#!/usr/bin/python3
#  coding: utf-8
#
#           showSetMaterialValueDDialog.py
#
#       材料物性値の値を表示、設定する。
#
#   24/04/30    新規作成
#      06/07    universalDialogsに変更
#      06/08    errDialog:parentを追加
#      06/09    dialogApp:parentを追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import sys
import os
import pyFistr
import universalDialogs

ls = "\n"

#-------------------
#  dialogApp class
#-------------------
class dialogApp:

    def __init__(self, title, message, items, cntVals, vals, units, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "showSetMaterialValueDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(title)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.message = message
        self.items = items
        self.cntVals = cntVals
        self.vals = vals
        self.units = units
        self.initialize()
        self.newVals = []

    #  show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()


    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        self.label_cont = self.builder.get_object("label_cont")
        label_item0 = self.builder.get_object("label_item0")
        label_item1 = self.builder.get_object("label_item1")
        label_item2 = self.builder.get_object("label_item2")
        label_item3 = self.builder.get_object("label_item3")
        label_item4 = self.builder.get_object("label_item4")
        label_cnt0 = self.builder.get_object("label_cnt0")
        label_cnt1 = self.builder.get_object("label_cnt1")
        label_cnt2 = self.builder.get_object("label_cnt2")
        label_cnt3 = self.builder.get_object("label_cnt3")
        label_cnt4 = self.builder.get_object("label_cnt4")
        label_val0 = self.builder.get_object("label_val0")
        entry_val1 = self.builder.get_object("entry_val1")
        entry_val2 = self.builder.get_object("entry_val2")
        entry_val3 = self.builder.get_object("entry_val3")
        entry_val4 = self.builder.get_object("entry_val4")
        label_unit0 = self.builder.get_object("label_unit0")
        label_unit1 = self.builder.get_object("label_unit1")
        label_unit2 = self.builder.get_object("label_unit2")
        label_unit3 = self.builder.get_object("label_unit3")
        label_unit4 = self.builder.get_object("label_unit4")
        self.button_cancel = self.builder.get_object("button_cancel")
        self.labelItems = [label_item0, label_item1, label_item2, label_item3, label_item4]
        self.labelCntVals = [label_cnt0, label_cnt1, label_cnt2, label_cnt3, label_cnt4]
        self.labelVals = [label_val0, entry_val1, entry_val2, entry_val3, entry_val4]
        self.labelUnits = [label_unit0, label_unit1, label_unit2, label_unit3, label_unit4]
        self.button_cancel.get_child().set_text(_("キャンセル"))

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化"""
        self.label_cont.set_text(self.message)
        for i in range(5):
            if i < len(self.items):
                self.labelItems[i].set_text(self.items[i])
                self.labelCntVals[i].set_text(self.cntVals[i])
                self.labelVals[i].set_text(self.vals[i])
                self.labelUnits[i].set_text(self.units[i])
            else:
                self.labelItems[i].set_text("")
                self.labelCntVals[i].set_text("")
                self.labelVals[i].set_text("")
                self.labelUnits[i].set_text("")
                #隠す
                self.labelItems[i].hide()
                self.labelCntVals[i].hide()
                self.labelVals[i].hide()
                self.labelUnits[i].hide()

    #
    #  getNewVals
    #-------------
    def getNewVals(self):
        """ entry内の値を取得する"""
        vals = []
        for i in range(1, len(self.items)):
            val = self.labelVals[i].get_text()
            stat, val = self.checkNum(val)
            if stat == "OK":
                vals.append(val)
            else:
                title = _("エラー")
                mess = _("数値以外が入力されています。")
                self.errDialog(title, mess, parent=self.dialog)
                break
        return stat, vals
    
    #
    #  checkNum
    #------------
    def checkNum(self, val):
        """ valの内容を確認。"""
        val = pyFistr.deleteSp(val)
        if val == "-" or val == "":
            return "OK", ""
        try:
            stat = "OK"
            a = float(val)
        except:
            stat = "NG"
        return stat, val
    
    def errDialog(self, title, message, parent=None):
        dialog = universalDialogs.errDialog(title, message, parent)
        dialog.show()


#-----------------------------
#  showSetMaterialValue class
#-----------------------------
class showSetMaterialValue:

    def __init__(self, title, mess, itemNames, cntVals, dbVals, units, funcName, funcArgs, parent=None):
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(title, mess, itemNames, cntVals, dbVals, units, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        stat, newVals = self.dialog.getNewVals()
        if stat == "OK":
            self.close()
            itemNames, matName, path, item = self.funcArgs
            self.funcName(newVals, itemNames, matName, path, item)
        