#!/usr/bin/python3
#  coding: utf-8
#
#           showMaterialValueDDialog.py
#
#       材料物性値の値を表示する。
#
#   24/03/24    新規作成
#      05/26    showMaterialValue:新規クラスを追加
#      06/09    dialogApp:parentを追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import sys
import os

ls = "\n"

#-------------------
#  dialogApp class
#-------------------
class dialogApp:

    def __init__(self, title, message, items, cntVals, vals, units, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "showMaterialValueDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(title)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.message = message
        self.items = items
        self.cntVals = cntVals
        self.vals = vals
        self.units = units
        self.initialize()

    #  show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.button_ok = self.builder.get_object("button_ok")
        self.label_cont = self.builder.get_object("label_cont")
        label_item0 = self.builder.get_object("label_item0")
        label_item1 = self.builder.get_object("label_item1")
        label_item2 = self.builder.get_object("label_item2")
        label_item3 = self.builder.get_object("label_item3")
        label_item4 = self.builder.get_object("label_item4")
        label_cnt0 = self.builder.get_object("label_cnt0")
        label_cnt1 = self.builder.get_object("label_cnt1")
        label_cnt2 = self.builder.get_object("label_cnt2")
        label_cnt3 = self.builder.get_object("label_cnt3")
        label_cnt4 = self.builder.get_object("label_cnt4")
        label_val0 = self.builder.get_object("label_val0")
        label_val1 = self.builder.get_object("label_val1")
        label_val2 = self.builder.get_object("label_val2")
        label_val3 = self.builder.get_object("label_val3")
        label_val4 = self.builder.get_object("label_val4")
        label_unit0 = self.builder.get_object("label_unit0")
        label_unit1 = self.builder.get_object("label_unit1")
        label_unit2 = self.builder.get_object("label_unit2")
        label_unit3 = self.builder.get_object("label_unit3")
        label_unit4 = self.builder.get_object("label_unit4")
        self.labelItems = [label_item0, label_item1, label_item2, label_item3, label_item4]
        self.labelCntVals = [label_cnt0, label_cnt1, label_cnt2, label_cnt3, label_cnt4]
        self.labelVals = [label_val0, label_val1, label_val2, label_val3, label_val4]
        self.labelUnits = [label_unit0, label_unit1, label_unit2, label_unit3, label_unit4]

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化"""
        self.label_cont.set_text(self.message)
        for i in range(5):
            if i < len(self.items):
                self.labelItems[i].set_text(self.items[i])
                self.labelCntVals[i].set_text(" " + self.cntVals[i])
                self.labelVals[i].set_text("  " + self.vals[i])
                self.labelUnits[i].set_text(" " + self.units[i])
            else:
                self.labelItems[i].set_text("")
                self.labelCntVals[i].set_text("")
                self.labelVals[i].set_text("")
                self.labelUnits[i].set_text("")

#--------------------------
#  showMaterialValue class 
#--------------------------
class showMaterialValue:

    def __init__(self, title, mess, itemNames, cntVals, dbVals, units, parent=None):
        self.dialog = dialogApp(title, mess, itemNames, cntVals, dbVals, units, parent)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onOk(self, event):
        self.close()
