#!/usr/bin/python3
#  coding: utf-8
#
#           showCreatingMeshDialog.py
#
#       メッシュ作成中を表示するdialog。
#
#   25/02/22    新規作成
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import os, sys


#-------------
#  dialogApp 
#-------------
class dialogApp:

    def __init__(self, funcHalt, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "showCreatingMeshDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.funcHalt = funcHalt
        self.setGtkObject()


    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        """ gtkObjectを定義する"""
        self.label_showConts = self.builder.get_object("label_showConts")
        self.button_halt = self.builder.get_object("button_halt")
        mess = _("meshを作成中...") + "\n"
        mess += _("  中断する場合は、「中断」ボタンをクリックしてください...")
        self.label_showConts.set_text(mess)

    #
    #  show
    def show(self):
        self.dialog.show()

    #
    #  close
    def close(self, *args):
        self.dialog.destroy()

    #
    #  onProcHalt
    def onProcHalt(self, event):
        if len(self.funcHalt) > 0:
            funcName = self.funcHalt[0]
            funcArgs = self.funcHalt[1:]
            funcName(*funcArgs)
        self.close()

