#!/usr/bin/python3
#  coding:  utf-8
#
#           selectMaterialDataCntDbDDialog.py
#
#       cntファイルと材料DB内の物性値の値が異なっている時
#       どちらのdataを使うか選択する。
#
#   24/03/24    新規作成
#      05/27    selectMaterialDataCntDb:新規classを追加
#      06/09    dialogApp:parentえお追加
#      09/22    非線形データ表示用labelを追加
#      09/27    initialize:cancelBtnの動作をdialogに追記
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import sys
import os

ls = "\n"

#-------------------
#  dialogApp class
#-------------------
class dialogApp:

    def __init__(self, egrp, matName, items, cntVals, dbVals, units, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "selectMaterialDataCntDbDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("使用する材料物性値の選択"))
        self.builder.connect_signals(self)
        #self.setGtkObject()
        self.egrp = egrp
        self.matName = matName
        self.items = items
        self.cntVals = cntVals
        self.dbVals = dbVals
        self.units = units
        self.selData = "cnt"
        self.setGtkObject()
        self.initialize()

    #  show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        self.label_subTitle = self.builder.get_object("label_subTitle")
        self.label_cont = self.builder.get_object("label_cont")
        item0 = self.builder.get_object("label_item0")
        item1 = self.builder.get_object("label_item1")
        item2 = self.builder.get_object("label_item2")
        item3 = self.builder.get_object("label_item3")
        item4 = self.builder.get_object("label_item4")
        cnt0 = self.builder.get_object("label_cnt0")
        cnt1 = self.builder.get_object("label_cnt1")
        cnt2 = self.builder.get_object("label_cnt2")
        cnt3 = self.builder.get_object("label_cnt3")
        cnt4 = self.builder.get_object("label_cnt4")
        db0 = self.builder.get_object("label_db0")
        db1 = self.builder.get_object("label_db1")
        db2 = self.builder.get_object("label_db2")
        db3 = self.builder.get_object("label_db3")
        db4 = self.builder.get_object("label_db4")
        unit0 = self.builder.get_object("label_unit0")
        unit1 = self.builder.get_object("label_unit1")
        unit2 = self.builder.get_object("label_unit2")
        unit3 = self.builder.get_object("label_unit3")
        unit4 = self.builder.get_object("label_unit4")

        item10 = self.builder.get_object("label_item10")
        item11 = self.builder.get_object("label_item11")
        item12 = self.builder.get_object("label_item12")
        item13 = self.builder.get_object("label_item13")
        cnt10 = self.builder.get_object("label_cnt10")
        cnt11 = self.builder.get_object("label_cnt11")
        cnt12 = self.builder.get_object("label_cnt12")
        cnt13 = self.builder.get_object("label_cnt13")
        db10 = self.builder.get_object("label_db10")
        db11 = self.builder.get_object("label_db11")
        db12 = self.builder.get_object("label_db12")
        db13 = self.builder.get_object("label_db13")
        unit10 = self.builder.get_object("label_unit10")
        unit11 = self.builder.get_object("label_unit11")
        unit12 = self.builder.get_object("label_unit12")
        unit13 = self.builder.get_object("label_unit13")

        self.labelItems = [item0, item1, item2, item3, item4, item10, item11, item12, item13]
        self.labelCntVals = [cnt0, cnt1, cnt2, cnt3, cnt4, cnt10, cnt11, cnt12, cnt13]
        self.labelDbVals = [db0, db1, db2, db3, db4, db10, db11, db12, db13]
        self.labelUnits = [unit0, unit1, unit2, unit3, unit4, unit10, unit11, unit12, unit13]
        self.label_selCntDb = self.builder.get_object("label_selCntDb")
        self.radio_cnt = self.builder.get_object("radioBtn_cnt")
        self.radio_db = self.builder.get_object("radioBtn_db")

        self.label_cancel = self.builder.get_object("label_cancel")
        if self.items[5] == "":
            #非線形分を隠す
            item10.hide(); cnt10.hide(); db10.hide(); unit10.hide()
            item11.hide(); cnt11.hide(); db11.hide(); unit11.hide()
            item12.hide(); cnt12.hide(); db12.hide(); unit12.hide()
            item13.hide(); cnt13.hide(); db13.hide(); unit13.hide()

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化"""
        subTitle = "egrp:" + self.egrp + "  " + _("材料名:") + self.matName
        self.label_subTitle.set_text(subTitle)
        mess  = _("材料の物性値がcntファイルと材料DBで異なっています。") + ls
        mess += _("使用する材料物性値の値を選択してください。")
        self.label_cont.set_text(mess)
        for i in range(len(self.labelItems)):
            if i < len(self.items):
                self.labelItems[i].set_text(self.items[i])
                self.labelCntVals[i].set_text("  " + self.cntVals[i])
                self.labelDbVals[i].set_text("  " + self.dbVals[i])
                self.labelUnits[i].set_text(" " + self.units[i])
            else:
                self.labelItems[i].set_text("")
                self.labelCntVals[i].set_text("")
                self.labelDbVals[i].set_text("")
                self.labelUnits[i].set_text("")
        self.label_selCntDb.set_text(_("材料物性値の選択"))
        self.radio_cnt.get_child().set_text(_("cntを使う (材料DB内のdataがcntの値に書き変わる）"))
        self.radio_db.get_child().set_text(_("DBを使う (cntのdataが材料DBの値に書き変わる）"))
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))
        self.label_cancel.set_text(_("「キャンセル」は、何もせずに戻る。"))

    #
    #  changeItem
    #-------------
    def changeItem(self):
        """ radioBtnを変更した時のevent"""
        if self.radio_cnt.get_active() == True:
            self.selData = "cnt"
        elif self.radio_db.get_active() == True:
            self.selData = "db"
        
#--------------------------------
#  selectMaterialDataCntDb class
#--------------------------------
class selectMaterialDataCntDb:

    def __init__(self, egrp, matName, itemNames, cntVals, dbVals, units, funcName, funcArgs, parent=None):
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(egrp, matName, itemNames, cntVals, dbVals, units, parent)
        self.dialog.radio_cnt.connect("toggled", self.onChangeItem)
        self.dialog.radio_db.connect("toggled", self.onChangeItem)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onChangeItem(self, event):
        self.dialog.changeItem()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        self.dialog.changeItem()
        selData = self.dialog.selData
        self.close()
        [matName, path, item] = self.funcArgs
        self.funcName(selData, matName, path, item)

if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext
