#!/usr/bin/python3
# coding: utf-8
#
#       mountServerDDialog.py
#
#       sshfsコマンドでマウントするサーバを選択する。
#
#   17/06/20    新規作成
#      06/30    textBoxを追加
#   19/10/31    GTK+3, python3用に大幅修正
#   20/04/22    多言語化対応
#   22/10/26    「from matplotlib.cbook import ls_mapper」を削除
#   24/05/25    mountServer:クラスを新規追加
#      06/09    dialogApp:parentを追加
#   25/06/13    第1行目/user/を/usr/に修正
# 

import gi
#from matplotlib.cbook import ls_mapper
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
import os, sys

try:
    import pyFistr
except:
    import python.pyFistr as pyFistr

#import locale
localeDir = os.getenv("LOCALE_DIR")
#localeDir = os.getenv("easyIstrPath") + "/data/locale"
#locale.bindtextdomain("easyistr", localeDir)

import logFileCreater
logFileCreater.log()
 

#-------------------
#  dialogApp class
#-------------------
class dialogApp:
    """ sshfsコマンドでマウントするサーバを選択する。
    
    Attribute:
        serverNames (list(str)) :マウントできるserver名
    Returns:
        serverName (str)        :選択したserver名 or 「""」"""
    def __init__(self, serverNames, parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "mountServerDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.serverNames = serverNames
        self.selServer = serverNames[0]
        self.stat = "CANCEL"
        #serverのデータを取得
        server = pyFistr.server(self.selServer)
        self.sshfsDict = server.sshfsDict
        self.sshDict = server.sshDict
        #comboにデータセット
        self.setDataToCombo()
        #entryにデータセット
        self.setDataToEntry()
        #textViewにデータセット
        self.setDataToTextView()

    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        self.combo_server = self.builder.get_object("combo_server")
        self.entry_hostName = self.builder.get_object("entry_hostName")
        self.entry_hostDir = self.builder.get_object("entry_hostDir")
        self.textView_setEnv = self.builder.get_object("textView_setEnviron")
        #文字の設定
        self.dialog.set_title(_("serverのマウント"))
        self.builder.get_object("label_title").set_label(_("serverのマウント"))
        mess  = _("sshfsコマンドでマウントするサーバを選択する。") + "\n"
        mess += _("各textBoxの内容を編集すると、編集した内容でマウントする。")
        self.builder.get_object("label_mountConts").set_label(mess)
        self.builder.get_object("label_selectServer").set_label(_("serverの選択"))
        self.builder.get_object("label_serverConnect").set_label(_("server接続の内容"))
        self.builder.get_object("label_hostName").set_label(_("HostName:  ~/.ssh/configで定義しているHost"))
        self.builder.get_object("label_hostDir").set_label(_("HostDir:  マウントするHost側のDir"))
        self.builder.get_object("label_setEnv").set_label(_("setEnviron:  login後の環境設定"))
        self.builder.get_object("button_cancel").set_label(_("キャンセル"))
        self.builder.get_object("button_ok").set_label("OK")

    #  show
    def show(self):
        """ dialogの表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        self.dialog.destroy()
    
    #
    #  setDataToCombo
    #  --------------
    def setDataToCombo(self):
        self.combo_server.clear()
        listModel = Gtk.ListStore(str)
        for name in self.serverNames:
            listModel.append([name])
        cell = Gtk.CellRendererText()
        self.combo_server.pack_start(cell, True)
        self.combo_server.add_attribute(cell, "text", 0)
        self.combo_server.set_model(listModel)
        self.combo_server.set_entry_text_column(0)
        self.combo_server.set_active(0)

    #
    #  setDataToEntry
    #  --------------
    def setDataToEntry(self):
        hostName = self.sshfsDict["hostName"]
        self.entry_hostName.set_text(hostName)
        hostDir = self.sshfsDict["hostDir"]
        self.entry_hostDir.set_text(hostDir)

    #
    #  setDataToTextView
    #  -----------------
    def setDataToTextView(self):
        setEnv = self.sshfsDict["setEnviron"]
        buffer = self.textView_setEnv.get_buffer()
        buffer.set_text(setEnv)

    #
    #  changeServer
    #  ------------
    def changeServer(self):
        iter = self.combo_server.get_active_iter()
        if iter == None:
            return
        listModel = self.combo_server.get_model()
        self.selServer = listModel.get_value(iter, 0)
        server = pyFistr.server(self.selServer)
        self.sshfsDict = server.sshfsDict
        self.sshdict = server.sshDict
        self.setDataToEntry()
        self.setDataToTextView()

    #
    #  setServerContData
    #  -----------------
    def setServerContData(self):
        entry = self.combo_server.get_child()
        self.selServer = entry.get_text()
        hostName = self.entry_hostName.get_text()
        hostDir = self.entry_hostDir.get_text()
        buffer = self.textView_setEnv.get_buffer()
        st = buffer.get_start_iter()
        ed = buffer.get_end_iter()
        setEnv = buffer.get_text(st, ed, True)
        self.sshfsDict["hostName"] = hostName
        self.sshfsDict["hostDir"] = hostDir
        self.sshfsDict["setEnviron"] = setEnv
        server = pyFistr.server(self.selServer)
        server.sshfsDict = self.sshfsDict
        server.writeSshfsData()

#----------------------------------
#  mountServer class
#----------------------------------
class mountServer:
    """ serverを取得し、マウントするdialog。
    
    Args:
        serverNames (list(str)):    mountできるservers
        funcName (object):          選択したserverをマウントする関数名
        funcArgs (list):            マウントする関数の引数"""

    def __init__(self, serverNames, funcName, funcArgs, parent=None):
        self.serverNames = serverNames
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(serverNames, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)
        self.dialog.combo_server.connect("changed", self.onChangeServer)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onChangeServer(self, event):
        self.dialog.changeServer()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        self.dialog.setServerContData()
        selServer = self.dialog.selServer
        self.close()
        mountDir, mountedServers = self.funcArgs
        self.funcName(selServer, mountDir, mountedServers)

