#!/usr/bin/python3
#  coding: utf-8
#
#   getVtkShowContentsDDialog.py
#
#       vtk表示させる内容を取得する。
#       --undefine-- or allEgrp
#
#   21/01/14    新規作成
#   22/03/15    国際化
#      03/22    国際化（文字をpython側でセット）
#   24/05/23    getVtkShowContent:新規追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import os
import sys

#import locale
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

#----------------------
#  dialogApp class
#----------------------
class dialogApp:

    def __init__(self, setRadio, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "getVtkShowContentsDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("vtk表示内容を選択"))
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.setRadio = setRadio        #radioButtonの初期設定
        self.radioStat = setRadio       #radioButtonの状態
        self.stat = "CANCEL"
        self.initialize()

    #  show
    def show(self):
        """ dialogを表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        """ GtkObjectの定義"""
        self.radio_undefine = self.builder.get_object("radio_undefine")
        self.radio_egrps = self.builder.get_object("radio_egrps")
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        #文字をセット
        mess = _("EGRP名が定義されていない!ELEMENTが存在します。\nvtk表示する内容を選択してください。")
        self.builder.get_object("label_exp").set_text(mess)
        self.builder.get_object("label_showVtk").set_text(_("vtk表示内容"))
        self.radio_undefine.get_child().set_text(_("--undefine-- （未定義の!ELEMENTを表示する）"))
        self.radio_egrps.get_child().set_text(_("全てのEGRP （定義済みの全EGRPを表示する）"))
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化。
        radioButtonの設定"""
        if self.setRadio == "undefine":
            self.radio_undefine.set_active(True)
        else:
            self.radio_egrps.set_active(True)

    #
    #  getRadioStat
    #---------------
    def getRadioStat(self):
        """ radioButtonの状態を取得して返す"""
        if self.radio_undefine.get_active():
            radioStat = "undefine"
        else:
            radioStat = "egrps"
        return radioStat

#-----------------------------------------
#  getVtkShowContents class
#-----------------------------------------
class getVtkShowContents:
    """ vtk表示の為のelmGrpを取得するdialogを表示、vtk表示する。

    Args:
        eName (str):    表示内容（elmGrpのみ or --undefine--のみ）
        funcName (object):  vtk表示させる関数
    """

    def __init__(self, eName, funcName, parent=None):
        self.eName = eName
        self.funcName = funcName
        self.dialog = dialogApp(eName, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.dialog.show()

    def close(self):
        self.dialog.dialog.close()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        radioStat = self.dialog.getRadioStat()
        self.close()
        self.funcName(radioStat)


if __name__ == "__main__":
    dialog = dialogApp("egrps")
    stat = dialog.show()
