#!/usr/bin/python3
#
#           createNewDimensionDDialog.py
#
#       任意のdimensionを作成する
#
#   23/12/23    新規作成
#   24/05/26    createNewDimension:クラスを新規追加
#      06/09    parentを追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import os
import GtkParts
import convDimensionMatCsv


#-------------------
#  dialogApp class
#-------------------
class dialogApp:

    def __init__(self, currDim, parent=None):
        self.builder = Gtk.Builder()
        #self.builder.set_translation_domain("easyistr")
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "createNewDimensionDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("新しい単位系の作成"))
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.dimension = ""
        self.currDim = currDim
        self.Initialize()
        
    #  show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        """ objectの定義"""
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        combo_mass = self.builder.get_object("combo_mass")
        self.combo_mass = GtkParts.comboBox(combo_mass)
        combo_len = self.builder.get_object("combo_len")
        self.combo_len = GtkParts.comboBox(combo_len)
        combo_time = self.builder.get_object("combo_time")
        self.combo_time = GtkParts.comboBox(combo_time)
        self.builder.get_object("label_mess").set_text(_("質量、長さ、時間の単位を選択"))
        self.builder.get_object("label_select").set_text(_("項目を選択"))
        self.builder.get_object("label_mass").set_text(_("質量"))
        self.builder.get_object("label_len").set_text(_("長さ"))
        self.builder.get_object("label_time").set_text(_("時間"))
        self.builder.get_object("label_cont").set_text(_("選択した項目の単位系を作成します。"))

    #
    #  Initialize
    #--------------
    def Initialize(self):
        #各単位を取得
        mDict, lDict, tDict = convDimensionMatCsv.mlsDicts()
        mItems = mDict.keys()
        lItems = lDict.keys()
        tItems = tDict.keys()
        #comboにitemをセット
        self.combo_mass.setItems(mItems)
        self.combo_len.setItems(lItems)
        self.combo_time.setItems(tItems)
        #選択表示
        dims = self.currDim.split("_")
        self.combo_mass.selectItem(dims[0])
        self.combo_len.selectItem(dims[1])
        self.combo_time.selectItem(dims[2])

    #
    #  getSelectDimension
    #----------------------
    def getSelectDimension(self):
        """ 選択している項目を取得する"""
        m = self.combo_mass.getSelectedItem()
        l = self.combo_len.getSelectedItem()
        t = self.combo_time.getSelectedItem()
        selDim = "_".join([m, l, t])
        return selDim
    
#----------------------------------------
#  createnewDimension class
#----------------------------------------
class createNewDimension:
    """ 任意のdimensionを選択するdialogの表示、任意dimaension設定。
    
    Args:
        dim (str):  現在の単位系
        funcName (object):  選択した単位系に変更する処理関数"""

    def __init__(self, dim, funcName, funcArgs, parent=None):
        self.dim = dim
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(dim, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onCancel(self, event):
        selDim = ""
        self.close()
        path, item = self.funcArgs
        self.funcName(selDim, self.dim, path, item)

    def onOk(self, event):
        selDim = self.dialog.getSelectDimension()   #選択したdim
        self.close()
        path, item = self.funcArgs
        self.funcName(selDim, self.dim, path, item)
