#!/usr/bin/python3
# coding: utf-8
#
#       convertInpResToVtuDDialog.py
#
#       calculixの計算結果をvtu形式に変換する
#
#   25/01/04    新規作成
#      01/10    refine
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys
import universalDialogs
import showContentsDDialog

localeDir = os.getenv("LOCALE_DIR")

ls = "\n"

#----------------------
#  getInpResName class
#----------------------
class getInpResName:
    """ calculixの計算結果をvtu形式に変換する"""

    def __init__(self, fileDir, funcOk=[], parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "convertInpResToVtuDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.dialog.set_title(_("calculix計算結果のvtu変換"))

        self.fileDir = fileDir
        self.funcOk = funcOk


    def setGtkObject(self):
        """ GUIのobject名を取得する。"""
        self.label_title = self.builder.get_object("label_title")
        self.label_conts = self.builder.get_object("label_conts") 
        self.label_convertMethod = self.builder.get_object("label_convertMethod")
        self.label_frdConts = self.builder.get_object("label_frdConts")
        self.label_inpConts = self.builder.get_object("label_inpConts")
        self.label_fileName = self.builder.get_object("label_fileName")
        self.entry_inpName = self.builder.get_object("entry_inpName")
        self.radio_frd = self.builder.get_object("radio_frd")
        self.radio_inpDat = self.builder.get_object("radio_inpDat")
        self.button_showFrdDetail = self.builder.get_object("button_showFrdDetail")
        self.button_showInpDetail = self.builder.get_object("button_showInpDetail")
        self.button_reference = self.builder.get_object("button_reference")
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_convert = self.builder.get_object("button_convert")

        self.label_title.set_text(_("Calculixの計算結果をvtu形式に変換"))
        mess = _("変換方法を選択し、参照ボタンでfileを選択して、変換を開始する。")
        self.label_conts.set_text(mess)
        self.label_convertMethod.set_text(_("vtu変換方法の選択"))
        self.label_frdConts.set_text(_("frd内のnode, element, 計算結果から変換する"))
        self.label_inpConts.set_text(_("inp内のnode, element, dat内の計算結果から変換する"))
        self.label_fileName.set_text(_("入力file名:"))
        self.radio_frd.get_child().set_text(_("frdからvtu変換 ---"))
        self.radio_inpDat.get_child().set_text(_("inp,datから変換 ---"))
        self.button_showFrdDetail.get_child().set_text(_("frd変換内容の詳細表示..."))
        self.button_showInpDetail.get_child().set_text(_("inp,dat変換内容の詳細表示..."))
        self.button_reference.get_child().set_text(_("参照..."))
        self.button_cancel.get_child().set_text(_("キャンセル"))
        self.button_convert.get_child().set_text(_("変換開始"))


    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.close()

    def onCancel(self, event):
        self.close()

    def onShowConvertFromFrd(self, event):
        self.showFrdContents()

    def onShowConvertFromInpDat(self, event):
        self.showInpDatContents()

    def onOk(self, event):
        inpFile = self.entry_inpName.get_text()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            extName = "inp"
            if self.radio_frd.get_active() == True:
                extName = "frd"
            funcArgs = [(inpFile, extName)] + self.funcOk[1:]
            GLib.timeout_add(100, funcName, *funcArgs)

    def onReferInpFile(self, event):
        title = _("inpファイルを取得")
        fileDir = self.fileDir
        funcOk = [self.setInpFile]
        funcCancel = []
        selName = ""
        if self.radio_frd.get_active() == True:
            filterSets = [[_(u"frdファイル  (*.frd)"), "*.frd"], [_(u"全てのファイル"), "*"]]
        else:
            filterSets = [[_(u"inpファイル  (*.inp)"), "*.inp"], [_(u"全てのファイル"), "*"]]
        dialog = universalDialogs.openFileDialog(title, fileDir, funcOk, funcCancel, self.dialog, selName, filterSets)
        dialog.show()

    def setInpFile(self, fileName):
        relPath = os.path.relpath(fileName, self.fileDir)
        self.entry_inpName.set_text(relPath)

    #
    #  showInpDatContents
    #---------------------
    def showInpDatContents(self):
        """ inpDat変換内容の詳細を表示する"""
        #実行file名を取得
        fileName = os.getenv("easyIstrPath") + os.sep + "bin" + os.sep + "createAbaVtu.py"
        #変換内容を実行fileから取得
        f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        contLines = []
        for i in range(2, len(lines), 1):
            line = lines[i]
            if line[:len("#--------")] == "#--------":
                break
            contLines += [line]
        conts = "".join(contLines)
        dialog = showContentsDDialog.showMessage(conts, parent=self.dialog)
        dialog.show()

    #
    #  showFrdContents
    #---------------------
    def showFrdContents(self):
        """ frd変換内容の詳細を表示する"""
        #実行file名を取得
        fileName = os.getenv("easyIstrPath") + os.sep + "bin" + os.sep + "frd2vtu.py"
        #変換内容を実行fileから取得
        f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        contLines = []
        for i in range(2, len(lines), 1):
            line = lines[i]
            if line[:len("#--------")] == "#--------":
                break
            contLines += [line]
        conts = "".join(contLines)
        dialog = showContentsDDialog.showMessage(conts, parent=self.dialog)
        dialog.show()


if __name__ == "__main__":
    import gettext
    #gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext
    dialog = getInpResName()
    dialog.show()
    Gtk.main()



