#!/usr/bin/python3  
# -*- coding: utf-8 -*-    
#
#       easyIstr_main2.py
#
#   15/04/16    新規作成 ver1.0
#      04/26    塑性解析を追加 ver1.1
#      04/28    並列処理追加   ver1.11
#      05/14    固有値解析追加、出力をvtk形式に変更　ver1.12
#      05/18    周波数応答追加　ver1.13
#      05/21    表面要素取得fistr2vtk.pyに対応
#      05/25    notebookのtabを非表示に設定
#      05/26    警告が多数発生するため元に戻す（tabを表示）
#               stepで計算する境界条件の設定を修正（バグ取り）
#      05/27    postの表記を修正（inp→vtk）
#
#   15/06/07    wxGladeからglade（GTK）に変更 ver2.00
#      06/09    熱伝導を追加 ver2.10
#      06/11    amplitudeを追加
#      06/14    境界条件として、VELOCITY、ACCELERATIONを追加
#               AMPの候補として、STEPを追加　ver2.11
#      06/15    境界条件TEMPERATUREに熱解析結果が使える様に修正
#      06/16    restartが可能になる様に設定
#      06/17    境界条件のfont色を修正 ver2.12
#      06/18    材料定義のバグ修正（同じ材料を定義した時ダブって定義される）
#      06/19    熱解析（動解析）にcheckBtnを追加、!INITIALを追加
#      06/20    solution設定画面に入出力ファイルを表示
#      07/14    バグ修正（anarysis→analysisに修正）
#      08/26    線形solverMUMPS等を追加
#      08/31    $easyIstrUserPath追加の為の修正
#      09/01    windowsに対応させる為、os.sep, os.path.normpathに修正
#      09/02    createPlasticSsDataFile:strain→valueに変更
#               "\n"→os.linesepに修正
#               initialize:materialDBとcurrDirのdirを修正 ver2.13
#      10/13    copyUseCntFile:useCntFileの保存を追加
#      10/18    windows対応用でos.system()部を見直し
#      10/19    osCopyFileを追加。
#      10/20    os毎に異なるappの定義をdata/usingAppファイルで定義 ver2.14
#      10/22    バグ修正。update時、usingAppがcopyされない
#               バグ修正。SPRINGの境界条件が、ステップ解析の現れない。
#               材料の硬化則でmultiLinearを最初に設定
#               バグ修正。周波数応答でsample数が修正できない
#               addDefaultFloadNames:FLOADのdefaultのLOAD_CASEを1:実部に変更
#      10/27    周波数応答で計算終了後、応答結果のcsvファイルを作成
#               動解析のdefaultの運動方程式を「陽解法」に変更
#               os.CopyFile:バグ修正
#               writeFistrModelMsh,writeFistrModelCnt,writeHecmwCtrlDatを修正。
#                 行末を揃える。
#      10/30    loadHcmwPartCtrlDat:fileのコピー方法を修正（読み込み後、書き込み）
#      11/11    材料物性値のページに「DB開く」ボタンを追加
#      11/19    材料物性値_subに「物性値の確認」ボタンを追加
#      12/05    checkSetUserPathFiles:currDir,matDirが存在しない場合、defaultのdir
#               に修正を追加。
#      12/10    solve画面を変更。
#               Fistr実行ボタンクリックで、制御ファイルへの書き込みを無くし、「設定」
#               ボタンを追加
#      12/14    moveItemToListBox:multipleSelectionに対応（複数選択が可能）
#      12/17    主応力にvectorを追加。setListDataInListBox:namesをsortして表示。
#      12/18    主ひずみ、misesひずみを追加
#               項目追加用のdialog「addOutputItemsDialog.py」を追加。
#      12/24    changeMeshScale:終了時にdialogを表示
#               CLOADに合計荷重を追加
#      12/25    行末コードlsを修正。!CLOADの行にvalue=の項目を追加（端数が生じる為）。
#      12/28    writeCloadContInCnt:node番号で設定する時にも対応できる様修正。
#               CLOADに等分布荷重が設定できるように修正。
#   16/01/04    等分布荷重の設定方法を修正
#      01/06    追加項目にtresca応力、ひずみを追加
#      01/08    BOUNDARY、CLOADについて、省略形でも読み込み可能に修正
#      01/12    abaqusinp2fistrcnt.pyをメッシュ変換に引き続き実行する様に修正。
#      01/16    「!INITIAL CONDITION」の挿入場所を修正 ver2.15
#               「!TEMPERATURE」、「!DLOAD,GRAV」に各nodeGroupの設定が可能に修正
#      01/31    applyBCGroup:TEMPERATUREでnameを全て削除した時のエラー発生を修正
#      02/04    editPlasticSsData:材料名を入力せずに「ss_data作成」場合、エラー発生
#               するので、これを修正。
#      02/13    getDataList:データの最後が空白文字の場合、エラーが発生したので修正
#      03/27    シェル要素（731、732、741）を追加 ver 2.20
#      03/28    BOUNDARYに回転を追加。材料設定にshellの板厚を追加
#      04/05    runParaView:読み込むファイルを設定してparaViewを起動。
#      04/08    シェル要素（761、781）を追加
#      04/09    readSetMaterialType:textBoxを隠す時、値をクリア
#               isRotationElementType:追加。
#      04/14    beam(611)を追加
#      05/01    meshConvert:バグ修正（file名の取得方法を修正）
#      06/20    remakeSolidShellModel（混在モデル）の場合、EQUATIONを追加 ver 2.21
#      07/01    applyContact:contactAlgoのセットを修正（バグ）
#      08/12    runFrontIstr:windowsでの並列処理（mpiexec）を追加
#      08/17    runFrontIstr:実行時のlogファイルを出力する様に修正
#      08/19    runFrontIstr:Fistrを裏で起動するように修正（バグ修正）
#      09/10    FrontISTRのインストール先、paraviewの起動コマンドをusingAppに設定
#               ver 2.22
#      11/08    getSolutitionTypeFromCnt:デフォルトのsolutionTypeを設定
#      11/19    createMaterialDefine:!SECTIONの位置を限定せずに検索する様に修正
#      11/27    solid,shell,beam混在モデルに対応 ver 2.23
#      12/14    shell、beamにモーメント入力を追加 ver 2.24
#               writeCloadContDummyInCntを追加。
#               readBoundaryNgrpName:dummyNGRPの設定を追加
#      12/24    writeCloadContDummyInCnt.createAddCont:バグ修正
#      12/25    getNodeForceAtArea.py:バグ修正
#   17/01/03    applyCloadCont,applyBoundaryCont:dummyNgrpを「meshCont」から取得
#               setCload_sub,setBoundary_sub:回転の有無を「meshCont」から取得
#      01/09    makeIniTreeData:mat.sort()を追加。
#      04/09    setContact_sub:slave, masterの名前リストのsortを追加
#               deleteContactConditions:contactのlistBoxを複数選択可に変更
#               接触アルゴリズムの初期設定を「SLAGRANGE」に変更
#               STEPのmaxIterを「1000」に変更
#      05/19    applyContact:デフォルトのINTERACTIONを「SSLID」に変更
#      06/18    applyContact:デフォルトのINTERACTIONを「FSLID」に戻す。
#               setContact_sub, applyContactCont:GUI上にINTERACTIONの日本語追加
#      07/13    outputItems:出力項目に「梁要素NQM」を追加
#      08/22    plotStepMonitor:stepの実行状況を表示させるボタンを追加 ver 2.25
#               接触解析時のNPENALTY,TPENALTYを追加。
#      08/23    setUsingApplications:削除し、pyFistr側に移動
#      08/24    接触解析時のNPENALTY,TPENALTYを削除。
#               getContactContInCnt:factorの初期値を0.0→1.0e3に修正
#      08/29    applyContact:接触ペア作成時、ペア名をsortする様に修正
#      08/30    各「設定」ボタンにdialogを表示させる様に修正
#      09/11    getNoGroups:「dummy***」のgroup名を取得しないように修正
#               「設定」ボタンのクリック時、処理が終了するまで、設定中dialogを表示
#      09/12    settingDialog, plotStepMonitorのwindows対応。
#      09/16    getDataList:高速化の為、修正。deleteSpを無くし、errorTrapを追加
#      09/18    高速化の為、無駄な書き込みをなくす。（大規模メッシュ対応）
#      09/20    changeMeshScale:高速化の為、全てのmeshContの読み込み廃止。
#      09/23    高速化の為、meshDataをmshHeaderDataとして保存、処理する様に修正
#      09/28    switchUseResult:設定値のセット方法を修正
#      09/29    deleteContactPairNameInCntMsh:バグ修正。
#      10/01    getSavedData, saveIstrData, setIstrData, subInitialize:mesh変換
#               したfile名を保存し、起動時にtextBoxに表示するように修正。
#      10/07    writeFistrModelFile:バグ修正。（ssDataがcntファイルに書き込めない）
#      10/08    getNgrpNodeNos:バグ修正（dummyGrpupが読み込めない）
#      11/10    複数step解析を可能にした。 ver 2.30
#      11/11    setContactGroupToListBox:バグ修正（メッシュ変換後、接触を選択すると
#               エラー発生）
#      11/12    バグ修正。（mesh変換時、境界条件がクリアされない事を修正。）
#      11/30    plotStepMonitor:端末への出力量を減らす。
#      12/01    plotStepMonitor:端末への出力量をさらに減らす。
#      12/03    addContactPairNameInCntMsh:バグ修正。接触ペアgroup名定義でエラー発生。
#               addContactCondition:バグ修正。pair名追加時、連番にならない。
#      12/04    meshConvert:メッシュ変換後、直ぐに読み込むとエラー発生するので修正
#               checkReformCntFile:cntファイルのチェック修正を追加
#      12/18    getSavedData:workDirを削除した時、起動しない事があるので修正。
#      12/31    readVeloNgrpName,readDloadSgrpName,readVloadEgrpName,readGravValueFromCnt,
#               readSpringValueFromCont,readAccelNgrpName:バグ修正（step毎の内容が取得できず）
#               writeFloadContInCnt:バグ修正(step0以外に設定できず）
#   18/01/01    setStep_sub:sort方法変更
#      01/04        ↑　:バグ修正
#               applyContact:factorのdefault値を1e3→1e5に修正
#      01/31    addContactCondition:使用済みのcontact名を追加。（バグ修正）
#      02/02    「NGRPの修正」ボタンを追加（reformNgrpを追加）
#      02/20    getPlasticSsData:EXCELでss_dataを読むとエラーが発生したため修正 ver 2.31
#      03/29    reformNgrp:バグ修正
#      03/31    getBoundaryNodeGroupInCnt:バグ修正
#               getSolverContFromCnt:バグ修正
#      04/04    applyTemperatureCont:初期温度の設定方法修正（バグ）
#               readTemperatureValueFromCntMesh:初期温度の読み取りに変更（バグ）
#               「INITIAL」を境界条件のlistから、Treeの上位に移動 ver 2.40
#      06/08    gnome-terminalのオプション「-x」を「--」に修正。（警告が発生する為）
#      06/17    deleteOverlapNodesDDialog.py:group内全node削除される時エラー発生
#               するので修正（バグ） ver 2.41
#      06/24    selectWorkFolder:folder移動先に必要なfileが存在しない時、初期化を追加
#      07/16    abaqus2fistr.py:小文字のkeyword読み込みに対応
#      08/28    checkNumStr:物性値の読み込み時、指数表記の小数点有無チェックを追加
#      09/01    openWorkFolder:nautilusを裏で動かす様に修正。（ubuntu18.04対応）
#      11/03    fistr2vtk.py:resファイルの要素Noの読み込み方法修正（バグ）
#      11/17    ver 2.42 としてリリース
#      12/11    大規模解析用として大幅修正 ver 2.50
#      12/30    getAnalysisTypeInCnt:詳細な結果を戻すように修正
#               plotStepMonitor:非定常熱伝導解析でplotMonitorが起動する様に修正 ver 2.51
#
#   19/01/22    python3, Glade3用に大幅修正 ver 3.00
#               CFLUXの和名を修正、CFLUXに等分布設定を追加。
#      01/30    windows用に修正
#               currDirの表示追加、temp設定保存btn追加
#               windows上での「fistr1」実行時に、「commTee.py」を使用する様に変更。
#      02/05    plotStepMonitor.py, plotStepMonitorHeatDy.py
#               windows用に修正
#      02/22    main:checkTrueCurrDirを追加。
#               currDirTrueが存在しない場合、currDirを$HOMEに設定する為。
#      03/04    yesNoDialogを追加。
#      03/06    getParameterNumber:同名のEGRPをまとめる方法を修正
#               saveDataList:face数が実数で取得されていた為、修正
#      03/07    モジュールcopyFilesFromTempToCurrDirを作成し、これに伴いmain側を修正
#      03/08    setMaterialTypeToListBox:バグ修正（matModelが2重に表示されていた）
#      03/18    convertDataForParaview,getConvertComm:fistr2vtk.py実行時に「python3 -u」
#               のオプション付きで実行する様に修正。（realTimeで出力を取得するため）
#               checkSetIstrData:istrDataの読み直しを追加
#      03/20    getBndListFromDefine:バグ修正（VLOAD,CENT,GRAVがstep設定できないを修正）
#      03/21    GRPIDの再設定時、step内のGRPIDも修正する様に変更
#               moveItemToListBoxStep:box内の選択表示が狂っていたので修正。
#      03/28    createTempCaseFiles:currDirを引数に追加。currDirが存在しない状態では、
#               エラー発生して、起動できない為、修正
#      04/06    abaqus2fistr.py, unv2fistr.py:直接pythonScriptを起動していたので
#               「python3 <pythonScript>」形式に修正。
#               （windowsでメッシュ変換できないバグ発生。）
#      04/16    vsCodeでエラーチェックし、修正
#      04/20    remakeGrpidInStep:GRPIDの設定を再修正。（3/21修正時の再修正）
#      04/22    numSettingDialog,closeSettingDialog:subprocessが正常な状態（BrokenPipe
#               では無い状態）の時flushする様に修正。ver 3.03
#               showSettingDialog:settingDialogが起動していない場合は、0.1s waitする
#      05/01    getCurrDirFromTempFolder:tempFolder内にmeshContsファイルが存在しない
#               場合、エラーが発生し、easyIstrが起動しない状態に陥るのを修正。
#      06/24    resetCntMshFile:mshFileの保存をtempDirに限定する様に修正
#               meshConvert:tempCase作成時、shrinkしたmeshHeaderDataから作成する様に修正
#               matchControlCont:mshFileの保存をtempDirに限定する様に修正
#      08/27    deleteBndWithoutTypeNames:修正（バグ）
#      09/06    dirDialog:Gtk.Dialogの警告が発生するので、修正。
#      09/22    meshConvert:メッシュ変換後、initialConditionが反映されていなかった
#               ので修正。
#      09/23    windowSizeの保存を追加。treeのwindow幅を可変に修正
#   20/03/12    FrontISTR5対応として、AUTOINCに対応（ver 3.10)
#      03/19    バグ取り
#      04/13    readSetEachMaterialName:材料非選択時に空白を出力する様に修正
#               applyMaterial:バグ修正
#               copyUseCntFile:バグ修正（hecmw_ctrl.datも置き換える）
#      04/23    checkUserPathFolder:$easyIstrUserPathのfolderが無い場合、作成するを追加
#               bashShell中で行っていたものをpython側で取り込んだ。
#      06/10    dirIconの左エリアをdoubleClicして作業folderに設定できる様修正
#               これに伴い、tooltipも修正
#      06/24    changeMeshScale:scale変更後、cnt内容が戻ってしまうので、scale変更前に
#               cntファイルの保存を追加
#      06/26    button追加 ver 3.20
#      06/27    createVtkDataFromFile:同じrendererを使い回す様に修正
#               reloadする度に新規に定義するとaxisが動かなくなる。
#               getMeshParameter:tempFolderがクリアされた状態で、matDefineを取得する時、
#               errorが発生し、起動しない事があるので、tryで取得する様に修正。
#      06/28    reloadDir:この時にvtk再表示させていたが、これを削除
#               isGrpNameInVtkFiles:vtkFilesが最新かどうかcheckする方法を修正
#      06/29    viewFromX,viewFromY,viewFromZ:各方向のcamera位置を修正
#               中心位置-camera位置までの距離は、各方向とも同じ距離。
#               plotStepMonitor:windowsについて、batファイルを作成せずに実行する様に修正
#               ctrl+Cで直ぐに停止できない為。
#      06/30    path名表記の"/"をos.sepに修正
#               fileDialog:buttonの設定をadd_buttonsに変更（warning出る為）
#      07/02    Fistr-4.6が使える様に修正。
#      07/03    reformNgrp:node削除後、vtkを再表示を追加
#      07/06    viewFromX, viewFromY, viewFromZ:camera位置を修正
#      07/07    viewerに左右反転、回転のボタンを追加
#      07/08    initialize:usingAppを辞書形式の読み込みに変更
#               menuBar, toolBarにrunCad, runMesherを追加。
#      07/10    addTempMaterialInMsh:SECTION行にMATERIAL=noDataを追加（バグ）
#      07/11    createVtkDataFromFile:1次要素はOKだが、2次要素のVTK表示ができず
#               修正。
#      07/15    resizeVtkBox, vtkRender:削除。
#               vtk画面サイズ変更のeventはGtkVtkRenderWindowInteractor.py内で処理。
#      08/04    addSelectedActors:pointSizeが小さい為、sizeを5→8に変更。
#      08/10    editUsingApp:frontIstrFolderを書き換えた時、再起動しないとPATHが
#               反映されなかったので、修正。
#      08/13    setCurrDirInLabel:最大の文字数80→65に変更。
#      08/16    nodesBondingDDialog.pyを追加
#               節点結合（部品の結合）を追加。
#      08/19    treeDirにpopupMenuを追加。
#      08/20    changeCurrDir:workFolder移動した時、parallelのチェックを外す。
#               移動先がparallel設定の場合、実行時にエラーが発生する。
#      08/31    起動時にvtkのversionを表示。
#      09/08    要素Grpをoverlapして定義した場合、要素Grpを選択色に設定
#               すると、重ね書きした裏の要素色が見える事があるため、    
#               cell色（非選択、選択、事前選択）の設定をCellDataで設定し
#               各要素Grp中で同じfaceが存在する時には、そのface色を統一
#               する様に修正
#      09/20    threadManage:vtk表示でエラー発生時、起動しない事があるので
#               try文でエラー検出する様に修正。
#      09/23    changeWorkFolder:最後にtempCaseDateの修正を追加
#      09/27    選択面の表示方法を変更。surfaceのvtuファイルを読み込み表示
#               →elementのvtkファイル内からsurfaceデータを読み込み表示。
#               createSubActor:新たに追加
#      09/30    showAllElms, hideElmsボタンを追加。
#               createSubActor:vtk-8.2でactorが作成できなかった為、修正。
#               vtk-6.3.0ベースでsourceを書き換え。
#      10/09    選択したEGRP上にNGRP、SGRPを作成追加するページを追加。
#      10/10    setCreateGrp:「vtkFileを作り直す→vtkFileを修正する」に変更。
#               速度を優先する為。
#      10/11    setNewTreeData:self.treeStore.clear時にshowPageをmaskする。
#               treeStore.clear()の実行時に全てのpageにアクセスする為。
#      10/18    nodeGrp, surfaceGrp, elementGrpのrenameと削除を追加。
#      10/21    nodeGrp, surfaceGrp, elementGrpのrename時、同名のgrp名が存在
#               する場合、そのgrpに追加する様に修正
#      10/25    要素GrpのedgeのvtkFileを追加して、edgeを表示させる様に修正。
#               2次要素の場合、正しくedgeが表示されない為。
#      10/30    deleteElementGroup:!ELEMENTで定義したEGRPは、削除できない
#               様に修正。
#      10/31    setMeshFile:currDirの外のunvファイルがアクセスできる様に修正
#      11/02    meshConvertKeepSetting:新規追加
#               メッシュ変換時に設定保持できる様に修正。
#               clearAllBoundary:新規追加
#               全境界条件が削除できる様に修正。
#      11/05    NGRP, SGRPグループ作成方法を修正。
#      11/06    threadManage:windowsでは、vtkOutputWindowが出力されerror、
#               warningが出力されるので、vtkOutputWindowが出力されない様に
#               修正。（vtkObj.GlobalWarningDisplayOff()を追加）
#      11/12    setColorsToSurElmGrps:EGRP, SGRPの色（要素色とedge色）を
#               設定する方法を修正。
#      11/13    saveCreateSurfaceGrp,saveCreateNodeGrp:バグ修正。
#               実行前に、tempのmshファイルをcurrDirに保存を追加。
#      11/30    reloadDir:currDirとselDirを展開し、selDirを選択表示する様に修正
#               casePasteFolder:バグ修正（計算結果除くで貼り付けた時エラー
#               発生する場合がある。）
#      12/16    dirTreeの選択を複数選択が可能な様に修正。
#               （複数Dirのcopy、複数Dirの削除が可能）
#      12/17    dirTreeのfolderLinkが表示される様に修正。
#               （windowsのshortCutは、認識しない）
#      12/26    getFaceGrpsFromPickedCellId:バグ修正
#               cellId:0をpickした時を反応しなかった事を修正。
#               pickedCellのnodeが取得できないことがあるを修正。
#   21/01/04    nodesBond:nodeToFaceの結合を追加
#      01/07    showCreatedEgrp,setCreateGrp:elmGrpの作成を追加。
#      01/08    createVtkDataFromFile:vtk画面上に表示しているelmGrp名
#               を追加。（elmsTextActorを追加）
#               showAllElms,setHideElms:elmsTextActorに表示elmGrp名
#               をセットする関数を追加。
#      01/15    !ELEMENT, !EGROUPでEGRPを定義しない場合、vtkで表示できない。
#               （vtkは、egrp単位でvtkFileを作成しているため）
#               !ELEMENTでEGRPが定義されていない時、「--undefine--」で
#               vtkが表示できる様に修正。
#      01/17    getPickedCellType:pickedCellId > GetNumberOfValues()の場合
#               エラー発生する為、修正。
#      01/27    !SPRING pageに回転を追加
#      01/29    getBoundaryNodeGroupInCnt:!BOUNDARY, !CLOAD, !SPRINGについて
#               NGRP名がdummy_xxxの場合、xxxのみ取得する様に修正。
#      01/30    threadManage:vtkデータ読み込みでエラー発生する事があり
#               エラー発生すると、起動しなくなる為、errorTrapを追加。
#      02/03    addNewFolder,renameFolder:選択表示させるfolderを修正。
#               addNewFolder:folder名取得方法を修正。
#      02/09    changeCurrDir:dataDict[newDir]が更新されないので、folderCont
#               を取得して辞書を更新するように修正。
#      02/14    runOnlyParaView:toolBarにparaViewのアイコンを追加。
#      02/18    editBeamElementDDialog,getBeamRefDirDDialog,
#               calcSectionCoeffDDialog:新規追加。
#      02/26    deleteBndWithoutNames:isDeleteName内でnameの比較に"dummy_"
#               を追加して比較。
#               nodesBond:nodeGrpsは、dummyを含めない様に修正。
#               dialog表示前に現設定保存を追加。
#      03/07    meshConvert:mesh変換して、現在のメッシュに追加する機能追加
#               メッシュ追加の場合は、「変換前に戻す」ボタンを追加
#      03/08    checkCorrectElmType:メッシュ変換時、追加して変換した時、
#               beam、shellを追加する時にelmTypeを修正して追加する様に修正
#      03/23    pasteFolder,casePasteFolder:空folderにpasteした後、dirが
#               正常に表示されない事があり、これを修正。 
#      03/27    group編集pageを追加。各ngrp,sgrp,egrpのrename、削除が可能
#      04/13    GROUP作成画面中でshell、beamでのNGRP、EGRP作成ができる様に
#               修正。solid, shell, beamでface、edge、pointsがpickできる様
#               に修正して、これらを使って、GROUPが作成できる。
#      05/02    startStatusThread:daemonThreadとして起動し、HDDの使用状況
#               をstatusBarに表示。
#      05/03    writeStartFile:起動時に起動画面を表示させる。
#      05/05    startStatusThreadを廃止。threadでは、途中でハングする為。
#               定期的なtimerEventでHDDの使用状況を確認する（checkHddUsage）
#               matchControlCont:grp「ALL」に設定しても再起動時クリアされて
#               しまう為、修正
#      05/07    setVtkModel:制限時間を3s→6sに変更
#               pressMouseButton:dirTree上のcurrDirをclickした時、folderCont
#               を再読込、再表示させる。
#               getColumnNoFromPos:mouseの位置checkがheaderを検出する様に修正
#      05/10    threadGetHddNumResults:HDDの空き容量、結果file数の取得をtimeoutで
#               取得する様に修正。(threadで取得)
#               threadGetFolderContHdd:folderCont, HDD容量の取得をtimeoutで
#               取得する様に修正。（threadで取得）
#      05/13    vtkがimportできなかった場合、エラー発生するので、修正
#      05/15    deleteResults:popupMenuに結果data削除を追加。
#               pasteFolder,casePasteFolder:paste後、チェックマークが消える事
#               があるので、チェックIconを再設定。
#      05/17    os.system()をsubprocessに変更。
#               gnome-terminalを起動し、大きな処理を行うと、EasyISTRがフリーズ
#               する事があるため。
#      05/20    checkHddUsage:GLibで呼び出す関数内でthreadを投入すると
#               負荷が重い時、ハングする事があるので、直接関数を起動する様に修正。
#               deleteAllDataFiles:popupMenuに全dataファイル削除を追加
#      05/21    applyBCGroup:出力項目設定時に「!OUTPUT_VIS」が存在すると
#               fiist-5.2では、走らないので、これを削除する様に修正。
#               fistr-5.0, 5.1で今確認した結果、無くても問題なかった。
#      05/24    plotStepMonitor:plotStepMonitorDialogに統合した為修正
#      05/29    plotStepMonitor:plotStepMonitorDialog.py起動時の引数から
#               gnuplotCommを削除。
#      06/24    pressMouseButton:treeDir内のcurrDirを頻繁にdragすると、突然落ちる。
#               drag(singleClick)時にtreeDirの内容を更新しており、更新をthread
#               で行っていた為。threadではなくmainで行うように修正。
#      06/30    keyPress, keyRelease:key入力のeventを追加
#               cursor移動、copyPaste、delete等、key操作で実現。
#      07/06    addElementHeader,addSectionHeader:バグ修正
#               meshを追加する時、!SECTIONをsolid,beam,shellの順で定義する為
#               この順にしないとエラーが発生する。
#      07/11    showCreatedSgrp:shellのSGRP取得ボタンを有効に変更
#      07/14    threadManage:showNoneSelectedModelを追加。vtkが表示されていない事がある為
#               showNonSelectedModel,showSelectedModel,showCreateGrpModel:
#               最初に「self.showModel == True」を追加。余分なvtkを表示していた為。
#   22/02/11    setElGroupToListBoxInMaterial:codeを見直し
#               readMeshGetEachMaterialName:戻り値をlist→dictに変更
#      02/14    大幅修正。内容書き換え時には「設定」ボタン上に書き換えた事が
#               判る様に表示を追加。
#      02/15    showPopupMenu:popupMenuのaccelerationKey表示を右詰めで表示させる。
#               deleteElementGrps:currDirをtempに設定後、meshHeaderData読み直し
#               getPickedCellContents:error発生の為、pickedCellIdのチェックを追加。
#      02/16    readSetMaterialType:anaTypeと合致する材料データかどうかチェック追加
#      02/19    getPickedPointsContents:既に選択しているpointをpickした時、選択を
#               キャンセルするが、textBox内もクリアする様に修正。
#      02/27    renameFolder:currDirのfolder名変更を可能にした。
#               applyStep_sub:setFlagの再作成を追加。「境界条件STEP1」が増える為。
#               applyTemperatureCont:setFlagの再作成追加。initialondition設定される為。
#      02/28    setTemperatureToListBox:初期温度textCtrlを非表示設定に変更
#               applyBCGroup:TEMPERATUREの設定時、初期値の設定を削除。（温度設定のみ）
#               applyTemperatureCont:初期温度の設定を削除。（温度設定のみ）
#               meshConvert:メッシュ変換後、setFlagInTreeDictの作成を追加。
#               setBCGroupToListBox:treeのchildNamesとsetBox内のnamesを比較し、
#               異なっていた場合、flagをセットする。
#               setContactGroupToListBox,setAmpGroupToListBox,setStepGroupToListBox: ↑
#      03/03    doubleClickRow:doubleClick時の操作を修正。
#      03/13    言語の設定を追加
#      03/21    setGtkObject:windowsの国際化の為、labelへの文字セットを追加。
#               gladeファイルの翻訳がwindowsではできない為。
#      03/24    editUsingApp:okDialogの表示をeditUsingAppDDialog.pyに移動
#               okDialogがアクティブにならない為。
#      03/28    showNoneSelectedModel:vtk表示させる条件を追加。
#               選択、事前選択、currActorが空の時、差表示させる。
#               selectItem:再描画flagを追加。
#               meshConvert:tempCaseの作成方法を統一。（バグ修正）
#      04/01    shrinkMeshLines:「!END」が存在しない場合、最後に「!END」を追加。
#      04/02    getPickedPointsContents:pointModeでpickした時のpoint取得方法を修正
#               getPickedEdgeContents:edge4Modeでpickした時のedge取得方法を修正
#               大規模solidの場合、取得に時間が掛かる為。
#      04/03    hideVtk:vtk非表示設定のcheckBoxを追加
#      04/06    createNgrpSgrpPageを大幅修正。grpに加算、減算を追加。
#      04/10    selectItem:「*設定」状態で、TreeItemを移動すると
#               移動するかどうか確認dialogが表示される。
#      04/13    editPlasticSsData:弾塑性材料定義について、MULTILINEAR以外の
#               材料設定が可能に変更。
#      04/18    全ての非線形材料が使える様に修正。
#      04/19    全設定ボタンのsettingDialogを廃止。defaultでlog画面を表示。
#      04/25    setShowLogInTextViewer:logFileのopen時にencoding="utf-8"追加
#               最初にcheckUserPathFolderを実行する様に修正
#               $easyIstrUserPathフォルダが存在しない時、error停止する為。
#               runCad,runMesher,runOnlyParaView:commandBGをcommandWithLogBGに変更
#      04/27    solvePageにthread数の入力を追加
#      04/28    solvePageのthread設定checkBoxを追加
#      04/30    solvePageのGUIpartsの配置を変更
#      05/01    createMultiJob:メッシュ分割前にsetParallelHcmwCtrlDat(nCpu)を追加
#               runFrontIstr:出力方法を修正
#      05/20    createMultiJob:mesh分割時に結果fileを削除する様に修正。
#               mesh分割数を変更して計算させた時、前の結果が残っているので、
#               エラー発生することがある。
#      05/27    runCad,runMesher,runOnlyParaView:print(comm)を追加。
#      07/28    defaultAutoIncStepData:defaultの自動増分の値を設定する関数を追加
#      07/29    pasteFolder,casePasteFolder:paste後、currDirがTreeDirの表示から
#               閉じて、隠れてしまうので、修正。
#      07/30    pasteFolder,casePasteFolder:バグ修正。
#               showTreeViewAfterDelete:folder削除後の表示を修正。
#               pasteFolder,casePasteFolder:paste後のTreeView表示修正。
#      07/31    defineTreeItem:dirの幅を自由長に変更
#      08/01    showTreeViewAfterDelete:選択部を表示させる為、set_cursorを追加
#      08/11    onGetPickedCellId:cellのpick時は、buttonの「*」マーク付与廃止
#      08/15    setStringToPages:GROUP作成のmessage内容が長過ぎるので修正。
#      09/20    addOriginAxes:原点表示を追加
#      10/08    sshfsによるserverMount、serverUnmountを追加。
#      10/09    getLocalFolders,getServerFolders:追加
#               getAllFolders:localとserverに分けて取得する様に修正
#               createItemDict:serverIconを追加して設定
#      10/12    pasteScpCompTransfer,casePasteScpCompTransfer:追加
#               deleteServerFoldersRm:追加
#               getNeedFolders:追加（不要なfolderを取得しない為）
#      10/13    threadManage,createVtkDataFromFile,setHideVtkModelSW:
#               hideVtkModelSWフラグを追加して、vtk非表示設定で起動できる様に修正。
#      10/17    dir再読込、workFolser設定ボタンにicon設定
#      10/26    casePasteUsingServer:locel->local時のエラー表示追加
#               deleteServerFoldersRm:server接続有無チェックを最初に移動
#               setPostPage:ver4 or 5 の表示内容を修正。
#               createMultiJob:datファイルが存在しない場合があり、エラー発生。修正
#               deleteResultFoldersFiles:存在しないfileを削除、エラー発生。修正
#      10/28    paraviewによる可視化について、vtk or vtuが選択できる様に修正。
#      10/29    saveIstrData:treeWidgetのcol幅を追加
#               endingApp:treeWidgetのcol幅の保存を追加
#      10/30    setHecmwContFromDat:"hecmw_part_ctrl.dat"が存在しない場合
#               エラー発生。修正。
#      11/18    shrinkCntLines:!DLOADのforceTypeのチェックを追加。
#      11/21    OpenFOAMの結果取得を追加
#               selectPressType:radioBtnの選択を追加
#               createPtcOpenFoam:ptc作成ボタンを追加
#               showPtcPressure:mapping結果確認ボタンを追加
#      11/30    点群fileが「参照」ボタンで取得できるように修正。
#      12/07    runRevocap:commndBGをcommandWithLogBGに変更
#      12/10    createPtcOpenFoam:複数のpatch取得を可能にした。
#      12/14    設定項目Treeに「REFTEMP」を追加。
#      12/15    設定項目Treeの初期値をinitemp,inivel,iniaccに分割。
#               各々設定できる様に修正。
#      12/17    inivel, iniaccの設定を削除してもとに戻す。
#               VELOCITY, ACCELERATIONにTYPEを追加して、INITIALに対応。
#      12/19    clearFolder:currDirとselDirが合致していない時のworning廃止。
#      12/24    defaultDynamicSolutionCont:デフォルトの値を修正。
#               デフォルトで空白文字が入っていたので、最初のnodeNoを設定。
#      12/27    !INITIAL CONDITIONで定義するinivel,iniaccを全て削除
#   23/01/07    convertResultData:resFile数が4以上の場合は、nCpuを設定する
#      01/09    createMultiJob:「hecmw_part_ctrl.dat」有無check追加
#      01/10    postPageに並列処理を追加。REVOCAPを削除
#               setPostPage:並列の処理を追加。
#               convertResultData:並列数の入力先を変更
#      01/12    resultMerge:mergeResFiles.pyでmergeする様に修正
#               mergeする時、取りこぼすstepがあった為。
#      01/24    showPtcPressure:バグ修正。caseDirが長いとエラー発生。
#               setCaseDirTimeRegionFieldPatch:行を縮める方法を修正。
#      01/28    setPtcFile:fileDialogでcancelした時、エラー発生。修正
#      02/02    setCreateNewGrp:grp取得をクリックした時、テキストボックスが
#               activeにならない為、修正。
#      02/13    createPtcOpenFoam:存在しないPTCファイルが設定されていた場合
#               エラー発生するため、修正
#      02/20    loadCaseToTempDir:追加。起動option（-load）を追加した為。
#      02/22    loadCaseToTempDir:起動option（-dir）を追加。
#      02/23    checkLoadToTempOrNot:追加。起動時にtempにloadする、しないを確認
#               直接「fistr1」で計算した後、easyISTR起動する時は、tempに読み込む
#               様に修正。
#      02/25    readGetMaterialModel:HYPERELASTICの時、再起動後typeが表示されない
#               事を修正。
#      03/01    readSetEachMaterialName:DB未登録材料が使われた時、登録する様に修正
#      03/02    showMaterialData:物性値の表示方法を修正
#               onReloadDB:材料DB再読込ボタンを追加
#               toolBar, menuBarの順番を変更。（load,saveが判り難い為）
#      03/15    setContact_sub:comboBoxに「TIED (結合)」を追加
#               ver-5.5対応
#      03/23    materialType,materialMthDict:誤記訂正（MOONY-RIVLIN→MOONEY-RIVLIN）
#      03/24    writeHeatFistrModelFile:熱解析時の物性値を構造解析と同じ書式に変更。
#      03/30    getDloadBoundaryIdStpName:バグ修正。stepにdloadが追加できない。
#      04/01    iniLoadDirToTempDir:cnt,msh,dat有無確認し、無ければcopyを追加
#      04/13    "FistrModel.cnt"の使用を止め、hecmw_ctrl.datからの読込に変更。
#               任意のcntファイル名が使用可能。
#      04/14    getRunOption:"-cnt"オプションを追加。
#      04/18    resultMerge,convertDataForParaview46:resFileHeaderの取得方法を変更
#      04/19    DFLUXをDFLUXとBFに分割してBFを新たに追加
#               shrinkCntLines:!CLOAD,!CFLUX,!TEMPERATUREでotherData=yesの場合、
#               生dataのshrinkを追加。
#      04/25    copyUseCntFile:cnt,mshファイル名をdefault名に戻す事を追加。
#      04/27    copyUseCntFile:元に戻す。cntファイルの置き換えのみ
#               clearCntFile:datファイルをdefaultに戻す。cnt,mshファイル名をdefault名に戻す
#               setFrontISTRPage:cnt,mshファイル名の表示を追加
#      04/30    clearCntFile:余分なdat,cntファイルの削除を追加
#      05/02    setDload_sub:mapShiftを追加。
#      05/18    meshConvert:mesh変換時、datファイルを置き換えていたが、置き換えない
#               置き換えない様に変更。
#      05/19    goRenameNodeGrp,goRenameSurfaceGrp,goRenameElementGrp:修正漏れで修正
#               goRenameSurfaceGrp:重複定義関数の為、片方を削除
#      05/27    addSelectedActors:ngrpを設定していない時、初期値設定のALLを選択した時
#               辞書のkeyErrorが発生するので修正。
#      05/29    setPostPage:"FistrModel.res"名をdatからの読み込みに修正
#      06/13    showPtcPressure,applyDloadCont:ptcFileNameが未入力時エラー発生の為修正
#      07/15    fileDialog:dialogのopen時、selectしているfileを選択表示させる。
#      07/17    getPickedPointsContents:vtk画面上でpickしたpointを再度pickしてcancel
#               して、pointを取得するとエラー発生したので、修正。
#      07/18    deleteMeshGrps:mesh削除時、!SECTIONの削除を追加。
#      07/19    getParameterNumber:meshContの内容を修正（egrpの全typeを表示させる）
#      07/20    meshConvert:メッシュ変換後、datファイルをsingleコア用に修正を追加
#               set341elm_selective:341要素をselective_ESNS要素（平滑化）に設定可。
#               setHecmwContFromDat:hecmw_part_ctrl.datファイル中にDEPTH=2,1の設定
#               を追加。（平滑化要素使用の為）
#      11/02    checkDatFileConts:起動時にhecmw\ctrl.datファイル内容をチェック修正追加。
#               メッシュ分割後のメッシュをFistrModel_p* → <headerName>_p* に変更              
#      11/03    "FistrModel"の文字を変数headerNameに変更
#      11/22    getParallelOptionLine:currDir移動時にparallelの設定を確認する関数を追加
#      11/27    showCreateAllNgrp,saveNewCreateAllNodesGrp:追加。
#               setCreateGrp_newGrp:修正。
#               elmGrp内の全node取得用として、追加修正。
#      11/29    copyOtherFiles:並列計算用の分割meshは、tempFolderにコピーしない様に修正
#      12/14    copyOtherFiles:copyするfile数を制限していた為、必要なfileがcopyされない事態
#               が発生。file数の制限を無くし、計算結果をcopyしない様に修正。
#               changeWorkFolder:dir移動後にcurrDirがtempFolderに設定されていなかった為、修正
#      12/22    checkDimensionMatCsv:dimensionのチェックを追加
#      12/24    単位の設定を追加
#      12/29    checkDimensionMatCsv:workFolder内のその他matFileの単位変換を追加
#               (MULTILINEARのfileのみ)
#      12/30    clearAllBoundary:内部発熱（BF)がクリアできなかったを修正（バグ）
#      12/31    editPlasticSsData,applyEachMaterial:multilnear以外の非線形dataの
#               保存方法を修正
#   24/01/01    checkDimensionMatCsv:バグ修正（matFileの内容が単位変換できず）
#      01/02    全非線形材料dataの単位系変換を追加。
#      01/03    checkSetUserPathFiles:材料DBファイルの更新がwindowsでできていなかった
#               為、修正。（バグ）
#               saveIstrData:デフォルトの単位をmat.csvから取得する。
#      01/04    checkDimensionMatCsv:matFileを変更した時、comboBoxへの材料名再設定を追加
#      01/15    getDloadBoundaryIdStpName:DLOADの時間変化が設定できず。バグ修正
#      01/16    applyDloadCont:設定したAMPが消える事があるので修正
#      01/17    applyGravCont:  ↑
#      01/20    readGravValueFromCnt,readCentEgrpName,readVloadEgrpName,readDloadSgrpName,
#               deleteGravCont:DLOADの"S"とそれ以外を設定した時、エラー発生。
#               "S"とそれ以外は、引数の数が異なっている為。
#               applyCentCont,applyVeloCont,applyAccelCont:設定したAMPが消える事がある為修正
#      01/24    applyVeloCont,setVelocity_sub:Velocity_subページにcheckButtonを追加。
#               これに対する対応。
#      01/28    applyAccelCont:accTypeを削除。（初期加速度設定は意味ない為。）
#               applyAccelCont,setAcceleration_sub:Acceleration_subページにcheckBtnを追加。
#               writeFixtempContInCnt,writeCfluxContInCnt,writeSfluxContInCnt:
#               設定したAMPが消える事があるので修正。
#      01/31    deleteAmplitudeCont:listBox内の項目をmultiSelectionに変更。
#      02/16    endingApp:windowSizeの内容が空の場合、エラー発生する為、修正。
#      02/27    applyAmplitudeCont:ampDataをshrinkしてtempに保存
#      02/29    checkTempCaseDate:currDir移動時に警告出ないときあり、修正
#               保存終了のメッセージを廃止。
#      03/01    applyContact:treeへの追加itemをaddTreeItemsSetに追加。
#               setIniTreeData:fontStyle(bold,normal)の設定を追加
#               clearSetFlagInTree:addTreeItemsSetから表示pageの項目を削除。tree再表示。
#               applySolutionType,applyMaterial,applyBCGroup,applyStep_sub,applyAmp_sub:
#               addTreeItemsSetを取得して、追加itemをBoldで表示する様に修正
#      03/02    設定項目treeの追加item(未確定item)の設定をaddTreeItemsSetに統一。
#               (setFlagInTreeDict廃止)
#               追加itemを終了・dir移動前に保存し、起動・dir移動後に読込する様に修正。
#      03/06    saveNewCreateElmGrp,saveNewCreateSurfaceGrp,saveNewCreateAllNodesGrp,
#               saveNewCreateNodeGrp:cntFileの保存(temp→実folder)を追加。
#               cntの最新の状態が消える為（実folder内の旧cntにtempが置き換わる為）
#               setAddTreeItemsSetCurrPage:addTreeItemsSetに追加しないitemを新たに追加
#      03/09    setAddTreeItemsSetCurrPage:Treeの最上位が選択されている時エラーの為修正。
#      03/12    renameContactPair:contactPair名の変更を新規追加。
#      03/13    renameAmplitude:amp名の変更を新規追加
#               AMPLITUDE_sub pageを修正（境界条件と時間変化データを入れ替え）
#      03/16    reformStepBCCont:複数のgrpIDの取得ができる様に修正。（breakを削除）
#      03/18    createAmpDataFile:ampData取得を実folder内のmshファイルから取得する様に修正。
#               createTempCase:tempCase作成時に、cnt,mshファイルをチェック修正を追加
#               (remakeCntMshDataForEasyIstr.run()を追加)
#      03/22    changeWorkFolder:変更先folderの単位系が未設定の場合、設定を促すdialog追加
#               isDimensionInCurrDir,setDimensionToCurrDir:新規追加。
#               setMaterialToElGroup:cntと材料DBに不一致があるとflagをセットする様に修正
#      03/24    showMaterialData:表示方法を修正。
#      03/25    selectMaterialDataCntOrDB:材料物性値をcnt or DBのどちらを使うか選択する。
#               新規追加。
#      03/26    getMaterialParamsFromMatFile:材料DB内dataの単位取得方法を変更
#      03/27    setMaterialDataFromDbToCnt:cntのdataがDBに置き換わらない時があり修正。
#      03/29    国際化:一部英訳していない箇所あり。修正。
#               checkBtn_set341elmにtooltipを追加。
#      04/29    editPlasticSsData:内容を変更した時に発するflagのセット方法を修正。
#      04/30    getMaterialCoeffInCnt:材料物性値内に未定義項目ある時、エラー発生の為、修正。
#               showMaterialData:材料DBの値が修正できる様に修正。
#               setValsToMaterialDB:新規追加（材料物性値の値をDBに保存する。）
#      05/01    showPtcPressure,applyDloadCont:mapping処理が並列処理できる様に修正。
#      05/08    getYoungsExp:削除。変わりにpyFistr.float2strAutoに変更。
#               setDimensionToCurrDir,editPlasticSsData:valueを文字列に変換
#               (pyFistr.float2strAuto)を追加
#      05/21    renameNodeGrps,renameSurfaceGrps,renameElementGrps,renameNodeGroup,
#               renameSurfaceGroup,renameElementGroup,renameFolder,addNewFolder,
#               renameContactPair,renameAmplitude:inputTextDDialog.getInputTextクラスを使って修正
#      05/22    reformNgrp:deleteOverlapNodesクラスに置き換え。
#               editAutoincParam:autoincParamクラスに置き換え。
#               editUsingApp:setEditUsingAppクラスに置き換え
#      05/23    nodesBond:setNodesFacesBondingクラスに置き換え。
#               showAllElms:setVtkShowContentsクラスに置き換え
#               editBeamElements:setEditBeamElementクラスに置き換え
#      05/24    getBeamRefDirMethods:setBeamRefDirクラスに置き換え
#               calcSectionCoeff:setCalcSectionCoeffクラスに置き換え
#      05/25    editPlasticSsData:inputMaterialContクラスに置き換え
#               selectMountServer:mountServerクラスに置き換え
#               createPtcOpenFoam:selectOpenFoamResultクラスに置き換え
#      05/26    changeUnit:createNewDimensionクラスに置き換え
#               setDimensionToCurrDir:setDimensionToCurrDirクラスに置き換え
#               showMaterialData:showMaterialValue,ahowSetMaterialValueクラスに置き換え
#      05/27    checkPhysicalValueENull:取得した値の整形する様に修正
#      05/30    showMaterialData_onSetDlg:pageが移動している場合、pageを戻すを追加
#      05/31    editAutoincParam_onDlg,calcSectionCoeff_onDlg,changeAnyUnit_onDlg,
#               reformNgrp_onDlg,editBeamElements_onDlg,editUsingApp_onDlg,
#               getBeamRefDirMethods_onDlg,getSetMaterial3Vals_onDlg,renameNodeGrps_onDlg,
#               renameSurfaceGrps_onDlg,renameElementGrps_onDlg,renameNodeGroup_onDlg,
#               renameSurfaceGroup_onDlg,renameElementGroup_onDlg,renameFolder_onDlg,
#               addNewFolder_onDlg,renameContactPair_onDlg,renameAmplitude_onDlg,
#               nodeBond_onDlg,showMaterialData_onSetDlg:pageが移動していた時、pageを元に戻す。
#      06/06    universalDilogsを設定。
#               addPrincipalStress:削除
#      06/08    universalDialogにparentを追加
#      06/20    setMaterialDB,setMeshFile:openFileDialogにparent追加漏れで、追加
#      06/26    meshConvertKeepSetting:設定を保持してmesh変換する時、等分布荷重の設定
#               があると、エラー発生。また、unvFile名が継承されず、旧のunvが使われていた。
#               これを修正。
#      06/27    meshConvertKeepSetting:設定を保持してmesh変換する時、材料物性値の保持で
#               エラー発生することがあり、修正。
#      06/30    setNewCurrDir:「folderを移動しました」のmessageを削除。
#      07/07    openにencoding="utf-8"を追加
#      07/25    selectItem:選択itemへの移動確認dialogをここで表示させる。
#               pressMouseButtonInTreeItem:削除（ここで確認dialog表示させていた）
#      08/08    国際化対応:「localectl」コマンドで言語変更する様に修正
#               main:起動時にcnt,mshファイル名が表示されない為、self.setFrontISTRPage()
#               を追加。
#      08/16    setStep_sub:step解析する境界条件の表示が正しく反映されない為、
#               「self.setControlCont()」を追加。
#               selectItem:treeのitemNameが前回、今回とも「ステップ解析」の場合
#               移動しないを追加。（stepを追加するとpathが変わる）
#               getShowPageName:「境界条件 step1」に対応するpageが設定されていない為、追加
#      09/12    readMeshData,confirmModelAtParaview:mesh読み込み、形状確認buttonを削除。
#      09/13    setNewElasticMaterialInDB:cntから物性値が読み取れなかった場合、
#               mshから読み込む様に修正。
#               shrinkMeshLines:shrinkデータの最後に「...」を追加
#               materialType,getNonlinearMaterialDataInCnt:matHardenの「""」(default)を追加。
#               writeFistrModelMsh:tempFolderへの保存は、最終dataに「...」を追加。
#               loadDataToTempProcess:実currDirから読み込んだ時、self.changeItem(path)で
#               itemPageを表示する事を追加。
#      09/15    createCopyAllAmpFiles:!AMPLITUDEが定義されて、AMPfileが存在しない場合、
#               新規に作成する。
#               getMaterialCoeffInMshCnt:msh,cnt両方から物性値を読み込み、値がダブル場合は
#               cntFileの方を優先させる。
#      09/16    isResultDataFile:辞書内容が「""」の場合全て該当する事になる為、修正。
#               この場合、tempCase作成時に、otherFilesがまったくcopyされなくなるので、修正。
#      09/22    checkElasticMaterialDataInDB:非線形データのcheckを追加
#               selectMaterialDataCntOrDB:非線形データの表示を追加
#               editPlasticSsData:cnt-DBで非線形データの値が異なる場合を追加
#      09/23    createPlasticSsDataFile,createPlasticSsDataFaiFile:cnt内のdataを毎回読み取り
#               csvを作成するように修正
#               replaceElasticMaterialInDB,setMaterialDataFromDbToCnt:非線形dataの置き換えを追加
#      09/24    mesh変換時に、egrp:All,ngrp:ALLを追加するように修正。
#               getParameterNumber:meshCont内にERGP:ALL,NGRP:ALLを追加
#      09/26    matModel,matType,matHardのcomboBoxの用法をGtkPartsに統合
#               getMaterialCoeffInMsh:mshファイル内のcp,kappaの値が入れ替わっており修正。
#               editGroupRename,editGroupDelete,editGroupDelMesh:処理後、表示が更新されない
#               最後にpage再表示を追加。
#      09/28    editGroup:group編集pageを表示させた時、直前で表示させたvtkが残ったまま、修正。
#      09/29    meshConvert,meshConvertKeepSetting:mesh変換中、meshのscale変更ができる様に修正。
#      09/30    renameContactPair_onDlg,renameAmplitude_onDlg:global変数追加。
#               contactPair名変更できず。バグ修正。
#               inputTextDDialogをinputTextOkCancelDialogに変更。
#               treeList内のpopupMenuを削除。（grp名変更削除は、grp編集画面でできる為）
#               isGrpNameInVtkFiles:"ALL"を追加したため、起動時毎回vtk読みに行く。バグ修正。
#      10/03    getModelSize:pyFistr.float2strAutoを使って変換する様に修正。
#      10/04    applyEachMaterial:mthDict[mats]をmthDictに修正。バグ修正。
#               setMatYieldType:matType=="",matHarden=""を追加。エラー発生の為。
#      10/05    getMaterialCoeffInMsh:mshファイル内の物性値の読み込みをSUBITEM=1 or 2
#               で熱解析or構造を決定する様に修正。熱解析結果を使った構造計算をすると
#               エラー発生のため。（anaTypeで熱or構造を決定していた為エラー発生）
#      10/6     setReftemp:vtk表示を非選択で表示（showNoneSelectedModel）する様に修正。
#               renameAmplitude_onDlg,renameContactPair_onDlg:連続してrenameすると
#               エラー発生の為、修正。
#      11/10    applyDynamicSolution:global currDirを追加、currDirを戻す位置を変更。
#               バグ修正
#      11/11    getAddTreeItemsPath:addTreeItemsSet内のitemに加え親itemを追加
#               親のpathもゴシックに変更する。
#               deleteNoneItemInAddTreeItemsSet:追加（存在しないitemを削除する）
#               clearSetFlagInTree:tree項目のゴシックのクリア表示をリアルタイムで実行する。
#               setTreeFontColour:tree項目のゴシック表示をリアルタイムで実行する。
#      11/12    clearSetFlagInTree,getAddTreeItemsPath:親pathがrootの場合、set_cursorしない。
#      12/13    createAmpDataFile:csvDataの1行1列に"FrontISTR"を追加
#               getAmpDataInFile:csvDataの読み込みを修正。
#               meshConvert:mesh変換後、sourceMeshFile名がeasyIstrSub_dataに保存されて
#               いなかった為、修正。
#      12/18    getStepBndListFromDefineData:同じ内容がbndListに存在するので、削除
#               setBCGroupToListBox:bndDefineの取得を止める
#               applyBCGroup:bndDefineの取得をここで実施。（ボタンのクリック時）
#               checkTempCaseDate:cnt,mshファイル有無で処理変更
#      12/31    大幅変更:vtk描画速度アップのため、actorのcolor設定方法を変更。
#               従来:1ヶのactorでactor内の各cellの色を設定。今回:color毎のactorを準備。
#   25/01/05    setOpacColorToElement:透明化のとき、選択していない面のedgeは表示しない
#               様に修正。（edge多数ある状態で透明化した時表示がおかしくなる為）
#      01/10    convertToInp,convertToRad,convertInpResToVtu:inp,radファイル変換追加
#               calculix結果をvtu変換を追加
#      01/18    createSurfaceActors,createOutLineActor,getDoublePickedActor:elNameの
#               取得方法を split("_")[1] から "_".join(split("_")[1:]) に修正。
#      01/20    setMeshFile:fileOpenDialogに渡すmeshNameを修正。
#      01/22    バネ要素をバネ境界に変更。
#               writeUnsetTreeItems,readUnsetTreeItems:" "区切りから","区切りに変更。
#               applyBCGroup:addItemsSetのゴシック表示がstepが変わった時、
#               おかしくなる為、修正。
#               setDynamicContInCnt:固有値から周波数応答を連続して行うとerror発生。
#               （folderCopyすればerrorなし）修正。
#               applyDynamicSolution:周波数応答を設定するが、確定すると動解析に変わる為修正
#               getDynamicContFromCnt:dataの整形を追加。
#      01/23    meshConvert,meshConvert_createTempCase:メッシュ変換後、341要素チェック追加
#               createAmpDataFile:csvDataの1行1列に単位系を記入する様に修正。
#               applyBCGroup:参照温度の様にstepがない場合エラー発生のため修正。
#      01/24    meshConvert_createTempCase:mesh変換時にtempFolder用のmshファイルが実folder内
#               にcopyされた事があり、修正。
#      02/11    setCreateGrp_newGrp,setCreateGrp_addGrp,setCreateGrp_delGrp:pointモードでは
#               entryが空白になる場合があり、この時エラー発生する為、修正。
#      02/12    threadGetHddNumResults:timeout時間を0.2→0.3に修正。
#      02/20    isPrallelMeshFile:__pycache__フォルダがある時、起動しない時あるある為、修正。
#      02/23    getSavedData,saveIstrData:createMeshの設定内容の読込保存を追加。
#      02/27    group編集画面:項目選択をマウスのみ→カーソルキーでも選択できる様に修正。
#               メッシュ画面:「mesh作成」「mesh変換」ボタンを追加。
#      03/01    convertInpResToVtu_run:frd2vtu変換終了後、paraview起動を追加。
#      03/20    createMesh_createTempCase:メッシュ作成時のvtkFile作成は、setVtkModelから
#               setreloadVtkMesh（時間制限なし）に変更。
#      03/24    createVtkDataFromFile:vtk-9.4からbackgroundの設定方法が変わった為、対応。
#               「import vtk」の位置をgtkよりも前に設定。vtk-9.4では、gtkの後に設定すると
#               vtkのimportの時間が15分かかってしまう。gtkの前に設定すると、早い。
#               initialize:userPathが存在しない場合、作成するように追加。
#      03/26    FistrModel.msh画面を修正し、Gmshによるメッシュ作成を追加。
#      03/27    confirmModelAtParaview:メッシュ作成画面でparaview起動を復活。
#               setEdgeElementActor:viewerの要素edgeのlineWidthを1.0→1.2に修正
#      03/30    threadManage,createVtkDataFromFile,hideVtkModel:vtk-9.4対応で再修正。
#               SetGradientbackGround(True)→GradientBackgroundOn()に変更。
#      04/03    endingApp:終了時にwinSizeを保存を追加。
#               setWindowSize:起動時に保存したwinSizeを設定するを追加。
#      04/07    setGtkObject:listBox_eNgrp,listBox_eSgrp,listBox_eEgrpに
#               eventのconnectを追加。
#      04/09    editNgrpSelect,editSgrpSelect,editEgrpDict:eventのconnect削除して
#               処理を修正。
#      04/17    meshConvertKeepSetting,meshConvertClearSetting:meshioによる
#               他形式のmesh読み込みを追加。
#               set_newMesh_or_addMesh:作成したmeshの保存file名変更
#      04/18    createMeshFromCadKeepSetting:mesh作成後の処理に、「設定を保持する」を追加。
#      04/20    convertToInp,convertToRad:saveFileDialogで入力できる様に追加。
#               convertInpResToVtu:openFileDialogの受取を修正。
#      04/21    menuBar,toolBar:importとexportのメニューを追加
#      04/22    meshConvertClearSetting,meshConvertKeepSetting:unv2fistr.py,abaqus2fistr.py
#               の引数追加。
#      04/25    deleteMeshGrps:meshを削除した後、chdirで移動したcurrDirを
#               元に戻していなかった為、エラー発生。chdirで元に戻すを追加。
#      04/26    loadDataToTempProcess:tempCase作成時にvtkDataを作成表示を追加。
#      04/30    setEdgeElementActor:edgeの幅を1.2→2.0に変更。
#               addColoredElmActor:beamの要素色とedge色を黒、黒に修正。
#               defaultは要素色緑、edge色黒の為、beamの場合、緑、黒が重なる為。
#      05/01    setOpacColorToElement:addColoredElmActorでの色設定を止めて、ここで設定。
#      05/02    defineTreeItem,createItemDict,threadGetHddNumResults,threadGetFolderContHdd,
#               deleteResultFoldersFiles,deleteAllDataFilesProcess,
#               writeFolderContToTreeItem,setNumResultsToTreeItem,writeNumResultsToTreeItem:
#               nResを廃止に伴い修正。(folderの展開に時間が掛かっている為、廃止。)
#      05/03    defineTreeItem,createItemDict,threadGetHddNumResults,threadGetFolderContHdd,
#               deleteResultFoldersFiles,deleteAllDataFilesProcess,
#               writeFolderContToTreeItem,setNumResultsToTreeItem,writeNumResultsToTreeItem:
#               nRes復活に伴い元に戻す。(nRes取得方法を変更してfolder展開速度アップさせて復活)
#      05/13    showAllCellActors:関数名をshowElmActors→showAllCellActorsに変更
#      06/05    set_newMesh_or_addMesh,createMeshFromCadKeepSetting,meshConvertClearSetting,
#               meshConvert_createTempCase,addConvertMeshToCurrMesh,meshConvertKeepSetting,
#               meshConvertKeep_createTempCase,createTempCase:
#               meshFile読み込み時、pyFistr.readFistrFileUntilEndに変更。
#               windowsでmeshファイルを全て読み込めない時があるため。
#               createMesh_changeScaleCreateTempcase,createMesh_createTempCase,
#               meshConvert_createTempCase,meshConvertKeep_createTempCase,              
#               :終了メッセージの表示を追加。
#      06/06    waitUntilCreatingMeshEnd:monitorFile読み込みをpyFistr.readFistrFileUntilEnd
#               に変更。（windowsで読み込み漏れが発生するため）
#      06/12    mesh作成変換時、meshHeaderDataをbinaryで保存し、vtk作成時にこれを使う様に修正
#      06/17    vtkFile作成時の引数に「vtkFormat」を追加。
#               起動時のvtk表示の時間制限を廃止。（vtk表示時間が早くなった為）
#      06/22    getReturnMeshHeaderData:meshHeaderDataを戻す関数を追加。
#               createTempCase:pickleFileが読み込める様に修正。
#      06/23    changeMeshScaleWithEquation:pickleFileを使うように修正。
#      06/24    mesh作成・変換時にsettingDialog（progressDialog）の表示を追加
#      06/26    saveNewCreateElmGrp,saveNewCreateSurfaceGrp,saveNewCreateAllNodesGrp,
#               saveNewCreateNodeGrp:pickleFileを使うように修正。
#               changeMeshScaleWithEquation:再度修正。
#      07/03    threadManage:vtk表示の時間制限を無くしているが、「時間制限オーバした」
#               のメッセージが出ることがあるので修正。
#      07/22    setEdgeElementActor:beamとbeam以外でlineWidthを変更。
#      07/25    setOpacColorToSurface:「isBeam=True」を追加。バグ修正。
#      08/11    getNeedFolders:「vtkCadData」を隠しfolderに追加。
#      08/20    viewFromXP,viewFromXM,viewFromYP,viewFromYM,viewFromZP,viewFromZM:
#               vtk表示を+-XYZ方向の6種類に追加。
#      09/25    setMaterialThicknessToTextBox:paramsが設定されていない場合、
#               初期値を設定するように修正。
#

#vtk関連をimport
import vtk
import GtkVtkRenderWindowInteractor as gtkVtk
from vtk.util.colors import *

#Gtk3関連をimport
import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, Gdk, GdkPixbuf, Pango, GLib

import sys
import os
import glob
import csv
import shutil
import subprocess
import time
import threading
import decimal
import multiprocessing
import signal
import math
import pickle

import pyFistr
import geometryFunc as geo
import convertMesh
import abaqus2fistr
import deleteOverlapNodesDDialog2 as deleteOverlapNodesDDialog
import deleteOverlapNodeInNgrp as delnd
import copyFilesFromTempToCurrDir as copyTempFiles
import inputTextOkCancelDDialog
import autoincParamDDialog
#import openFolderDDialog
import editUsingAppDDialog
import nodesFacesBondingDDialog
import GtkParts
import getVtkShowContentsDDialog
import editBeamElementDDialog
import getBeamRefDir
import getBeamRefDirDDialog
import calcSectionCoeffDDialog
import beam611To641
import shell741To781
import shell731To761
import folderContHddVals
import deleteFilesDialog2 as deleteFilesDialog
import inputMaterialContDDialog
import inputMaterialContSigmaDDialog
import inputMaterialContEpsilonDDialog
import mountServerDDialog
import progressBar
import mappingFromPointCloud
import selectOpenFoamResultDDialog
import createPointCloudFromOpenFoam
import convDimensionMatCsv
import createNewDimensionDDialog
import remakeCntMshDataForEasyIstr
import setDimensionAtChangeFolderDDialog
import showMaterialValueDDialog
import showSetMaterialValueDDialog
import selectMaterialDataCntDbDDialog
import universalDialogs
import convertToInpDDialog
import convertInpResToVtuDDialog
import convertToRadiossDDialog
import convertMeshFromOtherMeshDDialog
import meshioOperation as meshOp
import selectImportItemDDialog
import selectExportItemDDialog
import exportMeshToOtherFormatDDialog
#モデルのvtkFile作成をimport
import createVtkSourceFiles
vtkVersion = createVtkSourceFiles.version


#import locale
#glade(ui)ファイル内を翻訳
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

#logFile定義
#import logFileCreater
#logFileCreater.new()

#起動時に表示させるdialogのinputFileを定義
StartFileName = os.sep.join(
    [os.getenv("easyIstrUserPath"), "data", "startingFile"])

version = "3.54-250926"

loadFlag = 0                #起動option（起動時にtempをセットする）
FistrModel_cnt = ""         #cntファイル名(default:FistrModel.cnt)
FistrModel_msh = ""         #mshファイル名(default:FistrModel.msh)
FistrModelDict = {}         #hecmw_ctrl.datファイル内の辞書を保存
builder = ""                    #Gtk.Builderの保存場所
mainWindow = ""                 #GUIのwindowの保存場所
winSizeFileName = "windowSize"  #windowSizeの保存場所

#appの設定（変数の定義）
OrgPath = ""                #起動時のsystemPah
vtkFormat = ""              #vtkFileのformat
runOfficeComm = ""          #office
runTerminalComm = ""        #ターミナル
runTerminalRunComm = ""     #ターミナル付きでcomm実行
runFileManagerComm = ""     #ファイルマネージャ
runEditorComm = ""          #エディタ
frontIstrFolder = ""        #FrontISTRのインストール先
runParaViewComm = ""        #paraview
#runRevocapComm = ""         #REVOCAP
runGnuplotComm = ""         #gnuplot

dimTrueFalseFlag = True     #単位系有無flag
settingDialog = ""          #設定中dialogのobject
currDirTemp = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + "temp"
currDir = ""
sourceMeshFile = ""
istrDataFileName = "easyIstr_data"
istrSubDataFileName = "easyIstrSub_data"
istrData = []
materialDBName = ""
anaType = ""            #解析の種類
selPairName = ""        #選択しているcontactのPairName
materialDBCont =[]
meshGroup = []          #meshグループ名list:[EGRP, SGRP, NGRP]
matDefine = []          #材料定義:[[EGRP名, 材料, elType], ...]
bndDefine = []          #BOUNDARYグループ名（変位）
cloadDefine = []        #CLOADグループ名（荷重）
dloadDefine = []        #DLOADグループ名（面圧）
vloadDefine = []        #VLOADグループ名（体積力）
centDefine = []         #CENTグループ名（遠心力）
tempDefine = []         #TEMPERATURE
reftempDefine = []      #REFTEMP
gravDefine = []         #GRAV
springDefine = []       #SPRING
contactDefine = []      #CONTACT
floadDefine = []        #FLOAD
veloDefine = []         #VELOCITY
accelDefine = []        #ACCELERATION
initempDefine = []      #INITEMP
fixtempDefine = []      #FIXTEMP
cfluxDefine = []        #CFLUX
bfDefine = []           #BF
dfluxDefine = []        #DFLUX
sfluxDefine = []        #SFLUX
sfilmDefine = []        #SFILM
sradiateDefine = []     #SRADIATE
ampDefine = []          #AMPLITUDE
stepDefine = []         #STEP
needBoundaryNo = []     #設定された解析の必要な境界条件Noのリスト
meshHeaderData = []     #meshデータの保存用（header毎に数値で保存

treeData = []
treeRoot = [] 
treeFistrModel = []
treeSolution = []
treeMaterial = []
treeInitial = []
treeReftemp = []
treeBoundary = []
treeAmp = []
treeStep = []
treeSolver = []
treePost = []
treeStepBounds = []     #step解析時の境界条件用Tree

autoincParamData = []   #セットするAUTOINC_PARAMの内容

ls = "\n"               #行末コード

#AppのPathを定義
binAppPath = pyFistr.binAppPath             #binFolder
pythonAppPath = pyFistr.pythonAppPath       #pythonFolder

contactAlgo = "SLAGRANGE"   #接触アルゴリズムの初期設定

#tempFolderにコピーする時、shrinkするkeywordを取得（これ以外はそのままコピーする）
shrinkKeywords = pyFistr.shrinkKeywords

vtkImportFlag = "no"        #vtkのimportFlag


def ampValTypes():
    types = [_(u"RELATIVE（相対値）"), _(u"ABSOLUTE（絶対値）")]
    return types

def analysisTypes():
    anaTypes = [_(u"線形弾性静解析"), _(u"非線形静解析"), _(u"動解析"),
                _(u"固有値解析"), _(u"周波数応答解析"), _(u"熱伝導（静解析）"),
                _(u"熱伝導（動解析）")]
    return anaTypes

def analysisTypesE():
    anaTypes = ["STATIC", "NLSTATIC", "DYNAMIC",
                "EIGEN", "DYNAMIC_F", "HEAT",
                "HEAT_D"]
    return anaTypes

def initialTreeParts():
    root = [_(u"FrontISTR analysis")] 
    fistrModel = [[_(u"FistrModel.msh"), [_(u"GROUP作成"), _(u"GROUP編集")]]]
    solution =[_(u"解析の種類")]
    material = [_(u"材料物性値")]
    initial = [_(u"初期値（初期温度）")]
    reftemp = [_(u"参照温度")]
    boundary = [[_(u"境界条件"), [_(u"BOUNDARY（変位）"), _(u"CLOAD（荷重）"),
                              _(u"DLOAD（圧力）"), _(u"VLOAD（体積力）"),
                              _(u"GRAV（重力）"), _(u"CENT（遠心力）"),
                              #_(u"TEMPERATURE（温度）"), _(u"SPRING（バネ要素）"),
                              _(u"TEMPERATURE（温度）"), _(u"SPRING（バネ境界）"),
                              _(u"CONTACT（接触）"), _(u"FLOAD（周期荷重）"),
                              _(u"VELOCITY（速度）"), _(u"ACCELERATION（加速度）"),
                              _(u"FIXTEMP（温度固定）"),
                              _(u"CFLUX（集中熱量）"), _(u"SFLUX（面熱流束）"),
                              _(u"DFLUX（個別の面熱流束）"), _(u"BF（内部発熱）"), _(u"SFILM（熱伝達率）"),
                              _(u"SRADIATE（輻射）")]]]
    step = [_(u"ステップ解析")]
    amp = [_(u"時間変化")]
    solver = [[_(u"solver"), [_(u"線形solver"), _(u"出力")]]]
    post = [_(u"post")]
    return [root, fistrModel, solution, material, initial, reftemp, boundary, amp, step, solver, post]

def boundaryNames():
    names = ["BOUNDARY", "CLOAD", "DLOAD", "VLOAD", "GRAV", "CENT",
             "TEMPERATURE", "SPRING", "CONTACT", "FLOAD",
             "VELOCITY", "ACCELERATION",
             "FIXTEMP", "CFLUX", "SFLUX", "DFLUX", "BF", "SFILM", "SRADIATE"]
    return names

#境界条件のorderNoを定義
nBoundary=0;  nCload=1;         nDload=2;     nVload=3;    nGrav=4
nCent=5;      nTemperature=6;   nSpring=7;    nContact=8;  nFload=9
nVelocity=10; nAcceleration=11; nFixtemp=12;  nCflux=13
nSflux=14;    nDflux=15;        nBf=16;       nSfilm=17;   nSradiate=18

#各解析で必要な境界条件のリスト（boundary[0][1]の内容）
#線形静解析
needBndStatic = (nBoundary, nCload,nDload, nVload, nGrav, nCent, nTemperature,
                 nSpring)
#非線形
needBndNlstatic = (nBoundary, nCload,nDload, nVload, nGrav, nCent, nTemperature,
                   nSpring, nContact)
#動解析
needBndDynamic = (nBoundary, nCload, nDload, nVload, nGrav, nCent, nTemperature,
                  nSpring, nContact, nVelocity, nAcceleration)
#固有値解析
needBndEigen = (nBoundary, nCload, nDload, nVload, nGrav, nCent, nTemperature,
                nSpring)
#周波数応答解析
needBndDynamic_F = (nBoundary, nCload, nDload, nVload, nGrav, nCent, nTemperature,
                    nSpring, nFload)
#熱伝導解析（静解析）
needBndHeat = (nFixtemp, nCflux, nSflux, nDflux, nBf, nSfilm, nSradiate)
#熱伝導解析（動解析）
needBndHeat_D = (nFixtemp, nCflux, nSflux, nDflux, nBf, nSfilm, nSradiate)


materialType = [
    ["ELASTIC", [], []],
    ["PLASTIC",
        ["MISES", "MOHR-COULOMB", "DRUCKER-PRAGER", ""],
        ["MULTILINEAR", "BILINEAR", "SWIFT", "RAMBERG-OSGOOD", "KINEMATIC", 
          "COMBINED", ""]],
    ["HYPERELASTIC",
        ["NEOHOOKE", "MOONEY-RIVLIN", "ARRUDA-BOYCE"], []],
    ["VISCOELASTIC", [], []],
    ["CREEP", ["NORTON"], []]
    ]

matGrpHeader = ["!ITEM", "!ELASTIC", "!DENSITY", "!EXPANSION_COEFF", "!PLASTIC",
                "!HYPERELASTIC", "!VISCOELASTIC", "!CREEP", "!SPECIFIC_HEAT",
                "!THERMAL_CONDUCTIVITY"]


#非線形材料data取得dialog表示の為の辞書作成
def materialMthDict():
    mthDict = {
        # model     type      harden
        ("ELASTIC", "",      ""):{
            "dialog": None,
            "names":  [],
            "cols": [],
            "conts":  [] },
        ("PLASTIC", "MISES", "MULTILINEAR"):{
            "dialog":"office",
            "name" :"_PlasticSSdata.csv",
            "cols": [],
            "cont" :"normal"},
        ("PLASTIC", "", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["YIELD0", "H", ""],
            "cols":   [7, 8, -1],
            "conts":  [_("初期降伏応力"), _("硬化係数"), ""] },
        ("PLASTIC", "MISES", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["YIELD0", "H", ""],
            "cols":   [7, 8, -1],
            "conts":  [_("初期降伏応力"), _("硬化係数"), ""] },
        ("PLASTIC", "MISES", "BILINEAR"):{
            "dialog": inputMaterialContDDialog,
            "names" : ["YIELD0", "H", ""],
            "cols":   [7, 8, -1],
            "conts":  [_("初期降伏応力"), _("硬化係数"), ""] },
        ("PLASTIC", "MISES", "SWIFT"):{
            "dialog": inputMaterialContSigmaDDialog,
            "names" : ["epsilon0", "K", "n"],
            "cols":   [9, 10, 11],
            "conts":  ["", "", ""] },
        ("PLASTIC", "MISES", "RAMBERG-OSGOOD"):{
            "dialog": inputMaterialContEpsilonDDialog,
            "names" : ["epsilon0", "D", "n"],
            "cols":   [12, 13, 14],
            "conts":  ["", "", ""] },
        ("PLASTIC", "MISES", "KINEMATIC"):{
            "dialog": inputMaterialContDDialog,
            "names" : ["YIELD0", "C", ""],
            "cols":   [7, 16, -1],
            "conts":  [_("初期降伏応力"), _("線形移動硬化係数"), ""] },
        ("PLASTIC", "MISES", "COMBINED"):{
            "dialog": inputMaterialContDDialog,
            "names" : ["YIELD0", "H", "C"],
            "cols":   [7, 8, 16],
            "conts":  [_("初期降伏応力"), _("硬化係数"), _("線形移動硬化係数")] },
        ("PLASTIC", "MOHR-COULOMB", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["c", "FAI", "H"],
            "cols":   [16, 15, 8],
            "conts":  [_("粘着力"), _("内部摩擦角"), _("硬化係数")] },
        ("PLASTIC", "MOHR-COULOMB", "BILINEAR"):{
            "dialog": inputMaterialContDDialog,
            "names" : ["c", "FAI", "H"],
            "cols":   [16, 15, 8],
            "conts":  [_("粘着力"), _("内部摩擦角"), _("硬化係数")] },
        ("PLASTIC", "MOHR-COULOMB", "MULTILINEAR"):{
            "dialog":"office",
            "name" : "_PlasticMohrSVdata.csv",
            "cols": [],
            "cont" :"FAI"},
        ("PLASTIC", "DRUCKER-PRAGER", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["c", "FAI", "H"],
            "cols":   [16, 15, 8],
            "conts":  [_("粘着力"), _("内部摩擦角"), _("硬化係数")] },
        ("PLASTIC", "DRUCKER-PRAGER", "BILINEAR"):{
            "dialog": inputMaterialContDDialog,
            "names" : ["c", "FAI", "H"],
            "cols":   [16, 15, 8],
            "conts":  [_("粘着力"), _("内部摩擦角"), _("硬化係数")] },
        ("PLASTIC", "DRUCKER-PRAGER", "MULTILINEAR"):{
            "dialog":"office",
            "name" : "_PlasticDruckerSVdata.csv",
            "cols": [],
            "cont" :"FAI"},
        ("HYPERELASTIC", "NEOHOOKE", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["C10", "D", ""],
            "cols":   [17, 18, -1],
            "conts":  [_("材料定数"), _("材料定数"), ""] },
        ("HYPERELASTIC", "MOONEY-RIVLIN", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["C10", "C01", "D"],
            "cols":   [19, 20, 21],
            "conts":  [_("材料定数"), _("材料定数"), _("材料定数")] },
        ("HYPERELASTIC", "ARRUDA-BOYCE", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["mu", "lambda_m", "D"],
            "cols":   [22, 23, 24],
            "conts":  [_("材料定数"), _("材料定数"), _("材料定数")] },
        ("VISCOELASTIC", "", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["g", "t", ""],
            "cols":   [25, 26, -1],
            "conts":  [_("せん断緩和弾性率"), _("緩和時間"), ""] },
        ("CREEP", "NORTON", ""):{
            "dialog": inputMaterialContDDialog,
            "names" : ["A", "n", "m"],
            "cols":   [27, 28, 29],
            "conts":  [_("材料係数"), _("材料係数"), _("材料係数")] },
        ("HEAT", "", ""):{
            "dialog": None,
            "names":  [],
            "cols":   [],
            "conts":  [] }
        }
    return mthDict

solveMethod = ["CG", "BiCGSTAB", "GMRES", "GPBiCG", "DIRECT", "DIRECTmkl", "MUMPS"]

#出力項目
def outputItems():
    items = [_("1.変位:DISP"), _("2.シェル回転:ROT"), _("1.節点反力:REACTION"),
            _("1.節点ひずみ:NSTRAIN"), _("1.節点応力:NSTRESS"),
            _("1.節点Mises応力:NMISES"), _("1.要素ひずみ:ESTRAIN"),
            _("1.要素応力:ESTRESS"), _("1.要素Mises応力:EMISES"),
            _("1.積分点ひずみ:ISTRAIN"), _("1.積分点応力:ISTRESS"),
            _("3.速度:VEL"), _("3.加速度:ACC"), _("3.温度:TEMP"),
            _("4.節点主応力Scalar:PRINC_NSTRESS"),
            _("4.節点主応力Vector:PRINCV_NSTRESS"),
            _("4.節点主ひずみScalar:PRINC_NSTRAIN"),
            _("4.節点主ひずみVector:PRINCV_NSTRAIN"),
            _("4.要素主応力Scalar:PRINC_ESTRESS"),
            _("4.要素主応力Vector:PRINCV_ESTRESS"),
            _("4.要素主ひずみScalar:PRINC_ESTRAIN"),
            _("4.要素主ひずみVector:PRINCV_ESTRAIN"),
            _("2.シェル表面:SHELL_SURFACE"),
            _("2.梁要素NQM:BEAM_NQM"),
            _("5.接触法線力:CONTACT_NFORCE"),
            _("5.接触摩擦力:CONTACT_FRICTION"),
            _("5.接触相対滑り速度:CONTACT_RELVEL"),
            _("5.接触状態:CONTACT_STATE")]
    return items

#defailtの出力item
def iniOutputItems():
    items = [_("1.変位:DISP"), _("1.節点応力:NSTRESS"),
         _("1.節点Mises応力:NMISES")]
    return items

#dynamicSolution
def defaultDynamicSolutionCont():
    #全6行、21ヶのデータ

    def getFirstNodeNo():
        nodeNo = 1
        for headerData in meshHeaderData:
            header = headerData[0]
            if header[:len("!NODE")].upper() == "!NODE":
                nodeNo = headerData[1][0][0]
                break
        ans = str(nodeNo)
        return ans

    nodeNo = getFirstNodeNo()
    data = ["11", "1",
            "0.0", "1.0", "500", "1e-5",
            "0.5", "0.25",
            "1", "1", "0.0", "0.0",
            "100", nodeNo, "1",
            "0", "0", "0", "0", "0", "0"]
    return data

#freqResponseSolution
def defaultFreqResponseSolutionCont():
    #全6行、21ヶのデータ
    data = ["11", "2",
            "14000", "16000", "20", "15000",
            "0.0", "6.6e-5",
            "1", "1", "0.0", "7.2e-7",
            "10", "2", "",
            "1", "0", "0", "0", "0", "0"]
    return data

#heatSolution
def defaultHeatSolutionCont():
    #data = ["0.0", "3600.0", "1.0", "20.0",      "20",             "1.0e-6"]
    data = ["0.0"]
    return data

#dynamicHeatSolution
def defaultDynamicHeatSolutionCont():
    #       DT      ETIME     DTmin  許容変化温度  非線形最大反復数  収束判定
    data = ["10.0", "3600.0", "1.0", "20.0",      "20",            "1.0e-6"]
    return data

#eigenSolution
def defaultEigenSolutionCont():
    #      固有値数　許容差　最大反復数
    data = ["5", "1e-8", "100"]
    return data

#autoIncrementStep
def defaultAutoIncStepData():
    #       DTIME, ETIME,  minTime,  maxTime
    data = ["0.1", "10.0", "0.0001",  "2.0"]
    return data

#autoincParam
def defaultAutoincParamLines():
    data  = ["0.50, 10, 50, 10, 1" + ls]
    data += ["1.41, 10, 50, 10, 1" + ls]
    data += ["0.50, 10" + ls]
    return data
#global変数に設定する
autoincParamData = defaultAutoincParamLines()

#要素タイプが板厚を必要としているタイプかどうか
def isThicknessElementType(elType):
    ans = False
    if elType[0] == "7":
        #「7」は、板厚要
        ans = True
    return ans

#要素タイプがbeamの設定値を必要としているかどうか
def isBeamElementType(elType):
    ans = False
    if elType[0] == "6":
        ans = True
    return ans

#回転の自由度を必要としている要素かどうか
def isRotationElementType(elType):
    ans = False
    if elType[0] == "7":
        #shell
        ans = True
    elif elType[0] == "6":
        #beam
        ans = True
    return ans


#  ---------
#  windowApp
#  ---------
#    GUIの起動
class windowApp:

    #
    #  GUIの初期化
    #
    def __init__(self):
        global GtkApp, builder, mainWindow
        builder = Gtk.Builder()                 #builderをglobal変数に設定
        #gladeファイル内翻訳のため、domainを定義
        #builder.set_translation_domain("easyistr")
        #gladeファイル読み込み
        builder.add_from_file("easyIstr_2.glade")
        mainWindow = builder.get_object("window1")
        mainWindow.connect("delete-event", self.close)
        builder.connect_signals(self)           #handlerのセット
        
        #属性のセット
        self.rootDir = os.getenv("HOME")
        self.clipboard = []
        self.NORMAL = Pango.Weight.NORMAL   #標準
        self.BOLD =   Pango.Weight.BOLD     #bold
        self.addTreeItemsSet = set([])      #追加Itemのflag
        self.readUnsetTreeItems()           #  読み込み
        #iconの定義
        iconDir = os.getenv("easyIstrPath") + os.sep + "icons"
        iconFile = GdkPixbuf.Pixbuf.new_from_file
        self.iconFolder = iconFile(iconDir + os.sep + "folder16.png")
        self.iconCase = iconFile(iconDir + os.sep + "x-office-document16.png")
        self.iconFolderLink = iconFile(iconDir + os.sep + "folderLink16.png")
        self.iconCaseLink = iconFile(iconDir + os.sep + "x-office-document_link16.png")
        self.iconFolderCk = iconFile(iconDir + os.sep + "folderCheck16.png")
        self.iconCaseCk = iconFile(iconDir + os.sep + "x-office-document_check16.png")
        self.iconFolderLinkCk =  iconFile(iconDir + os.sep + "folderLinkCheck16.png")
        self.iconCaseLinkCk = iconFile(iconDir + os.sep + "x-office-document_link_check16.png")
        self.iconServerFolder = iconFile(iconDir + os.sep + "serverFolder16.png")
        self.iconServerFolderCk = iconFile(iconDir + os.sep + "serverFolderCheck16.png")
        self.iconServerFolderLn = iconFile(iconDir + os.sep + "serverFolderLink16.png")
        self.iconServerFolderLnCk = iconFile(iconDir + os.sep + "serverFolderLinkCheck16.png")
        #eventMaskする
        self.maskEvent = True
        self.maskShowPage = False
        self.maskChangeCont = False
        #event発生したlistBox
        self.eventListBox = None
        #マウスでpickしたdata
        self.pickedData = []            #pickしたdata[actor, cells, nodes]
        self.pickedGrp = ""             #取得したgrp ("ngrp", "sgrp" or "egrp")
        #ctrlKeyのflag　0:noPress, 1:pressing
        self.ctrlKeyFlag = 0
        #timerEventの処理
        self.timerFlag = "run"
        self.threadFlag = "stop"
        self.threadClickFlag ="stop"
        self.threadShowTreeDir = ""
        self.threadCreateShowTreeDir = ""
        self.beforePath = Gtk.TreePath.new_from_indices([0]) #前回選択したpath
        self.beforeTreeItem = "FrontISTR analysis"           #前回選択したitemName
        self.maskSelectItem = False
        self.monitorFile = ""
        #vtk関連
        if vtkImportFlag == "yes":
            #vtkをimoprtした場合
            self.vtkSize = (300, 250)   #vtkWidowサイズ(x方向はgladeFile中のscrollWinの幅で設定)
            self.vtkObj = gtkVtk.GtkVtkRenderWindowInteractor(self)
            self.vtkConvProc = ""           #vtkMeshData作成のsubprocess名
            self.renderer = ""              #vtk表示用のrenderer（top表示）
            self.vtkInitialRun = True       #最初のvtk表示flag
            self.currActors = []            #表示中のactor名
            self.vtkFolder = "vtkMeshData"  #メッシュのvtkデータ保存folder
            self.actorDict = {}             #読み込んだ全actorの辞書
            self.subActorDict = {}          #elmから作成するactorの辞書
            self.selectedActors = []        #選択したactor        
            self.preSelectedActors = []     #事前選択したactor
            self.doublePickedActors = []    #doubleClickで選択したactor
            self.allElms = []               #全element
            self.hideElms = []              #隠す(非表示)element
            self.showModel = False          #制限時間内でモデル読込できた時：true
            self.hideVtkModelSW = "show"    #vtkModel非表示flag(show/hide)
            self.readerDict = {}            #vtkReader保存
            self.edgeReaderDict = {}        #edgeVtkReader保存
            self.surElmDataDict = {}        #表面要素が各grpに属するdata
            self.showMeshMode = "normal"    #meshの表示モード
            self.pickMode = "face"          #GROUP作成時のpick対象
            self.createdGrp = []            #GROUP作成時、取得した値を保存
            self.dummyCreatedGrp = []       #　↑　dummyNodeを保存
            self.pickedPoints = []          #pickしたpointId
            self.dummyPickedPoints = []     #pickしたdummyPointId
            self.pickedActorName = ""       #pickしたactorName
            self.pickedActors = []          #pickしたactorを保存
            self.recreateVtk = "yes"        #vtk再描画flag
            self.originAxes = None          #原点表示flag（原点actorの保存）
        else:
            #vtkがimportできなかった場合
            self.showModel = False
            self.vtkFolder = "vtkMeshData"  #メッシュのvtkデータ保存folder
        #mainWindowのwindowSizeを設定（やや広めで設定）
        #self.setWindowSize()
        #mainWindow.modify_font(Pango.FontDescription('courier new 11'))


    #
    #  GUIの表示
    #
    def main(self):
        initialize()
        checkTrueCurrDir()                      #trueCurrDir有無チェック
        clearBackupMeshFile()                   #backupしたmeshfileをクリアする
        checkSetIstrData()                      #currDir等をcheck(tempFolder,FistrModel_cnt再作成含む)
        checkLoadToTempOrNot()                  #"-ld"オプション（tempFolderにloadするしない）
        #checkCntNameInDatFile()                 #"-c"オプション（hecmw_ctrl内のcnt名を確認）
        getFistrCntFileNameFromDatFile()        #tempFolderからcntFile名を取得
        checkDatFileConts()                     #tempFolder内のdatFile内容をチェック修正
        edit = isTempCase_EditOrNoedit()        #tempFolder内の修正有無を確認
        writeStartFile("setting EasyISTR...")
        self.writeEasyIstrVersion()             #easyIstrのversionを書き込み
        self.setGtkObject()                     #GUI objectのnameを設定
        self.setWindowSize()                    #windowSizeを設定
        self.setHideVtkModelSW()                #vtk非表示設定
        self.createNotebookDict()               #notebook関連の辞書を作成
        writeStartFile("getting directories...")
        self.checkConnectingServer()            #server接続有無をcheck
        self.treeWidget = GtkParts.treeWidget(self.tree_dir)
        self.setFolderDirInTree()               #dirをTreeにセット
        writeStartFile("reading mesh data...")
        self.subInitialize()                    # cntのtreeを作成
        self.initCreateNgrpSgrpPage()           #createNgrpSgrpPageの初期化
        setTimeStampOfMshCntFiles(edit)         #起動時のtimeStampを確認し、書き込む
        self.checkDimensionMatCsv()             #単位をチェック
        self.setFrontISTRPage()                 #easyISTRの表紙をセット
        self.setTitle()                         #titleとバージョンを設定
        self.setVtkArea()                       #vtkAreaをセット
        self.setToolTip()                       #toolTipをセット
        GLib.timeout_add(5000, self.checkHddUsage) #5s間隔でHDDの使用状況確認timerをセット
        self.setShowLogInTextViewer()           #log表示の設定
        #GLib.timeout_add(1000, self.checkLogFile)   #logFileへのアクセスと表示
        self.setStatusBar()                     #statusBarに内容を表示
        writeStartFile("close")
        mainWindow.show_all()                   #GUI表示

        self.setUndefineToHideElms()            #self.hideElmsを設定
        self.setVtkModel()                      #vtkを表示
        self.scrlWin_treeDir.set_propagate_natural_width(True)
        Gtk.main()                              #loop

    #
    #  GUIの終了
    #
    def close(self, *args):
        self.timerFlag = "stop"     #timerEventを停止
        Gtk.main_quit(*args)
        self.writeUnsetTreeItems()

    #
    #  setWindowSize
    def setWindowSize(self):
        """ windowSizeを設定する"""
        #画面の設定
        x, y = 1300, 600
        winDict = pyFistr.readWindowSize()
        if "windowSize" in winDict.keys():
            cont = winDict["windowSize"]
            words = cont.split()
            x, y = list(map(int, words[:2]))
        mainWindow.set_default_size(x, y)
        #splitterの設定
        if "windowSize_splitter" in winDict.keys():
            cont = winDict["windowSize_splitter"]
            splitEasyistr, splitVtk = list(map(int, cont.split()[:2]))
            self.paned_easyistr.set_position(splitEasyistr)
            self.paned_vtk.set_position(splitVtk)

    #
    #  checkHddUsage
    #-----------------
    def checkHddUsage(self):
        """ HDDの使用状況をinterval間隔でcheckする。
        GLib.timeout_add()から呼び出される関数。
        戻り値がFalseならtimerは停止。Trueならtimer継続する。
        timerFlagが「run」の間はcheckし続ける"""
        if self.timerFlag == "run":
            workDir = getCurrDirFromTempFolder()
            if self.threadFlag != "run" and self.threadClickFlag != "run":
                self.threadFlag = "run"
                self.threadGetHddNumResults(workDir)
            return True     #timerEvent再発行
        else:
            return False    #timer停止

    #
    #  setShowLogInTextViewer
    #--------------------------
    def setShowLogInTextViewer(self):
        """ log表示の設定"""
        self.waitCount = 0
        #textViewを設定
        self.logBuffer = Gtk.TextBuffer.new(None)
        self.textView_log.set_buffer(self.logBuffer)
        #file openしてtimerEventを設定
        logFile = os.getenv("LogFile")
        self.logRead = open(logFile, encoding="utf-8")
        GLib.timeout_add(200, self.checkLogFile)

    #
    #  checkLogFile
    #---------------
    def checkLogFile(self):
        """ logFileを読み込みtextviewに表示するtimerEvent。"""
        addText = self.logRead.read()
        if addText != "":
            self.waitCount = 2
            #bufferに追加のlogをinsert
            self.logBuffer.insert(self.logBuffer.get_end_iter(), addText)
            #最終のiterを取得
            endIter = self.logBuffer.get_end_iter()
            #全行数を取得
            nLines = endIter.get_line()
            maxLines = 200
            if nLines > maxLines:
                #maxLineを超えている場合
                delStart = self.logBuffer.get_start_iter()
                delEnd = self.logBuffer.get_iter_at_line(nLines-maxLines+50)
                #bufferから削除
                self.logBuffer.delete(delStart, delEnd)
                endIter = self.logBuffer.get_end_iter()
        else:
            if self.waitCount > 0:
                #最終行を表示させる
                endIter = self.logBuffer.get_end_iter()
                self.textView_log.scroll_to_iter(endIter, 0, True, 0, 0)
                self.waitCount -= 1
        #Treeを再表示、選択表示させる。
        if self.threadShowTreeDir != "":
            #Treeを閉じて開く事でTreeを再表示
            parentDir = self.threadShowTreeDir[0]
            selDirs = self.threadShowTreeDir[1]
            #親dirを閉じて開く
            self.treeWidget.collapseChildDir(parentDir)
            self.treeWidget.expandChildDir(parentDir)
            #seiDirを選択表示させる
            self.treeWidget.unselectAllDir()
            for selDir in selDirs:
                self.treeWidget.selectDir(selDir)
            #flagをクリア応じ
            self.threadShowTreeDir = ""
        #Treeを再作成、表示、選択表示させる
        if self.threadCreateShowTreeDir != "":
            #TreeDataを再作成してTreeを再表示
            showDir = self.threadCreateShowTreeDir[0]
            folderConts = self.threadCreateShowTreeDir[1]
            #追加するfolderをtimerEventでdictに保存
            for folderCont in folderConts:
                self.treeWidget.dataDict[folderCont[0]] = folderCont[1:]
            #treeを再作成し、再表示
            self.createShowTreeViewAtNewFolderDict(showDir)
            #threadデータをクリア
            self.threadCreateShowTreeDir = ""
        return True

    #
    #  createShowTreeViewAtNewFolderDict
    def createShowTreeViewAtNewFolderDict(self, showDir):
        """ 新しいfolderDict(dataDict)を使って、treeを再作成する。
        tree再作成後、showDir以下の増えた子folderを
        を選択表示させる。"""
        #showDir内の子folder名を取得
        childNames = self.treeWidget.getChildNames(showDir)
        #Treeを再作成
        self.createTreeViewAtNewFolderDict(showDir)
        #選択表示させる
        newNames = self.treeWidget.getChildNames(showDir)
        selNames = list(set(newNames) - set(childNames))
        selNames.sort()
        for selName in selNames:
            selDir = showDir + os.sep + selName
            self.treeWidget.selectDir(selDir)

    #
    #  craeteTreeViewAtNewFolderDict
    #--------------------------------
    def createTreeViewAtNewFolderDict(self, showDir):
        """ 新しいfolderDict(dataDict)を使って、treeを再作成する。
        showDirとcurrDirまで展開する"""
        self.maskEvent = True
        #currDirを取得
        currDir = getCurrDirFromTempFolder()
        #treeを再作成
        #  folders作成
        folders = list(self.treeWidget.dataDict.keys())
        folders.sort()
        #  itemDict作成
        itemDict = self.createItemDict(folders)
        self.treeWidget.itemDict = itemDict
        #treeDataを作成
        treeData = self.treeWidget.createTreeData(itemDict)
        self.treeWidget.treeData = treeData
        #treeNodesを作成
        self.treeWidget.createTreeNodes()
        #currDir, showDirまで展開
        self.treeWidget.expandToCurrDir(currDir)
        self.treeWidget.expandChildDir(showDir)
        #currDirのiconと書体を設定する
        self.setSelectedDir(currDir)
        self.maskEvent = False

    #
    #  setGtkObject
    #    object名をセット（定義）
    def setGtkObject(self):
        #panedの定義
        self.paned_easyistr = builder.get_object("paned_easyistr")
        self.paned_vtk = builder.get_object("paned_vtk")
        #treeのmodelを定義
        self.treestore = Gtk.TreeStore(str)
        self.treestoreDir = Gtk.TreeStore(str)
        #listのmodelを定義
        self.listmodelCntFile = Gtk.ListStore(str)
        self.listmodelNoMat = Gtk.ListStore(str)
        self.listmodelDefMat = Gtk.ListStore(str)
        self.listmodelNoGroup = Gtk.ListStore(str)
        self.listmodelSetGroup = Gtk.ListStore(str)
        self.listmodelSetContact = Gtk.ListStore(str)
        self.listmodelStepNoCnd = Gtk.ListStore(str)
        self.listmodelStepSetCnd = Gtk.ListStore(str)
        self.listmodelSetAmp = Gtk.ListStore(str)
        self.listmodelAmpNoGrp = Gtk.ListStore(str)
        self.listmodelAmpSetGrp = Gtk.ListStore(str)
        #comboのmodelを定義
        self.listmodelAnaType = Gtk.ListStore(str)
        self.listmodelMatName = Gtk.ListStore(str)
        self.listmodelMatModel = Gtk.ListStore(str)
        self.listmodelMatType = Gtk.ListStore(str)
        self.listmodelMatHard = Gtk.ListStore(str)
        self.listmodelCntPair = Gtk.ListStore(str)
        self.listmodelCntSlave = Gtk.ListStore(str)
        self.listmodelCntMaster = Gtk.ListStore(str)
        self.listmodelCntIntr = Gtk.ListStore(str)
        self.listmodelStepType = Gtk.ListStore(str)
        self.listmodelSoldyType = Gtk.ListStore(str)
        self.listmodelSoldyEqn = Gtk.ListStore(str)
        self.listmodelSoldyGroup = Gtk.ListStore(str)
        self.listmodelSlinMethod = Gtk.ListStore(str)
        self.listmodelAmpValue = Gtk.ListStore(str)
        #labelのnameを定義
        self.label_title = builder.get_object("title")              #Top page
        self.versionLabel = builder.get_object("version")           #Top page
        self.label_datCont = builder.get_object("label_datCont")
        self.label_meshCnt = builder.get_object("meshCnt")          #FrontISTR page
        self.label_sourceFile = builder.get_object("label_sourceFile")
        self.label_sourceFileName = builder.get_object("label_sourceFileName")
        self.label_setMatGrp = builder.get_object("setMatGrp")      #材料物性値_sub page
        self.boundaryFrameTitle = builder.get_object("label43")     #setGroup page
        self.boundaryFrameLabel = builder.get_object("label44")     #setGroup page
        self.boundaryFrameNoset = builder.get_object("label45")     #setGroup page
        self.boundaryFrameSet = builder.get_object("label46")       #setGroup page
        self.boundaryGrpLabel = builder.get_object("label56")       #BOUNDARY_sub page
        self.cloadGrpLabel = builder.get_object("label59")          #CLOAD_sub page
        self.dloadGrpLabel = builder.get_object("label65")          #DLOAD_sub page
        self.vloadGrpLabel = builder.get_object("label69")          #VLOAD_sub page
        self.gravGrpLabel = builder.get_object("label75")           #GRAV_sub page
        self.centGrpLabel = builder.get_object("label81")           #CENT_sub page
        self.temperatureGrpLabel = builder.get_object("label93")    #TEMPERATURE_sub page
        self.floadGrpLabel = builder.get_object("label98")          #FLOAD_sub page
        self.contactGrpLabel = builder.get_object("label106")       #CONTACT_sub page
        self.label_stepName = builder.get_object("label118")        #step_sub page
        self.label_soldyTitle = builder.get_object("label134")      #solution_dyna page
        self.label_soldySEtime = builder.get_object("label138")     #solution_dyna page
        self.label_soldyDtime = builder.get_object("label140")      #solution_dyna page
        self.label_soldyGbeta = builder.get_object("label144")      #solution_dyna page
        self.label_soldyNewmark = builder.get_object("label146")    #solution_dyna page
        self.label_soldyGroup = builder.get_object("label150")      #solution_dyna page
        self.label_soldyOutdis = builder.get_object("label151")     #solution_dyna page
        self.label_fixtempGrp = builder.get_object("label182")      #FIXTEMP_sub page
        self.label_cfluxGrp = builder.get_object("label186")        #CFLUX_sub page
        self.label_dfluxGrp = builder.get_object("label_dfluxGrp")
        self.label_bfGrp = builder.get_object("label_bfGrp")        #DFLUX_sub page
        self.label_sfluxGrp = builder.get_object("label194")        #SFLUX_sub page
        self.label_sfilmGrp = builder.get_object("label198")        #SFILM_sub page
        self.label_sradiateGrp = builder.get_object("label203")     #SRADIATE_sub page
        self.label_soluDt = builder.get_object("label215")          #solution_heatDyna page
        self.label_soluEtime = builder.get_object("label216")       #solution_heatDyna page
        self.label_soluDtmin = builder.get_object("label217")       #solution_heatDyna page
        self.label_soluDeltmx = builder.get_object("label218")      #solution_heatDyna page
        self.label_ampTitle = builder.get_object("label223")        #AMPLITUDE page
        self.label_ampName = builder.get_object("label224")         #AMPLITUDE page
        self.label_ampGrpName = builder.get_object("label225")      #AMPLITUDE page
        self.label_ampMsg = builder.get_object("label226")          #AMPLITUDE page
        self.label_ampGrp = builder.get_object("label229")          #AMPLITUDE_sub page
        self.label_veloTitle = builder.get_object("label_title_p22")
        self.label_veloGrp = builder.get_object("label238")         #VELOCITY_sub
        self.label_acceTitle = builder.get_object("label_title_p23")
        self.label_accelGrp = builder.get_object("label242")        #ACCELARATION_sub
        self.label_tempHres = builder.get_object("label248")        #TEMPERATURE_sub
        self.label_springGrp = builder.get_object("label252")       #SPRING_sub page
        self.label_initialGrp = builder.get_object("label256")      #IITIAL_sub page
        self.label_soluCont = builder.get_object("label259")        #solutionType page
        self.label_Mx = builder.get_object("label278")              #CLOAD_sub page
        self.label_My = builder.get_object("label279")              #CLOAD_sub page
        self.label_Mz = builder.get_object("label280")              #CLOAD_sub page
        self.label_currDir = builder.get_object("label281")         #Top page
        self.label_DTIME = builder.get_object("label_DTIME") 
        self.label_ETIME = builder.get_object("label_ETIME")
        self.label_minDt = builder.get_object("label_minDT")
        self.label_maxDt = builder.get_object("label_maxDT")
        self.label_incCond = builder.get_object("label_incCond")
        self.label_decCond = builder.get_object("label_decCond")
        self.label_cutBackCond = builder.get_object("label_cutBackCond")
        self.label_incVal = builder.get_object("label_incVal")
        self.label_decVal = builder.get_object("label_decVal")
        self.label_cutbackVal = builder.get_object("label_cutBackVal")
        self.label_nRes = builder.get_object("label_nRes")
        self.label_fistrDir = builder.get_object("label_fistrDir")
        self.label_nCpu = builder.get_object("label_nCpu_p35")
        self.label_nThread = builder.get_object("label_nThread")
        self.label_otherAppSolve = builder.get_object("label_otherApp_pSolve")
        self.label_otherAppPost = builder.get_object("label_otherApp_pPost")
        self.label_statusBar = builder.get_object("label_statusBar")
        #textCtrlのnameを定義
        self.textCtrl_useCntFile = builder.get_object("entry2")     #FrontISTR page
        self.textCtrl_meshScale = builder.get_object("entry4")      #FistrModel page
        self.textCtrl_startFace = builder.get_object("entry_startFace")
        self.textCtrl_faceAngle = builder.get_object("entry_faceAngle")
        self.textCtrl_grpName = builder.get_object("entry_grpName")
        self.textCtrl_matDB = builder.get_object("entry5")          #材料物性値
        self.textCtrl_bndX = builder.get_object("entry6")           #BOUNDARY_sub page
        self.textCtrl_bndY = builder.get_object("entry7")           #BOUNDARY_sub page
        self.textCtrl_bndZ = builder.get_object("entry8")           #BOUNDARY_sub page
        self.textCtrl_cloadX = builder.get_object("entry9")         #CLOAD_sub page
        self.textCtrl_cloadY = builder.get_object("entry10")        #CLOAD_sub page
        self.textCtrl_cloadZ = builder.get_object("entry11")        #CLOAD_sub page
        self.textCtrl_dload = builder.get_object("entry12")         #DLOAD_sub page
        self.textCtrl_vloadBx = builder.get_object("entry13")       #VLOAD_sub page
        self.textCtrl_vloadBy = builder.get_object("entry14")       #VLOAD_sub page
        self.textCtrl_vloadBz = builder.get_object("entry15")       #VLOAD_sub page
        self.textCtrl_gravX = builder.get_object("entry16")         #GRAV_sub page
        self.textCtrl_gravY = builder.get_object("entry17")         #GRAV_sub page
        self.textCtrl_gravZ = builder.get_object("entry18")         #GRAV_sub page
        self.textCtrl_centOm = builder.get_object("entry19")        #CENT_sub page
        self.textCtrl_centPx = builder.get_object("entry20")        #CENT_sub page
        self.textCtrl_centPy = builder.get_object("entry21")        #CENT_sub page
        self.textCtrl_centPz = builder.get_object("entry22")        #CENT_sub page
        self.textCtrl_centDx = builder.get_object("entry23")        #CENT_sub page
        self.textCtrl_centDy = builder.get_object("entry24")        #CENT_sub page
        self.textCtrl_centDz = builder.get_object("entry25")        #CENT_sub page
        self.textCtrl_tempSet = builder.get_object("entry27")       #TEMPERATURE_sub page
        self.textCtrl_floadCase = builder.get_object("entry28")     #FLOAD_sub page
        self.textCtrl_floadX = builder.get_object("entry29")        #FLOAD_sub page
        self.textCtrl_floadY = builder.get_object("entry30")        #FLOAD_sub page
        self.textCtrl_floadZ = builder.get_object("entry31")        #FLOAD_sub page
        self.textCtrl_cntNtol = builder.get_object("entry32")       #contact_sub page
        self.textCtrl_cntTtol = builder.get_object("entry33")       #contact_sub page
        self.textCtrl_cntCoeff = builder.get_object("entry34")      #contact_sub page
        self.textCtrl_cntFact = builder.get_object("entry35")       #contact_sub page
        self.textCtrl_stepConv = builder.get_object("entry36")      #step_sub page
        self.textCtrl_stepSubStep = builder.get_object("entry37")   #step_sub page
        self.textCtrl_stepMaxIter = builder.get_object("entry38")   #step_sub page
        self.textCtrl_stepDtime = builder.get_object("entry39")     #step_sub page
        self.textCtrl_stepEtime = builder.get_object("entry40")     #step_sub page
        self.textCtrl_eigenNum = builder.get_object("entry41")      #solution_eigen page
        self.textCtrl_eigenPerm = builder.get_object("entry42")     #solution_eigen page
        self.textCtrl_eigenMaxiter = builder.get_object("entry43")  #solution_eigen page
        self.textCtrl_soldyStime = builder.get_object("entry44")    #solution_dyna page
        self.textCtrl_soldyEtime = builder.get_object("entry45")    #solution_dyna page
        self.textCtrl_soldyAllstep = builder.get_object("entry46")  #solution_dyna page
        self.textCtrl_soldyDtime = builder.get_object("entry47")    #solution_dyna page
        self.textCtrl_soldyOutfile = builder.get_object("entry48")  #solution_dyna page
        self.textCtrl_soldyGanma = builder.get_object("entry49")    #solution_dyna page
        self.textCtrl_soldyBeta = builder.get_object("entry50")     #solution_dyna page
        self.textCtrl_soldyRm = builder.get_object("entry51")       #solution_dyna page
        self.textCtrl_soldyRk = builder.get_object("entry52")       #solution_dyna page
        self.textCtrl_soldySample = builder.get_object("entry53")   #solution_dyna page
        self.textCtrl_soldyOutterm = builder.get_object("entry55")  #solution_dyna page
        self.textCtrl_solveNcpu = builder.get_object("entry54")     #solver page
        self.textCtrl_solveNthread = builder.get_object("entry_nThread")  #solver page
        self.textCtrl_solveFreq = builder.get_object("entry56")     #solver page
        self.textCtrl_slinPrecond = builder.get_object("entry58")   #solver_lin page
        self.textCtrl_slinNiter = builder.get_object("entry59")     #solver_lin page
        self.textCtrl_slinResid = builder.get_object("entry60")     #solver_lin page
        self.textCtrl_fixtemp = builder.get_object("entry61")       #FIXTEMP_sub
        self.textCtrl_cflux = builder.get_object("entry62")         #CFLUX_sub
        self.textCtrl_dflux = builder.get_object("entry_dflux")
        self.textCtrl_bf = builder.get_object("entry63")
        self.textCtrl_sflux = builder.get_object("entry64")         #SFLUX_sub
        self.textCtrl_sfilmAmb = builder.get_object("entry65")      #SFILM_sub
        self.textCtrl_sfilmVal = builder.get_object("entry66")      #SFILM_sub
        self.textCtrl_sradiateAmb = builder.get_object("entry67")   #SRADIATE_sub
        self.textCtrl_sradiateVal = builder.get_object("entry68")   #SRADIATE_sub
        self.textCtrl_hdynaDt = builder.get_object("entry69")       #solution_heatDyna page
        self.textCtrl_hdynaEtime = builder.get_object("entry70")    #solution_heatDyna page
        self.textCtrl_hdynaDtmin = builder.get_object("entry71")    #solution_heatDyna page
        self.textCtrl_hdynaDmax = builder.get_object("entry72")     #solution_heatDyna page
        self.textCtrl_hdynaItmax = builder.get_object("entry73")    #solution_heatDyna page
        self.textCtrl_hdynaEps = builder.get_object("entry74")      #solution_heatDyna page
        self.textCtrl_veloX = builder.get_object("entry75")         #VELOCITY_sub page
        self.textCtrl_veloY = builder.get_object("entry76")         #VELOCITY_sub page
        self.textCtrl_veloZ = builder.get_object("entry77")         #VELOCITY_sub page
        self.textCtrl_accelX = builder.get_object("entry78")        #ACCELARATION_sub page
        self.textCtrl_accelY = builder.get_object("entry79")        #ACCELARATION_sub page
        self.textCtrl_accelZ = builder.get_object("entry80")        #ACCELARATION_sub page
        self.textCtrl_tempReadR = builder.get_object("entry81")     #TEMPERATURE_sub page
        self.textCtrl_tempSstep = builder.get_object("entry82")     #TEMPERATURE_sub page
        self.textCtrl_tempInterval = builder.get_object("entry83")  #TEMPERATURE_sub page
        self.textCtrl_springX = builder.get_object("entry84")       #SPRING_sub page
        self.textCtrl_springY = builder.get_object("entry85")       #SPRING_sub page
        self.textCtrl_springZ = builder.get_object("entry86")       #SPRING_sub page
        self.textCtrl_springRX = builder.get_object("entry_springRotX") #SPRING_sub page
        self.textCtrl_springRY = builder.get_object("entry_springRotY") #SPRING_sub page
        self.textCtrl_springRZ = builder.get_object("entry_springRotZ") #SPRING_sub page
        self.textCtrl_initempTemp = builder.get_object("entry87")   #INITIAL_sub page
        self.textCtrl_Rx = builder.get_object("entry88")            #BOUNDARY_sub page
        self.textCtrl_Ry = builder.get_object("entry89")            #BOUNDARY_sub page
        self.textCtrl_Rz = builder.get_object("entry90")            #BOUNDARY_sub page
        self.textCtrl_tShell = builder.get_object("entry91")        #材料物性値_sub page
        self.textCtrl_nShell = builder.get_object("entry92")        #材料物性値_sub page
        self.textCtrl_beamVx = builder.get_object("entry93")        #材料物性値_sub page
        self.textCtrl_beamVy = builder.get_object("entry94")        #材料物性値_sub page
        self.textCtrl_beamVz = builder.get_object("entry95")        #材料物性値_sub page
        self.textCtrl_beamArea = builder.get_object("entry96")      #材料物性値_sub page
        self.textCtrl_beamIyy = builder.get_object("entry97")       #材料物性値_sub page
        self.textCtrl_beamIzz = builder.get_object("entry98")       #材料物性値_sub page
        self.textCtrl_beamJx = builder.get_object("entry99")        #材料物性値_sub page
        self.textCtrl_Mx = builder.get_object("entry100")           #CLOAD_sub page
        self.textCtrl_My = builder.get_object("entry101")           #CLOAD_sub page
        self.textCtrl_Mz = builder.get_object("entry102")           #CLOAD_sub page
        self.textCtrl_minDt = builder.get_object("entry_minDT")
        self.textCtrl_maxDt = builder.get_object("entry_maxDT")
        self.textCtrl_nRes = builder.get_object("entry_nRes")
        self.textCtrl_maxContIter = builder.get_object("entry_maxContIter")
        self.textCtrl_ptcFile = builder.get_object("entry_ptcFile")
        self.textCtrl_ptcCoeff = builder.get_object("entry_ptcCoeff")
        self.textCtrl_ptcShift = builder.get_object("entry_ptcShift")
        self.textCtrl_initemp = builder.get_object("entry_initemp")
        self.textCtrl_reftemp = builder.get_object("entry_reftemp")
        self.textCtrl_postNProcs = builder.get_object("entry_nProcs_post")
        #Treeのnameを定義
        self.tree_main = builder.get_object("treeview1")
        self.tree_dir = builder.get_object("tree_dir")
        self.listBox_cntFile = builder.get_object("treeview2")      #FrontISTR page
        self.listBox_noMat = builder.get_object("treeview3")        #材料物性値 page
        self.listBox_noMat.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_defMat = builder.get_object("treeview4")       #材料物性値 page
        self.listBox_defMat.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_noGroup = builder.get_object("treeview5")      #setGroup page
        self.listBox_noGroup.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_setGroup = builder.get_object("treeview6")     #setGroup page
        self.listBox_setGroup.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_setContact = builder.get_object("treeview7")   #contact page
        self.listBox_setContact.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_stepNoCnd = builder.get_object("treeview8")    #step_sub page
        self.listBox_stepNoCnd.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_stepSetCnd = builder.get_object("treeview9")   #step_sub page
        self.listBox_stepSetCnd.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_setAmp = builder.get_object("treeview10")      #AMPLITUDE page
        self.listBox_setAmp.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_ampNoGrp = builder.get_object("treeview11")    #AMPLITUDE_sub page
        self.listBox_ampNoGrp.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.listBox_ampSetGrp = builder.get_object("treeview12")   #AMPLITUDE_sub page
        self.listBox_ampSetGrp.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        listBox_eNgrp = builder.get_object("tree_eNgrp")
        #listBox_eNgrp.get_selection().connect("changed", self.onENgrpSelect)
        listBox_eSgrp = builder.get_object("tree_eSgrp")
        #listBox_eSgrp.get_selection().connect("changed", self.onESgrpSelect)
        listBox_eEgrp = builder.get_object("tree_eEgrp")
        #listBox_eEgrp.get_selection().connect("changed", self.onEEgrpSelect)
        self.treeList_eNgrp = GtkParts.treeList(listBox_eNgrp)
        self.treeList_eSgrp = GtkParts.treeList(listBox_eSgrp)
        self.treeList_eEgrp = GtkParts.treeList(listBox_eEgrp)
        self.treeList_eNgrp.create()
        self.treeList_eSgrp.create()
        self.treeList_eEgrp.create()
        #notebookのnameを定義
        self.notebook_main = builder.get_object("notebook1")
        self.notebook_folderLog = builder.get_object("note_folderLog")
        self.notebook_folderLog.set_current_page(1)
        #textViewを定義
        self.textView_log = builder.get_object("textView_log")
        #comboBoxのnameを定義
        self.comboBox_anaType = builder.get_object("combobox1")     #solutionType page
        comboBox_matName = builder.get_object("combobox2")          #材料物性値_sub page
        self.combo_matName = GtkParts.comboBox(comboBox_matName)
        comboBox_matModel = builder.get_object("combobox3")         #材料物性値_sub page
        self.combo_matModel = GtkParts.comboBox(comboBox_matModel)
        comboBox_matType = builder.get_object("combobox4")          #材料物性値_sub page
        self.combo_matType = GtkParts.comboBox(comboBox_matType)
        comboBox_matHard = builder.get_object("combobox5")          #材料物性値_sub page
        self.combo_matHard = GtkParts.comboBox(comboBox_matHard)
        self.comboBox_cntAlgo = builder.get_object("combobox6")     #contact page
        self.comboBox_cntSlave = builder.get_object("combobox7")    #contact_sub page
        self.comboBox_cntMaster = builder.get_object("combobox8")   #contact_sub page
        self.comboBox_cntIntr = builder.get_object("combobox9")     #contact_sub page
        self.comboBox_stepType = builder.get_object("combobox10")   #step_sub page
        self.comboBox_soldyType = builder.get_object("combobox11")  #solution_dyna page
        self.comboBox_soldyEqn = builder.get_object("combobox12")   #solution_dyna page
        self.comboBox_soldyGroup = builder.get_object("combobox13") #solution_dyna page
        self.comboBox_slinMethod = builder.get_object("combobox14") #solver_lin page
        self.comboBox_ampValue = builder.get_object("combobox15")   #AMPLITUDE_sub page
        comboBox_existGrpName = builder.get_object("combo_existGrpName")
        self.combo_existGrpName = GtkParts.comboBoxText(comboBox_existGrpName)
        comboBox_velType = builder.get_object("combo_velType")
        self.comboBox_velType = GtkParts.comboBox(comboBox_velType)
        comboBox_dflux = builder.get_object("combo_dflux")
        self.comboBox_dflux = GtkParts.comboBox(comboBox_dflux)
        comboBox_dimension = builder.get_object("combo_dimension")
        self.comboBox_dimension = GtkParts.comboBox(comboBox_dimension)
        #buttonのnameを定義
        self.button_datCont = builder.get_object("button_datCont") 
        self.button_ssData = builder.get_object("button20")         #材料物性値_sub page
        self.button_getZaxis = builder.get_object("button_getZaxis")
        self.button_calcSect = builder.get_object("button_calcSect")
        self.button_solveFistr = builder.get_object("button43")     #solver page
        self.button_plotMonitor = builder.get_object("button72")    #solver page
        self.button_editAutoinc = builder.get_object("button_editAutoincParam")
        self.button_resultMerge46 = builder.get_object("button_resultMerge46")
        self.button_convResult46 = builder.get_object("button_convResult46")
        self.button_convResult = builder.get_object("button_convResult")
        self.button_runParaView46 = builder.get_object("button_runParaView46")
        self.button_runParaView = builder.get_object("button_runParaView")
        self.button_clearAllBoundary = builder.get_object("button_clearAllBoundary")
        self.button_editGroupDelMesh = builder.get_object("button_eEgrpDelMesh")
        self.button_getNgrp = builder.get_object("button_getNgrp")
        self.button_getSgrp = builder.get_object("button_getSgrp")
        self.button_getEgrp = builder.get_object("button_getEgrp")
        self.button_getAllNgrp = builder.get_object("button_getAllNgrp")
        self.button_reloadDB = builder.get_object("button_onReloadDB")
        self.button_setPtc = builder.get_object("button_setPtc")
        self.button_pressOpenFoam = builder.get_object("button_pressOpenFoam")
        self.button_showPtcPress = builder.get_object("button_showPtcPress")
        #設定ボタン
        self.button_setGettingGroup = builder.get_object("button_setGettingGroup")
        self.button_setSolution = builder.get_object("button_setSolution")
        self.button_setDynamicSol = builder.get_object("button_setDynamicSol")
        self.button_setEigenSol = builder.get_object("button_setEigenSol")
        self.button_setHeatDyna = builder.get_object("button_setHeatDyna")
        self.button_setMaterial = builder.get_object("button_setMaterial")
        self.button_setMaterialToEgrp = builder.get_object("button_setMaterialToEgrp")
        self.button_setBCGroup = builder.get_object("button_setBCGroup")
        self.button_setBoundary = builder.get_object("button_setBoundary")
        self.button_setIniNGRP = builder.get_object("button_setIniNGRP")
        self.button_setReftemp = builder.get_object("button_setReftemp")
        self.button_setCload = builder.get_object("button_setCload")
        self.button_setDload = builder.get_object("button_setDload")
        self.button_setVload = builder.get_object("button_setVload")
        self.button_setGrav = builder.get_object("button_setGrav")
        self.button_setCent = builder.get_object("button_setCent")
        self.button_setTemperature = builder.get_object("button_setTemperature")
        self.button_setSpring = builder.get_object("button_setSpring")
        self.button_setContact = builder.get_object("button_setContact")
        self.button_setContactPair = builder.get_object("button_setContactPair")
        self.button_setFload = builder.get_object("button_setFload")
        self.button_setVelocity = builder.get_object("button_setVelocity")
        self.button_setAcceleration = builder.get_object("button_setAcceleration")
        self.button_setFixTemp = builder.get_object("button_setFixTemp")
        self.button_setCflux = builder.get_object("button_setCflux")
        self.button_setSflux = builder.get_object("button_setSflux")
        self.button_setDflux = builder.get_object("button_setDflux")
        self.button_setBf = builder.get_object("button_setBf")
        self.button_setSfilm = builder.get_object("button_setSfilm")
        self.button_setSradiate = builder.get_object("button_setSradiate")
        self.button_setAmplitude = builder.get_object("button_setAmplitude")
        self.button_setStepCont = builder.get_object("button_setStepCont")
        self.button_setAmpCont = builder.get_object("button_setAmpCont")
        self.button_setSolveMethod = builder.get_object("button_setSolveMethod")
        self.button_setSolverLn = builder.get_object("button_setSolverLn")
        self.button_separateMesh = builder.get_object("button_sepMesh_p35")
        self.button_convToInp = builder.get_object("button_convToInp")
        self.button_convToRad = builder.get_object("button_convToRad")
        self.button_convInpToVtu = builder.get_object("button_convInpToVtu")
        #radioButtonのnameを定義
        #self.radioBtn_unv2fistr = builder.get_object("radiobutton1")    #FistrModel page
        #self.radioBtn_abaqus2fistr = builder.get_object("radiobutton2") #FistrModel page
        self.radioBtn_nodeForce = builder.get_object("radiobutton3")    #CLOAD_sub page
        self.radioBtn_aveForce = builder.get_object("radiobutton4")     #CLOAD_sub page
        self.radioBtn_trueForce = builder.get_object("radiobutton5")    #CLOAD_sub page
        self.radioBtn_nodeQw = builder.get_object("radiobutton6")   #CFLUX_sub page
        self.radioBtn_aveQw = builder.get_object("radiobutton7")    #CFLUX_sub page
        self.radioBtn_trueQw = builder.get_object("radiobutton8")   #CFLUX_sub page
        self.radioBtn_pointToPoint = builder.get_object("radioBtn_pointToPoint")
        self.radioBtn_faceToFace = builder.get_object("radioBtn_faceToFace")
        self.radioBtn_pickFace = builder.get_object("radio_pickFace")
        self.radioBtn_pickEdge = builder.get_object("radio_pickEdge")
        self.radioBtn_pickPoints = builder.get_object("radio_pickPoints")
        self.radioBtn_newGrp = builder.get_object("radio_createNewGrp")
        self.radioBtn_existGrp = builder.get_object("radio_existGrp")
        self.radioBtn_addGrp = builder.get_object("radio_addGrp")
        self.radioBtn_subGrp = builder.get_object("radio_subtractGrp")
        self.radioBtn_useVtk = builder.get_object("radio_useVtk")
        self.radioBtn_useVtu = builder.get_object("radio_useVtu")
        self.radioBtn_pressUniform = builder.get_object("radio_pressUniform")
        self.radioBtn_pressDist = builder.get_object("radio_pressDist")
        #checkBoxのnameを定義
        self.checkBtn_bndX = builder.get_object("checkbutton1")     #BOUNDARY_sub page
        self.checkBtn_bndY = builder.get_object("checkbutton2")     #BOUNDARY_sub page
        self.checkBtn_bndZ = builder.get_object("checkbutton3")     #BOUNDARY_sub page
        self.checkBtn_soldyDis = builder.get_object("checkbutton4")     #solution_dyna page
        self.checkBtn_soldyVelo = builder.get_object("checkbutton5")    #solution_dyna page
        self.checkBtn_soldyAcc = builder.get_object("checkbutton6")     #solution_dyna page
        self.checkBtn_soldyForce = builder.get_object("checkbutton7")   #solution_dyna page
        self.checkBtn_soldyStrain = builder.get_object("checkbutton8")  #solution_dyna page
        self.checkBtn_soldyStress = builder.get_object("checkbutton9")  #solution_dyna page
        self.checkBtn_solvePara = builder.get_object("checkbutton10")   #solver page
        self.checkBtn_solveIlog = builder.get_object("checkbutton11")   #solver page
        self.checkBtn_solveTlog = builder.get_object("checkbutton12")   #solver page
        self.checkBtn_fistrVersion = builder.get_object("check_fistrVersion")   #solver page
        self.checkBtn_tempUseH = builder.get_object("checkbutton19")    #TEMPERATURE_sub
        self.checkBtn_solverRestart = builder.get_object("checkbutton20")   #solver
        self.checkBtn_springX = builder.get_object("checkbutton21")     #SPRING_sub
        self.checkBtn_springY = builder.get_object("checkbutton22")     #SPRING_sub
        self.checkBtn_springZ = builder.get_object("checkbutton23")     #SPRING_sub
        self.checkBtn_springRX = builder.get_object("check_springRotX") #SPRING_sub
        self.checkBtn_springRY = builder.get_object("check_springRotY") #SPRING_sub
        self.checkBtn_springRZ = builder.get_object("check_springRotZ") #SPRING_sub
        self.checkBtn_soluDt = builder.get_object("checkbutton24")      #solution_heatDyna
        self.checkBtn_Rx = builder.get_object("checkbutton25")      #Boundary_sub
        self.checkBtn_Ry = builder.get_object("checkbutton26")      #Boundary_sub
        self.checkBtn_Rz = builder.get_object("checkbutton27")      #Boundary_sub
        self.checkBtn_autoinc = builder.get_object("checkBtn_autoinc")
        #self.checkBtn_keepSetting = builder.get_object("checkBtn_keepSetting")  #mesh変換 page
        #self.checkBtn_addMesh = builder.get_object("check_addMesh")             #mesh変換 page
        self.checkBtn_set341elm = builder.get_object("check_set341elm")         #mesh変換 page
        self.checkBtn_Vx = builder.get_object("check_Vx")               #Velocity_sub
        self.checkBtn_Vy = builder.get_object("check_Vy")               #Velocity_sub
        self.checkBtn_Vz = builder.get_object("check_Vz")               #Velocity_sub
        self.checkBtn_Ax = builder.get_object("check_Ax")               #Acceleration_sub
        self.checkBtn_Ay = builder.get_object("check_Ay")               #Acceleration_sub
        self.checkBtn_Az = builder.get_object("check_Az")               #Acceleration_sub
        self.checkBtn_otherApp_pSolve = builder.get_object("check_otherApp_pSolve")
        self.checkBtn_otherApp_pPost = builder.get_object("check_otherApp_pPost")
        self.checkBtn_postPara = builder.get_object("check_parallel_post")      #post　page
        #vtk関連
        self.label_vtk = builder.get_object("label_vtk")
        self.button_resetCamera = builder.get_object("button_resetCamera")
        self.button_viewXP = builder.get_object("button_viewXP")
        self.button_viewXM = builder.get_object("button_viewXM")
        self.button_viewYP = builder.get_object("button_viewYP")
        self.button_viewYM = builder.get_object("button_viewYM")
        self.button_viewZP = builder.get_object("button_viewZP")
        self.button_viewZM = builder.get_object("button_viewZM")
        self.button_newReloadVtkMesh = builder.get_object("button_newReloadVtkMesh")
        self.button_reloadVtkMesh = builder.get_object("button_reloadVtkMesh")
        #self.button_rightToLeft = builder.get_object("button_rightToLeft")
        #self.button_rolling90 = builder.get_object("button_rolling90")
        self.button_showAllElms = builder.get_object("button_showAllElms")
        self.button_hideElms = builder.get_object("button_hideElms")
        self.box_vtk = builder.get_object("box_vtk")
        self.btn_setWorkFolder = builder.get_object("btn_setWorkFolder")
        self.frame_outer = builder.get_object("frame_outer")
        self.scrlWin_treeDir = builder.get_object("scrlWin_treeDir")
        self.check_showEdge = builder.get_object("check_showEdge")
        self.check_showEdge.set_active(True)
        self.check_opacity = builder.get_object("check_opacity")
        self.check_opacity.set_active(False)
        self.check_hideVtk = builder.get_object("check_hideVtk")
        self.check_hideVtk.set_active(False)
        self.check_showOriginAxes = builder.get_object("check_showOriginAxes")
        self.check_showOriginAxes.set_active(False)
        #scrlWinを設定
        self.scrlWin_dirLog = builder.get_object("scrlWin_dirLog")
        #treeListのeventを設定
        self.listBox_noMat.get_selection().connect("changed", self.onSelectUnsetEgrp)
        self.listBox_defMat.get_selection().connect("changed", self.onSelectSetEgrp)
        self.listBox_noGroup.get_selection().connect("changed", self.onSelectUnsetEachGrp)
        self.listBox_setGroup.get_selection().connect("changed", self.onSelectSetEachGrp)
        self.comboBox_cntSlave.connect("changed", self.onSelectSlaveGrp)
        self.comboBox_cntMaster.connect("changed", self.onSelectMasterGrp)
        #textCtrlに値をセット
        self.textCtrl_faceAngle.set_text("30")
        #eventの設定
        self.tree_dir.connect("key-press-event", self.onKeyPress)
        self.tree_dir.connect("key-release-event", self.onKeyRelease)
        #labelに文字をセット(国際化)
        self.setStringToMenu()
        self.setStringToPageName()
        self.setStringToButtons()
        self.setStringToVtk()
        self.setStringToDirLog()
        self.setStringToFirstPage()
        self.setStringToPages()

    #
    #  setStringToMenu
    def setStringToMenu(self):
        """ menuItemに文字を設定（国際化のため）"""
        #menu_file
        builder.get_object("menu_file").get_child().set_text(_("ファイル"))
        builder.get_object("menu_editUsingApp").get_child().set_text(_("設定内容の変更"))
        builder.get_object("menu_openWork").get_child().set_text(_("folder開く"))
        builder.get_object("menu_runTerm").get_child().set_text(_("端末起動"))
        builder.get_object("menu_close").get_child().set_text(_("閉じる"))
        builder.get_object("menu_openTemp").get_child().set_text(_("tempフォルダ開く"))
        builder.get_object("menu_saveToDir").get_child().set_text(_("保存 (temp -> dir)"))
        builder.get_object("menu_loadToTmp").get_child().set_text(_("読込 (dir -> temp)"))
        #menu_import
        builder.get_object("menu_import").get_child().set_text("import...")
        impDict = selectImportItemDDialog.importItemDict
        names = list(impDict.keys())
        builder.get_object("menu_cad").get_child().set_text(impDict[names[0]][0])
        builder.get_object("menu_unv2fistr").get_child().set_text(impDict[names[1]][0])
        builder.get_object("menu_abaqus2fistr").get_child().set_text(impDict[names[2]][0])
        builder.get_object("menu_resFrd2vtk").get_child().set_text(impDict[names[3]][0])
        builder.get_object("menu_readAbaqus").get_child().set_text(impDict[names[4]][0])
        builder.get_object("menu_readAnsys").get_child().set_text(impDict[names[5]][0])
        builder.get_object("menu_readAvsucd").get_child().set_text(impDict[names[6]][0])
        builder.get_object("menu_readExodus").get_child().set_text(impDict[names[7]][0])
        builder.get_object("menu_readGmsh").get_child().set_text(impDict[names[8]][0])
        builder.get_object("menu_readMdpa").get_child().set_text(impDict[names[9]][0])
        builder.get_object("menu_readMed").get_child().set_text(impDict[names[10]][0])
        builder.get_object("menu_readMedit").get_child().set_text(impDict[names[11]][0])
        builder.get_object("menu_readNastran").get_child().set_text(impDict[names[12]][0])
        builder.get_object("menu_readNetgen").get_child().set_text(impDict[names[13]][0])
        builder.get_object("menu_readPermas").get_child().set_text(impDict[names[14]][0])
        builder.get_object("menu_readVtk").get_child().set_text(impDict[names[15]][0])
        builder.get_object("menu_readVtu").get_child().set_text(impDict[names[16]][0])
        builder.get_object("menu_readXdmf").get_child().set_text(impDict[names[17]][0])
        #menu_export
        builder.get_object("menu_export").get_child().set_text("export...")
        expDict = selectExportItemDDialog.exportItemDict
        names = list(expDict.keys())
        builder.get_object("menu_fistr2abaqus").get_child().set_text(expDict[names[0]][0])
        builder.get_object("menu_fistr2rad").get_child().set_text(expDict[names[1]][0])
        builder.get_object("menu_writeAbaqus").get_child().set_text(expDict[names[2]][0])
        builder.get_object("menu_writeAnsys").get_child().set_text(expDict[names[3]][0])
        builder.get_object("menu_writeAvsucd").get_child().set_text(expDict[names[4]][0])
        builder.get_object("menu_writeExodus").get_child().set_text(expDict[names[5]][0])
        builder.get_object("menu_writeGmsh").get_child().set_text(expDict[names[6]][0])
        builder.get_object("menu_writeGmsh22").get_child().set_text(expDict[names[7]][0])
        builder.get_object("menu_writeMdpa").get_child().set_text(expDict[names[8]][0])
        builder.get_object("menu_writeMed").get_child().set_text(expDict[names[9]][0])
        builder.get_object("menu_writeMedit").get_child().set_text(expDict[names[10]][0])
        builder.get_object("menu_writeNastran").get_child().set_text(expDict[names[11]][0])
        builder.get_object("menu_writeNetgen").get_child().set_text(expDict[names[12]][0])
        builder.get_object("menu_writePermas").get_child().set_text(expDict[names[13]][0])
        builder.get_object("menu_writeVtk").get_child().set_text(expDict[names[14]][0])
        builder.get_object("menu_writeVtu").get_child().set_text(expDict[names[15]][0])
        builder.get_object("menu_writeXdmf").get_child().set_text(expDict[names[16]][0])
        #menu_edit
        builder.get_object("menu_edit").get_child().set_text(_("編集"))
        builder.get_object("menu_editCntMsh").get_child().set_text(_("cnt,mshファイル編集"))
        builder.get_object("menu_clearFolder").get_child().set_text(_("folderクリア"))
        builder.get_object("menu_initCntDat").get_child().set_text(_("cnt,datファイル初期化"))
        #menu_tool
        builder.get_object("menu_tool").get_child().set_text(_("ツール"))
        builder.get_object("menu_runCad").get_child().set_text(_("CAD起動"))
        builder.get_object("menu_runMesher").get_child().set_text(_("mesher起動"))
        builder.get_object("menu_runParaview").get_child().set_text(_("ParaView起動"))
        #menu_help
        builder.get_object("menu_help").get_child().set_text(_("ヘルプ"))
        builder.get_object("menu_showVersion").get_child().set_text(_("バージョン表示"))

    #
    #  setStringToPageName
    def setStringToPageName(self):
        """ pageNameに文字をセット（国際化）"""
        builder.get_object("page_material").set_text(_("材料物性値"))
        builder.get_object("page_material_sub").set_text(_("材料物性値_sub"))
        builder.get_object("page_boundaryCondition").set_text(_("境界条件"))

    #
    #  setStringToButtons
    def setStringToButtons(self):
        """ buttonのラベルに文字をセット（国際化）"""
        #欄外button
        builder.get_object("button_openWorkFolder").get_child().set_text(_("folder開く"))
        builder.get_object("button_openTempFolder").get_child().set_text(_("temp開く"))
        builder.get_object("button_editCntMesh").get_child().set_text(_("cnt,mshファイル編集"))
        builder.get_object("button_clearFolder").get_child().set_text(_("folderクリア"))
        builder.get_object("button_close").get_child().set_text(_("閉じる"))

    #
    #  setStringToVtk
    def setStringToVtk(self):
        """ vtk画面に文字をセット（国際化）"""
        self.label_vtk.set_text(_("model形状表示"))
        self.check_hideVtk.get_child().set_text(_("vtk非表示"))
        self.check_showEdge.get_child().set_text(_("edge表示"))
        self.check_opacity.get_child().set_text(_("透明化"))
        self.check_showOriginAxes.get_child().set_text(_("原点表示"))
        builder.get_object("label_moveWorkFolder_vtk").set_text(_("作業用folderの場所移動"))
        builder.get_object("button_reloadDir_vtk").set_label(_("dir再読込"))
        self.btn_setWorkFolder.set_label(_("選択dirを作業folderに設定"))

    #
    #  setStringToDirLog
    def setStringToDirLog(self):
        """ treeDirとlog表示に文字をセット"""
        builder.get_object("label_moveWorkFolder_pageTitle").set_text(_("workFolder移動"))
        builder.get_object("label_showLog_pageTitle").set_text(_("log表示"))
        builder.get_object("label_showLog_page2").set_text(_("log表示"))

    #
    #  setStringToFirstPage
    def setStringToFirstPage(self):
        """ 最初のpage（notebook以外）に文字をセット（国際化）"""
        builder.get_object("label_anaInWorkFolder_p0").set_text(_("作業folder内の解析"))
        builder.get_object("label_items_p0").set_text(_("設定項目"))

    #
    #  setStringToPages
    def setStringToPages(self):
        """ pageのラベルに文字をセット（国際化）"""
        #FrontISTR page
        self.button_datCont.get_child().set_text(_("defaultに戻す"))
        builder.get_object("label_workFolder").set_text(_("作業用folder"))
        builder.get_object("label_iniCntFile").set_text(_("cntファイルの初期化"))
        builder.get_object("label_usingContFile").set_text(_("使用するcntファイル"))
        builder.get_object("label_replaceCont").set_text(_("現在のcntファイル\nを置き換えて初期化する"))
        builder.get_object("label_allFiles").set_text(_(" 　全cntファイル　 "))
        builder.get_object("button_onSetUseContFile").get_child().set_text(_("選択>>"))
        builder.get_object("button_onCopyUseFile").get_child().set_text(_("cntファイル置き換え"))
        #FistrModel page
        builder.get_object("label_meshOperation").set_text(_("メッシュ操作"))
        builder.get_object("label_convertMesh").set_text(_("メッシュ"))
        builder.get_object("label_sourceFile").set_text(_("meshの元file:"))
        builder.get_object("label_changeScale").set_text(_("単位、スケール変更"))
        builder.get_object("label_dimension").set_text(_("単位:"))
        builder.get_object("label_magnification").set_text(_("倍率:"))
        builder.get_object("label_meshConts").set_text(_("メッシュ内容"))
        builder.get_object("label_createMeshCont").set_text(_("step, stp, brepファイルからmesh作成"))
        builder.get_object("label_convertMeshCont").set_text(_("unv, inpのmeshをfistr形式に変換"))
        builder.get_object("button_createMesh").get_child().set_text(_("CADデータからmesh作成..."))
        builder.get_object("button_convertMesh").get_child().set_text(_("他形式のmeshをimport..."))
        builder.get_object("button_onChangeMeshScale").get_child().set_text(_("倍率変更"))
        builder.get_object("button_onReformNgrp").get_child().set_text(_("NGRPの修正"))
        builder.get_object("button_onNodesBond").get_child().set_text(_("!EQUATIONで\n部品結合"))
        builder.get_object("button_onEditBeamElements").get_child().set_text(_("beam要素編集\n（pin接続）"))
        builder.get_object("button_onConfirmModelAtParaview").get_child().set_text(_("形状確認\n(paraView)"))
        builder.get_object("label_set341elm").set_text(_("要素の設定"))
        builder.get_object("check_set341elm").get_child().set_text(_("341要素:SELECTIVE_ESNS要素に設定（平滑化要素） ver5.5以降"))
        #createNgrpSgrp page
        builder.get_object("label_tile_createNgrpPage").set_text(_("node, surface, element groupの作成"))
        builder.get_object("label_createGrp_createNgrpPage").set_text(_("meshからGroup作成"))
        mess = _("pick modeを選択する。\nviewerのmeshをマウスでクリック、角度を入力。\n「NGRP取得」,「SGRP取得」or「EGRP取得」をクリックしてgroupを取得。")
        builder.get_object("label_createGrpMethod_createNgrpPage").set_text(mess)
        builder.get_object("label_pickThong_createNgrpPage").set_text(_("mouseでpickする対象"))
        builder.get_object("label_pickPlace_createNgrpPage").set_text(_("mouseでmeshをpickした場所"))
        builder.get_object("label_createGrpName_createNgrpPage").set_text(_("作成するgroup名"))
        builder.get_object("label_allNgrpConts").set_text(_("pickしたEGRP内の全nodeを取得"))
        builder.get_object("label_startPoint_createNgrpname").set_text(_("始点の位置:"))
        builder.get_object("label_abgle_createNgrpPage").set_text(_("角度:"))
        builder.get_object("label_getGrp_createNgrpPage").set_text(_("group取得"))
        builder.get_object("button_onClearGrpView").get_child().set_text(_("取得\nクリア"))
        builder.get_object("button_getNgrp").get_child().set_text(_("NGRP取得"))
        builder.get_object("button_getAllNgrp").get_child().set_text(_("全NGRP取得"))
        builder.get_object("button_getSgrp").get_child().set_text(_("SGRP取得"))
        builder.get_object("button_getEgrp").get_child().set_text(_("EGRP取得"))
        builder.get_object("label_getgrp_createNgrpPage").set_text(_("grpを取得"))
        mess = _("新規にgrpを作成する場合\n")
        mess += _("  「新規作成」を選択し、作成するgrp名を入力。\n")
        mess += _("既存のgrpに加算/減算する場合\n")
        mess += _("  「既存grp」を選択し、加算/減算するgrp名を選択、加算/減算を選択。")
        builder.get_object("label_createGrp_createNgrpPag").set_text(mess)
        builder.get_object("label_setGrp_createNgrpPage").set_text(_("取得したgrpの処理方法"))
        self.radioBtn_newGrp.get_child().set_text(_("新規作成"))
        self.radioBtn_existGrp.get_child().set_text(_("既存grp"))
        self.radioBtn_addGrp.get_child().set_text(_("加算する"))
        self.radioBtn_subGrp.get_child().set_text(_("減算する"))
        #editGroup page(page3)
        builder.get_object("label_title_p3").set_text(_("node, surface, element Groupの編集"))
        builder.get_object("label_editGrp_p3").set_text(_("groupの編集"))
        mess = _("NGRP, SGRP, EGRPの各group名を選択、ボタンをクリックして編集する。\nEGRPについては、「mesh削除」ボタンでEGRP名の該当メッシュを削除する。")
        builder.get_object("label_editMethod_p3").set_text(mess)
        builder.get_object("button_onEditGroupRename").get_child().set_text(_("grp名変更"))
        builder.get_object("button_onEditGroupDelete").get_child().set_text(_("grp名削除"))
        builder.get_object("button_eEgrpDelMesh").get_child().set_text(_("mesh削除"))
        #solutionType page(page4)
        builder.get_object("label_title_p4").set_text(_("解析の種類を設定"))
        builder.get_object("label_solType_p4").set_text(_("解析の種類"))
        #solution_eigen (page5)
        builder.get_object("label_title_p5").set_text(_("固有値解析の設定"))
        builder.get_object("label_settingConts_p5").set_text(_("設定内容"))
        builder.get_object("label_nEigen_p5").set_text(_("固有値の数"))
        builder.get_object("label_tolerance_p5").set_text(_("許容差"))
        builder.get_object("label_maxIter_p5").set_text(_("最大反復数"))
        #solution_dyna (page6)
        self.label_soldyTitle.set_text(_("動解析の設定"))
        builder.get_object("label_settingConts_p6").set_text(_("設定内容"))
        builder.get_object("label_motionEqn_p6").set_text(_("運動方程式"))
        builder.get_object("label_allSteps_p6").set_text(_("全step数"))
        builder.get_object("label_outInterval_p6").set_text(_("file出力間隔"))
        builder.get_object("label_param_p6").set_text(_("パラメータ"))
        builder.get_object("label_dampa_p6").set_text(_("Rayleigh減衰（α, β）"))
        builder.get_object("label_monitor_p6").set_text(_("モニタ出力指定"))
        builder.get_object("label_nSample_p6").set_text(_("sampling数"))
        builder.get_object("label_monitorConts_p6").set_text(_("モニタ内容"))
        self.checkBtn_soldyDis.get_child().set_text(_("変位"))
        self.checkBtn_soldyVelo.get_child().set_text(_("速度"))
        self.checkBtn_soldyAcc.get_child().set_text(_("加速度"))
        self.checkBtn_soldyForce.get_child().set_text(_("反力"))
        self.checkBtn_soldyStrain.get_child().set_text(_("ひずみ"))
        self.checkBtn_soldyStress.get_child().set_text(_("応力"))
        #solution_heatDyna (page7)
        builder.get_object("label_title_p7").set_text(_("熱伝導（動解析）の設定"))
        builder.get_object("label_settingConts_p7").set_text(_("設定内容"))
        self.checkBtn_soluDt.get_child().set_text(_("時間増分を固定して計算する"))
        self.label_soluDt.set_text(_("初期時間増分"))
        self.label_soluEtime.set_text(_("計算時間"))
        self.label_soluDtmin.set_text(_("最小時間増分"))
        self.label_soluDeltmx.set_text(_("許容変化温度"))
        builder.get_object("label_nlMaxIter_p7").set_text(_("非線形最大反復数"))
        builder.get_object("label_judgeValue_p7").set_text(_("収束判定値"))
        #page_material (page8)
        builder.get_object("label_title_p8").set_text(_("材料物性値の設定"))
        builder.get_object("label_setMatDB_p8").set_text(_("材料DBの設定"))
        builder.get_object("label_matDB_p8").set_text(_("材料DB（mat.csv）"))
        builder.get_object("button_onSetMaterialDB").get_child().set_text(_("参照..."))
        builder.get_object("button_onOpenDB").get_child().set_text(_("DB開く"))
        self.button_reloadDB.get_child().set_text(_("DB再読込"))
        builder.get_object("label_setMaterial_p8").set_text(_("材料を設定"))
        builder.get_object("label_groupName_p8").set_text(_("group名:"))
        builder.get_object("label_setGroupName_p8").set_text(_("物性値を定義するgroup"))
        #page_material_sub (page9)
        builder.get_object("label_title_p9").set_text(_("材料物性値の設定"))
        self.label_setMatGrp.set_text(_("elgroup名:"))
        builder.get_object("label_matData_p9").set_text(_("材料物性値"))
        builder.get_object("label_matName_p9").set_text(_("材料名:"))
        builder.get_object("button_onShowMaterialData").get_child().set_text(_("物性値の確認"))
        builder.get_object("button_onOpenMaterialData").get_child().set_text(_("DB編集"))
        builder.get_object("label_matModel_p9").set_text(_("材料モデル"))
        builder.get_object("label_creepType_p9").set_text(_("降伏条件/タイプ"))
        builder.get_object("label_yieldData_p9").set_text(_("非線形data"))
        self.button_ssData.get_child().set_text(_("SS_data\n作成・編集"))
        builder.get_object("label_hardness_p9").set_text(_("硬化則"))
        builder.get_object("label_shell_p9").set_text(_("板厚の設定（shell）"))
        builder.get_object("label_thickness_p9").set_text(_("板厚:"))
        builder.get_object("label_integPoints_p9").set_text(_("厚さ方向積分点数:"))
        builder.get_object("label_crossSection_p9").set_text(_("断面形状の設定（beam）"))
        self.button_getZaxis.get_child().set_text(_("軸方向取得"))
        self.button_calcSect.get_child().set_text(_("断面積等の定数を計算・取得"))
        builder.get_object("label_refZaxis_p9").set_text(_("参考z軸方向"))
        builder.get_object("label_area_p9").set_text(_("断面積"))
        builder.get_object("label_crossMoment_p9").set_text(_("断面2次モーメント"))
        builder.get_object("label_nejiri_p9").set_text(_("ねじり定数"))
        #page_boundaryConditions (page10)
        builder.get_object("label_title_p10").set_text(_("境界条件の設定"))
        builder.get_object("label_clearBoundaryCond_p10").set_text(_("境界条件のクリア"))
        mess = _("全ての境界条件設定をクリアする。\n（mshファイルに含まれる初期値、接触ペア、AMPLITUDEを含む）")
        builder.get_object("label_clearConts_p10").set_text(mess)
        self.button_clearAllBoundary.get_child().set_text(_("全境界条件クリア"))
        #setGroup page (page11)
        self.boundaryFrameTitle.set_text(_("境界条件の設定"))
        self.boundaryFrameSet.set_text(_("設定するgroup"))
        builder.get_object("button_onSetBCGroup").get_child().set_text(_("選択>>"))
        builder.get_object("button_onReturnBCGroup").get_child().set_text(_("<<戻す"))
        #contact page (page12)
        builder.get_object("label_title_p12").set_text(_("境界条件の設定"))
        builder.get_object("label_defineContact_p12").set_text(_("contactの定義"))
        builder.get_object("label_algo_p12").set_text(_("Algorithmの設定"))
        builder.get_object("label_setContact_p12").set_text(_("contactの設定"))
        builder.get_object("label_setPairName_p12").set_text(_("設定するcontactPair名　"))
        builder.get_object("label_conactConts_p12").set_text(_("contactの設定を\n「追加>>」ボタンで追加。\n「<<削除」ボタンで削除。"))
        builder.get_object("button_onAddContact").get_child().set_text(_("追加>>"))
        builder.get_object("button_onDeleteContact").get_child().set_text(_("<<削除"))
        #boundary_sub page (page13)
        builder.get_object("label_title_p13").set_text(_("BOUNDARY（節点の変位拘束）の設定"))
        self.boundaryGrpLabel.set_text(_("group名:"))
        builder.get_object("label_disp_p13").set_text(_("変位"))
        builder.get_object("label_rotation_p13").set_text(_("回転角"))
        #CLOAD_sub page (page14)
        builder.get_object("label_title_p14").set_text(_("CLOAD（集中荷重）の設定"))
        self.cloadGrpLabel.set_text(_("nodeGroup名:"))
        builder.get_object("label_loadType_p14").set_text(_("集中荷重の種類"))
        self.radioBtn_nodeForce.get_child().set_text(_("節点あたりの荷重（入力値をそのまま節点にセット）"))
        self.radioBtn_aveForce.get_child().set_text(_("トータル荷重（入力値/節点数 を節点にセット）"))
        self.radioBtn_trueForce.get_child().set_text(_("等分布トータル荷重（等分布荷重となる値を節点にセット）"))
        builder.get_object("label_load_p14").set_text(_("荷重"))
        builder.get_object("lamel_moment_p14").set_text(_("モーメント"))
        #DLOAD_sub page (page15)
        builder.get_object("label_title_p15").set_text(_("DLOAD（面荷重）の設定"))
        self.dloadGrpLabel.set_text(_("surfaceGroup名:"))
        builder.get_object("label_pres_p15").set_text(_("圧力"))
        builder.get_object("label_pressType_p15").set_label(_("圧力の種類"))
        self.button_setPtc.set_label(_("参照..."))
        self.button_pressOpenFoam.set_label(_("点群作成_OpenFOAM"))
        builder.get_object("label_explaneOpenFoam_p15").set_label(_("計算結果を点群fileに変換"))
        builder.get_object("label_ptcFile_p15").set_label(_("点群file"))
        builder.get_object("label_explaneCoeff_p15").set_label(_("点群fileの値に係数を乗じて設定する"))
        builder.get_object("label_dload_explainShift").set_label(_("点群fileの値に加算して設定する"))        
        self.radioBtn_pressUniform.get_child().set_label(_("均一な圧力"))
        self.radioBtn_pressDist.get_child().set_label(_("分布圧力（外部データ:点群fileから設定）"))
        self.button_showPtcPress.get_child().set_label(_("分布圧力確認"))
        #VLOAD_sub page (page16)
        builder.get_object("label_title_p16").set_text(_("VLOAD（体積力）の設定"))
        self.vloadGrpLabel.set_text(_("elGroup名:"))
        #GRAV_sub page (page17)
        builder.get_object("label_title_p17").set_text(_("GRAV（重力）の設定"))
        self.gravGrpLabel.set_text(_("elGoup名:"))
        #CENT_sub page (page18)
        builder.get_object("label_title_p18").set_text(_("CENT（遠心力）の設定"))
        self.centGrpLabel.set_text(_("elGroup名:"))
        builder.get_object("label_omega_p18").set_text(_("角速度 "))
        builder.get_object("label_locVector_p18").set_text(_("位置ベクトル（中心座座標）"))
        builder.get_object("label_dirVector_p18").set_text(_("方向ベクトル（回転軸）"))
        #TEMPERATURE_sub page (page19)
        builder.get_object("label_title_p19").set_text(_("TEMPERATURE（温度）の設定"))
        self.temperatureGrpLabel.set_text(_("nodeGroup名:"))
        builder.get_object("label_iniTemp_p19").set_text(_("「参照温度」とセットで熱伸縮を計算する"))
        builder.get_object("label_settingConts_p19").set_text(_("設定温度"))
        self.checkBtn_tempUseH.get_child().set_text(_("熱伝導解析結果を使う"))
        builder.get_object("label_setTemp_p19").set_text(_("各nodeに設定する温度"))
        builder.get_object("label_allSteps_p19").set_text(_("熱解析結果の全step数"))
        builder.get_object("label_startStepNo_p19").set_text(_("熱解析結果の計算開始stepNo"))
        builder.get_object("label_writeInterval_p19").set_text(_("熱解析結果の読み込み間隔"))
        #SPRING_sub page (page20)
        #builder.get_object("label_title_p20").set_text(_("SPRING（バネ要素）の設定"))
        builder.get_object("label_title_p20").set_text(_("SPRING（バネ境界）の設定"))
        self.label_springGrp.set_text(_("nodeGroup名:"))
        builder.get_object("label_disp_p20").set_text(_("変位のバネ定数"))
        builder.get_object("label_rotation_p20").set_text(_("回転のバネ定数"))
        #FLOAD_sub page (page21)
        builder.get_object("label_title_p21").set_text(_("FLOAD（周期荷重）の設定"))
        self.floadGrpLabel.set_text(_("nodeGroup名:"))
        builder.get_object("label_realImage_p21").set_text(_("1（実部）or 2（虚部）"))
        #VELOCITY_sub page (page22)
        self.label_veloTitle.set_text(_("VELOCITY（速度）の設定"))
        self.label_veloGrp.set_text(_("nodeGroup名:"))
        builder.get_object("label_velType").set_text(_("初期速度のみ与える場合は、「INITIAL」を選択"))
        #ACCELERATION_sub page (page23)
        self.label_acceTitle.set_text(_("ACCELERATION（加速度）の設定"))
        self.label_accelGrp.set_text(_("nodeGroup名:"))
        #contact_sub page (page24)
        builder.get_object("label_title_p24").set_text(_("CONTACT（接触）の設定"))
        self.contactGrpLabel.set_text(_("contactPair名:"))
        self.radioBtn_pointToPoint.get_child().set_text(_("点-面 接触 (slave-master)"))
        self.radioBtn_faceToFace.get_child().set_text(_("面-面 接触"))
        builder.get_object("label_setContactPair_p24").set_text(_("contactPairの設定"))
        builder.get_object("label_contactCond_p24").set_text(_("contactの条件"))
        builder.get_object("label_normalVal_p24").set_text(_("法線方向しきい値"))
        builder.get_object("label_contacVal_p24").set_text(_("接線方向しきい値"))
        builder.get_object("label_fric_p24").set_text(_("摩擦係数"))
        builder.get_object("label_penalty_p24").set_text(_("摩擦のペナルティ剛性"))
        #initial_sub page (page25)
        builder.get_object("label_title_p25").set_text(_("INITEMP（初期温度）の設定"))
        self.label_initialGrp.set_text(_("nodeGroup名:"))
        builder.get_object("label_iniTemp_p25").set_text(_("初期温度"))
        builder.get_object("label_iniTempConts_p25").set_text(_("mshFileに「!INITIAL CONDITION」として設定"))
        #REFTEMP_sub (page26)
        builder.get_object("label_titleReftemp").set_text(_("参照温度の設定"))
        builder.get_object("label_frameReftemp").set_text(_("参照温度"))
        mess  = _("応力ゼロ、歪ゼロ状態の温度") + ls
        mess += _("初期温度設定時は、初期温度と同じ値に設定")
        builder.get_object("label_reftempCont").set_text(mess)
        #FIXTEMP_sub page (page26)
        builder.get_object("label_title_p26").set_text(_("FIXTEMP（熱:温度固定）の設定"))
        self.label_fixtempGrp.set_text(_("nodeGroup名:"))
        builder.get_object("label_temperature_p26").set_text(_("温度"))
        #CFLUX_sub page (page27)
        builder.get_object("label_title_p27").set_text(_("CFLUX（集中熱量）の設定"))
        self.label_cfluxGrp.set_text(_("nodeGroup名:"))
        builder.get_object("label_heatType_p27").set_text(_("セットする集中熱量の種類"))
        self.radioBtn_nodeQw.get_child().set_text(_("節点当たりの熱量（入力値をそのまま節点にセット）"))
        self.radioBtn_aveQw.get_child().set_text(_("トータル熱量（入力値/節点数 を節点にセット）"))
        self.radioBtn_trueQw.get_child().set_text(_("等分布トータル熱量（等分布熱量となる値を節点にセット）"))
        builder.get_object("label_heat_p27").set_text(_("集中熱量"))
        #SFLUX_sub page (page28)
        builder.get_object("label_title_p28").set_text(_("SFLUX（面熱流束）の設定"))
        self.label_sfluxGrp.set_text(_("surfaceGroup名:"))
        builder.get_object("label_heat_p28").set_text(_("面熱流束"))
        #DFLUX_sub page
        builder.get_object("label_title_dflux").set_text(_("DFLUX（個別の面熱流束）"))
        builder.get_object("labal_dflux_faceNo").set_text(_("面番号"))
        builder.get_object("label_dflux_heatFlux").set_text(_("熱流束"))
        builder.get_object("label_dflux_explain").set_text(_("faceを構成する各要素の面番号に値を設定する"))
        #BF_sub page (page29)
        builder.get_object("label_title_p29").set_text(_("BF（内部発熱）の設定"))
        self.label_bfGrp.set_text(_("elGroup名:"))
        builder.get_object("label_heat_p29").set_text(_("発熱量"))
        #SFILM_sub page (page30)
        builder.get_object("label_title_p30").set_text(_("SFILM（熱伝達率）の設定"))
        self.label_sfilmGrp.set_text(_("surfaceGroup名:"))
        builder.get_object("label_ambTemp_p30").set_text(_("雰囲気温度"))
        builder.get_object("label_cond_p30").set_text(_("熱伝達率"))
        #SRADIATE_sub page (page31)
        builder.get_object("label_title_p31").set_text(_("SRADIATE（輻射）の設定"))
        self.label_sradiateGrp.set_text(_("surfaceGroup名:"))
        builder.get_object("label_ambTemp_p31").set_text(_("雰囲気温度"))
        builder.get_object("label_radi_p31").set_text(_("輻射係数"))
        #step_sub page (page32)
        builder.get_object("label_title_p32").set_text(_("ステップ解析の設定"))
        self.checkBtn_autoinc.get_child().set_text(_("自動時間増分を使う（動解析では使えません）"))
        self.label_incCond.set_text(_("時間幅減少条件: "))
        self.label_decCond.set_text(_("時間幅増加条件: "))
        self.label_cutBackCond.set_text(_("cutBack条件: "))
        self.label_nRes.set_text(_("step内の計算結果保存個数（等間隔）"))
        self.button_editAutoinc.get_child().set_text(_("編集..."))
        builder.get_object("label_stepCond_p32").set_text(_("step解析する境界条件"))
        builder.get_object("label_unsetGrps_p32").set_text(_("このstepまでの境界条件"))
        builder.get_object("label_setGrps_p32").set_text(_("設定する境界条件"))
        builder.get_object("button_setBC_p32").get_child().set_text(_("選択>>"))
        builder.get_object("button_onReturn_p32").get_child().set_text(_("<<戻す"))
        #AMPLITUDE page (page33)
        self.label_ampTitle.set_text(_("時間変化（AMPLITUDE）の設定"))
        self.label_ampName.set_text(_("設定内容"))
        self.label_ampMsg.set_text(_("amplitude定義を\n「追加>>」ボタンで追加。\n「<<削除」ボタンで削除。"))
        self.label_ampGrpName.set_text(_("設定するamp名"))
        builder.get_object("button_addAmp_p33").get_child().set_text(_("追加>>"))
        builder.get_object("button_returnAmp_p33").get_child().set_text(_("<<削除"))
        #AMPLITUDE_sub page (page34)
        builder.get_object("label_title_p34").set_text(_("時間変化（AMPLITUDE）の設定"))
        self.label_ampGrp.set_text(_("amp名:"))
        builder.get_object("label_explainAmp_p34").set_text(_("境界条件に時間変化を与えるためのデータを作成する"))
        builder.get_object("button_onEditAmpData").get_child().set_text(_("data作成・編集"))
        builder.get_object("label_currentCond_p34").set_text(_("現在の境界条件"))
        builder.get_object("label_setCond_p34").set_text(_("時間変化させる境界条件"))
        builder.get_object("button_setAmp_p34").get_child().set_text(_("選択>>"))
        builder.get_object("button_returnAmp_p34").get_child().set_text(_("<<戻す"))
        builder.get_object("label_selectAmpCond").set_text(_("時間変化させる境界条件を選択"))
        builder.get_object("label_setAmpData").set_text(_("時間変化のデータ"))
        builder.get_object("button_renameAmplitude").get_child().set_text(_("amp名の変更..."))
        #solver page (page35)
        builder.get_object("label_title_p35").set_text(_("solverの設定"))
        builder.get_object("label_setPara_p35").set_text(_("process並列の設定"))
        self.checkBtn_solvePara.get_child().set_text(_("並列計算する"))
        self.label_nCpu.set_text(_("並列数:"))
        self.label_nThread.set_text(_("thread数:"))
        self.button_separateMesh.get_child().set_text(_("メッシュ分割"))
        builder.get_object("label_exec_p35").set_text(_("実行（シングル、並列処理共）"))
        self.checkBtn_solveIlog.get_child().set_text(_("iterationLog出力"))
        self.checkBtn_solveTlog.get_child().set_text(_("timeLog出力"))
        builder.get_object("label_resInterval_p35").set_text(_("結果出力頻度"))
        builder.get_object("label_restart_p35").set_text(_("restartの制御:"))
        self.checkBtn_solverRestart.get_child().set_text(_("途中stepから開始する"))
        builder.get_object("label_execFileDir_p35").set_text(_("実行ファイル場所:"))
        builder.get_object("label_execFile_p35").set_text(_("実行ファイル ver:"))
        self.checkBtn_fistrVersion.get_child().set_text(_("ver4.6以前 (FrontISTRのversion)"))
        builder.get_object("label_threadRun_p35").set_text(_("thread並列の設定"))
        self.button_plotMonitor.get_child().set_text(_("step状況表示\n(plotStepMonitor)"))
        #solver_lin page (page36)
        builder.get_object("label_title_p36").set_text(_("線形solverの設定"))
        builder.get_object("label_linSolver_p36").set_text(_("線形solver"))
        builder.get_object("label_kaiho_p36").set_text(_("解法"))
        builder.get_object("label_preCond_p36").set_text(_("前処理手法  1,2:SSOR 3:Diag 5:AMG"))
        builder.get_object("label_iter_p36").set_text(_("反復回数"))
        builder.get_object("label_residual_p36").set_text(_("打ち切り誤差"))
        #post page (page37)
        builder.get_object("label_title_p37").set_text(_("post処理"))
        builder.get_object("label_paraFrame_post").set_text(_("ファイル変換の並列処理"))
        builder.get_object("check_parallel_post").set_label(_("並列処理する"))
        builder.get_object("label_nProcs_post").set_text(_("並列数:"))
        mess = _("多数の変換fileが存在する場合、複数fileを並列処理する。")
        builder.get_object("label_paraCont1_post").set_label(mess)
        mess = _("並列計算結果の場合、並列でfile変換する。（ver 5以降）")
        builder.get_object("label_paraCont2_post").set_label(mess)
        self.checkBtn_otherApp_pSolve.get_child().set_text(_("他アプリとの連携（設定内容を他アプリ用に変換）"))
        self.button_convToInp.get_child().set_text(_("Calculixの inp に変換..."))
        self.button_convToRad.get_child().set_text(_("OpenRadiossの rad に変換..."))
        self.button_convInpToVtu.get_child().set_text(_("Calculixの結果をvtu変換..."))
        builder.get_object("label_visualParaview_p37").set_label(_("ParaViewによる可視化"))
        self.checkBtn_otherApp_pPost.get_child().set_text(_("他アプリとの連携（他アプリの計算結果をvtuに変換）"))
        self.radioBtn_useVtk.set_label(_("resファイルをvtkに変換"))
        self.radioBtn_useVtu.set_label(_("FrontISTRが出力したvtuをそのまま使用"))
        self.radioBtn_useVtu.set_active(True)
        builder.get_object("label_mergeMethod_p37").set_text(_("並列処理の計算結果をmergeする"))
        self.button_convResult46.get_child().set_text(_("データ変換"))
        builder.get_object("label_under46Conts_p37").set_text(_("FrontISTRが出力したresファイルをLegacy vtkに変換"))
        self.button_runParaView46.get_child().set_text(_("ParaView起動"))
        builder.get_object("label_legParaview_p37").set_text(_("legacy vtkをParaViewで開く"))
        builder.get_object("label_fistr5_p37").set_text(_("FrontISTR-5 以降"))
        self.button_convResult.get_child().set_text(_("eGrp追加"))
        mess = _("elementGroupをvtuファイルに追加\nDISPLACEMENTから回転を削除（shell, beamは、回転含む）")
        builder.get_object("label_convVtu_p37").set_text(mess)
        mess = _("xml vtuをParaViewで開く")
        builder.get_object("label_xmlParaview_p37").set_text(mess)
        self.button_runParaView.get_child().set_text(_("ParaView起動"))
        #initial page
        builder.get_object("label_initialTitle").set_text(_("初期値の設定"))
        mess  = _("!INITIAL CONDITION を設定する。") + ls
        mess += _("mshファイル内に定義される。") 
        builder.get_object("label_initialCont").set_text(mess)

    #
    #  setHideVtkModelSW
    def setHideVtkModelSW(self):
        """ vtk非表示設定"""
        global istrData
        for line in istrData:
            items = line.split()
            if items[0] == "hideVtkModelSW":
                if items[1] == "hide":
                    self.hideVtkModelSW = "hide"
                    self.check_hideVtk.set_active(True)
                else:
                    self.hideVtkModelSW = "show"
                    self.check_hideVtk.set_active(False)

    #
    #  createNotebookDict
    def createNotebookDict(self):
        """ notebook関連の辞書を作成。
        page名からpage内の設定buttonを取得する。"""
        self.pageToSetButtonDict = {
            #pageName           setButtonName
            "FrontISTR":        "",
            "FistrModel":       "",
            "createNgrpSgrp":   self.button_setGettingGroup,
            "editGroup":        "",
            "solutionType":     self.button_setSolution,
            "solution_eigen":   self.button_setEigenSol,
            "solution_dyna":    self.button_setDynamicSol,
            "solution_heatDyna":self.button_setHeatDyna,
            _("材料物性値"):    self.button_setMaterial,
            _("材料物性値_sub"):self.button_setMaterialToEgrp,
            _("境界条件"):      "",
            "setGroup":         self.button_setBCGroup,
            "contact":          self.button_setContact,
            "BOUNDARY_sub":     self.button_setBoundary,
            "CLOAD_sub":        self.button_setCload,
            "DLOAD_sub":        self.button_setDload,
            "VLOAD_sub":        self.button_setVload,
            "GRAV_sub":         self.button_setGrav,
            "CENT_sub":         self.button_setCent,
            "TEMPERATURE_sub":  self.button_setTemperature,
            "REFTEMP_sub":      self.button_setReftemp,
            "SPRING_sub":       self.button_setSpring,
            "FLOAD_sub":        self.button_setFload,
            "VELOCITY_sub":     self.button_setVelocity,
            "ACCELERATION_sub": self.button_setAcceleration,
            "contact_sub":      self.button_setContactPair,
            "INITIAL":          "",
            "INITEMP_sub":     self.button_setIniNGRP,
            "FIXTEMP_sub":      self.button_setFixTemp,
            "CFLUX_sub":        self.button_setCflux,
            "SFLUX_sub":        self.button_setSflux,
            "DFLUX_sub":        self.button_setDflux,
            "BF_sub":           self.button_setBf,
            "SFILM_sub":        self.button_setSfilm,
            "SRADIATE_sub":     self.button_setSradiate,
            "step_sub":         self.button_setStepCont,
            "AMPLITUDE":        self.button_setAmplitude,
            "AMPLITUDE_sub":    self.button_setAmpCont,
            "solver":           self.button_setSolveMethod,
            "solver_lin":       self.button_setSolverLn,
            "post":             ""
            }


    def setToolTip(self):
        """ toolTipを設定する。"""
        resetCamera = _("モデルを画面にフィットさせる")
        viewXP = _("X軸視(Y-Z平面)を表示")
        viewXM = _("-X軸視(Y-Z平面)を表示")
        viewYP = _("Y軸視(X-Z平面)を表示")
        viewYM = _("-Y軸視(X-Z平面)を表示")
        viewZP = _("Z軸視(X-Y平面)を表示")
        viewZM = _("-Z軸視(X-Y平面)を表示")
        rightToLeft = _("視点を反転する(左右反転)")
        rolling90 = _("時計回りに90度回転する")
        newReloadVtkMesh = _("時間制限無しで、vtkデータを再作成し、読み込む")
        reloadVtk = _("時間制限無しで、vtkデータを再読込する")
        showEdge = _("全体モデル、選択モデル共にedgeを表示する")
        opacity = _("全体モデルを半透明に設定する")
        showAllElms = _("全要素グループ(EGRP)を表示する")
        hideElms = _("doubleClickでEGRPを選択(薄茶色),") + ls
        hideElms += _("材料物性値などでEGRPが選択された状態(pink or red)") + ls
        hideElms += _("でクリックするとそのEGRPを非表示する。")
        self.button_resetCamera.props.tooltip_text = resetCamera
        self.button_viewXP.props.tooltip_text = viewXP
        self.button_viewXM.props.tooltip_text = viewXM
        self.button_viewYP.props.tooltip_text = viewYP
        self.button_viewYM.props.tooltip_text = viewYM
        self.button_viewZP.props.tooltip_text = viewZP
        self.button_viewZM.props.tooltip_text = viewZM
        self.button_newReloadVtkMesh.props.tooltip_text = newReloadVtkMesh
        #self.button_rightToLeft.props.tooltip_text = rightToLeft
        #self.button_rolling90.props.tooltip_text = rolling90
        self.button_showAllElms.props.tooltip_text = showAllElms
        self.button_hideElms.props.tooltip_text = hideElms
        self.button_reloadVtkMesh.props.tooltip_text = reloadVtk
        self.check_showEdge.props.tooltip_text = showEdge
        self.check_opacity.props.tooltip_text = opacity
        datCont = _("cnt,datファイルを初期化する。")
        editUsingApp = _("usingAppの設定内容を編集する")
        openWorkFolder = _("作業folderを開く")
        runTerm = _("端末を起動する")
        exit = _("閉じる")
        saveToDir = _("tempFolaerの内容を作業folderに保存する")
        openTempFolder = _("tempFolderを開く")
        loadToTemp = _("作業folderの内容を省略して、tempFolderにloadする")
        editCntMshFile = _("tempFolder内のcnt,mshファイルを確認、編集する")
        clearFolder = _("作業Folder内の計算結果などをクリアする")
        initCntDatFile = _("cnt,datファイルを初期化する。")
        runCad = _("usingAppで設定されているCADを起動する")
        runMesher = _("usingAppで設定されているmesherを起動する。")
        runParaView = _("paraViewを起動する")
        nThreadEntry = _("入力値が「0」「none」「空白」の場合、") + ls
        nThreadEntry += _("thread並列の設定をしません。")
        set341elm  = _("構造計算時、341要素の精度を向上する。") + ls
        set341elm += _("cntファイルに「!SECTION」を追加。") + ls
        set341elm += _("並列計算時は、hecmw_part_ctrl.datファイルに「DEPTH=2」を追加。")
        self.button_datCont.props.tooltip_text = datCont
        builder.get_object("tool_editUsingApp").props.tooltip_text = editUsingApp
        builder.get_object("tool_openWorkFolder").props.tooltip_text = openWorkFolder
        builder.get_object("tool_runTerm").props.tooltip_text = runTerm
        builder.get_object("tool_exit").props.tooltip_text = exit
        builder.get_object("tool_openTempFolder").props.tooltip_text = openTempFolder
        builder.get_object("tool_saveToDir").props.tooltip_text = saveToDir
        builder.get_object("tool_loadToTemp").props.tooltip_text = loadToTemp
        builder.get_object("tool_editCntMshFile").props.tooltip_text = editCntMshFile
        builder.get_object("tool_clearFolder").props.tooltip_text = clearFolder
        builder.get_object("tool_initCntDatFile").props.tooltip_text = initCntDatFile
        builder.get_object("tool_runCad").props.tooltip_text = runCad
        builder.get_object("tool_runMesher").props.tooltip_text = runMesher
        builder.get_object("tool_runParaView").props.tooltip_text = runParaView
        self.textCtrl_solveNthread.props.tooltip_text = nThreadEntry
        self.checkBtn_set341elm.props.tooltip_text = set341elm

    #---------- vtk 関連 ------------------------------------
    #
    #  setVtkArea
    #--------------
    def setVtkArea(self):
        """ vtkAreaを設定"""
        if vtkImportFlag == "no":
            self.label_vtk.set_text("  no vtk")
            label = Gtk.Label()
            label.set_text("\ncould not import vtk\n")
            self.box_vtk.pack_start(label, True, True, 0)
            return
        vtkObj = self.vtkObj
        vtkObj.set_size_request(*self.vtkSize)
        self.box_vtk.pack_start(vtkObj, True, True, 0)


    #
    #  setUndefineToHideElms
    #-------------------------
    def setUndefineToHideElms(self):
        """ vtkFilesがundefineのみかどうか確認し、hideElmsを設定する。
        undefineのみ: hideElms=[]
        undefine無し: hideElms=[]
        undefine+egrps: hideElms=["--undefine--"]
        """
        currDir = getCurrDirFromTempFolder()
        vtkFiles = glob.glob(currDir + os.sep + self.vtkFolder + os.sep + "*.vtu")
        vtkNames = list(map(lambda x: os.path.basename(x), vtkFiles))
        vtkNames = list(filter(lambda x: x[:len("elementGrp_")]=="elementGrp_", vtkNames))
        self.hideElms = []
        if len(list(filter(lambda x: x.find("--undefine--")>=0, vtkNames))) > 0:
            if len(vtkNames) > 1:
                self.hideElms = ["elementGrp_--undefine--"]

    #
    #  setVtkModel
    #--------------
    def setVtkModel(self):
        """ vtkを作成し、表示する"""
        if vtkImportFlag == "no":
            return 
        #制限時間（5s）を設定
        limitTime = 5.0
        #limitTime = 1.0
        self.threadManage(limitTime)

    #
    #  threadManage
    def threadManage(self, limitTime):
        """ vtkModelを作成し、表示する。"""

        def addAxis():
            """ 最初の1回のみ、XYZの軸（compas）をrendererに追加する。"""
            if self.vtkInitialRun == True:
                #add axis(最初の起動時のみ)
                interactor = renWin.GetInteractor()
                axesActor = vtk.vtkAxesActor()
                self.axes = vtk.vtkOrientationMarkerWidget()
                self.axes.SetOrientationMarker(axesActor)
                self.axes.SetInteractor(interactor)
                self.axes.EnabledOn()
                self.axes.InteractiveOn()
                #flagをセット
                self.vtkInitialRun = False
            return

        #vtkがimportされていない場合、直ぐに戻る
        if vtkImportFlag == "no":
            return
        #vtkデータを取得する
        #ここでエラーが発生すると起動しなくなる為、エラートラップ。
        try:
            self.showModel = self.createVtkDataFromFile(limitTime)
        except:
            #エラー発生時は、vtk非表示で起動
           self.showModel = False
        #処理が中断されたかどうか確認する
        if self.showModel == False:
            title = _("モデル表示")
            mess = _("FrontISTRのmshファイルからvtkDataが作成できませんでした。") + "\n"
            mess += _("  vtkが再表示できていません。") + "\n\n"
            mess += _("  mshファイルが壊れている可能性があります。")
            self.okDialog(title, mess, parent=mainWindow)

            # #中断した場合
            # #ゴミのactorを削除
            # self.deleteAllActors()
            # #timeOutの文字を表示
            # self.textActor.SetInput("Time Out")
            # #背景色をwhiteに設定
            # self.renderer.SetBackground2(1, 1, 1)  # Set background to white
            # self.renderer.SetBackground(1, 1, 1)
            # self.renderer.GradientBackgroundOn()
            # self.renderer.SetTexturedBackground(True)
            # #余分なrendererを削除する
            # renWin = self.vtkObj.GetRenderWindow()
            # renWin.NewInstance()
            # #新しいrendererを追加
            # renWin.AddRenderer(self.renderer)
            # #axisをrendererに追加
            # addAxis()
            # self.vtkObj.Initialize()
            # self.vtkObj.Start()
            # title = _("モデル表示")
            # mess = _("読込時間が制限時間をオーバしたので、表示できません。") + "\n"
            # mess += _("  制限時間を設定せずに読み込む場合は、vtk再読込アイコンをクリックして再読込する。")
            # self.okDialog(title, mess, parent=mainWindow)

        else:
            #正常に終了した場合
            #self.hideElms = []
            self.textActor.SetInput("")
            #余分なrendererを削除する
            renWin = self.vtkObj.GetRenderWindow()
            renWin.NewInstance()
            #新しいrendererを追加
            renWin.AddRenderer(self.renderer)
            #vtkを表示させる（21/07/14追加）
            self.showNoneSelectedModel()
            #axisをrendererに追加
            addAxis()
            #vtk表示
            self.vtkObj.GlobalWarningDisplayOff()   #windowsのエラー対策
            self.vtkObj.Initialize()
            self.vtkObj.Start()
            
            try:
                #Z軸視に設定
                self.viewFromZM()
            except:
                if self.hideVtkModelSW == "hide":
                    #非表示設定の場合「Hide model」を表示
                    self.textActor.SetInput("Hide Model")
                else:
                    #表示設定の場合、error message
                    showElms = set(self.allElms).difference(self.hideElms)
                    if len(showElms) == 0:
                        subMess = _("  全elmGrpが非表示設定です。")
                    else:
                        subMess = _("  meshデータを確認してください。")
                    title = _("エラー")
                    mess = _("vtkが表示できません。") + "\n"
                    #mess += _("  meshデータを確認してください。")
                    mess += subMess
                    self.errDialog(title, mess, parent=mainWindow)

    #
    #  createVtkDataFromFile
    def createVtkDataFromFile(self, limitTime):
        """ vtkデータをfile（FistrModel.msh.vtu）から取得してrendererを作成する。
        fileが存在しない場合は、変換する。"""

        #
        def createVtkFiles():
            """ vtkFilesを作成する"""
            global currDir, vtkFormat
            currDir = getCurrDirFromTempFolder()
            print(_("メッシュのvtkFileを作成中..."))
            createVtkSourceFiles.createVtkFiles(currDir, vtkFormat)
            vtkFiles = glob.glob(currDir + os.sep + self.vtkFolder + os.sep + "*.vtu")
            currDir = currDirTemp
            os.chdir(currDirTemp)
            self.setUndefineToHideElms()
            return vtkFiles

        #
        def isGrpNameInVtkFiles(grps, vtkFiles):
            """ vtkFilesのファイル名が全て存在するかをgrpsでチェックする。
            vtkVersionが現在のversionと合致しているかチェックする。"""
            egrps, sgrps, ngrps = grps
            #vtkFiles内のgrpsを取得
            vtkEgrps = []; vtkSgrps = []; vtkNgrps = []; vtkOthers = []
            for vtkFile in vtkFiles:
                vtkName = os.path.basename(vtkFile)
                grp = vtkName.split("_")[0]
                grpName = "_".join(vtkName.split("_")[1:])
                grpName = ".".join(grpName.split(".")[:-1])
                if grp == "elementGrp":
                    vtkEgrps.append(grpName)
                elif grp == "surfaceGrp":
                    vtkSgrps.append(grpName)
                elif grp == "nodeGrp":
                    vtkNgrps.append(grpName)
                else:
                    vtkOthers.append(vtkName)
            #vtkFilesが正しいかチェック
            egrps.sort(); vtkEgrps.sort()
            if egrps != vtkEgrps:
                #異なっている場合、差が["ALL"]か？
                difEgrp = list(set(egrps) - set(vtkEgrps))
                if difEgrp != ["ALL"]:
                    #差が["ALL"]以外ならFalse
                    return False
            return True

        #
        def getVtkFileNames():
            """ vtkFileの有無、versionを調べ、vtkFileを取得する。
            vtkFileが無い、version違いの場合は、vtkFileを作成して取得する。"""
            currDir = getCurrDirFromTempFolder()
            vtkFiles = glob.glob(currDir + os.sep + self.vtkFolder + os.sep + "*.vtu")
            if len(vtkFiles) > 0:
                #createVtkSourceFilesのversionを確認
                verFile = currDir + os.sep + self.vtkFolder + os.sep + "version_" + vtkVersion
                #if len(glob.glob(verFile)) == 0:
                if os.path.exists(verFile) == False:
                    vtkFiles = createVtkFiles()
                    return vtkFiles
                #tempFolder内meshのgrp名を確認
                egrps, sgrps, ngrps = getGrpNameInTempFolder()
                vtkNames = list(map(lambda x: os.path.basename(x), vtkFiles))
                if len(list(filter(lambda x: x.find("--undefine--")>=0, vtkNames))) > 0:
                    egrps += ["--undefine--"]
                grps = (egrps, sgrps, ngrps)
                if isGrpNameInVtkFiles(grps, vtkFiles) == False:
                    vtkFiles = createVtkFiles()
                return vtkFiles
            else:
                #vtkFile作成
                vtkFiles = createVtkFiles()
                return vtkFiles
        
        #
        def createOutLineActor(vtkName):
            """ elementGrpのoutlineを作成する"""
            elmName = "_".join(vtkName.split("_")[1:])
            reader = self.readerDict[vtkName]
            #filter
            geomFilter = vtk.vtkGeometryFilter()
            geomFilter.SetInputConnection(reader.GetOutputPort())
            #featureEdge
            featureEdge = vtk.vtkFeatureEdges()
            featureEdge.SetInputConnection(geomFilter.GetOutputPort())
            #mapper
            edgeMapper = vtk.vtkCompositePolyDataMapper()
            edgeMapper.SetInputConnection(featureEdge.GetOutputPort())
            edgeMapper.ScalarVisibilityOff()
            edgeActor = vtk.vtkActor()
            edgeActor.SetMapper(edgeMapper)
            prop = edgeActor.GetProperty()
            prop.SetLineWidth(1.5)
            actorName = "elementGrp_" + elmName + "_outline"
            self.actorDict[actorName] = edgeActor

        #
        def getSurfaceElmJoinGrpsData(vtkName, reader, egrps, sgrps, ngrps):
            """ vtkFileからsurfaceのdataを読み込み、surElmDataDictを作成する。"""
            esName = vtkName.split("_")[0]
            #elementGrp, surfaceGrp?
            if esName == "elementGrp":
                #elementGrpを確認
                grpName = "_".join(vtkName.split("_")[1:])
                grpKey = "EGRP_" + grpName
                egrpDict = {}
                for egrp in egrps:
                    name = "EGRP_" + egrp
                    surMap = reader.GetOutput().GetCellData().GetScalars(name)
                    surData = []
                    for i in range(surMap.GetSize()):
                        value = surMap.GetValue(i)
                        surData.append(value)
                    egrpDict[name] = surData
                #  辞書に保存
                if "EGRP" in self.surElmDataDict.keys():
                    self.surElmDataDict["EGRP"].update({grpKey:egrpDict})
                else:
                    self.surElmDataDict["EGRP"] = {grpKey:egrpDict}
                #surfaceGrpを確認
                sgrpDict = {}
                for sgrp in sgrps:
                    name = "SGRP_" + sgrp
                    surMap = reader.GetOutput().GetCellData().GetScalars(name)
                    surData = []
                    for i in range(surMap.GetSize()):
                        value = surMap.GetValue(i)
                        surData.append(value)
                    sgrpDict[name] = surData
                #  辞書に保存
                if "SGRP" in self.surElmDataDict.keys():
                    self.surElmDataDict["SGRP"].update({grpKey:sgrpDict})
                else:
                    self.surElmDataDict["SGRP"] = {grpKey:sgrpDict}
                #nodeGrpを確認
                ngrpDict = {}
                for ngrp in ngrps:
                    name = "NGRP_" + ngrp
                    nodeMap = reader.GetOutput().GetPointData().GetScalars(name)
                    nodeData = []
                    for i in range(nodeMap.GetSize()):
                        value = nodeMap.GetValue(i)
                        nodeData.append(value)
                    ngrpDict[name] = nodeData
                #  辞書に保存
                if "NGRP" in self.surElmDataDict.keys():
                    self.surElmDataDict["NGRP"].update({grpKey:ngrpDict})
                else:
                    self.surElmDataDict["NGRP"] = {grpKey:ngrpDict}
            return

        #
        def createSubActor(vtkName, reader, egrps, sgrp, ngrps):
            """ 要素に含まれるsubActor（nodeGrpのみ）を作成する。"""
            esName = vtkName.split("_")[0]
            #elementGrp, surfaceGrp?
            if esName != "elementGrp":
                #elementGrp以外は直ぐに戻る。
                return
            #elementGrpのdataを取得
            cellData = reader.GetOutput().GetCells().GetData()
            points = reader.GetOutput().GetPoints().GetData()
            #cellDataを取得
            cellNodeData = []       #取得結果の保存先
            data = []
            nNodes = 0
            for i in range(cellData.GetSize()):
                if nNodes == 0:
                    if len(data) > 0:
                        cellNodeData.append(data)
                    #cellのnode数を保存
                    data = []
                    #vtk-8.2対応
                    try:
                        nNodes = cellData.GetValue(i)
                        data.append(nNodes)
                    except:
                        break
                else:
                    #nodeNoを保存
                    nodeNo = cellData.GetValue(i)
                    data.append(nodeNo)
                    nNodes -= 1
            if len(data) > 0:
                cellNodeData.append(data)
            #nodeGrpのactorを作成
            for ngrp in ngrps:
                egrpKey = vtkName.replace("elementGrp", "EGRP") 
                ngrpKey = "NGRP_" + ngrp
                #mapデータを取得
                nodeMapData = self.surElmDataDict["NGRP"][egrpKey][ngrpKey]
                #nodeActor作成
                nodeIds = []
                for i in range(len(nodeMapData)):
                    if nodeMapData[i] > 0:
                        nodeIds.append(i)
                actorName = vtkName
                pickedNodes = nodeIds
                actor = self.getNodeActorFromNodeIds(actorName, pickedNodes)
                #actorを保存
                if egrpKey in self.subActorDict.keys():
                    self.subActorDict[egrpKey][ngrpKey] = actor
                else:
                    self.subActorDict[egrpKey] = {}
                    self.subActorDict[egrpKey][ngrpKey] = actor
            return

        #surfaceGrpのactorを作成
        def createSurfaceActors(vtkFiles, sgrps):
            """ surfaceGrpのactorを作成する"""
            for vtkFile in vtkFiles:
                vtkName = os.path.basename(vtkFile).split(".")[0]
                if vtkName[:len("elementGrp")] == "elementGrp":
                    for sgrp in sgrps:
                        egrpKey = vtkName.replace("elementGrp", "EGRP")
                        sgrpKey = "SGRP_" + sgrp
                        #mapデータを取得
                        surMapData = self.surElmDataDict["SGRP"][egrpKey][sgrpKey]
                        cellIds = []
                        elmActorName = vtkName
                        for i in range(len(surMapData)):
                            if surMapData[i] > 0:
                                cellIds.append(i)
                        if len(cellIds) > 0:
                            elmActorName = vtkName                
                            pickedData = [elmActorName, cellIds, []]
                            surActor = self.createPickedCellActor(pickedData)
                            elmName = "_".join(vtkName.split("_")[1:])
                            surActorName = "surfaceGrp_" + elmName + "_" + sgrp
                            self.actorDict[surActorName] = surActor
                            edgeActor = self.createPickedEdgeActor(pickedData)
                            edgeActorName = "edgeSurfaceGrp_" + elmName + "_" + sgrp
                            self.edgeActorDict[edgeActorName] = edgeActor

        #---------------------------
        #基本のrendererを作成
        if self.renderer == "":
            #新規作成
            self.renderer = vtk.vtkRenderer()
            #文字のactorを追加
            self.textActor = vtk.vtkTextActor()
            self.textActor.SetInput("")
            txtprop = self.textActor.GetTextProperty()
            txtprop.BoldOn()
            txtprop.SetColor(green_dark)
            txtprop.SetFontSize(18)
            self.renderer.AddActor(self.textActor)
            #elmGrp名のactorを追加
            self.elmsTextActor = vtk.vtkTextActor()
            self.elmsTextActor.SetInput("")
            txtprop = self.elmsTextActor.GetTextProperty()
            txtprop.BoldOn()
            #txtprop.SetColor(light_grey)
            txtprop.SetFontSize(13)
            self.elmsTextActor.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport()
            self.elmsTextActor.GetPosition2Coordinate().SetCoordinateSystemToNormalizedViewport()
            self.elmsTextActor.SetPosition(0.015, 0.25)
            self.renderer.AddActor(self.elmsTextActor)
        else:
            #クリアする
            self.renderer.NewInstance()

        #vtk非表示設定？
        if self.hideVtkModelSW == "hide":
            self.check_hideVtk.set_active(True)
            self.hideVtk()
            return
        #settingDialogを表示
        showSettingDialog("show vtk model")
        #制限時間を設定
        endTime = time.time() + limitTime
        #vtkPolyDataを取得
        numSettingDialog(10, "creating vtk data file...")
        vtkFiles = getVtkFileNames()
        if len(vtkFiles) == 0:
            closeSettingDialog()
            return False
        print(_("vtkデータを読込中..."))
        #全actorを取得
        dValue = 55.0 / len(vtkFiles)
        value = 40.0
        self.actorDict = {}
        self.edgeActorDict = {}
        self.surElmDataDict = {}
        self.allElms = []
        egrps, sgrps, ngrps = getGrpNameInTempFolder()
        #未定義elmGrpを確認
        vtkNames = list(map(lambda x: os.path.basename(x), vtkFiles))
        if len(list(filter(lambda x: x.find("--undefine--")>=0, vtkNames))) > 0:
            #未定義有りの場合
            egrps += ["--undefine--"]
        for vtkFile in vtkFiles:
            #progressDialogを表示
            vtkName = os.path.basename(vtkFile).split(".")[0]
            numSettingDialog(value, "reading vtk " + vtkName + "...")
            value += dValue
            #elementVtkを取得
            vtkName0 = vtkName.split("_")[0]
            if (vtkName0 == "elementGrp" and vtkName != "elementGrp_"):
                #allElmsを取得
                if vtkName0 == "elementGrp":
                    self.allElms.append(vtkName)
                #vtk読み込み
                reader = vtk.vtkXMLUnstructuredGridReader()
                reader.SetFileName(vtkFile)
                reader.Update()  # Needed because of GetScalarRange
                self.readerDict[vtkName] = reader
                #elementのoutlineを作成
                createOutLineActor(vtkName)
                #vtkFileからgrpDataを読み込み、辞書(surElmDataDict)作成
                getSurfaceElmJoinGrpsData(vtkName, reader, egrps, sgrps, ngrps)
                #要素に含まれるsubActorを作成する。(nodeGrpのみ作成)
                createSubActor(vtkName, reader, egrps, sgrps, ngrps)
                output = reader.GetOutputPort()
                #  actorを作成
                mapper = vtk.vtkDataSetMapper()
                mapper.SetInputConnection(output)
                #mapper.ScalarVisibilityOff()
                actor = vtk.vtkActor()
                actor.SetMapper(mapper)
                self.actorDict[vtkName] = actor
            #edgeVtkを読み込み
            elif vtkName0 == "edgeElementGrp":
                #vtkを読み込み
                reader = vtk.vtkXMLUnstructuredGridReader()
                reader.SetFileName(vtkFile)
                reader.Update()  # Needed because of GetScalarRange
                self.edgeReaderDict[vtkName] = reader
                output = reader.GetOutputPort()
                #  actorを作成
                mapper = vtk.vtkDataSetMapper()
                mapper.SetInputConnection(output)
                #mapper.ScalarVisibilityOff()
                actor = vtk.vtkActor()
                actor.SetMapper(mapper)
                self.edgeActorDict[vtkName] = actor
            #if time.time() > endTime:
            #    break
        #surfaceのvtkを作成
        createSurfaceActors(vtkFiles, sgrps)
        #if time.time() > endTime:
        #    closeSettingDialog()
        #    return False
        #rendererを作成
        numSettingDialog(95, "renderering...")
        #actorを設定
        self.showNoneSelectedModel()
        #hideElmsButtonのsensitiveを設定
        self.hideElmsButton_sensitive()

        #backgroundColorを設定
        self.renderer.SetBackground2(0.5, 0.5, 1)
        self.renderer.SetBackground(0.8, 0.8, 1)
        self.renderer.GradientBackgroundOn()
        self.renderer.SetTexturedBackground(True)
        self.renderer.ResetCamera()
        #showElmsを表示
        self.setElmsActorName()
        #dialogを閉じる
        closeSettingDialog()
        return True

    #
    #  setElmsActorName
    def setElmsActorName(self):
        """ elmsActorNameをtextActorにセットする。"""
        showElms = set(self.allElms).difference(self.hideElms)
        elms = list(map(lambda x: " " + x[len("elementGrp_"):], showElms))
        elms.sort()
        line = "Show elms" + ls
        line += "\n".join(elms)
        self.elmsTextActor.SetInput(line)

    #
    #  deleteAllActors
    def deleteAllActors(self):
        """ 全actorを削除する。self.currActorsはそのまま。"""
        actors = self.renderer.GetActors()
        for actor in actors:
            self.renderer.RemoveActor(actor)
        return

    #
    #  addAllElementActors
    def addAllElementActors(self):
        """ 全elementのactorをrendererに追加する。
        selectedElementは、select表示に設定する。
        Opacityをセットする。"""
        selectNames = self.selectedActors
        preSelectNames = self.preSelectedActors
        #要素色、edge色設定
        selColorGrps = [selectNames, [red, white]]
        preSelColorGrps = [preSelectNames, [pink, grey]]
        otherColor = [green, black]
        grpColorSets = [preSelColorGrps, selColorGrps]
        self.addColoredElmActor(grpColorSets, otherColor)
        #outlineを表示
        self.addOutlineActor()
        #原点表示
        self.addOriginAxes()
        return

    #
    #  addOutlineActor
    def addOutlineActor(self):
        #透明、edge非表示？
        if self.check_opacity.get_active() == True:
            showElms = list(set(self.allElms).difference(self.hideElms))
            for elmGrp in showElms:
                elName = "_".join(elmGrp.split("_")[1:])
                actorName = "elementGrp_" + elName + "_outline"
                actor = self.actorDict[actorName]
                self.renderer.AddActor(actor)

    #
    #  addColoredElmActor
    #---------------------
    def addColoredElmActor(self, grpColors, otherColor):
        """ 設定したelement,surfaceのActorに要素色, edge色を設定する。
        grpColorSetsの定義順に色を上書きしていく。
        grpColorSet:Grpsとcolorsのリスト（[Grps, colors]）
          Grps:要素Grp、面Grp名
          colors:要素colorとedgeColorのリスト（[cellColor, edgeColor]）

        Args:
            grpColorSets [grpColorSet, ...]: Grpsとcolorsのセットで色を設定
            bgColors colors:                 背景のcolorsを設定"""
        #表示elmを取得-----------
        showElms = list(set(self.allElms).difference(self.hideElms))
        #surface側を設定
        for elmGrp in showElms:
            elName = "_".join(elmGrp.split("_")[1:])
            isBeam = self.isBeamElement(elName)
            vtkName = elmGrp
            opFlag = 0          #checkBoxにより透明度を変える
            self.setOpacColorToElement(vtkName, otherColor, opFlag)
            #selectGrpのactorを設定
            for grpNames, colors in grpColors:
                name1 = "elementGrp_" + elName
                name2 = "elementGrp_ALL"
                if name1 in grpNames or name2 in grpNames:
                    #elmGrpを設定（全surfを設定）
                    vtkName = name1 
                    opFlag = 1  #常に不透明
                    self.setOpacColorToElement(vtkName, colors, opFlag)
                else:                
                    #surfaceGrpを設定
                    for grpName in grpNames:
                        if grpName[:len("surfaceGrp_")] == "surfaceGrp_":
                            surName = "_".join(grpName.split("_")[1:])
                            vtkName = "surfaceGrp_" + elName + "_" + surName
                            if vtkName in self.actorDict.keys():
                                opFlag = 1  #常に不透明
                                self.setOpacColorToSurface(vtkName, colors, opFlag)    

    #  isBeamElement
    def isBeamElement(self, elName):
        """ elNameGrpがbeamかどうか調べる"""
        egrpDict = createEgrpToTypeDict()
        ans = False
        if elName in egrpDict.keys():
            elType = egrpDict[elName]
            if convertMesh.elmContsDict[elType][0] == "beam":
                ans = True
        return ans

    #
    #  setOpacColorToElement
    def setOpacColorToElement(self, vtkName, colors, opFlag):
        """ elementのgrpName（vtkName）のopacityとcolorを設定"""
        elmColor, edgeColor = colors
        #beam要素の場合、要素を表示しない
        elName = "_".join(vtkName.split("_")[1:])
        isBeam = self.isBeamElement(elName)
        if isBeam == False:
            #surfaceを設定
            actor = self.actorDict[vtkName]
            actor = self.setElementActor(actor, elmColor, opFlag)
            self.renderer.AddActor(actor)
        #edgeを設定
        if self.check_showEdge.get_active() == True:
            if self.check_opacity.get_active() == False or opFlag == 1:
                edgeName = vtkName.replace("elementGrp", "edgeElementGrp")
                actor = self.edgeActorDict[edgeName]
                actor = self.setEdgeElementActor(actor, edgeColor, opFlag, isBeam)
                self.renderer.AddActor(actor)

    #
    #  setOpacColorToSurface
    def setOpacColorToSurface(self, vtkName, colors, opFlag):
        """ surfaceのgrpName(vtkName)のopacityとcolorを設定"""
        elmColor, edgeColor = colors
        isBeam = False
        #surfaceを設定
        actor = self.actorDict[vtkName]
        actor = self.setElementActor(actor, elmColor, opFlag)
        self.renderer.AddActor(actor)
        #edgeを設定
        if self.check_showEdge.get_active() == True:
            edgeName = vtkName.replace("surfaceGrp", "edgeSurfaceGrp")
            actor = self.edgeActorDict[edgeName]
            actor = self.setEdgeElementActor(actor, edgeColor, opFlag, isBeam)
            self.renderer.AddActor(actor)

    #  setElementActor
    def setElementActor(self, actor, color, opFlag):
        """ actorの透明度と色を設定"""
        prop = actor.GetProperty()
        #opacityを設定
        if opFlag == 1:
            #常時不透明設定
            prop.SetOpacity(1.0)
            #prop.SetLineWidth(2.0)
        else:
            #透明も可
            if self.check_opacity.get_active() == True:
                prop.SetOpacity(0.10)
            else:
                prop.SetOpacity(1.0)
            #prop.SetLineWidth(1.0)
        prop.EdgeVisibilityOff()
        #colorを設定
        prop.SetColor(color)
        return actor

    #  setEdgeElementActor
    def setEdgeElementActor(self, actor, color, opFlag, isBeam):
        """ edgeActorの透明度と色を設定"""
        prop = actor.GetProperty()
        #opacityを設定
        if opFlag == 1:
            #常時不透明設定
            prop.SetOpacity(1.0)
            #prop.SetLineWidth(2.0)
        else:
            #透明も可
            if self.check_opacity.get_active() == True:
                prop.SetOpacity(0.10)
            else:
                prop.SetOpacity(1.5)
            #prop.SetLineWidth(1.2)
            #prop.SetLineWidth(2.0)
        if isBeam == True:
            prop.SetLineWidth(2.0)
        else:
            prop.SetLineWidth(1.2)
        prop.EdgeVisibilityOn()
        #colorを設定
        prop.SetColor(color)
        return actor

    #
    #  addAllElementActorsForCreateGrp
    def addAllElementActorsForCreateGrp(self, pickedData):
        """ 全elementのactorをrendererに追加する。
        createGroup用としてcolorをlightBlueで追加する。"""
        if len(pickedData) == 0:
            self.addAllElementActorsForCreateElmGrp(pickedData)
            return
        actorName = pickedData[0]
        if actorName[:len("element")] == "element":
            self.addAllElementActorsForCreateElmGrp(pickedData)
        else:
            self.addAllElementActorsForCreateEdgeGrp(pickedData)
        return

    #
    #  addAllElementActorsForCreateElmGrp
    def addAllElementActorsForCreateElmGrp(self, pickedData):
        """ pickedMode色に変更し、pickedDataがあれば、pickedActorを作成する。"""
        #表示させるelmを取得
        showElms = list(set(self.allElms).difference(self.hideElms))
        for elmGrp in showElms:
            vtkName = elmGrp
            colors = [blue_light, black]
            opFlag = 0  #透明可
            self.setOpacColorToElement(vtkName, colors, opFlag)
        #pickデータを確認
        if len(pickedData) == 0:
            pickedActorName, pickedCells, _pickedNodes = "", [], []
        else:    
            pickedActorName, pickedCells, _pickedNodes = pickedData
        #pickedCellActorを作成する
        self.pickedActors = []
        cellActor = self.createPickedCellActor(pickedData)
        if cellActor != None:
            self.pickedActors.append([cellActor, pink])
            edgeActor = self.createPickedEdgeActor(pickedData)
            if edgeActor != None:
                self.pickedActors.append([edgeActor, grey])

    #
    #  showPickedActors
    def showPickedActors(self):
        """ pickしたactorを表示する"""
        opFlag = 1
        for actor, color in self.pickedActors:
            actor = self.setElementActor(actor, color, opFlag)
            self.renderer.AddActor(actor)

    #  createPickedCellActor
    def createPickedCellActor(self, pickedData):
        """ pickしたcellActorを作成する"""
        if len(pickedData) == 0:
            return None
        else:    
            pickedActorName, pickedCells, pickedNodes = pickedData
        if (pickedActorName[:len("elementGrp")] != "elementGrp"
            or len(pickedCells) == 0):
            return None
        
        newIdTypeArray = vtk.vtkIdTypeArray()
        newCellTypesArray = vtk.vtkUnsignedCharArray()
        newCells = vtk.vtkCellArray()
        
        reader = self.readerDict[pickedActorName]
        cellArray = reader.GetOutput().GetCells()
        connectArray = cellArray.GetConnectivityArray()
        cellTypesArray = reader.GetOutput().GetCellTypesArray()
        maxNodeId = connectArray.GetMaxId()
        maxCellId = cellArray.GetSize() - connectArray.GetSize() - 1
        for cellId in pickedCells:
            #cellIdからnodeIdを取得
            nodeIds = []
            st = cellArray.GetOffset(cellId)
            if cellId < maxCellId:
                ed = cellArray.GetOffset(cellId+1)
            else:
                ed = maxCellId + 1
            for i in range(st, ed, 1):
                nodeNo = connectArray.GetValue(i)
                nodeIds.append(nodeNo)
            #cellを構成するnode数を取得
            nNodes = len(nodeIds)
            #cellTypeを取得
            cellType = cellTypesArray.GetValue(cellId)
            #newCellを作成
            nodeNos = nodeIds
            for nodeId in nodeIds:
                newIdTypeArray.InsertNextTuple1(nodeId)
            newCells.InsertNextCell(nNodes, nodeNos)    
            newCellTypesArray.InsertNextTuple1(cellType)
        #gridCellを作成
        newGridCells = vtk.vtkUnstructuredGrid()
        newGridCells.NewInstance()
        #  cellDataをセット
        newGridCells.SetCells(newCellTypesArray, newIdTypeArray, newCells)
        #  pointsをセット
        points = reader.GetOutput().GetPoints().GetData()
        newPoints = vtk.vtkPoints()
        newPoints.NewInstance()
        newPoints.SetData(points)
        newGridCells.SetPoints(newPoints)
        #mapper
        mapper = vtk.vtkDataSetMapper()
        mapper.SetInputData(newGridCells)
        mapper.ScalarVisibilityOff()
        #actor
        actor = vtk.vtkActor()
        actor.SetMapper(mapper)
        return actor

    #
    #  createPickedEdgeActor
    def createPickedEdgeActor(self, pickedData):
        """ pickしたelementのedgeActorを作成する"""
        #pickedDataを確認
        if len(pickedData) == 0:
            return None
        else:    
            pickedActorName, pickedCells, pickedNodes = pickedData
        if len(pickedCells) == 0:
            return None
        
        if pickedActorName[:len("elementGrp")] == "elementGrp":
            #pickしたelementからedgeIdを取得する
            edgeActorName = pickedActorName.replace("elementGrp_", "edgeElementGrp_")
            reader = self.edgeReaderDict[edgeActorName]
            #対象のedgeIdを取得
            pickedCellSet = set(pickedCells)
            nCells = reader.GetOutput().GetNumberOfCells()
            cellData = reader.GetOutput().GetCellData().GetScalars("pairElmNo")
            #pairElmNoからedgeIdを取得
            edgeIds = []
            edgeId = 0
            for i in range(0, nCells*2, 2):
                elm0 = cellData.GetValue(i)
                if elm0 in pickedCellSet:
                    edgeIds.append(edgeId)
                else:
                    elm1 = cellData.GetValue(i+1)
                    if elm1 in pickedCellSet:
                        edgeIds.append(edgeId)
                edgeId += 1
        else:
            #pickしたedgeをedgeIdとして使う
            edgeIds = pickedCells
            reader = self.edgeReaderDict[pickedActorName]
        #edgeIdからactorを作成
        newIdTypeArray = vtk.vtkIdTypeArray()
        newCellTypesArray = vtk.vtkUnsignedCharArray()
        newCells = vtk.vtkCellArray()
        #edgeIdからnodeIdを取得
        cellArray = reader.GetOutput().GetCells()
        connectArray = cellArray.GetConnectivityArray()
        cellTypesArray = reader.GetOutput().GetCellTypesArray()
        maxNodeId = connectArray.GetMaxId()
        maxCellId = cellArray.GetSize() - connectArray.GetSize() - 1
        for edgeId in edgeIds:
            #edgeを構成するnodeIdを取得
            nodeIds = []
            st = cellArray.GetOffset(edgeId)
            if edgeId < maxCellId:
                ed = cellArray.GetOffset(edgeId+1)
            else:
                ed = maxCellId + 1
            for i in range(st, ed, 1):
                nodeNo = connectArray.GetValue(i)
                nodeIds.append(nodeNo)
            #cellを構成するnode数を取得
            nNodes = len(nodeIds)
            #cellTypeを取得
            cellType = cellTypesArray.GetValue(edgeId)
            #newCellを作成
            nodeNos = nodeIds
            for nodeId in nodeIds:
                newIdTypeArray.InsertNextTuple1(nodeId)
            newCells.InsertNextCell(nNodes, nodeNos)    
            newCellTypesArray.InsertNextTuple1(cellType)
        #gridCellを作成
        newGridCells = vtk.vtkUnstructuredGrid()
        newGridCells.NewInstance()
        #  cellDataをセット
        newGridCells.SetCells(newCellTypesArray, newIdTypeArray, newCells)
        #  pointsをセット
        points = reader.GetOutput().GetPoints().GetData()
        newPoints = vtk.vtkPoints()
        newPoints.NewInstance()
        newPoints.SetData(points)
        newGridCells.SetPoints(newPoints)
        #mapper
        mapper = vtk.vtkDataSetMapper()
        mapper.SetInputData(newGridCells)
        mapper.ScalarVisibilityOff()
        #actor
        actor = vtk.vtkActor()
        actor.SetMapper(mapper)
        return actor

    #
    #  addAllElementActorsForCreateEdgeGrp
    def addAllElementActorsForCreateEdgeGrp(self, pickedData):
        """ pickedMode色に変更し、pickedDataがあれば、edgeのpickedActorを作成する。"""
        #表示させるelmを取得
        showElms = list(set(self.allElms).difference(self.hideElms))
        for elmGrp in showElms:
            vtkName = elmGrp
            colors = [blue_light, black]
            opFlag = 0  #透明可
            self.setOpacColorToElement(vtkName, colors, opFlag)
        #pickデータを確認
        if len(pickedData) == 0:
            pickedActorName, pickedCells, _pickedNodes = "", [], []
        else:    
            pickedActorName, pickedCells, _pickedNodes = pickedData
        #pickedCellActorを作成する
        self.pickedActors = []
        edgeActor = self.createPickedEdgeActor(pickedData)
        if edgeActor != None:
            self.pickedActors.append([edgeActor, grey])
            #self.pickedActors.append([edgeActor, white])

    #
    #  addOriginAxes
    #----------------
    def addOriginAxes(self):
        """ 原点表示のactorを追加する"""
        showElms = list(set(self.allElms).difference(self.hideElms))
        if len(showElms) == 0:
            #表示するactorが存在しない場合
            if self.originAxes != None:
                self.renderer.RemoveActor(self.originAxes)
                self.originAxes = None
            return
        
        if self.check_showOriginAxes.get_active() == True:
            if self.originAxes != None:
                #原点を削除
                self.renderer.RemoveActor(self.originAxes)
                self.originAxes = None
            #原点を作成
            bounds = self.getBoundsActors()
            lenX = (bounds[1] - bounds[0]) / 2.0 * 1.2
            lenY = (bounds[3] - bounds[2]) / 2.0 * 1.2
            lenZ = (bounds[5] - bounds[4]) / 2.0 * 1.2
            length = max([lenX, lenY, lenZ])
            axes = vtk.vtkAxesActor()
            axes.SetTotalLength(length, length, length)
            #axes.SetTotalLength(lenX, lenY, lenZ)
            axes.GetXAxisCaptionActor2D().GetTextActor().SetTextScaleModeToNone()
            axes.GetXAxisCaptionActor2D().GetCaptionTextProperty().SetFontSize(12)
            axes.GetYAxisCaptionActor2D().GetTextActor().SetTextScaleModeToNone()
            axes.GetYAxisCaptionActor2D().GetCaptionTextProperty().SetFontSize(12)
            axes.GetZAxisCaptionActor2D().GetTextActor().SetTextScaleModeToNone()
            axes.GetZAxisCaptionActor2D().GetCaptionTextProperty().SetFontSize(12)
            self.renderer.AddActor(axes)
            self.originAxes = axes
        else:
            #原点を削除
            self.renderer.RemoveActor(self.originAxes)
            self.originAxes = None
        return

    #
    #  showAllCellActors
    def showAllCellActors(self):
        """ GtkVtkRendererWindowInteractorから呼び出す。
        pickした時、vtkを再描画しないと、windowsではエラーが発生するので
        こので再描画する。"""
        pickedData = self.pickedData
        self.addAllElementActorsForCreateElmGrp(pickedData)

    #
    #  addPickedActors
    def addPickedActors(self, pickedData):
        """ pickedActor(node)をrendererに追加する"""
        if len(pickedData) == 0:
            return
        pickedActorName, pickedCells, pickedNodes = pickedData
        if pickedActorName[:len("edge")] == "edge":
            pickedActorName = pickedActorName.replace("edgeElement", "element")
        if len(pickedNodes) > 0:
            #pickedNodeGrpを取得
            nodeActor = self.getNodeActorFromNodeIds(pickedActorName, pickedNodes)
            prop = nodeActor.GetProperty()
            prop.SetPointSize(10)
            #pickedActorsに保存
            self.pickedActors.append([nodeActor, pink])

    #
    #  addSelectedActors
    def addSelectedActors(self):
        """ self.selectedActorsのnodeGrpをactorに追加する"""
        showElms = list(set(self.allElms).difference(self.hideElms))
        #nodeを取得
        sels = []; preSels = []
        surSels = []; surPreSels = []
        for selActor in self.selectedActors:
            if selActor.split("_")[0] == "nodeGrp":
                sels.append(selActor)
        for selActor in self.preSelectedActors:
            if selActor.split("_")[0] == "nodeGrp":
                preSels.append(selActor)

        #nodeGrpのselectedActorを取得
        for elmGrp in showElms:
            egrpKey = elmGrp.replace("elementGrp", "EGRP")
            for nodeGrp in sels:
                ngrpKey = nodeGrp.replace("nodeGrp", "NGRP")
                if egrpKey in self.subActorDict.keys():
                    if ngrpKey in self.subActorDict[egrpKey].keys():
                        actor = self.subActorDict[egrpKey][ngrpKey]
                        prop = actor.GetProperty()
                        prop.SetColor(red)
                        prop.SetPointSize(10)
                        self.renderer.AddActor(actor)
        #preSelectedActorを取得
        for elmGrp in showElms:
            egrpKey = elmGrp.replace("elementGrp", "EGRP")
            for nodeGrp in preSels:
                ngrpKey = nodeGrp.replace("nodeGrp", "NGRP")
                if egrpKey in self.subActorDict.keys():
                    if ngrpKey in self.subActorDict[egrpKey].keys():
                        actor = self.subActorDict[egrpKey][ngrpKey]
                        prop = actor.GetProperty()
                        prop.SetColor(pink)
                        prop.SetPointSize(10)
                        self.renderer.AddActor(actor)
        return

    #
    #  getNodeActorFromNodeIds
    #--------------------------
    def getNodeActorFromNodeIds(self, actorName, nodeIds):
        """ actorNameから新たにnodeIdsのみのactorを作り出す"""
        newIdTypeArray = vtk.vtkIdTypeArray()
        newCellTypesArray = vtk.vtkUnsignedCharArray()
        newCells = vtk.vtkCellArray()
        for nodeId in nodeIds:
            nodeNos = [nodeId]
            nNodes = 1
            cellType = 1
            newIdTypeArray.InsertNextTuple1(nodeId)
            newCells.InsertNextCell(nNodes, nodeNos)
            newCellTypesArray.InsertNextTuple1(cellType)
        #gridCellを作成
        newGridCells = vtk.vtkUnstructuredGrid()
        newGridCells.NewInstance()
        #  cellDataをセット
        newGridCells.SetCells(newCellTypesArray, newIdTypeArray, newCells)
        #  pointsをセット
        reader = self.readerDict[actorName]
        points = reader.GetOutput().GetPoints().GetData()
        newPoints = vtk.vtkPoints()
        newPoints.NewInstance()
        newPoints.SetData(points)
        newGridCells.SetPoints(newPoints)
        #mapper
        mapper = vtk.vtkDataSetMapper()
        mapper.SetInputData(newGridCells)
        mapper.ScalarVisibilityOff()
        #actor
        actor = vtk.vtkActor()
        actor.SetMapper(mapper)
        return actor

    #
    #  setPickMode
    #--------------
    def setPickMode(self):
        """ group作成時のpickModeを設定する。"""
        if self.radioBtn_pickFace.get_active() == True:
            self.pickMode = "face"
        elif self.radioBtn_pickEdge.get_active() == True:
            self.pickMode = "edge"
        else:
            self.pickMode = "points"
            self.pickedPoints = []
            self.dummyPickedPoints = []
        #取得buttonを非active設定
        self.activeButtonOfCreateGrp([])
        #表示をクリア
        self.clearGrpView()

    #
    #  clearGrpView
    #---------------
    def clearGrpView(self):
        """ vtkのviewをdefaultの色の設定する。"""
        self.pickedData = []
        self.pickedPoints = []
        self.dummyPickedPoints = []
        self.showCreateGrpModel()
        self.textCtrl_startFace.set_text("")
        #pickedItemsをクリア
        self.vtkObj.pickedActor = None
        self.vtkObj.pickedCellId = None

    #
    #  clearChangeFlag
    #------------------
    def clearChangeFlag(self):
        """ changeFlagをクリアして、通常表示に設定する"""
        #flagをクリア
        self.clearSetFlagInTree()
        #ボタンのlabelをclear
        self.clearButtonLabel()

    #
    #  showCreateNgrp
    #-----------------
    def showCreateNgrp(self):
        """ nodeGrpを取得し、表示する"""
        angle = self.textCtrl_faceAngle.get_text()
        try:
            angle = float(angle)
            angle = math.cos(math.pi/180.0*angle)
        except:
            title = _("エラー")
            mess = _("face角度の入力値が間違っています。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pick内容を取得
        cellCont = self.textCtrl_startFace.get_text()
        words = cellCont.split()
        if len(words) < 2:
            title = _("エラー")
            mess = _("始点のfaceが選択されていません。") + "\n"
            mess += _("  マウスでmesh内ののcellをクリックしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return

        #pickMode別に処理
        #  faceMode?
        if self.radioBtn_pickFace.get_active() == True:
            #pickしたnodeIdを取得
            actorName = "elementGrp_" + words[0]
            pickedCellId = int(words[1])
            getGrp = "nodeGrp"
            nodeIds = []
            nodeIds, dummyIds = self.getFaceGrpsFromPickedCellIdForSolidShell(pickedCellId, actorName, angle, getGrp)
            #nodeNoを取得
            reader = self.readerDict[actorName]
            nodeNos = reader.GetOutput().GetPointData().GetScalars("nodeNo")
            nodeGrp = []
            dummyGrp = []
            for nodeId in nodeIds:
                nodeNo = nodeNos.GetValue(nodeId)
                nodeGrp.append(nodeNo)
            for nodeId in dummyIds:
                nodeNo = nodeNos.GetValue(nodeId)
                dummyGrp.append(nodeNo)
            self.createdGrp = ["nodeGrp_", nodeGrp]
            if len(dummyGrp) > 0:
                self.dummyCreatedGrp = ["nodeGrp_", dummyGrp]
        #edgeMode?
        elif self.radioBtn_pickEdge.get_active() == True:
            #pickしたnodeIdを取得
            edgeActorName = "edgeElementGrp_" + words[0]
            pickedEdgeId = int(words[1])
            getGrp = "nodeGrp"
            #pickedCellと辞書を取得
            pickedCellIds, allDicts = self.getCellIdFromPickedEdge(pickedEdgeId, edgeActorName)
            pickedCellId = pickedCellIds[0]
            elementDict = allDicts[1]
            #cellTypeを取得
            cellType = elementDict[pickedCellId]["item"]
            #solid or shellのedgeをpick？
            if cellType == "solid" or cellType == "shell":
                nodeIds, dummyIds = self.getEdgeGrpsFromPickedEdgeIdForShell(pickedEdgeId, edgeActorName, angle, getGrp, pickedCellId, allDicts)
                #nodeNoを取得
                actorName = "elementGrp_" + words[0]
                reader = self.readerDict[actorName]
                nodeNos = reader.GetOutput().GetPointData().GetScalars("nodeNo")
                nodeGrp = []
                for nodeId in nodeIds:
                    nodeNo = nodeNos.GetValue(nodeId)
                    nodeGrp.append(nodeNo)
                dummyGrp = []
                for dummyId in dummyIds:
                    nodeNo = nodeNos.GetValue(dummyId)
                    dummyGrp.append(nodeNo)
                self.createdGrp = ["nodeGrp_", nodeGrp]
                self.dummyCreatedGrp = []
                if len(dummyGrp) > 0:
                    self.dummyCreatedGrp = ["nodeGrp_", dummyGrp]
            #beamをpick？
            elif cellType == "beam":
                nodeIds, dummyIds = self.getEdgeGrpsFromPickedEdgeIdForBeam(pickedEdgeId, edgeActorName, angle, getGrp, pickedCellId, allDicts)
                #nodeNoを取得
                actorName = "elementGrp_" + words[0]
                reader = self.readerDict[actorName]
                nodeNos = reader.GetOutput().GetPointData().GetScalars("nodeNo")
                nodeGrp = []
                for nodeId in nodeIds:
                    nodeNo = nodeNos.GetValue(nodeId)
                    nodeGrp.append(nodeNo)
                dummyGrp = []
                for dummyId in dummyIds:
                    nodeNo = nodeNos.GetValue(dummyId)
                    dummyGrp.append(nodeNo)
                self.createdGrp = ["nodeGrp_", nodeGrp]
                self.dummyCreatedGrp = []
                if len(dummyGrp) > 0:
                    self.dummyCreatedGrp = ["nodeGrp_", dummyGrp]
        #grpを設定
        self.pickedGrp = "ngrp"
        self.setCreateNewGrp()
        #vtk表示
        self.pickedData = [actorName, [], nodeIds]
        self.showCreateGrpModel()

    #
    #  showCreatedSgrp
    #-----------------
    def showCreatedSgrp(self):
        """ surfaceGrpを取得し、表示する。"""
        angle = self.textCtrl_faceAngle.get_text()
        try:
            angle = float(angle)
            angle = math.cos(math.pi/180.0*angle)
        except:
            title = _("エラー")
            mess = _("角度の入力値が間違っています。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pick内容を取得        
        cellCont = self.textCtrl_startFace.get_text()
        words = cellCont.split()
        if len(words) < 2:
            title = _("エラー")
            mess = _("始点のfaceが選択されていません。") + "\n"
            mess += _("  マウスでmesh内ののcellをクリックしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pickしたcellIdを取得
        actorName = "elementGrp_" + words[0]
        pickedCellId = int(words[1])
        getGrp = "faceGrp"
        cellIds = self.getFaceGrpsFromPickedCellIdForSolidShell(pickedCellId, actorName, angle, getGrp)
        #elmNo,faceNoを取得
        faceGrp = []
        reader = self.readerDict[actorName]
        elmNos = reader.GetOutput().GetCellData().GetScalars("elmNo")
        faceNos = reader.GetOutput().GetCellData().GetScalars("faceNo")
        for cellId in cellIds:
            elmNo = elmNos.GetValue(cellId)
            #faceNo = faceNos.GetValue(cellId)
            sectFaceNo = faceNos.GetValue(cellId)
            faceNo = sectFaceNo % 100
            faceGrp.append(elmNo)
            faceGrp.append(faceNo)
        self.createdGrp = ["surfaceGrp_", faceGrp]
        self.pickedGrp = "sgrp"
        self.setCreateNewGrp()
        #vtkを表示
        self.pickedData = [actorName, cellIds, []]
        self.showCreateGrpModel()

    #
    #  showCreatedEgrp
    #------------------
    def showCreatedEgrp(self):
        """ elementGrpを取得し、表示する。"""
        #pick内容を取得
        cellCont = self.textCtrl_startFace.get_text()
        words = cellCont.split()
        if len(words) < 2:
            title = _("エラー")
            mess = _("始点のfaceが選択されていません。") + "\n"
            mess += _("  マウスでmesh内ののcellをクリックしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pickしたcellIdを取得
        actorName = "elementGrp_" + words[0]
        pickedCellId = int(words[1])
        getGrp = "elmGrp"
        #角度を取得
        angle = self.textCtrl_faceAngle.get_text()
        try:
            angle = float(angle)
            angle = math.cos(math.pi/180.0*angle)
        except:
            title = _("エラー")
            mess = _("face角度の入力値が間違っています。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pickModeがface？
        if self.radioBtn_pickFace.get_active() == True:
            cellIds = self.getFaceGrpsFromPickedCellIdForSolidShell(pickedCellId, actorName, angle, getGrp)
            #elmNoを取得
            #  外表面のelmNoを取得
            elmGrp = []
            reader = self.readerDict[actorName]
            elmNos = reader.GetOutput().GetCellData().GetScalars("elmNo")
            for cellId in cellIds:
                elmNo = elmNos.GetValue(cellId)
                elmGrp.append(elmNo)
            self.createdGrp = ["elmGrp_", elmGrp]
        #pickModeがedge
        elif self.radioBtn_pickEdge.get_active() == True:
            #pickしたnodeIdを取得
            edgeActorName = "edgeElementGrp_" + words[0]
            pickedEdgeId = int(words[1])
            pickedCellIds, allDicts = self.getCellIdFromPickedEdge(pickedEdgeId, edgeActorName)
            cellIds = self.getEdgeGrpsFromPickedEdgeIdForBeam(pickedEdgeId, edgeActorName, angle, getGrp, pickedCellIds[0], allDicts)
            #elmNoを取得
            elmGrp = []
            reader = self.readerDict[actorName]
            elmNos = reader.GetOutput().GetCellData().GetScalars("elmNo")
            for cellId in cellIds:
                elmNo = elmNos.GetValue(cellId)
                elmGrp.append(elmNo)
            self.createdGrp = ["elmGrp_", elmGrp]
        self.pickedGrp = "egrp"
        self.setCreateNewGrp()
        #vtkを表示
        self.pickedData = [actorName, cellIds, []]
        self.showCreateGrpModel()

    #
    #  showCreateAllNgrp
    #----------------------
    def showCreateAllNgrp(self):
        """ elementGrp内の全nodeを取得し、表示する。"""
        #pick内容を取得
        cellCont = self.textCtrl_startFace.get_text()
        words = cellCont.split()
        if len(words) < 2:
            title = _("エラー")
            mess = _("始点のfaceが選択されていません。") + "\n"
            mess += _("  マウスでmesh内ののcellをクリックしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pickしたcellIdを取得
        actorName = "elementGrp_" + words[0]
        pickedCellId = int(words[1])
        getGrp = "nodeGrp"
        #角度を取得
        angle = self.textCtrl_faceAngle.get_text()
        try:
            angle = float(angle)
            angle = math.cos(math.pi/180.0*angle)
        except:
            title = _("エラー")
            mess = _("face角度の入力値が間違っています。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pickModeがface or edge？
        if (self.radioBtn_pickFace.get_active() == True or 
            self.radioBtn_pickEdge.get_active() == True):
            print(getGrp + " in same elmGrp will be gotton.")
            print("  creating nodes dictionary...")
            nodeDict = self.getFullNodeDictFromVtk(actorName)
            nodeIds = set([])
            nodeIds = list(nodeDict.keys())
            #nodeNoを取得
            reader = self.readerDict[actorName]
            nodeNos = reader.GetOutput().GetPointData().GetScalars("nodeNo")
            nodeGrp = []
            for nodeId in nodeIds:
                nodeNo = nodeNos.GetValue(nodeId)
                nodeGrp.append(nodeNo)
            self.createdGrp = ["allNodeGrp_", nodeGrp]
        print("  gotton all nodes in same element group!")
        self.pickedGrp = "ngrp"
        self.setCreateNewGrp()
        #vtk表示
        self.pickedData = [actorName, [], nodeIds]
        self.showCreateGrpModel()

    #
    #  setCreateGrp
    #----------------
    def setCreateGrp(self):
        """ 取得したNGRP or SGRPをmshファイルに保存する。"""
        if self.radioBtn_newGrp.get_active() == True:
            #新規にgrpを作成
            self.setCreateGrp_newGrp()
        else:
            #既存のgrpに加算or減算する
            if self.radioBtn_addGrp.get_active() == True:
                #加算する
                self.setCreateGrp_addGrp()
            else:
                #減算（削除）する
                self.setCreateGrp_delGrp()

    #
    #  setCreateGrp_newGrp
    #----------------------
    def setCreateGrp_newGrp(self):
        """ 新規にgrpを作成する"""
        global meshHeaderData, vtkFormat
        grpName = self.textCtrl_grpName.get_text()
        grpName = grpName.replace(" ", "")
        grpName = grpName.replace("\t", "")
        if grpName == "":
            title = _("エラー")
            mess = _("group名が入力されていません。") + "\n"
            mess += _("  group名を入力してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #取得結果をチェック
        if len(self.createdGrp) == 0:
            title = _("エラー")
            mess = _("NGRP or SGRPが取得されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #entryをチェック
        if self.textCtrl_startFace.get_text() == "":
            title = _("エラー")
            mess = _("pick結果が取得できません。") + "\n"
            mess += "  " + _("再度、pickしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #!ELEMENTのegrp名を取得
        eegrps = []
        egrps = []
        sgrps = []
        ngrps = []
        for headerData in meshHeaderData:
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name != "":
                    eegrps.append(name)
                    egrps.append(name)
            elif words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name != "":
                    egrps.append(name)
            elif words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name != "":
                    sgrps.append(name)
            elif words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name != "":
                    ngrps.append(name)
        #grp名をチェック
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            if (grpName in eegrps) or (grpName in egrps):
                title = _("EGRPの保存")
                mess = _("同じ名前のEGRPが存在します。") + ls
                mess += _("  grp名を変更してください。")
                self.errDialog(title, mess, parent=mainWindow)
                return
        elif self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
            if grpName in sgrps:
                title = _("SGRPの保存")
                mess = _("同じ名前のSGRPが存在します。") + ls
                mess += _("  grp名を変更してください。")
                self.errDialog(title, mess, parent=mainWindow)
                return
        elif self.createdGrp[0][:len("allNodeGrp")] == "allNodeGrp":
            if grpName in ngrps:
                title = _("NGRPの保存")
                mess = _("同じ名前のNGRPが存在します。") + ls
                mess += _("  grp名を変更してください。")
                self.errDialog(title, mess, parent=mainWindow)
                return
        else:
            if grpName in ngrps:
                title = _("NGRPの保存")
                mess = _("同じ名前のNGRPが存在します。") + ls
                mess += _("  grp名を変更してください。")
                self.errDialog(title, mess, parent=mainWindow)
                return
        #grpをmshファイルに保存
        showSettingDialog("create group")
        numSettingDialog(10, "saving "+grpName+" to mshFile...")
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            #elmGrpをmshファイルに保存
            self.saveNewCreateElmGrp(grpName)
        elif self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
            #surfaceGrpをmshファイルに保存
            self.saveNewCreateSurfaceGrp(grpName)
        elif self.createdGrp[0][:len("allNodeGrp")] == "allNodeGrp":
            #egrp内の全nodeをmshファイルに保存
            self.saveNewCreateAllNodesGrp(grpName)
        else:
            #nodeGrpをmshファイルに保存
            self.saveNewCreateNodeGrp(grpName)     #主nodeを保存
            if len(self.dummyCreatedGrp) > 0:
                dummyName = "dummy_" + grpName
                grpData = self.createdGrp[:]
                self.createdGrp = self.dummyCreatedGrp[:]
                self.saveNewCreateNodeGrp(dummyName)   #dummyNodeを保存
                self.createdGrp = grpData
        #meshデータを再読込、GUIに表示
        numSettingDialog(80, "setting mesh contents...")
        self.setMeshCont()
        #vtkを再取得
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            #elmGrp作成の場合
            currDir = getCurrDirFromTempFolder()
            #vtkを全て作り直す
            createVtkSourceFiles.createVtkFiles(currDir, vtkFormat)
        else:
            #surfaceGrp, nodeGrp作成の場合
            text = self.textCtrl_startFace.get_text()
            words = text.split()
            egrp = words[0]
            currDir = getCurrDirFromTempFolder()
            vtkFile = currDir + os.sep + self.vtkFolder + os.sep + "elementGrp_" + egrp + ".vtu"
            if self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
                #surfaceGrp
                createVtkSourceFiles.addSurfaceGrp(vtkFile, grpName, self.createdGrp[1])
            else:
                #nodeGrp
                createVtkSourceFiles.addNodeGrp(vtkFile, grpName, self.createdGrp[1])
                if len(self.dummyCreatedGrp) > 0:
                    createVtkSourceFiles.addNodeGrp(vtkFile, "dummy_"+grpName, self.dummyCreatedGrp[1])
        numSettingDialog(101, "close")
        closeSettingDialog()
        #vtk表示
        self.reloadVtkMesh()
        #createGrpモードで再表示
        self.pickedData = []
        self.showCreateGrpModel()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()
        return

    #
    #  saveNewCreateElmGrp
    def saveNewCreateElmGrp(self, grpName):
        """ 作成したelmGrpをmeshファイルに保存する。"""
        global meshHeaderData, currDir
        #grpDataを取得(表層のelmのみ)
        grpData = self.createdGrp[1]
        #currDirを実際のcurrDirに変更
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        precopyCntFromTempToCurrDir()
        #copyCntFromTempToCurrDir()
        #copyMshFromTempToCurrDir()
        #tempの設定を反映したmeshHeaderDataを作成
        meshHeaderData = createHeaderDataFromTemp(numFlag=True)
        #meshデータを取得
        #getMeshHeaderData()
        #solid要素の場合、全要素を取得する
        #  vtkは、表面要素のみ
        grpData = self.getElementGrpFromOuterElms(grpData)
        grpData.sort()
        #ngrpを追加する
        header = "!EGROUP, EGRP=" + grpName + ls
        addHeaderData = [header, grpData]
        #追加場所を検索
        searchWords = ["!EGROUP", "!SGROUP", "!NGROUP"]
        si = self.getInsertPointOfMeshHeaderData(searchWords, meshHeaderData)
        #addHeaderDataを追加
        meshHeaderData = meshHeaderData[:si] + [addHeaderData] + meshHeaderData[si:]
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        self.pickleDumpHeaderData(meshHeaderData)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  saveNewCreateSurfaceGrp
    def saveNewCreateSurfaceGrp(self, grpName):
        """ 作成したsurfaceGrpをmeshファイルに保存する。"""
        global meshHeaderData, currDir
        #grpDataを取得
        grpData = self.createdGrp[1]
        #grpDataをsort
        data = []
        for i in range(0, len(grpData), 2):
            data.append([grpData[i], grpData[i+1]])
        data.sort()
        grpData = []
        for vals in data:
            grpData += vals
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        precopyCntFromTempToCurrDir()
        #copyCntFromTempToCurrDir()
        #copyMshFromTempToCurrDir()
        #tempの設定を反映したmeshHeaderDataを作成
        meshHeaderData = createHeaderDataFromTemp(numFlag=True)
        #meshデータを取得
        #getMeshHeaderData()
        #ngrpを追加する
        addHeaderData = ["!SGROUP, SGRP="+grpName+"\n", grpData]
        #追加場所を検索
        searchWords = ["!SGROUP", "!NGROUP"]
        si = self.getInsertPointOfMeshHeaderData(searchWords, meshHeaderData)
        #挿入
        meshHeaderData = meshHeaderData[:si] + [addHeaderData] + meshHeaderData[si:]
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        self.pickleDumpHeaderData(meshHeaderData)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  saveNewCreateAllNodesGrp
    def saveNewCreateAllNodesGrp(self, grpName):
        """ 取得したegrp内の全nodeを取得してnodeGrpをmeshファイルに保存する。"""
        global meshHeaderData, currDir
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        precopyCntFromTempToCurrDir()
        #copyCntFromTempToCurrDir()
        #copyMshFromTempToCurrDir()
        #tempの設定を反映したmeshHeaderDataを作成
        meshHeaderData = createHeaderDataFromTemp(numFlag=True)
        #meshデータを取得
        #getMeshHeaderData()
        #egrp名を取得
        actorName = self.pickedData[0]
        egrpName = actorName[len("elementGrp_"):]
        #nodeNoを取得
        nodeNos = set([])
        for header, data in meshHeaderData:
            words = deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name == egrpName:
                    for elm in data:
                        nodes = elm[1:]
                        nodeNos.update(nodes)
            elif words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name == egrpName:
                    nodeNos.update(data)
        nodeNos = list(nodeNos)
        #追加するheaderDataを作成
        addHeaderData  = ["!NGROUP, NGRP=" + grpName + "\n"]
        addHeaderData += [nodeNos]
        #headerDataの追加場所を検索
        searchWords = ["!NGROUP"]
        si = self.getInsertPointOfMeshHeaderData(searchWords, meshHeaderData)
        #挿入
        meshHeaderData = meshHeaderData[:si] + [addHeaderData] + meshHeaderData[si:]
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        self.pickleDumpHeaderData(meshHeaderData)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  saveNewCreateNodeGrp
    def saveNewCreateNodeGrp(self, grpName):
        """ 作成したnodeGrpをmeshファイルに保存する。"""
        global meshHeaderData, currDir
        grpData = self.createdGrp[1]
        grpData.sort()
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        precopyCntFromTempToCurrDir()
        #copyCntFromTempToCurrDir()
        #copyMshFromTempToCurrDir()
        #tempの設定を反映したmeshHeaderDataを作成
        meshHeaderData = createHeaderDataFromTemp(numFlag=True)
        #meshデータを取得
        #getMeshHeaderData()
        #ngrpを追加する
        addHeaderData = ["!NGROUP, NGRP="+grpName+"\n", grpData]
        #追加場所を検索
        searchWords = ["!NGROUP"]
        si = self.getInsertPointOfMeshHeaderData(searchWords, meshHeaderData)
        #挿入
        meshHeaderData = meshHeaderData[:si] + [addHeaderData] + meshHeaderData[si:]
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        self.pickleDumpHeaderData(meshHeaderData)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  setCreateGrp_addGrp
    #----------------------
    def setCreateGrp_addGrp(self):
        """ 取得したgrpを既存のgrpに追加する"""
        global meshHeaderData, vtkFormat
        #grpName = self.textCtrl_grpName.get_text()
        grpName = self.combo_existGrpName.getSelectedItem()
        grpName = grpName.replace(" ", "")
        grpName = grpName.replace("\t", "")
        if grpName == "":
            title = _("エラー")
            mess = _("group名が入力されていません。") + "\n"
            mess += _("  group名を入力してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #取得結果をチェック
        if len(self.createdGrp) == 0:
            title = "エラー"
            mess = _("NGRP or SGRPが取得されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #entryをチェック
        if self.textCtrl_startFace.get_text() == "":
            title = _("エラー")
            mess = _("pick結果が取得できません。") + "\n"
            mess += "  " + _("再度、pickしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #!ELEMENTのegrp名を取得
        eegrps = []
        egrps = []
        sgrps = []
        ngrps = []
        for headerData in meshHeaderData:
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name != "":
                    eegrps.append(name)
                    egrps.append(name)
            elif words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name != "":
                    egrps.append(name)
            elif words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name != "":
                    sgrps.append(name)
            elif words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name != "":
                    ngrps.append(name)
        #grpをmeshファイルに保存
        showSettingDialog("create group")
        numSettingDialog(10, "saving "+grpName+" to mshFile...")
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            #elmGrpをmshファイルに保存
            self.saveAddCreateElmGrp(grpName)
        elif self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
            #surfaceGrpをmshファイルに保存
            self.saveAddCreateSurfaceGrp(grpName)
        else:
            #nodeGrpをmshファイルに保存
            self.saveAddCreateNodeGrp(grpName)     #主nodeを保存
            if len(self.dummyCreatedGrp) > 0:
                dummyName = "dummy_" + grpName
                grpData = self.createdGrp[:]
                self.createdGrp = self.dummyCreatedGrp[:]
                self.saveAddCreateNodeGrp(dummyName)   #dummyNodeを保存
                self.createdGrp = grpData
        #meshデータを再読込、GUIに表示
        numSettingDialog(80, "setting mesh contents...")
        self.setMeshCont()
        #vtkを再取得
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            #elmGrp作成の場合
            currDir = getCurrDirFromTempFolder()
            #vtkを全て作り直す
            createVtkSourceFiles.createVtkFiles(currDir, vtkFormat)
        else:
            #surfaceGrp, nodeGrp作成の場合
            text = self.textCtrl_startFace.get_text()
            words = text.split()
            egrp = words[0]
            currDir = getCurrDirFromTempFolder()
            vtkFile = currDir + os.sep + self.vtkFolder + os.sep + "elementGrp_" + egrp + ".vtu"
            if self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
                #surfaceGrp
                createVtkSourceFiles.addSurfaceGrp(vtkFile, grpName, self.createdGrp[1])
            else:
                #nodeGrp
                createVtkSourceFiles.addNodeGrp(vtkFile, grpName, self.createdGrp[1])
                if len(self.dummyCreatedGrp) > 0:
                    createVtkSourceFiles.addNodeGrp(vtkFile, "dummy_"+grpName, self.dummyCreatedGrp[1])
        numSettingDialog(101, "close")
        closeSettingDialog()
        #vtk表示
        self.reloadVtkMesh()
        #createGrpモードで再表示
        self.pickedData = []
        self.showCreateGrpModel()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()
        return

    #
    #  saveAddCreateElmGrp(grpName)
    def saveAddCreateElmGrp(self, grpName):
        """ 作成したelmGrpを同名のgrpに追加して保存する。"""
        global meshHeaderData, currDir
        #grpDataを取得(表層のelmのみ)
        grpData = self.createdGrp[1]
        #currDirを実際のcurrDirに変更
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        copyMshFromTempToCurrDir()
        #meshデータを取得
        getMeshHeaderData()
        #solid要素の場合、全要素を取得する
        #  vtkは、表面要素のみ
        grpData = self.getElementGrpFromOuterElms(grpData)
        #同名のgrpをチェック
        flag = 0
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name == grpName:
                    flag = 1
                    break
            elif words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name == grpName:
                    flag = 2
                    break
        if flag == 1:
            #上書きで置き換え
            data = headerData[1] + grpData
            data.sort()
            meshHeaderData[i] = [header, data]
        elif flag == 2:
            #headerからEGRP=を削除
            newWords = []
            for word in words:
                if word.find("EGRP=") < 0:
                    newWords.append(word)
            newHeader = ", ".join(newWords) + ls
            meshHeaderData[i][0] = newHeader
            #grpDataを作成
            searchWords = ["!EGROUP", "!SGROUP", "!NGROUP"]
            si = self.getInsertPointOfMeshHeaderData(searchWords, meshHeaderData)
            newHeader = "!EGROUP, EGRP=" + grpName + ls
            data = list(map(lambda x: x[0], headerData[1]))
            data += grpData
            data.sort()
            headerData = [newHeader, data]
            meshHeaderData = meshHeaderData[:si] + [headerData] + meshHeaderData[si:]
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  getInsertPointOfMeshHeaderData
    def getInsertPointOfMeshHeaderData(self, searchWords, meshHeaderData):
        """ meshHeaderDataのinsertPointを探して返す。
        検索は、searchWords内のwordを検索する。"""
        si = -1
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] in searchWords:
                si = i
                break
        if si < 0:
            lastHeader = meshHeaderData[-1][0]
            words = deleteSp(lastHeader).split(",")
            if words[0] == "!END":
                si = len(meshHeaderData) - 1
            else:
                si = len(meshHeaderData)
        return si

    #
    #  saveAddCreateSurfaceGrp(grpName)
    def saveAddCreateSurfaceGrp(self, grpName):
        """ 取得したgrpを同名のgrpに追加して保存する。"""
        global meshHeaderData, currDir
        #grpDataを取得
        grpData = self.createdGrp[1]
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        copyMshFromTempToCurrDir()
        #meshデータを取得
        getMeshHeaderData()
        #同名のgrpをチェック
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name == grpName:
                    #上書きで置き換え
                    newHeader = pyFistr.setValName(header, "SGRP="+grpName)
                    data = headerData[1] + grpData
                    subData = []
                    for ii in range(0, len(data), 2):
                        subData.append((data[ii], data[ii+1]))
                    data = list(set(subData))
                    data.sort()
                    subData = []
                    for cellNo, faceNo in data:
                        subData.append(cellNo)
                        subData.append(faceNo)
                    data = subData
                    meshHeaderData[i] = [newHeader, data]
                    break
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  saveAddCreateNodeGrp
    def saveAddCreateNodeGrp(self, grpName):
        """ 取得したgrpを同名のgrpに追加して保存する。"""
        global meshHeaderData, currDir
        grpData = self.createdGrp[1]
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        copyMshFromTempToCurrDir()
        #meshデータを取得
        getMeshHeaderData()
        #同名のgrpをチェック
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name == grpName:
                    #上書きで置き換え
                    newHeader = pyFistr.setValName(header, "NGRP="+grpName)
                    data = headerData[1] + grpData
                    data = list(set(data))
                    meshHeaderData[i] = [newHeader, data]
                    break
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  setCreateGrp_delGrp
    #----------------------
    def setCreateGrp_delGrp(self):
        """ 取得したgrpを既存のgrpに追加する"""
        global meshHeaderData, vtkFormat
        #grpName = self.textCtrl_grpName.get_text()
        grpName = self.combo_existGrpName.getSelectedItem()
        grpName = grpName.replace(" ", "")
        grpName = grpName.replace("\t", "")
        if grpName == "":
            title = _("エラー")
            mess = _("group名が入力されていません。") + "\n"
            mess += _("  group名を入力してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #取得結果をチェック
        if len(self.createdGrp) == 0:
            title = "エラー"
            mess = _("NGRP or SGRPが取得されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #entryをチェック
        if self.textCtrl_startFace.get_text() == "":
            title = _("エラー")
            mess = _("pick結果が取得できません。") + "\n"
            mess += "  " + _("再度、pickしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #!ELEMENTのegrp名を取得
        eegrps = []
        egrps = []
        sgrps = []
        ngrps = []
        for headerData in meshHeaderData:
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name != "":
                    eegrps.append(name)
                    egrps.append(name)
            elif words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name != "":
                    egrps.append(name)
            elif words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name != "":
                    sgrps.append(name)
            elif words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name != "":
                    ngrps.append(name)
        #grpをmeshファイルに保存
        showSettingDialog("create group")
        numSettingDialog(10, "saving "+grpName+" to mshFile...")
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            #elmGrpをmshファイルに保存
            self.saveDelCreateElmGrp(grpName)
        elif self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
            #surfaceGrpをmshファイルに保存
            self.saveDelCreateSurfaceGrp(grpName)
        else:
            #nodeGrpをmshファイルに保存
            self.saveDelCreateNodeGrp(grpName)     #主nodeを保存
            if len(self.dummyCreatedGrp) > 0:
                dummyName = "dummy_" + grpName
                grpData = self.createdGrp[:]
                self.createdGrp = self.dummyCreatedGrp[:]
                self.saveDelCreateNodeGrp(dummyName)   #dummyNodeを保存
                self.createdGrp = grpData
        #meshデータを再読込、GUIに表示
        numSettingDialog(80, "setting mesh contents...")
        self.setMeshCont()
        #vtkを再取得
        if self.createdGrp[0][:len("elmGrp_")] == "elmGrp_":
            #elmGrp作成の場合
            currDir = getCurrDirFromTempFolder()
            #vtkを全て作り直す
            createVtkSourceFiles.createVtkFiles(currDir, vtkFormat)
        else:
            #surfaceGrp, nodeGrp作成の場合
            text = self.textCtrl_startFace.get_text()
            words = text.split()
            egrp = words[0]
            currDir = getCurrDirFromTempFolder()
            vtkFile = currDir + os.sep + self.vtkFolder + os.sep + "elementGrp_" + egrp + ".vtu"
            if self.createdGrp[0][:len("surfaceGrp_")] == "surfaceGrp_":
                #surfaceGrp
                createVtkSourceFiles.delSurfaceGrp(vtkFile, grpName, self.createdGrp[1])
            else:
                #nodeGrp
                createVtkSourceFiles.delNodeGrp(vtkFile, grpName, self.createdGrp[1])
                if len(self.dummyCreatedGrp) > 0:
                    createVtkSourceFiles.delNodeGrp(vtkFile, "dummy_"+grpName, self.dummyCreatedGrp[1])
        numSettingDialog(101, "close")
        closeSettingDialog()
        #vtk表示
        self.reloadVtkMesh()
        #createGrpモードで再表示
        self.pickedData = []
        self.showCreateGrpModel()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()
        return

    #
    #  saveDelCreateElmGrp
    def saveDelCreateElmGrp(self, grpName):
        """ 作成したelmGrpを同名のgrpから削除して保存する。"""
        global meshHeaderData, currDir
        #grpDataを取得(表層のelmのみ)
        grpData = self.createdGrp[1]
        #currDirを実際のcurrDirに変更
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        copyMshFromTempToCurrDir()
        #meshデータを取得
        getMeshHeaderData()
        #solid要素の場合、全要素を取得する
        #  vtkは、表面要素のみ
        grpData = self.getElementGrpFromOuterElms(grpData)
        #同名のgrpをチェック
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name == grpName:
                    #該当を削除
                    data = list(set(headerData[1]) - set(grpData))
                    data.sort()
                    meshHeaderData[i] = [header, data]
                    break
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  saveDelCreateSurfaceGrp
    def saveDelCreateSurfaceGrp(self, grpName):
        """ 作成したsurGrpを同名のgrpから削除して保存する。"""
        global meshHeaderData, currDir
        #grpDataを取得
        grpData = self.createdGrp[1]
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        copyMshFromTempToCurrDir()
        #meshデータを取得
        getMeshHeaderData()
        #同名のgrpをチェック
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name == grpName:
                    #該当を削除
                    subDataSet = set([])
                    subGrpSet = set([])
                    for ii in range(0, len(headerData[1]), 2):
                        vals = tuple([headerData[1][ii], headerData[1][ii+1]])
                        subDataSet.add(vals)
                    for ii in range(0, len(grpData), 2):
                        vals = tuple([grpData[ii], grpData[ii+1]])
                        subGrpSet.add(vals)
                    data = list(subDataSet - subGrpSet)
                    data.sort()
                    newData = []
                    for vals in data:
                        newData += vals
                    meshHeaderData[i] = [header, newData]
                    break
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return

    #
    #  saveDelCreateNodeGrp
    def saveDelCreateNodeGrp(self, grpName):
        """ 作成したnodeGrpを同名のgrpから削除して保存する。"""
        global meshHeaderData, currDir
        grpData = self.createdGrp[1]
        #currDirを実際のcurrdirに変更する
        currDir = getCurrDirFromTempFolder()
        #tempの設定を保存する
        copyMshFromTempToCurrDir()
        #meshデータを取得
        getMeshHeaderData()
        #同名のgrpをチェック
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name == grpName:
                    #該当を削除
                    data = list(set(headerData[1]) - set(grpData))
                    data.sort()
                    meshHeaderData[i] = [header, data]
                    break
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #currDirを元に戻す
        currDir = currDirTemp
        getMeshHeaderData()
        return
    
    #
    #  getElementGrpFromOuterElms
    def getElementGrpFromOuterElms(self, grpData):
        """ solid要素の場合、外表面のelmsからelmGrp全体を取得する"""
        
        def isSolidElm(elmType):
            solidElms = set(["341", "342", "351", "352", "361", "362"])
            if elmType in solidElms:
                return True
            else:
                return False

        def setNodeElmDict(elmNo, nodeNos, nodeElmDict):
            for nodeNo in nodeNos:
                if nodeNo in nodeElmDict.keys():
                    nodeElmDict[nodeNo].append(elmNo)
                else:
                    nodeElmDict[nodeNo] = [elmNo]
            return nodeElmDict

        def addDict(elms, nodeElmDict, elmNodeDict):
            """ 要素dataを辞書に追加する"""
            for elm in elms:
                elmNo = elm[0]
                nodeNos = elm[1:]
                if len(nodeNos) == 4:       #tet:四面体
                    nodeElmDict = setNodeElmDict(elmNo, nodeNos, nodeElmDict)
                    elmNodeDict[elmNo] = nodeNos[:]
                elif len(nodeNos) == 8:     #hex:六面体
                    nodeElmDict = setNodeElmDict(elmNo, nodeNos, nodeElmDict)
                    elmNodeDict[elmNo] = nodeNos[:]
                elif len(nodeNos) == 6:     #prism:五面体
                    nodeElmDict = setNodeElmDict(elmNo, nodeNos, nodeElmDict)
                    elmNodeDict[elmNo] = nodeNos[:]
                elif len(nodeNos) == 10:    #tet2:四面体2次
                    nodeElmDict = setNodeElmDict(elmNo, nodeNos[:4], nodeElmDict)
                    elmNodeDict[elmNo] = nodeNos[:4]
                elif len(nodeNos) == 20:    #hex2:六面体2次
                    nodeElmDict = setNodeElmDict(elmNo, nodeNos[:8], nodeElmDict)
                    elmNodeDict[elmNo] = nodeNos[:8]
                elif len(nodeNos) == 15:    #prism2:五面体2次
                    nodeElmDict = setNodeElmDict(elmNo, nodeNos[:6], nodeElmDict)
                    elmNodeDict[elmNo] = nodeNos[:6]
            return nodeElmDict, elmNodeDict

        #pickした要素grp名を取得
        text = self.textCtrl_startFace.get_text()
        baseElmGrp = text.split()[0]
        #辞書を作成
        nodeElmDict = {}    #{nodeNo:[elm1, elm2, ...]}
        elmNodeDict = {}    #{elmNo:[node1, node2, ...]}
        #pickした要素grpの要素Noを取得
        elmNosSet = set({})
        for headerData in meshHeaderData:
            words = deleteSp(headerData[0]).split(",")
            if words[0] == "!EGROUP":
                grpName = pyFistr.getValName(headerData[0], "EGRP")
                if grpName == baseElmGrp:
                    elmNosSet = set(headerData[1])
        #!EGROUPが定義されているか？
        if len(elmNosSet) == 0:
            #!EGROUPが定義されていない場合
            if baseElmGrp == "--undefine--":
                baseElmGrp = ""
            for headerData in meshHeaderData:
                words = deleteSp(headerData[0]).split(",")
                if words[0] == "!ELEMENT":
                    elmType = pyFistr.getValName(headerData[0], "TYPE")
                    #solid要素？
                    if isSolidElm(elmType) == True:
                        grpName = pyFistr.getValName(headerData[0], "EGRP")
                        if grpName == baseElmGrp:
                            elms = headerData[1]
                            #辞書に追加
                            nodeElmDict, elmNodeDict = addDict(elms, nodeElmDict, elmNodeDict)
        else:
            #!EGROUPが定義されている場合
            for headerData in meshHeaderData:
                words = deleteSp(headerData[0]).split(",")
                if words[0] == "!ELEMENT":
                    elmType = pyFistr.getValName(headerData[0], "TYPE")
                    #solid要素？
                    if isSolidElm(elmType) == True:
                        grpName = pyFistr.getValName(headerData[0], "EGRP")
                        #ELEMENT内でEGRPが定義されているか？
                        if grpName == baseElmGrp:
                            #定義されている場合
                            elms = headerData[1]
                            #辞書に追加
                            nodeElmDict, elmNodeDict = addDict(elms, nodeElmDict, elmNodeDict)
                        else:
                            #EGRPが定義されていない場合
                            elms = headerData[1]
                            eNos = map(lambda x: x[0], elms)
                            eNos = elmNosSet.intersection(eNos)
                            elms = filter(lambda x: x[0] in eNos, elms)
                            #辞書に追加
                            nodeElmDict, elmNodeDict = addDict(elms, nodeElmDict, elmNodeDict)
        #setGrpを作成
        elmsSet = set(grpData)
        #nodesSetを作成
        nodesSet = set([])
        for elmNo in elmsSet:
            #solid要素のみ取得する
            if elmNo in elmNodeDict.keys():
                nodes = elmNodeDict[elmNo]
                nodesSet.update(nodes)
        #elmを取得
        #  newElmsSetを取得
        newNodesSet = set([])
        for nodeNo in nodesSet:
            elms = nodeElmDict[nodeNo]
            newElms = set(elms).difference(elmsSet)
            #  newNodesSetを取得
            for elmNo in newElms:
                nodes = elmNodeDict[elmNo]
                newNodesSet.update(set(nodes).difference(nodesSet))
            elmsSet.update(newElms)
        #newNodesSetが無くなるまで繰り返し
        i = 0
        while len(newNodesSet) > 0:
            #newNodeSetからnewElmsSetを取得
            nodeTempSet = set([])
            for nodeNo in newNodesSet:
                elms = nodeElmDict[nodeNo]
                newElms = set(elms).difference(elmsSet)
                #newElmsからnewNodesを取得
                for elmNo in newElms:
                    nodes = elmNodeDict[elmNo]
                    nodeTempSet.update(set(nodes).difference(nodesSet))
                #elmsSetを更新
                elmsSet.update(newElms)
            #newNodesSetを更新
            newNodesSet = nodeTempSet
            i += 1
        elms = list(elmsSet)
        return elms

    #
    #  editNgrpSelect
    #-----------------
    def editNgrpSelect(self):
        """ editGroup page のngrpを選択した時の処理"""
        GLib.timeout_add(100, self.editNgrpSelect_run)

    def editNgrpSelect_run(self):
        #選択項目を取得
        selNgrps = self.treeList_eNgrp.getSelectedItems()
        #sgrp, egrpを非選択に設定
        self.treeList_eSgrp.unselectAllItems()
        self.treeList_eEgrp.unselectAllItems()
        #選択ngrpをvtk表示
        self.preSelectedActors = list(map(lambda x: "nodeGrp_" + x, selNgrps))
        self.selectedActors = []
        self.showSelectedModel()
        #delMeshボタンを非表示
        self.button_editGroupDelMesh.set_sensitive(False)

    #
    #  editSgrpSelect
    #-----------------
    def editSgrpSelect(self):
        """ editGroup page のsgrpを選択した時の処理"""
        GLib.timeout_add(100, self.editSgrpSelect_run)

    def editSgrpSelect_run(self):
        #選択項目を取得
        selSgrps = self.treeList_eSgrp.getSelectedItems()
        #ngrp, egrpを非選択に設定
        self.treeList_eNgrp.unselectAllItems()
        self.treeList_eEgrp.unselectAllItems()
        #選択ngrpをvtk表示
        self.preSelectedActors = list(map(lambda x: "surfaceGrp_" + x, selSgrps))
        self.selectedActors = []
        self.showSelectedModel()
        #delMeshボタンを非表示
        self.button_editGroupDelMesh.set_sensitive(False)
        
    #
    #  editEgrpSelect
    #------------------
    def editEgrpSelect(self):
        """ editGroup page のegrpを選択した時の処理"""
        GLib.timeout_add(100, self.editEgrpSelect_run)

    def editEgrpSelect_run(self):
        #選択項目を取得
        selEgrps = self.treeList_eEgrp.getSelectedItems()
        #ngrp, sgrpを非選択に設定
        self.treeList_eNgrp.unselectAllItems()
        self.treeList_eSgrp.unselectAllItems()
        #選択ngrpをvtk表示
        self.preSelectedActors = list(map(lambda x: "elementGrp_" + x, selEgrps))
        self.selectedActors = []
        self.showSelectedModel()
        #delMeshボタン表示
        self.button_editGroupDelMesh.set_sensitive(True)

    #
    #  editGroupRename
    #------------------
    def editGroupRename(self):
        """ 複数のgrp名の変更"""
        #選択grpTypeとgrpNamesを取得
        selType, selNames = self.getGrpTypeNamesInEditGroupPage()
        if len(selNames) == 0:
            title = _("エラー")
            mess = _("group名が選択されていません。\n")
            mess += _("名称変更するgroup名を選択してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        if "ALL" in selNames:
            title = _("エラー")
            mess = _("group名「ALL」が含まれています。") + ls
            mess += _("「ALL」は、名称変更できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        if selType == "nodeGrp":
            self.renameNodeGrps(selNames)
        elif selType == "surfaceGrp":
            self.renameSurfaceGrps(selNames)
        elif selType == "elementGrp":
            self.renameElementGrps(selNames)
        
    #
    #  getGrpTypeNamesInEditGroupPage
    def getGrpTypeNamesInEditGroupPage(self):
        """ editGroupPageの選択groupとgroup名を取得する"""
        grpNames = self.treeList_eNgrp.getSelectedItems()
        if len(grpNames) > 0:
            grpType = "nodeGrp"
            return grpType, grpNames
        grpNames = self.treeList_eSgrp.getSelectedItems()
        if len(grpNames) > 0:
            grpType = "surfaceGrp"
            return grpType, grpNames
        grpNames = self.treeList_eEgrp.getSelectedItems()
        if len(grpNames) > 0:
            grpType = "elementGrp"
            return grpType, grpNames
        return "", []

    #
    #  renameNodeGrps
    #------------------
    def renameNodeGrps(self, grpNames):
        """ nodeGrpsの名称を変更する"""
        global meshHeaderData, currDir, meshGroup
        title = _("nodeGroup名の変更")
        mess = _("新しいnodeGroup名を入力してください")
        iniText = grpNames[0]
        funcOk = [self.renameNodeGrps_onDlg, grpNames]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()
        return

    #
    #  renameNodeGrps_onDlg
    def renameNodeGrps_onDlg(self, newGrpName, grpNames):
        """ 取得したnewGrpNameを処理する。
        path,itemは、使用せず。"""
        if newGrpName == "" or len(newGrpName.split()) == 0:
            return
        #errorチェック
        if len(grpNames) > 1:
            title = _("nodeGroup名の変更")
            mess = _("複数のnodeGroup名が選択されています。") + "\n"
            mess += _("  選択groupを結合して、新しいgroupを作成しますか?")
            funcOk = [self.goRenameAddNodeGrps, grpNames, newGrpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        egrps, sgrps, ngrps = getGrpNameInTempFolder()
        if newGrpName in ngrps:
            title = _("nodeGroup名の変更")
            mess = _("新しいnodeGroup名と同名のgroup名が存在します") + "\n"
            mess += _("  そのgroupに追加しますか?")
            funcOk = [self.goRenameAddNodeGrps, grpNames, newGrpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        #1ヶのgrpNameをnewNameに変更する
        self.goRenameNodeGrp(grpNames[0], newGrpName)

    #
    #  goRenameNodeGrp
    def goRenameNodeGrp(self, grpName, newGrpName):
        """ nodeGrp名をnewNameに変更する"""
        global meshHeaderData, currDir, meshGroup, currDirTemp
        #tempのmeshHeaderDataを修正
        getMeshHeaderData()
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!NODE":
                ngrp = pyFistr.getValName(header, "NGRP")
                if ngrp == grpName:
                    newHeader = pyFistr.setValName(header, "NGRP="+newGrpName)
                    meshHeaderData[i][0] = newHeader
            elif words[0] == "!NGROUP":
                ngrp = pyFistr.getValName(header, "NGRP")
                if ngrp == grpName:
                    newHeader = pyFistr.setValName(header, "NGRP="+newGrpName)
                    meshHeaderData[i][0] = newHeader
        #tempMeshHeaderを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempのmshファイルから実meshファイルを作成保存
        currDir = getCurrDirFromTempFolder()
        copyMshFromTempToCurrDir()
        #meshContを書き換え
        meshContDict = getMeshContsFromTempFolder()
        meshCont = meshContDict["meshCont"]
        lines = meshCont.split("\n")
        for i in range(len(lines)):
            line = lines[i]
            words = line.split()
            if len(words) > 2:
                if words[0] == "NGRP" and words[1] == grpName:
                    words[1] = newGrpName
                    lines[i] = " ".join(words)
                    break
        meshCont = "\n".join(lines) + "\n"
        meshContDict["meshCont"] = meshCont
        saveCaseContDict(meshContDict)
        #meshContをlabelにセット
        self.setMeshCont()
        #vtkFileを修正、表示
        folderDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.renameNodeGrp(folderDir, grpName, newGrpName)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  goRenameAddNodeGrps
    def goRenameAddNodeGrps(self, grpNames, newGrpName):
        """ 同名のnodeGrpに追加して保存する"""
        global meshHeaderData, currDir, meshGroup, currDirTemp
        #currDirを実際のcurrDirに変更
        currDir = getCurrDirFromTempFolder()
        #meshデータを取得
        getMeshHeaderData()
        #!NODEでの定義を!NGROUPに変更する
        addHeaderData = []
        for i in range(len(meshHeaderData)):
            headerData = meshHeaderData[i]
            header = headerData[0]
            words = deleteSp(header).split(",")
            if words[0] == "!NODE":
                name = pyFistr.getValName(header, "NGRP")
                if name != "":
                    newHeader = pyFistr.deleteValName(header, "NGRP")
                    meshHeaderData[i] = [newHeader, headerData[1]]
                    addHeader = "!NGROUP, NGRP=" + name + "\n"
                    nodeNos = list(map(lambda x: x[0], headerData[1]))
                    addHeaderData.append([addHeader, nodeNos])
        if len(addHeaderData) > 0:
            #  挿入場所確認
            si = len(meshHeaderData)
            for i in range(len(meshHeaderData)):
                header = meshHeaderData[i][0]
                words = deleteSp(header).split(",")
                if words[0] == "!NGROUP":
                    si = i
                    break
                elif words[0] == "!END":
                    si = i
                    break
            #  挿入
            meshHeaderData = meshHeaderData[:si] + addHeaderData + meshHeaderData[si:]
        #grpNamesのheaderDataを取得
        grpHeaderData = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name in grpNames:
                    grpHeaderData += meshHeaderData[i][1]
        #newGrpNameに加える
        #  newGrpNameが存在するか確認
        flag = 0
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name == newGrpName:
                    newData = list(set(meshHeaderData[i][1] + grpHeaderData))
                    newData.sort()
                    meshHeaderData[i][1] = newData
                    flag = 1
                    break
        if flag == 0:
            #新たに追加する。
            addHeaderData = []
            header = "!NGROUP, NGRP=" + newGrpName + "\n"
            grpHeaderData.sort()
            addHeaderData.append([header, grpHeaderData])
            #挿入場所を確認
            for i in range(len(meshHeaderData)):
                header = meshHeaderData[i][0]
                words = deleteSp(header).split(",")
                if words[0] == "!NGROUP":
                    si = i
                    break
            meshHeaderData = meshHeaderData[:si] + addHeaderData + meshHeaderData[si:]
        #grpNameを削除
        newHeaderData = []
        for header, data in meshHeaderData:
            words = deleteSp(header).split(",")
            if words[0] == "!NGROUP":
                name = pyFistr.getValName(header, "NGRP")
                if name in grpNames:
                    pass
                else:
                    newHeaderData.append([header, data])
            else:
                newHeaderData.append([header, data])
        meshHeaderData = newHeaderData
        #meshHeaderDataを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempを作成
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #meshContをlabelにセット
        self.setMeshCont()
        #vtkFileを修正、表示
        vtkDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.addDeleteNodeGrps(vtkDir, grpNames, newGrpName)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  renameSurfaceGrps
    #---------------------
    def renameSurfaceGrps(self, grpNames):
        """ surfaceGrpsの名称を変更する"""
        global meshHeaderData, currDir, meshGroup
        #newNameを取得
        title = _("surfaceGroup名の変更")
        mess = _("新しいsurfaceGroup名を入力してください")
        iniText = grpNames[0]
        funcOk = [self.renameSurfaceGrps_onDlg, grpNames]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()
        return
    
    #
    #  renameSurfaceGrps_onDlg
    def renameSurfaceGrps_onDlg(self, newGrpName, grpNames):
        """ 取得したnewGrpNameを処理する。path,itemは使用せず。"""
        if newGrpName == "" or len(newGrpName.split()) == 0:
            return
        #errorチェック
        if len(grpNames) > 1:
            title = _("surfaceGroup名の変更")
            mess = _("複数のsurfaceGroup名が選択されています。") + "\n"
            mess += _("  選択groupを結合して、新しいgroupを作成しますか?")
            funcOk = [self.goRenameAddSurfaceGrps, grpNames, newGrpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        egrps, sgrps, ngrps = getGrpNameInTempFolder()
        if newGrpName in sgrps:
            title = _("surfaceGroup名の変更")
            mess = _("新しいsurfaceGroup名と同名のgroup名が存在します") + "\n"
            mess += _("  そのgroupに追加しますか?")
            funcOk = [self.goRenameAddSurfaceGrps, grpNames, newGrpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        #1ヶのgrpNameをnewNameに変更する
        self.goRenameSurfaceGrp(grpNames[0], newGrpName)

    #
    #  goRenameAddSurfaceGrps
    def goRenameAddSurfaceGrps(self, grpNames, newGrpName):
        """ 同名のsurfaceGrpに追加して保存する"""
        global meshHeaderData, currDir, meshGroup, currDirTemp
        #currDirを実際のcurrDirに変更
        currDir = getCurrDirFromTempFolder()
        #meshデータを取得
        getMeshHeaderData()
        #grpNamesのheaderDataを取得
        grpHeaderData = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name in grpNames:
                    grpHeaderData += meshHeaderData[i][1]
        #newGrpNameに加える
        #  newGrpNameが存在するか確認
        flag = 0
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name == newGrpName:
                    newData = list(set(meshHeaderData[i][1] + grpHeaderData))
                    newData.sort()
                    meshHeaderData[i][1] = newData
                    flag = 1
                    break
        if flag == 0:
            #新たに追加する。
            addHeaderData = []
            header = "!SGROUP, SGRP=" + newGrpName + "\n"
            #  grpHeaderDataをsortする。
            newData = []
            for i in range(0, len(grpHeaderData), 2):
                val = [grpHeaderData[i], grpHeaderData[i+1]]
                newData.append(val)
            newData.sort()
            grpHeaderData = []
            for val in newData:
                grpHeaderData += val
            #headerDataを保存
            addHeaderData.append([header, grpHeaderData])
            #挿入場所を確認
            for i in range(len(meshHeaderData)):
                header = meshHeaderData[i][0]
                words = deleteSp(header).split(",")
                if words[0] == "!SGROUP":
                    si = i
                    break
            meshHeaderData = meshHeaderData[:si] + addHeaderData + meshHeaderData[si:]
        #grpNameを削除
        newHeaderData = []
        for header, data in meshHeaderData:
            words = deleteSp(header).split(",")
            if words[0] == "!SGROUP":
                name = pyFistr.getValName(header, "SGRP")
                if name in grpNames:
                    pass
                else:
                    newHeaderData.append([header, data])
            else:
                newHeaderData.append([header, data])
        meshHeaderData = newHeaderData
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempを作成
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #meshContをlabelにセット
        self.setMeshCont()
        #vtkFileを修正、表示
        vtkDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.addDeleteSurfaceGrps(vtkDir, grpNames, newGrpName)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  renameElementGrps
    #--------------------
    def renameElementGrps(self, grpNames):
        """ elementGrpsの名称を変更する"""
        global meshHeaderData, currDir, meshGroup
        #newNameを取得
        title = _("elementGroup名の変更")
        mess = _("新しいelementGroup名を入力してください")
        iniText = grpNames[0]
        funcOk = [self.renameElementGrps_onDlg, grpNames]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()
        return
        
    #
    #  renameElementGrps_onDlg
    def renameElementGrps_onDlg(self, newGrpName, grpNames):
        """ 取得したnewGrpNameを処理する。path,itemは使用せず。"""
        if newGrpName == "" or len(newGrpName.split()) == 0:
            return
        #errorチェック
        if len(grpNames) > 1:
            title = _("elementGroup名の変更")
            mess = _("複数のelementGroup名が選択されています。") + "\n"
            mess += _("  選択groupを結合して、新しいgroupを作成しますか?")
            funcOk = [self.goRenameAddElementGrps, grpNames, newGrpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        egrps, sgrps, ngrps = getGrpNameInTempFolder()
        if newGrpName in egrps:
            title = _("elementGroup名の変更")
            mess = _("新しいelementGroup名と同名のgroup名が存在します") + "\n"
            mess += _("  そのgroupに追加しますか?")
            funcOk = [self.goRenameAddElementGrps, grpNames, newGrpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        #1ヶのgrpNameをnewNameに変更する
        self.goRenameElementGrp(grpNames[0], newGrpName)

    #
    #  goRenameElementGrp
    def goRenameElementGrp(self, grpName, newGrpName):
        """ elementGrp名をnewNameに変更する"""
        global meshHeaderData, currDir, meshGroup, currDirTemp
        #tempのmeshHeaderDataを修正
        getMeshHeaderData()
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                egrp = pyFistr.getValName(header, "EGRP")
                if egrp == grpName:
                    newHeader = pyFistr.setValName(header, "EGRP="+newGrpName)
                    meshHeaderData[i][0] = newHeader
            elif words[0] == "!EGROUP":
                egrp = pyFistr.getValName(header, "EGRP")
                if egrp == grpName:
                    newHeader = pyFistr.setValName(header, "EGRP="+newGrpName)
                    meshHeaderData[i][0] = newHeader
        #tempのmeshHeaderDataを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempのmshファイルから実mshファイルを作成保存
        currDir = getCurrDirFromTempFolder()
        copyMshFromTempToCurrDir()
        #meshContを書き換え
        meshContDict = getMeshContsFromTempFolder()
        meshCont = meshContDict["meshCont"]
        lines = meshCont.split("\n")
        for i in range(len(lines)):
            line = lines[i]
            words = line.split()
            if len(words) > 2:
                if words[0] == "EGRP" and words[1] == grpName:
                    words[1] = newGrpName
                    lines[i] = " ".join(words)
                    break
        meshCont = "\n".join(lines) + "\n"
        meshContDict["meshCont"] = meshCont
        saveCaseContDict(meshContDict)
        #meshContをlabelにセット
        self.setMeshCont()
        #vtkFileを修正
        folderDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.renameElementGrp(folderDir, grpName, newGrpName)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  goRenameAddElementGrps
    def goRenameAddElementGrps(self, grpNames, newGrpName):
        """ 同名のelementGrpに追加して保存する"""
        global meshHeaderData, currDir, meshGroup, currDirTemp
        global vtkFormat
        #currDirを実際のcurrDirに変更
        currDir = getCurrDirFromTempFolder()
        #meshデータを取得
        getMeshHeaderData()
        #grpNamesをnewGrpNameに修正(!EGROUPは、dataを取得する)
        repNos = []
        headerData = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name in grpNames:
                    newHeader = pyFistr.setValName(header, "EGRP=" + newGrpName)
                    meshHeaderData[i][0] = newHeader
            elif words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name in grpNames:
                    headerData += meshHeaderData[i][1]
                    repNos.append(i)
                elif name == newGrpName:
                    headerData += meshHeaderData[i][1]
                    repNos.append(i)
        #!EGROUPのデータをセット
        if len(repNos) > 0:
            #headerData内の重複定義をチェック
            headerData = list(set(headerData))
            headerData.sort()
            #!EGROUPのデータをセット
            repNo = repNos[-1]
            repNos = repNos[:-1]
            header = meshHeaderData[repNo][0]
            newHeader = pyFistr.setValName(header, "EGRP=" + newGrpName)
            meshHeaderData[repNo][0] = newHeader
            meshHeaderData[repNo][1] = headerData
            #余分なgrpNamesを削除
            newHeaderData = []
            for i in range(len(meshHeaderData)):
                if i in repNos:
                    pass
                else:
                    newHeaderData.append(meshHeaderData[i])
            meshHeaderData = newHeaderData
        # #meshHeaderDataを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempを作成
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #meshContをlabelにセット
        self.setMeshCont()
        #vtkFileを作成、表示
        createVtkSourceFiles.createVtkFiles(currDir, vtkFormat)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  editGroupDelete
    #------------------
    def editGroupDelete(self):
        """ 複数のgrp名の削除"""
        #選択grpTypeとgrpNamesを取得
        selType, selNames = self.getGrpTypeNamesInEditGroupPage()
        if len(selNames) == 0:
            title = _("エラー")
            mess = _("group名が選択されていません。\n")
            mess += _("削除するgroup名を選択してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        if "ALL" in selNames:
            title = _("エラー")
            mess = _("group名「ALL」が含まれています。") + ls
            mess += _("「ALL」は、group削除できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        if selType == "nodeGrp":
            self.deleteNodeGrps(selNames)
        elif selType == "surfaceGrp":
            self.deleteSurfaceGrps(selNames)
        elif selType == "elementGrp":
            self.deleteElementGrps(selNames)

    #
    #  editGroupDelMesh
    #-------------------
    def editGroupDelMesh(self):
        """ EGRPのメッシュを削除する。"""
        #選択grpTypeとgrpNamesを取得
        selType, selNames = self.getGrpTypeNamesInEditGroupPage()
        if len(selNames) == 0:
            title = _("エラー")
            mess = _("group名が選択されていません。\n")
            mess += _("名称変更するgroup名を選択してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        if selType != "elementGrp":
            return
        if "ALL" in selNames:
            title = _("エラー")
            mess = _("group名「ALL」が含まれています。") + ls
            mess += _("「ALL」は、mesh削除できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        egrps = self.treeList_eEgrp.getAllItems()
        remGrps = set(egrps) - set(selNames)
        if len(remGrps) == 0:
            title = _("エラー")
            mess = _("選択したEGRPを削除すると、メッシュが無くなります。") + ls
            mess += _("メッシュが削除できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        title = _("メッシュ削除")
        mess = _("EGRPのメッシュを削除します。") + ls
        mess += _("削除後は、元に戻りません。")
        funcOk = [self.reconfirmDeleteMeshEgrp, selNames]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
    
    #
    #  reconfirmDeleteMeshEgrp
    def reconfirmDeleteMeshEgrp(self, selNames):
        title = _("メッシュ削除")
        mess = _("本当に、メッシュを削除しますか？") + ls
        funcOk = [self.deleteMeshGrps, selNames]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)

    #
    #  deleteMeshGrps
    def deleteMeshGrps(self, grpNames):
        """ elementGrpsのメッシュを削除する"""

        def deleteIdxNos(delNos, meshHeaderData):
            newData = []
            for i in range(len(meshHeaderData)):
                if not(i in delNos):
                    newData.append(meshHeaderData[i])
            return newData

        global meshHeaderData, currDir, meshGroup
        global vtkFormat
        #実currDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #今の設定を保存する
        copyFilesFromTempToCurrDir()
        #meshHeaderDataを取得
        getMeshHeaderData()
        #削除するelmNo, indexNoを取得する
        delElmNos = []
        delNos = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            data = meshHeaderData[i][1]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name in grpNames:
                    elmNos = list(map(lambda x: x[0], data))
                    delElmNos += elmNos
                    delNos.append(i)
            elif words[0] == "!EGROUP":
                name = pyFistr.getValName(header, "EGRP")
                if name in grpNames:
                    delElmNos += data
                    delNos.append(i)
            elif words[0] == "!SECTION":
                name = pyFistr.getValName(header, "EGRP")
                if name in grpNames:
                    delNos.append(i)
        delElmNosSet = set(delElmNos)
        meshHeaderData = deleteIdxNos(delNos, meshHeaderData)
        #!ELEMENT内からdelElmNosを削除
        delNos = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            data = meshHeaderData[i][1]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if name == "":
                    newData = []
                    for vals in data:
                        elmNo = vals[0]
                        if not(elmNo in delElmNosSet):
                            newData.append(vals)
                    if len(newData) == 0:
                        delNos.append(i)
                    else:
                        meshHeaderData[i][1] = newData
        if len(delNos) > 0:
            meshHeaderData = deleteIdxNos(delNos, meshHeaderData)
        #!EGROUP, !SGROUP内からdelElmNosを削除
        delNos = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            data = meshHeaderData[i][1]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!EGROUP":
                newData = list(set(data) - delElmNosSet)
                meshHeaderData[i][1] = newData
            elif words[0] == "!SGROUP":
                newData = []
                for ii in range(0, len(data), 2):
                    elmNo = data[ii]
                    faceNo = data[ii+1]
                    if not(elmNo in delElmNosSet):
                        newData += [elmNo, faceNo]
                if len(newData) == 0:
                    delNos.append(i)
                else:
                    meshHeaderData[i][1] = newData
        if len(delNos) > 0:
            meshHeaderData = deleteIdxNos(delNos, meshHeaderData)
        #未使用NODEを削除する
        #  必要な要素内で使っているnodeNoを取得
        nodeNos = []
        for header, data in meshHeaderData:
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!ELEMENT":
                name = pyFistr.getValName(header, "EGRP")
                if not(name in grpNames):
                    for vals in data:
                        nodes = vals[1:]
                        nodeNos += nodes
        nodeNosSet = set(nodeNos)
        #  !NODE内から不要なnodeを削除
        delNos = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            data = meshHeaderData[i][1]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!NODE":
                newNodes = []
                for vals in data:
                    if vals[0] in nodeNosSet:
                        newNodes.append(vals)
                if len(newNodes) == 0:
                    delNos.append(i)
                else:
                    meshHeaderData[i][1] = newNodes
        if len(delNos) > 0:
            meshHeaderData = deleteIdxNos(delNos, meshHeaderData)
        #  !NGROUPから不要なnodeを削除
        delNos = []
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            data = meshHeaderData[i][1]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!NGROUP":
                newData = list(set(data) & nodeNosSet)
                if len(newData) == 0:
                    delNos.append(i)
                else:
                    meshHeaderData[i][1] = newData
        if len(delNos) > 0:
            meshHeaderData = deleteIdxNos(delNos, meshHeaderData)
        #meshHeaderDataを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempを作成
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        #meshContをlabelにセット
        self.setMeshCont()
        #vtkFileを作成、表示
        createVtkSourceFiles.createVtkFiles(currDir, vtkFormat)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        os.chdir(currDir)
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  hideVtk
    #-----------
    def hideVtk(self):
        """ vtk表示を表示・非表示に設定する。"""
        #checkBoxの状況を確認
        if self.check_hideVtk.get_active() == True:
            #vtk非表示設定
            self.hideVtkModelSW = "hide"
            if vtkImportFlag == "yes":
                self.showModel = False
                self.hideVtkModel()
                self.button_newReloadVtkMesh.set_sensitive(False)
                self.button_reloadVtkMesh.set_sensitive(False)
        else:
            #vtk表示
            self.hideVtkModelSW = "show"
            if vtkImportFlag == "yes":
                self.showModel = True
                self.recreateVtk = "yes"
                self.setVtkModel()
                self.button_newReloadVtkMesh.set_sensitive(True)
                self.button_reloadVtkMesh.set_sensitive(True)
        #設定を保存
        data = ["hideVtkModelSW " + self.hideVtkModelSW]
        saveIstrData(data)

    #
    #  hideVtkModel
    def hideVtkModel(self):
        """ vtk画面上のモデルを隠す"""
        #actorを削除
        self.deleteAllActors()
        #timeOutの文字を表示
        self.textActor.SetInput("Hide Model")
        #背景色をwhiteに設定
        self.renderer.SetBackground2(1, 1, 1)  # Set background to white
        self.renderer.SetBackground(1, 1, 1)
        self.renderer.GradientBackgroundOn()
        self.renderer.SetTexturedBackground(True)
        #余分なrendererを削除する
        renWin = self.vtkObj.GetRenderWindow()
        renWin.NewInstance()
        #新しいrendererを追加
        renWin.AddRenderer(self.renderer)
        self.vtkObj.Initialize()
        self.vtkObj.Start()

    #
    #  fitToWindow
    #--------------
    def fitToWindow(self):
        """ モデルサイズを画面サイズに合わせる。resetCamera"""
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()

    #
    #  viewFromXP
    #------------
    def viewFromXP(self):
        """ +X軸視（Y-Z面）"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        cameraPos = (-(Xcenter+maxLeng*2.0), Ycenter, Zcenter)
        #X軸視に設定
        camera = self.renderer.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの焦点を中心に合わせる
        camera.SetFocalPoint(Xcenter, Ycenter, Zcenter)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 0, 1)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()

    #
    #  viewFromXM
    #-------------
    def viewFromXM(self):
        """ -X軸視"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        cameraPos = (Xcenter+maxLeng*2.0, Ycenter, Zcenter)
        #X軸視に設定
        camera = self.renderer.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの焦点を中心に合わせる
        camera.SetFocalPoint(Xcenter, Ycenter, Zcenter)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 0, 1)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()
        return

    #
    #  viewFromYP
    #------------
    def viewFromYP(self):
        """ Y軸視（Z-X面）"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        #cameraPos = (Xcenter, bounds[1]*1.5, Zcenter)
        #xyzAve = (bounds[1] + bounds[3] + bounds[5]) / 3.0
        cameraPos = (Xcenter, -(Ycenter+maxLeng*2.0), Zcenter)
        #Y軸視に設定
        camera = self.renderer.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの焦点を中心に合わせる
        camera.SetFocalPoint(Xcenter, Ycenter, Zcenter)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 0, 1)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()

    #
    #  viewFromYM
    #-------------
    def viewFromYM(self):
        """ -Y軸視"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        #cameraPos = (Xcenter, bounds[1]*1.5, Zcenter)
        #xyzAve = (bounds[1] + bounds[3] + bounds[5]) / 3.0
        cameraPos = (Xcenter, Ycenter+maxLeng*2.0, Zcenter)
        #Y軸視に設定
        camera = self.renderer.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの焦点を中心に合わせる
        camera.SetFocalPoint(Xcenter, Ycenter, Zcenter)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 0, 1)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()
        return

    #
    #  viewFromZP
    #------------
    def viewFromZP(self):
        """ Z軸視（X-Y面）"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        #cameraPos = (Xcenter, Ycenter, bounds[1]*1.5)
        #xyzAve = (bounds[1] + bounds[3] + bounds[5]) / 3.0
        cameraPos = (Xcenter, Ycenter, -(Zcenter+maxLeng*2.0))
        #Z軸視に設定
        camera = self.renderer.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの焦点を中心に合わせる
        camera.SetFocalPoint(Xcenter, Ycenter, Zcenter)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 1, 0)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()

    #
    #  viewFromZM
    #-------------
    def viewFromZM(self):
        """ -Z軸視"""
        #camera位置を算出
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        maxLeng = max(bounds[1]-bounds[0], bounds[3]-bounds[2], bounds[5]-bounds[4])
        #cameraPos = (Xcenter, Ycenter, bounds[1]*1.5)
        #xyzAve = (bounds[1] + bounds[3] + bounds[5]) / 3.0
        cameraPos = (Xcenter, Ycenter, Zcenter+maxLeng*2.0)
        #Z軸視に設定
        camera = self.renderer.GetActiveCamera()
        #  camera位置を設定
        camera.SetPosition(*cameraPos)
        #  cameraの焦点を中心に合わせる
        camera.SetFocalPoint(Xcenter, Ycenter, Zcenter)
        #  cameraの縦軸の単位vectorを設定
        camera.SetViewUp(0, 1, 0)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()
        return

    #
    #  setReverseCamera
    #-------------------
    def setReverseCamera(self):
        """ camera位置を反転（左右反転）させる"""
        bounds = self.getBoundsActors()
        Xcenter = (bounds[0] + bounds[1]) / 2.0
        Ycenter = (bounds[2] + bounds[3]) / 2.0
        Zcenter = (bounds[4] + bounds[5]) / 2.0
        center = (Xcenter, Ycenter, Zcenter)
        camera = self.renderer.GetActiveCamera()
        pos = camera.GetPosition()
        relPos = (pos[0]-center[0], pos[1]-center[1], pos[2]-center[2])
        newRelPos = list(map(lambda x: -x, relPos))
        newPos = (newRelPos[0]+center[0], newRelPos[1]+center[1], newRelPos[2]+center[2])
        camera.SetPosition(*newPos)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()

    #
    #  rolling90
    #------------
    def rolling90(self):
        """ 視点を右回転（90°）させる。"""
        camera = self.renderer.GetActiveCamera()
        camera.Roll(-90.0)
        #  表示
        self.renderer.ResetCamera()
        self.vtkObj.Initialize()

    #
    #  getBoundsActors
    def getBoundsActors(self):
        """ 全actorのboundsを取得して返す。"""
        actors = self.renderer.GetActors()
        bounds = []
        for actor in actors:
            bound = actor.GetBounds()
            bounds.append(bound)
        Xmin = min(map(lambda x: x[0], bounds))
        Xmax = max(map(lambda x: x[1], bounds))
        Ymin = min(map(lambda x: x[2], bounds))
        Ymax = max(map(lambda x: x[3], bounds))
        Zmin = min(map(lambda x: x[4], bounds))
        Zmax = max(map(lambda x: x[5], bounds))
        return (Xmin, Xmax, Ymin, Ymax, Zmin, Zmax)

    #
    #  reloadVtkMesh
    #----------------
    def reloadVtkMesh(self):
        """ 制限時間を1hに設定して、meshを再読込し、vtk表示させる。"""
        global currDir, meshHeaderData
        limitTime = 3600.0
        #elf.hideElms = []
        self.threadManage(limitTime)

    #
    #  newReloadVtkMesh
    #--------------------
    def newReloadVtkMesh(self):
        """ 時間制限を1hに設定して、vtkMeshDataを再作成し、vtk表示させる"""
        global currDir
        limitTime = 3600.0
        #self.hideElms = []
        currDir = getCurrDirFromTempFolder()
        vtkDir = currDir + os.sep + self.vtkFolder
        if os.path.exists(vtkDir) == True:
            shutil.rmtree(vtkDir)
        self.threadManage(limitTime)

    #
    #  showAllElms
    #---------------
    def showAllElms(self):
        """ 全elmGrpを表示する"""

        def showAllElms_onDlg(radioStat):
            self.showAllElms_sub(radioStat)

        #未定義EGRPが存在するか？
        radioStat = ""
        if len(list(filter(lambda x: x.find("--undefine--") >= 0, self.allElms))) == 1:
            #存在する場合、dialogを表示する
            if len(self.allElms) == 1:
                eName = "undefine"
            else:
                eName = "undefine"
            funcName = showAllElms_onDlg
            dialog = getVtkShowContentsDDialog.getVtkShowContents(eName, funcName, parent=mainWindow)
            dialog.show()
            return
        self.showAllElms_sub(radioStat)

    #  showAllElms_sub
    def showAllElms_sub(self, radioStat):
        """ dialog表示後の処理"""
        #エラーチェック
        if self.allElms == ["elementGrp_--undefine--"] and radioStat == "egrps":
            title = _("vtk表示内容")
            mess = _("EGRPが定義されていません。") + ls
            mess += _("「--undefine--」を表示します。")
            self.warningDialog(title, mess, parent=mainWindow)
            radioStat = "undefine"
        self.showAllElmsForMeshMode(radioStat)

    #
    #  showAllElmsForMeshMode
    def showAllElmsForMeshMode(self, radioStat):
        """ radioStat(elmGrpsのみ or --undefine--のみ)に応じてvtk表示する。"""
        if self.showMeshMode == "normal":
            #group作成以外（通常のvtk表示）
            self.hideElms = []
            if radioStat == "undefine":
                #undefineのみ（undefine以外を非表示）
                self.hideElms += list(set(self.allElms) - set(["elementGrp_--undefine--"]))
            elif radioStat == "egrps":
                #undefine除く（undefineを非表示）
                self.hideElms += ["elementGrp_--undefine--"]
            self.setElmsActorName()
            self.showSelectedModel()
        else:
            #group作成用vtk
            self.pickedData = []
            self.createdGrp = []
            #solid要素を取得
            showElms = self.allElms
            #vtkを表示
            self.hideElms = []
            if radioStat == "undefine":
                #undefineのみ表示
                self.hideElms += list(set(showElms) - set(["elementGrp_--undefine--"]))
            elif radioStat == "egrps":
                #undefineを除く表示
                self.hideElms += ["elementGrp_--undefine--"]
            self.setElmsActorName()
            self.pickedData = []
            self.showCreateGrpModel()

    #
    #  setHideElms
    #--------------
    def setHideElms(self):
        """ 指定したelmGrpを隠す。"""
        if self.showMeshMode == "normal":
            selGrps = list(set(self.selectedActors + self.preSelectedActors + self.doublePickedActors))
            selElms = list(filter(lambda x: x[:len("elementGrp_")]=="elementGrp_", selGrps))
            self.hideElms = list(set(selElms + self.hideElms))
            self.setElmsActorName()
            self.showSelectedModel()
        else:
            if len(self.pickedData) > 0:
                pickedActors = [self.pickedData[0]]
                self.hideElms += pickedActors
                self.setElmsActorName()
                self.createdGrp = []
                self.pickedData = []
                self.showCreateGrpModel()

    #
    #  checkShowEdge
    #-----------------
    def checkShowEdge(self, event):
        """ edgeの表示/非表示切り替え"""
        self.deleteAllActors()
        if self.showMeshMode == "normal":
            self.addAllElementActors()
            self.addSelectedActors()
        else:
            self.showCreateGrpModel()
            self.showPickedActors()
            self.addOriginAxes()
        self.vtkObj.Initialize()

    #
    #  checkOpacity
    #---------------
    def checkOpacity(self, event):
        """ 透明、不透明切り替え"""
        self.checkShowEdge(event)

    #
    #  showOriginAxes
    #-----------------
    def showOriginAxes(self):
        """ 原点表示切り替え"""
        self.checkShowEdge("")

    #
    #  showNoneSelectedModel
    #------------------------
    def showNoneSelectedModel(self):
        """ 非選択状態のモデルを表示する"""
        if vtkImportFlag == "yes" and self.showModel == True:
            if (len(self.selectedActors) > 0 
                    or len(self.preSelectedActors) > 0
                    or len(self.currActors) == 0
                     or self.recreateVtk == "yes"):
                self.selectedActors = []
                self.preSelectedActors = []
                self.doublePickedActors = []
                self.currActors = []
                self.deleteAllActors()
                self.addAllElementActors()
                self.vtkObj.Initialize()

    #
    #  showSelectedModel
    #--------------------
    def showSelectedModel(self):
        """ 選択モデルを表示"""
        if vtkImportFlag == "yes" and self.showModel == True:
            self.currActors = []
            self.doublePickedActors = []
            self.checkShowEdge("")
            #hideElmsボタンの表示／非表示設定
            self.hideElmsButton_sensitive()

    #
    #  showCreateGrpModel
    #----------------------
    def showCreateGrpModel(self):
        """ gropu作成モードでmodelを表示する"""
        if vtkImportFlag == "yes" and self.showModel == True:
            pickedData = self.pickedData
            self.deleteAllActors()
            self.addAllElementActorsForCreateGrp(pickedData)
            self.addPickedActors(pickedData)
            self.showPickedActors()
            self.addOutlineActor()
            self.vtkObj.Initialize()

    #
    #  hideElmsButton_sensitive
    #----------------------------
    def hideElmsButton_sensitive(self):
        """ button_hideElmsのsensitiveを設定する。"""
        selGrps = self.selectedActors + self.preSelectedActors
        word = "elementGrp_"
        elmGrps = list(filter(lambda x: x[:len(word)]==word, selGrps))
        if len(elmGrps) > 0:
            self.button_hideElms.set_sensitive(True)
        else:
            self.button_hideElms.set_sensitive(False)

    #
    #  getPickedCellId
    #------------------
    def getPickedCellId(self, event):
        """ cellをpickupした時の処理"""
        pickedCellId = event[0]
        pickedActor = event[1]
        pickedPointId = event[2]
        pickedPosition = event[3]
        if pickedActor == None:
            return
        if pickedCellId < 0 and pickedPointId < 0:
            return
        #actorNameを取得
        actors = self.renderer.GetActors()
        actorName = self.getActorNameFromActor(pickedActor)
        if not actorName in self.readerDict.keys():
            return
        #pickedAcorNameを保存
        if self.pickedActorName != actorName:
            #picked変数をクリア
            self.pickedPoints = []
            self.dummyPickedPoints = []
        self.pickedActorName = actorName
        #faceモード？
        if self.pickMode == "face":
            pickedItems = self.getPickedCellContents(actorName, pickedCellId, pickedPosition)
            if pickedItems == ["solid"]:
                self.activeButtonOfCreateGrp(["NGRP", "SGRP", "EGRP"])
            elif pickedItems == ["shell"]:
                #self.activeButtonOfCreateGrp(["NGRP", "EGRP"])
                self.activeButtonOfCreateGrp(["NGRP", "SGRP", "EGRP"])
            else:
                return
        #edgeモード？
        elif self.pickMode == "edge":
            if pickedPointId < 0:
                return
            #pickしたitemを表示する
            pickedItems = self.getPickedEdgeContents(actorName, pickedCellId, 
                    pickedPointId, pickedPosition)
            #buttonの設定
            if len(pickedItems) == 0:
                return
            if pickedItems == ["beam"]:
                self.activeButtonOfCreateGrp(["NGRP", "EGRP"])
            else:
                self.activeButtonOfCreateGrp(["NGRP"])
        #pointsモード？
        elif self.pickMode == "points":
            if pickedPointId < 0:
                return
            #pickしたitemを表示する
            self.getPickedPointsContents(actorName, pickedCellId,
                pickedPointId, pickedPosition)
            #buttonの設定
            self.activeButtonOfCreateGrp([])
            self.pickedGrp = "ngrp"
            self.setCreateNewGrp()

    #
    #  activeButtonOfCreateGrp
    def activeButtonOfCreateGrp(self, NSEgrp):
        """ 指定したbuttonをactive設定"""
        self.button_getNgrp.set_sensitive(False)
        self.button_getAllNgrp.set_sensitive(False)
        if "NGRP" in NSEgrp:
            self.button_getNgrp.set_sensitive(True)
            self.button_getAllNgrp.set_sensitive(True)
        self.button_getSgrp.set_sensitive(False)
        if "SGRP" in NSEgrp:
            self.button_getSgrp.set_sensitive(True)
        self.button_getEgrp.set_sensitive(False)
        if "EGRP" in NSEgrp:
            self.button_getEgrp.set_sensitive(True)

    #
    #  getPickedCellContents
    #------------------------
    def getPickedCellContents(self, actorName, pickedCellId, pickedPosition):
        """ solid, shellで、pickしたfaceをvtk表示させる。"""
        #pickしたcellの内容を取得(solid or shell)
        if pickedCellId < 0:
            return []
        reader = self.readerDict[actorName]
        elmNos = reader.GetOutput().GetCellData().GetScalars("elmNo")
        faceNos = reader.GetOutput().GetCellData().GetScalars("faceNo")
        if pickedCellId >= elmNos.GetNumberOfValues():
            return []
        if pickedCellId >= faceNos.GetNumberOfValues():
            return []
        cell = reader.GetOutput().GetCell(pickedCellId)
        if cell == None:
            return []
        #pick内容を取得
        print(_("pickDataを取得中..."))
        nodes = []
        for i in range(cell.GetPointIds().GetNumberOfIds()):
            nodeNo = cell.GetPointId(i)
            nodes.append(nodeNo)
        elmNo = elmNos.GetValue(pickedCellId)
        sectFaceNo = faceNos.GetValue(pickedCellId)
        egrpName = actorName.replace("elementGrp_", "")
        #pickItemを取得
        sect = sectFaceNo // 100
        if sect == 1:
            pickedItem = "shell"
        elif sect == 2:
            pickedItem = "beam"
        else:
            pickedItem = "solid"
        if pickedItem == "beam":
            #pickItemがbeamの場合は戻る
            return [pickedItem]
        #textCtrlに出力
        #cellCont = egrpName + " " + str(pickedCellId) + " (" + str(elmNo) + "," + str(faceNo) + ")"
        cellCont = egrpName + " " + str(pickedCellId) + " (" + str(elmNo) + "," + str(sectFaceNo) + ")"
        self.textCtrl_startFace.set_text(cellCont)
        #grp取得結果の保存変数を定義
        self.createdGrp = []
        #pickedActorを表示
        pickedCells = [pickedCellId]
        pickedNodes = nodes
        self.pickedData = [actorName, pickedCells, pickedNodes]
        self.showCreateGrpModel()
        #elmGrpの非表示設定の準備
        self.button_hideElms.set_sensitive(True)
        print("  pickedData cell: " + cellCont)
        return [pickedItem]

    #
    # getPickedEdgeContents
    #------------------------
    def getPickedEdgeContents(self, actorName, pickedCellId, pickedPointId, pickedPosition):
        """ solid, shell, beam上でpickしたedgeを表示させる。"""
        #solid上でpick？
        if pickedCellId >= 0:
            #solid上でpickしたpointを取得
            reader = self.readerDict[actorName]
            elmNos = reader.GetOutput().GetCellData().GetScalars("elmNo")
            faceNos = reader.GetOutput().GetCellData().GetScalars("faceNo")
            if pickedCellId >= elmNos.GetNumberOfValues():
                return []
            if pickedCellId >= faceNos.GetNumberOfValues():
                return []
            cell = reader.GetOutput().GetCell(pickedCellId)
            if cell == None:
                return []
            #pickedItemを取得
            sectFaceNo = faceNos.GetValue(pickedCellId)
            sect = sectFaceNo // 100
            #pick対象がsolid？
            #  sect=0:solid, sect=1:shell, sect=2:beam
            if sect == 0:
                #pick内容を取得
                print(_("pickDataを取得中..."))
                #viewLineを取得
                camera = self.renderer.GetActiveCamera()
                viewPoint = camera.GetPosition()
                viewLine = (viewPoint, pickedPosition)
                #cellのnodeNoを順番に取得（conectivity）
                nodes = []
                for i in range(cell.GetPointIds().GetNumberOfIds()):
                    nodeNo = cell.GetPointId(i)
                    nodes.append(nodeNo)
                #edgeを取得
                edges = self.getCellEdgesFromVtk_org(nodes)
                #nodeDict作成
                nodeDict = self.getFullNodeDictFromVtk(actorName)
                elementDict = self.getFullElementDictFromVtk(actorName)
                #  nodeDictにcellsを追加
                for cellNo in elementDict.keys():
                    nodes = elementDict[cellNo]["nodes"]
                    for nodeNo in nodes:
                        nodeDict[nodeNo]["cells"].add(cellNo)
                #最近接のedgeを取得
                lenEdges = []
                for edge in edges:
                    loc1 = nodeDict[edge[0]]["loc"]
                    loc2 = nodeDict[edge[-1]]["loc"]
                    line = (loc1, loc2)
                    #viewLineとedgeの距離算出
                    l = geo.lenLineToLine(viewLine, line)
                    lenEdges.append([l, edge])
                lenEdges.sort()
                selEdge = lenEdges[0][1]
                #edgeNoを取得
                edgeNodes = selEdge
                edgeActorName = actorName.replace("element", "edgeElement")
                edgeElementDict = self.getFullElementDictFromVtk(edgeActorName)
                for cellNo in edgeElementDict.keys():
                    nodes = edgeElementDict[cellNo]["nodes"]
                    if selEdge[0] in nodes:
                        if selEdge[1] in nodes:
                            edgeNo = cellNo
                            break
                #textCtrlに出力
                grpName = actorName.replace("elementGrp_", "")
                reader = self.readerDict[actorName]
                points = reader.GetOutput().GetPointData().GetScalars("nodeNo")
                nodes = []
                for nodeNo in selEdge:
                    nodes.append(nodeNo)
                nodesStr = ",".join(list(map(str, nodes)))
                edgeCont = grpName + " " + str(edgeNo) + " (" + nodesStr + ")"
                self.textCtrl_startFace.set_text(edgeCont)
                #grp取得結果の保存変数を定義
                self.createdGrp = []
                #pickedActorを表示
                pickedEdges = [edgeNo]
                pickedNodes = edgeNodes
                self.pickedData = [edgeActorName, pickedEdges, pickedNodes]
                self.showCreateGrpModel()
                #elmGrpの非表示設定の準備
                self.button_hideElms.set_sensitive(True)
                #pickedItemsをedgeNoから取得
                nodes = edgeElementDict[edgeNo]["nodes"]
                node1 = nodes[0]
                node2 = nodes[1]
                cells1 = nodeDict[node1]["cells"]
                cells2 = nodeDict[node2]["cells"]
                comCells = set(cells1) & set(cells2)
                pickedItems = set([])
                for cellNo in comCells:
                    cellItem = elementDict[cellNo]["item"]
                    pickedItems.add(cellItem)
                pickedItems = list(pickedItems)
                print("  pickedData edge: " + edgeCont)
                return pickedItems
        #shell, beamの場合
        pickedItems = self.getPickedEdgeContents_shellBeam(actorName, pickedPointId, pickedPosition)
        return pickedItems

    #
    # getPickedEdgeContents_shellBeam
    def getPickedEdgeContents_shellBeam(self, actorName, pickedPointId, pickedPosition):
        """ shell, beam上でpickしたedgeを表示させる。"""

        def separateElementDict(elementDict):
            """ elementDictを通常のdictとdummyDictに分ける"""
            elmDict = {}
            dummyDict = {}
            for cellNo in elementDict.keys():
                valDict = elementDict[cellNo]
                nodes = valDict["nodes"]
                cellItem = valDict["item"]
                vtkType = valDict["type"]
                n = len(nodes)
                if cellItem == "solid":
                    elmDict[cellNo] = valDict
                elif cellItem == "shell":
                    if (n == 6 or n == 8) and (vtkType == 12 or vtkType == 13):
                        newValDict = valDict.copy()
                        newValDict["nodes"] = nodes[:n//2]
                        elmDict[cellNo] = newValDict
                        valDict["nodes"] = nodes[n//2:]
                        dummyDict[cellNo] = valDict
                    else:
                        elmDict[cellNo] = valDict
                elif cellItem == "beam":
                    if (n == 4 or n == 6) and (vtkType == 9 or vtkType == 13):
                        newValDict = valDict.copy()
                        newValDict["nodes"] = nodes[:n//2]
                        elmDict[cellNo] = newValDict
                        valDict["nodes"] = nodes[n//2:]
                        dummyDict[cellNo] = valDict
                    else:
                        elmDict[cellNo] = valDict
            return elmDict, dummyDict

        print(_("pickDataを取得中..."))
        #辞書作成
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        elementDict = self.getFullElementDictFromVtk(actorName)
        elementDict, dummyElmDict = separateElementDict(elementDict)
        #nodeDictにcellsを追加
        for cellNo in elementDict.keys():
            nodes = elementDict[cellNo]["nodes"]
            for nodeNo in nodes:
                nodeDict[nodeNo]["cells"].add(cellNo)
        #pickedPointのnodeNo、座標を取得
        cells = nodeDict[pickedPointId]["cells"]
        #近接edgeを取得
        neibEdges = set([])
        #pickedItems = []
        for cellId in cells:
            nodes = elementDict[cellId]["nodes"]
            cellItem = elementDict[cellId]["item"]
            #pickedItems.append(cellItem)
            if cellItem == "solid" or cellItem == "shell":
                edges = self.getCellEdgesFromVtk(nodes)
                for edge in edges:
                    if pickedPointId in edge:
                        neibEdges.add(edge)
            elif cellItem == "beam":
                nodes.sort()
                edge = tuple(nodes)
                if pickedPointId in edge:
                    neibEdges.add(edge)
        #取得できていない場合は、戻る
        if len(neibEdges) == 0:
            return []
        #近接nodeを取得
        neibNodes = set([])
        for edge in neibEdges:
            if edge[0] == pickedPointId:
                neibNodes.add(edge[-1])
            else:
                neibNodes.add(edge[0])
        neibNodes = [ [node, []] for node in neibNodes ]
        loc1 = nodeDict[pickedPointId]["loc"]
        loc2 = pickedPosition
        baseVec = geo.normal(geo.vector(loc1, loc2))
        for i in range(len(neibNodes)):
            nodeNo = neibNodes[i][0]
            loc2 = nodeDict[nodeNo]["loc"]
            nVec = geo.normal(geo.vector(loc1, loc2))
            cosVec = geo.dotProduct(baseVec, nVec)
            neibNodes[i][1] = cosVec
        #pickした場所に最近接するnodeを取得
        neibNodes.sort(key=lambda x: x[1])
        neibNode = neibNodes[-1][0]
        selEdge = [pickedPointId, neibNode]
        selEdge.sort()
        #dummyNodeを取得
        dummyEdgeNodes = []
        pickCells = nodeDict[pickedPointId]["cells"]        
        neibCells = nodeDict[neibNode]["cells"]
        pickCell = list(set(pickCells) & set(neibCells))[0]
        if pickCell in dummyElmDict.keys():
            dummyNodes = dummyElmDict[pickCell]["nodes"]
            nodes = elementDict[pickCell]["nodes"]
            idx = nodes.index(pickedPointId)
            dummyEdgeNodes.append(dummyNodes[idx])
            idx = nodes.index(neibNode)
            dummyEdgeNodes.append(dummyNodes[idx])
        #edgeNo, nodeNosを取得
        edgeActorName = actorName.replace("element", "edgeElement")
        edgeElementDict = self.getFullElementDictFromVtk(edgeActorName)
        for cellNo in edgeElementDict.keys():
            nodes = edgeElementDict[cellNo]["nodes"]
            if selEdge[0] in nodes:
                if selEdge[1] in nodes:
                    edgeNo = cellNo
                    edgeNodes = nodes
                    break
        #  dummyのedgeNoを取得
        if len(dummyEdgeNodes) > 0:
            for cellNo in edgeElementDict.keys():
                nodes = edgeElementDict[cellNo]["nodes"]
                if dummyEdgeNodes[0] in nodes:
                    if dummyEdgeNodes[1] in nodes:
                        dummyEdgeNo = cellNo
        #textCtrlに出力
        grpName = actorName.replace("elementGrp_", "")
        reader = self.readerDict[actorName]
        points = reader.GetOutput().GetPointData().GetScalars("nodeNo")
        node1 = points.GetValue(selEdge[0])
        node2 = points.GetValue(selEdge[1])
        edgeCont = grpName + " " + str(edgeNo) + " (" + str(node1) + "," + str(node2) + ")"
        self.textCtrl_startFace.set_text(edgeCont)
        #grp取得結果の保存変数を定義
        self.createdGrp = []
        #pickedActorを表示
        pickedEdges = [edgeNo]
        pickedNodes = edgeNodes
        #  dummyを追加
        if len(dummyEdgeNodes) > 0:
            pickedEdges += [dummyEdgeNo]
            pickedNodes += dummyEdgeNodes
        self.pickedData = [edgeActorName, pickedEdges, pickedNodes]
        self.showCreateGrpModel()
        #elmGrpの非表示設定の準備
        self.button_hideElms.set_sensitive(True)
        #pickedItemsをedgeNoから取得
        nodes = edgeElementDict[edgeNo]["nodes"]
        node1 = nodes[0]
        node2 = nodes[1]
        cells1 = nodeDict[node1]["cells"]
        cells2 = nodeDict[node2]["cells"]
        comCells = set(cells1) & set(cells2)
        pickedItems = set([])
        for cellNo in comCells:
            cellItem = elementDict[cellNo]["item"]
            pickedItems.add(cellItem)
        pickedItems = list(pickedItems)
        print("  pickedData edge: " + edgeCont)
        return pickedItems

    #  getPickedPointsContents
    #--------------------------
    def getPickedPointsContents(self, actorName, pickedCellId, pickedPointId, pickedPosition):
        """ solid, shell, beam上でpickしたpointを表示させる"""
        #solid上？
        if pickedCellId >= 0:
            #solid上でpickしたpointを取得
            reader = self.readerDict[actorName]
            elmNos = reader.GetOutput().GetCellData().GetScalars("elmNo")
            faceNos = reader.GetOutput().GetCellData().GetScalars("faceNo")
            if pickedCellId >= elmNos.GetNumberOfValues():
                return []
            if pickedCellId >= faceNos.GetNumberOfValues():
                return []
            cell = reader.GetOutput().GetCell(pickedCellId)
            if cell == None:
                return []
            #pickedItemを取得
            sectFaceNo = faceNos.GetValue(pickedCellId)
            sect = sectFaceNo // 100
            #pick対象がsolid？
            #  sect=0:solid, sect=1:shell, sect=2:beam
            if sect == 0:
                #pick内容を取得
                print(_("pickDataを取得中..."))
                #viewLineを取得
                camera = self.renderer.GetActiveCamera()
                viewPoint = camera.GetPosition()
                viewLine = (viewPoint, pickedPosition)
                #cellのnodeNo（conectivity）を取得
                nodes = []
                for i in range(cell.GetPointIds().GetNumberOfIds()):
                    nodeNo = cell.GetPointId(i)
                    nodes.append(nodeNo)
                #辞書作成
                nodeDict = self.getFullNodeDictFromVtk(actorName)
                #最近接のpointを取得する
                lenPoints = []
                for nodeNo in nodes:
                    loc1 = nodeDict[nodeNo]["loc"]
                    l = geo.lenLineToPoint(viewLine, loc1)
                    lenPoints.append([l, nodeNo])
                lenPoints.sort()
                pickedPointId = lenPoints[0][1]
                #textBoxに表示
                grpName = actorName.replace("elementGrp_", "")
                reader = self.readerDict[actorName]
                points = reader.GetOutput().GetPointData().GetScalars("nodeNo")
                nodeNo = points.GetValue(pickedPointId)
                pointCont = grpName + " " + str(pickedPointId) + " (" + str(nodeNo) + ")"
                self.textCtrl_startFace.set_text(pointCont)
                #pickedActorを表示
                allNodes = set(nodeDict.keys())
                self.pickedPoints = list(allNodes & set(self.pickedPoints))
                #pickedPointIdをチェック
                if pickedPointId in self.pickedPoints:
                    #pickedPintIdを削除
                    self.pickedPoints = list(set(self.pickedPoints) - set([pickedPointId]))
                    #textCtrlをクリア
                    #self.textCtrl_startFace.set_text("")
                    self.textCtrl_startFace.set_text(grpName)
                else:
                    #pickedPointIdを追加
                    self.pickedPoints += [pickedPointId]
                #createdGrpを作成
                nodeNos = reader.GetOutput().GetPointData().GetScalars("nodeNo")
                if len(self.pickedPoints) > 0:
                    grpData = []
                    for pointId in self.pickedPoints:
                        nodeNo = nodeNos.GetValue(pointId)
                        grpData.append(nodeNo)
                    self.createdGrp = ["nodeGrp_", grpData]
                else:
                    self.createGrp = []
                #pickedDataを作成
                self.pickedData = [actorName, [], self.pickedPoints]
                self.showCreateGrpModel()
                #elmGrpの非表示設定の準備
                self.button_hideElms.set_sensitive(True)
                print("  pickedData point: " + pointCont)
                return
        #shell, beamのpointsを取得
        self.getPickedPointsContents_shellBeam(actorName, pickedPointId, pickedPosition)
        return

    #
    #  getPickedPointsContents_shellBeam
    def getPickedPointsContents_shellBeam(self, actorName, pickedPointId, pickedPosition):
        """ shell, beam上でpickしたpointを表示させる。"""

        def getDummyNodeDict(elementDict):
            """ elementDictからdummyDictを作成する。
            """
            dummyDict = {}
            for cellNo in elementDict.keys():
                elmNodes = elementDict[cellNo]["nodes"]
                n = len(elmNodes)
                cellItem = elementDict[cellNo]["item"]
                vtkType = elementDict[cellNo]["type"]
                if cellItem == "shell":
                    if (n == 6 or n == 8) and (vtkType == 12 or vtkType == 13):
                        nodes = elmNodes[:n//2]
                        dummyNodes = elmNodes[n//2:]
                        for i in range(len(nodes)):
                            nodeNo = nodes[i]
                            dummyDict[nodeNo] = dummyNodes[i]
                elif cellItem == "beam":
                    if (n == 4 or n == 6) and (vtkType == 9 or vtkType == 13):
                        nodes = elmNodes[:n//2]
                        dummyNodes = elmNodes[n//2:]
                        for i in range(len(nodes)):
                            nodeNo = nodes[i]
                            dummyDict[nodeNo] = dummyNodes[i]
            return dummyDict

        print(_("pickDataを取得中..."))
        #辞書作成
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        elementDict = self.getFullElementDictFromVtk(actorName)
        getDummyDict = getDummyNodeDict(elementDict)
        #textCtrlに出力
        grpName = actorName.replace("elementGrp_", "")
        reader = self.readerDict[actorName]
        points = reader.GetOutput().GetPointData().GetScalars("nodeNo")
        nodeNo = points.GetValue(pickedPointId)
        pointCont = grpName + " " + str(pickedPointId) + " (" + str(nodeNo) + ")"
        self.textCtrl_startFace.set_text(pointCont)
        #pickedActorを表示
        allNodes = set(nodeDict.keys())
        self.pickedPoints = list(allNodes & set(self.pickedPoints))
        self.dummyPickedPoints = list(allNodes & set(self.dummyPickedPoints))
        #pickedPointIdをチェック
        if pickedPointId in self.pickedPoints:
            #pickedPintIdを削除
            self.pickedPoints = list(set(self.pickedPoints) - set([pickedPointId]))
            if pickedPointId in getDummyDict.keys():
                dummyNode = getDummyDict[pickedPointId]
                self.dummyPickedPoints = list(set(self.dummyPickedPoints) - set([dummyNode]))
            #textCtrlをクリア
            self.textCtrl_startFace.set_text("")
        else:
            #pickedPointIdを追加
            self.pickedPoints += [pickedPointId]
            if pickedPointId in getDummyDict.keys():
                self.dummyPickedPoints += [getDummyDict[pickedPointId]]
        #createdGrpを作成
        nodeNos = reader.GetOutput().GetPointData().GetScalars("nodeNo")
        if len(self.pickedPoints) > 0:
            grpData = []
            for pointId in self.pickedPoints:
                nodeNo = nodeNos.GetValue(pointId)
                grpData.append(nodeNo)
            self.createdGrp = ["nodeGrp_", grpData]
        else:
            self.createGrp = []
        if len(self.dummyPickedPoints) > 0:
            dummyGrpData = []
            for pointId in self.dummyPickedPoints:
                nodeNo = nodeNos.GetValue(pointId)
                dummyGrpData.append(nodeNo)
            self.dummyCreatedGrp = ["nodeGrp_", dummyGrpData]
        else:
            self.dummyCreatedGrp = []
        #pickedDataを作成
        self.pickedData = [actorName, [], self.pickedPoints]
        self.showCreateGrpModel()
        #elmGrpの非表示設定の準備
        self.button_hideElms.set_sensitive(True)
        print("  pickedData point: " + pointCont)
        return

    #
    #  getDoublePickedActor
    #-----------------------
    def getDoublePickedActor(self, event):
        """ cellをdoubleClickした時の処理"""
        pickedActor = event
        if pickedActor == None:
            return
        actorName = self.getActorNameFromActor(pickedActor)
        if actorName == "":
            return
        #pickedActorNameをチェック
        if len(self.doublePickedActors) != 0:
            if self.doublePickedActors[0] == actorName:
                #同じactorをpickした場合、元に戻す。
                self.doublePickedActors = []
                self.button_hideElms.set_sensitive(False)
                self.showSelectedModel()
                return
        #選択したactorNameの色を薄茶に変更する
        #surfaceのactorNameをelementのactorNameに変更
        if actorName[:len("surfaceGrp")] == "surfaceGrp":
            elName = "_".join(actorName.split("_")[1:])
            actorName = "elementGrp_" + elName
        #pickedActorを設定
        self.doublePickedActors = [actorName]
        self.button_hideElms.set_sensitive(True)
        #色を設定
        pickColorGrps = [self.doublePickedActors, [banana, white]]
        selColorGrps = [self.selectedActors, [red, white]]
        preSelColorGrps = [self.preSelectedActors, [pink, grey]]
        otherColor = [green, black]
        grpColors = [preSelColorGrps, selColorGrps, pickColorGrps]
        #self.setColorsToSurElmGrps(grpColors, otherColor)
        self.addColoredElmActor(grpColors, otherColor)

    #
    #  getActorNameFromActor
    #------------------------
    def getActorNameFromActor(self, pickedActor):
        """ actorからactorNameを取得する"""
        actorName = ""
        for name in self.actorDict.keys():
            #element側を確認
            if self.actorDict[name] == pickedActor:
                actorName = name
                break
            #edgeを確認
            words = name.split("_")
            if words[0] == "elementGrp":
                edgeName = "edgeElementGrp_" + "_".join(words[1:])
            elif words[0] == "surfaceGrp":
                edgeName = "edgeSurfaceGrp_" + "_".join(words[1:])
            if edgeName in self.edgeActorDict.keys():
                if self.edgeActorDict[edgeName] == pickedActor:
                    actorName = name
                    break
        if actorName.find("surface") >= 0:
            actorName = ""
        return actorName

    #
    #  getElmGrpFromPickedCellId
    #----------------------------
    def getElmGrpFromPickedCellId(self, cellId, actorName, getGrp):
        """ cellId（VTKのcellNo）から、elmGrpsを取得する。"""
        if cellId < 0 or actorName == "":
            return []
        print(getGrp + " in mesh will be gotton.")
        #辞書を作成する
        print("  creating nodes, elements, edges dictionary...")
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        elementDict = self.getFullElementDictFromVtk(actorName)
        #elementDictにflagを追加
        for cellId in elementDict.keys():
            elementDict[cellId]["flag"] = 0
        edgeDict = self.getEdgeDictFromVtk(elementDict)
        dicts = [nodeDict, elementDict, edgeDict]
        #初期のcheckEdgesを取得
        print("  getting elmGrp in mesh...")
        nodes = elementDict[cellId]["nodes"]
        checkEdges = self.getCellEdgesFromVtk(nodes)
        elementDict[cellId]["flag"] = 1
        #elmGrpを取得する
        angle = -2.0
        i = 0
        while len(checkEdges) > 0:
            newAns = self.getNewCheckEdgesFromVtk(checkEdges, dicts, angle)
            (checkEdges, dicts) = newAns
            i += 1
        #結果を取得
        sels = []
        for cellId in elementDict.keys():
            if elementDict[cellId]["flag"] == 1:
                sels.append(cellId)
        print("  gotton " + str(len(sels)) + " surface cells of elmGrp!")
        return sels

    #
    #  getFaceGrpsFromPickedCellId
    #-------------------------------
    def getFaceGrpsFromPickedCellId(self, cellId, actorName, angle, getGrp):
        """ cellId（VTKのcellNo）から、faceGrpsを取得する。"""
        if cellId < 0 or actorName == "":
            return []
        print(getGrp + " in same plane will be gotton.")
        #angle = math.cos(math.pi/180.0*angle)
        #辞書を作成する
        print("  creating nodes, elements, edges dictionary...")
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        elementDict = self.getFullElementDictFromVtk(actorName)
        #elementDictにflagを追加
        for cellNo in elementDict.keys():
            elementDict[cellNo]["flag"] = 0
        edgeDict = self.getEdgeDictFromVtk(elementDict)
        dicts = [nodeDict, elementDict, edgeDict]
        #初期のcheckEdgesを取得
        print("  getting solid faces in same plane...")
        nodes = elementDict[cellId]["nodes"]
        checkEdges = self.getCellEdgesFromVtk(nodes)
        elementDict[cellId]["flag"] = 1
        #faceGrpを取得する
        i = 0
        while len(checkEdges) > 0:
            newAns = self.getNewCheckEdgesFromVtk(checkEdges, dicts, angle)
            (checkEdges, dicts) = newAns
            i += 1
        #結果を取得
        if getGrp == "faceGrp":
            #FaceGrpを取得
            sels = []
            for cellId in elementDict.keys():
                if elementDict[cellId]["flag"] == 1:
                    sels.append(cellId)
            print("  gotton " + str(len(sels)) + " faces!")
        else:
            #nodeGrpを取得
            sels = []
            sels += nodes
            for edge in edgeDict.keys():
                if edgeDict[edge][1] == 1:
                    nodes = list(edge)
                    sels += nodes
            sels = list(set(sels))
            print("  gotton " + str(len(sels)) + " nodes!")
        return sels

    #
    #  getFaceGrpsFromPickedCellIdForSolidShell
    #--------------------------------------
    def getFaceGrpsFromPickedCellIdForSolidShell(self, pickedCellId, actorName, angle, getGrp):
        """ cellId（VTKのcellNo）から、faceGrpsを取得する。"""
        if pickedCellId < 0 or actorName == "":
            return []
        print(getGrp + " in same plane will be gotton.")
        print("  creating nodes, elements, edges dictionary...")
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        elementDict = self.getFullElementDictFromVtk(actorName)
        #elementDictにflagを追加
        for cellId in elementDict.keys():
            elementDict[cellId]["flag"] = 0
        elementDict, dummyElmDict = self.separateElementDict(elementDict)
        edgeDict = self.getEdgeDictFromVtk(elementDict)
        dicts = [nodeDict, elementDict, edgeDict]
        #初期のcheckEdgesを取得
        print("  getting shell faces in same plane...")
        nodes = elementDict[pickedCellId]["nodes"]
        checkEdges = self.getCellEdgesFromVtk(nodes)
        elementDict[pickedCellId]["flag"] = 1
        #angleを再設定
        cellItem = elementDict[pickedCellId]["item"]
        if cellItem == "solid" and getGrp == "elmGrp":
            #solidの場合は、全てのfaceを取得する為
            angle = -2.0
        #faceGrpを取得する
        i = 0
        while len(checkEdges) > 0:
            newAns = self.getNewCheckEdgesFromVtk(checkEdges, dicts, angle)
            (checkEdges, dicts) = newAns
            i += 1
        #結果を取得
        cells = []
        for elmNo in elementDict.keys():
            if elementDict[elmNo]["flag"] == 1:
                cells.append(elmNo)
        #elmGrpを取得？
        if getGrp == "elmGrp":
            #elmGrpの場合
            print("  gotton " + str(len(cells)) + " faces!")
            return cells
        #faceGrpを取得？
        elif getGrp == "faceGrp":
            #faceGrpの場合
            print("  gotton " + str(len(cells)) + " faces!")
            return cells
        #nodeGrpを取得？
        elif getGrp == "nodeGrp":
            #nodeGrpの場合
            nodes = []
            dummyNodes = []
            for cellNo in cells:
                nodes += elementDict[cellNo]["nodes"]
                if cellNo in dummyElmDict.keys():
                    dummyNodes += dummyElmDict[cellNo]["nodes"]
            nodes = list(set(nodes))
            dummyNodes = list(set(dummyNodes))
            print("  gotton " + str(len(nodes) + len(dummyNodes)) + " nodes!")
            return [nodes, dummyNodes]
        else:
            return []

    #
    #  separateElementDict
    def separateElementDict(self, elementDict):
        """ elementDictを主node、dummyNodeDictに分ける"""
        elmDict = {}
        dummyDict = {}
        for cellNo in elementDict.keys():
            nodes = elementDict[cellNo]["nodes"]
            cellType = elementDict[cellNo]["type"]
            value = elementDict[cellNo]["flag"]
            cellItem = elementDict[cellNo]["item"]
            vtkType = elementDict[cellNo]["type"]
            n = len(nodes)
            #if n == 6 or n == 8:
            if cellItem == "shell" and (n == 6 or n == 8) and (vtkType == 12 or vtkType == 13):
                elmDict[cellNo] = {"nodes":nodes[:n//2], "type":cellType, "flag":value, "item":cellItem}
                dummyDict[cellNo] = {"nodes":nodes[n//2:], "type":cellType, "flag":value, "item":cellItem}
            elif cellItem == "beam" and ( n == 4 or n == 6) and (vtkType == 9 or vtkType == 13):
                elmDict[cellNo] = {"nodes":nodes[:n//2], "type":cellType, "flag":value, "item":cellItem}
                dummyDict[cellNo] = {"nodes":nodes[n//2:], "type":cellType, "flag":value, "item":cellItem}
            else:
                elmDict[cellNo] = {"nodes":nodes, "type":cellType, "flag":value, "item":cellItem}
        return elmDict, dummyDict

    #
    #  getNewCheckEdgesFromvtk
    def getNewCheckEdgesFromVtk(self, checkEdges, dicts, angle):
        """ checkEdgesから新しいcheckEdgesを取得する。"""

        def getFaceLocations(cell):
            """ cellから三角形faceの座標listを取得する"""
            nodes = elementDict[cell]["nodes"]
            if len(nodes) == 3:
                loc1 = nodeDict[nodes[0]]["loc"]
                loc2 = nodeDict[nodes[1]]["loc"]
                loc3 = nodeDict[nodes[2]]["loc"]
                locs = [loc1, loc2, loc3]
            elif len(nodes) == 4:
                loc1 = nodeDict[nodes[0]]["loc"]
                loc2 = nodeDict[nodes[1]]["loc"]
                loc3 = nodeDict[nodes[2]]["loc"]
                locs = [loc1, loc2, loc3]
            elif len(nodes) == 6:
                loc1 = nodeDict[nodes[0]]["loc"]
                loc2 = nodeDict[nodes[2]]["loc"]
                loc3 = nodeDict[nodes[4]]["loc"]
                locs = [loc1, loc2, loc3]
            elif len(nodes) == 8:
                loc1 = nodeDict[nodes[0]]["loc"]
                loc2 = nodeDict[nodes[2]]["loc"]
                loc3 = nodeDict[nodes[4]]["loc"]
                locs = [loc1, loc2, loc3]
            return locs

        [nodeDict, elementDict, edgeDict] = dicts
        #checkEdgeからcheckCellを取得する
        newCheckCells = []
        for checkEdge in checkEdges:
            key = tuple(checkEdge)
            cells = edgeDict[key][0]
            if len(cells) == 2:
                #ownCell, checkCellに分ける
                if elementDict[cells[0]]["flag"] == 1:
                    checkCell = cells[1]
                    ownCell = cells[0]
                else:
                    checkCell = cells[0]
                    ownCell = cells[1]
                #checkCellがselCellに含まれるか？
                if elementDict[checkCell]["flag"] == 0:
                    #含まれない場合、faceAngleをcheck
                    locs1 = getFaceLocations(ownCell)
                    locs2 = getFaceLocations(checkCell)
                    cosAng = geo.facesAngle(locs1, locs2)
                    if cosAng > angle:
                        newCheckCells.append(checkCell)

        #newCheckEdgesを取得
        newCheckEdges = []
        for checkCell in newCheckCells:
            elementDict[checkCell]["flag"] = 1
            nodes = elementDict[checkCell]["nodes"]
            edges = self.getCellEdgesFromVtk(nodes)
            for edge in edges:
                #非選択のedge？
                if edgeDict[edge][1] == 0:
                    #非選択edgeの場合
                    newCheckEdges.append(edge)
                    edgeDict[edge][1] = 1
        #戻り値を作成
        dicts = [nodeDict, elementDict, edgeDict]
        ans = (newCheckEdges, dicts)        
        return ans

    #
    #  getNodeDictFromVtk
    def getNodeDictFromVtk(self, actorName):
        """ actorのnodeDictを作成して返す"""
        reader = self.readerDict[actorName]
        #nodeDictを作成
        points = reader.GetOutput().GetPoints().GetData()
        nodeDict = {}
        for i in range(0, points.GetSize(), 3):
            nodes = []
            nodes.append(points.GetValue(i))
            nodes.append(points.GetValue(i+1))
            nodes.append(points.GetValue(i+2))
            nodeDict[i//3] = nodes
        return nodeDict

    #
    #  getElementDictFromVtk
    def getElementDictFromVtk(self, actorName):
        """ actorのelementDictを作成
        elementDict={cellNo: [nodenos, cellType, selFlag]}"""
        reader = self.readerDict[actorName]
        elementDict = {}
        cellData = reader.GetOutput().GetCells().GetData()
        cellTypes = reader.GetOutput().GetCellTypesArray()
        nCells = reader.GetOutput().GetNumberOfCells()
        data = []
        nNodes = 0
        cellNo = 0
        for i in range(cellData.GetSize()):
            if nNodes == 0:
                if len(data) > 0:
                    elementDict[cellNo] = [data, cellType, 0]
                    cellNo += 1
                    if cellNo >= nCells:
                        break
                cellType = cellTypes.GetValue(cellNo)
                data = []
                nNodes = cellData.GetValue(i)
            else:
                nodeNo = cellData.GetValue(i)
                data.append(nodeNo)
                nNodes -= 1
        if len(data) > 0:
            elementDict[cellNo] = [data, cellType, 0]
        return elementDict

    #
    #  getEdgeDictFromVtk
    def getEdgeDictFromVtk(self, elementDict):
        """ elementDictからedgeDictを作成する
        edgeDict = {key: [cells, selFlag]}"""
        edgeDict = {}
        for cellNo in elementDict.keys():
            #nodes = elementDict[cellNo][0]
            nodes = elementDict[cellNo]["nodes"]
            edges = self.getCellEdgesFromVtk(nodes)
            for key in edges:
                if key in edgeDict.keys():
                    edgeDict[key][0].append(cellNo)
                else:
                    edgeDict[key] = [[cellNo], 0]
        return edgeDict

    #
    #  getCellEdgesFromVtk
    def getCellEdgesFromVtk(self, nodes):
        """ cellNoからcellのedges(tuple)を取得して返す"""
        edges = self.getCellEdgesFromVtk_org(nodes)
        newEdge = []
        for edge in edges:
            edge.sort()
            newEdge.append(tuple(edge))
        return newEdge

    #
    #  getCellEdgesFromVtk_org
    def getCellEdgesFromVtk_org(self, nodes):
        """ cellNoからcellのedges(tuple)を取得して返す。
        vtkのconectivityをそのまま返す。"""
        edges = []
        if len(nodes) == 3:
            edges.append([nodes[0], nodes[1]])
            edges.append([nodes[1], nodes[2]])
            edges.append([nodes[2], nodes[0]])
        elif len(nodes) == 4:
            edges.append([nodes[0], nodes[1]])
            edges.append([nodes[1], nodes[2]])
            edges.append([nodes[2], nodes[3]])
            edges.append([nodes[3], nodes[0]])
        elif len(nodes) == 6:
            edges.append([nodes[0], nodes[3], nodes[1]])
            edges.append([nodes[1], nodes[4], nodes[2]])
            edges.append([nodes[2], nodes[5], nodes[0]])
        elif len(nodes) == 8:
            edges.append([nodes[0], nodes[4], nodes[1]])
            edges.append([nodes[1], nodes[5], nodes[2]])
            edges.append([nodes[2], nodes[6], nodes[3]])
            edges.append([nodes[3], nodes[7], nodes[0]])
        return edges

    #
    #  getEdgeGrpsFromPickedEdgeId
    #------------------------------
    def getEdgeGrpsFromPickedEdgeId(self, edgeId, actorName, angle, getGrp):
        """ edgeId（vtkのedgeNo）からedgeGrpを作成する"""
        if actorName == "":
            return
        print(getGrp + " is same line will be gotton.")
        #angle = math.cos(math.pi/180.0*angle)
        #辞書作成
        print("  creating nodes, elements, edges dictionary...")
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        edgeDict = self.getFullElementDictFromVtk(actorName)
        #  edgeDictにflagを追加
        for edgeNo in edgeDict.keys():
            edgeDict[edgeNo]["flag"] = 0
        #  nodeDictにedgeNoを追加
        for edgeNo in edgeDict.keys():
            nodes = edgeDict[edgeNo]["nodes"]
            for nodeNo in nodes:
                if "edges" in nodeDict[nodeNo].keys():
                    nodeDict[nodeNo]["edges"].add(edgeNo)
                else:
                    nodeDict[nodeNo]["edges"] = set([edgeNo])
        dicts = [nodeDict, edgeDict]
        print("  getting solid edges in same plane...")
        #初期のcheckEdgesを設定
        checkEdges = [edgeId]
        #edgeGrpを取得する
        i = 0
        while len(checkEdges) > 0:
            newAns = self.getNewCheckEdgesFromVtkForEdge(checkEdges, dicts, angle)
            (checkEdges, dicts) = newAns
            i += 1
        #結果を取得
        edges = []
        for edgeNo in edgeDict.keys():
            if edgeDict[edgeNo]["flag"] == 1:
                edges.append(edgeNo)
        #groupを取得
        sels = []
        if getGrp == "nodeGrp":
            #nodeGrpの場合
            nodes = set([])
            for edgeNo in edges:
                edgeNodes = edgeDict[edgeNo]["nodes"]
                nodes = nodes | set(edgeNodes)
            sels = list(nodes)
        print("  gotton " + str(len(sels)) + " nodes!")
        return sels

    #
    #  getEdgeGrpsFromPickedEdgeIdForShell
    #--------------------------------------
    def getEdgeGrpsFromPickedEdgeIdForShell(self, edgeId, edgeActorName, angle, getGrp, pickedCellId, allDicts):
        """ edgeId（vtkのedgeNo）からshellのedgeGrpを作成する"""

        def separateDummyNodes(elementDict, edgeDict):
            """ edgeDictからdummyNodeを削除し、dummyDictを作成する。"""
            newEdgeDict = {}
            nodeToDummyDict = {}
            #dummyNodesを取得
            for elmNo in elementDict.keys():
                nodes = elementDict[elmNo]["nodes"]
                cellItem = elementDict[elmNo]["item"]
                vtkType = elementDict[elmNo]["type"]
                n = len(nodes)
                #if n == 6 or n == 8:
                if cellItem == "shell" and (n == 6 or n == 8) and (vtkType == 12 or vtkType == 13):
                    mainNodes = nodes[:n//2]
                    dummyNodes = nodes[n//2:]
                    for i in range(len(mainNodes)):
                        nodeNo = mainNodes[i]
                        nodeToDummyDict[nodeNo] = dummyNodes[i]
                elif cellItem == "beam" and (n == 4 or n == 6) and (vtkType == 9 or vtkType == 13):
                    mainNodes = nodes[:n//2]
                    dummyNodes = nodes[n//2:]
                    for i in range(len(mainNodes)):
                        nodeNo = mainNodes[i]
                        nodeToDummyDict[nodeNo] = dummyNodes[i]
            #edgeDictからdummyEdgeを削除
            for edgeNo in edgeDict.keys():
                nodes = edgeDict[edgeNo]["nodes"]
                mNodes = nodeToDummyDict.keys() & set(nodes)
                if len(mNodes) == 2:
                    #主nodeを取得
                    newEdgeDict[edgeNo] = edgeDict[edgeNo]
                elif len(mNodes) == 0:
                    #dummyNodeが無い場合
                    newEdgeDict[edgeNo] = edgeDict[edgeNo]
            return newEdgeDict, nodeToDummyDict

        if edgeActorName == "":
            return
        print(getGrp + " is same line will be gotton.")
        #辞書作成
        print("  creating nodes, elements, edges dictionary...")
        actorName = edgeActorName.replace("edgeElementGrp_", "elementGrp_")
        #nodeDict = self.getFullNodeDictFromVtk(actorName)
        #elementDict = self.getFullElementDictFromVtk(actorName)
        #edgeDict = self.getFullElementDictFromVtk(edgeActorName)
        nodeDict, elementDict, edgeDict = allDicts
        #edgeDictからdummyを分ける
        edgeDict, nodeToDummyDict = separateDummyNodes(elementDict, edgeDict)
        #  edgeDictにflagを追加
        for edgeNo in edgeDict.keys():
            edgeDict[edgeNo]["flag"] = 0
        #  nodeDictにedgeNoを追加
        for edgeNo in edgeDict.keys():
            nodes = edgeDict[edgeNo]["nodes"]
            for nodeNo in nodes:
                if "edges" in nodeDict[nodeNo].keys():
                    nodeDict[nodeNo]["edges"].add(edgeNo)
                else:
                    nodeDict[nodeNo]["edges"] = set([edgeNo])
        dicts = [nodeDict, edgeDict]
        #初期のcheckEdgeを取得
        print("  getting shell edge in same line...")
        checkEdges = [edgeId]
        #edgeGrpを取得
        i = 0
        while len(checkEdges) > 0:
            newAns = self.getNewCheckEdgesFromVtkForEdge(checkEdges, dicts, angle)
            (checkEdges, dicts) = newAns
            i += 1
        #結果を取得
        edges = []
        for edgeNo in edgeDict.keys():
            if edgeDict[edgeNo]["flag"] == 1:
                edges.append(edgeNo)
        #groupを取得
        sels = []
        if getGrp == "nodeGrp":
            #nodeGrpの場合
            nodes = set([])
            dummyNodes = set([])
            for edgeNo in edges:
                edgeNodes = edgeDict[edgeNo]["nodes"]
                for nodeNo in edgeNodes:
                    nodes.add(nodeNo)
                    if nodeNo in nodeToDummyDict.keys():
                        dummyNodeNo = nodeToDummyDict[nodeNo]
                        dummyNodes.add(dummyNodeNo)
            sels = [list(nodes), list(dummyNodes)]
            nNodes = len(nodes) + len(dummyNodes)
            print("  gotton " + str(nNodes) + " nodes!")
        return sels

    #
    #  getEdgeGrpsFromPickedEdgeIdForBeam
    #------------------------------------------
    def getEdgeGrpsFromPickedEdgeIdForBeam(self, edgeId, edgeActorName, angle, getGrp, pickedCellId, allDicts):
        """ edgeId（vtkのedgeNo）からbeamのedgeGrpを作成する"""

        def separateDummyNodes(elementDict, edgeDict):
            """ edgeDictからdummyNodeを削除し、dummyDictを作成する。"""
            newEdgeDict = {}
            nodeToDummyDict = {}
            #dummyNodesを取得
            for elmNo in elementDict.keys():
                nodes = elementDict[elmNo]["nodes"]
                cellItem = elementDict[elmNo]["item"]
                vtkType = elementDict[elmNo]["type"]
                n = len(nodes)
                #if n == 4 or n == 6:
                if cellItem == "beam" and (n == 4 or n == 6) and (vtkType == 9 or vtkType == 13):
                    mainNodes = nodes[:n//2]
                    dummyNodes = nodes[n//2:]
                    for i in range(len(mainNodes)):
                        nodeNo = mainNodes[i]
                        nodeToDummyDict[nodeNo] = dummyNodes[i]
                elif cellItem == "shell" and (n == 6 or n == 8) and (vtkType == 12 or vtkType == 13):
                    mainNodes = nodes[:n//2]
                    dummyNodes = nodes[n//2:]
                    for i in range(len(mainNodes)):
                        nodeNo = mainNodes[i]
                        nodeToDummyDict[nodeNo] = dummyNodes[i]
            #edgeDictからdummyEdgeを削除
            for edgeNo in edgeDict.keys():
                nodes = edgeDict[edgeNo]["nodes"]
                mNodes = nodeToDummyDict.keys() & set(nodes)
                if len(mNodes) == 2:
                    #主nodeを取得
                    newEdgeDict[edgeNo] = edgeDict[edgeNo]
                elif len(mNodes) == 0:
                    #dummyNodeが無い場合
                    newEdgeDict[edgeNo] = edgeDict[edgeNo]
            return newEdgeDict, nodeToDummyDict

        if edgeActorName == "":
            return

        print(getGrp + " is same line will be gotton.")
        print("  creating nodes, elements, edges dictionary...")
        actorName = edgeActorName.replace("edgeElement", "element")
        nodeDict, elementDict, edgeDict = allDicts
        #edgeDictからdummyを分ける
        edgeDict, nodeToDummyDict = separateDummyNodes(elementDict, edgeDict)
        #  edgeDictにflagを追加
        for edgeNo in edgeDict.keys():
            edgeDict[edgeNo]["flag"] = 0
        #  nodeDictにedgeNoを追加
        for edgeNo in edgeDict.keys():
            nodes = edgeDict[edgeNo]["nodes"]
            for nodeNo in nodes:
                if "edges" in nodeDict[nodeNo].keys():
                    nodeDict[nodeNo]["edges"].add(edgeNo)
                else:
                    nodeDict[nodeNo]["edges"] = set([edgeNo])
        dicts = [nodeDict, edgeDict]
        #初期のcheckEdgeを取得
        print("  getting beam edges in same line...")
        checkEdges = [edgeId]
        #edgeGrpを取得
        i = 0
        while len(checkEdges) > 0:
            newAns = self.getNewCheckEdgesFromVtkForEdge(checkEdges, dicts, angle)
            (checkEdges, dicts) = newAns
            i += 1
        #結果を取得
        edges = []
        for edgeNo in edgeDict.keys():
            if edgeDict[edgeNo]["flag"] == 1:
                edges.append(edgeNo)
        #groupを取得
        sels = []
        if getGrp == "nodeGrp":
            #nodeGrpの場合
            nodes = set([])
            dummyNodes = set([])
            for edgeNo in edges:
                edgeNodes = edgeDict[edgeNo]["nodes"]
                for nodeNo in edgeNodes:
                    nodes.add(nodeNo)
                    if nodeNo in nodeToDummyDict.keys():
                        dummyNodeNo = nodeToDummyDict[nodeNo]
                        dummyNodes.add(dummyNodeNo)
            sels = [list(nodes), list(dummyNodes)]
            nNodes = len(nodes) + len(dummyNodes)
            print("  gotton " + str(nNodes) + " nodes!")
        elif getGrp == "elmGrp":
            #elmGrpの場合
            cells = set([])
            for edgeNo in edges:
                edgeNodes = edgeDict[edgeNo]["nodes"]
                edgeCells1 = nodeDict[edgeNodes[0]]["cells"]
                edgeCells2 = nodeDict[edgeNodes[1]]["cells"]
                sameCells = set(edgeCells1) & set(edgeCells2)
                cells.update(sameCells)
            sels = list(cells)
            print("  gotton " + str(len(sels)) + " cells!")
        return sels

    #
    #  getCellIdFromPickedEdge
    def getCellIdFromPickedEdge(self, pickedEdgeId, edgeActorName):
        """ pickedEdgeからcellIdと必要な辞書を返す"""
        actorName = edgeActorName.replace("edgeElement", "element")
        nodeDict = self.getFullNodeDictFromVtk(actorName)
        elementDict = self.getFullElementDictFromVtk(actorName)
        edgeDict = self.getFullElementDictFromVtk(edgeActorName)
        #nodeDictにcellIdを追加
        for cellId in elementDict.keys():
            nodes = elementDict[cellId]["nodes"]
            for nodeId in nodes:
                nodeDict[nodeId]["cells"].add(cellId)
        #pickedEdgeのnodeIdsを取得
        nodes = edgeDict[pickedEdgeId]["nodes"]
        #cellIdsを取得
        node1 = nodes[0]
        node2 = nodes[1]
        cells1 = nodeDict[node1]["cells"]
        cells2 = nodeDict[node2]["cells"]
        cellIds = list(set(cells1) & set(cells2))
        allDicts = [nodeDict, elementDict, edgeDict]
        return cellIds, allDicts

    #
    #  getNewCheckEdgesFromVtkForEdge
    def getNewCheckEdgesFromVtkForEdge(self, checkEdges, dicts, angle):
        """ checkEdgesから新しいcheckEdgesを取得する。"""
        [nodeDict, edgeDict] = dicts
        #checkEdgesのflagをセット
        for edgeNo in checkEdges:
            edgeDict[edgeNo]["flag"] = 1
        #newCheckEdgesを取得
        newCheckEdges = []
        for edgeNo in checkEdges:
            nodes = edgeDict[edgeNo]["nodes"]
            node1 = nodes[0]
            node2 = nodes[1]
            loc1 = nodeDict[node1]["loc"]
            loc2 = nodeDict[node2]["loc"]
            #edge順方向をチェック(node1 -> node2)
            vec1 = geo.vector(loc1, loc2)
            otherEdges = nodeDict[node2]["edges"]
            for oEdgeNo in otherEdges:
                if edgeDict[oEdgeNo]["flag"] == 0:
                    otherNodes = edgeDict[oEdgeNo]["nodes"]
                    if otherNodes[0] == node2:
                        node3 = otherNodes[1]
                    else:
                        node3 = otherNodes[0]
                    loc3 = nodeDict[node3]["loc"]
                    vec2 = geo.vector(loc2, loc3)
                    if geo.vecsAngle(vec1, vec2) > angle:
                        newCheckEdges.append(oEdgeNo)
            #edge反対方向をチェック(node2 -> node1)
            vec1 = geo.vector(loc2, loc1)
            otherEdges = nodeDict[node1]["edges"]
            for oEdgeNo in otherEdges:
                if edgeDict[oEdgeNo]["flag"] == 0:
                    otherNodes = edgeDict[oEdgeNo]["nodes"]
                    if otherNodes[0] == node1:
                        node3 = otherNodes[1]
                    else:
                        node3 = otherNodes[0]
                    loc3 = nodeDict[node3]["loc"]
                    vec2 = geo.vector(loc1, loc3)
                    if geo.vecsAngle(vec1, vec2) > angle:
                        newCheckEdges.append(oEdgeNo)
        dicts = [nodeDict, edgeDict]
        return newCheckEdges, dicts

    #
    #  getFullNodeDictFromVtk
    #-------------------------
    def getFullNodeDictFromVtk(self, actorName):
        """ fullSpecのnodeDictを作成する。"""
        if actorName[:len("element")] == "element":
            reader = self.readerDict[actorName]
        else:
            reader = self.edgeReaderDict[actorName]
        #nodeDictを作成
        points = reader.GetOutput().GetPoints().GetData()
        nodeDict = {}
        for i in range(0, points.GetSize(), 3):
            nodes = []
            nodes.append(points.GetValue(i))
            nodes.append(points.GetValue(i+1))
            nodes.append(points.GetValue(i+2))
            nodeDict[i//3] = {"loc":nodes, "cells":set([])}
        return nodeDict

    #
    #  getFullElementDictFromVtk
    #-----------------------------
    def getFullElementDictFromVtk(self, actorName):
        """ fullSpecのelementDictを作成する"""
        if actorName[:len("element")] == "element":
            reader = self.readerDict[actorName]
        else:
            reader = self.edgeReaderDict[actorName]
        elementDict = {}
        cellData = reader.GetOutput().GetCells().GetData()
        cellTypes = reader.GetOutput().GetCellTypesArray()
        faceNos = reader.GetOutput().GetCellData().GetScalars("faceNo")
        nCells = reader.GetOutput().GetNumberOfCells()
        data = []
        nNodes = 0
        cellNo = 0
        for i in range(cellData.GetSize()):
            if nNodes == 0:
                if len(data) > 0:
                    #elementDict[cellNo] = [data, cellType, 0]
                    elementDict[cellNo] = {"nodes":data, "type":cellType, "item":cellItem}
                    cellNo += 1
                    if cellNo >= nCells:
                        break
                cellType = cellTypes.GetValue(cellNo)
                if faceNos != None:
                    #faceNo = faceNos.GetValue(cellNo)
                    sectFaceNo = faceNos.GetValue(cellNo)
                    sect = sectFaceNo // 100
                    if sect == 1:
                        cellItem = "shell"
                    elif sect == 2:
                        cellItem = "beam"
                    else:
                        cellItem = "solid"
                    # if faceNo == 0:
                    #     cellItem = "shell"
                    # elif faceNo == 99:
                    #     cellItem = "beam"
                    # else:
                    #     cellItem = "solid"
                else:
                    cellItem = "" 
                data = []
                nNodes = cellData.GetValue(i)
            else:
                nodeNo = cellData.GetValue(i)
                data.append(nodeNo)
                nNodes -= 1
        if len(data) > 0:
            #elementDict[cellNo] = [data, cellType, 0]
            elementDict[cellNo] = {"nodes":data, "type":cellType, "item":cellItem}
        return elementDict

    #---------- vtk 関連 ここまで ---------------------------

    #---------- Tree_dir (folderDir) 関連 -------------------
    #
    #  checkConnectingServer
    #------------------------
    def checkConnectingServer(self):
        """ serverが接続されているか確認"""
        #serverがマウントされているdirを取得
        serverDirs = []
        mountServers = pyFistr.servers().getMountedServers()
        if len(mountServers) > 0:
            serverDirs = list(map(lambda x: x[2], mountServers))
            for serverDir in serverDirs:
                if len(glob.glob(serverDir + os.sep + "*")) == 0:
                    #serverDirが空の場合
                    serverName = pyFistr.servers().getServerName(serverDir)
                    server = pyFistr.server(serverName)
                    server.sshfsDict["mountPoint"] = ""
                    server.writeSshfsData()

    #
    #  setFolderDirInTree
    #---------------------
    def setFolderDirInTree(self):
        """ folderDirをtree_dirにセットする。"""
        #currDirの取得
        currDir = getCurrDirFromTempFolder()
        #rootからcurrDirまでのdirを取得
        folders = self.getAllFolders(currDir)
        folders = self.getNeedFolders(folders)
        dataDict = self.createDataDict(folders)
        self.treeWidget.dataDict = dataDict
        #treeのitemを定義(item、headerの内容、itemの位置変数を定義)
        (headers, itemDefines, colWidthes) = self.defineTreeItem()
        #treeViewの定義
        self.treeWidget.defineTreeView(headers, itemDefines,
                    colWidthes, multi=True)
        #itemの辞書（itemDict）を作成
        itemDict = self.createItemDict(folders)
        self.treeWidget.itemDict = itemDict
        #treeDataを作成
        treeData = self.treeWidget.createTreeData(itemDict)
        self.treeWidget.treeData = treeData
        #treeNodesを作成し、表示する
        self.treeWidget.createTreeNodes()
        #currDirまで展開する
        self.treeWidget.expandToCurrDir(currDir)
        #currDirを選択する(scrollして選択表示させる)
        self.treeWidget.selectDir(currDir)
        #currDirのiconと書体を設定する
        self.setSelectedDir(currDir)
        #eventMaskを解除
        self.maskEvent = False

    def setSelectedDir(self, currDir):
        """ currDirをチェック付アイコン、bold、redに設定する"""
        if self.treeWidget.itemDict[currDir][self.COL_ICON] == self.iconFolder:
            icon = self.iconFolderCk
        elif self.treeWidget.itemDict[currDir][self.COL_ICON] == self.iconFolderLink:
            icon = self.iconFolderLinkCk
        elif self.treeWidget.itemDict[currDir][self.COL_ICON] == self.iconCase:
            icon = self.iconCaseCk
        elif self.treeWidget.itemDict[currDir][self.COL_ICON] == self.iconCaseLink:
            icon = self.iconCaseLinkCk
        self.treeWidget.changeColFromDir(currDir, self.COL_ICON, icon)
        self.treeWidget.changeColFromDir(currDir, self.COL_WEIGHT, self.BOLD)
        self.treeWidget.changeColFromDir(currDir, self.COL_COLOR, "red")

    def getFolTypeIcon(self, folder, folType, serverDirs):
        """ folderのiconを取得して返す"""
        #server内をチェック
        folderList = folder.split(os.sep)
        serverLists = list(map(lambda x: x.split(os.sep), serverDirs))
        isServer = False
        for serverList in serverLists:
            if serverList == folderList[:len(serverList)]:
                isServer = True
                break
        #server内？
        if isServer == True:
            #server内のfolder
            if folType == "case":
                icon = self.iconCase
            elif folType == "caseLink":
                icon = self.iconCaseLink
            elif folType == "folder":
                icon = self.iconServerFolder
            elif folType == "folderLink":
                icon = self.iconServerFolderLn
            else:
                icon = self.iconServerFolder
        else:
            #通常のfolder
            if folType == "case":
                icon = self.iconCase
            elif folType == "caseLink":
                icon = self.iconCaseLink
            elif folType == "folder":
                icon = self.iconFolder
            elif folType == "folderLink":
                icon = self.iconFolderLink
            else:
                icon = self.iconFolder
        return icon

    def createItemDict(self, folders):
        """ dirをkeyとして、treeNodesに保存する内容の辞書を作成する。
        辞書の内容は、itemDefinesに従った内容。"""
        #serverDirsを取得
        serverDirs = []
        mountServers = pyFistr.servers().getMountedServers()
        if len(mountServers) > 0:
            serverDirs = list(map(lambda x: x[2], mountServers))
        #itemの辞書作成
        itemDict = {}
        #rootを作成
        rootDir = folders[0]
        itemCont = [self.iconFolder, rootDir, "", "", "", "", "", self.NORMAL, "black"]
        #itemCont = [self.iconFolder, rootDir, "", "", "", "", self.NORMAL, "black"]
        itemDict[rootDir] = itemCont
        #rootDir以下を作成
        for folder in folders[1:]:
            folderCont = self.treeWidget.dataDict[folder]
            folType = folderCont[0]
            #iconを設定
            icon = self.getFolTypeIcon(folder, folType, serverDirs)
            #itemDictを作成
            itemName = os.path.basename(folder)
            itemCont = [icon, itemName] + folderCont[1:] + [self.NORMAL, "black"]
            itemDict[folder] = itemCont
        return itemDict

    def defineTreeItem(self):
        """ itemの内容とheaderを定義する。"""
        global istrData
        #dirColWidthを取得
        dirColWidth = 200
        for line in istrData:
            words = line.split()
            if words[0] == "treeDirColWidth":
                dirColWidth = int(words[1])
                break
        #itemを定義
        pixbuf = GdkPixbuf.Pixbuf
        weight = Pango.Weight
        #              icon    dir  solutin     solver    model    size nRes  (bold)  color
        itemDefines = [pixbuf, str, str,        str,      str,     str, str,  weight, str]
        headers     = ["directory", "solution", "solver", "model", "meshSize(MB)", "nRes"]
        colWidthes  = [dirColWidth,  None,       None,     100,     None,           None]

        # #              icon    dir  solutin     solver    model    size   (bold)  color
        # itemDefines = [pixbuf, str, str,        str,      str,     str,   weight, str]
        # headers     = ["directory", "solution", "solver", "model", "meshSize(MB)"]
        # colWidthes  = [dirColWidth,  None,       None,     100,     None]
        
        #位置変数を定義
        self.COL_ICON     = 0
        self.COL_DIR      = 1
        self.COL_SOLUTION = 2
        self.COL_SOLVER   = 3
        self.COL_MODEL    = 4
        self.COL_SIZE     = 5
        self.COL_NRES     = 6
        self.COL_WEIGHT   = 7
        self.COL_COLOR    = 8
        #dirの位置をtreeWidgetに渡す。
        self.treeWidget.COL_DIR = self.COL_DIR
        return (headers, itemDefines, colWidthes)

    def createDataDict(self, folders):
        """ treeを作成する為の辞書（dataDict）を作成する"""
        #folderの辞書作成
        dataDict = {}
        for folder in folders:
            folderCont = self.getFolderCont(folder)
            dataDict[folder] = folderCont
        return dataDict

    def getFolderCont(self, folderDir):
        """ folderの内容を取得する
        folderCont = folType, solType, solver, model, meshSize, nRes
        """
        folderCont = folderContHddVals.getFolderCont(folderDir)
        return folderCont

    # def getNumberOfResults(self, folderDir):
    #     """ 結果のflder数を取得"""
    #     n = folderContHddVals.getNumResults(folderDir)
    #     return n

    def getNeedFolders(self, folders):
        """ 必要なfolderのみ取得して返す。"""

        def isNeedFolder(folder):
            """ 必要なfolderかどうかcheckして返す"""
            name = os.path.basename(folder)
            if name.find(".vis_psf.") >= 0:
                flag = False
            elif name == "vtkMeshData" or name == "vtkCadData":
                flag = False
            else:
                flag = True
            return flag

        newFolders = list(filter(isNeedFolder, folders))
        return newFolders

    def getAllFolders(self, currDir):
        """ rootからcurrDirまでの全folderDirを取得して返す"""
        folders = self.getLocalFolders(currDir)
        folders += self.getServerFolders(currDir)
        folders = list(set(folders))
        folders.sort()
        return folders

    def getLocalFolders(self, currDir):
        """ rootからcurrDirまでのlocal側のfolderを取得して返す"""
        #serverがマウントされているdirを取得
        serverDirs = []
        mountServers = pyFistr.servers().getMountedServers()
        if len(mountServers) > 0:
            serverDirs = list(map(lambda x: x[2], mountServers))
        #serverDirs以外のfolderを取得
        folders = self.treeWidget.getDirUnderRootToSelDir(self.rootDir, currDir, maskDirs=serverDirs)
        folders += self.treeWidget.getChildFolders(folders, maskDirs=serverDirs)
        folders = list(set(folders))
        folders.sort()
        return folders
        
    def getServerFolders(self, currDir):
        """ rootからcurrDirまでのserver側のfolderを取得して返す"""
        #serverがマウントされているdirを取得
        serverDirs = []
        mountServers = pyFistr.servers().getMountedServers()
        if len(mountServers) > 0:
            serverDirs = list(map(lambda x: x[2], mountServers))
            #server内のfolderを取得
            folders = []
            currDirList = currDir.split(os.sep)
            #server毎にfolderを取得
            for serverDir in serverDirs:
                parentDirList = serverDir.split(os.sep)[:-1]
                if parentDirList == currDirList[:len(parentDirList)]:
                    #folder取得
                    tempFolders = self.treeWidget.getFoldersBetweenDir(serverDir, currDir)
                    tempFolders += self.treeWidget.getChildFolders(tempFolders)
                    folders += tempFolders
            folders = list(set(folders))
            folders.sort()
        else:
            #serverがマウントされていない場合
            folders = []
        return folders

    def remakeNormalIconInTreeDir(self, currDir):
        """ currDirのアイコンを元に戻す"""
        if self.treeWidget.itemDict[currDir][self.COL_ICON] == self.iconFolder:
            icon = self.iconFolder
        elif self.treeWidget.itemDict[currDir][self.COL_ICON] == self.iconCase:
            icon = self.iconCase
        self.treeWidget.changeColFromDir(currDir, self.COL_ICON, icon)
        self.treeWidget.changeColFromDir(currDir, self.COL_WEIGHT, self.NORMAL)
        self.treeWidget.changeColFromDir(currDir, self.COL_COLOR, "black")

    def remakeCheckIconInTreeDir(self, currDir):
        """ currDirをcheck付iconに修正する"""
        self.treeWidget.changeColFromDir(currDir, self.COL_ICON, self.iconCaseCk)
        self.treeWidget.changeColFromDir(currDir, self.COL_WEIGHT, self.BOLD)
        self.treeWidget.changeColFromDir(currDir, self.COL_COLOR, "red")
    
    #
    #  expandTreeDir
    #-----------------
    def expandTreeDir(self, path):
        """ expandした時のevent"""
        #currDirの取得
        currDir = getCurrDirFromTempFolder()
        #pathのchildrenを全て削除（2ヶの辞書も削除）
        self.treeWidget.deleteChildrenPath(path)
        #path以下のfolderを取得
        expDirList = self.treeWidget.getDirFromTreePath(path)
        expDir = os.sep.join(expDirList)
        folders = self.treeWidget.getFolders(expDir)
        folders += self.treeWidget.getChildFolders(folders)
        folders = self.getNeedFolders(folders)
        if not currDir in self.treeWidget.dataDict.keys():
            folders += [currDir]
        folders.sort()
        #辞書に新しい内容を追加
        self.addNewDataToDict(folders)
        #treeDataを再作成
        itemDict = self.treeWidget.itemDict
        treeData = self.treeWidget.createTreeData(itemDict)
        self.treeWidget.treeData = treeData
        #parentDir以下を再作成
        items = self.treeWidget.getItemsFromTreeData(expDir)
        treeStore = self.treeWidget.treeStore
        parentIter = self.treeWidget.getIterInTreeView(expDir)
        self.treeWidget.addTreeNodes(treeStore, parentIter, items)
        #currDirを再設定（icon、書体、fontColor）
        self.setSelectedDir(currDir)
        #expDirを展開する
        self.maskEvent = True
        self.treeWidget.expandChildDir(expDir)
        self.maskEvent = False


    #
    #  addNewDataToDict
    def addNewDataToDict(self, folders):
        """ 辞書にnewDataを追加する"""
        #serverDirsを取得
        serverDirs = []
        mountServers = pyFistr.servers().getMountedServers()
        if len(mountServers) > 0:
            serverDirs = list(map(lambda x: x[2], mountServers))
        #辞書に追加する
        for folder in folders:
            #dataDictに追加
            folderCont = self.getFolderCont(folder)
            self.treeWidget.dataDict[folder] = folderCont
            #itemDictに追加
            folType = folderCont[0]
            #  iconを設定
            icon = self.getFolTypeIcon(folder, folType, serverDirs)
            #  dir名を設定
            name = os.path.basename(folder)
            if folder == self.rootDir:
                name = folder
            #  itemContを作成
            itemCont = [icon, name] + folderCont[1:] + [self.NORMAL, "black"]
            self.treeWidget.itemDict[folder] = itemCont
    
    #
    #  setFolderContToTreeItem
    #---------------------------
    def setFolderContToTreeItem(self, folderDir):
        """ dirTree内の指定したdirの内容を再取得して書き換える。
        treeWidgte.treeDataは、変わらないので、修正しない。"""
        #folderContを再取得
        folderCont = self.getFolderCont(folderDir)
        self.writeFolderContToTreeItem(folderDir, folderCont)
        
    def writeFolderContToTreeItem(self, folderDir, folderCont):
        #dataDictを書き換え
        self.treeWidget.dataDict[folderDir] = folderCont
        #itemDictを書き換え
        oldItemCont = self.treeWidget.itemDict[folderDir]
        icon = oldItemCont[0]
        itemName = oldItemCont[1]
        weight = oldItemCont[-2]
        color = oldItemCont[-1]
        newItemCont = [icon, itemName] + folderCont[1:] + [weight, color]
        self.treeWidget.itemDict[folderDir] = newItemCont
        #colの内容を修正
        newCont = newItemCont[self.COL_SOLUTION]
        self.treeWidget.changeColFromDir(folderDir, self.COL_SOLUTION, newCont)
        newCont = newItemCont[self.COL_SOLVER]
        self.treeWidget.changeColFromDir(folderDir, self.COL_SOLVER, newCont)
        newCont = newItemCont[self.COL_MODEL]
        self.treeWidget.changeColFromDir(folderDir, self.COL_MODEL, newCont)
        newCont = newItemCont[self.COL_SIZE]
        self.treeWidget.changeColFromDir(folderDir, self.COL_SIZE, newCont)
        newCont = newItemCont[self.COL_NRES]
        self.treeWidget.changeColFromDir(folderDir, self.COL_NRES, newCont)

    #
    #  setNumResultsToTreeItem
    #---------------------------
    def setNumResultsToTreeItem(self, folderDir):
        """ dirTreeの指定したdirのnResを再取得して書き換える。
        更新専用。"""
        #結果のfile数を取得
        n = self.getNumberOfResults(folderDir)
        self.writeNumResultsToTreeItem(folderDir, n)

    def writeNumResultsToTreeItem(self, folderDir, n):
        #今の設定内容を取得
        loc_nRes = 5
        try:
            old_nRes = int(self.treeWidget.dataDict[folderDir][loc_nRes])
        except:
            return
        if n == old_nRes:
            #読み取ったnResが同じ値の場合、何もせず戻る
            return
        #結果file数を設定
        nRes = ("%4d" % n) + " "
        #dataDictを修正
        self.treeWidget.dataDict[folderDir][loc_nRes] = nRes
        #itemDictを修正
        self.treeWidget.itemDict[folderDir][self.COL_NRES] = nRes
        #colの内容を修正
        self.treeWidget.changeColFromDir(folderDir, self.COL_NRES, nRes)

    #
    #  deleteNodeGrps
    def deleteNodeGrps(self, grpNames):
        """ nodeGrpを削除する"""
        global meshHeaderData, currDir, meshGroup
        #currDirのmshファイルからnodeGrpを削除する
        currDir = getCurrDirFromTempFolder()
        currDirTrue = currDir
        os.chdir(currDir)
        meshHeaderData = getReturnMeshHeaderData()
        meshHeaderData = copyTempFiles.deleteGrpFromHeaderNumData(meshHeaderData, "NGRP", grpNames)
        newLines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(newLines)
        self.pickleDumpHeaderData(meshHeaderData)
        #tempDir戻してmshファイルを保存
        currDir = currDirTemp
        os.chdir(currDir)
        lines = shrinkMeshLines(newLines)
        writeFistrModelMsh(lines)
        #実folderに戻して継続
        currDir = currDirTrue
        os.chdir(currDir)
        #meshHeaderDataを読み込み
        getMeshHeaderData()
        #meshContを書き換え
        meshContDict = getMeshContsFromTempFolder()
        meshCont = meshContDict["meshCont"]
        lines = meshCont.split("\n")
        newLines = []
        for i in range(len(lines)):
            line = lines[i]
            words = line.split()
            if len(words) > 2:
                if words[0] == "NGRP" and words[1] in grpNames:
                    pass
                else:
                    newLines.append(line)
            else:
                newLines.append(line)
        meshCont = "\n".join(newLines) + "\n"
        meshContDict["meshCont"] = meshCont
        saveCaseContDict(meshContDict)
        #meshContをlabelにセット
        self.setMeshCont()
        #ngrpを修正
        egrps, sgrps, ngrps = meshGroup
        ngrps = list(set(ngrps).difference(grpNames))
        meshGroup = [egrps, sgrps, ngrps]
        #vtkFileを修正、表示
        folderDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.deleteNodeGrp(folderDir, grpNames)
        self.reloadVtkMesh()
        #currDirを元に戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  deleteSurfaceGrps
    def deleteSurfaceGrps(self, grpNames):
        """ surfaceGrpを削除する"""
        global meshHeaderData, currDir, meshGroup
        #currDirのmshファイルからnodeGrpを削除する
        currDir = getCurrDirFromTempFolder()
        currDirTrue = currDir
        os.chdir(currDir)
        meshHeaderData = getReturnMeshHeaderData()
        meshHeaderData = copyTempFiles.deleteGrpFromHeaderNumData(meshHeaderData, "SGRP", grpNames)
        newLines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(newLines)
        self.pickleDumpHeaderData(meshHeaderData)
        #tempDir戻してmshファイルを保存
        currDir = currDirTemp
        os.chdir(currDir)
        lines = shrinkMeshLines(newLines)
        writeFistrModelMsh(lines)
        #実folderに戻して継続
        currDir = currDirTrue
        os.chdir(currDir)
        #meshHeaderDataを読み込み
        getMeshHeaderData()
        #meshContを書き換え
        meshContDict = getMeshContsFromTempFolder()
        meshCont = meshContDict["meshCont"]
        lines = meshCont.split("\n")
        newLines = []
        for i in range(len(lines)):
            line = lines[i]
            words = line.split()
            if len(words) > 2:
                if words[0] == "SGRP" and words[1] in grpNames:
                    pass
                else:
                    newLines.append(line)
            else:
                newLines.append(line)
        meshCont = "\n".join(newLines) + "\n"
        meshContDict["meshCont"] = meshCont
        saveCaseContDict(meshContDict)
        #meshContをlabelに表示
        self.setMeshCont()
        #sgrpsを修正
        egrps, sgrps, ngrps = meshGroup
        sgrps = list(set(sgrps).difference(grpNames))
        meshGroup = [egrps, sgrps, ngrps]
        #vtkFileを修正、表示
        folderDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.deleteSurfaceGrp(folderDir, grpNames)
        self.reloadVtkMesh()
        #currDirを戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  deleteElementGrps
    def deleteElementGrps(self, grpNames):
        """ elementGrpを削除する"""
        global meshHeaderData, currDir, meshGroup
        #currDirのmshファイルからnodeGrpを削除する
        currDir = getCurrDirFromTempFolder()
        currDirTrue = currDir
        os.chdir(currDir)

        meshHeaderData = getReturnMeshHeaderData()
        meshHeaderData = copyTempFiles.deleteGrpFromHeaderNumData(meshHeaderData, "EGRP", grpNames)
        newLines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(newLines)
        self.pickleDumpHeaderData(meshHeaderData)
        #tempDir戻してmshファイルを保存
        currDir = currDirTemp
        os.chdir(currDir)
        lines = shrinkMeshLines(newLines)
        writeFistrModelMsh(lines)
        #実folderに戻して継続
        currDir = currDirTrue
        os.chdir(currDir)


        # lines = readFistrModelMsh()
        # lines = copyTempFiles.deleteGrpHeaderFromMsh(lines, "EGRP", grpNames)
        # pyFistr.writeFistrModelMsh(lines)
        # #tempFolderのmshファイルからnodeGrpを削除
        # os.chdir(currDirTemp)
        # lines = readFistrModelMsh()
        # lines = copyTempFiles.deleteGrpHeaderFromMsh(lines, "EGRP", grpNames)
        # pyFistr.writeFistrModelMsh(lines)
        

        #meshHeaderDataを読み込み
        getMeshHeaderData()
        #meshCont書き換え
        meshContDict = getMeshContsFromTempFolder()
        meshCont = meshContDict["meshCont"]
        lines = meshCont.split("\n")
        newLines = []
        for i in range(len(lines)):
            line = lines[i]
            words = line.split()
            if len(words) > 2:
                if words[0] == "EGRP" and words[1] in grpNames:
                    pass
                else:
                    newLines.append(line)
            else:
                newLines.append(line)
        meshCont = "\n".join(newLines) + "\n"
        meshContDict["meshCont"] = meshCont
        saveCaseContDict(meshContDict)
        #meshContをlabelに表示
        self.setMeshCont()
        #egrpsを修正
        egrps, sgrps, ngrps = meshGroup
        egrps = list(set(egrps).difference(grpNames))
        meshGroup = [egrps, sgrps, ngrps]
        #vtkFileを修正、表示
        folderDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.deleteElementGrp(folderDir, grpNames)
        #vtkFileがundefineのみかどうか確認する
        vtkFiles = glob.glob(folderDir+"/elementGrp_*.vtu")
        if len(vtkFiles) == 1:
            if os.path.basename(vtkFiles[0]).find("--undefine--") >=0:
                title = _("vtk表示内容")
                mess = _("EGRPが定義されていません。") + ls
                mess += _("「--undefine--」を表示します。")
                self.warningDialog(title, mess, parent=mainWindow)
        self.setUndefineToHideElms()
        self.setVtkModel()
        self.reloadVtkMesh()
        #currDirを戻す
        currDir = currDirTemp
        #headerDataを読み直し
        getMeshHeaderData()
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  goRenameSurfaceGrp
    def goRenameSurfaceGrp(self, grpName, newGrpName):
        """ surfaceGrp名をnewNameに変更する"""
        global meshHeaderData, currDir, meshGroup, currDirTemp
        #tempのmeshHeaderDataを修正
        getMeshHeaderData()
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!SGROUP":
                sgrp = pyFistr.getValName(header, "SGRP")
                if sgrp == grpName:
                    newHeader = pyFistr.setValName(header, "SGRP="+newGrpName)
                    meshHeaderData[i][0] = newHeader
        #tempのmeshHeaderDataを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #tempのmshファイルから実meshファイルを作成保存
        currDir = getCurrDirFromTempFolder()
        copyMshFromTempToCurrDir()
        #meshContを書き換え
        meshContDict = getMeshContsFromTempFolder()
        meshCont = meshContDict["meshCont"]
        lines = meshCont.split("\n")
        for i in range(len(lines)):
            line = lines[i]
            words = line.split()
            if len(words) > 2:
                if words[0] == "SGRP" and words[1] == grpName:
                    words[1] = newGrpName
                    lines[i] = " ".join(words)
                    break
        meshCont = "\n".join(lines) + "\n"
        meshContDict["meshCont"] = meshCont
        saveCaseContDict(meshContDict)
        #meshContをlabelに表示
        self.setMeshCont()
        #vtkFileを修正、表示
        folderDir = currDir + os.sep + self.vtkFolder
        createVtkSourceFiles.renameSurfaceGrp(folderDir, grpName, newGrpName)
        self.reloadVtkMesh()
        #currDirを戻す
        currDir = currDirTemp
        #cntFileをチェック修正
        self.setControlCont()
        matchControlCont()
        #pageを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #pageを表示
        self.setTreeSetPage(expPathes, selPath)
        self.editGroup()
        return

    #
    #  pressMouseButton
    #-------------------
    def pressMouseButton(self, widget, event):
        """ dirTreeの左右クリック、ダブルクリック時の動作。
        eventは、クリックした瞬間に発生しているので、
        TreeViewのrowは未だ選択されていない状態。"""
        pos = (event.x, event.y)
        #  clickDirを取得
        pathinfo = self.treeWidget.treeView.get_path_at_pos(event.x, event.y)
        if pathinfo == None:
            return
        path, _col, _x, _y = pathinfo
        clickDirList = self.treeWidget.getDirFromTreePath(path)
        clickDir = os.sep.join(clickDirList)
        #rightClick?
        if event.button == 3:
            #rightClickの場合
            #  選択dirを取得
            selDirs = self.treeWidget.getSelectedDirs()
            #clickDirが選択されている？
            if clickDir in selDirs:
                #  0.1s後に再選択する
                th = threading.Thread(target=self.afterSelectDir, args=(selDirs,))
                th.start()
            #popupMenuを表示
            self.showPopupMenu(pos)
        #single or doubleClick?
        elif event.button == 1:
            #doubleClick?
            if event.type.value_name == "GDK_2BUTTON_PRESS":
                self.doubleClickRow(pos)
            #singleClick?
            elif event.type.value_name == "GDK_BUTTON_PRESS":
                #statusBarにHDDの内容を書き込み
                currDir = getCurrDirFromTempFolder()
                if currDir == clickDir:
                    rootDir = self.treeWidget.treeData[0]
                    if clickDir != rootDir:
                        #timeoutを設定してfolderCont, Hddを取得
                        if self.threadClickFlag != "run":
                            self.threadClickFlag = "run"
                            #th = threading.Thread(target=self.threadGetFolderContHdd,
                            #                      args=(currDir,))
                            #th.start()
                            self.threadGetFolderContHdd(currDir)

    #
    #  keyPress
    #-----------
    def keyPress(self, event):
        """ tree_dirのkey eventの処理"""
        keyName = Gdk.keyval_name(event.keyval)
        if keyName == "Control_L" or keyName == "Control_R":    #ctrlKey?
            self.ctrlKeyFlag = 1
        elif keyName == "Right":
            selDir = self.treeWidget.getSelectedDir()
            self.treeWidget.expandChildDir(selDir)
        elif keyName == "Left":
            selDir = self.treeWidget.getSelectedDir()
            self.treeWidget.collapseChildDir(selDir)
        elif keyName == "Up":
            self.upCursorTree()
        elif keyName == "Down":
            self.downCursorTree()
        elif keyName == "Return":
            self.openFolder()
        elif keyName == "F2":
            self.renameFolder()
        elif keyName == "Delete":
            self.deleteFolder()
        #ctrlKeyとのセット
        if self.ctrlKeyFlag == 1:
            if keyName.lower() == "c":
                self.copyFolder()
            elif keyName.lower() == "v":
                self.pasteFolder()
            elif keyName.lower() == "b":
                self.casePasteFolder()
            elif keyName.lower() == "n":
                self.addNewFolder()

    #
    #  keyRelease
    #--------------
    def keyRelease(self, event):
        """ tree_dirのkeyRelease eventの処理"""
        keyName = Gdk.keyval_name(event.keyval)
        if keyName == "Control_L" or keyName == "Control_R":
            self.ctrlKeyFlag = 0

    #
    #  upCursorTree
    def upCursorTree(self):
        """ tree_dir上のcursorUpさせる"""
        #選択dir、pathを取得
        selDir = self.treeWidget.getSelectedDir()
        selPath = self.treeWidget.getPathInTreeView(selDir)
        #cursorをアップさせる
        newPath = self.treeWidget.cursorUp(selPath)
        #選択表示させる
        selDirList = self.treeWidget.getDirFromTreePath(newPath)
        selDir = os.sep.join(selDirList)
        self.treeWidget.unselectAllDir()
        self.treeWidget.selectDir(selDir)

    #
    #  downCursorTree
    def downCursorTree(self):
        """ tree_dir上のcursorUpさせる"""
        #選択dir、pathを取得
        selDir = self.treeWidget.getSelectedDir()
        selPath = self.treeWidget.getPathInTreeView(selDir)
        #cursorDownさせる
        newPath = self.treeWidget.cursorDown(selPath)
        #選択表示させる
        selDirList = self.treeWidget.getDirFromTreePath(newPath)
        selDir = os.sep.join(selDirList)
        self.treeWidget.unselectAllDir()
        self.treeWidget.selectDir(selDir)

    #
    #  threadGetHddNumResults
    #-------------------------
    def threadGetHddNumResults(self, folderDir):
        #timeoutを設定してHDD内容とnResを取得
        #res = procGetHddNumResults(folderDir, timeout=0.2)
        res = procGetHddNumResults(folderDir, timeout=0.3)
        if len(res) == 0:
            #timeout発生時
            text = self.label_statusBar.get_text()
            text = "*" + text[1:]
            self.label_statusBar.set_text(text)
        else:
            #正常に終了（結果を取得）
            total, free, nRes = res
            #total, free = res
            #statusBar書き込み
            self.writeHddUsageToStatusBar(total, free)
            #結果file数書き込み
            self.writeNumResultsToTreeItem(folderDir, nRes)
        self.threadFlag = "stop"

    #
    #  threadGetFolderContHdd
    #----------------------
    def threadGetFolderContHdd(self, folderDir):
        #res = procGetFolderContHdd(folderDir, timeout=0.2)
        res = procGetFolderContHdd(folderDir, timeout=0.3)
        if len(res) == 0:
            #取得できていない場合
            text = self.label_statusBar.get_text()
            text = "*" + text[1:]
            self.label_statusBar.set_text(text)
        else:
            folderCont = res[:6]
            total = int(res[6]); free = int(res[7])
            #folderCont = res[:5]
            #total = int(res[5]); free = int(res[6])
            #hdd容量を書き込み
            self.writeHddUsageToStatusBar(total, free)
            self.writeFolderContToTreeItem(folderDir, folderCont)
        self.threadClickFlag = "stop"

    #
    #  afterSelectDir
    def afterSelectDir(self, selDirs):
        """ 0.1s後に再選択する"""
        time.sleep(0.1)
        self.treeWidget.selectDirs(selDirs)

    #
    #  doubleClickRow
    def doubleClickRow(self, pos):
        """ doubleClick時の動作"""
        (dummy, pathes) = self.treeWidget.treeView.get_selection().get_selected_rows()
        colNo = self.getColumnNoFromPos(pathes[0], pos)
        if colNo == -1:
            #解析dir(作業folder)に設定
            event = pos
            self.changeCurrDir(event)
            return
        elif colNo == -2:
            #解析dir(作業folder)に設定
            event = pos
            self.changeCurrDir(event)
            return
        self.openFolder()

    def openFolder(self):
        """ fileManagerでfolderを開く"""
        #fileManager起動
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        currDir = selDirs[0]
        if os.name == "nt":
            #windows
            comm = runFileManagerComm + " " + currDir
            #os.system(comm)
            pyFistr.run().command(comm)
        else:
            #linux
            comm = runFileManagerComm + " " + currDir + " &"
            #os.system(comm)
            pyFistr.run().command(comm)

    def warningMultiSelectionDir(self):
        """ Dirの複数選択の警告"""
        title = _("directoryの選択")
        mess = _("複数のdirectoryが選択されています。") + ls
        mess += _("  1ヶのdirectoryを選択し直してください。")
        self.warningDialog(title, mess, parent=mainWindow)

    def getColumnNoFromPos(self, path, pos):
        """ pathとpos(x,y)から、そのposのcolumnNoを返す。
        colNo=-2:欄外（y方向）
        colNo=-1:欄外（x方向）
        colNo=0:treeDir部
        colNo=1以上:col部"""
        for i in range(len(self.treeWidget.treeView.get_columns())):
            #cellサイズを取得 rect = (rect.x, rect.y, rect.width, rect.height)
            # (rect.x 〜 rect.x + rect.width)
            rect = self.treeWidget.treeView.get_cell_area(path, self.treeWidget.treeView.get_column(i))
            if pos[0] < rect.x:
                break
        #クリックのxがcell高さよりも小さい？
        if pos[0] < rect.height:
            #treeViewのheader位置
            colNo = -2
        else:
            colNo = i - 1
        return colNo

    #
    #  showPopupMenu
    def showPopupMenu(self, pos):
        """ popupMenuを表示する。"""
        menuItems = [
            #  label                accKey      handler
            [_("開く"),             "Return",   self.popOpenFolder],
            [_("端末起動"),         "",         self.popRunTerm],
            [_("-"),                "",         ""],
            [_("コピー"),     "Ctrl+C",         self.popCopyFolder],
            [_("貼り付け"),   "Ctrl+V",         self.popPasteFolder],
            [_("case貼り付け(計算結果除く)"), "Ctrl+B", self.popCasePasteFolder],
            [_("-"),                "",         ""],
            [_("folder名変更"),     "F2",       self.popRenameFolder],
            [_("新しいfolder追加"), "Ctrl+N",   self.popAddNewFolder],
            [_("folder削除"),       "Delete",   self.popDeleteFolder],
            [_("-"),                "",         ""],
            [_("folder内の計算結果を削除"), "", self.popDeleteResults],
            [_("folder内のFistrDataを削除"), "", self.popDeleteAllDataFiles],
            [_("-"),                "",         ""],
            [_("loginシェル起動"),  "",         self.popRunLoginShell],
            [_("server Job管理"),   "",         self.popServerJob],
            [_("sshfsサーバ マウント"), "",     self.popServerMount],
            [_("sshfsサーバ アンマウント"), "", self.popServerUnmount],
            [_("貼り付け(scp圧縮転送,cp)"), "", self.popScpPasteFolder],
            [_("case貼り付け(scp圧縮転送,cp)"),"", self.popScpCasePasteFolder],
            [_("server内folder削除(rm)"), "",   self.popDeleteServer]
            ]

        #選択dirを取得
        menu = Gtk.Menu()
        for menuItem in menuItems:
            menuName, accName, func = menuItem
            if menuName == "-":
                #separateをセット
                item = Gtk.SeparatorMenuItem()
            else:
                #menuItemをセット
                box = Gtk.Box.new(Gtk.Orientation.HORIZONTAL, 0)
                item = Gtk.MenuItem()
                label = Gtk.Label()
                label.set_text(menuName)
                box.pack_start(label, False, False, 4)
                labelAcc = Gtk.Label()
                labelAcc.set_text(accName)
                labelAcc.set_xalign(1)      #右詰め
                box.pack_start(labelAcc, True, True, 0)
                item.add(box)
                item.connect("activate", func)
                item = self.setPopupItemSensitive(item, menuName)
            menu.append(item)
        #menuを表示
        menu.show_all()
        menu.popup(None, None, None, None, 0, Gtk.get_current_event_time())

    #
    #  setPopupItemSensitive
    def setPopupItemSensitive(self, item, menuName):
        """ itemの非表示設定"""
        hideItems = [
            _("loginシェル起動"),
            _("server Job管理"), 
            _("sshfsサーバ マウント"),
            _("sshfsサーバ アンマウント"),
            _("貼り付け(scp圧縮転送,cp)"),
            _("case貼り付け(scp圧縮転送,cp)"),
            _("server内folder削除(rm)") ]
        if os.name == "nt":
            #windowsの場合は、隠す
            if menuName in hideItems:
                item.set_sensitive(False)
            else:
                item.set_sensitive(True)
        return item

    #
    #  setShowToolTip
    #------------------
    def setShowToolTip(self, pos):
        """ tooltipの設定、表示。
        TreeViewで「motion-notify-event」でeventを発生させる。
        #gladeファイル内のpropertyを直接修正してtooltipを表示する。
        glgade側で、widgetの「共通」タグ内のtooltipにその内容を記述しておく。
        gladeファイルのpropertyの取得方法は、
            <widget>.property("tooltip-text") or
            <widget>.prop.tooltip_text
        で取得できる。"""
        (x, y) = pos
        pathInfo = self.treeWidget.treeView.get_path_at_pos(x, y)
        if pathInfo == None:
            return
        (path, _col, x, y) = pathInfo
        if path == None:
            return
        #dirを取得
        tooltipDirList = self.treeWidget.getDirFromTreePath(path)
        tooltipDir = os.sep.join(tooltipDirList)
        #選択case上にマウスカーソルがあるか？
        selDirs = self.treeWidget.getSelectedDirs()
        if tooltipDir in selDirs:
            #マウスカーソルの位置を取得
            colNo = self.getColumnNoFromPos(path, pos)
            if colNo == -1:
                tooltipText = _("ここをダブルクリックすると") + "\n"
                tooltipText += _("作業用folderに設定する。")
            elif colNo == -2:
                tooltipText = _("ここをダブルクリックすると") + "\n"
                tooltipText += _("作業用folderに設定する。")
            else:
                tooltipText = _("ここをダブルクリックすると") + "\n"
                tooltipText += _("folderを開く。")
        else:
            #tooltip非表示
            tooltipText = ""
        #tooltipを表示
        self.treeWidget.treeView.props.tooltip_text = tooltipText
    #----------------------------------------------------------------------


    #  setTitle
    #    title, version, currDirを設定
    def setTitle(self):
        title = "EasyISTR5 for FrontISTR-5  (ver " + version + ")"
        self.label_title.set_label(title)
        self.versionLabel.set_label("ver " + version)
        trueCurrDir = getCurrDirFromTempFolder()
        title = "EasyISTR5: " + trueCurrDir.split(os.sep)[-1]
        mainWindow.set_title(title)
        self.setCurrDirInLabel(trueCurrDir)
        self.setUnitToTitle()
        
    def setCurrDirInLabel(self, dispDir):
        maxNum = 65
        if len(dispDir) > maxNum:
            dispDir = "..." + dispDir[3-maxNum:]
        self.label_currDir.set_label("currDir: " + dispDir)

    # def setWindowSize(self):
    #     """ windowSizeを設定する。"""
    #     x, y = 800, 600     #windowSize(デフォルト)
    #     fileName = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + winSizeFileName
    #     if len(glob.glob(fileName)) != 0:
    #         f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
    #         for line in lines:
    #             words = line.split()
    #             if len(words) >= 3:
    #                 if words[0] == "windowSize":
    #                     xy = words[1:3]
    #                     try:
    #                         [x, y] = list(map(int, xy))
    #                     except:
    #                         pass
    #                     break
    #     #winSizeを設定
    #     mainWindow.set_default_size(x, y)

    def subInitialize(self):
        #istrDataをセット
        self.setIstrData()
        #cnt,mshファイルの有無チェック（存在しない場合は、defaultをコピー）
        self.checkCntMshFile()
        #cntファイル内容をチェック修正
        checkReformCntFile()
        #cntファイルをlistBoxにセット
        self.setCntFilesToListBox()
        #Fistrmodel.mshデータを取得
        getMeshHeaderData()
        self.setMeshCont()          #labelにmeshContをセット
        #FistrModel.cntデータ取得
        self.setControlCont()       #cntFileの内容を取得
        matchControlCont()          #meshとcntFileの整合をとる
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #材料物性値のDialog表示
        self.readMaterialDB()
        self.setMaterialNameToListBox()
        self.setMaterialModelToComboBox()
        #titleページを表示
        showPage = _(u"FrontISTR")
        self.showNoteBook(showPage)

    #
    #  createTreeItemsPathInts
    def createTreeItemsPathInts(self):
        """ TreeItemのPathInts（path代わりの数値のlist）を作成する"""
        #全treeのpathIntを作成
        pathInts = []
        treestore = self.treestore
        #rootを取得
        pathInt = [0]
        pathInts.append(pathInt)
        rootPath = Gtk.TreePath.new_from_indices(pathInt)
        rootIter = treestore.get_iter(rootPath)
        nChildren = treestore.iter_n_children(rootIter)
        #子を取得
        for n in range(nChildren):
            #子を保存
            pathInt = [0, n]
            pathInts.append(pathInt)
            #孫を取得
            path = Gtk.TreePath.new_from_indices(pathInt)
            iter = treestore.get_iter(path)
            nGrChildren = treestore.iter_n_children(iter)
            for nn in range(nGrChildren):
                #孫を保存
                pathInt = [0, n, nn]
                pathInts.append(pathInt)
                #ひ孫を取得
                path = Gtk.TreePath.new_from_indices(pathInt)
                iter = treestore.get_iter(path)
                nGGrChildren = treestore.iter_n_children(iter)
                for nnn in range(nGGrChildren):
                    #ひ孫を保存
                    pathInt = [0, n, nn, nnn]
                    pathInts.append(pathInt)
        return pathInts

    #
    #  getItemListFomPath
    def getItemListFromPath(self, path):
        """ treePathからitemNameのlistを返す"""
        words = []
        for i in range(len(path)):
            iter = self.treestore.get_iter(path[:i+1])
            value = self.treestore.get_value(iter, 0)
            words.append(value)
        return words

    #
    #  getPathFromItmList
    def getPathFromItemList(self, itemList):
        """ itemListからtreeのpathを取得して返す"""
        
        def getIntFromItemName(parentInt, itemName, pathInt):
            parentPath = Gtk.TreePath.new_from_indices(pathInt)
            iter = self.treestore.get_iter(parentPath)
            nChildren = self.treestore.iter_n_children(iter)
            for n in range(nChildren):
                pathInt = parentInt + [n]
                path = Gtk.TreePath.new_from_indices(pathInt)
                iter = self.treestore.get_iter(path)
                name = self.treestore.get_value(iter, 0)
                if name == itemName:
                    break
            return n
        
        pathInt = [0]
        for n in range(1, len(itemList)):
            name = itemList[n]
            parentInt = pathInt
            i = getIntFromItemName(parentInt, name, pathInt)
            pathInt.append(i)
        path = Gtk.TreePath.new_from_indices(pathInt)
        return path

    #
    #  clearSetFlagInTree
    def clearSetFlagInTree(self):
        """ 選択itemのpage設定をclear（設定済）する"""
        treeSelection = self.tree_main.get_selection()
        _treestore, pathes = treeSelection.get_selected_rows()
        path = pathes[0]
        itemList = self.getItemListFromPath(path)
        itemTuple = tuple(itemList)
        #itemを削除(addTreeItemsSetから削除)
        delTuple = itemTuple[1:]    #rootを除くitem
        if delTuple in self.addTreeItemsSet:
            self.addTreeItemsSet.remove(delTuple)
        #存在しないaddTreeItemsSet内のtreeItemを削除
        self.deleteNoneItemInAddTreeItemsSet()
        #treeのfontを設定
        self.setTreeFontColour(anaType)
        #fontを表示
        self.maskSelectItem = True
        if len(path) > 2:
            #root以外の親pathを追加
            self.tree_main.set_cursor(path[:-1], None, False)
        self.tree_main.set_cursor(path, None, False)
        self.maskSelectItem = False

    #  deleteNoneItemInAddTreeItemsSet
    def deleteNoneItemInAddTreeItemsSet(self):
        """ addTreeItemsSet内に存在しないitemがあれば削除する"""

        def isInTreeList(addItem):
            """ addItemがTreeDataにあるかどうか確認"""
            ans = True
            items = treeData[1]
            for word in addItem:
                flag = 0
                for i in range(len(items)):
                    if type(items[i]) == str:
                        if word == items[i]:
                            flag = 1
                            break
                    else:
                        if word == items[i][0]:
                            items = items[i][1]
                            flag = 1
                            break
                if flag == 0:
                    ans = False
                    break
            return ans

        addItems = list(self.addTreeItemsSet)
        remainItems = []
        for addItem in addItems:
            if isInTreeList(addItem) == True:
                remainItems.append(addItem)
        self.addTreeItemsSet = set(remainItems)

    #
    #  setSettingButtonLabel
    def setSettingButtonLabel(self):
        """ flagの状況に応じて「設定」ボタンのlabelを設定する"""
        #itemTuple(flagのkey）を取得
        treeSelection = self.tree_main.get_selection()
        _treestore, pathes = treeSelection.get_selected_rows()
        if len(pathes) == 0:
            #非選択の場合
            return
        path = pathes[0]
        itemList = self.getItemListFromPath(path)
        itemTuple = tuple(itemList[1:])
        #flagを確認
        if not itemTuple in self.addTreeItemsSet:
            #label clear
            self.clearButtonLabel()
        else:
            #label mark
            self.markButtonLabel()
            self.setAddTreeItemsSetCurrPage()

    #
    #  isMarkButton
    def isMarkButton(self):
        """ 設定ボタンが「*設定」ボタンかどうか確認する"""
        #currentPageNameを取得
        i = self.notebook_main.get_current_page()
        page = self.notebook_main.get_nth_page(i)
        pageName = self.notebook_main.get_tab_label_text(page)
        #「設定」ボタンを取得
        setButton = self.pageToSetButtonDict[pageName]
        if setButton == "":
            return False
        text = setButton.get_child().get_label()
        if text == _("設定"):
            return False
        else:
            return True

    #
    #  markButtonLabel
    def markButtonLabel(self):
        """ 設定ボタンをマークする"""
        #currentPageNameを取得
        i = self.notebook_main.get_current_page()
        page = self.notebook_main.get_nth_page(i)
        pageName = self.notebook_main.get_tab_label_text(page)
        #「設定」ボタンを取得
        setButton = self.pageToSetButtonDict[pageName]
        if setButton == "":
            return
        text = "<b>*" + _("設定") + "</b>"
        label = setButton.get_child()
        label.set_markup(text)

    #
    #  setAddTreeItemsSetCurrPage
    def setAddTreeItemsSetCurrPage(self):
        """ currPageのsetTreeItemsSetを追加する
        treeItemのfontをnormal or boldに設定する。"""
        #itemTuple(flagのkey）を取得
        treeSelection = self.tree_main.get_selection()
        _treestore, pathes = treeSelection.get_selected_rows()
        if len(pathes) == 0:
            #非選択の場合
            return
        path = pathes[0]
        itemList = self.getItemListFromPath(path)
        itemTuple = tuple(itemList[1:])
        if len(itemTuple) == 0:
            #itemTupleが空の場合、直ぐに戻る
            return
        #setするしないを確認
        unsetTreeItems = [_("FistrModel.msh")]
        if itemTuple[0] in unsetTreeItems:
            #セットせず戻る
            return
        #セットする。
        self.addTreeItemsSet.add(itemTuple)
        self.setTreeFontColour(anaType)

    #
    #  clearButtonLabel
    def clearButtonLabel(self):
        """ 設定ボタンをデフォルトに戻す"""
        #currentPageNameを取得
        i = self.notebook_main.get_current_page()
        page = self.notebook_main.get_nth_page(i)
        pageName = self.notebook_main.get_tab_label_text(page)
        #「設定」ボタンを取得
        setButton = self.pageToSetButtonDict[pageName]
        if setButton == "":
            return
        text = _("設定")
        setButton.set_label(text)

    #
    #  changeContentsSetFlag
    #------------------------
    def changeContentsSetFlag(self):
        """ データを修正時、「設定」ボタンのlabelをセットする"""
        if self.maskChangeCont == True:
            return
        self.markButtonLabel()
        self.setAddTreeItemsSetCurrPage()


    #
    #  handler（eventの処理）
    #  ----------------------
    #
    #------ VTK画面関連 --------------------------
    def onHideVtk(self, event):                     #vtk非表示
        if self.maskEvent == False:
            self.hideVtk()
    def onFitToWindow(self, event):                 #fitWindow
        if self.showModel == True:
            self.fitToWindow()
    def onViewFromXP(self, event):                  #X軸視
        if self.showModel == True:
            self.viewFromXP()
    def onViewFromXM(self, event):                  #-X軸視
        if self.showModel == True:
            self.viewFromXM()
    def onViewFromYP(self, event):                  #Y軸視
        if self.showModel == True:
            self.viewFromYP()
    def onViewFromYM(self, event):                  #-Y軸視
        if self.showModel == True:
            self.viewFromYM()
    def onViewFromZP(self, event):                  #Z軸視
        if self.showModel == True:
            self.viewFromZP()
    def onViewFromZM(self, event):                  #-Z軸視
        if self.showModel == True:
            self.viewFromZM()
    # def onSetReverseCamera(self, event):            #左右反転
    #     if self.showModel == True:
    #         self.setReverseCamera()
    # def onRolling90(self, event):                   #回転
    #     if self.showModel == True:
    #         self.rolling90()
    def onShowAllElms(self, event):                 #全表示
        if self.showModel == True:
            self.showAllElms()
    def onHideElms(self, event):                    #要素を隠す
        if self.showModel == True:
            self.setHideElms()
    def onNewReloadVtkMesh(self, event):            #新reload
        #if self.showModel == True:
        self.newReloadVtkMesh()
    def onReloadVtkMesh(self, event):               #meshをreload
        #if self.showModel == True:
        self.reloadVtkMesh()
    def onCheckShowEdge(self, event):               #checkShowEdge
        if self.showModel == True:
            self.checkShowEdge(event)
    def onCheckOpacity(self, event):                #checkOpacity
        if self.showModel == True:
            self.checkOpacity(event)
    def onShowOriginAxes(self, event):               #原点表示
        if self.showModel == True:
            self.showOriginAxes()
    def onResizeVtkBox(self, box, rect):            #vtkBoxのサイズ変更時
        pass
    def onGetPickedCellId(self, event):             #vtkのcellをpickした時
        if self.showMeshMode == "createGroup":
            self.getPickedCellId(event)
    def onGetDoublePickedActor(self, event):        #vtkのcellをdoublrClickした時
        if self.showMeshMode != "createGroup":
            self.getDoublePickedActor(event)            
    #------ TreeDir関連(directory) --------------------------
    def onReloadDir(self, event):                   #dirのreload
        self.reloadDir(event)
    def onChangeCurrDir(self, event):               #currDir移動
        self.changeCurrDir(event)
    def onExpandTreeDir(self, treeview, treeiter, path): #tree展開
        if self.maskEvent == False:
            self.expandTreeDir(path)
    def onPressMouseButton(self, widget, event):    #mouseClick
        self.pressMouseButton(widget, event)
    def onMoveToolTip(self, treeView, event):       #tooltipの設定
        if self.maskEvent == False:
            pos = (event.x, event.y)
            self.setShowToolTip(pos)
    def onChangeMainWindowSize(self, widget, event):    #vtk再描画
        #self.vtkRender()
        pass
    def onKeyPress(self, treeview, event):
        self.keyPress(event)
    def onKeyRelease(self, treeview, event):
        self.keyRelease(event)
    #------ TreeItem選択(設定項目) -------------------
    def onSelectItem(self, event):                  #TreeView選択
        if self.maskSelectItem == False:
            self.selectItem(event)
    def onPressMouseButtonInTreeItem(self, widget, event): #TreeViewをclick
        pass
        # if widget == self.tree_main:
        #     self.pressMouseButtonInTreeItem()
    #-------------menu, tool, 欄外button -------------------------
    def onEditUsingApp(self, event):                #設定内容変更
        self.editUsingApp()
    def onClose(self, event):                       #閉じる btn
        self.closeApp()
    def onClearFolder(self, event):                 #folder内クリア btn
        self.clearFolder(event)
    def onSaveTempData(self, event):                #設定保存 btn (temp->dir)
        self.saveTempData(event)
    def onImport(self, event):                      #import
        self.importItem()
    def onExport(self, event):                      #export
        self.exportItem()
    def onOpenWorkFolder(self, event):              #folder開く btn
        self.openWorkFolder(event)
    def onOpenTempFolder(self, event):              #tempFolder開く btn
        self.openTempFolder(event)
    def onEditCntMshFile(self, event):              #cnt,mshFile編集 btn
        self.editCntMeshFile(event)
    def onRunTerminal(self, event):                 #端末起動 btn
        self.runTerminal(event)
    def onClearCntFile(self, event):                #cntファイル初期化
        self.clearCntFile(event)
    def onLoadToTemp(self, event):                  #tempCase作成 (dir->temp)
        self.loadDataToTemp()
    def onRunCad(self, event):                      #CAD起動
        self.runCad()
    def onRunMesher(self, event):                   #mesher起動
        self.runMesher()
    def onShowVersion(self, event):                 #version表示
        self.showVersion()
    def onRunOnlyParaView(self, event):             #paraView起動
        self.runOnlyParaView()
    #------ import menu ------------------------------
    def onCadCreateMesh(self, event):               #Cad
        self.importItem_run("cad")
    def onUnv2fistr(self, event):                   #unv2fistr
        self.importItem_run("unv2fistr")
    def onAbaqus2fistr(self, event):                #abaqus2frir
        self.importItem_run("abaqus2fistr")
    def onResFrd2vtk(self, event):                  #frd2vtk
        self.importItem_run("resFrd2vtk")
    def onReadAbaqus(self, event):                  #readAbaqus
        self.importItem_run("readAbaqus")
    def onReadAnsys(self, event):                   #readAnsys
        self.importItem_run("readAnsys")
    def onReadAvsucd(self, event):                  #readAvsucd
        self.importItem_run("readAvsucd")
    def onReadExodus(self, event):                  #readExodus
        self.importItem_run("readExodus")
    def onReadGmsh(self, event):
        self.importItem_run("readGmsh")             #readGmsh
    def onReadMdpa(self, event):
        self.importItem_run("readMdpa")             #readMdpa
    def onReadMed(self, event):
        self.importItem_run("readMed")              #readMed
    def onReadMedit(self, event):
        self.importItem_run("readMedit")            #readMedit
    def onReadNastran(self, event):
        self.importItem_run("readNastran")          #readNastran
    def onReadNetgen(self, event):
        self.importItem_run("readNetgen")           #readNetgen
    def onReadPermas(self, event):
        self.importItem_run("readPermas")           #readPermas
    def onReadVtk(self, event):
        self.importItem_run("readVtk")              #readVtk
    def onReadVtu(self, event):
        self.importItem_run("readVtu")              #readVtu
    def onReadXdmf(self, event):
        self.importItem_run("readXdmf")             #readXdmf
    #------ export menu ------------------------------
    def onFistr2abaqus(self, event):                #fistr2Abaqus
        self.exportItem_run("fistr2abaqus")
    def onFistr2rad(self, event):                   #fistr2rad
        self.exportItem_run("fistr2rad")
    def onWriteAbaqus(self, event):                 #writeAbaqus
        self.exportItem_run("writeAbaqus")
    def onWriteAnsys(self, event):                  #writeAnsys
        self.exportItem_run("writeAnsys")
    def onWriteAvsucd(self, event):                 #writeAvsucd
        self.exportItem_run("writeAvsucd")
    def onWriteExodus(self, event):                 #writeExodus
        self.exportItem_run("writeExodus")
    def onWriteGmsh(self, event):                   #writeGmsh
        self.exportItem_run("writeGmsh")
    def onWriteGmsh22(self, event):                 #writeGmsh22
        self.exportItem_run("writeGmsh22")
    def onWriteMdpa(self, event):                   #writeMdpa
        self.exportItem_run("writeMdpa")
    def onWriteMed(self, event):                    #writeMed
        self.exportItem_run("writeMed")
    def onWriteMedit(self, event):                  #writeMedit
        self.exportItem_run("writeMedit")
    def onWriteNastran(self, event):                #writeNastran
        self.exportItem_run("writeNastran")
    def onWriteNetgen(self, event):                 #writeNetgen
        self.exportItem_run("writeNetgen")
    def onWritePermas(self, event):                 #writePermas
        self.exportItem_run("writePermas")
    def onWriteVtk(self, event):                    #writeVtk
        self.exportItem_run("writeVtk")
    def onWriteVtu(self, event):                    #writeVtu
        self.exportItem_run("writeVtu")
    def onWriteXdmf(self, event):                   #writeXdmf
        self.exportItem_run("writeXdmf")
    #------ FrontISTR page ---------------------------
    def onSetDefaultCntMshName(self, event):        #defaultに戻す
        self.setDefaultCntMshName()
    def onSetUseCntFile(self, event):               #選択>> btn
        self.setUseCntFile(event)
    def onCopyUseCntFile(self, event):              #cntファイル置き換え btn
        self.copyUseCntFile(event)
    #----- FistrModel.msh page ---------------------------
    def onCreateMeshFromCad(self, event):           #mesh作成
        self.createMeshFromCad()
    def onConvertMeshFromOther(self, event):        #mesh変換
        self.convertMeshFromOther()
    #def onSetMeshFile(self, event):                 #参照... btn
    #    self.setMeshFile(event)
    #def onMeshConvert(self, event):                 #mesh変換 btn
    #    self.meshConvert(event)
    #def onSetBackupMesh(self, event):               #変換前に戻す
    #    self.setBuckupMesh()
    def onChangeUnit(self, event):                  #単位変更
        self.changeUnit()
    def onChangeMeshScale(self, event):             #倍率変更 btn
        self.changeMeshScale(event)
    def onSet341elm_selective(self, event):         #341要素の設定
        self.set341elm_selective()
    #def onReadMeshData(self, event):                #mesh読込 btn
    #    self.readMeshData(event)
    def onReformNgrp(self, event):                  #NGRPの修正 btn
        self.reformNgrp(event)
    def onNodesBond(self, event):                   #節点結合
        self.nodesBond()
    def onEditBeamElements(self, event):            #beam要素編集
        self.editBeamElements()
    def onConfirmModelAtParaview(self, event):      #形状確認 btn
        self.confirmModelAtParaview(event)
    #---- GROUP作成 --------------------------------
    def onSetPickMode(self, event):
        self.setPickMode()                          #pickMode選択
    def onClearGrpView(self, event):
        self.clearGrpView()                         #表示クリア
    def onClearChangeFlag(self, event):
        self.clearChangeFlag()
    def onShowCreatedNgrp(self, event):
        self.showCreateNgrp()                       #NGRP取得
    def onShowCreatedAllNgrp(self, event):
        self.showCreateAllNgrp()                    #全NGRP取得
    def onShowCreatedSgrp(self, event):
        self.showCreatedSgrp()                      #SGRP取得
    def onShowCreatedEgrp(self, event):
        self.showCreatedEgrp()                      #EGRP取得
    def onSetNgrpSgrp(self, event):
        self.setCreateGrp()                         #設定
    def onChangeCreateGrpMethod(self, event):
        self.changeCreateGrpMethod()                #grp作成方法（新規or修正）
    #---- GROUP編集 --------------------------------
    def onENgrpSelect(self, event):                 
        if self.maskEvent == False:
            self.editNgrpSelect()                   #NGRP選択時
    def onESgrpSelect(self, event):
        if self.maskEvent == False:
            self.editSgrpSelect()                   #SGRP選択時
    def onEEgrpSelect(self, event):
        if self.maskEvent == False:
            self.editEgrpSelect()                   #EGRP選択時
    def onEditGroupRename(self, event):
        self.editGroupRename()                      #名前変更
    def onEditGroupDelete(self, event):
        self.editGroupDelete()                      #grp名削除
    def onEditGroupDelMesh(self, event):
        self.editGroupDelMesh()                     #mesh削除
    #---- solutionType page button -----------------
    def onSetSolutionCont(self, event):             #解析選択combo
        self.setSolutionCont(self)
    def onApplySolutionType(self, event):           #設定btn
        self.applySolutionType(event)
    #----- solutionType Eigen page -----------------
    def onApplyEigenSolution(self, event):          #設定btn
        self.applyEigenSolution(event)
    #----- solutionType Dynamic page -----------------
    def onSetGroupName(self, event):                #group名 comboBox
        self.setGroupName(event)
    def onApplyDynamicSolution(self, event):        #設定btn
        self.applyDynamicSolution(event)
    #----- solutionType HeatDynamic page -----------------
    def onApplyHeatDynamicSolution(self, event):    #設定btn
        self.applyHeatDynamicSolution(event)
    def onCheckDtConstant(self, event):             #時間増分固定checkBox
        self.checkDtConstant(event)
    #----- 材料物性値 page -----------------
    def onSetMaterialDB(self, event):               #参照...
        self.setMaterialDB(event)
    def onOpenDB(self, event):                      #DBを開く
        self.openMaterialDB(event)
    def onSetMaterialGroup(self, event):            #選択>>btn
        self.setMaterialGroup(event)
    def onSelectUnsetEgrp(self, event):             #非選択側のEGRPを選択
        self.selectUnsetEgrp()
    def onSelectSetEgrp(self, event):               #選択側のEGRPを選択
        self.selectSetEgrp()
    def onReturnMaterialGroup(self, event):         #<<戻すbtn
        self.returnMaterialGroup(event)
    def onApplyMaterial(self, event):               #設定btn
        self.applyMaterial(event)
    #----- 材料物性値_sub page -----------------
    def onSetEachMaterialModel(self, event):        #材料モデルcomboBox
        self.setEachMaterialTypeHard()
    def onSetMatYieldType(self, event):             #降伏条件ComboBox
        if self.maskEvent == False:
            self.setMatYieldType()
    def onSetMatHarden(self, event):                #硬化則comboBox
        if self.maskEvent == False:
            self.setMatHarden()
    def onEditSsData(self, event):                  #SS_data作成btn
        self.editPlasticSsData(event)
    def onShowMaterialData(self, event):            #物性値確認btn
        self.showMaterialData(event)
    def onOpenMaterialDB(self, event):              #材料DB開くbtn
        self.openMaterialDB(event)
    def onReloadDB(self, event):                    #材料DB再読込
        self.reloadMaterialDB()
    def onGetBeamZaxis(self, event):                #z軸取得
        self.getBeamZaxis()
    def onCalcSectionCoeff(self, event):            #断面の定数取得
        self.calcSectionCoeff()
    def onApplyEachMaterial(self, event):           #設定btn
        self.applyEachMaterial()
    #----- 境界条件設定 ------------------
    def onClearAllBoundary(self, event):            #全境界条件クリア
        self.clearAllBoundary()
    #----- setGroup page -----------------
    def onSetBCGroup(self, event):                  #選択>>btn
        self.setBCGroup(event)
    def onReturnBCGroup(self, event):               #<<戻すbtn
        self.returnBCGroup(event)
    def onApplyBCGroup(self, event):                #設定btn
        self.applyBCGroup(event)
    def onSelectUnsetEachGrp(self, event):          #非選択側のitemを選択
        self.selectUnsetEachGrp()
    def onSelectSetEachGrp(self, event):            #選択側のitemを選択
        self.selectSetEachGrp()
    #----- BOUNDARY_sub page -----------------
    def onApplyBoundaryCont(self, event):           #設定btn
        self.applyBoundaryCont(event)
    #----- CLOAD_sub page -----------------
    def onApplyCloadCont(self, event):              #設定btn
        self.applyCloadCont(event)
    #----- DLOAD_sub page -----------------
    def onSelectPressType(self, event):             #pressTypeの選択
        self.selectPressureType()
    def onSetPtcFile(self, event):                  #参照...
        self.setPtcFile()
    def onPtcOpenFoam(self, event):                 #OpenFOAM
        self.createPtcOpenFoam()
    def onShowPtcPress(self, event):                #圧力分布確認
        self.showPtcPressure()
    def onApplyDloadCont(self, event):              #設定btn
        self.applyDloadCont(event)
    #----- VLOAD_sub page -----------------
    def onApplyVloadCont(self, event):              #設定btn
        self.applyVloadCont(event)
    #----- GRAV_sub page -----------------
    def onApplyGravCont(self, event):               #設定btn
        self.applyGravCont(event)
    #----- CENT_sub page -----------------
    def onApplyCentCont(self, event):               #設定btn
        self.applyCentCont(event)
    #----- TEMPERATURE_sub page -----------------
    def onSwitchUseResult(self, event):             #熱伝導解析結果を使用checkBox
        self.switchUseResult(event)
    def onApplyTemperatureCont(self, event):        #設定btn
        self.applyTemperatureCont(event)
    #----- SPRING_sub page -----------------
    def onApplySpringCont(self, event):             #設定btn
        self.applySpringCont(event)
    #----- contact page -----------------
    def onAddContactCondition(self, event):         #追加>>btn
        self.addContactCondition(event)
    def onDeleteContactCondition(self, event):      #<<削除btn
        self.deleteContactConditions(event)
    def onApplyContact(self, event):                #設定btn
        self.applyContact(event)
    #----- contact_sub page -----------------
    def onChangeContactType(self, event):           #contactType
        self.changeContactType(event)
    def onApplyContactCont(self, event):            #設定btn
        self.applyContactCont(event)
    def onSelectSlaveGrp(self, event):              #slaveのcomboを選択
        self.selectSlaveGrp()
    def onSelectMasterGrp(self, event):             #masterのcomboを選択
        self.selectMasterGrp()
    def onRenameContactPair(self, event):           #接触ペア名変更
        self.renameContactPair()
    #----- FLOAD_sub page -----------------
    def onApplyFloadCont(self, event):              #設定btn
        self.applyFloadCont(event)
    #----- VELOCITY_sub page -----------------
    def onApplyVeloCont(self, event):               #設定btn
        self.applyVeloCont(event)
    #----- ACCELERATION_sub page -----------------
    def onApplyAccelCont(self, event):              #設定btn
        self.applyAccelCont(event)
    #----- INITIAL_sub page -----------------
    def onApplyInitialCont(self, event):            #設定btn
        self.applyInitempCont(event)
    #----- REFTEMP page -----------------
    def onApplyReftempValue(self, event):           #設定btn
        self.applyReftempValue(event)
    #----- FIXTEMP_sub page ---------------
    def onApplyFixtempCont(self, event):            #設定btn
        self.applyFixtempCont(event)
    #----- CFLUX_sub page -----------------
    def onApplyCfluxCont(self, event):              #設定btn
        self.applyCfluxCont(event)
    #----- SFLUX_sub page -----------------
    def onApplySfluxCont(self, event):              #設定btn
        self.applySfluxCont(event)
    #----- DFLUX_sub page -----------------
    def onApplyDfluxCont(self, event):              #設定btn
        self.applyDfluxCont(event)
    #----- BF_sub page -----------------
    def onApplyBfCont(self, event):              #設定btn
        self.applyBfCont(event)
    #----- SFILM_sub page -----------------
    def onApplySfilmCont(self, event):              #設定btn
        self.applySfilmCont(event)
    #----- SRADIATE_sub page -----------------
    def onApplySradiateCont(self, event):           #設定btn
        self.applySradiateCont(event)
    #----- step_sub page -----------------
    def onSwitchAutoinc(self, event):               #自動増分
        self.switchAutoinc(event)
    def onEditAutoincParam(self, event):            #編集...
        self.editAutoincParam(event)
    def onSetBCGroupForStep(self, event):           #選択>>btn
        self.setBCGroupForStep(event)
    def onReturnBCGroupForStep(self, event):        #<<戻すbtn
        self.returnBCGroupForStep(event)
    def onApplyStepCont(self, event):               #設定btn
        self.applyStepCont(event)
    #----- AMPLITUDE or step page -----------------
    def onAddAmplitudeCont(self, event):            #追加>>btn
        self.addAmplitudeCont(event)
    def onDeleteAmplitudeCont(self, event):         #<<削除btn
        self.deleteAmplitudeCont(event)
    def onApplyAmplitude(self, event):              #設定btn
        self.applyAmplitude(event)
    #----- AMPLITUDE_sub page -----------------
    def onEditAmpData(self, event):                 #data作成btn
        self.editAmpData(event)
    def onSetAmpBndGrp(self, event):                #選択>>btn
        self.setAmpBndGrp(event)
    def onReturnAmpBndGrp(self, event):             #<<戻すbtn
        self.returnAmpBndGrp(event)
    def onRenameAmplitude(self, event):             #amp名変更
        self.renameAmplitude()
    def onApplyAmplitudeCont(self, event):          #設定btn
        self.applyAmplitudeCont(event)
    #----- solver page -----------------
    def onSwitchParallel(self, event):              #並列計算checkBox
        self.switchParallel(event)
    def onCreateMultiJob(self, event):              #メッシュ分割btn
        self.createMultiJob(event)
    def onSwitchRestart(self, event):               #途中stepから開始checkBox
        self.switchRestart(event)
    def onSolveSet(self, event):                    #設定btn
        self.solveSet(event)
    def onRunFrontIstr(self, event):                #FrontISTR実行btn
        self.runFrontIstr(event)
    def onPlotStepMonitor(self, event):             #step状況表示btn
        self.plotStepMonitor(event)
    def onShowHideInpRadButton(self, event):        #他アプリ変換button表示
        self.showHideInpRadButton()
    def onConvertToInp(self, event):                #inpに変換
        self.convertToInp()
    def onConvertToRad(self, event):                #rad変換
        self.convertToRad()
    #------線形solver-----------------
    def onApplySolverCont(self, event):             #設定btn
        self.applySolverCont(event)
    #----- post page -----------------
    def onResultMerge(self, event):                 #merge btn
        self.resultMerge(event)
    #def onRunRevocap(self, event):                 #REVOCAP起動 btn
    #    self.runRevocap(event)
    def onSelectUseVtk(self, event):                #vtk変換を選択
        self.selectUseVtk()
    def onSelectUseVtu(self, event):                #vtu変換を選択
        self.selectUseVtu()
    def onConvertResult46(self, event):             #4.6用vtk変換 btn
        self.convertResult46(event)
    def onRunParaView46(self, event):               #4.6用paraView起動 btn
        self.runParaView46(event)
    def onConvertResultData(self, event):           #egrp追加（vtk変換 btn）
        self.convertResultData(event)
    def onRunParaView(self, event):                 #ParaView起動 btn
        self.runParaView(event)
    def onShowHideInpVtuButton(self, event):        #vtu変換
        self.showHideInpVtuButton()
    def onConvertInpResToVtu(self, event):          #frd2vtu
        self.convertInpResToVtu()
    #------ 内容変更時 -----------------
    def onChangeContents(self, event):
        self.changeContentsSetFlag()                #内容変更時
    #------ mouseEvent -----------------
    # def onPressMouseButtonInBox(self, widget, event):
    #     self.pressMouseButtonInBox(widget, event)
    #------ popupMenu ------------------
    def popOpenFolder(self, event):                 #folder開く
        self.openFolder()
    def popRunTerm(self, event):                    #端末起動
        self.runTermFromPopup()
    def popRenameFolder(self, event):               #folder名変更
        self.renameFolder()
    def popAddNewFolder(self, event):               #folder作成
        self.addNewFolder()
    def popDeleteFolder(self, event):               #folder削除
        self.deleteFolder()
    def popDeleteResults(self, event):              #folder内の計算結果data削除
        self.deleteResults()
    def popDeleteAllDataFiles(self, event):         #folder内のmesh等全data削除
        self.deleteAllDataFiles()
    def popCopyFolder(self, event):                 #folderコピー
        self.copyFolder()
    def popPasteFolder(self, event):                #folder貼り付け
        self.pasteFolder()
    def popCasePasteFolder(self, event):            #case貼り付け
        self.casePasteFolder()
    # def popRenameGrpInBox(self, event):             #grp名変更
    #     self.renameGrpInBox()
    # def popDeleteGrpInBox(self, event):             #grp名削除
    #     self.deleteGrpInBox()
    def popRunLoginShell(self, event):              #loginシェル起動
        self.runLoginShell()
    def popServerJob(self, event):                  #server jon管理
        self.serverJobControl()
    def popServerMount(self, event):                #sshfsサーバマウント
        self.serverMount()
    def popServerUnmount(self, event):              #sshfsサーバアンマウント
        self.serverUnmount()
    def popScpPasteFolder(self, event):             #貼り付け(scp圧縮転送,cp)
        self.pasteScpCompTransfer()
    def popScpCasePasteFolder(self, event):         #case貼り付け(scp圧縮転送,cp)
        self.casePasteScpCompTransfer()
    def popDeleteServer(self, event):               #server内folder削除(rm)
        self.deleteServerFoldersRm()

    #------------------------- handler の内容 --------------------
    #
    #  runTermFromPopup
    #-------------------
    def runTermFromPopup(self):
        """ popupMenuからの端末起動"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        currDir = selDirs[0]
        saveDir = os.getcwd()
        #os.chdir(currDir)
        comm = runTerminalComm
        #os.system(comm)
        pyFistr.run(currDir).command(comm)
        os.chdir(saveDir)

    #
    #  renameFolder
    #---------------
    def renameFolder(self):
        """ folder名変更"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        selDir = selDirs[0]
        currDir = getCurrDirFromTempFolder()
        #currDirのflagを設定
        currDirFlag = 0
        if currDir == selDir:
            #currDirのfolder名変更の場合、flagを設定
            currDirFlag = 1
        title = _("folder名変更")
        mess = _("新しいfolder名を入力してください")
        folderName = os.path.basename(selDir)
        iniText = folderName
        args = [selDir, currDirFlag]
        funcOk = [self.renameFolder_onDlg, args]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()
        return
        
    #
    #  renameFolder_onDlg
    def renameFolder_onDlg(self, newName, args):
        """ 取得したnewNameを処理する。
        path, itemは、使用しない。"""
        [selDir, currDirFlag] = args
        if newName == "":
            return
        newDir = os.path.dirname(selDir) + os.sep + newName
        if os.path.exists(newDir) == True:
            title = _("エラー")
            mess = _("同じfolder名が存在します。") + ls
            mess += _("別のfolder名を再入力してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        os.rename(selDir, newDir)
        #dirTreeを整形する
        parentDir = os.path.dirname(selDir)
        #  parentDirを閉じる
        path = self.treeWidget.getPathInTreeView(parentDir)
        self.treeWidget.treeView.collapse_row(path)
        #  parentDirを開く
        self.treeWidget.treeView.expand_row(path, False)
        #  newDirのみを選択
        self.treeWidget.unselectAllDir()
        self.treeWidget.selectDir(newDir)
        #currDirの名称変更？
        if currDirFlag == 1:
            #条件Tree内の展開しているnodeと選択しているnodeを取得
            (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
            #workDirをnewDirに変更
            self.changeWorkFolder(newDir)
            #nodeを展開する
            self.setTreeSetPage(expPathes, selPath)
            #newDirの内容を取得し、dataDictに書き込み
            folderCont = self.getFolderCont(newDir)
            self.treeWidget.dataDict[newDir] = folderCont
            #itemDictのiconをcaseに設定
            self.treeWidget.itemDict[newDir][self.COL_ICON] = self.iconCase
            #titleをセット
            self.setTitle()
            #dirTreeを整形する
            parentDir = os.path.dirname(selDir)
            #  parentDirを閉じる
            path = self.treeWidget.getPathInTreeView(parentDir)
            self.treeWidget.treeView.collapse_row(path)
            #  parentDirを開く
            self.treeWidget.treeView.expand_row(path, False)
            #  newDirのみを選択
            self.treeWidget.unselectAllDir()
            self.treeWidget.selectDir(newDir)

    #
    #  addNewFolder
    #----------------
    def addNewFolder(self):
        """ 新しいfolderを追加"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        selDir = selDirs[0]
        n = 0
        loop = True
        while loop:
            newName = "newFolder_" + str(n)
            newDir = selDir + os.sep + newName
            if os.path.exists(newDir) == False:
                break
            n += 1
        title = _("新しいfolder追加")
        mess = _("新しく追加するfolder名を入力してください。")
        iniText = newName
        args = [selDir, newDir]
        funcOk = [self.addNewFolder_onDlg, args]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()

    #
    #  addNewFolder_onDlg
    def addNewFolder_onDlg(self, newName, args):
        """ 取得したnewNameを処理する。
        path、itemは、使用しない。"""
        selDir, newDir = args
        if newName == "":
            return
        newDir = os.sep.join(newDir.split(os.sep)[:-1]) + os.sep + newName
        if os.path.exists(newDir) == True:
            title = _("エラー")
            mess = _("同じ名前のfolderが存在します。") + ls
            mess += _("  folderが追加できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        os.mkdir(newDir)
        #selDirを閉じる
        parentDir = os.sep.join(selDir.split(os.sep)[:-1])
        self.treeWidget.collapseChildDir(parentDir)
        self.treeWidget.expandChildDir(selDir)
        #path = self.treeWidget.getPathInTreeView(selDir)
        #self.treeWidget.treeView.collapse_row(path)
        #selDirを開く
        #self.treeWidget.treeView.expand_row(path, False)
        #newDirを選択
        self.treeWidget.unselectAllDir()
        self.treeWidget.selectDir(newDir)

    #
    #  deleteFolder
    #---------------
    def deleteFolder(self):
        """ folder削除"""
        selDirs = self.treeWidget.getSelectedDirs()
        currDir = getCurrDirFromTempFolder()
        errFlag = 0
        if currDir in selDirs:
            errFlag = 1
        else:
            for selDir in selDirs:
                checkDir = selDir + os.sep
                if currDir[:len(checkDir)] == checkDir:
                    errFlag = 1
                    break
        if errFlag == 1:
            title = _("エラー")
            mess = _("workFolderが含まれている為、folderが削除できません。") + ls
            mess += _("workFolderを外して選択してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return

        title = _("folder削除")
        mess = _("folderを削除します。") + ls
        mess += _("  よろしいですか？")
        funcOk = [self.reconfirmDeleteFolder, selDirs]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # self.reconfirmDeleteFolder(selDirs)

    #
    # reconfirmDeleteFolder
    def reconfirmDeleteFolder(self, selDirs):
        title = _("folder削除")
        mess = _("削除後は元に戻りません。") + ls
        mess += _("  本当に削除しますか？")
        funcOk = [self.deleteFolderShowTreeItemProcess, selDirs]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # self.deleteFolderShowTreeItemProcess(selDirs)

    #
    #  deleteFolderShowTreeItemProcess
    def deleteFolderShowTreeItemProcess(self, selDirs):
        parentDir = os.path.dirname(selDirs[0])
        for selDir in selDirs:
            shutil.rmtree(selDir)
        #treeViewを再表示する
        self.showTreeViewAfterDelete(selDirs)

    #
    #  showTreeViewAfterDelete
    def showTreeViewAfterDelete(self, delDirs):
        """ deleteFolder実行後のTreeViewの表示"""
        #parentDirsとdelDirのpathを取得
        parDirDict = {}
        delDirPathDict = {}
        for delDir in delDirs:
            #parentDirを取得
            parDir = os.path.dirname(delDir)
            name = os .path.basename(delDir)
            if parDir in parDirDict.keys():
                parDirDict[parDir].append(name)
            else:
                parDirDict[parDir] = [name]
            #pathを取得
            path = self.treeWidget.getPathInTreeView(delDir)
            delDirPathDict[delDir] = path
        #parentDirをcloseして開く（dirを再読込）
        parDirs = list(parDirDict.keys())
        parDirs.sort()
        for parDir in parDirs:
            path = self.treeWidget.getPathInTreeView(parDir)
            #parentDirを閉じる
            self.treeWidget.treeView.collapse_row(path)
            #parentDirを開く
            self.treeWidget.treeView.expand_row(path, False)
        #parentDir毎に処理
        selDirs = []
        for parDir in parDirs:
            parIter = self.treeWidget.getIterInTreeView(parDir)
            nChildren = self.treeWidget.treeStore.iter_n_children(parIter)
            names = parDirDict[parDir]
            for name in names:
                delDir = parDir + os.sep + name
                path = delDirPathDict[delDir]
                #pathを数値に変換
                pathInt = []
                for i in range(len(path)):
                    pathInt.append(path[i])
                #childが存在するか
                if nChildren > 0:
                    #path[-1]をnChildrenと比較
                    if pathInt[-1] >= nChildren:
                        pathInt[-1] = nChildren - 1
                else:
                    #chilrenが無い場合
                    pathInt = pathInt[:-1]
                path = Gtk.TreePath.new_from_indices(pathInt)
                selDirList = self.treeWidget.getDirFromTreePath(path)
                selDir = os.sep.join(selDirList)
                selDirs.append(selDir)
        #選択表示させる
        selDirs = list(set(selDirs))
        selDirs.sort()
        self.treeWidget.selectDirs(selDirs)
        #最後のdirをcursorに設定（選択部を表示させるため）
        path = self.treeWidget.getPathInTreeView(selDirs[-1])
        self.treeWidget.treeView.set_cursor(path)

    #
    #  deleteResults
    #----------------
    def deleteResults(self):
        """ 選択folder内の計算結果を削除する。
        削除する内容は、「deleteFilesDialog2.py」と同じ内容"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        caseDir = selDirs[0]
        title = _("計算結果の削除")
        mess = _("計算結果の削除") + ls
        mess += _("計算結果を削除します。") + ls
        mess += _("  よろしいですか？")
        funcOk = [self.deleteResultFoldersFiles, caseDir]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # #結果fileを削除
        # self.deleteResultFoldersFiles(caseDir)

    #
    #  deleteResultFoldersFiles
    def deleteResultFoldersFiles(self, folderDir):
        """ 結果folder、filesを削除する"""
        #folderDirを取得
        #folderDir = selDirs[0]
        #削除するfolderとfileのパターンを定義
        deleteFilesDialog.FistrModel_msh = FistrModel_msh
        deleteFilesDialog.FistrModelDict = FistrModelDict
        #    削除するfolder
        folderPatterns = deleteFilesDialog.currResultFolders()
        #    削除するfile
        filePatterns  = ["*.res.*", "*_res.*"]
        filePatterns += deleteFilesDialog.currResultFiles()
        filePatterns += deleteFilesDialog.eigenResultFiles()
        filePatterns += deleteFilesDialog.responseResultFiles()
        filePatterns += deleteFilesDialog.heatResultFiles()
        #    残すfile名
        remainFiles = deleteFilesDialog.remainFiles()
        #削除するfolder名を取得
        delFolders = []
        for pattern in folderPatterns:
            folders = glob.glob(folderDir + os.sep + pattern)
            for folder in folders:
                if os.path.isdir(folder) == True:
                    delFolders += [folder]
        #削除するfile名を取得
        delFiles = []
        for pattern in filePatterns:
            files = glob.glob(folderDir + os.sep + pattern)
            for file in files:
                if os.path.isfile(file) == True:
                    if not os.path.basename(file) in remainFiles:
                        delFiles += [file]
        if len(delFolders) > 0 or len(delFiles) > 0:
            #folderを削除
            for folder in delFolders:
                if os.path.exists(folder) == True:
                    shutil.rmtree(folder)
            #fileを削除
            for file in delFiles:
                if os.path.exists(file) == True:
                    os.remove(file)
            #treeの内容を修正
            self.threadFlag = "run"
            res = procGetHddNumResults(folderDir)
            total, free, nRes = res
            #total, free = res
            self.writeHddUsageToStatusBar(total, free)
            self.writeNumResultsToTreeItem(folderDir, nRes)
            self.threadFlag = "stop"

    #
    #  deleteAllDataFiles
    #---------------------
    def deleteAllDataFiles(self):
        """ folder内のFrontISTR関連ファイルを全て削除する。"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        selDir = selDirs[0]
        currDir = getCurrDirFromTempFolder()
        if currDir == selDir:
            title = _("エラー")
            mess = _("workFolderに設定されている為、FrontISTR関連ファイルが削除できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        title = _("FrontISTR関連ファイルの削除")
        mess = _("FrontISTR関連ファイルの削除") + ls
        mess += _("フォルダ内からFrontISTR関連の全ファイルを削除します。") + ls
        mess += _("  よろしいですか？")
        funcOk = [self.reconfirmDelateAllDataFiles, selDirs]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # self.reconfirmDelateAllDataFiles(selDirs)

    #
    #  reconfirmDelateAllDataFiles
    def reconfirmDelateAllDataFiles(self, selDirs):
        title = _("FrontISTR関連ファイルの削除")
        mess = _("本当に削除しますか？") + ls
        mess += _("削除後は、元に戻りません。")
        funcOk = [self.deleteAllDataFilesProcess, selDirs]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # #data削除
        # self.deleteAllDataFilesProcess(selDirs)

    #
    #  deleteAllDataFilesProcess
    def deleteAllDataFilesProcess(self, selDirs):
        #folderDirを取得
        folderDir = selDirs[0]
        deleteFilesDialog.FistrModel_msh = FistrModel_msh
        deleteFilesDialog.FistrModelDict = FistrModelDict
        #削除するfolderPattern
        folderPatterns = deleteFilesDialog.currResultFolders()
        folderPatterns += ["vtkMeshData"]
        #削除するfile
        filePatterns  = ["*.res.*", "*_res.*"]
        filePatterns += deleteFilesDialog.currResultFiles()
        filePatterns += deleteFilesDialog.eigenResultFiles()
        filePatterns += deleteFilesDialog.responseResultFiles()
        filePatterns += deleteFilesDialog.heatResultFiles()
        filePatterns += deleteFilesDialog.partMeshFiles()
        filePatterns += ["*.cnt", "*.msh", "*.dat", "*.csv", "*.unv", "*.bak"]
        filePatterns += ["*_data", "*.inp", "run", "runPlotMonitor*", "hecmw*"]
        #削除するfolder名を取得
        delFoldersSet = set([])
        for pattern in folderPatterns:
            folders = glob.glob(folderDir + os.sep + pattern)
            for folder in folders:
                if os.path.isdir(folder) == True:
                    delFoldersSet.add(folder)
        #削除するfile名を取得
        delFilesSet = set([])
        for pattern in filePatterns:
            files = glob.glob(folderDir + os.sep + pattern)
            for file in files:
                if os.path.isfile(file) == True:
                    delFilesSet.add(file)
        if len(delFoldersSet) != 0 or len(delFilesSet) != 0:
            #folderを削除
            for folder in delFoldersSet:
                shutil.rmtree(folder)
            #fileを削除
            for file in delFilesSet:
                os.remove(file)
            #dirTreeの内容を修正
            self.threadFlag = "run"
            res = procGetFolderContHdd(folderDir)
            #dataDict書き換え
            folderCont = res[:6]
            #folderCont = res[:5]
            self.treeWidget.dataDict[folderDir] = folderCont
            #itemDict書き換え
            itemCont = self.treeWidget.itemDict[folderDir]
            icon = self.iconFolder
            itemName = itemCont[1]
            weight = itemCont[-2]
            color = itemCont[-1]
            newItemCont = [icon, itemName] + folderCont[1:] + [weight, color]
            self.treeWidget.itemDict[folderDir] = newItemCont
            #dirTreeを修正
            self.writeFolderContToTreeItem(folderDir, folderCont)
            #  iconを書き換え
            self.treeWidget.changeColFromDir(folderDir, self.COL_ICON, icon)
            #statusBarを書き換え
            total = int(res[6]); free = int(res[7])
            self.writeHddUsageToStatusBar(total, free)
            self.threadFlag = "stop"

    #
    #  copyFolder
    #-------------
    def copyFolder(self):
        """ 選択folderをself.clipboardにコピーする"""
        selDirs = self.treeWidget.getSelectedDirs()
        self.setDirsToClipboard(selDirs)

    #
    #  pasteFolder
    #---------------
    def pasteFolder(self):
        """ self.clipboardの内容を取り出し、貼り付ける"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        
        #pasteDirを取得
        pasteDir = selDirs[0]
        #copyDirsを取得
        copyDirs = self.getDirsFromClipboard()
        stat = copyLocalToLocal(copyDirs, pasteDir)
        names = self.treeWidget.getChildNames(pasteDir)
        #parentDirを閉じて開く（parentDir以下を再取得）
        self.treeWidget.collapseChildDir(pasteDir)
        self.treeWidget.expandChildDir(pasteDir)
        #増加したitemを選択表示する
        self.treeWidget.unselectAllDir()
        newNames = self.treeWidget.getChildNames(pasteDir)
        addNames = set(newNames) - set(names)
        selDirs = list(map(lambda x: pasteDir + os.sep + x, addNames))
        for selDir in selDirs:
            self.treeWidget.selectDir(selDir)
        return

    #
    #  casePasteFolder
    #------------------
    def casePasteFolder(self):
        """ 計算結果を除いた内容をコピーする"""
        #copyDirsを取得
        copyDirs = self.getDirsFromClipboard()
        flag = 0
        for copyDir in copyDirs:
            folType = self.treeWidget.dataDict[copyDir][0]
            if folType != "case":
                flag = 1
                break
        if flag == 1:
            title = _("エラー")
            mess = _("pasteするfolderは、FrontISTRのfolderではありません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #pasteDirを取得
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        pasteDir = selDirs[0]
        #paste前のpasteDir内folder名を取得
        names = self.treeWidget.getChildNames(pasteDir)
        #貼り付け
        stat = copyCaseLocalToLocal(copyDirs, pasteDir)
        #parentDirを閉じて開く（parentDir以下を再取得）
        self.treeWidget.collapseChildDir(pasteDir)
        self.treeWidget.expandChildDir(pasteDir)
        #増加したfolde名を選択表示する
        self.treeWidget.unselectAllDir()
        newNames = self.treeWidget.getChildNames(pasteDir)
        addNames = set(newNames) - set(names)
        selDirs = list(map(lambda x: pasteDir + os.sep + x, addNames))
        for selDir in selDirs:
            self.treeWidget.selectDir(selDir)   
        return

    #
    #  runLoginShell
    #----------------
    def runLoginShell(self):
        """ loginシェルを起動する"""
        folderDir = self.treeWidget.getSelectedDir()
        print(_("loginシェルを起動します"))
        serverName = pyFistr.servers().getServerName(folderDir)
        server = pyFistr.server(serverName)
        hostDir = server.sshfsDict["hostDir"]
        mountDir = server.sshfsDict["mountPoint"]
        setEnviron = server.sshfsDict["setEnviron"]
        if mountDir == "":
            title = _("エラー")
            mess = _("serverがマウントされていません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #loginDir, setEnvironを作成
        if mountDir == folderDir[:len(mountDir)]:
            openDir = hostDir + folderDir[len(mountDir):]
            lines = setEnviron.split("\n")
            i = len(lines) - 1
            while i >= 0:
                if lines[i][:len("cd")] == "cd":
                    #words = lines[i].split()
                    lines[i] = "cd " + openDir
                    break
                i -= 1
            setEnviron = "\n".join(lines)
        else:
            setEnviron = ""
        #tempFile作成
        name = "setEnviron"
        fileName = os.getenv("easyIstrUserPath") + os.sep + name
        f=open(fileName, "w"); f.write(setEnviron); f.close()
        #environを転送
        server.scpCommandNoTerm(fileName, "~")
        #login端末を起動 
        server.runLoginTerm()

    #
    #  serverJobControl
    #-------------------
    def serverJobControl(self):
        """ focus Job管理"""
        selDir = self.treeWidget.getSelectedDir()
        serverName = pyFistr.servers().getServerName(selDir)
        if serverName == "":
            title = _("エラー")
            mess = _("serverがマウントされていません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #serverのaddress（url）を取得
        server = pyFistr.server(serverName)
        serverAdd = server.sshDict["url"]
        #Job管理を起動
        jobConScript = server.sshfsDict["jobConScript"]
        jobControl = os.getenv("easyIstrPath") + os.sep + "python" + os.sep + jobConScript
        comm = jobControl + " " + selDir + " &"
        pyFistr.run(selDir).command(comm)
        return

    #
    #  serverMount
    #--------------
    def serverMount(self):
        """ sshfsを使ってserverをマウントする"""
        mountDir = self.treeWidget.getSelectedDir()
        #errorチェック
        files = os.listdir(mountDir)
        if len(files) != 0:
            #エラー発生
            flag = 0
            for nameDir in files:
                name = os.path.basename(nameDir)
                if name == ".bashrc" or name == ".ssh":
                    flag += 1
            if flag == 2:
                title = _("警告")
                mess = _("既にマウントされています。")
                self.warningDialog(title, mess, parent=mainWindow)
                return
            else:
                title = _("エラー")
                mess = _("マウントするfolder内にファイルが存在します。") + "\n"
                mess += _("マウントできません。")
                self.errDialog(title, mess, parent=mainWindow)
                return
        #serverマウント
        self.selectMountServer(mountDir)

    #
    #  selServerMount
    def selServerMount(self, serverName, mountDir):
        """ serverNameをmountDirにマウントする"""
        if serverName == "":
            return
        #serverをマウント
        server = pyFistr.server(serverName)
        (stat, errMess) = server.mount(mountDir)
        if stat == "OK":
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            #接続内容を表示
            title = _("サーバマウント")
            mess = _("サーバをマウントしました。") + "\n\n"
            mess += "host " + serverName + "\n"
            mess += "HostName:    " + hostName + "\n"
            mess += "User:        " + userName + "\n"
            mess += "HostDir:     " + hostDir + "\n"
            mess += "MountPoint:  " + mountDir + "\n"
            self.okDialog(title, mess, parent=mainWindow)
        else:
            server.sshfsDict["mountPoint"] = ""
            server.writeSshfsData()
            title = _("エラー")
            mess = _("サーバをマウントできませんでした。") + "\n"
            mess += errMess
            self.errDialog(title, mess, parent=mainWindow)
        self.reloadDir("")

    #
    #  selectMountServer
    def selectMountServer(self, mountDir):
        """ mountするserverを取得する。"""

        def selectMountServer_onDlg(serverName, mountDir, mountedServers):
            """ dialogから起動する処理関数。"""
            if serverName == "" or serverName == None:
                return ""
            #エラーチェック
            flag = 0
            for mountedServer in mountedServers:
                if serverName == mountedServer:
                    flag = 1
                    break
            if flag == 1:
                title = _("エラー")
                mess = serverName + ": " + _("既にマウントされています。") + "\n"
                mess += _("マウントできません。")
                self.errDialog(title, mess, parent=mainWindow)
                serverName = ""
            #serverをマウントする。
            self.selServerMount(serverName, mountDir)

        (serverNames, mountedServers) = pyFistr.servers().getAllServerNames()
        funcName = selectMountServer_onDlg
        funcArgs = [mountDir, mountedServers]
        dialog = mountServerDDialog.mountServer(serverNames, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #
    #  serverUnmount
    #----------------
    def serverUnmount(self):
        """ sshfsサーバをアンマウントする"""
        unmountDir = self.treeWidget.getSelectedDir()
        currDir = getCurrDirFromTempFolder()
        #currDirがserver内かどうか確認
        currDirList = currDir.split(os.sep)
        unmountDirList = unmountDir.split(os.sep)
        if unmountDirList == currDirList[:len(unmountDirList)]:
            #error
            title = _("エラー")
            mess = _("アンマウントエラー") + "\n"
            mess += _("作業folderがserver内に有る為、アンマウントできません。") + "\n"
            mess += _("作業folderを移動して、アンマウントしてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #アンマウントの確認
        title = _("sshfsサーバアンマウント")
        mess = _("サーバをアンマウントします。")
        funcOk = [self.serverUnmountProcess, unmountDir]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # self.serverUnmountProcess(unmountDir) 

    #
    #  serverUnmountProcess
    def serverUnmountProcess(self, unmountDir):
        #アンマウント
        comm = "fusermount -z -u " + unmountDir
        (stat, _res, errMess) = pyFistr.run().commandReturnCont(comm)
        if stat == "OK":
            serverName = pyFistr.servers().getServerName(unmountDir)
            server = pyFistr.server(serverName)
            #mountPointを削除
            server.sshfsDict["mountPoint"] = ""
            server.writeSshfsData()
            self.reloadDir("")
        else:
            title = _("エラー")
            mess = _("サーバをアンマウントできませんでした。") + "\n"
            mess += _("folder名を確認してください。") + "\n\n"
            mess += errMess
            self.errDialog(title, mess, parent=mainWindow)

    #
    #  pasteScpCompTransfer
    #-----------------
    def pasteScpCompTransfer(self):
        """ clipboardの内容を取り出し、貼り付ける。
        server-local間、server間の「貼り付け」を行う。
        scp圧縮転送、cpコマンド使用する。"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        #pasteDirを取得
        pasteDir = selDirs[0]
        #copyDirsを取得
        copyDirs = self.getDirsFromClipboard()
        #server名を取得
        copyServer = pyFistr.servers().getServerName(copyDirs[0])
        pasteServer = pyFistr.servers().getServerName(pasteDir)
        #paste開始
        self.pasteUsingServer(copyServer, copyDirs, pasteServer, pasteDir)        
        return

    #
    #  pasteUsingServer
    def pasteUsingServer(self, copyServer, copyDirs, pasteServer, pasteDir):
        """ serverを介したpaste。
        状況に応じて、local->server, server->local, server->serverへpasteする。
        local->localのpasteは、エラー表示する"""
        
        def getPasteName(name):
            """ pasteDirに同名のpathがあるか確認し、あればcopy_0を付加する"""
            newCopyName = pasteDir + os.sep + name
            if os.path.exists(newCopyName) == False:
                #同名が存在しない場合
                return name
            #名称更新
            i = 0
            loop = True
            while loop:
                newName = name + "_copy" + str(i)
                newCopyName = pasteDir + os.sep + newName
                if os.path.exists(newCopyName) == False:
                    break
                i += 1
            return newName

        def runCommand(filesLines, lines):
            """ scpコマンド実行"""
            #スクリプト作成
            fileName = os.getenv("easyIstrUserPath") + os.sep + "run"
            f=open(fileName, "w")
            f.writelines(lines)
            f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
            #  空file作成
            f = open(logFile, "w", encoding="utf-8"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト
            line = "script " + logFile + " -a -q -f -c " + fileName
            line += " 2>&1 | tee -a " + os.getenv("LogFile")
            lines.append(line)
            fileName = os.getenv("easyIstrUserPath") + os.sep + "runrun"
            f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行
            appDict = pyFistr.readUsingApplications()
            terminalRun = appDict["terminalRun"]
            comm = terminalRun + " " + fileName
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.kill()
                print(_("中断しました。"))
            return stat

        def runCommandCp(filesLines, lines):
            """ cpコマンド実行"""
            fileName = os.getenv("easyIstrUserPath") + os.sep + "run"
            f=open(fileName, "w")
            f.writelines(lines)
            f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
            #  空file作成
            f = open(logFile, "w", encoding="utf-8"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト(scriptコマンド使用しない)
            lines.append("echo 'Script started on' >> " + logFile + "\n")
            lines.append(fileName + " >> " + logFile + "\n")
            lines.append("echo 'Script done on' >> " + logFile + "\n")
            fileName = os.getenv("easyIstrUserPath") + os.sep + "runrun"
            f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行
            comm = fileName + " 2>&1 | tee -a " + os.getenv("LogFile") + " &"
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.stdin.write(b"\x03")       #ctrl+cを出力
                proc.kill()
                print(_("中断しました。"))
            return stat

        def threadRunCommand(filesLines, lines, pastePathes):
            """ commandを作成し実行。実行後、Treeの内容を再作成する。"""
            stat = runCommand(filesLines, lines)
            #ending(stat, pastePathes)
            endingAddConts(stat, pastePathes)

        def threadRunCommandCp(filesLines, commLines, pastePathes):
            """ commandを作成し実行。実行後、Treeの内容を再作成する。"""
            stat = runCommandCp(filesLines, commLines)
            endingAddConts(stat, pastePathes)

        def ending(stat, pastePathes):
            """#pasteDirとpasteしたfolder名をセット
            timerEvent側でTreeを再作成する
            （thread側では操作できない為）"""
            self.threadShowTreeDir = [pasteDir, pastePathes]
            print(_("clipBoardの内容をcase貼り付けました。"))
            showMessage(stat)

        def endingAddConts(stat, pasteFolderName):
            """ copyFiles側からfolderContを取得し、pasteFiles側に適用する。
            treeにpasteしたfolderを追加(結果を削除)
              numFolder(結果folder)を削除したfolderContsを取得"""
            folderConts = getAddPasteFolderContDeleteNum(copyDirs, pasteFiles)
            self.threadCreateShowTreeDir = [pasteDir, folderConts]
            print(_("clipBoardの内容をcase貼り付けました。"))
            showMessage(stat)

        def getAddPasteFolderContDeleteNum(copyFiles, pasteFiles):
            """ 追加するfolderContを取得"""
            #folderの内容を取得
            folderConts = []
            for i in range(len(copyFiles)):
                copyFile = copyFiles[i]
                cont = self.treeWidget.dataDict[copyFile][:]
                #結果を削除
                cont[-1] = ("%4d" % 0) + " "
                pasteFile = pasteFiles[i]
                folderConts.append([pasteFile] + cont)
            return folderConts

        def showMessage(stat):
            if stat != "OK":
                title = _("case貼り付け")
                threadResult = _("処理を中断しました。") + "\n"
                threadResult += _("  中断しない場合、処理中の端末を閉じてください")
                GLib.timeout_add(1000, self.okDialog, title, threadResult, parent=mainWindow)

        #paste方法を取得
        # paste local->server
        if copyServer == "" and pasteServer != "":
            #localからserverへpasteする
            serverName = pasteServer
            server = pyFistr.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #貼り付け
            pasteFolder = hostDir + pasteDir[len(mountDir):]
            copyFiles = copyDirs
            pasteFiles = []
            lines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                name = copyFile.split(os.sep)[-1]
                newName = getPasteName(name)
                line = sshHeader + "scp -Cr " + copyFile + " " + userName + "@" + hostName + ":" + pasteFolder + "/" + newName + "\n"
                lines.append(line)
                pasteFiles.append(pasteDir + os.sep + newName)
            #全file名を取得
            logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
            filesLines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                line = "find " + copyFile + " -type f >> " + logFile + "\n"
                filesLines.append(line)
            #実行（threadを投げて直ぐに戻る）
            pasteFolderName = mountDir + pasteFolder[len(hostDir):] + os.sep + newName
            th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFiles))
            th.start()
        #paste sever->local
        elif copyServer != "" and pasteServer == "":
            #serverからlocalへpasteする
            serverName = copyServer
            server = pyFistr.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #copyFilesを取得
            copyFiles = []
            for name in copyDirs:
                if name[:len(mountDir)] == mountDir:
                    nameDir = hostDir + name[len(mountDir):]
                    copyFiles.append(nameDir)
            #貼り付け
            pasteFolder = pasteDir
            pasteFiles = []
            lines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                name = copyFile.split(os.sep)[-1]
                newName = getPasteName(name)
                line = sshHeader + " " + "scp -Cr " + userName + "@" + hostName + ":" + copyFile + " " + pasteFolder + "/" + newName + "\n"
                lines.append(line)
                pasteFiles.append(pasteDir + "/" + newName)
            #全file名を取得
            logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
            filesLines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                line = sshHeader + " ssh " + userName + "@" + hostName
                line += " find " + copyFile + " -type f >> " + logFile + "\n"
                filesLines.append(line)
            #実行（threadを投げて直ぐに戻る）
            pasteFolderName = pasteFolder + os.sep + newName
            th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFiles))
            th.start()
        #paste server->server
        elif copyServer != "" and pasteServer != "":
            #serverからserverへpasteする
            cpServer = pyFistr.server(copyServer)
            psServer = pyFistr.server(pasteServer)
            #同じserverName間でコピー
            if copyServer == pasteServer:
                server = cpServer
                hostName = server.sshfsDict["hostName"]
                userName = server.sshDict["user"]
                hostDir = server.sshfsDict["hostDir"]
                mountDir = server.sshfsDict["mountPoint"]
                sshHeader = server.sshfsDict["sshHeader"]
                #copyFilesを取得
                copyFiles = []
                for name in copyDirs:
                    if name[:len(mountDir)] == mountDir:
                        nameDir = hostDir + name[len(mountDir):]
                        copyFiles.append(nameDir)
                #貼り付けスクリプト
                pasteFolder = hostDir + pasteDir[len(mountDir):]
                lines = []; pasteFiles = []
                for copyFile in copyFiles:
                    name = copyFile.split(os.sep)[-1]
                    newName = getPasteName(name)
                    line = "cp -rfv " + copyFile + " " + pasteFolder + os.sep + newName
                    lines.append(line)
                    pasteFiles.append(pasteDir + os.sep + newName)
                comms = '"' + ";".join(lines) + '"'
                commLine = "ssh " + userName + "@" + hostName + " " +comms
                print(commLine)
                commLine = sshHeader + commLine
                #全file名を取得スクリプト
                logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    line = sshHeader + " ssh " + userName + "@" + hostName
                    line += " find " + copyFile + " -type f >> " + logFile + "\n"
                    filesLines.append(line)
                #実行、Treeを再表示（threadを投げて直ぐに戻る）
                pasteFolderName = mountDir + pasteFolder[len(hostDir):] + os.sep + newName
                commLines = [commLine]
                th = threading.Thread(target=threadRunCommandCp, args=(filesLines, commLines, pasteFiles))
                th.start()
        #paste local->local
        else:
            #localToLocalはエラー
            title = _("エラー")
            mess = _("copyFolder, pasteFolderともlocal側の設定です。") + "\n"
            mess += _("通常の「貼り付け」で貼り付けてください。")
            self.errDialog(title, mess, parent=mainWindow)
        return

    #
    #  casePasteScpCompTransfer
    #---------------------------
    def casePasteScpCompTransfer(self):
        """ clipboardの内容を取り出し、貼り付ける。
        server-local間、server間の「case貼り付け」を行う。
        scp圧縮転送、cpコマンド使用する。"""
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        #pasteDirを取得
        pasteDir = selDirs[0]
        #copyDirsを取得
        copyDirs = self.getDirsFromClipboard()
        #server名を取得
        copyServer = pyFistr.servers().getServerName(copyDirs[0])
        pasteServer = pyFistr.servers().getServerName(pasteDir)
        #paste開始
        self.casePasteUsingServer(copyServer, copyDirs, pasteServer, pasteDir)        
        return

    #
    #  casePasteUsingServer
    def casePasteUsingServer(self, copyServer, copyDirs, pasteServer, pasteDir):
        """ serverを介したcasePaste。
        状況に応じて、local->server, server->local, server->serverへpasteする。
        local->localのpasteは、エラー表示する"""
    
        def getPasteName(name):
            """ pasteDirに同名のpathがあるか確認し、あればcopy_0を付加する"""
            newCopyName = pasteDir + os.sep + name
            if os.path.exists(newCopyName) == False:
                #同名が存在しない場合
                return name
            #名称更新
            i = 0
            loop = True
            while loop:
                newName = name + "_copy" + str(i)
                newCopyName = pasteDir + os.sep + newName
                if os.path.exists(newCopyName) == False:
                    break
                i += 1
            return newName

        def checkCaseDir(caseDir):
            """ caseDir内にあるdirとfileを選別し、必要なものを返す。
            case初期化時に残すfolderとfileを返す"""
            resPathes = progressBar.resultPathes(caseDir)
            allPathes = glob.glob(caseDir + os.sep + "*")
            needPathes = set(allPathes) - set(resPathes)
            folders = list(filter(lambda x: os.path.isdir(x), needPathes))
            files = list(filter(lambda x: os.path.isfile(x), needPathes))
            return (folders, files)

        def getCopyNames(folder):
            """ copyするfileNameを取得する"""
            (copyDirs, copyFiles) = checkCaseDir(folder)
            copyNames = []
            for nameDir in (copyDirs + copyFiles):
                name = nameDir.split(os.sep)[-1]
                copyNames.append(name)
            return copyNames
        def changeHostToMountDir(folderDir):
            """ hostDirをlocalDirに変換する。"""
            newDir = mountDir + folderDir[len(hostDir):]
            return newDir

        def isCaseDir(copyDir):
            folType = self.treeWidget.dataDict[copyDir][0]
            if folType == "case":
                return True
            else:
                return False

        def runCommand(filesLines, lines):
            """ scp実行"""
            fileName = os.getenv("easyIstrUserPath") + os.sep + "run"
            f=open(fileName, "w")
            f.writelines(lines)
            f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
            #  空file作成
            f = open(logFile, "w", encoding="utf-8"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト
            line = "script " + logFile + " -a -q -f -c " + fileName
            line += " 2>&1 | tee -a " + os.getenv("LogFile")
            lines.append(line)
            fileName = os.getenv("easyIstrUserPath") + os.sep + "runrun"
            f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行
            appDict = pyFistr.readUsingApplications()
            terminalRun = appDict["terminalRun"]
            comm = terminalRun + " " + fileName
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.kill()
                print(_("中断しました。"))
            return stat

        def runCommandCp(filesLines, lines):
            """ cpコマンド実行"""
            fileName = os.getenv("easyIstrUserPath") + os.sep + "run"
            f=open(fileName, "w")
            f.writelines(lines)
            f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行ファイルを作成（log作成）
            logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
            #  空file作成
            f = open(logFile, "w", encoding="utf-8"); f.close()
            #  全fileを取得
            lines = filesLines
            #  copyスクリプト(scriptコマンド使用しない)
            lines.append("echo 'Script started on' >> " + logFile + "\n")
            lines.append(fileName + " >> " + logFile + "\n")
            lines.append("echo 'Script done on' >> " + logFile + "\n")
            fileName = os.getenv("easyIstrUserPath") + os.sep + "runrun"
            f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()
            pyFistr.run().command("chmod a+x " + fileName)
            #実行
            comm = fileName + " 2>&1 | tee -a " + os.getenv("LogFile") + " &"
            proc = subprocess.Popen(comm, shell=True, stdin=subprocess.PIPE)
            #GUIを表示
            stat = copyUsingServer(fileName, logFile)
            if stat == "CANCEL":
                #中断する
                proc.stdin.write(b"\x03")   #ctrl+cを出力
                proc.kill()
                print(_("中断しました。"))
            return stat

        def threadRunCommand(filesLines, lines, pastePathes):
            stat = runCommand(filesLines, lines)
            #ending(stat, pastePathes)
            endingAddConts(stat, pastePathes)

        def threadRunCommandCp(filesLines, comms, pasteFolderName):
            stat = runCommandCp(filesLines, comms)
            endingAddConts(stat, pasteFolderName)

        def ending(stat, pastePathes):
            """pasteDirとpasteしたfolder名をセット
            timerEvent側でTreeを再作成する
            （thread側では操作できない為）"""
            self.threadShowTreeDir = [pasteDir, pastePathes]
            print(_("clipBoardの内容をcase貼り付けました。"))
            showMessage(stat)

        def endingAddConts(stat, pasteFolderName):
            """ copyFiles側からfolderContを取得し、pasteFiles側に適用する。
            treeにpasteしたfolderを追加(結果を削除)
              numFolder(結果folder)を削除したfolderContsを取得"""
            folderConts = getAddPasteFolderContDeleteNum(copyDirs, pasteFiles)
            self.threadCreateShowTreeDir = [pasteDir, folderConts]
            print(_("clipBoardの内容をcase貼り付けました。"))
            showMessage(stat)

        def getAddPasteFolderContDeleteNum(copyFiles, pasteFiles):
            """ 追加するfolderContを取得"""
            #folderの内容を取得
            folderConts = []
            for i in range(len(copyFiles)):
                copyFile = copyFiles[i]
                cont = self.treeWidget.dataDict[copyFile][:]
                #結果を削除
                cont[-1] = ("%4d" % 0) + " "
                pasteFile = pasteFiles[i]
                folderConts.append([pasteFile] + cont)
            return folderConts

        def showMessage(stat):
            if stat != "OK":
                title = _("case貼り付け")
                threadResult = _("処理を中断しました。") + "\n"
                threadResult += _("  中断しない場合、処理中の端末を閉じてください")
                GLib.timeout_add(1000, self.okDialog, title, threadResult, parent=mainWindow)

        #メイン
        errorFlag = 0
        #localからserverにcaseコピー
        if copyServer == "" and pasteServer != "":
            serverName = pasteServer
            server = pyFistr.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #貼り付け
            pasteFolder = hostDir + pasteDir[len(mountDir):]
            copyFiles = copyDirs
            lines = ["#!/bin/bash\n"]
            mkdirLines = []
            pasteFiles = []
            for copyFile in copyFiles:
                name = copyFile.split(os.sep)[-1]
                newName = getPasteName(name)
                line = sshHeader + " " + "ssh "+ userName + "@" + hostName + ' "mkdir ' + pasteFolder + os.sep + newName + '"\n'
                mkdirLines.append(line)
                pasteFiles.append(pasteDir + os.sep + newName)
                copyNames = getCopyNames(copyFile)
                if isCaseDir(copyFile) == False:
                    errorFlag = 1
                    break
                else:
                    for copyName in copyNames:
                        line = sshHeader + " " + "scp -Cr " + copyFile + os.sep + copyName + " " + userName + "@" +  hostName + ":" + pasteFolder + "/" + newName + "/" + copyName + "\n"
                        lines.append(line)
            if errorFlag == 1:
                title = _("エラー")
                mess = _("「") + copyFile + _("」は、FrontISTRのcaseDirectoryではありません。\ncaseコピーできません。")
                print(mess)
                self.errDialog(title, mess, parent=mainWindow)
            else:
                #全file名を取得
                logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    filesLines.append("find " + copyFile + " -type f >> " + logFile + "\n")
                filesLines += mkdirLines        #mkdirコマンドを追加
                #実行、Tree再表示（threadを投げて直ぐに戻る）
                pasteFolderName = mountDir + pasteFolder[len(hostDir):] + os.sep + newName
                th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFiles))
                th.start()
        #serverからlocalにcaseコピー
        elif copyServer != "" and pasteServer == "":
            serverName = copyServer
            server = pyFistr.server(serverName)
            hostName = server.sshfsDict["hostName"]
            userName = server.sshDict["user"]
            hostDir = server.sshfsDict["hostDir"]
            mountDir = server.sshfsDict["mountPoint"]
            sshHeader = server.sshfsDict["sshHeader"]
            #copyFilesを取得
            copyFiles = []
            for name in copyDirs:
                if name[:len(mountDir)] == mountDir:
                    nameDir = hostDir + name[len(mountDir):]
                    copyFiles.append(nameDir)
            #貼り付け
            pasteFolder = pasteDir
            mkdirLines = []
            pasteFiles = []
            lines = ["#!/bin/bash\n"]
            for copyFile in copyFiles:
                name = copyFile.split("/")[-1]
                newName = getPasteName(name)
                line = "mkdir " + pasteFolder + os.sep + newName + "\n"
                mkdirLines.append(line)
                copyHostFile = mountDir + copyFile[len(hostDir):]
                copyNames = getCopyNames(copyHostFile)
                treeFolder = changeHostToMountDir(copyFile)
                if isCaseDir(treeFolder) == False:
                    errorFlag = 1
                    break
                else:
                    for copyName in copyNames:
                        line = sshHeader + " " + "scp -Cr " + userName + "@" + hostName + ":" + copyFile + os.sep + copyName + " " + pasteFolder + os.sep + newName + os.sep + copyName + "\n"
                        lines.append(line)
                        pasteFiles.append(pasteDir + os.sep + newName)
            if errorFlag == 1:
                title = _("エラー")
                mess = _("「") + copyFile + _("」は、FrontISTRのcaseDirectoryではありません。\ncaseコピーできません。")
                print(mess)
                self.errDialog(title, mess, parent=mainWindow)
            else:
                #全file名を取得
                logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
                filesLines = ["#!/bin/bash\n"]
                for copyFile in copyFiles:
                    line = sshHeader + " ssh " + userName + "@" + hostName
                    line += " find " + copyFile + " -type f >> " + logFile + "\n"
                    filesLines.append(line)
                filesLines += mkdirLines        #mkdirコマンドを追加
                #実行、Tree再表示（threadを投げて直ぐに戻る）
                pasteFolderName = pasteFolder + os.sep + newName
                th = threading.Thread(target=threadRunCommand, args=(filesLines, lines, pasteFiles))
                th.start()
        #server内からserver内へcaseコピー
        elif (copyServer != "" and pasteServer != ""):
            cpServer = pyFistr.server(copyServer)
            psServer = pyFistr.server(pasteServer)
            #同じserverName間でコピー
            if copyServer == pasteServer:
                server = cpServer
                hostName = server.sshfsDict["hostName"]
                userName = server.sshDict["user"]
                hostDir = server.sshfsDict["hostDir"]
                mountDir = server.sshfsDict["mountPoint"]
                sshHeader = server.sshfsDict["sshHeader"]
                #copyFilesを取得
                copyFiles = []
                for name in copyDirs:
                    if name[:len(mountDir)] == mountDir:
                        nameDir = hostDir + name[len(mountDir):]
                        copyFiles.append(nameDir)
                #貼り付け
                pasteFolder = hostDir + pasteDir[len(mountDir):]
                lines = ["#!/bin/bash\n"]
                pasteFiles = []
                for copyFile in copyFiles:
                    name = copyFile.split(os.sep)[-1]
                    newName = getPasteName(name)
                    line = "mkdir " + pasteFolder + os.sep + newName + "\n"
                    lines.append(line)
                    pasteFiles.append(pasteDir + os.sep + newName)
                    copyHostFile = mountDir + copyFile[len(hostDir):]
                    copyNames = getCopyNames(copyHostFile)
                    treeFolder = changeHostToMountDir(copyFile)
                    if isCaseDir(treeFolder) == False:
                        errorFlag = 1
                        break
                    else:
                        for copyName in copyNames:
                            line = "cp -rfv " + copyFile + os.sep + copyName + " " + pasteFolder + os.sep + newName + os.sep + copyName + "\n"
                            lines.append(line)
                if errorFlag == 1:
                    title = _("エラー")
                    mess = _("「") + copyFile + _(u"」は、FrontISTRのcaseDirectoryではありません。\ncaseコピーできません。")
                    print(mess)
                    self.errDialog(title, mess, parent=mainWindow)
                else:
                    #server内に実行file作成
                    fileName = mountDir + "/tmpRun"
                    f = open(fileName, "w", encoding="utf-8")
                    for line in lines:
                        f.write(line)
                    f.write("rm ~/tmpRun")      #tmpRunを削除を追記
                    f.close()
                    pyFistr.run().command("chmod a+x " + fileName)
                    #実行
                    comm = sshHeader + " " + "ssh " + userName + "@" + hostName + " " + hostDir + "/tmpRun"
                    #全file名を取得スクリプト
                    logFile = os.getenv("easyIstrUserPath") + os.sep + "scpLog"
                    filesLines = ["#!/bin/bash\n"]
                    for copyFile in copyFiles:
                        line = sshHeader + " ssh " + userName + "@" + hostName
                        line += " find " + copyFile + " -type f >> " + logFile + "\n"
                        filesLines.append(line)
                    #コマンド作成し実行、Treeを再表示（threadを投げて直ぐに戻る）
                    pasteFolderName = mountDir + pasteFolder[len(hostDir):] + os.sep + newName
                    comms = [comm]
                    th = threading.Thread(target=threadRunCommandCp, args=(filesLines, comms, pasteFolderName))
                    th.start()
        #paste local->local
        else:
            #localToLocalはエラー
            title = _("エラー")
            mess = _("copyFolder, pasteFolderともlocal側の設定です。") + "\n"
            mess += _("通常の「貼り付け」で貼り付けてください。")
            self.errDialog(title, mess, parent=mainWindow)
        return            

    #
    #  deleteServerFoldersRm
    #------------------------
    def deleteServerFoldersRm(self):
        """ server内folderを削除する"""

        def maskTreeEventFalse():
            self.maskTreeEvent = False

        #delDirを取得
        delDirs = self.treeWidget.getSelectedDirs()
        serverName = pyFistr.servers().getServerName(delDirs[0])
        if serverName == "":
            title = _("エラー")
            mess = _("serverがマウントされていません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        print(_("serverフォルダを削除します"))
        self.maskTreeEvent = True
        title = _("serverフォルダの削除")
        mess = _("server内のフォルダを削除します")
        funcOk = [self.reconfirmdeleteServerFoldersRm, serverName, delDirs]
        funcCancel = [maskTreeEventFalse]
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # ans = self.okCancelDialog(title, mess)
        # if ans != "OK":
        #     #eventのマスクを解除
        #     maskTreeEventFalse()
        #     return
        # self.reconfirmdeleteServerFoldersRm(serverName, delDirs)

    #
    #  reconfirmdeleteServerFoldersRm
    def reconfirmdeleteServerFoldersRm(self, serverName, delDirs):
        
        def maskTreeEventFalse():
            self.maskTreeEvent = False
        
        title = _("serverフォルダの削除")
        mess = _("本当にフォルダを削除しますか?") + "\n"
        mess += _("削除後は、元に戻りません。")
        funcOk = [self.deleteServerFoldersRmProcess, serverName, delDirs]
        funcCancel = [maskTreeEventFalse]
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # ans = self.okCancelDialog(title, mess)
        # if ans != "OK":
        #     #eventのマスクを解除
        #     maskTreeEventFalse()
        #     return
        # #削除
        # self.deleteServerFoldersRmProcess(serverName, delDirs)
        
    #
    #  deleteServerFoldersRmProcess
    def deleteServerFoldersRmProcess(self, serverName, delDirs):
        #server情報取得
        server = pyFistr.server(serverName)
        hostName = server.sshfsDict["hostName"]
        userName = server.sshDict["user"]
        hostDir = server.sshfsDict["hostDir"]
        mountDir = server.sshfsDict["mountPoint"]
        sshHeader = server.sshfsDict["sshHeader"]
        if mountDir == "":
            title = _("エラー")
            mess = _("サーバが接続されていません")
            mess += _("local側のfolderを削除する場合は、「フォルダ削除...」を選択してください")
            self.errDialog(title, mess, parent=mainWindow)
            #eventのマスクを解除
            self.maskTreeEvent = False
            return
        #削除
        for delDir in delDirs:
            delFolder = hostDir + delDir[len(mountDir):]
            comm = "rm -rf " + delFolder
            commLine = "ssh " + userName + "@" + hostName + ' "' + comm + '"'
            print(commLine)
            commLine = sshHeader + commLine       #sshにsshHeaderを追加
            pyFistr.run().commandWithLog(commLine)
        #delDirs[-1]のpathを取得（選択表示の為）
        showPath = self.treeWidget.getPathInTreeView(delDirs[-1])
        parentDir = os.path.dirname(delDirs[-1])
        #dataDictから該当dirを削除
        folders = list(self.treeWidget.dataDict.keys())
        for folderDir in folders:
            for delDir in delDirs:
                if folderDir == delDir:
                    dummy = self.treeWidget.dataDict.pop(folderDir)
                else:
                    if folderDir[:len(delDir)+1] == delDir + os.sep:
                        dummy = self.treeWidget.dataDict.pop(folderDir)
        #Treeを再作成、表示
        self.createTreeViewAtNewFolderDict(delDirs[-1])
        #選択表示
        #pathを数値に変換
        pathInt = []
        for i in range(len(showPath)):
            pathInt.append(showPath[i])
        #子の数を調べる
        names = self.treeWidget.getChildNames(parentDir)
        nChildren = len(names)
        if nChildren > 0:
            if pathInt[-1] >= nChildren:
                pathInt[-1] = nChildren - 1
        else:
            pathInt = pathInt[:-1]
        #pathを選択表示
        path = Gtk.TreePath.new_from_indices(pathInt)
        selDirList = self.treeWidget.getDirFromTreePath(path)
        selDir = os.sep.join(selDirList)
        self.treeWidget.selectDir(selDir)
        print(_("folderを削除しました"))
        #eventのマスクを解除
        self.maskTreeEvent = False

    #
    #  closeApp
    #  --------
    def closeApp(self):
        self.endingApp()
        self.close()

    #
    #  editUsingApp
    #---------------
    def editUsingApp(self):
        """ usingAppをGUI上で編集する。"""
        #GUIを表示
        funcName = self.editUsingApp_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [path, item] 
        dialog = editUsingAppDDialog.editUsingApp(funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return
    
    #  editUsingApp_onDlg
    def editUsingApp_onDlg(self, stat, path, item):
        """ apply後のusingAppの処理"""
        global runOfficeComm, runTerminalComm, runFileManagerComm, runEditorComm
        global frontIstrFolder, runParaViewComm, runGnuplotComm
        global vtkFormat
        if stat != "OK":
            return
        self.showThisPageIfNotShow(path, item)
        #usingAppの辞書を取得
        appDict = pyFistr.readUsingApplications()
        #PATHの設定
        fistrDir = appDict["frontIstrFolder"]
        if frontIstrFolder != fistrDir and fistrDir != "":
            frontIstrFolder = fistrDir
            if os.name != "nt":
                #linux
                setDir = getAbsDir(frontIstrFolder)
                os.environ["PATH"] = setDir + ":" + OrgPath
            else:
                #window
                os.environ["PATH"] = frontIstrFolder + ";" + OrgPath
        #言語の変更をチェック
        #appを再読込し、設定する
        runOfficeComm = appDict["office"]
        runTerminalComm = appDict["terminal"]
        runFileManagerComm = appDict["fileManager"]
        runEditorComm = appDict["editor"]
        frontIstrFolder = appDict["frontIstrFolder"]
        runParaViewComm = appDict["paraView"]
        #runRevocapComm = appDict["REVOCAP"]
        runGnuplotComm = appDict["gnuplot"]
        vtkFormat = appDict["vtkFormat"]

    #
    #  endingApp
    def endingApp(self):
        #windowsSizeを取得
        if mainWindow.is_maximized() == False:
            #fullScreen以外は、windowSizeを保存
            #windowSize
            (x, y) = mainWindow.get_size()
            winDict = {}
            winDict["windowSize"] = str(x) + " " + str(y)
            #paned
            splitEasyistr = self.paned_easyistr.get_position()
            splitVtk = self.paned_vtk.get_position()
            winDict["windowSize_splitter"] = str(splitEasyistr) + " " + str(splitVtk)
            pyFistr.writeWindowSize(winDict)

        # treeColWidthをセット
        dirColWidth = self.treeWidget.treeView.get_column(0).get_fixed_width()
        data = ["treeDirColWidth " + str(dirColWidth)]
        saveIstrData(data)

    #
    #  runTerminal
    #  -----------
    #    端末を起動する
    def runTerminal(self, event):
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        #os.chdir(currDir)
        #端末起動
        comm = runTerminalComm
        #os.system(comm)
        pyFistr.run(currDir).command(comm)
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  clearCntFile
    #---------------
    def clearCntFile(self, event):
        """ cntファイルを初期化する"""
        global FistrModel_cnt, FistrModel_msh, FistrModelDict
        title = _("cnt,datファイル初期化")
        mess = _("cnt,datファイルを初期化します。") + ls
        mess += _("  現在の設定が全てクリアされます。")
        funcOk = [self.clearCntFileProcess]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat == "OK":
        #     self.clearCntFileProcess()

    #
    #  clearCntFileProcess
    def clearCntFileProcess(self):
        currDir = getCurrDirFromTempFolder()
        #条件Tree内の展開しているnodeと選択しているnodeを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #cnt,mshファイルをdefault名に戻す
        FistrModel_cnt, FistrModel_msh = pyFistr.cntMshFileName(currDir)
        if FistrModel_msh != "FistrModel.msh":
            sourceFile = currDir + os.sep + FistrModel_msh
            newMshFile = currDir + os.sep + "FistrModel.msh"
            if os.path.exists(newMshFile) == True:
                os.remove(newMshFile)
            os.rename(sourceFile, newMshFile)
        FistrModel_cnt, FistrModel_msh = "FistrModel.cnt", "FistrModel.msh"
        FistrModelDict = pyFistr.getCntMshFileNameDict(currDir)
        #datファイル置き換え
        pasteFile = currDir + os.sep + "hecmw_ctrl.dat"
        copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + "hecmw_ctrl.dat"
        shutil.copy(copyFile, pasteFile)
        #余分なdat,cntファイルを削除する
        delFiles  = glob.glob(currDir + os.sep + "*.dat")
        delFiles += glob.glob(currDir + os.sep + "*.cnt")
        saveFiles = [currDir + os.sep + "hecmw_ctrl.dat",
                        currDir + os.sep + "FistrModel.cnt"]
        delFiles = set(delFiles) - set(saveFiles)
        for fileName in delFiles:
            os.remove(fileName)
        loadCaseToTempDir()
        #初期化する
        self.copyUseCntFile("")
        #nodeを展開する
        self.setTreeSetPage(expPathes, selPath)

    #
    #  loadDataToTemp
    #-----------------
    def loadDataToTemp(self):
        """ currDirの内容をtempFolderにコピーし、tempCaseを作成する。"""
        #global dimTrueFalseFlag
        title = _("tempCaseの作成")
        mess = _("作業folderの内容を省略圧縮してtempFolderにコピーします。") + "\n"
        mess += _("tempFolderの内容が失われますが、このまま継続しますか？")
        funcOk = [self.loadDataToTempProcess]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)

    #
    #  loadDataToTempProcess
    def loadDataToTempProcess(self):
        global dimTrueFalseFlag
        #条件Tree内の展開しているnodeと選択しているnodeを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        currDir = getCurrDirFromTempFolder()
        self.changeWorkFolder(currDir)
        #vtkDataを再作成して、表示する。
        self.newReloadVtkMesh()
        #nodeを展開する
        showPath = self.setTreeSetPage(expPathes, selPath)
        #showPathを表示
        self.changeItem(showPath)
        #createGrpPageを初期化する
        self.initCreateNgrpSgrpPage()
        if dimTrueFalseFlag == True:
            title = _("tempCaseの作成")
            mess = _("作業folderの内容をtempFolderにloadしました。")
            self.okDialog(title, mess, parent=mainWindow)

    #
    #  runCad
    #---------
    def runCad(self):
        """ usingAppで設定されているCADを起動する。"""
        appDict = pyFistr.readUsingApplications()
        comm = appDict["CAD"]
        if comm == "":
            title = _("エラー")
            mess = _("usingAppファイル中でCADが設定されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #CADを起動する
        saveDir = os.getcwd()
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #pyFistr.runAppBG(comm)
        #pyFistr.run(currDir).commandBG(comm)
        print(comm)
        pyFistr.run(currDir).commandWithLogBG(comm)
        os.chdir(saveDir)

    #
    #  runMesher
    #------------
    def runMesher(self):
        """ usingAppで設定されているMesherを起動する"""
        appDict = pyFistr.readUsingApplications()
        comm = appDict["mesher"]
        if comm == "":
            title = _("エラー")
            mess = _("usingAppファイル中でmesherが設定されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #mesherを起動する
        saveDir = os.getcwd()
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #pyFistr.run(currDir).commandBG(comm)
        print(comm)
        pyFistr.run(currDir).commandWithLogBG(comm)
        os.chdir(saveDir)

    #
    #  runOnlyParaView
    #--------------------
    def runOnlyParaView(self):
        """ paraViewのみを起動する"""
        global currDir
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        comm = runParaViewComm
        #pyFistr.runAppBG(comm)
        #pyFistr.run(currDir).commandBG(comm)
        print(comm)
        pyFistr.run(currDir).commandWithLogBG(comm)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  showVersion
    #--------------
    def showVersion(self):
        """ easyistrのバージョンを表示"""
        title = _("バージョン表示")
        mess = _("EasyISTRのバージョン") + "\n"
        mess += "EasyISTR-" + version + "\n\n"
        mess += " "*20 + "programed by s.Fujii"
        self.okDialog(title, mess, parent=mainWindow)

    #
    #  openWorkFolder
    #  --------------
    #    currDirを開く
    def openWorkFolder(self, event):
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #端末起動
        if os.name == "nt":
            #windows
            comm = runFileManagerComm + " " + currDir
            #os.system(comm)
            pyFistr.run(currDir).command(comm)
        else:
            #linux
            comm = runFileManagerComm + " " + currDir + " &"
            #os.system(comm)
            pyFistr.run(currDir).command(comm)
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  openTempFolder
    #  --------------
    #    tempFolderを開く
    def openTempFolder(self, event):
        #端末起動
        if os.name == "nt":
            #windows
            comm = runFileManagerComm + " " + currDir
            #os.system(comm)
            pyFistr.run().command(comm)
        else:
            #linux
            comm = runFileManagerComm + " " + currDir + " &"
            #os.system(comm)
            pyFistr.run().command(comm)

    #
    #  editCntMeshFile
    #  ---------------
    #    cnt, mesh, datファイルを開く
    def editCntMeshFile(self, event):
        fileNames = (currDir + os.sep + FistrModel_cnt + " " +
                     currDir + os.sep + FistrModel_msh + " " + 
                     currDir + os.sep + "hecmw_ctrl.dat")
        partFile = currDir + os.sep + "hecmw_part_ctrl.dat"
        #if len(glob.glob(partFile)) != 0:
        if os.path.exists(partFile) == True:
            fileNames += " " + partFile
        if os.name=="nt":
            names = fileNames.split()
            i = len(names)-1
            while i >= 0:
                fileName = names[i]
                comm = "start /b cmd /c " + runEditorComm + " " + fileName
                pyFistr.run().command(comm)
                i -= 1
        else:
            comm = runEditorComm + " " + fileNames + " &"
            pyFistr.run().command(comm)

    #
    #  saveTempData
    #  ------------
    #    tempFolderの設定内容をworkFolderに保存する
    def saveTempData(self, event):
        trueCurrDir = getCurrDirFromTempFolder()
        #if len(glob.glob(trueCurrDir)) == 0:
        if os.path.exists(trueCurrDir) == False:
            title = _(u"エラー")
            mess = _(u"tempFolderの保存") + "\n" + _(u"保存先のdir") + "\n" + trueCurrDir + "\n" + _(u"が存在しません") + "\n\n" + _(u"保存できません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #ファイル転送
        global currDir
        showSettingDialog("save temporary data")
        currDir = trueCurrDir
        os.chdir(currDir)
        numSettingDialog(20, "saving temporary setting data...")
        copyFilesFromTempToCurrDir()
        closeSettingDialog()
        #終了message
        title = _(u"tempFolderの保存")
        mess = _(u"tempFolderの保存") + "\n" + _(u"tempFolder内のファイルを") + "\n" + currDir + "\n" + _(u"に保存しました")
        self.okDialog(title, mess, parent=mainWindow)
        currDir = currDirTemp
        os.chdir(currDir)

    #
    #  importItem
    #-------------
    def importItem(self):
        """ importする"""
        istrLines = getSavedData()
        funcOk = [self.importItem_run]
        dialog = selectImportItemDDialog.getImportItem(istrLines, funcOk, parent=mainWindow)
        dialog.show()

    #  importItem_run
    def importItem_run(self, itemName):
        """ 選択したimport項目をimportする"""
        saveIstrData(["importItem " + itemName])
        if itemName == "cad":
            #cadをimport
            self.createMeshFromCad()
        elif itemName[:3] == "res":
            #結果fileのimport
            self.convertInpResToVtu()
        else:
            #meshをimport
            currDir = getCurrDirFromTempFolder()
            istrLines = getSavedData()
            funcConv = [self.convertMeshFromOther_run, currDir]
            dialog = convertMeshFromOtherMeshDDialog.convertMesh(currDir, istrLines, funcConv=funcConv, parent=mainWindow, selKey=itemName)
            dialog.show()

    #
    #  exportItem
    #-------------
    def exportItem(self):
        """ 選択した項目をexportする"""
        istrLines = getSavedData()
        funcOk = [self.exportItem_run]
        dialog = selectExportItemDDialog.getExportItem(istrLines, funcOk, parent=mainWindow)
        dialog.show()

    #  exportItem_run
    def exportItem_run(self, itemName):
        """ 選択したimport項目をimportする"""
        saveIstrData(["exportItem " + itemName])
        if itemName == "fistr2abaqus":
            #export inp
            self.convertToInp()
        elif itemName == "fistr2rad":
            #export rad
            self.convertToRad()
        else:
            #export meshio
            title = _("export file名の入力")
            currDir = getCurrDirFromTempFolder()
            funcOk = [self.exportItem_meshio, itemName]
            funcCancel = []
            selName = ""
            filterSet = selectExportItemDDialog.exportItemDict[itemName]
            filterSets = [filterSet, [_("全ファイル"), ["*"]]]
            self.saveFileDialog(title, currDir, funcOk, funcCancel, mainWindow, selName, filterSets)

    #  exportItem_meshio
    def exportItem_meshio(self, fileName, formatKey):
        """ meshioを使って、meshをexportする"""
        #file名をチェック
        if os.path.exists(fileName) == True:
            title = _("meshio によるmesh変換")
            mess  = _("指定したfile名と同じfileが存在します。") + "\n"
            mess += "  " + _("継続すると、file内容が書き換わります。") + "\n\n"
            mess += "  " + _("このまま継続しますか？")
            funcOk = [self.convertItem_runMeshio, fileName, formatKey]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        self.convertItem_runMeshio(fileName, formatKey)

    #  convertItem_runMeshio
    def convertItem_runMeshio(self, fileName, formatKey):
        """ meshioを実行"""
        global currDir
        showSettingDialog("exporting mesh file")
        #currDirを実folderに設定
        currDir = getCurrDirFromTempFolder()
        #tempFolderを保存
        copyFilesFromTempToCurrDir()
        #headerDataを取得
        numSettingDialog(20, "reading mesh data...")
        os.chdir(currDir)
        #lines = pyFistr.readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        os.chdir(currDirTemp)
        #export
        #  format名に置き換え
        key = formatKey[len("write"):].lower()
        name = os.path.basename(fileName)
        #  export
        numSettingDialog(50, "exporting " + key + " mesh at meshio...")
        writeMesh = meshOp.write(meshHeaderData, key)
        writeMesh.write(fileName)
        closeSettingDialog()
        title = _("meshio によるmesh変換")
        mess  = _("FrontISTR形式のメッシュを") + "\n"
        mess += "  " +_("meshioを使って '") + key + _("' 形式に変換しました。") + "\n\n"
        mess += "  '" + name + "' ファイルを作成しました。 "
        self.okDialog(title, mess, parent=mainWindow)

    #
    #  clearFolder
    #  -----------
    #    workFolderをクリアする
    def clearFolder(self, event):
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #folderClear
        comm = "python3 " + pythonAppPath + "deleteFilesDialog2.py"
        pyFistr.run(currDir).commandBG(comm)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  setGroupName
    #  ------------
    #    comboBox内の組み込みentryに選択nameをセット
    def setGroupName(self, event):
        nIter = self.comboBox_soldyGroup.get_active_iter()
        if nIter != None:
            model = self.comboBox_soldyGroup.get_model()
            name = model[nIter][0]
            entry = self.comboBox_soldyGroup.get_child()
            entry.set_text(name)

    def changeWorkFolder(self, currDir1):
        """ workFolderを変更する"""
        global meshHeaderData, istrData, FistrModel_cnt, currDir
        global FistrModel_msh, FistrModelDict, dimTrueFalseFlag
        
        currDir = currDir1
        os.chdir(currDir)
        FistrModelDict = pyFistr.getCntMshFileNameDict(currDir)
        FistrModel_cnt, FistrModel_msh = FistrModelDict["cnt"], FistrModelDict["msh"]
        dimTrueFalseFlag = isDimensionInCurrDir(currDir)     #dimension有無を確認
        saveIstrData(["currDir " + currDir])
        #cnt,mshファイル有無チェック
        stat = self.checkCntMshFile()
        if stat != "OK":
            title = _(u"workFolderの初期化")
            mess = _(u"必要なファイルが存在しなかったので、コピーしました")
            self.okDialog(title, mess, parent=mainWindow)
        #currDirをlabelにセット
        self.setCurrDirInLabel(currDir)
        #tempファイルを作成
        clearTempCase()
        createTempCase(currDir)
        copyOtherFilesToTemp(currDirTemp, currDir)
        #環境をtempCaseに設定
        currDir = currDirTemp
        paraLine = getParallelOptionLineFromTrueFolder()
        saveIstrData([paraLine, "currDir " + currDir])
        os.chdir(currDir)
        #tempCase内容を読み取り
        self.setCntFilesToListBox()
        #Fistrmodel.mshデータを取得
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        self.setMeshCont()
        #FistrModel.cntデータ取得
        checkReformCntFile()        #cntFileの内容をチェック修正
        self.setControlCont()       #cntFileの内容を取得
        matchControlCont()          #meshとcntFileの整合をとる
        dim, matFile = getDimensionMatFileFromIstrData()
        istrData = getSavedData()
        dim, matFile = getDimensionMatFileFromIstrData()
        self.setIstrData()
        if dimTrueFalseFlag == False:
            #dimensionが未設定の為、設定する
            self.setIniDimenionToCurrDir()
            self.setDimensionToCurrDir()
        self.checkDimensionMatCsv()     #dimensionのチェック

        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #treeのfontColour, fontStyle設定
        self.readUnsetTreeItems()
        self.setTreeFontColour(anaType)

        #材料物性値のDialog表示
        self.readMaterialDB()
        self.setMaterialNameToListBox()
        self.setMaterialModelToComboBox()
        #tempCaseDateを修正
        cntDate = os.path.getmtime(currDirTemp + os.sep + FistrModel_cnt) + 1.0
        mshDate = os.path.getmtime(currDirTemp + os.sep + FistrModel_msh) + 1.0
        tempCaseDate = max([cntDate, mshDate])        
        self.saveTempCaseDate(tempCaseDate)

    #
    #  saveTempCaseDate
    def saveTempCaseDate(self, caseDate):
        """ meshContファイルのtempCaseDateを書き換える"""
        fileName = currDirTemp + os.sep + "meshConts"
        f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        for i in range(len(lines)):
            line = lines[i]
            if line[:len("*tempCaseDate")] == "*tempCaseDate":
                lines[i+1] = str(caseDate) + "\n"
                break
        f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()

    #
    #  setTreeSetPage
    def setTreeSetPage(self, expPathes, selPath):
        """ Tree（設定項目Tree）を展開して、itemを選択する"""
        #treeを展開する
        for path in expPathes:
            self.tree_main.expand_to_path(path)
        #itemを選択する
        if selPath == None:
            selPath = Gtk.TreePath.new_from_indices([0])
        treeselection = self.tree_main.get_selection()
        treeselection.select_path(selPath)
        _treestore, pathes = treeselection.get_selected_rows()
        #選択できていない場合は、1段上がって選択する
        if len(pathes) == 0:
            pathInt = selPath.get_indices()
            selPath = Gtk.TreePath.new_from_indices(pathInt[:-1])
            treeselection.select_path(selPath)
        #pageを表示
        self.tree_main.set_cursor(selPath, None, False)
        return selPath

    #
    #  getExpandedSelectedNodesInTree
    def getExpandedSelectedNodesInTree(self):
        """ 設定項目Treeの展開しているnodeと選択しているnodeを取得して返す。"""
        
        def getChildIters(parentIters):
            """ childIterを取得して返す"""
            childIters = []
            for parentIter in parentIters:
                nChildren = self.treestore.iter_n_children(parentIter)
                for i in range(nChildren):
                    childIter = self.treestore.iter_nth_child(parentIter, i)
                    childIters.append(childIter)
            return childIters                    

        def getExpandIters(itemIters):
            """ itemの中で展開されているitemを取得して返す"""
            expIters = []
            for itemIter in itemIters:
                path = self.treestore.get_path(itemIter)
                if self.tree_main.row_expanded(path):
                    expIters.append(itemIter)
            return expIters
        
        saveIters = []
        rootPath = Gtk.TreePath.new_from_indices([0])
        rootIter = self.treestore.get_iter(rootPath)
        itemIters = getChildIters([rootIter])
        #itemの子itemの展開状況を確認
        expIters = getExpandIters(itemIters)
        saveIters += expIters
        #itemの孫itemの展開状況を確認
        itemIters = getChildIters(expIters)
        expIters = getExpandIters(itemIters)
        saveIters += expIters
        #pathに変更
        savePathes = []
        for iter in saveIters:
            path = self.treestore.get_path(iter)
            savePathes.append(path)
        #選択itemを取得
        treeselection = self.tree_main.get_selection()
        _treeStore, pathes = treeselection.get_selected_rows()
        if len(pathes) > 0:
            selPath = pathes[0]
        else:
            selPath = None
        #展開しているpathと選択pathを返す
        return (savePathes, selPath)

    #  checkTempCaseDate
    #    tempCaseDateを確認し、cnt,mshファイルが修正されていれば、保存する
    def checkTempCaseDate(self, newDir):
        """ tempCaseDataを確認後、workFolderをnewDirに移動する"""
        global currDir
        #tempCase内のcnt,mshファイルの更新有無確認
        currDir = currDirTemp
        os.chdir(currDir)
        #cnt,mshファイル有無確認
        if (os.path.exists(FistrModel_cnt) == False or 
            os.path.exists(FistrModel_msh) == False):
            #cnt,mshが存在しない場合、即workFolder移動
            self.setNewCurrDir(newDir)
            return
        #tempFolder内にcnt,mshファイルが存在する場合
        timeStampCnt = os.path.getmtime(FistrModel_cnt)
        timeStampMsh = os.path.getmtime(FistrModel_msh)
        tempCaseDate = getMeshContsFromTempFolder()["tempCaseDate"]
        if tempCaseDate <= timeStampCnt or tempCaseDate <= timeStampMsh:
            #yesNoDialog表示
            title = _(u"tempFolderの保存")
            mess = _(u"tempFolderの保存") + "\n" + _(u"tempFolder内のデータが更新されています") + "\n" + _(u"作業用folder移動前に、保存しますか？")
            funcYes = [self.checkTempCaseDate_onDlgYes, newDir]
            funcNo = [self.setNewCurrDir, newDir]
            self.yesNoDialog(title, mess, funcYes, funcNo, parent=mainWindow)
        else:
            #newDirをcurrDirに設定する
            self.setNewCurrDir(newDir)

    #
    #  checkTempCaseDate_onDlgYes
    def checkTempCaseDate_onDlgYes(self, newDir):
        """ yesNoDialogで「yes」を選択。
        tempDirの内容をcurrDirに保存後、currDirを移動する。"""
        global currDir
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        #if len(glob.glob(currDir)) == 0:
        if os.path.exists(currDir) == False:
            title = _(u"エラー")
            mess = _(u"tempFolderの保存") + "\n" + _(u"保存先のdir") + "\n" + currDir + "\n" + _(u"が存在しません") + "\n\n" + _(u"保存できませんでした")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #ファイル転送
        os.chdir(currDir)
        #ファイル転送（tempCase　→　実case）
        copyFilesFromTempToCurrDir()
        os.chdir(currDirTemp)
        #newDirをcurrDirに設定する
        self.setNewCurrDir(newDir)

    #
    #  setDefaultCntMshName
    #-----------------------
    def setDefaultCntMshName(self):
        """ cnt,mshファイル名をdefaultに戻す。"""
        if FistrModel_cnt == "FistrModel.cnt" and FistrModel_msh == "FistrModel.msh":
            return
        self.clearCntFile("")

    #
    #  setUseCntFile
    #  -------------
    #    手本のcntファイルをセット
    def setUseCntFile(self, event):
        (_listmodel, listIter) = self.listBox_cntFile.get_selection().get_selected()
        if listIter != None:
            useFile = self.listmodelCntFile.get_value(listIter, 0)
        else:
            title = _(u"エラー")
            mess = _(u"cntファイルを選択してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        self.textCtrl_useCntFile.set_text(useFile)

    #
    #  copyUseCntFile
    #  --------------
    def copyUseCntFile(self, event):
        """ cntファイル内容をdefaultの内容に戻す。"""
        global FistrModel_cnt, FistrModel_msh
        #実folder内のcntファイルを置き換える
        name = self.textCtrl_useCntFile.get_text()
        copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + name
        #if len(glob.glob(copyFile)) == 0:
        if os.path.exists(copyFile) == False:
            title = _(u"エラー")
            mess = _(u"cntファイルが正しく設定されていません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        pasteFile = currDir + os.sep + FistrModel_cnt
        shutil.copy(copyFile, pasteFile)
        #cntファイルを初期化（境界条件を削除する）
        getMeshHeaderData()
        resetCntMshFile()
        self.setControlCont()       #cntFileの内容を取得
        matchControlCont()          #meshとcntFileの整合をとる
        #Tree作成
        makeIniTreeData()
        self.setIniTreeData()
        #single計算に置き換え
        (_para, nCpu, nThread, fistrVer) = getParallelInSavedData()
        hideHcmwPartCtrlDat()
        setSingleHcmwCtrlDat()
        self.button_solveFistr.set_label(_(u"FrontISTR実行"))
        #useCntFileを保存 15/10/13
        saveIstrData(["useCntFile " + name,
                    "parallel False " + nCpu,
                    "thread " + nThread])
        #FistrModel.cnt, hecmw_ctrl.datを元のcurrDirにも書き換える
        copyFiles = [FistrModel_cnt, "hecmw_ctrl.dat"]
        pasteFolder = getCurrDirFromTempFolder()
        for copyFile in copyFiles:
            shutil.copy(copyFile, pasteFolder)
        #終了メッセージ
        title = _(u"cntファイルの置き換え")
        mess = _(u"cntファイルを置き換えて、制御ファイルを初期化しました")
        self.okDialog(title, mess, parent=mainWindow)

    #
    #  createMeshFromCad
    #--------------------
    def createMeshFromCad(self):
        """ CADfileからmesh作成する"""
        currDir = getCurrDirFromTempFolder()
        #fileをクリア
        resultFile = currDir + os.sep + "createMeshResult"
        self.monitorFile = resultFile
        if os.path.exists(self.monitorFile) == True:
            os.remove(self.monitorFile)
        #createMesh実行
        pythonAppPath = os.getenv("pythonApp")
        comm = "python3 " + pythonAppPath + os.sep
        comm += "createMeshFromCadFileDialog.py "
        comm += currDir
        pyFistr.run().commandWithLogBG(comm)
        #実行を監視
        GLib.timeout_add(200, self.waitUntilCreatingMeshEnd)

    #  waitUntilCreatingMeshEnd
    def waitUntilCreatingMeshEnd(self):
        """ Gmshの実行を監視し、その結果を取得する"""
        #settingFileが出来上がるまで待つ
        if os.path.exists(self.monitorFile) == False:
            return True
        #fileを読み込む
        lines = pyFistr.readFistrFileUntilEnd(self.monitorFile)
        if lines[0].split()[0] == "OK":
            condMeshDict = {}
            for line in lines[1:]:
                words = line.split()
                if len(words) > 1:
                    condMeshDict[words[0]] = words[1]
            self.createMeshFromCad_run(condMeshDict)
        #monitorFileを削除
        os.remove(self.monitorFile)
        #timerEventを停止
        return False


    #  createMeshFromCad_run
    def createMeshFromCad_run(self, condMeshDict):
        """ mesh作成"""
        if condMeshDict["keepCond"] == "yes":
            #設定を保持してmesh作成
            self.createMeshFromCadKeepSetting(condMeshDict)
            #set341elm_selectiveの設定
            self.set341elm_setCheckBox()
        else:
            #設定をクリアしてmesh変換
            self.set_newMesh_or_addMesh(condMeshDict)    

    #
    #  set_newMesh_or_addMesh
    #-------------------------
    def set_newMesh_or_addMesh(self, condMeshDict):
        """ createMeshFromCad実行後の後処理。
        設定をクリアしてnewMeshに入れ替える。"""
        global meshHeaderData
        currDir = getCurrDirFromTempFolder()
        meshName = ".".join(os.path.basename(condMeshDict["sourceMesh"]).split(".")[:-1]) + "_fistr.msh"
        fileName = currDir + os.sep + meshName
        showSettingDialog("read mesh file")
        numSettingDialog(20.0, "getting mesh parts data...")
        #lines = pyFistr.readFistrFileUntilEnd(fileName)
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData_file(fileName)
        closeSettingDialog()
        xyz = getModelSize()
        title = _("scale変更")
        mess  = _("新しいmeshのscaleを変更します。") + ls
        mess += _("  " + xyz)
        mess += _("scaleを入力してください。")
        iniText = "1.0"
        funcOk = [self.createMesh_changeScaleCreateTempcase,
                  condMeshDict]
        funcCancel = [self.createMesh_createTempCase,
                  condMeshDict]
        dialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        dialog.show()

    #  createMesh_changeScaleCreateTempcase
    def createMesh_changeScaleCreateTempcase(self, scale, condMeshDict):
        """ mesh変換後、scale変更とtempCaseを作成する。"""
        global currDir, meshHeaderData
        showSettingDialog("create FrontISTR mesh")
        numSettingDialog(20, "changing scale...")
        mshFile = ".".join(os.path.basename(condMeshDict["sourceMesh"]).split(".")[:-1]) + "_fistr.msh"
        #sourceMeshのscaleを変更
        self.changeSourceMeshScale(mshFile, scale)
        #option処理、tempCaseを作成
        self.createMesh_createTempCase(condMeshDict)

    #  showCompleteNewMesh
    def showCompleteNewMesh(self):
        """ meshが完成したことを知らせるメッセージを出力する。"""
        mess = _(u"新しいmeshが完成しました。")
        print (mess)
        title = _(u"newMesh")
        self.okDialog(title, mess, parent=mainWindow)

    #  createMesh_createTempCase
    def createMesh_createTempCase(self, condMeshDict):
        """ mesh作成後のoptionを処理し、tempCaseを作成する"""
        global meshHeaderData
        global currDir, meshGroup
        if settingDialog.poll() != None:
            showSettingDialog("create FrontISTR mesh")
        #実folderを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        currDirTrue = currDir
        name = ".".join(os.path.basename(condMeshDict["sourceMesh"]).split(".")[:-1]) + "_fistr.msh"
        mshFile = currDir + os.sep + name
        #mesh追加？
        if condMeshDict["addMesh"] == "yes":
            numSettingDialog(40, "adding new mesh to current mesh...")
            #今のmeshに追加する
            lines = self.addConvertMeshToCurrMesh(mshFile)
            meshHeaderData = pyFistr.getHeaderNumData(lines)
        else:
            #作成したmeshに置き換える
            numSettingDialog(40, "replacing new mesh...")
            #mesh変換のみ
            lines = pyFistr.readFistrFileUntilEnd(mshFile)
            pyFistr.writeFistrModelMsh(lines)
            os.remove(mshFile)
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
        #meshGroupを取得
        parameterList = getMeshParameterList()
        paraNum = getParameterNumber(parameterList)
        meshGroup = createMeshGroup(paraNum)
        #設定をクリアする
        #  cnt, datファイルを初期化
        name = self.textCtrl_useCntFile.get_text()
        copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + name
        shutil.copy(copyFile, currDirTrue + os.sep + FistrModel_cnt)
        shutil.copy(copyFile, currDirTemp + os.sep + FistrModel_cnt)
        #resetと書き込み、meshHeaderData更新、Tree内容もreset
        resetCntMshFile()

        numSettingDialog(60, "creating temporary case...")
        #tempCaseを作成
        meshHeaderDataSave = meshHeaderData         #headerDataを保存
        self.pickleDumpHeaderData(meshHeaderData)   # fileに保存
        createTempCaseFromMeshData(currDirTrue, lines, meshHeaderData)
        self.setMeshCont()
        #環境を戻す(tempFolder)
        os.chdir(currDirTemp)
        currDir = currDirTemp
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        meshHeaderDataTemp = meshHeaderData 
        #並列処理checkを外す
        self.checkBtn_solvePara.set_active(False)
        fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
        if os.path.exists(fileName) == True:
            os.remove(fileName)
        #cntファイルをsingleCore用に修正
        setSingleHcmwCtrlDat()
        #TreeDataを作成（mesh変換時initialDataを再設定）
        addInitempGroupInTreeData(initempDefine)
        #解析の種類以下のtreeDataを削除
        if type(treeSolution[0]) == list:
            treeSolution[0] = treeSolution[0][0]
        #treeDataを作成
        makeTreeData()
        #treeを作成
        self.setIniTreeData()
        treeList = [_(u"FistrModel.msh")]
        self.showTreeData(treeList)
        #set内容をistrDataに書き込み
        itemNames = condMeshDict.keys()
        saveData = []
        for item in itemNames:
            line = item + " " + condMeshDict[item]
            saveData.append(line)
        saveIstrData(saveData)
        #easyIsreSub_dataを実folderにコピーする。
        fileName = currDir + os.sep + istrSubDataFileName
        shutil.copy(fileName, currDirTrue)
        closeSettingDialog()

        #vtkModelを表示
        #  vtkMeshdataを削除する
        meshHeaderData = meshHeaderDataSave     #headerDataを復帰
        vtkFolder = currDirTrue + os.sep + self.vtkFolder
        if os.path.exists(vtkFolder):
            shutil.rmtree(currDirTrue + os.sep + self.vtkFolder)
        #  vtk表示
        if self.showModel == True:
            self.recreateVtk = "yes"
            #self.setVtkModel()
            self.reloadVtkMesh()    #時間制限なしのvtk作成、読み込み
        #createGrpPageを初期化
        self.initCreateNgrpSgrpPage()
        #set341elm_selectiveの設定
        self.set341elm_setCheckBox()
        #sourceMesh名をlabelに設定
        self.setSourceMeshFileToLabel()
        #終了メッセージ
        self.showCompleteNewMesh()
        #currTempのmeshHeaderDataを取得
        meshHeaderData = meshHeaderDataTemp

    #
    #  pickleDumpHeaderData
    def pickleDumpHeaderData(self, meshHeaderData):
        fileName = currDir + os.sep + "meshHeaderData.bin"
        f = open(fileName, "wb")
        pickle.dump(meshHeaderData, f)
        f.close()

    #
    #  createMeshFromCadKeepSetting
    #-------------------------------
    def createMeshFromCadKeepSetting(self, condMeshDict):
        """ createMeshFromCad実行後の後処理。
        設定を保持したままnewMeshに入れ替える。"""
        global meshHeaderData
        global currDir
        #mshTempファイル内の設定を取得
        showSettingDialog("read mesh file")
        numSettingDialog(0.0, "reading mesh file lines...")
        remHeaders = []
        matHeaders = []
        checkHeaders = ["!CONTACTPAIR", "!INITIALCONDITION", "!AMPLITUDE",
                        "!CONTACT PAIR", "!INITIAL CONDITION"]
        checkMatHeaders = ["!SECTION", "!MATERIAL", "!ITEM=1", "!ITEM=2", "!ITEM=3"]
        #lines = readFistrModelMsh()
        numSettingDialog(20.0, "getting mesh parts data...")
        #headerNumData = pyFistr.getHeaderNumData(lines)
        headerNumData = getReturnMeshHeaderData()
        for headerData in headerNumData:
            header = headerData[0]
            headerName = deleteSp(header).split(",")[0]
            if headerName in checkHeaders:
                remHeaders.append(headerData)
            elif headerName in checkMatHeaders:
                matHeaders.append(headerData)
        headerNumData = []
        #set内容をistrDataに書き込み
        itemNames = condMeshDict.keys()
        saveData = []
        for item in itemNames:
            line = item + " " + condMeshDict[item]
            saveData.append(line)
        saveIstrData(saveData)
        #元のcurrDirを取得        
        currDir = getCurrDirFromTempFolder()
        #meshName = ".".join(condMeshDict["sourceMesh"].split(".")[:-1]) + "_fistr.msh"
        meshName = ".".join(os.path.basename(condMeshDict["sourceMesh"]).split(".")[:-1]) + "_fistr.msh"
        fileName = currDir + os.sep + meshName
        #f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        #lines = pyFistr.readFistrFileUntilEnd(fileName)
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData_file(fileName)
        closeSettingDialog()
        xyz = getModelSize()
        title = _("scale変更")
        mess  = _("新しいmeshのscaleを変更します。") + ls
        mess += _("  " + xyz)
        mess += _("scaleを入力してください。")
        iniText = "1.0"
        #変数を取得
        sourceMeshFile = condMeshDict["sourceMesh"]
        option = condMeshDict["convertOpt"]
        addMesh = False; keepCond = False
        if condMeshDict["addMesh"] == "yes":
            addMesh = True
        if condMeshDict["keepCond"] == "yes":
            keepCond = True
        #dialog表示
        funcOk = [self.meshConvertKeep_changeScaleCreateTempCase,
                  meshName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond]
        funcCancel = [self.meshConvertKeep_createTempCase,
                  meshName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond]
        dialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        dialog.show()
        #currDirを元に戻す
        currDir = currDirTemp


    #
    #  convertMeshFromOther
    #-----------------------
    def convertMeshFromOther(self):
        """ 他形式メッシュをfistr形式に変換する"""
        currDir = getCurrDirFromTempFolder()
        istrLines = getSavedData()
        funcConv = [self.convertMeshFromOther_run, currDir]
        dialog = convertMeshFromOtherMeshDDialog.convertMesh(currDir, istrLines, funcConv=funcConv, parent=mainWindow)
        dialog.show()

    #  convertMeshFromOther_run
    def convertMeshFromOther_run(self, convOpt, sourceMeshFile, addMesh, keepCond, currDir):
        """ mesh変換"""
        #設定を保持する？
        if keepCond == True:
            #設定を保持してmesh変換
            self.meshConvertKeepSetting(sourceMeshFile, convOpt, addMesh)
            #set341elm_selectiveの設定
            self.set341elm_setCheckBox()
        else:
            #設定をクリアしてmesh変換
            self.meshConvertClearSetting(sourceMeshFile, convOpt, addMesh)
        
    #
    #  meshConvertClearSetting
    #--------------------------
    def meshConvertClearSetting(self, sourceMeshFile, option, addMesh):
        """ 設定をクリアしてmesh変換"""
        global currDir, meshHeaderData
        keepCond = False
        #設定をクリアしてmesh変換
        showSettingDialog("converting mesh file")
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        currDirTrue = currDir
        #cnt, dat, mshファイル有無チェック
        self.checkCntMshFile()
        
        #mesh変換後fileが存在する場合は削除
        name = os.path.basename(sourceMeshFile)
        fileName = ".".join(name.split(".")[:-1]) + "_fistr.msh"
        #fileName = ".".join(sourceMeshFile.split(".")[:-1]) + "_fistr.msh"
        if os.path.exists(fileName) == True:
            os.remove(fileName)
        #mesh変換
        meshFile = os.path.normpath(currDir + os.sep + sourceMeshFile)
        #  unv2fistr
        if option == "unv2fistr":
            numSettingDialog(20, "converting unv mesh file...")
            comm = "python3 " + binAppPath + "unv2fistr.py " + meshFile
            comm += " " + fileName
            pyFistr.run(currDir).command(comm)
        #  abaqus2fristr
        elif option == "abaqus2fistr":
            numSettingDialog(20, "converting abaqus mesh file...")
            comm = "python3 " + binAppPath + "abaqus2fistr.py " + meshFile
            comm += " " + fileName
            pyFistr.run(currDir).command(comm)
        #  meshio
        elif option[:len("read")] == "read":
            format = option[len("read"):].lower()
            numSettingDialog(20, "converting " + format + " mesh at meshio...")
            #meshFile = currDir + os.sep + sourceMeshFile
            readMesh = meshOp.read(meshFile, format)
            headerData = readMesh.meshio2fistr()
            readMesh.write(fileName)
        numSettingDialog(90, "checking converted mesh file...")
        #fileができあがるまで待つ
        count = 10
        while count > 0:
            time.sleep(0.1)
            if os.path.exists(fileName) == True:
                break
            count -= 1
        if os.path.exists(fileName) == False:
            closeSettingDialog()
            title = _(u"エラー")
            mess = _(u"メッシュ変換に失敗しました")
            self.errDialog(title, mess, parent=mainWindow)
            currDir = currDirTemp 
            os.chdir(currDirTemp)
            return
        
        #meshのscale変更
        #f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        #lines = pyFistr.readFistrFileUntilEnd(fileName)
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData_file(fileName)
        xyz = getModelSize()
        closeSettingDialog()
        title = _("scale変更")
        mess  = _("mesh変換したmeshのscaleを変更します。") + ls
        mess += _("  " + xyz)
        mess += _("scaleを入力してください。")
        iniText = "1.0"
        funcOk = [self.meshConvert_changeScaleCreateTempCase,
                  fileName, option, sourceMeshFile, addMesh, keepCond]
        funcCancel = [self.meshConvert_createTempCase,
                  fileName, option, sourceMeshFile, addMesh, keepCond]
        dialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        dialog.show()
        #currDirを元に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  meshConvert_changeScaleCreateTempCase
    def meshConvert_changeScaleCreateTempCase(self, scale, fileName, option, sourceMeshFile, addMesh, keepCond):
        """ mesh変換後、scale変更とtempCaseを作成する。"""
        global currDir, meshHeaderData
        #sourceMeshのscaleを変更
        showSettingDialog("convert mesh")
        numSettingDialog(20, "changing scale...")
        self.changeSourceMeshScale(fileName, scale)
        #option処理、tempCaseを作成
        self.meshConvert_createTempCase(fileName, option, sourceMeshFile, addMesh, keepCond)
        #currDirを元に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  changeSourMeshScale
    def changeSourceMeshScale(self, fileName, scale):
        """ fileName(mshファイル)のscaleを変更する"""
        global meshHeaderData
        if type(scale) == str:
            scale = float(scale)
        #scaleが「1.0」の場合戻る
        if scale == 1.0:
            return
        #msh座標を修正
        meshHeaderData = pyFistr.changeMeshScale(meshHeaderData, scale)
        #Equationを修正
        meshHeaderData = pyFistr.changeEquationScale(meshHeaderData, scale)
        #書き込み
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        currDir = getCurrDirFromTempFolder()
        fileName = currDir + os.sep + fileName
        f = open(fileName, "w", encoding="utf-8")
        f.writelines(lines)
        f.close()

    #
    #  meshConvert_createTempCase
    def meshConvert_createTempCase(self, fileName, option, sourceMeshFile, addMesh, keepCond):
        """ mesh変換のoptionを処理し、tempCaseを作成する"""
        global meshHeaderData
        global currDir, meshGroup
        if settingDialog.poll() != None:
            showSettingDialog("create FrontISTR mesh")
        #実folderを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        currDirTrue = currDir
        #mesh追加？
        #if self.checkBtn_addMesh.get_active() == True:
        if addMesh == True: 
            numSettingDialog(40, "adding new mesh to current mesh...")
            #変換したmeshを今のメッシュに追加する
            lines = self.addConvertMeshToCurrMesh(fileName)
            meshHeaderData = pyFistr.getHeaderNumData(lines)
            #「変換前に戻す」ボタンを表示
            #self.showReturnMeshButton()
        else:
            numSettingDialog(40, "replacing new mesh...")
            #mesh変換のみ
            #f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
            lines = pyFistr.readFistrFileUntilEnd(fileName)
            pyFistr.writeFistrModelMsh(lines)
            #meshHeaderData = pyFistr.getHeaderNumData(lines)    #self.hideReturnMeshButton()
            os.remove(fileName)
            clearBackupMeshFile()
        #mshファイル内のheaderチェック修正
        meshHeaderData = checkFistrModelMeshFile(meshHeaderData)
        #cntファイルを初期化
        #meshGroupを取得
        parameterList = getMeshParameterList()
        paraNum = getParameterNumber(parameterList)
        meshGroup = createMeshGroup(paraNum)
        #設定をクリアする
        #  cnt, datファイルを初期化
        name = self.textCtrl_useCntFile.get_text()
        copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + name
        shutil.copy(copyFile, currDirTrue + os.sep + FistrModel_cnt)
        shutil.copy(copyFile, currDirTemp + os.sep + FistrModel_cnt)
        #resetと書き込み、meshHeaderData更新、Tree内容もreset
        resetCntMshFile()
        #abaqus2fisr？
        if option == "abaqus2fistr":
            comm = "python3 " + binAppPath + "abaqusinp2fistrcnt.py " + currDir + os.sep + sourceMeshFile
            comm += " " + currDirTrue
            pyFistr.run(currDirTrue).command(comm)

            #lines = readFistrModelMsh()
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
            meshHeaderData = getReturnMeshHeaderData()
            getMeshParameter()          #meshの内容を取得
            self.setControlCont()       #cntFileの内容を取得
            matchControlCont()          #meshとcntFileの整合をとる
            #Tree作成
            makeIniTreeData()

        numSettingDialog(60, "creating temporary case...")
        #tempCaseを作成
        meshHeaderDataSave = meshHeaderData         #headerData保存
        self.pickleDumpHeaderData(meshHeaderData)   # fileに保存
        createTempCaseFromMeshData(currDirTrue, lines, meshHeaderData)
        self.setMeshCont()
        #環境を戻す
        os.chdir(currDirTemp)
        currDir = currDirTemp
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        meshHeaderDataTemp = meshHeaderData
        #並列処理checkを外す
        self.checkBtn_solvePara.set_active(False)
        fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
        if os.path.exists(fileName) == True:
            os.remove(fileName)
        #cntファイルをsingleCore用に修正
        setSingleHcmwCtrlDat()
        #TreeDataを作成（mesh変換時initialDataを再設定）
        addInitempGroupInTreeData(initempDefine)
        #解析の種類以下のtreeDataを削除
        if type(treeSolution[0]) == list:
            treeSolution[0] = treeSolution[0][0]
        #treeDataを作成
        makeTreeData()
        #treeを作成
        self.setIniTreeData()
        treeList = [_(u"FistrModel.msh")]
        self.showTreeData(treeList)
        #set内容をistrDataに書き込み
        addM = "no"
        keepC = "no"
        if addMesh == True:
            addM = "yes"
        if keepCond == True:
            keepC = "yes"
        istrData = ["convertOpt "+option, "sourceMesh "+sourceMeshFile,
                    "addMesh " + addM, "keepCond " + keepC]
        saveIstrData(istrData)
        #easyIsreSub_dataを実folderにコピーする。
        fileName = currDir + os.sep + istrSubDataFileName
        shutil.copy(fileName, currDirTrue)
        closeSettingDialog()

        #vtkModelを表示
        #  vtkMeshdataを削除する
        meshHeaderData = meshHeaderDataSave         #headerData復帰
        vtkFolder = currDirTrue + os.sep + self.vtkFolder
        if os.path.exists(vtkFolder):
            shutil.rmtree(currDirTrue + os.sep + self.vtkFolder)
        #  vtk表示
        if self.showModel == True:
            self.recreateVtk = "yes"
            #self.setVtkModel()
            self.reloadVtkMesh()    #時間制限なしのvtk作成、読み込み
        #createGrpPageを初期化
        self.initCreateNgrpSgrpPage()
        #set341elm_selectiveの設定
        self.set341elm_setCheckBox()
        #sourceMesh名を修正
        self.setSourceMeshFileToLabel()
        #終了メッセージ
        self.showCompleteNewMesh()
        meshHeaderData = meshHeaderDataTemp

    #
    #addConvertMeshToCurrMesh
    def addConvertMeshToCurrMesh(self, fileName):
        """ 変換したメッシュ（fileName）を現在のメッシュに追加する"""
        
        def getNewName(name, grps):
            i = 0
            newName = name
            while newName in grps:
                i += 1
                newName = name + "_" + str(i)
            return newName

        def getAllGrps(meshHeaderData):
            egrps, sgrps, ngrps = [], [], []
            for header, data in meshHeaderData:
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!NODE":
                    name = pyFistr.getValName(header, "NGRP")
                    if name != "":
                        ngrps.append(name)
                elif words[0] == "!NGROUP":
                    name = pyFistr.getValName(header, "NGRP")
                    ngrps.append(name)
                elif words[0] == "!ELEMENT":
                    name = pyFistr.getValName(header, "EGRP")
                    if name != "":
                        egrps.append(name)
                elif words[0] == "!EGROUP":
                    name = pyFistr.getValName(header, "EGRP")
                    egrps.append(name)
                elif words[0] == "!SGROUP":
                    name = pyFistr.getValName(header, "SGRP")
                    sgrps.append(name)
            return [egrps, sgrps, ngrps]

        def getAllElmTypes(meshHeaderData):
            elmTypesSet = set([])
            for header, data in meshHeaderData:
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!ELEMENT":
                    elmType = pyFistr.getValName(header, "TYPE")
                    elmTypesSet.add(elmType)
            return elmTypesSet

        def getElmSectionType(header):
            "elmの区分(solid, shell, beam)を返す"
            elmType = pyFistr.getValName(header, "TYPE")
            elmSec = abaqus2fistr.elementContsDict[elmType][0]
            return elmSec

        def checkCorrectElmType(newMeshHeaderData, meshHeaderData):
            """ 要素typeをチェック修正する"""
            newElmTypesSet = getAllElmTypes(newMeshHeaderData)
            elmTypesSet = getAllElmTypes(meshHeaderData)
            if (newElmTypesSet == elmTypesSet):
                return newMeshHeaderData, meshHeaderData
            elif (("731" in newElmTypesSet or "741" in newElmTypesSet) and
                  ("731" in elmTypesSet or "741" in elmTypesSet)):
                return newMeshHeaderData, meshHeaderData
            #meshHeaderDataをチェック
            if "611" in elmTypesSet:
                meshHeaderData = beam611To641.convert(meshHeaderData)
            elif "731" in elmTypesSet:
                meshHeaderData = shell731To761.convert(meshHeaderData)
            elif "741" in elmTypesSet:
                meshHeaderData = shell741To781.convert(meshHeaderData)
            #newMeshHeaderDataをチェック
            if "611" in newElmTypesSet:
                newMeshHeaderData = beam611To641.convert(newMeshHeaderData)
            elif "731" in newElmTypesSet:
                newMeshHeaderData = shell731To761.convert(newMeshHeaderData)
            elif "741" in newElmTypesSet:
                newMeshHeaderData = shell741To781.convert(newMeshHeaderData)
            return newMeshHeaderData, meshHeaderData

        def renumberingNodeElement(newMeshHeaderData, meshHeaderData):
            """ nodeNo, elementNoをrenumberingする。
            grp名が重ならないように修正する。"""
            #maxNoを取得
            maxNodeNo = 0
            maxElmNo = 0
            for header, data in meshHeaderData:
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!NODE":
                    nodeNos = list(map(lambda x: x[0], data))
                    maxNodeNo = max(max(nodeNos), maxNodeNo)
                elif words[0] == "!ELEMENT":
                    elmNos = list(map(lambda x: x[0], data))
                    maxElmNo = max(max(elmNos), maxElmNo)
            #現在のgrp名を取得
            egrps, sgrps, ngrps = getAllGrps(meshHeaderData)
            #nodeNo, elementNoを修正
            for i in range(len(newMeshHeaderData)):
                header = newMeshHeaderData[i][0]
                data = newMeshHeaderData[i][1]
                words = pyFistr.deleteSp(header).split(",")
                #nodeNoを修正
                if words[0] == "!NODE":
                    for ii in range(len(data)):
                        nodeData = data[ii]
                        nodeData[0] += maxNodeNo
                        data[ii] = nodeData
                    newMeshHeaderData[i][1] = data
                    #grpNameをチェック
                    name = pyFistr.getValName(header, "NGRP")
                    if name != "":
                        if name in ngrps:
                            newName = getNewName(name, ngrps)
                            header = pyFistr.setValName(header, "NGRP="+newName)
                            newMeshHeaderData[i][0] = header
                elif words[0] == "!NGROUP":
                    newData = list(map(lambda x: x + maxNodeNo, data))
                    newMeshHeaderData[i][1] = newData
                    #grpNameをチェック
                    name = pyFistr.getValName(header, "NGRP")
                    if name in ngrps:
                        newName = getNewName(name, ngrps)
                        header = pyFistr.setValName(header, "NGRP="+newName)
                        newMeshHeaderData[i][0] = header
                #elementNoを修正
                elif words[0] == "!ELEMENT":
                    for ii in range(len(data)):
                        elmData = newMeshHeaderData[i][1][ii]
                        elmData[0] += maxElmNo
                        newNodes = list(map(lambda x: x + maxNodeNo, elmData[1:]))
                        newMeshHeaderData[i][1][ii] = [elmData[0]] + newNodes
                    #grpNameをチェック
                    name = pyFistr.getValName(header, "EGRP")
                    if name != "":
                        if name in egrps:
                            newName = getNewName(name, egrps)
                            header = pyFistr.setValName(header, "EGRP="+newName)
                            newMeshHeaderData[i][0] = header
                elif words[0] == "!SGROUP":
                    for ii in range(0, len(data), 2):
                        newMeshHeaderData[i][1][ii] += maxElmNo
                    #grpNameをチェック
                    name = pyFistr.getValName(header, "SGRP")
                    if name in sgrps:
                        newName = getNewName(name, sgrps)
                        header = pyFistr.setValName(header, "SGRP="+newName)
                        newMeshHeaderData[i][0] = header
                elif words[0] == "!EGROUP":
                    newData = list(map(lambda x: x + maxElmNo, data))
                    newMeshHeaderData[i][1] = newData
                    #grpNameをチェック
                    name = pyFistr.getValName(header, "EGRP")
                    if name in egrps:
                        newName = getNewName(name, egrps)
                        header = pyFistr.setValName(header, "EGRP="+newName)
                        newMeshHeaderData[i][0] = header
            return newMeshHeaderData

        def addNodeHeader(headerData, meshHeaderData):
            flag = 0
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!NODE":
                    flag = 1
                else:
                    if flag == 1:
                        sp = i
                        break
            meshHeaderData = meshHeaderData[:sp] + [headerData] + meshHeaderData[sp:]
            return meshHeaderData

        def addElementHeader(headerData, meshHeaderData):
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!ELEMENT":
                    sp = i + 1
            #最後の!ELEMENTに追加する
            meshHeaderData = meshHeaderData[:sp] + [headerData] + meshHeaderData[sp:]
            return meshHeaderData

        def addSectionHeader(headerData, meshHeaderData):
            solidSections = []
            beamSections = []
            shellSections = []
            newHeaderData = []
            for header, data in meshHeaderData + [headerData]:
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!SECTION":
                    #sectionを取得
                    secType = pyFistr.getValName(header, "TYPE")
                    if secType == "SHELL":
                        shellSections.append([header, data])
                    elif secType == "BEAM":
                        beamSections.append([header, data])
                    else:
                        solidSections.append([header, data])
                else:
                    #sectionを削除したlistを作成
                    newHeaderData.append([header, data])
            #sectionsを並べ替え
            newSections = solidSections + beamSections + shellSections
            #sectionを挿入
            for i in range(len(newHeaderData)):
                header = newHeaderData[i][0]
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!ELEMENT":
                    sp = i + 1
            newHeaderData = newHeaderData[:sp] + newSections + newHeaderData[sp:]
            return newHeaderData

        def addEgroupHeader(headerData, meshHeaderData):
            flag = 0
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!EGROUP":
                    flag = 1
                elif words[0] == "!SGROUP" or words[0] == "!NGROUP" or words[0] == "!END":
                    sp = i
                    break
                else:
                    if flag == 1:
                        sp = i
                        break
            meshHeaderData = meshHeaderData[:sp] + [headerData] + meshHeaderData[sp:]
            return meshHeaderData

        def addSgroupHeader(headerData, meshHeaderData):
            flag = 0
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!SGROUP":
                    flag = 1
                elif words[0] == "!NGROUP" or words[0] == "!END":
                    sp = i
                    break
                else:
                    if flag == 1:
                        sp = i
                        break
            meshHeaderData = meshHeaderData[:sp] + [headerData] + meshHeaderData[sp:]
            return meshHeaderData

        def addNgroupHeader(headerData, meshHeaderData):
            flag = 0
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = pyFistr.deleteSp(header).split(",")
                if words[0] == "!NGROUP":
                    flag = 1
                elif words[0] == "!END":
                    sp = i
                    break
                else:
                    if flag == 1:
                        sp = i
                        break
            meshHeaderData = meshHeaderData[:sp] + [headerData] + meshHeaderData[sp:]
            return meshHeaderData

        headerMsh = pyFistr.getHeaderName(FistrModel_msh)
        headerCnt = pyFistr.getHeaderName(FistrModel_cnt)
        #現行のmsh,cntファイルのbackupを作成
        shutil.copy(FistrModel_msh, headerMsh + "-bak.msh")
        shutil.copy(FistrModel_cnt, headerCnt + "-bak.cnt")
        #現行mshファイル, newMeshファイルを読み込み
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        #f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        #lines = pyFistr.readFistrFileUntilEnd(fileName)
        #newMeshHeaderData = pyFistr.getHeaderNumData(lines)
        newMeshHeaderData = getReturnMeshHeaderData_file(fileName)
        os.remove(fileName)
        #要素typeをチェック
        newMeshHeaderData, meshHeaderData = checkCorrectElmType(newMeshHeaderData, meshHeaderData)
        #newMeshのrenumbering（nodeNo, elmNo）
        newMeshHeaderData = renumberingNodeElement(newMeshHeaderData, meshHeaderData)
        #parts毎に追加する
        for header, data in newMeshHeaderData:
            words = pyFistr.deleteSp(header).split(",")
            headerData = [header, data]
            if words[0] == "!NODE":
                meshHeaderData = addNodeHeader(headerData, meshHeaderData)
            elif words[0] == "!ELEMENT":
                meshHeaderData = addElementHeader(headerData, meshHeaderData)
            elif words[0] == "!SECTION":
                meshHeaderData = addSectionHeader(headerData, meshHeaderData)
            elif words[0] == "!EGROUP":
                meshHeaderData = addEgroupHeader(headerData, meshHeaderData)
            elif words[0] == "!SGROUP":
                meshHeaderData = addSgroupHeader(headerData, meshHeaderData)
            elif words[0] == "!NGROUP":
                meshHeaderData = addNgroupHeader(headerData, meshHeaderData)
        #保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        pyFistr.writeFistrModelMsh(lines)
        return lines

    #
    #  meshConvertKeepSetting
    #--------------------------
    def meshConvertKeepSetting(self, sourceMeshFile, option, addMesh):
        """ 設定を保持したままmesh変換"""
        #mesh変換（設定保持で）-----------
        global meshHeaderData, matDefine
        global currDir, meshGroup
        keepCond = True
        showSettingDialog("converting mesh file")
        #mshTempファイル内の設定を取得
        remHeaders = []
        matHeaders = []
        checkHeaders = ["!CONTACTPAIR", "!INITIALCONDITION", "!AMPLITUDE",
                        "!CONTACT PAIR", "!INITIAL CONDITION"]
        checkMatHeaders = ["!SECTION", "!MATERIAL", "!ITEM=1", "!ITEM=2", "!ITEM=3"]
        #lines = readFistrModelMsh()
        #headerNumData = pyFistr.getHeaderNumData(lines)
        headerNumData = getReturnMeshHeaderData()
        for headerData in headerNumData:
            header = headerData[0]
            headerName = deleteSp(header).split(",")[0]
            if headerName in checkHeaders:
                remHeaders.append(headerData)
            elif headerName in checkMatHeaders:
                matHeaders.append(headerData)
        headerNumData = []
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        currDirTrue = currDir
        #cnt, dat, mshファイル有無チェック
        self.checkCntMshFile()

        #mesh変換fileが存在する場合は削除
        name = os.path.basename(sourceMeshFile)
        fileName = ".".join(name.split(".")[:-1]) + "_fistr.msh"
        #fileName = ".".join(sourceMeshFile.split(".")[:-1]) + "_fistr.msh"
        if os.path.exists(fileName) == True:
            os.remove(fileName)
        #mesh変換前にcntファイルを最新版で保存
        copyCntFromTempToCurrDir()
        #mesh変換
        meshFile = os.path.normpath(currDir + os.sep + sourceMeshFile)
        if option == "unv2fistr":
            numSettingDialog(20, "converting unv mesh file...")
            #option = "unv2fistr"
            comm = "python3 " + binAppPath + "unv2fistr.py " + meshFile
            comm += " " + fileName
            pyFistr.run(currDir).command(comm)
        elif option == "abaqus2fistr":
            numSettingDialog(20, "converting abaqus mesh file...")
            #option = "abaqus2fistr"
            comm = "python3 " + binAppPath + "abaqus2fistr.py " + meshFile
            comm += " " + fileName
            pyFistr.run(currDir).command(comm)
        elif option[:len("read")] == "read":
            format = option[len("read"):].lower()
            numSettingDialog(20, "converting " + format + " mesh at meshio...")
            #meshFile = currDir + os.sep + sourceMeshFile
            readMesh = meshOp.read(meshFile, format)
            headerData = readMesh.meshio2fistr()
            readMesh.write(fileName)

        numSettingDialog(90, "checking converted mesh file...")
        #fileが出来上がるまで待つ
        count = 10
        while count > 0:
            time.sleep(0.1)
            if os.path.exists(fileName) == True:
                break
            count -= 1
        #  errorチェック
        #if len(glob.glob(fileName)) == 0:
        if os.path.exists(fileName) == False:
            closeSettingDialog()
            title = _(u"エラー")
            mess = _(u"メッシュ変換に失敗しました")
            self.errDialog(title, mess, parent=mainWindow)
            currDir = currDirTemp
            os.chdir(currDirTemp)
            return

        #meshのscale変更
        #f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        #lines = pyFistr.readFistrFileUntilEnd(fileName)
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData_file(fileName)
        xyz = getModelSize()
        closeSettingDialog()
        title = _("scale変更")
        mess  = _("mesh変換したmeshのscaleを変更します。") + ls
        mess += _("  " + xyz)
        mess += _("scaleを入力してください。")
        iniText = "1.0"
        funcOk = [self.meshConvertKeep_changeScaleCreateTempCase,
                  fileName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond]
        funcCancel = [self.meshConvertKeep_createTempCase,
                  fileName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond]
        dialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        dialog.show()
        #currDirを元に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  meshConvertKeep_changeScaleCreateTempCase
    def meshConvertKeep_changeScaleCreateTempCase(
            self, scale, fileName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond):
        """ mesh変換後、scale変更とtempCaseを作成する。"""
        global currDir, meshHeaderData
        showSettingDialog("create/convert mesh")
        numSettingDialog(20, "changing scale...")
        #sourceMeshのscaleを変更
        self.changeSourceMeshScale(fileName, scale)
        #option処理、tempCaseを作成
        self.meshConvertKeep_createTempCase(
            fileName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond)
        #currDirを元に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  meshConvertKeep_createTempCase
    def meshConvertKeep_createTempCase(
            self, fileName, sourceMeshFile, option, remHeaders, matHeaders, addMesh, keepCond):
        """ 設定を保持した状態で、mesh変換のoptionを処理し、tempCaseを作成する"""

        def getSectionHeader(matHeaders, typeName, egrpName):
            """ matHeaders内からtype、egrpが同じsectionを取得する"""
            headers = []
            for i in range(len(matHeaders)):
                header = matHeaders[i][0]
                words = deleteSp(header).split(",")
                if words[0] == "!SECTION":
                    tName = pyFistr.getValName(header, "TYPE")
                    eName = pyFistr.getValName(header, "EGRP")
                    if tName == typeName and eName == egrpName:
                        headers = matHeaders[i]
                        break
            return headers

        def addMaterialHeaders(meshHeaderData, addMatHeaders):
            """ meshHeaderDataにMaterialHeaderを挿入する"""
            si = -1
            matHeader = addMatHeaders[0][0]
            matName = pyFistr.getValName(matHeader, "NAME")
            for i in range(len(meshHeaderData)):
                header = meshHeaderData[i][0]
                header = deleteSp(header)
                words = header.split(",")
                if words[0] == "!SECTION":
                    mName = pyFistr.getValName(header, "MATERIAL")
                    if mName == matName:
                        si = i
                        break
            if si >= 0:
                meshHeaderData = meshHeaderData[:si] + addMatHeaders + meshHeaderData[si:]
            return meshHeaderData
        
        #---- 設定を保持したままmesh変換------
        global meshHeaderData
        global currDir
        #元のcurrDirを取得
        if settingDialog.poll() != None:
            showSettingDialog("create/convert mesh")
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        currDirTrue = currDir
        #mesh追加？
        if addMesh == True:
            #変換したmeshを今のメッシュに追加する
            numSettingDialog(40, "adding new mesh to current mesh...")
            lines = self.addConvertMeshToCurrMesh(fileName)
            meshHeaderData = pyFistr.getHeaderNumData(lines)
        else:
            #mesh変換のみ
            numSettingDialog(40, "replacing new mesh...")
            #f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
            lines = pyFistr.readFistrFileUntilEnd(fileName)
            pyFistr.writeFistrModelMsh(lines)
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
            os.remove(fileName)
            clearBackupMeshFile()

        #mshファイル内のheaderチェック修正
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = checkFistrModelMeshFile(meshHeaderData)
        #tempCaseを作成
        meshHeaderDataSave = meshHeaderData         #headerData保存
        self.pickleDumpHeaderData(meshHeaderData)   # fileに保存
        createTempCaseFromMeshData(currDir, lines, meshHeaderData)
        self.setMeshCont()
        numSettingDialog(60, "creating temporary case...")
        #環境を戻す
        os.chdir(currDirTemp)
        currDir = currDirTemp
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        #meshHeaderDataTemp = meshHeaderData
        #mshTempファイル内の設定を戻す
        #  remHeadersを戻す(contactPair, amplitude, initialCondition)
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!END":
                si = i
                break
        meshHeaderData = meshHeaderData[:si] + remHeaders + meshHeaderData[si:]
        #  !SECTIONを入れ替え
        for i in range(len(meshHeaderData)):
            header = meshHeaderData[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!SECTION":
                typeName = pyFistr.getValName(header, "TYPE")
                egrpName = pyFistr.getValName(header, "EGRP")
                newHeaderData = getSectionHeader(matHeaders, typeName, egrpName)
                if len(newHeaderData) > 0: 
                    meshHeaderData[i] = newHeaderData
        #  !MATERIALを挿入
        for i in range(len(matHeaders)):
            header = matHeaders[i][0]
            words = deleteSp(header).split(",")
            if words[0] == "!MATERIAL":
                addHeaders = [matHeaders[i]]
                #項目数を取得
                nItems = pyFistr.getValName(header, "ITEM")
                #項目の値を取得
                for ii in range(int(nItems)):
                    addHeaders.append(matHeaders[i+ii+1])
                meshHeaderData = addMaterialHeaders(meshHeaderData, addHeaders)
        #meshHeaderDataを保存
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #並列処理checkを外す
        self.checkBtn_solvePara.set_active(False)
        fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
        if os.path.exists(fileName) == True:
            os.remove(fileName)
        #cnt, mshの整合性をとる
        matchControlCont()
        cntLines = readFistrModelCnt()
        remakeDefineMaterial(cntLines)
        #TreeDataを作成（mesh変換時initialDataを再設定）
        makeIniTreeData()
        #treeを作成
        self.setIniTreeData()
        treeList = [_(u"FistrModel.msh")]
        self.showTreeData(treeList)
        #set内容をistrDataに書き込み
        addM = "no"
        keepC = "no"
        if addMesh == True:
            addM = "yes"
        if keepCond == True:
            keepC = "yes"
        istrData = ["convertOpt "+option, "sourceMesh "+sourceMeshFile,
                    "addMesh "+addM, "keepCond "+keepC]
        saveIstrData(istrData)
        #easyIsreSub_dataを実folderにコピーする。
        fileName = currDir + os.sep + istrSubDataFileName
        shutil.copy(fileName, currDirTrue)
        closeSettingDialog()

        #vtkModelを表示
        #  vtkMeshdataを削除する
        mehsHeaderData = meshHeaderDataSave     #headerData復帰
        vtkFolder = currDirTrue + os.sep + self.vtkFolder
        if os.path.exists(vtkFolder):
            shutil.rmtree(currDirTrue + os.sep + self.vtkFolder)
        #  vtk表示
        if self.showModel == True:
            self.recreateVtk = "yes"
            #self.setVtkModel()
            self.reloadVtkMesh()    #時間制限なしのvtk作成、読み込み
        #createGrpPageを初期化
        self.initCreateNgrpSgrpPage()
        #sourceMesh名を設定
        self.setSourceMeshFileToLabel()
        #終了メッセージ
        self.showCompleteNewMesh()
        #meshHeaderDataをtempに戻す
        #meshHeaderData = meshHeaderDataTemp
        meshHeaderData = getReturnMeshHeaderData()


    #
    #  changeUnit
    #-------------
    def changeUnit(self):
        """ 単位の変更"""

        def changeAnyUnit_onDlg(selDim, dim, path, item):
            #pageをチェック
            self.showThisPageIfNotShow(path, item)
            #dimを設定
            self.changeUnitProcess(selDim, dim)    

        dim, matFile = getDimensionMatFileFromIstrData()
        selDim = self.comboBox_dimension.getSelectedItem()
        if dim == selDim:
            return
        #任意の単位を選択？
        if selDim != _("(任意)"):
            self.changeUnitProcess(selDim, dim)
            return
        #任意を選択した時
        funcName = changeAnyUnit_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [path, item]
        dialog = createNewDimensionDDialog.createNewDimension(dim, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #
    #  changeUnitProcess
    def changeUnitProcess(self, selDim, dim):
        global currDir, currDirTemp
        """ 単位をselDimに変更する。"""
        global istrData
        if selDim == "":
            #元の単位に戻す
            self.comboBox_dimension.selectItem(dim)
            return
        #単位を変更
        saveIstrData(["dimension " + selDim])
        if currDir == currDirTemp:
            copyFile = currDir + os.sep + istrSubDataFileName
            pasteDir = getCurrDirFromTempFolder()
            shutil.copy(copyFile, pasteDir)
        istrData = getSavedData()
        self.checkDimensionMatCsv()
        #変換後のmessageを表示
        title = _("単位の変更")
        mess = _("単位を「") + selDim + _("」に変更しました。") + "\n"
        mess += _("材料DB内の物性値を変換しました。") + "\n"
        mess += _("メッシュサイズ、境界条件等を「") + selDim + _("」に合わせてください。")
        print(mess)
        self.okDialog(title, mess, parent=mainWindow)
        #単位をcomboに再設定
        self.setComboDimension()
        #単位をtitleに表示
        self.setUnitToTitle()

    #
    #  changeMeshScale
    #  ---------------
    #    meshのスケールを変更
    def changeMeshScale(self, event):
        #!EQUATIONをチェック後、scale変更する。
        self.checkEquationChangeScale()

    #
    #  changeMeshScaleWithEquation
    def changeMeshScaleWithEquation(self, flag):
        """ flagに応じてmeshのscaleを変更する。
        flag=0:Equationは、そのまま。
        flag=1:Equationのscaleも変更する。"""
        global currDir, meshHeaderData
        #scaleを取得
        a = self.textCtrl_meshScale.get_text()
        try:
            scale = float(a)
        except:
            title = _(u"エラー")
            mess = _(u"倍率は、数字を入力してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #tempのmeshHeaderDataを取得
        currDir = currDirTemp
        tempMeshHeaderData = getReturnMeshHeaderData()
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #dialog表示
        showSettingDialog("change scale")
        numSettingDialog(20, "reading mesh data...")
        #msh, cntファイルを転送
        precopyCntFromTempToCurrDir()
        #copyMshFromTempToCurrDir()
        #copyCntFromTempToCurrDir()
        meshHeaderData = createHeaderDataFromTemp(numFlag=True)
        #scale変更
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        #meshHeaderData = getReturnMeshHeaderData()
        numSettingDialog(50, "changing scale...")
        meshHeaderData = pyFistr.changeMeshScale(meshHeaderData, scale)
        if flag == 1:
            #equationのscaleを変更する
            meshHeaderData = pyFistr.changeEquationScale(meshHeaderData, scale)
        numSettingDialog(90, "writing mesh file...")
        #書き込み
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        self.pickleDumpHeaderData(meshHeaderData)
        numSettingDialog(95, "setting mesh contents...")
        #tempCase作成（tempcaseDateは更新せず）
        createTempCaseFromOnlyMeshData(currDir, lines, meshHeaderData)
        #createTempCaseFromMeshData(currDir, lines, meshHeaderData)        
        #meshContをlabelに書き込み
        self.setMeshCont()
        closeSettingDialog()
        #環境をtempに戻して、temp側のscaleを設定
        currDir = currDirTemp
        os.chdir(currDirTemp)
        getMeshHeaderData()
        #終了メッセージ
        self.showFinishChangeScale(a)
        return

        # #  scaleを設定
        # meshHeaderData = pyFistr.changeMeshScale(tempMeshHeaderData, scale)
        # if flag == 1:
        #     #equationのscaleを変更する
        #     meshHeaderData = pyFistr.changeEquationScale(meshHeaderData, scale)
        # #  書き込み
        # lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        # writeFistrModelMsh(lines)
        # #  meshContsのscaleを変更
        # meshContDict = getMeshContsFromTempFolder()
        # meshCont = meshContDict["meshCont"]
        # lines = meshCont.split("\n")
        # words = lines[0].split()
        # modelSize = list(map(float, words[1:]))
        # modelSize = list(map(lambda x: x*scale, modelSize))
        # x = pyFistr.float2strAuto(modelSize[0], prec=3)
        # y = pyFistr.float2strAuto(modelSize[1], prec=3)
        # z = pyFistr.float2strAuto(modelSize[2], prec=3)
        # lines[0] = " ".join([words[0], x,y,z])
        # meshCont = "\n".join(lines)
        # meshContDict["meshCont"] = meshCont
        # copyTempFiles.saveCaseContDict(meshContDict)
        # #  meshContをlabelに書き込み
        # self.setMeshCont()
        # #lines = readFistrModelMsh()
        # #meshHeaderData = pyFistr.getHeaderNumData(lines)
        # #終了メッセージ
        # self.showFinishChangeScale(a)

    #  showFinishChangeScale
    def showFinishChangeScale(self, scale):
        """ scale変更の終了メッセージを出力する"""
        if type(scale) != str:
            scale = str(scale)
        mess = _(u"meshのスケールを変更しました") + ls + _(u"  倍率: ") + scale
        print (mess)
        title = _(u"スケールの変更")
        self.okDialog(title, mess, parent=mainWindow)
        self.textCtrl_meshScale.set_text("1.0")

    #
    #  checkEquationChangeScale
    def checkEquationChangeScale(self):
        """ meshファイル内に!EQUATIONがあるか確認し、
        ある場合は、EQUATION内の値も倍率を変更するか確認し、scale変更する"""
        flag = 0
        lines = readFistrModelMsh()
        headerConts = pyFistr.getHeaderData(lines)
        for headerCont in headerConts:
            if headerCont[0][:len("!EQUATION")] == "!EQUATION":
                dataLines = headerCont[1]
                words = pyFistr.deleteSp(dataLines[0]).split(",")
                if words == ["4", "0.0"]:
                    if len(pyFistr.deleteSp(dataLines[1]).split(",")) == 12:
                        flag = 1
                        break
        if flag == 1:
            #yesNoDialogでEquationもscale変更するか確認
            title = _("!EQUATION のscale変更")
            mess = _("EQUATION内の値もscale変更しますか？") + ls
            mess += _("mshファイル中に「!EQUATION」が存在します。") + ls
            mess += _("mesh変換時に自動作成されたEQUATIONであれば、scale変更しても問題ありません。")
            funcYes = [self.checkEquationChangeScale_onDlgYes]    #mesh,Equationとも
            funcNo = [self.checkEquationChangeScale_onDlgNo]      #meshのみ
            self.yesNoDialog(title, mess, funcYes, funcNo, parent=mainWindow)
        else:
            #flag=0:meshのみscale変更
            self.changeMeshScaleWithEquation(flag)    

    #
    #  checkEquationChangeScale_onDlgYes
    def checkEquationChangeScale_onDlgYes(self):
        """ mesh, Equationともscale変更"""
        self.changeMeshScaleWithEquation(flag=1)

    #
    #  checkEquationChangeScale_onDlgNo
    def checkEquationChangeScale_onDlgNo(self):
        """ meshのみscale変更"""
        self.changeMeshScaleWithEquation(flag=0)

    #
    #  set341elm_selective
    #----------------------
    def set341elm_selective(self):
        """ 341要素をselective_esns(平滑化要素)に設定"""
        if self.checkBtn_set341elm.get_active() == True:
            #平滑化要素に設定
            self.set341elm_set()
        else:
            #通常の要素
            self.set341elm_clear()

    #
    #  set341elm_set
    def set341elm_set(self):
        """ 341要素をselective_esnsに設定する"""
        #341要素を使っているegrp名を取得　meshContをcheck
        egrp341 = self.getEgrp341Names()
        if len(egrp341) == 0:
            self.set341elm_clear()
            return
        #msh内の!SECTIONの順番を取得
        secNums = []
        num = 1
        for header, data in meshHeaderData:
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!SECTION":
                name = pyFistr.getValName(header, "EGRP")
                if name in egrp341:
                    secNums.append(num)
                num += 1
        #selective_esnsを作成
        selLines = []
        for num in secNums:
            line = "!SECTION, SECNUM=" + str(num) + ", FORM341=SELECTIVE_ESNS\n"
            selLines.append(line)
        #cntLinesからselective_esnsを削除
        cntLines = pyFistr.readFistrModelCnt()
        cntLines = self.set341elm_clearLines(cntLines)
        #selLinesを挿入
        ip = pyFistr.getInsertPointInCnt(cntLines, "!SECTION", ["Analysis Control"])
        cntLines = cntLines[:ip] + selLines + cntLines[ip:]
        #書き込み
        workDir = os.getcwd()
        cntFile, mshFile = pyFistr.cntMshFileName(workDir)
        fileName = workDir + os.sep + cntFile
        f = open(fileName, "w", encoding="utf-8"); f.writelines(cntLines); f.close()
        #part_ctrl.datファイルを修正
        partFile = "hecmw_part_ctrl.dat"
        if os.path.exists(partFile) == True:
            f = open(partFile, encoding="utf-8"); partLines = f.readlines(); f.close()
            i = pyFistr.getNextHeaderName(partLines, 0, "!PARTITION", "")
            partLines[i] = abaqus2fistr.setValName(partLines[i], "DEPTH=2")
            #書き込み
            f = open(partFile, "w", encoding="utf-8"); f.writelines(partLines); f.close()

    #
    #  getEgrp341Names
    def getEgrp341Names(self):
        """ 341要素のegrpNameを取得して返す。"""
        egrp341 = []
        meshCont = self.label_meshCnt.get_text()
        lines = meshCont.split("\n")
        for line in lines:
            words = line.split()
            if len(words) > 3:
                if words[0] == "EGRP":
                    if "341" in words[3:]:
                        egrp341.append(words[1])
        return egrp341

    #
    #  set341elm_clearLines
    def set341elm_clearLines(self, lines):
        """ lines内からselective_esnsを削除して返す"""
        newLines = []
        for i in range(len(lines)):
            line = lines[i]
            if line[0] == "!":
                words = pyFistr.deleteSp(line).split(",")
                if words[0] == "!SECTION":
                    name = pyFistr.getValName(line, "FORM341")
                    if name == "SELECTIVE_ESNS":
                        pass
                    else:
                        newLines.append(line)
                else:
                    newLines.append(line)
            else:
                newLines.append(line)
        return newLines

    #
    #  set341elm_clear
    def set341elm_clear(self):
        """ 341要素を通常の要素に戻す。"""
        #cntファイルから!SECTION,FORM341＝SELECTIVE_ESNSを削除
        lines = pyFistr.readFistrModelCnt()
        lines = self.set341elm_clearLines(lines)
        workDir = os.getcwd()
        cntFile, mshFile = pyFistr.cntMshFileName(workDir)
        fileName = workDir + os.sep + cntFile
        f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()
        #part_ctrl.datファイルを修正
        partFile = "hecmw_part_ctrl.dat"
        if os.path.exists(partFile) == True:
            f = open(partFile, encoding="utf-8"); partLines = f.readlines(); f.close()
            i = pyFistr.getNextHeaderName(partLines, 0, "!PARTITION", "")
            partLines[i] = abaqus2fistr.setValName(partLines[i], "DEPTH=1")
            #書き込み
            f = open(partFile, "w", encoding="utf-8"); f.writelines(partLines); f.close()

    #
    #  set341elm_setCheckBox
    def set341elm_setCheckBox(self):
        """ cntファイル内の!SECTIONを調べ、その結果に応じて、checkBoxの設定を行う。"""
        #341要素を使っているか?
        egrp341 = self.getEgrp341Names()
        if len(egrp341) == 0:
            #341要素無し
            self.checkBtn_set341elm.set_sensitive(False)
        else:
            #341要素あり
            self.checkBtn_set341elm.set_sensitive(True)
        #cntファイル中に!SECTION,FORM341=があるか
        if self.isSet341elm_selective() == False:
            #無し
            self.checkBtn_set341elm.set_active(False)
        else:
            #あり
            if len(egrp341) == 0:
                #341要素無し
                self.set341elm_clear()
                self.checkBtn_set341elm.set_active(False)
            else:
                #341要素あり
                self.checkBtn_set341elm.set_active(True)

    #
    #  isSet341elm_selective
    def isSet341elm_selective(self):
        """ cntファイル内にFORM341=SELECTIVE_ESNSがあるか？"""
        lines = pyFistr.readFistrModelCnt()
        flag = False
        for line in lines:
            if line[:len("!SECTION")] == "!SECTION":
                words = pyFistr.deleteSp(line).split(",")
                if words[0] == "!SECTION":
                    name = pyFistr.getValName(line, "FORM341")
                    if name == "SELECTIVE_ESNS":
                        flag = True
                        break
        return flag 

    #
    #  reformNgrp
    #  ----------
    #    NGRPの修正
    #    重複定義された節点を削除する。
    def reformNgrp(self, event):
        global currDir, meshHeaderData
        #overlapNGRPを取得
        meshConts = getMeshContsFromTempFolder()
        overlapNames = meshConts["overlapNGRP"]
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #修正後のmeshHderDataを取得
        funcName = self.reformNgrp_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [currDir, path, item]
        dialog = deleteOverlapNodesDDialog.deleteOverlapNodes(overlapNames, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return
    
    #  reformNgrp_onDlg
    def reformNgrp_onDlg(self, stat, data, cDir, path, item):
        global currDir, meshHeaderData
        currDir = cDir
        self.showThisPageIfNotShow(path, item)
        if stat == "OK":
            meshHeaderData = data
            lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
            createTempCaseFromOnlyMeshData(currDir, lines, meshHeaderData)
            self.setMeshCont()
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        #vtkを再描画
        currDir = getCurrDirFromTempFolder()
        vtkDir = currDir + os.sep + self.vtkFolder
        if os.path.exists(vtkDir) == True:
            shutil.rmtree(vtkDir)
        self.setVtkModel()

    #
    #  nodesBond
    #-------------
    def nodesBond(self):
        """ 節点結合"""
        global currDir, meshHeaderData
        #現在のgrp名と結合状態を取得
        meshConts = getMeshContsFromTempFolder()["meshCont"]
        bondNN = []
        bondNF = []
        nodeGrps = []
        surGrps = []
        lines = meshConts.split(ls)
        for line in lines:
            words = line.split()
            if len(words) >= 3:
                if words[0] == "bondNN":
                    bondNN.append(words[1:3])
                elif words[0] == "bondNF":
                    bondNF.append(words[1:3])
                elif words[0] == "NGRP":
                    if words[1][:len("dummy")] != "dummy":
                        nodeGrps.append(words[1])
                elif words[0] == "SGRP":
                    surGrps.append(words[1])
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #今の設定を保存する
        copyFilesFromTempToCurrDir()
        #メッシュ情報を取得
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()
        #dialog表示
        funcName = self.nodeBond_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [path, item]
        dialog = nodesFacesBondingDDialog.nodesFacesBonding(nodeGrps, surGrps, bondNN, bondNF, meshHeaderData, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #  nodeBond_onDlg
    def nodeBond_onDlg(self, stat, data, path, item):
        """ 結合の組み合わせを処理して結合する"""
        global currDir, meshHeaderData
        self.showThisPageIfNotShow(path, item)
        if stat == "OK":
            meshHeaderData = data
            lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
            writeFistrModelMsh(lines)
            createTempCaseFromOnlyMeshData(currDir, lines, meshHeaderData)
            self.setMeshCont()
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()

    #
    #  editBeamElements
    #-------------------
    def editBeamElements(self):
        """ beam要素の編集"""
        global currDir, meshHeaderData
        #現在のgrp名と結合状態を取得
        meshConts = getMeshContsFromTempFolder()["meshCont"]
        elmTypesSet = set([])
        lines = meshConts.split(ls)
        for line in lines:
            words = line.split()
            if len(words) > 1:
                if words[0] == "elements":
                    elmType = words[1].split(":")[1]
                    elmTypesSet.add(elmType)
        if len(elmTypesSet & set(["611", "641"])) == 0:
            title = _("エラー")
            mess = _("メッシュ内にbeam要素が含まれていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #今の設定を保存する
        copyFilesFromTempToCurrDir()
        #dialogを開く
        funcName = self.editBeamElements_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [path, item]
        dialog = editBeamElementDDialog.editBeamElement(funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #  editBeamElements_onDlg
    def editBeamElements_onDlg(self, stat, path, item):
        """ dialog「閉じる」選択後の処理"""
        global currDir, meshHeaderData
        self.showThisPageIfNotShow(path, item)
        if stat == "reload":
            lines = readFistrModelMsh()
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
            meshHeaderData = pyFistr.getHeaderNumDataMshLines(lines, currDir)
            createTempCaseFromOnlyMeshData(currDir, lines, meshHeaderData)
            self.setMeshCont()
            self.newReloadVtkMesh()     #vtkDataを作り直す
            #tempの環境に戻す
            currDir = currDirTemp
            os.chdir(currDirTemp)
            #lines = readFistrModelMsh()
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
            meshHeaderData = getReturnMeshHeaderData()
            #cntFileをチェック修正
            self.setControlCont()
            matchControlCont()
            #pageを取得
            (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
            #Tree作成
            makeIniTreeData()
            self.setIniTreeData()
            #pageを表示
            self.setTreeSetPage(expPathes, selPath)
        else:
            #tempの環境に戻す
            currDir = currDirTemp
            os.chdir(currDirTemp)
            #lines = readFistrModelMsh()
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
            meshHeaderData = getReturnMeshHeaderData()

    #
    #  confirmModelAtParaview
    #  ----------------------
    #    メッシュ形状確認
    def confirmModelAtParaview(self, event):
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #vtkファイル取得
        fileHeader = FistrModel_msh.split(".")[0]
        comm = "python3 " + binAppPath + "fistr2vtu.py -mesh " + fileHeader
        print (comm)
        #os.system(comm)
        pyFistr.run(currDir).command(comm)
        comm = runParaViewComm + " conv" + fileHeader + ".msh.vtu"
        pyFistr.run(currDir).commandBG(comm)
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  setSolutionCont
    #  ---------------
    #    solutionの内容をlabelに表示
    def setSolutionCont(self, event):
        anaType = self.getAnaTypeFromComboBox()
        self.setAnaTypeContInLabel(anaType)

    #  getAnaTypeFromComboBox
    #    anaTypeをcomboBoxから取得
    def getAnaTypeFromComboBox(self):
        anaTypeJ = ""
        nIter = self.comboBox_anaType.get_active_iter()
        if nIter != None:
            model = self.comboBox_anaType.get_model()
            anaTypeJ = model[nIter][0]
        i = 0
        for name in analysisTypes():
            if name == anaTypeJ:
                break
            i += 1
        anaTypes = analysisTypesE()         #英語表記のanaTypesを取得
        if i >= len(anaTypes):
            i = 0
        anaType = anaTypes[i]
        return anaType

    #  setAnaTypeContInLabel
    #    anaTypeの出力をlabelに表示
    def setAnaTypeContInLabel(self, anaType):
        label = _(u"入出力ファイル") + ls
        if anaType == "STATIC":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  出力:FistrModel.res")
        elif anaType == "NLSTATIC":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  出力:FistrModel.res")
        elif anaType == "DYNAMIC":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  出力:FistrModel.res")
        elif anaType == "EIGEN":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  出力:FistrModel_eigen.res")
        elif anaType == "DYNAMIC_F":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  入力:FistrModel_eigen.res") + ls
            label += _(u"  出力:FistrModel.res") + ls
            label += _(u"  出力:FistrModel_dyna.res")
        elif anaType == "HEAT":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  出力:FistrModel_temp.res")
        elif anaType == "HEAT_D":
            label += _(u"  入力:") + FistrModel_msh + ls
            label += _(u"  入力:") + FistrModel_cnt + ls
            label += _(u"  出力:FistrModel_temp.res")
        self.label_soluCont.set_label(label)

    #
    #  applySolutionType
    #  -----------------
    #    solutionTypeを設定
    def applySolutionType(self, event):
        global anaType, settingDialog, FistrModel_msh
        #solutionTypeを設定
        orgAnaType = getSolutitionTypeFromCnt()
        anaType = self.getAnaTypeFromComboBox()
        if anaType == orgAnaType:
            #設定が変わっていない場合は、clearButtonのみ
            print(_("解析の種類は、現在の設定のままです。"))
            self.clearButtonLabel()
        else:
            #cntの内容を修正する
            lines = readFistrModelCnt()
            lines = pyFistr.deleteHeaderName(lines, 0, "!EIGENREAD", "")
            i = pyFistr.getNextHeaderName(lines, 0, "!SOLUTION", "")
            realAnaType = anaType
            if anaType == "DYNAMIC_F":
                realAnaType = "DYNAMIC"
            elif anaType == "HEAT_D":
                realAnaType = "HEAT"
            lines[i] = abaqus2fistr.setValName(lines[i], "TYPE="+realAnaType)
            lines[i+1] = "!" + realAnaType + ls
            [lines, i] = pyFistr.deleteOnlyDataInLines(lines, i+2)
            #  初期値の設定
            if anaType == "DYNAMIC":
                values = defaultDynamicSolutionCont()
                addLines =  [", ".join(values[:2]) + ls]
                addLines += [", ".join(values[2:6]) + ls]
                addLines += [", ".join(values[6:8]) + ls]
                addLines += [", ".join(values[8:12]) + ls]
                addLines += [", ".join(values[12:15]) + ls]
                addLines += [", ".join(values[15:21]) + ls]
                lines = lines[:i] + addLines + lines[i:]
            elif anaType == "DYNAMIC_F":
                values = defaultFreqResponseSolutionCont()
                addLines =  [", ".join(values[:2]) + ls]
                addLines += [", ".join(values[2:6]) + ls]
                addLines += [", ".join(values[6:8]) + ls]
                addLines += [", ".join(values[8:12]) + ls]
                addLines += [", ".join(values[12:15]) + ls]
                addLines += [", ".join(values[15:21]) + ls]
                addLines += ["!EIGENREAD" + ls]
                addLines += ["eigen_log" + ls]
                addLines += ["1, 5" + ls]
                lines = lines[:i] + addLines + lines[i:]
            elif anaType == "EIGEN":
                values = defaultEigenSolutionCont()
                addLines = [", ".join(values) + ls]
                lines = lines[:i] + addLines + lines[i:]
            elif anaType == "HEAT":
                values = defaultHeatSolutionCont()
                addLines = [", ".join(values) + ls]
                lines = lines[:i] + addLines + lines[i:]
            elif anaType == "HEAT_D":
                values = defaultDynamicHeatSolutionCont()
                addLines = [", ".join(values) + ls]
                lines = lines[:i] + addLines + lines[i:]
            writeFistrModelCnt(lines)
            #hecmw_ctrlの内容を修正する
            resName = FistrModelDict["res"]
            header = pyFistr.getHeaderName(resName)
            headerName = header.split("_")[0]
            lines = readHecmwCtrlDat()
            i = pyFistr.getNextHeaderName(lines, 0, "!RESULT", "NAME=fstrRES")
            i += 1
            if anaType == "EIGEN":
                #固有値解析の場合、出力file名を変える
                lines[i] = headerName + "_eigen.res" + ls
                lines = deleteFstrDynaResultIn(lines)
            elif anaType == "DYNAMIC_F":
                lines[i] = headerName + ".res" + ls
                lines = addFstrDynaResultIn(lines)
            elif anaType == "HEAT" or anaType == "HEAT_D":
                #熱解析の場合、出力file名を変える
                lines[i] = headerName + "_temp.res" + ls
                lines = deleteFstrDynaResultIn(lines)
            else:
                #上記以外の場合は、そのまま
                lines[i] = headerName + ".res" + ls
                lines = deleteFstrDynaResultIn(lines)
            writeHecmwCtrlDat(lines)
            #Treeを再設定
            global treeSolution
            if (anaType == "DYNAMIC" or anaType == "DYNAMIC_F"
                    or anaType == "EIGEN" or anaType == "HEAT_D"):
                treeSolution = self.createSpecialAnaTypeTree(
                                treeSolution, anaType)
                makeTreeData()
                treeList = [_(u"解析の種類")]
                #addTreeItemsSetにitemを追加
                treeTuple = tuple(treeList + treeSolution[0][1])
                self.addTreeItemsSet.add(treeTuple)
                #tree表示
                self.showTreeData(treeList)
            else:
                if type(treeSolution[0]) == list:
                    treeSolution = [treeSolution[0][0]]
                    makeTreeData()
                    treeList = [_(u"解析の種類")]
                    self.showTreeData(treeList)
                #addTreeItemsSetから削除
                items = list(self.addTreeItemsSet)
                for item in items:
                    if item[0] == _("解析の種類"):
                        self.addTreeItemsSet.remove(item)
                        break
        
        #treeの文字色を設定
        nIter = self.comboBox_anaType.get_active_iter()
        model = self.comboBox_anaType.get_model()
        anaTypeJ = model[nIter][0]
        self.setTreeFontColour(anaType)
        print (_(u"解析の種類を「") + anaTypeJ + ":" + anaType + _(u"」に変更しました。")) 
        #flagを設定
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  createSpecialAnaTypeTree
    def createSpecialAnaTypeTree(self, treeSolution, anaType):
        itemDict = {
            "DYNAMIC":  _("動解析_設定"),
            "DYNAMIC_F":_("周波数応答_設定"),
            "EIGEN":    _("固有値解析_設定"),
            "HEAT_D":   _("熱伝導(動解析)_設定")
            }
        if type(treeSolution[0]) == str:
            treeSolution = [[treeSolution[0], [itemDict[anaType]]]]
        else:
            treeSolution[0][1] = [itemDict[anaType]]
        return treeSolution

    #
    #  applyEigenSolution
    #  ------------------
    #    eigenSolutionの内容を設定
    def applyEigenSolution(self, event):
        #設定
        value1 = self.textCtrl_eigenNum.get_text()
        value2 = self.textCtrl_eigenPerm.get_text()
        value3 = self.textCtrl_eigenMaxiter.get_text()
        values = [value1, value2, value3]
        lines = readFistrModelCnt()
        i = pyFistr.getInsertPointInCnt(lines, "!EIGEN", [])
        [lines, i] = pyFistr.deleteOnlyDataInLines(lines, i+1)
        addLines = [", ".join(values) + ls]
        lines = lines[:i] + addLines + lines[i:]
        writeFistrModelCnt(lines)
        print (_(u"固有値解析の設定を行いました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyDynamicSolution
    #  --------------------
    #    dynamicSolutionの内容を設定
    def applyDynamicSolution(self, event):
        global currDir
        #設定
        values = getDynamicContFromCnt()
        if values[0] == "":
            values[0] = "LINEAR"
        # if len(values[1]) != 21:
        #     if anaType == "DYNAMIC":
        #         #dynamic:動解析
        #         values[1] = defaultDynamicSolutionCont()
        #     else:
        #         #dynamic_f(response):周波数応答
        #         values[1] = defaultFreqResponseSolutionCont()
        if values[2] == "":
            values[2] = "1"
        #線形・非線形
        n = self.comboBox_soldyType.get_active()
        if n == 0:
            values[0] = "LINEAR"
        else:
            values[0] = "NONLINEAR"
        #運動方程式
        n = self.comboBox_soldyEqn.get_active()
        if n == 0:
            values[1][0] = "11"
        else:
            values[1][0] = "1"
        #開始時刻
        values[1][2] = self.textCtrl_soldyStime.get_text()
        values[1][3] = self.textCtrl_soldyEtime.get_text()
        values[1][4] = self.textCtrl_soldyAllstep.get_text()
        values[1][5] = self.textCtrl_soldyDtime.get_text()
        values[2] = self.textCtrl_soldyOutfile.get_text()
        #パラメータ
        values[1][6] = self.textCtrl_soldyGanma.get_text()
        values[1][7] = self.textCtrl_soldyBeta.get_text()
        values[1][10] = self.textCtrl_soldyRm.get_text()
        values[1][11] = self.textCtrl_soldyRk.get_text()
        #出力
        values[1][12] = self.textCtrl_soldySample.get_text()
        values[1][13] = self.comboBox_soldyGroup.get_child().get_text().split(":")[0]
        values[1][14] = self.textCtrl_soldyOutterm.get_text()
        if self.checkBtn_soldyDis.get_active() == False:
            values[1][15] = "0"
        else:
            values[1][15] = "1"
        if self.checkBtn_soldyVelo.get_active() == False:
            values[1][16] = "0"
        else:
            values[1][16] = "1"
        if self.checkBtn_soldyAcc.get_active() == False:
            values[1][17] = "0"
        else:
            values[1][17] = "1"
        if self.checkBtn_soldyForce.get_active() == False:
            values[1][18] = "0"
        else:
            values[1][18] = "1"
        if self.checkBtn_soldyStrain.get_active() == False:
            values[1][19] = "0"
        else:
            values[1][19] = "1"
        if self.checkBtn_soldyStress.get_active() == False:
            values[1][20] = "0"
        else:
            values[1][20] = "1"
        #valuesの内容をcntに書き込み
        #  errorチェック
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        if anaType == "DYNAMIC_F":
            #flag作成
            #eigenFlag = len(glob.glob("eigen_log")) == 0
            #if eigenFlag == True:
            if os.path.exists("eigen_log") == False:
                title = _(u"エラー")
                mess = _(u"固有値解析の結果ファイル（eigen_log）がありません") + ls
                mess += _(u"先に固有値解析を行ってください")
                self.errDialog(title, mess, parent=mainWindow)
                #環境を戻す
                currDir = currDirTemp
                os.chdir(currDirTemp)
                return
        currDir = currDirTemp
        os.chdir(currDirTemp)
        setDynamicContInCnt(values)
        print (_(u"SOLUTION dynamic を設定しました"))
        #環境を戻す
        # currDir = currDirTemp
        # os.chdir(currDirTemp)
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyHeatDynamicSolution
    #  ------------------------
    #    heatDynamicの内容を設定
    def applyHeatDynamicSolution(self, event):
        #設定
        Dt = self.textCtrl_hdynaDt.get_text()
        Etime = self.textCtrl_hdynaEtime.get_text()
        Dtmin = self.textCtrl_hdynaDtmin.get_text()
        Dmax = self.textCtrl_hdynaDmax.get_text()
        Itmax = self.textCtrl_hdynaItmax.get_text()
        Eps = self.textCtrl_hdynaEps.get_text()
        values = [Dt, Etime, Dtmin, Dmax, Itmax, Eps]
        lines = readFistrModelCnt()
        i = pyFistr.getInsertPointInCnt(lines, "!HEAT", [])
        lines[i+1] = ", ".join(values) + ls
        writeFistrModelCnt(lines)
        print (_(u"熱伝導（動解析）の設定を行いました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  checkDtConstant
    #  ---------------
    #    時間増分固定or自動の設定
    def checkDtConstant(self, event):
        if self.checkBtn_soluDt.get_active() == True:
            self.label_soluDt.set_label(_(u"時間増分"))
            self.label_soluEtime.set_label(_(u"計算時間"))
            self.textCtrl_hdynaDtmin.set_text("0")
            self.textCtrl_hdynaDtmin.set_sensitive(False)
            self.textCtrl_hdynaDmax.set_sensitive(False)
            self.label_soluDtmin.set_sensitive(False)
            self.label_soluDeltmx.set_sensitive(False)
        else:
            self.label_soluDt.set_label(_(u"初期時間増分"))
            self.label_soluEtime.set_label(_(u"計算時間"))
            self.textCtrl_hdynaDtmin.set_text("0.1")
            self.textCtrl_hdynaDtmin.set_sensitive(True)
            self.textCtrl_hdynaDmax.set_sensitive(True)
            self.label_soluDtmin.set_sensitive(True)
            self.label_soluDeltmx.set_sensitive(True)

    #
    #  setMaterialDB
    #  -------------
    #    材料DBの場所を設定
    def setMaterialDB(self, event):
        global materialDBName
        #if len(glob.glob(materialDBName)) == 0:
        if os.path.exists(materialDBName) == False:
            dbDir = os.path.dirname(os.getcwd())
            selName = os.path.basename(os.getcwd())
        else:
            dbDir = os.path.dirname(materialDBName)
            selName = os.path.basename(materialDBName)

        title = _(u"材料DBの選択")
        filterSets = [[_(u"csvファイル"), "*.csv"],
                      [_(u"全てのファイル"), "*"]]
        funcOk = [self.setMaterialDBProcess]
        funcCancel = []
        self.openFileDialog(title, dbDir, funcOk, funcCancel, mainWindow, selName, filterSets)
        # fileName = self.fileDialog(title, dbDir, selName, filterSets)
        # if fileName == "":
        #     return
        # #材料DBをfileNameに設定する
        # self.setMaterialDBProcess(fileName)

    #
    #  setMaterialDBProcess
    def setMaterialDBProcess(self, fileName):    
        #現在のunitを取得
        currUnit, matFile = getDimensionMatFileFromIstrData()
        #取得したfileのunitを取得
        units = getUnitsFromMatFiles([fileName])
        if len(units) == 0:
            f = open(fileName, encoding="utf-8"); line = f.readline(); f.close()
            words = line.split(",")[0]
            fileUnit = words[0]
        else:
            fileUnit = units[0]
        #現在のunitとfileのunitを比較
        if currUnit != fileUnit:
            title = _("エラー")
            mess = _("選択したファイルの単位系が、現在の単位系と異なっています。") + "\n"
            mess += _("現在の単位系と同じファイルを選択してください。") + "\n"
            mess += _("現在の単位系:") + currUnit
            self.errDialog(title, mess, parent=mainWindow)
            return
        #選択fileをmatFileとして設定
        materialDBName = fileName
        self.textCtrl_matDB.set_text(materialDBName)
        saveIstrData(["materialDB "+materialDBName])
        self.readMaterialDB()
        self.setMaterialNameToListBox()
        return

    #
    #  openMaterialDB
    #  --------------
    #    材料DBを開く
    def openMaterialDB(self, event):
        fileName = materialDBName
        #if len(glob.glob(fileName)) == 0:
        if os.path.exists(fileName) == False:
            title = _(u"エラー")
            mess = _(u"材料DBが存在しません") + ls
            mess += _(u"DBを再設定してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        comm = runOfficeComm + " " + fileName
        pyFistr.run().commandBG(comm)

    #
    #  reloadMaterialDB
    #-------------------
    def reloadMaterialDB(self):
        """ 材料DBを再読込し、材料名comboにセットし直す"""
        #選択matNameを取得
        selMatName = self.combo_matName.getSelectedItem()
        if selMatName == None:
            selMatName = ""
        #再読込
        self.readMaterialDB()
        self.setMaterialNameToListBox()
        #選択matNameを選択する
        if selMatName != "":
            self.combo_matName.selectItem(selMatName)

    #
    #  getBeamZaxis
    #---------------
    def getBeamZaxis(self):
        """ beamのZ軸を取得する"""
        global currDir, meshHeaderData
        #sourceのcurrDirを取得
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #今の設定を保存する
        copyFilesFromTempToCurrDir()
        #egrpから取得
        line = self.label_setMatGrp.get_text()
        egrp = line.split(":")[1]
        beam = getBeamRefDir
        beam.beamGrpNames = [egrp]
        vec = beam.getBeamRefDirInGrp()
        if len(vec) == 3:
            self.textCtrl_beamVx.set_text(vec[0])
            self.textCtrl_beamVy.set_text(vec[1])
            self.textCtrl_beamVz.set_text(vec[2])
            #tempの環境に戻す
            currDir = currDirTemp
            os.chdir(currDirTemp)
            #lines = readFistrModelMsh()
            #meshHeaderData = pyFistr.getHeaderNumData(lines)
            meshHeaderData = getReturnMeshHeaderData()
        else:
            #取得方法を選択する
            self.getBeamRefDirMethods(egrp)

    #
    #  getBeamRefDirMethods
    def getBeamRefDirMethods(self, egrp):
        """ beamの参照方向の取得方法をdialogから取得する"""
        funcName = self.getBeamRefDirMethods_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [egrp, path, item]
        dialog = getBeamRefDirDDialog.getBeamRefDir(funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return
    
    #
    #  getBeamRefDirMethods_onDlg
    def getBeamRefDirMethods_onDlg(self, vec2, egrp, path, item):
        global currDir, meshHeaderData
        #pageチェック
        self.showThisPageIfNotShow(path, item)
        #処理開始
        beam = getBeamRefDir
        if type(vec2) == list and len(vec2) == 3:
            vec2 = list(map(float, vec2))
            vec2 = geo.normal(vec2)
            vec = beam.getBeamRefDirWithVec(egrp, vec2)
            self.textCtrl_beamVx.set_text(vec[0])
            self.textCtrl_beamVy.set_text(vec[1])
            self.textCtrl_beamVz.set_text(vec[2])
        elif type(vec2) == list and len(vec2) == 2:
            if vec2[0] == "NGRP":
                ngrp = vec2[1]
                vec = beam.getBeamRefDirWithP(egrp, ngrp)
                if len(vec) == 0:
                    title = _("エラー")
                    mess = _("参照方向が取得できません。") + ls
                    mess += _("NGRP名を確認してください。")
                    self.errDialog(title, mess, parent=mainWindow)
                else:
                    self.textCtrl_beamVx.set_text(vec[0])
                    self.textCtrl_beamVy.set_text(vec[1])
                    self.textCtrl_beamVz.set_text(vec[2])
            elif vec2[0] == "EGRP":
                egrp2 = vec2[1]
                beam.beamGrpNames.append(egrp2)
                vec = beam.getBeamRefDir()
                if len(vec) == 0:
                    title = _("エラー")
                    mess = _("参照方向が取得できません。") + ls
                    mess += _("EGRP名を確認してください。")
                    self.errDialog(title, mess, parent=mainWindow)
                else:
                    self.textCtrl_beamVx.set_text(vec[0])
                    self.textCtrl_beamVy.set_text(vec[1])
                    self.textCtrl_beamVz.set_text(vec[2])
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)
        #lines = readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = getReturnMeshHeaderData()

    #
    #  calcSectionCoeff
    #-------------------
    def calcSectionCoeff(self):
        """ beamの断面定数を取得する"""
        egrp = self.label_setMatGrp.get_text().split(":")[1]
        path, item = self.getSelectedPathAndItemName() 
        funcName = self.calcSectionCoeff_onDlg
        funcArgs = [egrp, path, item]
        dialog = calcSectionCoeffDDialog.calcSectionCoeffClass(funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #
    #  calcSectionCoeff_onDlg
    def calcSectionCoeff_onDlg(self, stat, egrp, path, item):
        """ dialogから呼び出される関数。後処理。"""
        #pageをチェック
        self.showThisPageIfNotShow(path, item)
        #処理開始
        if len(stat) != 0:
            [area, Iyy, Izz, Jx] = stat
            self.textCtrl_beamArea.set_text(area)
            self.textCtrl_beamIyy.set_text(Iyy)
            self.textCtrl_beamIzz.set_text(Izz)
            self.textCtrl_beamJx.set_text(Jx)

    #
    #  setMaterialGroup
    #  ----------------
    #    elGroupを選択
    def setMaterialGroup(self, event):
        self.maskEvent = True
        self.moveItemToListBox(self.listBox_noMat, self.listmodelNoMat,
                               self.listBox_defMat, self.listmodelDefMat)
        self.maskEvent = False
        self.selectSetEgrp()

    #
    #  selectUnsetEgrp
    #------------------
    def selectUnsetEgrp(self):
        """ 材料設定page:非選択側のEGRPを選択した時"""
        if self.maskEvent == True:
            return
        #非選択側を取得
        treeList = GtkParts.treeList(self.listBox_noMat)
        unselEgrps = treeList.getSelectedItems()
        if len(unselEgrps) == 0:
            return
        self.preSelectedActors = list(map(lambda x: "elementGrp_" + x, unselEgrps))    
        #選択側を取得
        treeList = GtkParts.treeList(self.listBox_defMat)
        selEgrps = treeList.getSelectedItems()
        self.selectedActors = list(map(lambda x: "elementGrp_" + x, selEgrps))
        #vtkを表示
        self.showSelectedModel()

    #
    #  selectSetEgrp
    #-----------------
    def selectSetEgrp(self):
        """ 材料設定page:選択側のEGRPを選択した時"""
        if self.maskEvent == True:
            return
        #選択側を取得
        treeList = GtkParts.treeList(self.listBox_defMat)
        selEgrps = treeList.getSelectedItems()
        if len(selEgrps) == 0:
            return
        self.selectedActors = list(map(lambda x: "elementGrp_" + x, selEgrps))
        #非選択側を取得
        treeList = GtkParts.treeList(self.listBox_noMat)
        unselEgrps = treeList.getSelectedItems()
        self.preSelectedActors = list(map(lambda x: "elementGrp_" + x, unselEgrps))    
        #vtkを表示
        self.showSelectedModel()

    #
    #  returnMaterialGroup
    #  -------------------
    #    elGroupを戻す
    def returnMaterialGroup(self, event):
        self.maskEvent = True
        self.moveItemToListBox(self.listBox_defMat, self.listmodelDefMat,
                               self.listBox_noMat, self.listmodelNoMat)
        self.maskEvent = False
        self.selectUnsetEgrp()

    #  moveItemToListBox
    #    選択したitemをlistBox1からlistBox2に移動する
    def moveItemToListBox(self, listBox1, listmodel1, listBox2, listmodel2):
        names = self.moveItemToListBox_sub(listBox1, listmodel1, listBox2, listmodel2)
        if len(names) == 0:
            return

        [selNames, fromNames, toNames] = names
        #新しいnameListをセット
        self.setListDataInListBox(listmodel1, listBox1, fromNames)
        self.setListDataInListBox(listmodel2, listBox2, toNames)
        #selNamesを選択表示
        n = 0
        for name in toNames:
            for selName in selNames:
                if name == selName:
                    path = (n)
                    listBox2.get_selection().select_path(path)
            n += 1

    def moveItemToListBoxStep(self, listBox1, listmodel1, listBox2, listmodel2):
        names = self.moveItemToListBox_sub(listBox1, listmodel1, listBox2, listmodel2)
        if len(names) == 0:
            return

        [selNames, fromNames, toNames] = names
        #新しいnameListをセット
        self.setListDataInListBoxStep(listmodel1, listBox1, fromNames)
        self.setListDataInListBoxStep(listmodel2, listBox2, toNames)
        #selNamesを選択表示
        toNames = self.sortBndList(toNames)
        n = 0
        for name in toNames:
            for selName in selNames:
                if name == selName:
                    path = (n)
                    listBox2.get_selection().select_path(path)
            n += 1

    def moveItemToListBox_sub(self, listBox1, listmodel1, listBox2, listmodel2):
        if listBox1.get_selection().get_mode() == Gtk.SelectionMode.MULTIPLE:
            #multiple selection の場合-----------
            (listmodel, pathList) = listBox1.get_selection().get_selected_rows()
            if len(pathList) == 0:
                title = _(u"groupの選択")
                mess = _(u"group名を選択してください")
                self.errDialog(title, mess, parent=mainWindow)
                return []

            #選択しているselNamesを取得
            selNames = []
            names = self.getNamesInListmodel(listmodel)
            for path in pathList:
                selName = names[path[0]]
                selNames.append(selName)
        else:
            #single selection の場合---------------
            (listmodel, listIter) = listBox1.get_selection().get_selected()
            if listIter != None:
                selName = listmodel.get_value(listIter, 0)
            else:
                title = _(u"groupの選択")
                mess = _(u"group名を選択してください")
                self.errDialog(title, mess, parent=mainWindow)
                return []

            selNames = [selName]
        ##元listBoxからselNameを削除
        names = self.getNamesInListmodel(listmodel1)
        fromNames = []
        for name in names:
            flag = 0
            for selName in selNames:
                if name == selName:
                    flag = 1
                    break
            if flag == 0:
                fromNames.append(name)
        #先listBoxにselNamesを追加
        names = self.getNamesInListmodel(listmodel2)
        toNames = names + selNames
        return [selNames, fromNames, toNames]

    #
    #  applyMaterial
    #  -------------
    #    setした内容をFistrModel.cntに設定する
    def applyMaterial(self, event):

        def getMaterialNamesInMsh(meshHeaderData, names):
            """ names（要素grp）で定義されている材料名を取得"""
            matNames = []
            for i in range(len(meshHeaderData)):
                line = meshHeaderData[i][0]
                if line[:len("!SECTION")] == "!SECTION":
                    egrp = abaqus2fistr.getValName(line, "EGRP")
                    if egrp in names:
                        matName = abaqus2fistr.getValName(line, "MATERIAL")
                        matNames.append(matName)
            matNames = list(set(matNames)) 
            return matNames

        def addTempMaterialInCnt(lines):
            """ temp材料をcntファイルに定義する"""
            matName = "noData"
            newMat =  ["!MATERIAL, NAME=" + matName + ls]
            newMat += ["!ELASTIC, TYPE=ISOTROPIC" + ls]
            newMat += ["0.0, 0.0" + ls]
            newMat += ["!DENSITY" + ls]
            newMat += ["0.0" + ls]
            newMat += ["!EXPANSION_COEFF, DEPENDENCIES=0" + ls]
            newMat += ["0.0" + ls]
            lines = deleteDefineMaterialInCnt(lines, matName)
            lines = addDefineMaterialInCnt(lines, matName, newMat)
            return lines

        def addTempMaterialInMsh(meshHeaderData, names):
            """ temp材料をnames（要素grp名）にセットする。
            既にセットされている場合は、そのまま。"""
            setNames = []
            for i in range(len(meshHeaderData)):
                line = meshHeaderData[i][0]
                if line[:len("!SECTION")] == "!SECTION":
                    egrp = abaqus2fistr.getValName(line, "EGRP")
                    if egrp in names:
                        setNames.append(egrp)
                        #matNameをチェック
                        matName = abaqus2fistr.getValName(line, "MATERIAL")
                        if matName == "":
                            #temp材料をセット
                            line = abaqus2fistr.setValName(line, "MATERIAL=noData")
                            meshHeaderData[i][0] = line
            unsetNames = set(names).difference(setNames)
            if len(unsetNames) == 0:
                return meshHeaderData
            #未定義材料のSECTIONを作成する
            addMeshHeaderData = []
            egrpTypeDict = createEgrpToTypeDict()
            for name in unsetNames:
                elType = egrpTypeDict[name]
                if elType[0] == "7":
                    header = "!SECTION, TYPE=SHELL, EGRP=" + name + ", MATERIAL=noData" + ls
                    data = ["1.0, 5" + ls]
                elif elType[0] == "6":
                    header = "!SECTION, TYPE=BEAM, EGRP=" + name + ", MATERIAL=noData" + ls
                    data = ["0.0, 0.0, -1.0, 1.0, 1.0, 1.0, 1.0" + ls]
                else:
                    header = "!SECTION, TYPE=SOLID, EGRP=" + name + ", MATERIAL=noData" + ls
                    data = []
                addHeaderData = [header, data]
                addMeshHeaderData.append(addHeaderData)
            #SECTIONを追加する
            #  追加する場所を検索
            flag = 0
            sp = 0
            for i in range(len(meshHeaderData)):
                header = meshHeaderData[i][0]
                words = abaqus2fistr.deleteSp(header).split(",")
                if words[0] == "!ELEMENT":
                    flag = 1
                else:
                    if flag == 1:
                        #追加場所を取得
                        sp = i
                        break
            #  SECTIONを追加
            meshHeaderData = meshHeaderData[:sp] + addMeshHeaderData + meshHeaderData[sp:]
            return meshHeaderData

        def deleteMaterialInMsh(meshHeaderData, noMatNames):
            """ 材料未定義するnoMatNames（要素grp名）に定義されている材料名を削除する"""
            for i in range(len(meshHeaderData)):
                line = meshHeaderData[i][0]
                if line[:len("!SECTION")] == "!SECTION":
                    egrp = abaqus2fistr.getValName(line, "EGRP")
                    if egrp in noMatNames:
                        matName = abaqus2fistr.getValName(line, "MATERIAL")
                        if matName != "":
                            words = deleteSp(line).split(",")
                            newWords = []
                            for word in words:
                                if word.find("MATERIAL=") < 0:
                                    newWords.append(word)
                            line = ", ".join(newWords) + ls
                            meshHeaderData[i][0] = line
            return meshHeaderData

        def deleteMaterialExpectNames(meshHeaderData, matNames):
            """ meshHeaderDataからmatName以外の材料定義を削除する。
            「!MATERIAL, !ITEM」を削除。"""
            newData = []
            flag = 0
            for i in range(len(meshHeaderData)):
                line = meshHeaderData[i][0]
                if line[:len("!MATERIAL")] == "!MATERIAL":
                    matName = abaqus2fistr.getValName(line, "NAME")
                    if not matName in matNames:
                        flag = 1
                    else:
                        flag = 0
                        newData.append(meshHeaderData[i])
                else:
                    if flag == 1:
                        if line[:len("!ITEM")] != "!ITEM":
                            flag = 0
                            newData.append(meshHeaderData[i])
                    else:
                        newData.append(meshHeaderData[i])
            return newData

        def deleteSectionWithoutNamesInMsh(meshHeaderdata, names):
            """ 不要なSECTION行を削除する"""
            newHeaderData = []
            for headerData in meshHeaderData:
                header = headerData[0]
                words = abaqus2fistr.deleteSp(header).split(",")
                if words[0] == "!SECTION":
                    egrp = abaqus2fistr.getValName(header, "EGRP")
                    if egrp in names:
                        newHeaderData.append(headerData)
                else:
                    newHeaderData.append(headerData)
            return newHeaderData

        global matDefine, meshHeaderData
        #設定済みのcurrNamesを取得
        currNames = []
        for i in range(len(matDefine)):
            name = matDefine[i][0]
            currNames.append(name)        
        #elGroupを取得
        noMatNames = self.getNamesInListmodel(self.listmodelNoMat)
        names = self.getNamesInListmodel(self.listmodelDefMat)
        matDefine = []
        for name in names:
            #               elName, 材料名, elType
            matDefine.append([name, "", ""])
        #addTreeItemsSetを作成
        newNames = names
        parentList = [_("材料物性値")]
        self.remakeAddTreeItemsSet(parentList, currNames, newNames)
        #treeを表示
        addMatGroupInTreeData(names)
        treeList = parentList
        self.showTreeData(treeList)
        #材料定義を修正
        lines = readFistrModelCnt()
        #  names内の定義材料を取得
        matNames = getMaterialNamesInMsh(meshHeaderData, names)
        #  matNames以外の材料定義をcntファイルから削除
        lines = deleteMaterialWithoutNames(lines, matNames)
        #  temp材料をcntファイルに定義
        if "" in matNames:
            #材料未定義の要素grpが存在する場合にtemp材料を定義
            lines = addTempMaterialInCnt(lines)
        #  matNamesを取得
        matNames = getMatNamesInCnt(lines)
        writeFistrModelCnt(lines)
        #  meshHeaderDataからSECTIONのmatNames以外の材料を削除
        dummy_flag = deleteMaterialInSectionWithoutNames(matNames)
        #  matNames以外の材料定義部(!MATERIAL)を削除
        meshHeaderData = deleteMaterialExpectNames(meshHeaderData, matNames)
        #  namesのsection内に材料が定義されていない場合、temp材料(noData)を定義
        meshHeaderData = addTempMaterialInMsh(meshHeaderData, names)
        #  noMatNamesのsection内の材料を削除する。
        meshHeaderData = deleteMaterialInMsh(meshHeaderData, noMatNames)
        #  不要なSECTION行を削除する
        meshHeaderData = deleteSectionWithoutNamesInMsh(meshHeaderData, names)
        #要素タイプをmatDefineに追加
        egrpTypeDict = createEgrpToTypeDict()
        for headerData in meshHeaderData:
            line = headerData[0]
            if line[:len("!SECTION")] == "!SECTION":
                egrp = abaqus2fistr.getValName(line, "EGRP")
                matName = abaqus2fistr.getValName(line, "MATERIAL")
                elType = egrpTypeDict[egrp]
                for n in range(len(matDefine)):
                    if matDefine[n][0] == egrp:
                        matDefine[n][1] = matName
                        matDefine[n][2] = elType
                        break
        writeFistrModelMshHeader()
        print(_("材料グループを設定しました。"))
        #flagを再作成
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  setEachMaterialTypeHard
    #  -----------------------
    #    材料タイプ、硬化則をcomboBoxに再セット
    def setEachMaterialTypeHard(self):
        saveMask = self.maskEvent
        self.maskEvent = True
        matTypes = []
        matHards = []
        #matModel（材料モデル）を取得
        matModel = self.combo_matModel.getSelectedItem()
        if matModel == None:
            matModel = materialType[0][0]
        for matMTH in materialType:
            if matModel == matMTH[0]:
                matTypes = matMTH[1]
                matHards = matMTH[2]
                break
        if len(matTypes) == 0:
            self.combo_matType.unselectItem()
            self.combo_matType.comboBox.set_sensitive(False)
        else:
            self.combo_matType.comboBox.set_sensitive(True)
            self.combo_matType.setItems(matTypes)
            self.combo_matType.selectItem(matTypes[0])
        if len(matHards) == 0:
            self.combo_matHard.unselectItem()
            self.combo_matHard.comboBox.set_sensitive(False)
        else:
            self.combo_matHard.comboBox.set_sensitive(True)
            self.combo_matHard.setItems(matHards)
            self.combo_matHard.selectItem(matHards[0])
        #塑性ボタンのActive
        if matModel == "ELASTIC" or matModel == "HEAT":
            self.button_ssData.set_sensitive(False)
        else:
            self.button_ssData.set_sensitive(True)
        self.maskEvent = saveMask
        #塑性ボタンのlabelを設定
        self.setSsDataButtonLabel()

    #
    #  setSsDataButtonLabel
    def setSsDataButtonLabel(self):
        """ SS_dataボタンのlabelを設定"""
        #matmodel
        matModel = self.combo_matModel.getSelectedItem()
        if matModel == None:
            matModel = ""
        #matType
        matType = self.combo_matType.getSelectedItem()
        if matType == None:
            matType = ""
        #matHard
        matHard = self.combo_matHard.getSelectedItem()
        if matHard == None:
            matHard = ""
        #labelを設定
        if matModel == "PLASTIC":
            if matHard == "MULTILINEAR":
                if matType == "MISES":
                    mess = "SS_data" + ls
                    mess += _("作成・編集")
                else:
                    mess = "SV_data" + ls
                    mess += _("作成・編集")
            else:
                mess = "mat_data" + ls
                mess += _("作成・編集")
        elif matModel == "HYPERELASTIC":
            mess = "mat_data" + ls
            mess += _("作成・編集")
        else:
            mess = "mat_data" + ls
            mess += _("作成・編集")
        self.button_ssData.get_child().set_text(mess)

    #
    #  setMatYieldType
    #-------------------
    def setMatYieldType(self):
        """ 降伏条件comboBoxの内容を変更した時。
        塑性data入力buttonのlabelを修正"""
        #matModel取得
        matModel = self.combo_matModel.getSelectedItem()
        if matModel == None:
            matModel = ""
        #matType取得
        matType = self.combo_matType.getSelectedItem()
        if matType == None:
            matType = ""
        #matTypeに応じて、combo_matHardの内容を修正
        saveMask = self.maskEvent
        self.maskEvent = True
        if matModel == "PLASTIC":
            if matType == "MISES" or matType == "":
                hardens = ["MULTILINEAR", "BILINEAR", "SWIFT",
                            "RAMBERG-OSGOOD", "KINEMATIC", "COMBINED", ""]
            elif matType == "MOHR-COULOMB" or matType == "DRUCKER-PRAGER":
                hardens = ["MULTILINEAR", "BILINEAR"]
            #hardensをcomboにセット
            self.combo_matHard.setItems(hardens)
            self.combo_matHard.selectItem(hardens[0])
        self.maskEvent = saveMask
        #hardenを読み込み
        harden = self.combo_matHard.getSelectedItem()
        if harden == None:
            harden = ""
        #塑性data入力buttonのlabelを設定
        self.setSsDataButtonLabel()

    #
    #  setMatHarden
    #----------------
    def setMatHarden(self):
        """ 硬化則comboBoxの内容を変更した時。"""
        #hardenを読み込み
        harden = self.combo_matHard.getSelectedItem()
        if harden == None:
            harden = ""
        #塑性data入力buttonのlabelを設定
        self.setSsDataButtonLabel()

    #
    #  editPlasticSsData
    #  -----------------
    def editPlasticSsData(self, event):
        """ 塑性等のの非線形データを作成"""
        
        def getSelectedName(combo):
            name = combo.getSelectedItem()
            if name == None:
                name = ""
            return name

        def fitNlNames(nlNames):
            newNames = []
            for name in nlNames:
                name += ":"
                newNames.append(name)
            return newNames

        def fitNlUnits(nlUnits, conts):
            newUnits = []
            for i in range(len(nlUnits)):
            #for unit in nlUnits:
                unit = nlUnits[i]
                #if unit != "":
                if conts[i] != "":
                    if unit == "":
                        unit = "-"
                    unit = " " + conts[i] + " [" + unit + "]"
                newUnits.append(unit)
            return newUnits

        def fitVals(vals):
            newVals = []
            for val in vals:
                if val == "":
                    val = "- "
                newVals.append(val)
            return newVals

        matName = getSelectedName(self.combo_matName)
        if matName == "":
            title = _(u"エラー")
            mess = _(u"材料名が入力されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #非線形材料データ作成
        mthDict, mats = self.getMaterialTypeHardenDict()
        if mthDict["dialog"] == "office":
            #ファイルを作成
            dim, matFile = getDimensionMatFileFromIstrData()
            matDir = os.path.dirname(matFile)
            fileName = os.path.normpath(matDir + os.sep
                                + matName + mthDict["name"])
            #csvFileを作成
            if mthDict["cont"] == "normal":
                #normal形式
                createPlasticSsDataFile(fileName, matName, mats)
            elif mthDict["cont"] == "FAI":
                #FAI形式
                createPlasticSsDataFaiFile(fileName, matName, mats)
            else:
                #normalと同じ
                createPlasticSsDataFile(fileName, matName, mats)
            #office起動
            comm = runOfficeComm + " " + fileName
            pyFistr.run().commandBG(comm)
            #flagをセット
            self.changeContentsSetFlag()
        
        elif mthDict["dialog"] != None:
            #cnt-DB間のデータ比較
            newMatName = self.checkElasticMaterialDataInDB(matName)
            #cnt-DB間のデータが同じ場合?
            if newMatName == "":
                names = mthDict["names"]
                #matParams3Valsをdialogから取得
                vals, units = self.getMaterialParamsFromMatFile(matName, mthDict)
                if vals == ["","",""]:
                    #cntファイルから取得
                    vals = getNonlinearMaterialDataInCnt(matName, mats)
                    #materialDBに書き込み
                    if vals != ["","",""]:
                        self.saveMaterialParamsToMatFile(matName, mthDict, vals)    
                #valsを成形
                vals = self.checkPhysicalValueENull(vals)
                #contsにunit追加
                conts = mthDict["conts"]
                for i in range(len(units)):
                    if units[i] != "":
                        conts[i] = conts[i] + " [" + units[i] + "]"
                #dialogから材料定数を取得、設定
                self.getSetMaterial3Vals(matName, mats, names, vals, conts)
            #cnt-DB間のデータが異なる場合?
            else:
                nlTitle = mats[0]
                nlNames = mthDict["names"]
                #  cntの値を取得
                cnt3Vals = getNonlinearMaterialDataInCnt(matName, mats)
                #  DBの値を取得
                db3Vals, nlUnits = self.getMaterialParamsFromMatFile(matName, mthDict)
                #値の整形
                nlNames = fitNlNames(nlNames)   #nlNamesを整形
                conts = mthDict["conts"]
                nlUnits = fitNlUnits(nlUnits, conts)   #nlUnitsを整形
                cnt3Vals = fitVals(cnt3Vals)    #cnt3Valsを整形
                db3Vals = fitVals(db3Vals)      #db3Valsを整形
                #dialog表示データの作成
                itemNames = [matName + " "] + nlNames
                cnt3Vals = ["<cnt>"] + cnt3Vals
                db3Vals = ["<DB>"] + db3Vals
                nlUnits = [""] + nlUnits
                title = _("非線形材料の物性値")
                mess = "\n".join(mats)
                #dialog表示のみ
                dialog = showMaterialValueDDialog.showMaterialValue(title, mess, itemNames, cnt3Vals, db3Vals, nlUnits, parent=mainWindow)
                dialog.show()

    #
    #  getSetMaterial3Vals
    def getSetMaterial3Vals(self, matName, mats, names, vals, conts):
        """ 材料の非線形dataをdialogから取得、設定する。"""
        mthDict = materialMthDict()[mats]
        moduleName = mthDict["dialog"]

        def getSetMaterial3Vals_onDlg(matParams3Vals, matName, mthDict, path, item):
            """ dialogから実行される処理関数"""
            self.showThisPageIfNotShow(path, item)
            if len(matParams3Vals) != 0:
                #OKでdialogを閉じた場合
                self.saveMaterialParamsToMatFile(matName, mthDict, matParams3Vals)
                #flagをセット
                self.changeContentsSetFlag()

        funcName = getSetMaterial3Vals_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [matName, mthDict, path, item]
        dialog = moduleName.inputMaterialCont(mats, names, vals, conts, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #
    #  getMaterialParamsFromMatFile
    def getMaterialParamsFromMatFile(self, matName, mthDict):
        """ matFileから該当する非線形dataを取得する"""
        global materialDBName
        cols = mthDict["cols"]
        matFile = materialDBName
        vals = ["", "", ""]
        data = pyFistr.readMaterialData(matFile)
        allUnits = getUnitsOfMaterialData()
        units = list(map(lambda x: allUnits[x], cols))
        for i in range(2, len(data)):
            words = data[i]
            if words[0] == matName:
                for ii in range(len(cols)):
                    col = cols[ii]
                    if 0 <= col and col < len(words):
                        val = words[col]
                        vals[ii] = val
                break
        return vals, units

    #
    #  saveMaterialParamsToMatFile
    def saveMaterialParamsToMatFile(self, matName, mthDict, vals):
        """ 非線形dataを保存する"""
        global materialDBName
        cols = mthDict["cols"]
        matFile = materialDBName
        data = pyFistr.readMaterialData(matFile)
        for i in range(2, len(data)):
            words = data[i]
            if words[0] == matName:
                for ii in range(len(cols)):
                    col = cols[ii]
                    if 0 <= col and col < len(words):
                        words[col] = vals[ii]
                break
        pyFistr.writeCsvData(matFile, data)

    #
    #  showMaterialData
    #  ----------------
    #    設定した材料の物性値を表示
    def showMaterialData(self, event):

        def getUnit(unitName):
            """ 単位を取得"""
            unit = unitDict[unitName]
            cont = " [" + unit + "]"
            return cont

        def showMaterialData_onSetDlg(newVals, itemNames, matName, path, item):
            self.showThisPageIfNotShow(path, item)
            self.changeContentsSetFlag()
            #itemNamesからvalsの項目名を取得
            items = list(map(lambda x: x[:-1],itemNames[1:]))
            #materialDB内を修正
            self.setValsToMaterialDB(matName, items, newVals)

        matName = self.combo_matName.getSelectedItem()
        #if nIter == None:
        if matName == None:
            title = _("エラー")
            mess = _(u"材料名が設定されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        [elastic, heatVals] = getMaterialElasticValue(matName)
        #DB内の値をチェック
        conts = self.checkPhysicalValueENull(elastic + heatVals)
        elastic = conts[:4]; heatVals = conts[4:]
        #単位の辞書を取得
        dim, matFile = getDimensionMatFileFromIstrData()
        unitDict = convDimensionMatCsv.createUnitDict(dim)
        #cntとDB間のデータを比較
        anaType = getSolutitionTypeFromCnt()
        newMatName = self.checkElasticMaterialDataInDB(matName)
        if newMatName == "":
            #同じnameの場合
            if anaType == "HEAT" or anaType == "HEAT_D":
                #熱解析
                itemNames =[matName + " "] + ["density:", "thermal_cond.:", "specific_heat:"]
                cntVals = [""] + ["", "", ""]
                dbVals = ["value"] + [elastic[2]] + heatVals
                units =[""] + [getUnit("rho"), getUnit("thermCond"), getUnit("specHeat")]
            else:
                #熱解析以外
                itemNames =[matName + " "] + ["youngs:", "poisson:", "density:", "linearexp:"]
                cntVals = [""] + ["", "", "", ""]
                dbVals = ["value"] + elastic
                units = [""] + [getUnit("press"), " [-]", getUnit("rho"), " [1/K]"]
            title = _(u"材料の物性値")
            mess = _(u"材料DB内の ") + matName + _(u" の物性値   ")
            #dialog表示、処理
            #  現在のtreePathを取得
            path, item = self.getSelectedPathAndItemName()
            funcName = showMaterialData_onSetDlg
            funcArgs = [itemNames, matName, path, item]
            dialog = showSetMaterialValueDDialog.showSetMaterialValue(title, mess, itemNames, cntVals, dbVals, units, funcName, funcArgs, parent=mainWindow)
            dialog.show()
        else:
            #cnt内の値が異なる場合
            E, myu, rho, alpha, kappa, cp = self.getMaterialCoeffInMshCnt(matName)
            conts = [E, myu, rho, alpha, kappa, cp]
            #値をチェック
            conts = self.checkPhysicalValueENull(conts)
            if anaType == "HEAT" or anaType == "HEAT_D":
                nums = (2, 4, 5)
                cntVals = ["<cnt>"] + list(map(lambda x: conts[x], nums))
                dbVals = ["<DB>"] + [elastic[2]] + heatVals
                itemNames = [matName + " ", "density:", "thermal_cond.:", "specific_heat:"]
                units = ["", getUnit("rho"), getUnit("thermCond"), getUnit("specHeat")]
            else:
                nums = nums = (0, 1, 2, 3)
                cntVals = ["<cnt>"] + list(map(lambda x: conts[x], nums))
                dbVals = ["<DB>"] + elastic
                itemNames = [matName + " ", "youngs:", "poisson:", "density:", "linearexp:"]
                units = ["", getUnit("press"), " [-]", getUnit("rho"), " [1/K]"]
            title = _(u"材料の物性値")
            mess = _(u"材料DB内の ") + matName + _(u" の物性値   ")
            #dialog表示のみ
            dialog = showMaterialValueDDialog.showMaterialValue(title, mess, itemNames, cntVals, dbVals, units, parent=mainWindow)
            dialog.show()

    #
    #  setValsToMaterialDB
    def setValsToMaterialDB(self, matName, items, vals):
        """ 材料DB内の値を修正する。
        matName: 材料名
        items:  項目名
        vals:   値"""
        #材料DB読込
        fileName = materialDBName
        data = pyFistr.readMaterialData(fileName)
        #matNameの行番号を取得
        for row in range(len(data)):
            if data[row][0] == matName:
                break
        #項目毎に値を修正
        for i in range(len(items)):
            for col in range(len(data[0])):
                #10文字以内同士で比較（省略形があるため）
                if data[0][col][:10] == items[i][:10]:
                    data[row][col] = vals[i]
                    break
        #材料DBを保存
        pyFistr.writeCsvData(fileName, data)

    #
    #  applyEachMaterial
    #  -----------------
    #    各groupの材料を設定
    def applyEachMaterial(self):

        def getSelectedName(combo):
            name = combo.getSelectedItem()
            if name == None:
                name = ""
            return name

        #エラーチェック
        matName = getSelectedName(self.combo_matName)
        if matName == "":
            title = _("エラー")
            mess = _("設定されている材料名は、材料データベース内に存在しません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        mthDict, mats = self.getMaterialTypeHardenDict()
        matModel, matType, matHard = mats
        #設定開始
        line = self.label_setMatGrp.get_text()
        elGroup = line.split(":")[1]
        #材料物性値を各々(弾性と熱の値）取得する
        [elastic, heatVals] = getMaterialElasticValue(matName)
        #  shell, beamの場合その定数を書き込む
        self.writeThicknessBeamDataInCnt(elGroup)
        if matModel == "HEAT":
            self.setHeatMaterialValueInFile(elGroup, matName, elastic, heatVals)
            self.clearSetFlagInTree()
            self.clearButtonLabel()
            return
        elif matModel == "ELASTIC":
            writeFistrModelFile(elGroup, matName, elastic, matModel, matType,
                matHard, "")
        else:
            if mthDict["dialog"] == "office":
                dim, matFile = getDimensionMatFileFromIstrData()
                matDir = os.path.dirname(matFile)
                if mthDict["cont"] == "normal":
                    name = mthDict["name"]
                    fileName = matDir + os.sep + matName + name
                    ssData = getPlasticSsData(fileName)
                    if ssData == "":
                        title = _(u"エラー")
                        mess = _(u"塑性data（SS_curve）が入力されていません。")
                        self.errDialog(title, mess, parent=mainWindow)
                        return
                    #cnt, mshファイルへ書き込み
                    writeFistrModelFile(elGroup, matName, elastic, matModel, matType,
                        matHard, ssData)
                elif mthDict["cont"] == "FAI":
                    name = mthDict["name"]
                    #fileName = currDir + os.sep + matName + name
                    fileName = matDir + os.sep + matName + name
                    ssData = getPlasticSsFaiData(fileName)
                    if ssData == "":
                        title = _(u"エラー")
                        mess = _(u"塑性data（SS_curve）が入力されていません。")
                        self.errDialog(title, mess, parent=mainWindow)
                        return
                    #cnt, mshファイルへ書き込み
                    writeFistrModelFile(elGroup, matName, elastic, matModel, matType,
                        matHard, ssData)
            elif mthDict["dialog"] != None:
                #vals, units = self.getMaterialParamsFromMatFile(matName, mthDict[mats])
                vals, units = self.getMaterialParamsFromMatFile(matName, mthDict)
                line = ", ".join(vals)
                if line[-2:] == ", ":
                    line = line[:-2]
                lineCont = line + ls
                writeFistrModelFile(elGroup, matName, elastic, matModel, matType,
                    matHard, lineCont)
        print (elGroup + ": " + matName + _(u" を設定しました"))
        self.clearSetFlagInTree()
        self.clearButtonLabel()
        return

    #  writeThicknessBeamDataInCnt
    #    板厚を書き込む（shellの場合）
    def writeThicknessBeamDataInCnt(self, elGrp):
        for mat in matDefine:
            if mat[0] == elGrp:
                elType = mat[2]
                break
        newLine = ""
        if isThicknessElementType(elType) == True:
            tShell = self.textCtrl_tShell.get_text()
            nShell = self.textCtrl_nShell.get_text()
            newLine = tShell + ", " + nShell + ls
        elif isBeamElementType(elType) == True:
            Vx = self.textCtrl_beamVx.get_text()
            Vy = self.textCtrl_beamVy.get_text()
            Vz = self.textCtrl_beamVz.get_text()
            Area = self.textCtrl_beamArea.get_text()
            Iyy = self.textCtrl_beamIyy.get_text()
            Izz = self.textCtrl_beamIzz.get_text()
            Jx = self.textCtrl_beamJx.get_text()
            newLine = ", ".join([Vx, Vy, Vz, Area, Iyy, Izz, Jx]) + ls
        if newLine != "":
            global meshHeaderData
            for i in range(len(meshHeaderData)):
                line = meshHeaderData[i][0]
                if line[:len("!SECTION")] == "!SECTION":
                    name = pyFistr.getValName(line, "EGRP")
                    if name == elGrp:
                        meshHeaderData[i][1] = [newLine]

    #  setHeatMaterialValueInFile
    #    HEAT解析の場合の材料設定
    def setHeatMaterialValueInFile(self, elGroup, matName, elastic, heatVals):
        writeHeatFistrModelFile(elGroup, matName, elastic, heatVals)
        print (elGroup + ": " + matName + _(u" を設定しました"))

    #
    #  setIniDimenionToCurrDir
    #-------------------------
    def setIniDimenionToCurrDir(self):
        """ dimensionが設定されていないworkFolderに対し、
        暫定的なdimension（kg_m_s）を設定する。"""
        global istrData
        saveIstrData(["dimension kg_m_s"])
        istrData = getSavedData()

    #
    #  setDimensionToCurrDir
    #------------------------
    def setDimensionToCurrDir(self):
        """ dimensionが設定されていないworkFolderに対し、
        modelサイズとヤング率の値からdimensionの設定を促す。"""
        global istrData

        def getNameValueFromCnt(keyword):
            """ cntファイルからmatNameと値を取得する"""
            matName = ""; value = ""
            for i in range(len(lines)):
                line = lines[i]
                if line[:len("!MATERIAL")] == "!MATERIAL":
                    matName = pyFistr.getValName(line, "NAME")
                    value = ""
                elif line[:len(keyword)] == keyword:
                    words = deleteSp(lines[i+1]).split(",")
                    value = words[0]
                if matName != "" and value != "":
                    break
            return matName, value

        def getNameValueFromMsh():
            """ mshファイルからmatNameとITEM=1の値を取得する"""
            matName = ""; value = ""
            for header, data in meshHeaderData:
                if header[:len("!MATERIAL")] == "!MATERIAL":
                    matName = pyFistr.getValName(header, "NAME")
                    value = ""
                elif header[:len("!ITEM=1")] == "!ITEM=1":
                    words = deleteSp(data[0]).split(",")
                    value = words[0]
                if matName != "" and value != "":
                    break
            return matName, value

        #modelSizeを取得
        meshCont = getMeshContsFromTempFolder()["meshCont"]
        modelSize = ""
        meshContLines = meshCont.split(ls)
        for line in meshContLines:
            if line[:len("modelSize")] == "modelSize":
                modelSize = line.split(":")[1]
                xyzList = modelSize.split()
                modelSize = "_".join(xyzList)
                break
        #物性値の値を取得
        lines = readFistrModelCnt()
        if anaType[:len("HEAT")] != "HEAT":
            #構造解析（ヤング率を取得）
            matName, value = getNameValueFromCnt("!ELASTIC")
            if matName == "" or value == "":
                #meshから取得
                matName, value = getNameValueFromMsh()
        else:
            #熱解析（密度を取得）
            matName, value = getNameValueFromCnt("!DENSITY")
            if matName == "" or value == "":
                matName, value = getNameValueFromMsh()
        
        #valueを成形
        value = pyFistr.float2strAuto(value)
        #unitを取得
        dimItems = self.getAllDimensions()
        funcName = self.setDimensionToCurrDir_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [path, item]
        dialog = setDimensionAtChangeFolderDDialog.setDimensionAtChangeFolder(
            modelSize, anaType, matName, value, dimItems, 
            funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #
    #  setDimensionToCurrDir_onDlg
    def setDimensionToCurrDir_onDlg(self, unit, path, item):
        """ path, itemは、使用しない。"""
        global istrData, currDir
        #self.showThisPageIfNotShow(path, item)
        saveIstrData(["dimension " + unit])
        if currDir == currDirTemp:
            #実folderに反映
            copyFile = currDir + os.sep + istrSubDataFileName
            pasteDir = getCurrDirFromTempFolder()
            shutil.copy(copyFile, pasteDir)
        istrData = getSavedData()
        self.checkDimensionMatCsv()
        #単位をcomboに再設定
        self.setComboDimension()
        #単位をtitleに表示
        self.setUnitToTitle()

    #
    #  checkDimensionMatCsv
    #------------------------
    def checkDimensionMatCsv(self):
        """ dimensionのチェックし、matDB,otherMatFileをdimensionに合わせる。"""
        global istrData, materialDBName, materialDBCont, currDirTemp
        #現在のdimensionとmatDBを取得
        dim, matFile = getDimensionMatFileFromIstrData()
        #matDBを修正
        matFileDim = getUnitFromMatFile(matFile)
        if matFileDim == "":
            #matFileの1行1列から単位を取得
            matFileDim = getUnitFromMatFileCont(matFile)
        if matFileDim == dim:
            return
        #matFile名を修正
        matName = os.path.basename(matFile)
        words = matName.split(".")
        if len(words) == 2:
            newName = words[0] + "." + dim + ".csv"
        elif len(words) <= 1:
            newName = "mat." + dim + ".csv"
        else:
            newName = ".".join(words[:-2]) + "." + dim + ".csv"
        matDir = os.path.dirname(matFile)
        matFile = matDir + os.sep + newName
        if isCorrectMatFile(matFile) == False:
            #matFileを作成
            convDimensionMatCsv.convDimension(dim)
        #workDir内のotherFileを変換
        convDimensionMatCsv.convDimensionOtherMatFiles(matDir, dim)
        saveIstrData(["materialDB " + matFile])
        #textCtrlにmatFileをセット
        self.textCtrl_matDB.set_text(matFile)
        materialDBName = matFile
        #matNameをcomboBoxに設定する
        self.readMaterialDB()
        self.setMaterialNameToListBox()

    #
    #  setComboDimension
    #--------------------
    def setComboDimension(self):
        """ comboBox_dimensionの設定と現在のdimensionを選択表示させる"""
        global istrData
        #現在のdimensionを取得
        dim, matFile = getDimensionMatFileFromIstrData()
        #全itemを取得
        items = self.getAllDimensions()
        #comboにitemを設定
        self.comboBox_dimension.setItems(items)
        #選択itemを設定
        self.comboBox_dimension.selectItem(dim)

    #
    #  getAllDimensions
    def getAllDimensions(self):
        """ 現在の全dimensionを取得する"""
        #現在のdimensionを取得
        dim, matFile = getDimensionMatFileFromIstrData()
        #items = ["kg_m_s", "ton_mm_s", "kg_mm_ms", "g_cm_s"]
        items = list(convDimensionMatCsv.definedUnitDict().keys())
        if not dim in items:
            items += [dim]
        #既に作成している単位をfile名から取得
        matBaseName = getMatBaseName(matFile)
        matDir = os.path.dirname(matFile)
        matFiles = glob.glob(matDir + os.sep + matBaseName + "*.csv")
        fileUnits = getUnitsFromMatFiles(matFiles)
        items += fileUnits
        items = list(set(items))
        items.sort()
        items += [_("(任意)")]
        return items

    #
    #  setUnitToTitle
    def setUnitToTitle(self):
        """ 単位をtitle部に表示する"""
        dim, matFile = getDimensionMatFileFromIstrData()
        dimCont = _("単位:") + dim
        builder.get_object("label_unit_title").set_text(dimCont)

    #
    #  setUnitToPage
    #----------------
    def setUnitToPage(self, units):
        """ labelに単位をセットする
        units = [["len", [label0, label1]], ["time", [label2, label3]]]"""
        dim, matFile = getDimensionMatFileFromIstrData()
        unitDict = convDimensionMatCsv.createUnitDict(dim)
        for unit, labels in units:
            unitName = unitDict[unit]
            setCont = "[" + unitName + "]"
            for label in labels:
                builder.get_object(label).set_text(setCont)

    #
    #  clearAllBoundary
    #-------------------
    def clearAllBoundary(self):
        """ 全境界条件をクリアする。
        mshファイルに含まれる初期値、接触ペア、AMPLITUDEを含む"""
        #確認のdialog
        title = _("全境界条件のクリア")
        mess = _("全ての球界条件がクリアされます。") + ls
        mess += _("関連するmshファイル内の!INITIAL CONDITION, !CONTACTPAIR, !AMPLITUDEも削除されます。")
        funcOk = [self.clearAllBoundaryProcess]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
        #stat = self.okCancelDialog(title, mess)
        #if stat != "OK":
        #    return
        ##全条件をクリア
        #self.clearAllBoundaryProcess()

    #
    #  clearAllBoundaryProcess
    def clearAllBoundaryProcess(self):
        global meshHeaderData, stepDefine, contactDefine, ampDefine
        global reftempDefine, initempDefine
        #展開しているTreeのnodeと選択しているnodeを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #mshファイルをクリア
        delHeaders = ["!INITIALCONDITION", "!CONTACTPAIR", "!AMPLITUDE",
                      "!INITIAL CONDITION", "!CONTACT PAIR"]
        newHeaderData = []
        for headerData in meshHeaderData:
            header = headerData[0]
            words = deleteSp(header).split(",")
            if not words[0] in delHeaders:
                newHeaderData.append(headerData)
        meshHeaderData = newHeaderData
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        writeFistrModelMsh(lines)
        #cntファイルをクリア
        lines = readFistrModelCnt()
        lines = deleteDloadWithoutNames(lines, [], -1)
        lines = deleteCloadWithoutNames(lines, [], -1)
        lines = deleteBoundaryWithoutNames(lines, [], -1)
        lines = deleteVloadWithoutNames(lines, [], -1)
        lines = deleteGravWithoutNames(lines, [], -1)
        lines = deleteCentWithoutNames(lines, [], -1)
        lines = deleteTemperatureWithoutNames(lines, [], -1)
        lines = deleteSpringWithoutNames(lines, [], -1)
        lines = deleteFloadWithoutNames(lines, [], -1)
        lines = deleteVeloWithoutNames(lines, [], -1)
        lines = deleteAccelWithoutNames(lines, [], -1)
        lines = deleteFixtempWithoutNames(lines, [], -1)
        lines = deleteCfluxWithoutNames(lines, [], -1)
        lines = deleteBfWithoutNames(lines, [], -1)
        lines = deleteSfluxWithoutNames(lines, [], -1)
        lines = deleteDfluxWithoutNames(lines, [], -1)
        lines = deleteSfilmWithoutNames(lines, [], -1)
        lines = deleteSradiateWithoutNames(lines, [], -1)
        lines = deleteReftempCont(lines)
        lines = pyFistr.deleteHeaderName(lines, 0, "!CONTACT", "")
        lines = pyFistr.deleteHeaderName(lines, 0, "!CONTACT_ALGO", "")
        lines = pyFistr.deleteHeaderName(lines, 0, "!STEP", "")
        lines = pyFistr.deleteHeaderName(lines, 0, "!AUTOINC_PARAM", "")
        lines = pyFistr.deleteHeaderName(lines, 0, "!TIME_POINTS", "")
        writeFistrModelCnt(lines)
        #TreeDataを作成（initialDataを再設定）
        stepDefine = []
        contactDefine = [[]]
        ampDefine = []
        reftempDefine = []
        initempDefine = []
        makeIniTreeData()
        #treeを作成
        self.setIniTreeData()
        #Treeを表示
        self.setTreeSetPage(expPathes, selPath)
        #  vtk表示
        self.setVtkModel()
        #createGrpPageを初期化
        self.initCreateNgrpSgrpPage()
        #終了メッセージ
        title = _(u"全境界条件のクリア")
        mess = _(u"全ての境界条件をクリアしました。") + ls
        mess += _(u"mshファイル内の!INITIAL CONDITION, !CONTACTPAIR, !AMPLITUDEもクリアしました。")
        self.okDialog(title, mess, parent=mainWindow)

    #
    #  setBCGroup
    #  ----------
    #    BOUNDARYのgroupを設定
    def setBCGroup(self, event):
        self.maskEvent = True
        self.moveItemToListBox(self.listBox_noGroup, self.listmodelNoGroup,
                               self.listBox_setGroup, self.listmodelSetGroup)
        self.maskEvent = False
        self.selectSetEachGrp()

    #
    #  returnBCGroup
    #  -------------
    #    BOUNDARYのgroupを戻す
    def returnBCGroup(self, event):
        self.maskEvent = True
        self.moveItemToListBox(self.listBox_setGroup, self.listmodelSetGroup,
                               self.listBox_noGroup, self.listmodelNoGroup)
        self.maskEvent = False
        self.selectUnsetEachGrp()

    #
    #  applyBCGroup
    #  ------------
    #    BCGroupを決定
    def applyBCGroup(self, event):
        global tempDefine, gravDefine, stepDefine
        #stepIdを取得
        nStep = self.getStepIdFromItem()
        #設定
        itemName = self.boundaryFrameLabel.get_text()
        names = self.getNamesInListmodel(self.listmodelSetGroup)
        cNames = []
        #TEMPERATURE
        if itemName == u"TEMPERATURE":          #済み
            global tempDefine
            cNames = tempDefine
            addTempGroupInTreeData(names, nStep)
            writeDefaultTemperatureInCnt(names, nStep)
            tempDefine = self.updateStepDefine(names, nStep, tempDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"TEMPERATURE（温度）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"TEMPERATURE（温度）")]
        #BOUNDARY
        elif itemName == u"BOUNDARY":           #済み
            global bndDefine
            cNames = bndDefine
            addBndGroupInTreeData(names, nStep)
            writeDefaultBoundaryInCnt(names, nStep)
            bndDefine = self.updateStepDefine(names, nStep, bndDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"BOUNDARY（変位）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"BOUNDARY（変位）")]
        #CLOAD
        elif itemName == u"CLOAD":              #済み
            global cloadDefine
            cNames = cloadDefine
            addCloadGroupInTreeData(names, nStep)
            writeDefaultCloadInCnt(names, nStep)
            cloadDefine = self.updateStepDefine(names, nStep, cloadDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"CLOAD（荷重）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"CLOAD（荷重）")]
        #DLOAD
        elif itemName == u"DLOAD":              #済み
            global dloadDefine
            cNames = dloadDefine
            addDloadGroupInTreeData(names, nStep)
            writeDefaultDloadInCnt(names, nStep)
            dloadDefine = self.updateStepDefine(names, nStep, dloadDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"DLOAD（圧力）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"DLOAD（圧力）")]
        #VLOAD
        elif itemName == u"VLOAD":              #済み
            global vloadDefine
            cNames = vloadDefine
            addVloadGroupInTreeData(names, nStep)
            writeDefaultVloadInCnt(names, nStep)
            vloadDefine = self.updateStepDefine(names, nStep, vloadDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"VLOAD（体積力）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"VLOAD（体積力）")]
        #CENT
        elif itemName == u"CENT":               #済み（手本）
            global centDefine
            cNames = centDefine
            addCentGroupInTreeData(names, nStep)
            writeDefaultCentInCnt(names, nStep)
            centDefine = self.updateStepDefine(names, nStep, centDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"CENT（遠心力）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"CENT（遠心力）")]
        #GRAV
        elif itemName == u"GRAV":               #済み
            global gravDefine
            cNames = gravDefine
            writeDefaultGravInCnt(names, nStep)
            addGravGroupInTreeData(names, nStep)
            gravDefine = self.updateStepDefine(names, nStep, gravDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"GRAV（重力）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"GRAV（重力）")]
        #SPRING
        elif itemName == u"SPRING":             #済み
            global springDefine
            cNames = springDefine
            addSpringGroupInTreeData(names, nStep)
            writeDefaultSpringInCnt(names, nStep)
            springDefine = self.updateStepDefine(names, nStep, springDefine)
            if nStep == 0:
                #treeList = [_(u"境界条件"), _(u"SPRING（バネ要素）")]
                treeList = [_(u"境界条件"), _(u"SPRING（バネ境界）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"SPRING（バネ要素）")]
        #FLOAD
        elif itemName == u"FLOAD":              #済み（手本）
            global floadDefine
            cNames = floadDefine
            addFloadGroupInTreeData(names, nStep)
            writeDefaultFloadInCnt(names, nStep)
            floadDefine = self.updateStepDefine(names, nStep, floadDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"FLOAD（周期荷重）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"FLOAD（周期荷重）")]
        #VELOCITY
        elif itemName == u"VELOCITY":           #済み
            global veloDefine
            cNames = veloDefine
            addVeloGroupInTreeData(names, nStep)
            writeDefaultVeloInCnt(names, nStep)
            veloDefine = self.updateStepDefine(names, nStep, veloDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"VELOCITY（速度）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"VELOCITY（速度）")]
        #ACCELERATION
        elif itemName == u"ACCELERATION":       #済み
            global accelDefine
            cNames = accelDefine
            addAccelGroupInTreeData(names, nStep)
            writeDefaultAccelInCnt(names, nStep)
            accelDefine = self.updateStepDefine(names, nStep, accelDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"ACCELERATION（加速度）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"ACCELERATION（加速度）")]
        #FIXTEMP
        elif itemName == u"FIXTEMP":            #済み
            global fixtempDefine
            cNames = fixtempDefine
            addFixtempGroupInTreeData(names, nStep)
            writeDefaultFixtempInCnt(names, nStep)
            fixtempDefine = self.updateStepDefine(names, nStep, fixtempDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"FIXTEMP（温度固定）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"FIXTEMP（温度固定）")]
        #CFLUX
        elif itemName == u"CFLUX":              #済み
            global cfluxDefine
            cNames = cfluxDefine
            addCfluxGroupInTreeData(names, nStep)
            writeDefaultCfluxInCnt(names, nStep)
            cfluxDefine = self.updateStepDefine(names, nStep, cfluxDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"CFLUX（集中熱量）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"CFLUX（集中熱量）")]
        #SFLUX
        elif itemName == u"SFLUX":              #済み
            global sfluxDefine
            cNames = sfluxDefine
            addSfluxGroupInTreeData(names, nStep)
            writeDefaultSfluxInCnt(names, nStep)
            sfluxDefine = self.updateStepDefine(names, nStep, sfluxDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"SFLUX（面熱流束）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"SFLUX（面熱流束）")]
        #DFLUX
        elif itemName == u"DFLUX":              #済み
            global dfluxDefine
            cNames = dfluxDefine
            addDfluxGroupInTreeData(names, nStep)
            writeDefaultDfluxInCnt(names, nStep)
            dfluxDefine = self.updateStepDefine(names, nStep, dfluxDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"DFLUX（個別の面熱流束）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"DFLUX（個別の面熱流束）")]
        #BF
        elif itemName == u"BF":                 #済み
            global bfDefine
            cNames = bfDefine
            addBfGroupInTreeData(names, nStep)
            writeDefaultBfInCnt(names, nStep)
            bfDefine = self.updateStepDefine(names, nStep, bfDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"BF（内部発熱）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"BF（内部発熱）")]
        #SFILM
        elif itemName == u"SFILM":              #済み
            global sfilmDefine
            cNames = sfilmDefine
            addSfilmGroupInTreeData(names, nStep)
            writeDefaultSfilmInCnt(names, nStep)
            sfilmDefine = self.updateStepDefine(names, nStep, sfilmDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"SFILM（熱伝達率）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"SFILM（熱伝達率）")]
        #SRADIATE
        elif itemName == u"SRADIATE":           #済み
            global sradiateDefine
            cNames = sradiateDefine
            addSradiateGroupInTreeData(names, nStep)
            writeDefaultSradiateInCnt(names, nStep)
            sradiateDefine = self.updateStepDefine(names, nStep, sradiateDefine)
            if nStep == 0:
                treeList = [_(u"境界条件"), _(u"SRADIATE（輻射）")]
            else:
                treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"SRADIATE（輻射）")]
        #INITEMP
        elif itemName == u"INITEMP":            #変更せず
            global initempDefine
            cNames = [initempDefine]
            addInitempGroupInTreeData(names)
            writeDefaultInitempInMsh(names)
            initTempDefine = getInitempGroupInMsh()
            treeList = [_(u"初期値（初期温度）")]
        #REFTEMP
        elif itemName == "REFTEMP":
            global reftempDefine
            cNames = reftempDefine
            #cntの書き換え
            writeDefaultReftempInCnt(names)
            lines = readFistrModelCnt()
            reftempDefine = getReftempInCnt(lines) 
            #TreeItemを作成更新
            addReftempGroupInTreeData(names)
            treeList = [_(u"参照温度")]
        #output
        elif itemName == u"output":
            #itemNameを取得
            outputItems = []
            for name in names:
                outputItems.append(name.split(":")[1])
            #output_resの書き換え
            lines = readFistrModelCnt()
            i = pyFistr.getNextHeaderName(lines, 0, "!OUTPUT_RES", "")
            if i < len(lines):
                lines = pyFistr.delete1header(lines, i)
            else:
                i = pyFistr.getInsertPointInCnt(lines, "!OUTPUT_RES", ["Output"])
            addLines = ["!OUTPUT_RES" + ls]
            for item in outputItems:
                addLines += [item + ", ON" + ls]
            lines = lines[:i] + addLines + lines[i:]
            #output_visの書き換え(クリア)
            i = pyFistr.getNextHeaderName(lines, 0, "!OUTPUT_VIS", "")
            if i < len(lines):
                lines = pyFistr.delete1header(lines, i)
            #書き込み
            writeFistrModelCnt(lines)
        
        #output以外をtree表示
        if itemName != "output":
            #addTreeItemsSetを再作成
            # nStepのcurrNameを取得
            if len(cNames) == 0:
                #参照温度の様にstepが無い場合
                currNames = []
            else:
                if type(cNames[0]) == list:
                    #boundaryの様にstepがある場合
                    currNames = cNames[nStep]    
                else:
                    #stepがない場合
                    currNames = cNames
            newNames = names
            parentList = treeList
            self.remakeAddTreeItemsSet(parentList, currNames, newNames)
            #tree表示
            self.showTreeData(treeList)
        print(_("選択を確定しました。"))
        #flagを設定
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #  updateStepDefine
    def updateStepDefine(self, names, nStep, bndDefine):
        """ bndDefineを更新する"""
        for i in range(len(bndDefine), nStep+1):
            bndDefine.append([])
        bndDefine[nStep] = names
        return bndDefine


    #
    #  selectUnsetEachGrp
    #---------------------
    def selectUnsetEachGrp(self):
        """ setGrpのPage:非選択側を選択した時"""
        if self.maskEvent == True:
            return
        #非選択側を取得
        treeList = GtkParts.treeList(self.listBox_noGroup)
        unselGrps = treeList.getSelectedItems()
        if len(unselGrps) == 0:
            return
        #選択側を取得
        treeList = GtkParts.treeList(self.listBox_setGroup)
        selGrps = treeList.getSelectedItems()
        #groupを取得
        text = self.boundaryFrameNoset.get_label()
        #group別に確認
        if text[:len("nodeGroup")] == "nodeGroup":
            self.preSelectedActors = list(map(lambda x: "nodeGrp_" + x, unselGrps))
            self.selectedActors = list(map(lambda x: "nodeGrp_" + x, selGrps))
        elif text[:len("surfaceGroup")] == "surfaceGroup":
            self.preSelectedActors = list(map(lambda x: "surfaceGrp_" + x, unselGrps))
            self.selectedActors = list(map(lambda x: "surfaceGrp_" + x, selGrps))
        elif text[:len("elGroup")] == "elGroup":
            self.preSelectedActors = list(map(lambda x: "elementGrp_" + x, unselGrps))
            self.selectedActors = list(map(lambda x: "elementGrp_" + x, selGrps))
        else:
            self.preSelectedActors = []
            self.selectedActors = []
        self.showSelectedModel()

    #
    #  selectSetEachGrp
    #--------------------
    def selectSetEachGrp(self):
        """ setGrpのPage:選択側を選択した時"""
        if self.maskEvent == True:
            return
        #選択側を取得
        treeList = GtkParts.treeList(self.listBox_setGroup)
        selGrps = treeList.getSelectedItems()
        if len(selGrps) == 0:
            return
        #選択側を取得
        treeList = GtkParts.treeList(self.listBox_noGroup)
        unselGrps = treeList.getSelectedItems()
        text = self.boundaryFrameNoset.get_label()
        #group別に確認
        if text[:len("nodeGroup")] == "nodeGroup":
            self.preSelectedActors = list(map(lambda x: "nodeGrp_" + x, unselGrps))
            self.selectedActors = list(map(lambda x: "nodeGrp_" + x, selGrps))
        elif text[:len("surfaceGroup")] == "surfaceGroup":
            self.preSelectedActors = list(map(lambda x: "surfaceGrp_" + x, unselGrps))
            self.selectedActors = list(map(lambda x: "surfaceGrp_" + x, selGrps))
        elif text[:len("elGroup")] == "elGroup":
            self.preSelectedActors = list(map(lambda x: "elementGrp_" + x, unselGrps))
            self.selectedActors = list(map(lambda x: "elementGrp_" + x, selGrps))
        self.showSelectedModel()

    #
    #  applyBoundaryCont
    #  -----------------
    #    BOUNDARY内容を決定
    def applyBoundaryCont(self, event):
        global bndDefine

        def isDummyNgrp(ngrpName, meshCont):
            ans = False
            lines = meshCont.split("\n")
            for line in lines:
                words = line.split()
                if len(words) > 2:
                    if words[0] == "NGRP" and words[1] == "dummy_" + ngrpName:
                        ans = True
            return ans

        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        #設定
        ngrpName = self.getElGroupFromLabel(self.boundaryGrpLabel)
        bndCont = self.getBoundaryContFromTextBox()
        #cntファイルを要素typeに応じて修正
        meshCont = self.label_meshCnt.get_label()
        dummyNgrp = isDummyNgrp(ngrpName, meshCont)
        if dummyNgrp == False:
            #cntファイルをそのまま修正
            writeBoundaryContInCnt(ngrpName, bndCont, nStep)
            print (ngrpName + _(u"にBOUNDARYを設定しました"))
        else:
            #dummyNgrpも修正
            writeBoundaryContDummyInCnt(ngrpName, bndCont, nStep)
            print (ngrpName + ", dummy_" + ngrpName + _(u"にBOUNDARYを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #  getBoundaryContFromTextBox
    def getBoundaryContFromTextBox(self):
        ans = []
        if self.checkBtn_bndX.get_active() == True:
            val = self.textCtrl_bndX.get_text()
            if val == "":
                val = "0.0"
            ans += ["1, 1, " + val + ls]
        if self.checkBtn_bndY.get_active() == True:
            val = self.textCtrl_bndY.get_text()
            if val == "":
                val = "0.0"
            ans += ["2, 2, " + val + ls]
        if self.checkBtn_bndZ.get_active() == True:
            val = self.textCtrl_bndZ.get_text()
            if val == "":
                val = "0.0"
            ans += ["3, 3, " + val + ls]
        if self.checkBtn_Rx.get_active() == True:
            val = self.textCtrl_Rx.get_text()
            if val == "":
                val = "0.0"
            ans += ["4, 4, " + val + ls]
        if self.checkBtn_Ry.get_active() == True:
            val = self.textCtrl_Ry.get_text()
            if val == "":
                val = "0.0"
            ans += ["5, 5, " + val + ls]
        if self.checkBtn_Rz.get_active() == True:
            val = self.textCtrl_Rz.get_text()
            if val == "":
                val = "0.0"
            ans += ["6, 6, " + val + ls]
        return ans

    #
    #  applyCloadCont
    #  --------------
    #    CLOAD内容を決定
    def applyCloadCont(self, event):

        def isDummyNgrp(ngrpName, meshCont):
            #dummyのngrpがあるかチェック
            ans = False
            lines = meshCont.split("\n")
            for line in lines:
                words = line.split()
                if len(words) > 2:
                    if words[0] == "NGRP" and words[1] == "dummy_" + ngrpName:
                        ans = True
                        break
            return ans

        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        #設定
        ngrpName = self.getElGroupFromLabel(self.cloadGrpLabel)
        [cloadCont, valxyz] = self.getCloadContFromTextBox(ngrpName)
        #荷重の種類を読み取り
        forceType = self.getForceTypeOfCload()
        #荷重の種類に応じて値を修正
        cloadCont = self.changeForceForCload(cloadCont, ngrpName, forceType)
        #cntファイルを要素typeに応じて修正
        meshCont = self.label_meshCnt.get_label()
        dummyNgrp = isDummyNgrp(ngrpName, meshCont)
        if dummyNgrp == False:
            #cntファイルをそのまま修正
            writeCloadContInCnt(ngrpName, cloadCont, forceType, valxyz, nStep)
            print (ngrpName + _(u"に荷重を設定しました"))
        else:
            #dummyNgrpも修正
            writeCloadContDummyInCnt(ngrpName, cloadCont, forceType, valxyz, nStep)
            print (ngrpName + ", dummy_" + ngrpName + _(u"に荷重を設定しました"))
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #  getCloadContFromTextBox
    def getCloadContFromTextBox(self, ngrpName):
        #textBoxの値を取得
        valx = self.textCtrl_cloadX.get_text()
        if valx == "":
            valx = "0.0"
        valy = self.textCtrl_cloadY.get_text()
        if valy == "":
            valy = "0.0"
        valz = self.textCtrl_cloadZ.get_text()
        if valz == "":
            valz = "0.0"
        ans = []
        ans += ["1, " + valx + ls]
        ans += ["2, " + valy + ls]
        ans += ["3, " + valz + ls]
        if self.textCtrl_Mx.get_sensitive() == False:
            valMx = ""; valMy = ""; valMz = ""
        else:
            valMx = self.textCtrl_Mx.get_text()
            if valMx == "":
                valMx = "0.0"
            valMy = self.textCtrl_My.get_text()
            if valMy == "":
                valMy = "0.0"
            valMz = self.textCtrl_Mz.get_text()
            if valMz == "":
                valMz = "0.0"
            ans += ["4, " + valMx + ls]
            ans += ["5, " + valMy + ls]
            ans += ["6, " + valMz + ls]
        return [ans, [valx, valy, valz, valMx, valMy, valMz]]

    #  getForceTypeOfCload
    #    集中荷重の種類を取得
    def getForceTypeOfCload(self):
        forceType = "nodeForce"
        if self.radioBtn_aveForce.get_active() == True:
            forceType = "aveForce"
        elif self.radioBtn_trueForce.get_active() == True:
            forceType = "trueForce"
        return forceType

    #  changeForceForCload
    #    集中荷重の種類に応じて値を修正
    def changeForceForCload(self, cloadCont, ngrpName, forceType):
        if forceType == "nodeForce":
            #節点当たりの荷重の場合
            val = []
            for line in cloadCont:
                dummy = pyFistr.deleteSp(line)
                v = dummy.split(",")[1]
                val.append(v)
            print (_(u"各節点に(") + ", ".join(val) + _(u")をセットします"))
            return cloadCont

        elif forceType == "aveForce":
            #group内の合計荷重の場合
            #  group内のnode数を取得
            nNodes = getNodeNumOfNodeGroupInMesh(ngrpName)
            #  値をnode数除した値に修正
            if nNodes != 0:
                val = []
                for i in range(len(cloadCont)):
                    line = cloadCont[i]
                    line = pyFistr.deleteSp(line)
                    words = line.split(",")
                    words[1] = str(float(words[1])/nNodes)
                    cloadCont[i] = ", ".join(words) + ls
                    val.append(words[1])
                mess = _(u"節点数:") + str(int(nNodes)) + "  各節点に(" + ", ".join(val)
                mess += _(u")をセットします")
                print (mess)
            else:
                title = _(u"エラー")
                mess = _(u"group内のnode数が取得できません") + ls
                mess += _(u"meshFile内に指定したNGROUP名が存在しないか、")
                mess += _(u"node数がセットされていません。") + ls
                mess += _(u"入力値は、「節点当たりの荷重」としてセットします")
                self.errDialog(title, mess, parent=mainWindow)
            return cloadCont
        elif forceType == "trueForce":
            #均一な合計荷重の場合
            #numSettingDialog(10, "reading mesh file...")
            xyzForce = []
            for i in range(len(cloadCont)):
                line = cloadCont[i]
                line = pyFistr.deleteSp(line)
                words = line.split(",")
                xyzForce.append(words[1])
                words[1] = "0.0"
                cloadCont[i] = ", ".join(words) + ls
            #numSettingDialog(90, "ending...")
            return cloadCont

    #
    #  selectPressureType
    #---------------------
    def selectPressureType(self):
        """ 圧力の種類（radioButton）を選択した時に設定ボタン等を非表示設定にする"""
        if self.radioBtn_pressUniform.get_active() == True:
            self.selectPressUniform()
        else:
            self.selectPressDist()

    #
    #  selectPressUniform
    def selectPressUniform(self):
        """ 均一の圧力に設定する"""
        self.textCtrl_dload.set_sensitive(True)
        builder.get_object("label_pres_p15").set_sensitive(True)
        self.button_setPtc.set_sensitive(False)
        self.button_pressOpenFoam.set_sensitive(False)
        self.button_showPtcPress.set_sensitive(False)
        self.textCtrl_ptcFile.set_sensitive(False)
        self.textCtrl_ptcCoeff.set_sensitive(False)
        self.textCtrl_ptcShift.set_sensitive(False)
        builder.get_object("label_explaneOpenFoam_p15").set_sensitive(False)
        builder.get_object("label_timeField_p15").set_sensitive(False)
        builder.get_object("label_ptcFile_p15").set_sensitive(False)
        builder.get_object("label_coeff_p15").set_sensitive(False)
        builder.get_object("label_dload_shift").set_sensitive(False)
        builder.get_object("label_explaneCoeff_p15").set_sensitive(False)
        builder.get_object("label_dload_explainShift").set_sensitive(False)
        

    #
    #  selectPressDist
    def selectPressDist(self):
        """ 分布の圧力に設定する"""
        self.textCtrl_dload.set_sensitive(False)
        builder.get_object("label_pres_p15").set_sensitive(False)
        self.button_setPtc.set_sensitive(True)
        self.button_pressOpenFoam.set_sensitive(True)
        self.button_showPtcPress.set_sensitive(True)
        self.textCtrl_ptcFile.set_sensitive(True)
        self.textCtrl_ptcCoeff.set_sensitive(True)
        self.textCtrl_ptcShift.set_sensitive(True)
        builder.get_object("label_explaneOpenFoam_p15").set_sensitive(True)
        builder.get_object("label_timeField_p15").set_sensitive(True)
        builder.get_object("label_ptcFile_p15").set_sensitive(True)
        builder.get_object("label_coeff_p15").set_sensitive(True)
        builder.get_object("label_dload_shift").set_sensitive(True)
        builder.get_object("label_explaneCoeff_p15").set_sensitive(True)
        builder.get_object("label_dload_explainShift").set_sensitive(True)

    #
    #  setPtcFile
    #-------------
    def setPtcFile(self):
        """ 既存の点群fileを取得し設定する。"""
        title = _("点群fileを取得")
        currDir = getCurrDirFromTempFolder()
        filterSets = [[_("点群ファイル"), "*.particles"], [_("全てのファイル"), "*"]] 
        ptcFile = self.textCtrl_ptcFile.get_text()
        selName = ptcFile
        funcOk = [self.setPtcFileProcess]
        funcCancel = []
        self.openFileDialog(title, currDir, funcOk, funcCancel, mainWindow, selName, filterSets)

    #
    #  setPtcFileProcess
    def setPtcFileProcess(self, fileName):
        currDir = getCurrDirFromTempFolder()
        if os.path.dirname(fileName) != currDir:
            shutil.copy(fileName, currDir)
        #title, 内容を取得
        caseDir, time, region, field, patch = self.readOpenFoamContsFromPtcFile(fileName)
        if caseDir != "":
            #OpenFOAMの内容をlabelに表示
            self.setCaseDirTimeRegionFieldPatch(caseDir, time, region, field, patch)
        else:
            #OpenFOAM以外の内容を取得
            source, cont = self.readOthherContsFromPtcFile(fileName)
            conts = source + "\n" + cont
            builder.get_object("label_timeField_p15").set_label(conts)
        #ptcFileをtextBoxに反映
        ptcName = os.path.basename(fileName)
        self.textCtrl_ptcFile.set_text(ptcName)

    #
    #  createPtcOpenFoam
    #--------------------
    def createPtcOpenFoam(self):
        """ OpenFoamの結果から点群dataFileを作成する。"""
        currDir = getCurrDirFromTempFolder()
        ofCaseDir = currDir
        time = ""; region = ""; field = ""; patches = []
        ptcFileName = self.textCtrl_ptcFile.get_text()
        if ptcFileName != "":
            fileName = currDir + os.sep + ptcFileName
            if os.path.exists(fileName) == True:
                (caseDir, time, region, field, patches) = self.readOpenFoamContsFromPtcFile(fileName)
                if caseDir != "":
                    ofCaseDir = caseDir
        sgrp = self.dloadGrpLabel.get_text().split(":")[1]
        args = (ofCaseDir, time, region, field, patches)
        funcName = self.createPtcOpenFoam_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [sgrp, path, item]
        dialog = selectOpenFoamResultDDialog.selectOpenFoamResult(ofCaseDir, time, region, field, patches, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #
    #  createPtcOpenFoam_onDlg
    def createPtcOpenFoam_onDlg(self, ans, sgrp, path, item):
        """ dialogから起動される処理関数"""
        #pageをチェック
        self.showThisPageIfNotShow(path, item)
        #caseDirチェック
        (caseDir, time, region, field, patches) = ans
        if caseDir == "":
            return
        #処理開始
        #OpenFOAMの内容をtextCtrlに反映する。
        self.setCaseDirTimeRegionFieldPatch(caseDir, time, region, field, patches)
        #点群fileを作成する
        saveDir = os.getcwd()       #-----currDirを保存
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        self.textCtrl_ptcFile.set_text("")
        ptcFile = createPointCloudFromOpenFoam.createPointCloudOfPressure(
            caseDir, time, field, patches,
            region=region, fistrDir=currDir )
        os.chdir(saveDir)           #-----currDirを戻す
        ptcFileName = os.path.basename(ptcFile)
        self.textCtrl_ptcFile.set_text(ptcFileName)
        title = _("点群file作成")
        mess = _("点群file「") + ptcFileName + _("」を作成しました")
        self.okDialog(title, mess, parent=mainWindow)


    #
    #  showPtcPressure
    #------------------
    def showPtcPressure(self):
        """ 点群fileをvtuファイルに変換して、paraviewで表示する。"""
        ptcName = self.textCtrl_ptcFile.get_text()
        currDir = getCurrDirFromTempFolder()
        ptcFile = currDir + os.sep + ptcName
        if os.path.exists(ptcFile) == False or ptcName == "":
            title = _("エラー")
            mess = _("点群file「") + ptcName + _("」が存在しません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        caseDir = currDir
        # maxNum = 65
        # if len(caseDir) > maxNum:
        #     caseDir = "..." + caseDir[3-maxNum:]
        sgrpName = self.dloadGrpLabel.get_label().split(":")[1]
        (para, nCpu, nThread, version) = getParallelInSavedData()
        np = 1
        if para == "True":
            np = int(nCpu)
        np = np * int(nThread)
        vtuFile = mappingFromPointCloud.mappingPressureToVtu(caseDir, sgrpName, ptcFile, np)
        if vtuFile == "":
            title = _("エラー")
            mess  = _("点群dataがSGRPにmappingできません。") + ls
            mess += _("SGRP:") + sgrpName + _(" が点群内に含まれているか確認してください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #appDict = pyFistr.readUsingApplications()
        #paraview = appDict["paraView"]
        comm = runParaViewComm + " " + vtuFile
        print(comm)
        pyFistr.run(currDir).commandBG(comm)

    #
    #  applyDloadCont
    #  --------------
    #    DLOAD内容を決定
    def applyDloadCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        sgrpName = self.getElGroupFromLabel(self.dloadGrpLabel)
        #該当DLOADのheader行を取得
        dloadHeader = pyFistr.getDloadGrpHeaderLine(nStep, "S", sgrpName)
        #追加するAMPを取得
        ampName = pyFistr.getValName(dloadHeader, "AMP")
        if ampName != "":
            addAmp = ", AMP=" + ampName
        else:
            addAmp = ""
        #設定
        if self.radioBtn_pressUniform.get_active() == True:
            #均一な圧力設定
            #sgrpName = self.getElGroupFromLabel(self.dloadGrpLabel)
            dload = self.textCtrl_dload.get_text()
            if dload == "":
                dload = "0.0"
            addLines =  ["!DLOAD, GRPID=1" + addAmp + ls]
            addLines += [sgrpName + ", S, " + dload + ls]
            stat = "" 
        else:
            #mappingFileを設定
            ptcFileName = self.textCtrl_ptcFile.get_text()
            mapCoeff = self.textCtrl_ptcCoeff.get_text()
            mapShift = self.textCtrl_ptcShift.get_text()
            currDir = getCurrDirFromTempFolder()
            ptcFile = currDir + os.sep + ptcFileName
            if os.path.exists(ptcFile) == False or ptcFileName == "":
                stat = _("点群file「") + ptcFileName + _("」が存在しません。")
            else:                
                #sgrpName = self.getElGroupFromLabel(self.dloadGrpLabel)
                (para, nCpu, nThread, version) = getParallelInSavedData()
                np = 1
                if para == "True":
                    np = int(nCpu)
                np = np * int(nThread)
                mapFileDir = mappingFromPointCloud.mappingPressure(currDir, sgrpName, ptcFile, np)
                if mapFileDir != "":
                    stat = ""
                    mapFile = os.path.basename(mapFileDir)
                    addLines  = ["!DLOAD, GRPID=1, forceType=mapping, mapFile=" + mapFile +
                                 ", mapCoeff=" + mapCoeff + ", mapShift=" + mapShift + ls]
                    addLines += [sgrpName + ", S, 0.0" + ls]
                else:
                    stat  = _("点群dataがSGRPにmappingできません。") + ls
                    stat += _("SGRP:") + sgrpName + _(" が点群内に含まれているか確認してください。")
        if stat == "":
            writeDloadContInCnt(sgrpName, addLines, nStep)
            print (sgrpName + _(u"に面荷重を設定しました"))
        else:
            title = _("エラー")
            mess = stat
            self.errDialog(title, mess, parent=mainWindow)
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyVloadCont
    #  --------------
    #    VLOAD内容を決定
    def applyVloadCont(self, event):
        """ VLOADの設定を確定する。"""
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        egrpName = self.getElGroupFromLabel(self.vloadGrpLabel)
        #該当VLOAD行を取得
        vloadHeader = pyFistr.getDloadGrpHeaderLine(nStep, ["BX", "BY", "BZ"], egrpName)
        #追加するAMPを取得
        ampName = pyFistr.getValName(vloadHeader, "AMP")
        if ampName != "":
            addAmp = ", AMP=" + ampName
        else:
            addAmp = ""
        #設定
        values = []
        values.append(self.textCtrl_vloadBx.get_text())
        values.append(self.textCtrl_vloadBy.get_text())
        values.append(self.textCtrl_vloadBz.get_text())
        i = 0
        while i < 3:
            if deleteSp(values[i]) == "":
                values[i] == "0.0"
            i += 1
        addLines =  ["!DLOAD, GRPID=1" + addAmp + ls]
        addLines += [egrpName + ", BX, " + values[0] + ls]
        addLines += [egrpName + ", BY, " + values[1] + ls]
        addLines += [egrpName + ", BZ, " + values[2] + ls]
        writeVloadContInCnt(egrpName, addLines, nStep)
        print (egrpName + _(u"にVLOADを設定しました"))        
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyGravCont
    #  -------------
    #    GRAV内容を設定
    def applyGravCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        setName = self.gravGrpLabel.get_text().split(":")[1]
        #該当GRAVのheader行を取得
        gravHeader = pyFistr.getDloadGrpHeaderLine(nStep, "GRAV", setName)
        #追加するAMPを取得
        ampName = pyFistr.getValName(gravHeader, "AMP")
        if ampName != "":
            addAmp = ", AMP=" + ampName
        else:
            addAmp = ""
        #GRAVを設定する
        ax = self.textCtrl_gravX.get_text()
        ay = self.textCtrl_gravY.get_text()
        az = self.textCtrl_gravZ.get_text()
        values = [ax, ay, az]
        i = 0
        while i < 3:
            if deleteSp(values[i]) == "":
                values[i] == "0.0"
            i += 1
        x=float(values[0]); y=float(values[1]); z=float(values[2])
        g = pow((x*x + y*y + z*z), 0.5)
        ag = str(g)
        if g != 0:
            ax=str(x/g); ay=str(y/g); az=str(z/g)
        else:
            ax="0.0"; ay="0.0"; az="0.0"
        addLines =  ["!DLOAD, GRPID=1" + addAmp + ls]
        addLines += [setName + ", GRAV, " + ", ".join([ag, ax, ay, az]) + ls]
        writeGravContInCnt(setName, addLines, nStep)
        print (_(u"GRAVを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyCentCont
    #  -------------
    #    CENT内容を決定
    def applyCentCont(self, event):
        """ CENTの設定を確定する"""
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        egrpName = self.getElGroupFromLabel(self.centGrpLabel)
        #該当CENTのheader行を取得
        centHeader = pyFistr.getDloadGrpHeaderLine(nStep, "CENT", egrpName)
        #追加するAMPを取得
        ampName = pyFistr.getValName(centHeader, "AMP")
        if ampName != "":
            addAmp = ", AMP=" + ampName
        else:
            addAmp = ""
        #設定
        values = []
        values.append(self.textCtrl_centOm.get_text())
        values.append(self.textCtrl_centPx.get_text())
        values.append(self.textCtrl_centPy.get_text())
        values.append(self.textCtrl_centPz.get_text())
        values.append(self.textCtrl_centDx.get_text())
        values.append(self.textCtrl_centDy.get_text())
        values.append(self.textCtrl_centDz.get_text())
        i = 0
        while i < 7:
            if pyFistr.deleteSp(values[i]) == "":
                values[i] == "0.0"
            i += 1
        addLines =  ["!DLOAD, GRPID=1" + addAmp + ls]
        addLines += [egrpName + ", CENT, " + ", ".join(values) + ls]
        writeCentContInCnt(egrpName, addLines, nStep)
        print (egrpName + _(u"にCENTを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  switchUseResult
    #  ---------------
    #    熱解析結果を使用するかチェック
    def switchUseResult(self, event):
        if self.checkBtn_tempUseH.get_active() == False:
            #直接温度設定
            self.textCtrl_tempSet.set_sensitive(True)
            self.textCtrl_tempReadR.set_sensitive(False)
            self.textCtrl_tempSstep.set_sensitive(False)
            self.textCtrl_tempInterval.set_sensitive(False)
        else:
            #熱解析結果を使う
            self.textCtrl_tempSet.set_sensitive(False)
            self.textCtrl_tempReadR.set_sensitive(True)
            self.textCtrl_tempSstep.set_sensitive(True)
            self.textCtrl_tempInterval.set_sensitive(True)
            #元のcurrDirを取得
            currDir = getCurrDirFromTempFolder()
            os.chdir(currDir)
            #最終のstepNoを取得
            header = pyFistr.getHeaderName(FistrModelDict["res"])
            headerName = header.split("_")[0]
            #resFiles = glob.glob("FistrModel_temp.res.0.*")
            resFiles = glob.glob(headerName + "_temp.res.0.*")
            #環境を戻す
            currDir = currDirTemp
            os.chdir(currDirTemp)
            #stepNoを取得
            stepNos = []
            for resFile in resFiles:
                stepNo = resFile.split(".")[-1]
                try:
                    stepNos.append(int(stepNo))
                except:
                    pass
            if len(stepNos) == 0:
                maxStepNo = "1"
            else:
                stepNos.sort()
                maxStepNo = str(stepNos[-1])
            #値をセット
            if self.textCtrl_tempReadR.get_text() == "":
                if len(resFiles) > 0:
                    self.textCtrl_tempReadR.set_text(maxStepNo)
            if self.textCtrl_tempSstep.get_text() == "":
                if len(resFiles) > 0:
                    self.textCtrl_tempSstep.set_text(maxStepNo)
            if self.textCtrl_tempInterval.get_text() == "":
                if len(resFiles) > 0:
                    self.textCtrl_tempInterval.set_text("1")

    #
    #  applyTemperatureCont
    #  --------------------
    #    TEMPERATURE内容を設定
    def applyTemperatureCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        #TEMPERATUREを設定する
        #iniTemp = self.textCtrl_tempIni.get_text()
        temp = self.textCtrl_tempSet.get_text()
        readResult = self.textCtrl_tempReadR.get_text()
        sStep = self.textCtrl_tempSstep.get_text()
        interval = self.textCtrl_tempInterval.get_text()
        grpName = self.temperatureGrpLabel.get_text().split(":")[1]
        #入力データのチェック
        #if iniTemp == "":
        #    iniTemp = "0.0"
        if temp == "":
            temp = "0.0"
        if self.checkBtn_tempUseH.get_active() == False:
            #通常の計算
            addLines =  ["!TEMPERATURE, GRPID=1" + ls]
            #hecmw_ctrlの修正
            remakeNormalHecmwCtrl()
        else:
            #元のcurrDirを取得
            currDir = getCurrDirFromTempFolder()
            os.chdir(currDir)
            #熱解析結果を使用
            header = pyFistr.getHeaderName(FistrModelDict["res"])
            headerName = header.split("_")[0]
            #heatResFiles = glob.glob("FistrModel_temp.res.0.*")
            heatResFiles = glob.glob(headerName + "_temp.res.0.*")
            #環境を戻す
            currDir = currDirTemp
            os.chdir(currDirTemp)
            if len(heatResFiles) == 0:
                title = _(u"エラー")
                mess = _(u"熱伝導解析結果がありません") + ls
                mess += _(u"構造解析の前に熱伝導解析を行ってください")
                self.errDialog(title, mess, parent=mainWindow)
                return

            if readResult == "" or sStep == "" or interval == "":
                title = _(u"エラー")
                mess = _(u"熱伝導解析結果の読み込みに関するデータが入力されていません") + ls
                mess += _(u"データを入力してください")
                self.errDialog(title, mess, parent=mainWindow)
                return

            addLines = ["!TEMPERATURE, READRESULT=" + readResult + ", SSTEP=" + sStep + ", INTERVAL=" + interval + ", GRPID=1" + ls]
            #hecmw_ctrlの修正
            remakeHeatResultIn()

        addLines += [grpName + ", " + temp + ls]
        writeTemperatureContInCnt(grpName, addLines, nStep)
        print (_(u"TEMPERATUREをセットしました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applySpringCont
    #  ---------------
    #    SPRING内容を設定する
    def applySpringCont(self, event):

        def isDummyNgrp(ngrpName, meshCont):
            ans = False
            lines = meshCont.split("\n")
            for line in lines:
                words = line.split()
                if len(words) > 2:
                    if words[0] == "NGRP" and words[1] == "dummy_" + ngrpName:
                        ans = True
            return ans

        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        #設定
        ngrpName = self.getElGroupFromLabel(self.label_springGrp)
        x = ""
        if self.checkBtn_springX.get_active() == True:
            x = self.textCtrl_springX.get_text()
        y = ""
        if self.checkBtn_springY.get_active() == True:
            y = self.textCtrl_springY.get_text()
        z = ""
        if self.checkBtn_springZ.get_active() == True:
            z = self.textCtrl_springZ.get_text()
        rx = ""
        if self.checkBtn_springRX.get_active() == True:
            rx = self.textCtrl_springRX.get_text()
        ry = ""
        if self.checkBtn_springRY.get_active() == True:
            ry = self.textCtrl_springRY.get_text()
        rz = ""
        if self.checkBtn_springRZ.get_active() == True:
            rz = self.textCtrl_springRZ.get_text()
        if x=="" and y=="" and z=="" and rx=="" and ry=="" and rz=="":
            # #設定dialog閉じる
            # closeSettingDialog()
            title = _(u"エラー")
            mess = _(u"データが入力されていません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #該当部を削除
        lines = readFistrModelCnt()
        if nStep <= 0:
            #最初から検索
            i = 0
            ip = -1
            while i < len(lines):
                i = pyFistr.getNextHeaderName(lines, i, "!SPRING", "")
                if i < len(lines):
                    name = deleteSp(lines[i+1]).split(",")[0]
                    if name == ngrpName or name == "dummy_"+ngrpName:
                        ip = i
                        break
                i += 1
            if ip >= 0:
                lines = pyFistr.delete1header(lines, i)
        else:
            #途中から検索
            ip = -1
            i = skipStepId(lines, nStep)
            while i < len(lines):
                if lines[i][0] == "!" or lines[i][0] == "#":
                    ip = i
                    break
                i += 1
            if ip >= 0:
                lines = pyFistr.delete1header(lines, i)
        #追加する行を作成
        meshCont = self.label_meshCnt.get_label()
        dummyNgrp = isDummyNgrp(ngrpName, meshCont)
        if dummyNgrp == False:
            addLines = ["!SPRING, GRPID=1" + ls]
            if x != "":
                addLines += [ngrpName + ", 1, " + x + ls]
            if y != "":
                addLines += [ngrpName + ", 2, " + y + ls]
            if z != "":
                addLines += [ngrpName + ", 3, " + z + ls]
            if rx != "":
                addLines += [ngrpName + ", 4, " + rx + ls]
            if ry != "":
                addLines += [ngrpName + ", 5, " + ry + ls]
            if rz != "":
                addLines += [ngrpName + ", 6, " + rz + ls]
        else:
            #dummyに設定
            addLines = ["!SPRING, GRPID=1" + ls]
            if x != "":
                addLines += [ngrpName + ", 1, " + x + ls]
            if y != "":
                addLines += [ngrpName + ", 2, " + y + ls]
            if z != "":
                addLines += [ngrpName + ", 3, " + z + ls]
            if rx != "":
                addLines += ["dummy_"+ngrpName + ", 1, " + rx + ls]
            if ry != "":
                addLines += ["dummy_"+ngrpName + ", 2, " + ry + ls]
            if rz != "":
                addLines += ["dummy_"+ngrpName + ", 3, " + rz + ls]
        #行を追加
        i = pyFistr.getBndInsertPointInCnt(lines, "!SPRING", ["BOUNDARY", "Boundary", "boundary"], nStep)
        lines = lines[:i] + addLines + lines[i:]
        #GRPIDを修正
        lines = pyFistr.remakeGRPID(lines, "!SPRING")
        #書き込み
        writeFistrModelCnt(lines)
        print (ngrpName + _(u"にSPRINGをセットしました"))
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  addContactCondition
    #  -------------------
    #    contactをlistboxに追加
    def addContactCondition(self, event):
        #定義済のnameを取得
        names = self.getNamesInListmodel(self.listmodelSetContact)
        usedNames = getUsedContactNamesInCnt()
        names += usedNames
        #newNameを取得
        i = 0
        flag = ""
        while flag != "end":
            same = "no"
            for name in names:
                if name == "CP" + str(i):
                    same = "yes"
            if same == "yes":
                i += 1
            else:
                flag = "end"
        newName = "CP" + str(i)
        names = self.getNamesInListmodel(self.listmodelSetContact)
        names.append(newName)
        names.sort()
        self.setListDataInListBox(self.listmodelSetContact, self.listBox_setContact, names)
        #newNameを選択表示
        n = 0
        for name in names:
            if name == newName:
                break
            n += 1
        path = (n,)
        self.listBox_setContact.get_selection().select_path(path)

    #
    #  deleteContactConditions
    #  -----------------------
    #    contactをlistboxから削除
    def deleteContactConditions(self, event):
        names = self.getNamesInListmodel(self.listmodelSetContact)
        (listModel, pathList) = self.listBox_setContact.get_selection().get_selected_rows()
        if len(pathList) == 0:
            title = _(u"エラー")
            mess = _(u"削除するpairNameを選択してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #選択している名前を取得
        selNames = []
        for path in pathList:
            selName = names[path[0]]
            selNames.append(selName)
        #残す名前を取得
        remNames = []
        for name in names:
            flag = 0
            for selName in selNames:
                if name == selName:
                    flag = 1
                    break
            if flag == 0:
                remNames.append(name)
        #残った名前を表示
        self.setListDataInListBox(listModel, self.listBox_setContact, remNames)
        return

    #
    #  applyContact
    #  ------------
    #    contactのpairNameを決定
    def applyContact(self, event):
        global meshHeaderData
        nStep = self.getStepIdFromItem()         #stepIdを取得
        #設定
        names = self.getNamesInListmodel(self.listmodelSetContact)
        lines = readFistrModelCnt()
        #現在のGRPIDを取得
        grpids = getGrpidInNames(lines, "!CONTACT", names)
        #現在のpairNamesを取得
        currPairNames = getBoundaryNodeGroupInCnt(lines, "!CONTACT")
        #不要なpairNameを削除
        delNames = []
        for currName in currPairNames[nStep]:
            flag = 0
            for name in names:
                if name == currName:
                    flag = 1
                    break
            if flag != 1:
                delNames.append(currName)
        meshHeaderData = deleteContactPairNameInMsh(meshHeaderData, delNames)
        deleteContactInCnt(delNames, nStep, "all")
        writeFistrModelMshHeader()
        #新しいpairNamesを取得（cntファイルを再読み込み）
        lines = readFistrModelCnt()
        currPairNames = getBoundaryNodeGroupInCnt(lines, "!CONTACT")
        newPairNames = []
        for name in names:
            flag = 0
            for currName in currPairNames[nStep]:
                if name == currName:
                    flag = 1
                    break
            if flag == 0:
                newPairNames.append(name)
        #contact_Algoをチェック、無ければ追加
        i = 0
        flag = 0
        while i < len(lines):
            line = lines[i]
            if line[:len("!CONTACT_ALGO")] == "!CONTACT_ALGO":
                flag = 1
                break
            i += 1
        if flag == 0:
            #contact_Algoを追加
            ip = pyFistr.getInsertPointInCnt(lines, "!CONTACT_ALGO", ["Contact"])
            addLines =  ["!CONTACT_ALGO, TYPE=SLAGRANGE" + ls]
            lines = lines[:ip] + addLines + lines[ip:]
        #contact_Algoをセット
        nIter = self.comboBox_cntAlgo.get_active_iter()
        contactAlgo = self.comboBox_cntAlgo.get_model()[nIter][0]
        if contactAlgo[:len("SLAGRANGE")] == "SLAGRANGE":
            cntAlgo = "SLAGRANGE"
        elif contactAlgo[:len("ALAGRANGE")] == "ALAGRANGE":
            cntAlgo = "ALAGRANGE"
        else:
            cntAlgo = "ALAGRANGE"
        ip = pyFistr.getInsertPointInCnt(lines, "!CONTACT_ALGO", [])
        lines[ip] = abaqus2fistr.setValName(lines[ip], "TYPE="+cntAlgo)
        #defaultの新しいpairNamesを追加
        ip = pyFistr.getBndInsertPointInCnt(lines, "!CONTACT", ["Contact"], nStep)
        addLines = []
        for pairName in newPairNames:
            addLines += ["!CONTACT, GRPID=1, INTERACTION=FSLID, NTOL=1.0e-5, TTOL=1.0e-3" + ls]
            addLines += [pairName + ", 0.0, 1.0e5" + ls]
        lines = lines[:ip] + addLines + lines[ip:]
        #GRPIDを更新
        lines = pyFistr.remakeGRPID(lines, "!CONTACT")
        #STEP内のGRPIDを修正
        lines = remakeGrpidInStep(names, lines, "!CONTACT", grpids)
        #cntを保存
        writeFistrModelCnt(lines)
        #Treeを再作成
        global contactDefine
        contactDefine = getBoundaryNodeGroupInCnt(lines, "!CONTACT")
        addContactGroupInTreeData(contactDefine[nStep], nStep)
        if nStep == 0:
            treeList = [_(u"境界条件"), _(u"CONTACT（接触）")]
        else:
            treeList = [_(u"境界条件 ")+stepDefine[nStep], _(u"CONTACT（接触）")]
        #addTreeItemsSetを更新
        currNames = []
        for pairs in currPairNames:
            currNames += pairs
        newNames = names
        parentList = treeList
        self.remakeAddTreeItemsSet(parentList, currNames, newNames)
        #treeを表示
        self.showTreeData(treeList)
        print(_("接触ペア名を確定しました。"))
        #flagを設定
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  remakeAddTreeItemsSet
    def remakeAddTreeItemsSet(self, parentList, currNames, newNames):
        """ 親のTreeItem以下で、currNames→newNamesに変わった処理を行う
        self.addTreeItemsSet内から削除、追加を行う。"""
        parentTuple = tuple(parentList)
        #削除
        itemsTuple = tuple(self.addTreeItemsSet)
        for i in range(len(itemsTuple)):
            if itemsTuple[i][:-1] == parentTuple:
                name = itemsTuple[i][-1]
                if not name in newNames:
                    self.addTreeItemsSet.remove(itemsTuple[i])
        #追加
        addNames = list(set(newNames) - set(currNames))
        for addName in addNames:
            itemTuple = tuple(parentList + [addName])
            self.addTreeItemsSet.add(itemTuple)

    #
    #  changeContactType
    #---------------------
    def changeContactType(self, event):
        """ contactTypeを変更した時の処理。"""
        if self.radioBtn_pointToPoint.get_active() == True:
            slaveNames = meshGroup[2]
        else:
            slaveNames = meshGroup[1]
        slaveNames.sort()
        self.setComboDataInComboBox(self.listmodelCntSlave, self.comboBox_cntSlave, slaveNames)

    #
    #  applyContactCont
    #  ----------------
    #    CONTACT内容を決定
    def applyContactCont(self, event):
        global meshHeaderData
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        #設定
        newPairName = self.getElGroupFromLabel(self.contactGrpLabel)
        nSlave = self.comboBox_cntSlave.get_active_iter()
        nMaster = self.comboBox_cntMaster.get_active_iter()
        if nSlave == None or nMaster == None:
            title = _(u"エラー")
            mess = _(u"slave名、または、master名が入力されていません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        
        if self.radioBtn_pointToPoint.get_active() == True:
            contactType = "NODE-SURF"
        else:
            contactType = "SURF-SURF"
        slave = self.comboBox_cntSlave.get_model()[nSlave][0]
        master = self.comboBox_cntMaster.get_model()[nMaster][0]
        nIter = self.comboBox_cntIntr.get_active_iter()
        interaction = self.comboBox_cntIntr.get_model()[nIter][0]
        interaction = interaction.split()[0]
        nTol = self.textCtrl_cntNtol.get_text()
        tTol = self.textCtrl_cntTtol.get_text()
        coeff = self.textCtrl_cntCoeff.get_text()
        factor = self.textCtrl_cntFact.get_text()
        meshHeaderData = deleteContactPairNameInMsh(meshHeaderData, [selPairName])
        meshHeaderData = addContactPairNameInMsh(meshHeaderData, newPairName, contactType, slave, master)
        replaceContactInCnt(newPairName, interaction, nTol, tTol, coeff, factor, nStep)
        writeFistrModelMshHeader()
        #Tree作成
        if newPairName != selPairName:
            #Treeを再作成
            global contactDefine
            newDefine = []
            for name in contactDefine:
                if name == selPairName:
                    newDefine.append(newPairName)
                else:
                    newDefine.append(name)
            contactDefine = newDefine
            addContactGroupInTreeData(contactDefine, nStep)
            treeList = [_(u"境界条件"), _(u"CONTACT（接触）"), newPairName]
            self.showTreeData(treeList)
        print (_(u"CONTACTを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  selectSlaveGrp
    #-----------------
    def selectSlaveGrp(self):
        """ contact_subPage:slaveのcomboを選択した時"""
        #slave側
        nSlave = self.comboBox_cntSlave.get_active_iter()
        if nSlave == None:
            return
        slave = self.comboBox_cntSlave.get_model()[nSlave][0]
        if self.radioBtn_pointToPoint.get_active() == True:
            #node-surf
            if "nodeGrp_" + slave in self.preSelectedActors:
                return
            self.preSelectedActors = ["nodeGrp_" + slave]
        else:
            #surf-surf
            if "surfaceGrp_" + slave in self.preSelectedActors:
                return
            self.preSelectedActors = ["surfaceGrp_" + slave]
        #vtk再表示
        #master側
        nMaster = self.comboBox_cntMaster.get_active_iter()
        if nMaster != None:
            master = self.comboBox_cntMaster.get_model()[nMaster][0]
            self.selectedActors = ["surfaceGrp_" + master]
        self.showSelectedModel()

    #
    #  selectMasterGrp
    #------------------
    def selectMasterGrp(self):
        """ contact_subPage:masterのcomboを選択した時"""
        #master側
        nMaster = self.comboBox_cntMaster.get_active_iter()
        if nMaster == None:
            return
        master = self.comboBox_cntMaster.get_model()[nMaster][0]
        if "surfaceGrp_" + master in self.selectedActors:
            return
        #vtk再表示
        self.selectedActors = ["surfaceGrp_" + master]
        #slave側
        nSlave = self.comboBox_cntSlave.get_active_iter()
        if nSlave != None:
            slave = self.comboBox_cntSlave.get_model()[nSlave][0]
            if self.radioBtn_pointToPoint.get_active() == True:
                #node-surf
                self.preSelectedActors = ["nodeGrp_" + slave]
            else:
                #surf-surf
                self.preSelectedActors = ["surfaceGrp_" + slave]
        self.showSelectedModel()

    #
    #  renameContactPair
    #--------------------
    def renameContactPair(self):
        """ 接触ペア名の変更"""
        global selPairName, meshHeaderData, contactDefine
        #現在のペア名
        currCpName = self.getElGroupFromLabel(self.contactGrpLabel)
        #newNameを取得
        title = _("contactPair名の変更")
        mess = _("新しいcontactPair名を入力してください")
        iniText = currCpName
        funcOk = [self.renameContactPair_onDlg, currCpName]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()
        return
        
    #
    #  renameContactPair_onDlg
    def renameContactPair_onDlg(self, newCpName, currCpName):
        global selPairName, meshHeaderData, contactDefine
        """ 取得したnewCpNameを処理する。path,itemは使用しない。"""
        if newCpName == "":
            return
        newCpName = deleteSp(newCpName)
        #newNameのチェック
        currNames = []
        for header, data in meshHeaderData:
            if (header[:len("!CONTACT PAIR")] == "!CONTACT PAIR" or
                header[:len("!CONTACTPAIR")] == "!CONTACTPAIR"):
                name = abaqus2fistr.getValName(header, "NAME")
                currNames.append(name)
        if newCpName in currNames or len(newCpName) == 0:
            title = _("contactPair名の変更")
            mess = _("入力した名前は、設定できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #meshHeaderData内のペア名をnewCpNameに変更する
        for i in range(len(meshHeaderData)):
            header, data = meshHeaderData[i]
            if (header[:len("!CONTACT PAIR")] == "!CONTACT PAIR" or
                header[:len("!CONTACTPAIR")] == "!CONTACTPAIR"):
                cpName = abaqus2fistr.getValName(header, "NAME")
                if cpName == currCpName:
                    header = abaqus2fistr.setValName(header, "NAME=" + newCpName)
                    meshHeaderData[i][0] = header
                    writeFistrModelMshHeader()
                    break
        #cntFile内のcontactPair名をnewCpNameに変更
        lines = readFistrModelCnt()
        for i in range(len(lines)):
            line = lines[i]
            if line[:len("!CONTACT")] == "!CONTACT":
                i += 1
                line = lines[i]
                words = deleteSp(line).split(",")
                if words[0] == currCpName:
                    words[0] = newCpName
                    line = ", ".join(words) + ls
                    lines[i] = line
        writeFistrModelCnt(lines)
        #page内をnewCpNameに変更
        self.setElGroupToLabel(self.contactGrpLabel, newCpName)
        selPairName = newCpName
        #TreeDataを書き換え
        nStep = self.getStepIdFromItem()         #stepIdを取得
        contactDefine = getBoundaryNodeGroupInCnt(lines, "!CONTACT")
        addContactGroupInTreeData(contactDefine[nStep], nStep)
        #Tree書き換え
        if nStep == 0:
            addStep = ""
        else:
            addStep = " " + stepDefine[nStep]
        treeList = [_(u"境界条件")+addStep, _(u"CONTACT（接触）"), newCpName]
        self.showTreeData(treeList)
        #addTreeItemsSetを書き換え
        newItemTuple = tuple(treeList)
        currItemTuple = tuple(treeList[:-1] + [currCpName])
        if currItemTuple in self.addTreeItemsSet:
            self.addTreeItemsSet.remove(currItemTuple)
        self.addTreeItemsSet.add(newItemTuple)
        #treeItemをセット
        self.markButtonLabel()
        self.setAddTreeItemsSetCurrPage()

    #
    #  applyFloadCont
    #  --------------
    #    FLOAD内容を決定
    def applyFloadCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        ngrpName = self.getElGroupFromLabel(self.floadGrpLabel)
        floadCont = self.getFloadContFromTextBox()
        writeFloadContInCnt(ngrpName, floadCont, nStep)
        print (ngrpName + _(u"にFLOADを設定しました"))
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #  getFloadContFromTextBox
    def getFloadContFromTextBox(self):
        loadCase = self.textCtrl_floadCase.get_text()
        x = self.textCtrl_floadX.get_text()
        y = self.textCtrl_floadY.get_text()
        z = self.textCtrl_floadZ.get_text()
        values = [loadCase, [x, y, z]]
        return values

    #
    #  applyVeloCont
    #  -------------
    #    VELOCITY内容を決定
    def applyVeloCont(self, event):
        #VELOCITY
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        ngrpName = self.getElGroupFromLabel(self.label_veloGrp)
        x, y, z = "", "", ""
        if self.checkBtn_Vx.get_active() == True:
            x = self.textCtrl_veloX.get_text()
            if x == "":
                x = "0.0"
        if self.checkBtn_Vy.get_active() == True:
            y = self.textCtrl_veloY.get_text()
            if y == "":
                y = "0.0"
        if self.checkBtn_Vz.get_active() == True:
            z = self.textCtrl_veloZ.get_text()
            if z == "":
                z = "0.0"
        typeName = self.comboBox_velType.getSelectedItem()
        writeVeloContInCnt(ngrpName, [x, y, z, typeName], nStep)
        print (ngrpName + _(u"にVELOCITYを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyAccelCont
    #  --------------
    #    ACCELERATION内容を決定
    def applyAccelCont(self, event):
        #ACCELERATION
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        ngrpName = self.getElGroupFromLabel(self.label_accelGrp)
        x, y, z = "", "", ""
        if self.checkBtn_Ax.get_active() == True:
            x = self.textCtrl_accelX.get_text()
            if x == "":
                x = "0.0"
        if self.checkBtn_Ay.get_active() == True:
            y = self.textCtrl_accelY.get_text()
            if y == "":
                y = "0.0"
        if self.checkBtn_Az.get_active() == True:
            z = self.textCtrl_accelZ.get_text()
            if z == "":
                z = "0.0"
        writeAccelContInCnt(ngrpName, [x, y, z], nStep)
        print (ngrpName + _(u"にACCELERATIONを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyInitempCont
    #  ----------------
    #    INITEMP内容を決定
    def applyInitempCont(self, event):
        ngrpName = self.getElGroupFromLabel(self.label_initialGrp)
        iniTemp = self.textCtrl_initempTemp.get_text()
        writeInitempContInMsh(ngrpName, iniTemp)        
        print (ngrpName + _(u"にINITIALTEMPを設定しました"))        
        #clearFlag, clearButton
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyReftempValue
    #--------------------
    def applyReftempValue(self, event):
        """ REFTEMP（参照温度）を取得し適用"""
        reftemp = self.textCtrl_reftemp.get_text()
        addLines = ["!REFTEMP" + ls]
        addLines += [reftemp + ls]
        writeRefTempContInCnt(addLines)
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyFixtempCont
    #  ----------------
    #    FIXTEMP内容を決定
    def applyFixtempCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        ngrpName = self.getElGroupFromLabel(self.label_fixtempGrp)
        fixtemp = self.textCtrl_fixtemp.get_text()
        writeFixtempContInCnt(ngrpName, fixtemp, nStep)        
        print (ngrpName + _(u"にFIXTEMPを設定しました"))        
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyCfluxCont
    #  --------------
    #    CFLUX内容を設定
    def applyCfluxCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        ngrpName = self.getElGroupFromLabel(self.label_cfluxGrp)
        value = self.textCtrl_cflux.get_text()
        #集中熱量の種類を読み取り
        qwType = self.getQwTypeOfCflux()
        #集中熱量の種類に応じて値を修正
        cfluxCont = self.changeQwForCflux(value, ngrpName, qwType)
        writeCfluxContInCnt(ngrpName, cfluxCont, qwType, value, nStep)
        print (ngrpName + _(u"にCFLUXを設定しました"))        
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #  getQwTypeOfCflux
    #    集中熱量の種類を取得
    def getQwTypeOfCflux(self):
        qwType = "nodeQw"
        if self.radioBtn_aveQw.get_active() == True:
            qwType = "aveQw"
        elif self.radioBtn_trueQw.get_active() == True:
            qwType = "trueQw"
        return qwType

    #  changeQwForCflux
    def changeQwForCflux(self, value, ngrpName, qwType):
        if qwType == "nodeQw":
            print (_(u"各節点に(") + value + _(u")をセットします"))
            return value
        elif qwType == "aveQw":
            nNodes = getNodeNumOfNodeGroupInMesh(ngrpName)
            if nNodes != 0:
                value = str(float(value)/nNodes)
                mess = _(u"節点数:") + str(int(nNodes)) + "  各節点に(" + value
                mess += _(u")をセットします")
                print (mess)
            else:
                title = _(u"エラー")
                mess = _(u"group内のnode数が取得できません") + ls
                mess += _(u"meshFile内に指定したNGROUP名が存在しないか、")
                mess += _(u"node数がセットされていません。") + ls
                mess += _(u"入力値は、「節点当たりの熱量」としてセットします")
                self.errDialog(title, mess, parent=mainWindow)
            return value
        elif qwType == "trueQw":
            #numSettingDialog(10, "reading mesh file...")
            value = "0.0"
            #numSettingDialog(90, "ending...")
            return value

    #
    #  applySfluxCont
    #  --------------
    #    SFLUX内容を設定
    def applySfluxCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        sgrpName = self.getElGroupFromLabel(self.label_sfluxGrp)
        value = self.textCtrl_sflux.get_text()
        writeSfluxContInCnt(sgrpName, value, nStep)
        print (sgrpName + _(u"にSFLUXを設定しました"))        
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyDfluxCont
    #  --------------
    #    DFLUX内容を設定
    def applyDfluxCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        sgrpName = self.getElGroupFromLabel(self.label_dfluxGrp)
        faceNo = self.comboBox_dflux.getSelectedItem()
        value = self.textCtrl_dflux.get_text()
        values = [faceNo, value]
        writeDfluxContInCnt(sgrpName, values, nStep)
        print (sgrpName + _(u"にDFLUXを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applyBfCont
    #  --------------
    #    BF内容を設定
    def applyBfCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        egrpName = self.getElGroupFromLabel(self.label_bfGrp)
        value = self.textCtrl_bf.get_text()
        #writeDfluxContInCnt(egrpName, value, nStep)
        writeBfContInCnt(egrpName, value, nStep)
        print (egrpName + _(u"にBFを設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applySfilmCont
    #  --------------
    #    SFILM内容を設定
    def applySfilmCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        sgrpName = self.getElGroupFromLabel(self.label_sfilmGrp)
        value = self.textCtrl_sfilmVal.get_text()
        ambTemp = self.textCtrl_sfilmAmb.get_text()
        writeSfilmContInCnt(sgrpName, [value, ambTemp], nStep)
        print (sgrpName + _(u"にSFILMを設定しました"))        
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  applySradiateCont
    #  -----------------
    #    SRADIATE内容を設定
    def applySradiateCont(self, event):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        sgrpName = self.getElGroupFromLabel(self.label_sradiateGrp)
        value = self.textCtrl_sradiateVal.get_text()
        ambTemp = self.textCtrl_sradiateAmb.get_text()
        writeSradiateContInCnt(sgrpName, [value, ambTemp], nStep)
        print (sgrpName + _(u"にDRADIATEを設定しました"))        
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  switchAutoinc
    #----------------
    def switchAutoinc(self, event):
        """ autoincの設定を変更した場合、部品を表示・非表示設定を行う。"""
        #global autoincParamData
        if event.get_active() == True:
            #autoincの設定に変更した時
            self.hideFixincParts()
            self.showAutoincParts()
        else:
            #fixincの設定に変更した時
            self.hideAutoincParts()
            self.showFixincParts()

    #
    #  editAutoincParam
    #-------------------
    def editAutoincParam(self, event):
        """ autoincParamのを編集する"""
        global autoincParamData
        stepName = self.label_stepName.get_text()
        apName = "AP" + stepName[len("step"):]
        autoincParam = autoincParamData            
        #dialogを表示して取得設定
        funcName = self.editAutoincParam_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [path, item]
        dialog = autoincParamDDialog.autoincParam(autoincParam, funcName, funcArgs, parent=mainWindow)
        dialog.show()
        return

    #  editAutoincParam_onDlg
    def editAutoincParam_onDlg(self, autoincParam, path, item):
        global autoincParamData
        if len(autoincParam) == 0:
            return
        #pageをチェック
        self.showThisPageIfNotShow(path, item)
        #autoincParamをセットする。
        autoincParamData = autoincParam
        #labelに表示させる
        decLine = deleteSp(autoincParam[0]).split()[0]
        incLine = deleteSp(autoincParam[1]).split()[0]
        cutLine = deleteSp(autoincParam[2]).split()[0]
        self.label_decVal.set_text(("%-20s" % decLine)[:20])
        self.label_incVal.set_text(("%-20s" % incLine)[:20])
        self.label_cutbackVal.set_text(("%-20s" % cutLine)[:20])

    #
    #  setBCGroupForStep
    #  -----------------
    #    stepのgroupをセット
    def setBCGroupForStep(self, event):
        self.moveItemToListBoxStep(self.listBox_stepNoCnd, self.listmodelStepNoCnd,
                                   self.listBox_stepSetCnd, self.listmodelStepSetCnd)

    #
    #  returnBCGroupForStep
    #  --------------------
    #    stepのgroupを模です
    def returnBCGroupForStep(self, event):
        self.moveItemToListBoxStep(self.listBox_stepSetCnd, self.listmodelStepSetCnd,
                                   self.listBox_stepNoCnd, self.listmodelStepNoCnd)

    #
    #  setWriteAutoinc
    def setWriteAutoinc(self, stepName, timePoints, autoParam):
        """ autoincの設定を書き込む"""
        global autoincParamData
        #設定データを取得(dialog内)
        dTime = self.textCtrl_stepDtime.get_text()
        eTime = self.textCtrl_stepEtime.get_text()
        minDt = self.textCtrl_minDt.get_text()
        maxDt = self.textCtrl_maxDt.get_text()
        nRes = self.textCtrl_nRes.get_text()
        stepNo = stepName[len("step"):]
        #subStepsを計算で算出
        subSteps = str(int(float(eTime) / float(minDt)))
        self.textCtrl_stepSubStep.set_text(subSteps)
        #stepLineを修正
        lines = readFistrModelCnt()
        headerData = pyFistr.getHeaderData(lines)
        for i in range(len(headerData)):
            line = headerData[i][0]
            if line[:len("!STEP")].upper() == "!STEP":
                name = abaqus2fistr.getValName(line, "stepName")
                if name == stepName:
                    #!STEP行の設定内容を修正
                    line = abaqus2fistr.setValName(line, "INC_TYPE=AUTO")
                    line = abaqus2fistr.setValName(line, "TIMEPOINTS=TP" + stepNo)
                    line = abaqus2fistr.setValName(line, "AUTOINCPARAM=AP" + stepNo)
                    line = abaqus2fistr.setValName(line, "SUBSTEPS=" + subSteps)
                    headerData[i][0] = line
                    #stepのdeta部を作成
                    newData = ", ".join([dTime, eTime, minDt, maxDt]) + ls
                    headerData[i][1] = [newData] + headerData[i][1]
                    break
        #timePoints, autoParamsを削除
        tpHeader = []
        apHeader = []
        newHeaderData = []
        for header in headerData:
            line = header[0]
            if line[:len("!TIME_POINTS")].upper() == "!TIME_POINTS":
                if abaqus2fistr.getValName(line, "NAME") == "TP" + stepNo:
                    tpHeader = header
                    #pass    #該当部をpass
                else:
                    newHeaderData.append(header)
            elif line[:len("!AUTOINC_PARAM")].upper() == "!AUTOINC_PARAM":
                if abaqus2fistr.getValName(line, "NAME") == "AP" + stepNo:
                    apHeader = header
                    #pass    #該当部をpass
                else:
                    newHeaderData.append(header)    
            else:
                newHeaderData.append(header)
        headerData = newHeaderData[:]
        #timePointsを作成
        interval = str(float(eTime) / float(nRes))
        newLine = ", ".join([interval, eTime, interval]) + ls
        data = [newLine]
        header = "!TIME_POINTS, TIME=STEP, NAME=TP" + stepNo + ", GENERATE" + ls
        tpHeader = [header, data]
        #autoParamを作成
        header = "!AUTOINC_PARAM, NAME=AP" + stepNo + ls
        data = autoincParamData
        apHeader = [header, data]
        #stepの直前にtimePontsとautoParamを挿入
        for i in range(len(headerData)):
            line = headerData[i][0]
            if line[:len("!STEP"):].upper() == "!STEP":
                if abaqus2fistr.getValName(line, "stepName") == stepName:
                    ist = i
                    headerData = headerData[:ist] + [apHeader] + [tpHeader] + headerData[ist:]
                    break
        #計算結果出力間隔を修正
        #  !WRITE FREQUENCYで出力させない為
        for i in range(len(headerData)):
            header = headerData[i][0]
            if header[:len("!WRITE")] == "!WRITE":
                header = abaqus2fistr.setValName(header, "FREQUENCY=" + subSteps)
                headerData[i][0] = header
        #保存
        #pyFistr.writeHeaderData(headerData)
        writeHeaderDataToCnt(headerData)

    #
    # deleteAutoinc
    def deleteAutoinc(self, stepName):
        """ timePoints, autoParamを削除する"""
        #stepLineを修正
        lines = readFistrModelCnt()
        headerData = pyFistr.getHeaderData(lines)
        newHeaderData = []
        stepNo = stepName[len("step"):]
        for i in range(len(headerData)):
            header = headerData[i]
            line = header[0]
            if line[:len("!TIME_POINTS")].upper() == "!TIME_POINTS":
                if abaqus2fistr.getValName(line, "NAME") == "TP" + stepNo:
                    pass    #該当部をpass
                else:
                    newHeaderData.append(header)
            elif line[:len("!AUTOINC_PARAM")].upper() == "!AUTOINC_PARAM":
                if abaqus2fistr.getValName(line, "NAME") == "AP" + stepNo:
                    pass    #該当部をpass
                else:
                    newHeaderData.append(header)    
            else:
                newHeaderData.append(header)
        #書き込み
        #pyFistr.writeHeaderData(newHeaderData)
        writeHeaderDataToCnt(newHeaderData)

    #
    #  applyStepCont
    #  -------------
    #    STEP内容を決定
    def applyStepCont(self, event):
        global autoincParamData
        # #設定中dialog表示
        stepName = self.label_stepName.get_text()
        bndList = getStepBndListFromDefineData(stepName)
        nIter = self.comboBox_stepType.get_active_iter()
        stepType = self.comboBox_stepType.get_model()[nIter][0]
        converg = self.textCtrl_stepConv.get_text()
        subSteps = self.textCtrl_stepSubStep.get_text()
        maxIter = self.textCtrl_stepMaxIter.get_text()
        maxContIter = self.textCtrl_maxContIter.get_text()
        dTime = self.textCtrl_stepDtime.get_text()
        eTime = self.textCtrl_stepEtime.get_text()
        bnds = self.getNamesInListmodel(self.listmodelStepSetCnd)
        rBnds = reconstructStepBCCont(bnds, bndList)
        values = self.readStepNameValueFromCnt(stepName)
        #入れ替えるstepData内容を作成
        newLines =  ["!STEP, TYPE=" + stepType + ", CONVERG=" + converg +
                     ", SUBSTEPS=" + subSteps + ", MAXITER=" + maxIter +
                     ", MAXCONTITER=" + maxContIter + ", stepName=" + stepName + ls]
        if values[7] == "DYNAMIC":
            newLines += [dTime + ", " + eTime + ls]
        for bnd in rBnds:
            newLines += [bnd]

        #全step内容を取得
        stepDataLines = self.readStepDataLinesFromCnt()
        #stepName内の境界条件を取得
        for stepData in stepDataLines:
            if stepData[0] == stepName:
                bnLines = []
                for line in stepData[1]:
                    if line[:len("!STEP")] == "!STEP":
                        break
                    else:
                        bnLines.append(line)
        addLines = bnLines + newLines
        addData = [stepName, addLines]
        #addDataに入れ替え
        addStepDataLines = []
        for stepData in stepDataLines:
            if stepName != stepData[0]:
                addStepDataLines.append(stepData)
            else:
                addStepDataLines.append(addData)
        #入れ替えるstepLinesを作成
        newLines = []
        for stepData in addStepDataLines:
            newLines += stepData[1]
        #step内容を書き換える
        writeStepContInCnt(newLines)
        #autoincのチェック、設定
        if self.checkBtn_autoinc.get_active() == True:
            #AUTOの場合
            timePoints = values[11]
            autoParam = values[12]
            #autoincを読み取り、書き込む
            self.setWriteAutoinc(stepName, timePoints, autoParam)
        else:
            #FIXの場合：timePoints, autoincを削除
            self.deleteAutoinc(stepName)
            #autoincを初期値に戻す
            autoincParamData = defaultAutoincParamLines()
        print (_(u"STEPを設定しました"))       
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  addAmplitudeCont
    #  ----------------
    #    amplitudeをlistBoxに追加
    def addAmplitudeCont(self, event):
        job = self.label_ampName.get_text()
        if job == "AMPLITUDE":
            self.addAmpCont_sub("AMP")
        elif job == "STEP":
            self.addAmpCont_sub("STEP")

    def addAmpCont_sub(self, baseName):
        names = self.getNamesInListmodel(self.listmodelSetAmp)
        i = 0
        flag = ""
        while flag != "end":
            same = "no"
            for name in names:
                if name == baseName + str(i):
                    same = "yes"
            if same == "yes":
                i += 1
            else:
                flag = "end"
        newName = baseName + str(i)
        names.append(newName)
        names.sort()
        self.setListDataInListBox(self.listmodelSetAmp, self.listBox_setAmp, names)
        #newNameを選択表示
        n = 0
        for name in names:
            if name == newName:
                break
            n += 1
        path = (n,)
        self.listBox_setAmp.get_selection().select_path(path)

    #
    #  deleteAmplitudeCont
    #---------------------
    def deleteAmplitudeCont(self, event):
        """ amplitudeをlistBoxから削除"""
        names = self.getNamesInListmodel(self.listmodelSetAmp)
        (listModel, pathList) = self.listBox_setAmp.get_selection().get_selected_rows()
        if len(pathList) == 0:
            title = _(u"エラー")
            mess = _(u"削除するpairNameを選択してください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #選択している名前を取得
        selNames = []
        for path in pathList:
            selName = names[path[0]]
            selNames.append(selName)
        #残す名前を取得
        remNames = list(set(names) - set(selNames))
        #残った名前を表示
        self.setListDataInListBox(listModel, self.listBox_setAmp, remNames)
        return

    #
    #  applyAmplitude
    #  --------------
    #    amplitude、stepを決定(同じpageでampとstepを処理している)
    def applyAmplitude(self, event):
        job = self.label_ampName.get_text()
        if job == "AMPLITUDE":
            self.applyAmp_sub()
        elif job == "STEP":
            self.applyStep_sub()

    def applyAmp_sub(self):
        """ amplitudeを決定する"""
        global meshHeaderData
        names = self.getNamesInListmodel(self.listmodelSetAmp)
        #不要なampNameを削除（names以外のampを全て削除）
        deleteAmpWithoutNamesInCntMsh(names)
        #新しいampNameを取得
        currAmpNames = getAmpGroupInMsh()
        addNames = pyFistr.getNoGroups(names, currAmpNames)
        #defaultの新しいampNameをmshファイルに追加
        addHeaderData = []
        for addName in addNames:
            header = "!AMPLITUDE, NAME=" + addName + ls
            addData  = ["1.0, 0.0" + ls]
            addData += ["1.0, 0.1" + ls]
            addHeaderData.append([header, addData])
        meshHeaderData = meshHeaderData[:-1] + addHeaderData + meshHeaderData[-1:]
        writeFistrModelMshHeader()
        #Treeを再作成
        global ampDefine
        #  addTreeItemsSetを更新
        currNames = ampDefine[:]
        newNames = names
        parentList = [_(u"時間変化")]
        self.remakeAddTreeItemsSet(parentList, currNames, newNames)
        #  treeDataを作成
        ampDefine = getAmpGroupInMsh()
        addAmpGroupInTreeData(ampDefine)
        #  tree表示
        treeList = parentList
        self.showTreeData(treeList)
        print(_("amplitude名を確定しました。"))
        #flagを設定
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    def applyStep_sub(self):
        """ stepを決定する"""
        global stepDefine
        currNames = stepDefine
        #設定
        names = self.getNamesInListmodel(self.listmodelSetAmp)
        if len(names) == 0:
            stepDefine = []
            deleteStepContInCnt()
        else:
            stepDefine = []
            #全step内容を取得
            stepDataLines = self.readStepDataLinesFromCnt()
            #不要なstepNameを削除
            addStepDataLines = []
            for stepData in stepDataLines:
                stepName = stepData[0]
                if stepName in names:
                    addStepDataLines.append(stepData)
            #新しいstep内容を作成
            newStepDataLines = []
            for name in names:
                stepDefine.append(name)
                flag = 0
                for stepData in addStepDataLines:
                    stepName = stepData[0]
                    if name == stepName:
                        flag = 1
                        break
                if flag == 0:
                    line = "!STEP, TYPE=STATIC, CONVERG=1e-6, SUBSTEPS=1, MAXITER=1000, stepName=" + name + ls
                    newStepDataLines.append([name, [line]])
            #全てのstep内容を作成
            addStepDataLines += newStepDataLines
            addStepDataLines.sort()
            addLines = []
            for stepData in addStepDataLines:
                addLines += stepData[1]
            #step内容を置き換える
            writeStepContInCnt(addLines)
        self.setControlCont()                   #define変数を再取得
        addStepGroupInTreeData(names)           #TreeData作成
        self.setTreeFontColour(anaType)
        #addTreeItemsSetを設定
        newNames = names
        parentList = [_(u"ステップ解析")]
        self.remakeAddTreeItemsSet(parentList, currNames, newNames)
        #tree表示
        treeList = parentList
        self.showTreeData(treeList)
        print(_("step名を確定しました。"))
        #flagを設定
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  renameAmplitude
    #------------------
    def renameAmplitude(self):
        """ amp名の変更"""
        global meshHeaderData, ampDefine
        #現在のamp名
        currAmpName = self.getElGroupFromLabel(self.label_ampGrp)
        #newNameを取得
        title = _("amp名の変更")
        mess = _("新しいamp名を入力してください")
        iniText = currAmpName
        funcOk = [self.renameAmplitude_onDlg, currAmpName]
        funcCancel = []
        inputDialog = inputTextOkCancelDDialog.getInputText(title, mess, iniText, funcOk, funcCancel, parent=mainWindow)
        inputDialog.show()
        return
        
    #
    #  renameAmplitude_onDlg
    def renameAmplitude_onDlg(self, newAmpName, currAmpName):
        """ 取得したnewNameを処理する。path,itemは使用しない。"""
        global meshHeaderData, ampDefine
        if newAmpName == "":
            return
        newAmpName = deleteSp(newAmpName)
        #newNameのチェック
        currNames = []
        for header, data in meshHeaderData:
            if header[:len("!AMPLITUDE")] == "!AMPLITUDE":
                name = abaqus2fistr.getValName(header, "NAME")
                currNames.append(name)
        if newAmpName in currNames or len(newAmpName) == 0:
            mess = _("入力した名前は、設定できません。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #meshHeaderData内のamp名をnewNameに変更
        for i in range(len(meshHeaderData)):
            header, data = meshHeaderData[i]
            if header[:len("!AMPLITUDE")] == "!AMPLITUDE":
                name = abaqus2fistr.getValName(header, "NAME")
                if name == currAmpName:
                    header = abaqus2fistr.setValName(header, "NAME=" + newAmpName)
                    meshHeaderData[i][0] = header
                    writeFistrModelMshHeader()
                    break
        #cntFile内のamp名をnewNameに変更
        lines = readFistrModelCnt()
        findWord = "AMP=" + currAmpName
        for i in range(len(lines)):
            line = lines[i]
            if line[0] == "!":
                words = deleteSp(line).split(",")
                if findWord in words:
                    line = abaqus2fistr.setValName(line, "AMP=" + newAmpName)
                    lines[i] = line
        writeFistrModelCnt(lines)
        #ampDataFileのfile名変更
        currFileName = currDir + os.sep + currAmpName + "_ampData.csv"
        newFileName = currDir + os.sep + newAmpName + "_ampData.csv"
        if os.path.exists(currFileName) == True:
            os.rename(currFileName, newFileName)
        #page内をnewNameに変更
        self.setElGroupToLabel(self.label_ampGrp, newAmpName)
        #TreeDataを書き換え
        ampDefine = getAmpGroupInMsh()
        addAmpGroupInTreeData(ampDefine)
        #tree表示
        treeList = [_(u"時間変化"), newAmpName]
        self.showTreeData(treeList)
        #addTreeItemsSetを書き換え
        newItemTuple = tuple(treeList)
        currItemTuple = tuple(treeList[:-1] + [currAmpName])
        if currItemTuple in self.addTreeItemsSet:
            self.addTreeItemsSet.remove(currItemTuple)
        self.addTreeItemsSet.add(newItemTuple)
        #treeItemをセット
        self.markButtonLabel()
        self.setAddTreeItemsSetCurrPage()

    #
    #  applyAmplitudeCont
    #  ------------------
    #    ampを設定
    def applyAmplitudeCont(self, event):
        global meshHeaderData, currDir

        currDir = currDirTemp
        ampName = self.getElGroupFromLabel(self.label_ampGrp)
        setBnds = self.getNamesInListmodel(self.listmodelAmpSetGrp)
        valTypeNo = self.comboBox_ampValue.get_active()
        valType = "RELATIVE"
        if valTypeNo == 1:
            valType = "ABSOLUTE"
        #errorチェック
        fileName = ampName + "_ampData.csv"
        #if len(glob.glob(fileName)) == 0:
        if os.path.exists(fileName) == False:
            title = _(u"エラー")
            mess = _(u"ampDataが入力されていません")
            self.errDialog(title, mess, parent=mainWindow)
            return

        #cntファイルから設定しているamp名を削除
        lines = readFistrModelCnt()
        lines = deleteAmpNameInCnt(lines, ampName)
        #amp名をcntファイルにセット
        for setBnd in setBnds:
            i = searchSetBndInLines(lines, setBnd)
            if i < len(lines):
                lines[i] = abaqus2fistr.setValName(lines[i], "AMP="+ampName)
        writeFistrModelCnt(lines)
        #ampDataをmshファイルにセット
        ampData = getAmpDataInFile(fileName)
        ampData = ampData[:10]    #ampDataをshrinkする
        meshHeaderData = setAmpDataInMsh(meshHeaderData, ampName, valType, ampData)
        writeFistrModelMshHeader()
        print (ampName + _(u"を設定しました"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  editAmpData
    #  -----------
    #    ampData作成
    def editAmpData(self, event):
        ampName = self.label_ampGrp.get_label().split(":")[1]
        fileName = os.path.normpath(currDir + os.sep + ampName + "_ampData.csv")
        #if len(glob.glob(fileName)) == 0:
        if os.path.exists(fileName) == False:
            createAmpDataFile(ampName, fileName)
        comm = runOfficeComm + " " + fileName
        pyFistr.run().commandBG(comm)

    #
    #  setAmpBndGrp
    #  ------------
    #    ampGrpのセット
    def setAmpBndGrp(self, event):
        self.moveItemToListBox(self.listBox_ampNoGrp, self.listmodelAmpNoGrp,
                               self.listBox_ampSetGrp, self.listmodelAmpSetGrp)

    #
    #  returnAmpBndGrp
    #  ---------------
    #    ampGrpの削除
    def returnAmpBndGrp(self, event):
        self.moveItemToListBox(self.listBox_ampSetGrp, self.listmodelAmpSetGrp,
                               self.listBox_ampNoGrp, self.listmodelAmpNoGrp)

    #
    #  switchParallel
    #  --------------
    #    single, parallelのswitch
    def switchParallel(self, event):
        parallelSwitch = self.checkBtn_solvePara.get_active()
        if parallelSwitch == True:
            [para, nCpu, nThread, fistrVer] = getParallelInSavedData()
            loadHcmwPartCtrlDat()
            setHecmwContFromDat(para, nCpu)
            saveIstrData(["parallel True " + nCpu])
            self.textCtrl_solveNcpu.set_text(nCpu)
            setParallelHcmwCtrlDat(nCpu)
            self.label_nCpu.set_sensitive(True)
            self.textCtrl_solveNcpu.set_sensitive(True)
            self.button_separateMesh.set_sensitive(True)
        else:
            #singleの設定
            nCpu = self.textCtrl_solveNcpu.get_text()
            saveIstrData(["parallel False " + nCpu])
            hideHcmwPartCtrlDat()
            setSingleHcmwCtrlDat()
            self.label_nCpu.set_sensitive(False)
            self.textCtrl_solveNcpu.set_sensitive(False)
            self.button_separateMesh.set_sensitive(False)
        #FrontISTR実行ボタンのlabel設定
        self.setRunButtonLabel()

    #
    #  setRunButtonLabel
    def setRunButtonLabel(self):
        """ FrontISTRボタンのlabelを設定する"""
        parallel = self.checkBtn_solvePara.get_active()
        mess = _("FrontISTR実行")
        if parallel == True:
            mess += ls + _("(process並列)")
        self.button_solveFistr.set_label(mess)

    #
    #  createMultiJob
    #  --------------
    #    meshを分割する
    def createMultiJob(self, event):
        global currDir
        currDir = currDirTemp
        [para, nCpu] = getHecmwContFromDat()
        if para == False:
            title = _(u"エラー")
            mess = _(u"hecmw_part_ctrl.datファイルがありません") + ls
            mess += _(u"並列処理をチェックしてください")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #現在の設定を保存
        nCpu = self.textCtrl_solveNcpu.get_text()
        saveIstrData(["parallel True " + nCpu])
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #datファイルを転送
        datFiles = ["hecmw_ctrl.dat", "hecmw_part_ctrl.dat"]
        for datFile in datFiles:
            if os.path.exists(datFile) == True:
                shutil.copy(currDirTemp + os.sep + datFile, currDir)
        #mshファイルを転送
        copyMshFromTempToCurrDir()
        copyCntFromTempToCurrDir()
        #分割メッシュが残っていれば削除
        #header = pyFistr.getHeaderName(FistrModel_msh)
        header = pyFistr.getHeaderName(FistrModelDict["msh"])
        delNames = glob.glob(header + "_p*")
        #delNames =glob.glob("FistrModel_p*")
        if len(delNames) > 0:
            for name in delNames:
                os.remove(name)
        #計算結果を削除する
        self.deleteResultFoldersFiles(currDir)
        #nCpuをセット
        nCpu = self.textCtrl_solveNcpu.get_text()
        setHecmwContFromDat(para, nCpu)
        setParallelHcmwCtrlDat(nCpu)
        title = "separateMesh"
        comm = "hecmw_part1"
        commSet = "python3 " + pythonAppPath + "runCommandWithDialog2.py " + title + " " + comm
        pyFistr.run(currDir).commandBG(commSet)
        #datFileを戻す
        for datFile in datFiles:
            shutil.copy(currDir + os.sep + datFile, currDirTemp)
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  switchRestart
    #  -------------
    #    restartの設定
    def switchRestart(self, event):
        restart = self.checkBtn_solverRestart.get_active()
        setRestartInCnt(restart)

    #
    #  solveSet
    #  --------
    #    設定
    def solveSet(self, event):
        #logの出力取得
        if self.checkBtn_solveIlog.get_active() == True:
            iterLog = "YES"
        else:
            iterLog = "NO"
        if self.checkBtn_solveTlog.get_active() == True:
            timeLog = "YES"
        else:
            timeLog = "NO"
        #fistrVersionを取得
        if self.checkBtn_fistrVersion.get_active() == True:
            #!output_typeをコメントアウト
            self.outputTypeCommOut()
            fistrVer = "4.6"
        else:
            #!output_typeをVTKに設定
            self.outputTypeSetVTK()
            fistrVer = "5.0"
        #出力間隔取得
        freq = self.textCtrl_solveFreq.get_text()
        #設定をcntに書き込み
        setOutputLogInCnt(iterLog, timeLog, freq)
        #fistrVersionを書き込み
        dataLines = getSavedData()
        for i in range(len(dataLines)):
            line = dataLines[i]
            words = line.split()
            if len(words) > 1:
                if words[0] == "fistrVersion":
                    words[1] = fistrVer
                    newLine = " ".join(words) + "\n"
                    dataLines[i] = newLine
                    break
        saveIstrData(dataLines)
        print(_("solverの設定を確定しました。"))
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  outputTypeCommOut
    def outputTypeCommOut(self):
        """ 「!output_type」の行をコメントアウトする。Fistr-4.6用に設定する。"""
        lines = readFistrModelCnt()
        for i in range(len(lines)):
            header= lines[i]
            line = deleteSp(header).upper()
            if line[:len("!OUTPUT_TYPE=")] == "!OUTPUT_TYPE=":
                header = "#" + header
                lines[i] = header
                break
        writeFistrModelCnt(lines)

    #
    #  outputTypeSetVTK
    def outputTypeSetVTK(self):
        """ 「!output_type」の行を「!output_type=VTK」に設定する。Fistr-5.0用に設定する。"""
        lines = readFistrModelCnt()
        flag = 0
        for i in range(len(lines)):
            header= lines[i]
            line = deleteSp(header).upper()
            if line[:len("#!OUTPUT_TYPE=VTK")] == "#!OUTPUT_TYPE=VTK":
                line = header[1:]
                for ii in range(len(line)):
                    if line[ii] != " ":
                        break
                line = line[ii:]
                lines[i] = line
                flag = 1
                break
        if flag == 0:
            for i in range(len(lines)):
                header = lines[i]
                line = deleteSp(header).upper()
                if line[:len("!OUTPUT_TYPE=")] == "!OUTPUT_TYPE=":
                    line = "!output_type = VTK\n"
                    lines[i] = line
                    break
        writeFistrModelCnt(lines)

    #
    #  runFrontIstr
    #  ------------
    #    実行
    def runFrontIstr(self, event):

        def setCurrDirToTemp():
            global currDir
            currDir = currDirTemp
            os.chdir(currDirTemp)

        global currDir
        #設定内容を読み込み
        [para, nCpu] = getHecmwContFromDat()
        nThread = self.textCtrl_solveNthread.get_text()
        solType = getSolutitionTypeFromCnt()
        execFile = "fistr1"
        fistrComm = execFile
        try:
            if int(nThread) > 0:
                fistrComm += " -t " + nThread
            else:
                pass
        except:
            pass
        #nThreadを保存
        saveIstrData(["thread " + nThread])
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #appDictを取得
        appDict = pyFistr.readUsingApplications()
        #ファイルを転送
        preComm = "python3 " + pythonAppPath + "copyFilesFromTempToCurrDir.py "
        preComm += currDirTemp + " " + currDir + ls
        headerName = pyFistr.getHeaderName(FistrModelDict["res"])
        logFile = headerName + ".log"
        #並列の設定
        if para == True:
            #並列の場合
            if os.name == "nt":
                #fistrRun = "mpiexec -np " + nCpu + " " + fistrComm
                fistrRun = appDict["mpi"] + " -np " + nCpu + " " + fistrComm
                runComm  = "python3 " + pythonAppPath + "commTee.py "
                runComm += fistrRun
                runComm += " " + logFile
            else:
                #fistrRun = "mpirun -np " + nCpu + " " + fistrComm
                fistrRun = appDict["mpi"] +  " -np " + nCpu + " " + fistrComm
                runComm = fistrRun
                runComm += " | tee " + logFile
            #エラーチェック
            header = pyFistr.getHeaderName(FistrModelDict["msh"])
            meshes = glob.glob(header + "_p*")
            title = _(u"エラー")
            if len(meshes) == 0:
                mess = _(u"メッシュが並列計算用に分割されていません")
                self.errDialog(title, mess, parent=mainWindow)
                setCurrDirToTemp()
                return
            if len(meshes) != int(nCpu):
                mess = _(u"hecmw_part_ctrl.dat内のcpu数とメッシュ分割数が合致していません") + ls
                mess += _(u"メッシュは、") + str(len(meshes)) + _(u"分割されています")
                self.errDialog(title, mess, parent=mainWindow)
                setCurrDirToTemp()
                return
            if len(meshes) != int(self.textCtrl_solveNcpu.get_text()):
                mess = _(u"textBox内のcpu数とメッシュ分割数が合致していません") + ls
                mess += _(u"メッシュは、") + str(len(meshes)) + _(u"分割されています")
                self.errDialog(title, mess, parent=mainWindow)
                setCurrDirToTemp()
                return
            #core数をチェック
            try:
                nTh = int(nThread)
            except:
                nTh = 0
            try:
                allCores = int(nCpu) * nTh
            except:
                mess = _("並列数、thread数の入力値が間違っています。") + ls
                mess += _("入力し直してください。")
                self.errDialog(title, mess, parent=mainWindow)
                setCurrDirToTemp()
                return
            if allCores > multiprocessing.cpu_count():
                title = _("警告")
                mess = _("並列数（process数、thread数）がmachineのcore数を超えています。") + ls
                mess += _("このまま、続けますか?")
                funcOk = [self.runFrontIstrProcess, solType, preComm, runComm, fistrRun]
                funcCancel = [setCurrDirToTemp]
                self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
                return
            #frontIstr実行
            self.runFrontIstrProcess(solType, preComm, runComm, fistrRun)
        else:
            #シングル処理の場合
            #コマンド作成
            fistrRun = fistrComm
            if os.name == "nt":
                #windoes
                runComm = "python3 " + pythonAppPath + "commTee.py "
                runComm += fistrRun + " " + logFile
            else:
                #linux
                runComm = fistrRun + " | tee " + logFile
            #core数をチェック
            try:
                allCores = int(nThread)
            except:
                allCores = 0
            if allCores > multiprocessing.cpu_count():
                title = _("警告")
                mess = _("thread数がmachineのcore数を超えています。") + ls
                mess += _("このまま、続けますか?")
                funcOk = [self.runFrontIstrProcess, solType, preComm, runComm, fistrRun]
                funcCancel = [setCurrDirToTemp]
                self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
                return
            #frontIstr実行
            self.runFrontIstrProcess(solType, preComm, runComm, fistrRun)

    #
    #  runFrontIstrProcess
    def runFrontIstrProcess(self, solType, preComm, runComm, fistrRun):
        global currDir
        appDict = pyFistr.readUsingApplications()
        terminalRun = appDict["terminalRun"]
        #実行
        if os.name == "nt":
            #windows
            if solType == "EIGEN":
                runComm += ls + "copy 0.log eigen_log" + ls + runEditorComm + " eigen_log"
            elif solType == "DYNAMIC_F":
                runComm += ls + "python3 " + binAppPath + "createFreqResponseFile.py"
            runComm = preComm + runComm
            f=open("run.bat", "w"); f.write(runComm); f.close()
            #comm = "start run"
            comm = terminalRun + " run"
            pyFistr.run(currDir).commandBG(comm)
        else:
            #linux
            if solType == "EIGEN":
                runComm += ls + "cp 0.log eigen_log" + ls + runEditorComm + " eigen_log"
            elif solType == "DYNAMIC_F":
                runComm += ls + "python3 " + binAppPath + "createFreqResponseFile.py"
            runComm = preComm + runComm
            comm = "echo '" + runComm + "' > run; chmod a+x run"
            pyFistr.run(currDir).command(comm)
            #comm = "gnome-terminal -- bash --rcfile run &"
            comm = terminalRun + " bash --rcfile run &"
            pyFistr.run(currDir).commandBG(comm)
        #実行コマンド出力
        print(ls + runComm)
        #tempの環境に戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)
        print("FrontISTR (" + fistrRun + ") " + _("を実行しました。"))

    #
    #  plotStepMonitor
    #  ---------------
    #    plotStepMonitorを起動
    def plotStepMonitor(self, event):
        global currDir
        #anaTypeを取得
        lines = readFistrModelCnt()
        anaType = getAnalysisTypeInCnt(lines)
        #fistrVersionを取得
        fistrVer = self.getFistrVersionFromIstrData()
        ver = fistrVer[0]
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #plotMonitor開始
        if os.name == "nt":
            #windows
            runComm  = "python3 " + pythonAppPath + "plotStepMonitorDialog.py "
            runComm += " ".join([ver, anaType])
            pyFistr.run(currDir).commandBG(runComm)
        else:
            #linux
            runComm  = "python3 " + pythonAppPath + "plotStepMonitorDialog.py "
            runComm += " ".join([ver, anaType])
            pyFistr.run(currDir).commandBG(runComm)
        #環境を戻す
        os.chdir(currDirTemp)
        currDir = currDirTemp

    #
    #  getFistrVersionFromIstrData
    def getFistrVersionFromIstrData(self):
        """ frontIstrのversionをsavedDataから取得する"""
        savedLines = getSavedData()
        fistrVer = "5.0"
        for line in savedLines:
            words = line.split()
            if len(words) > 1:
                if words[0] == "fistrVersion":
                    fistrVer = words[1]
                    break
        return fistrVer

    #
    #  showHideInpRadButton
    #----------------------
    def showHideInpRadButton(self):
        """ inp,rad変換用ボタンの表示、非表示。"""
        if self.checkBtn_otherApp_pSolve.get_active() == True:
            #button表示
            self.button_convToInp.show()
            self.button_convToRad.show()
        else:
            #button非表示
            self.button_convToInp.hide()
            self.button_convToRad.hide()

    #
    #  convrtToInp
    #--------------
    def convertToInp(self):
        """ cnt,mshの設定内容をinp形式に変換する
        変換用のdialog表示"""
        inpName = "aba"
        currDir = getCurrDirFromTempFolder()
        funcOk = [self.convertToInp_run, currDir]
        dialog = convertToInpDDialog.getInpName(inpName, currDir, funcOk=funcOk, parent=mainWindow)
        dialog.show()

    #
    #  convertToInp_run
    def convertToInp_run(self, inpName, currDir):
        """ cnt,mshの設定内容をinp形式に変換する
        inpFile名を取得後、inp形式に変換。"""
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        cntName = FistrModel_cnt
        headerName = ".".join(cntName.split(".")[:-1])
        mshName = FistrModel_msh
        mshHeaderName = ".".join(mshName.split(".")[:-1])
        if headerName != mshHeaderName:
            title = _("エラー")
            mess = _("cnt,mshのheader名が異なっています。") + ls
            mess += _("  header名を合わせてください。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        #tempFileを転送する
        path = os.getenv("easyIstrPath") + os.sep + "python"
        comm = "python3 " + path + os.sep + "copyFilesFromTempToCurrDir.py "
        comm += currDirTemp + " " + currDir + ls
        pyFistr.run(currDir).command(comm)
        #inpNameの拡張子をチェック
        if inpName.split(".")[-1] == "inp":
            #.inp付きは、inpを削除
            inpName = ".".join(inpName.split(".")[:-1])
        #file名をチェック
        if os.path.exists(currDir + os.sep + inpName + ".inp") == True:
            title = _("fistr2abaqus.py 変換")
            mess  = _("指定したfile名と同じfileが存在します。") + "\n"
            mess += "  " + _("継続すると、file内容が書き換わります。") + "\n\n"
            mess += "  " + _("このまま継続しますか？")
            funcOk = [self.convertToInp_runCommand, currDir, headerName, inpName]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        #変換開始
        self.convertToInp_runCommand(currDir, headerName, inpName)    
        
    #  convertToInp_runCommand
    def convertToInp_runCommand(self, currDir, headerName, inpName):
        """ command実行"""
        #変換開始
        path = os.getenv("easyIstrPath") + os.sep + "bin"
        comm  = "python3 "
        comm += path + os.sep + "fistr2abaqus.py"
        comm += " -i " + headerName + " -o " + inpName
        print(comm)
        stat, resCont, errCont = pyFistr.run(currDir).commandReturnCont(comm, isOut=False)
        if stat == "OK":
            title = _("fistr2abaqus.py 変換")
            mess = _("FrontISTR形式をinp形式に変換しました。") + ls
            mess += "  " + inpName + ".inp ファイルを作成しました。"
            self.okDialog(title, mess, parent=mainWindow)
        else:
            title = _("エラー")
            mess = _("errorが発生しました。") + ls
            mess += _("logを確認してください。")
            self.errDialog(title, mess, parent=mainWindow)

    #
    #  convertToRad
    #----------------
    def convertToRad(self):
        """ cnt,mshの設定内容をrad形式に変換する。"""
        #tempの内容をcurrDirに保存する
        currDir = getCurrDirFromTempFolder()
        cntName = FistrModel_cnt
        headerName = ".".join(cntName.split(".")[:-1])
        funcOk = [self.convertToRad_run, currDir]
        dialog = convertToRadiossDDialog.getRadName(headerName, currDir, funcOk=funcOk, parent=mainWindow)
        dialog.show()

    #
    #  convertToRad_run
    def convertToRad_run(self, radName, option, currDir):
        """ cnt,mshの設定内容をrad形式に変換する
        radHeaderFile名を取得後、rad形式に変換。"""
        #radNameをチェック
        ext = radName.split(".")[-1]
        if ext == "rad" or ext == "inc":
            #radName = ".".join(radName.split(".")[:-1])
            radName = radName[:-len("_0000.rad")]
        #変数設定
        radName = radName.strip()
        #file名チェック
        names = [radName + "_0000.inc", 
                 radName + "_0000.rad",
                 radName + "_0001.rad"]
        flag = 0
        for name in names:
            fileName = currDir + os.sep + name
            if os.path.exists(fileName) == True:
                flag = 1
                break
        if flag == 1:
            #dialog表示
            title = _("fistr2rad.py 変換")
            mess  = _("指定したfile名と同じfileが存在します。") + "\n"
            mess += "  " + _("継続すると、file内容が書き換わります。") + "\n\n"
            mess += "  " + _("このまま継続しますか？")
            funcOk = [self.convertToRad_runCommand, currDir, radName, option]
            funcCancel = []
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
        #変換開始
        self.convertToRad_runCommand(currDir, radName, option)

    #  convertToRad_runCommand
    def convertToRad_runCommand(self, currDir, radName, option):
        """ rad変換のcommand実行"""
        #tempFileを転送する
        #currDir = getCurrDirFromTempFolder()
        path = os.getenv("easyIstrPath") + os.sep + "python"
        comm = "python3 " + path + os.sep + "copyFilesFromTempToCurrDir.py "
        comm += currDirTemp + " " + currDir + ls
        pyFistr.run(currDir).command(comm)
        #option取得
        option2 = option.strip()
        if radName == "":
            option1 = ""
        else:
            option1 = " -inc " + radName + " -rad " + radName
        #変換開始
        path = os.getenv("easyIstrPath") + os.sep + "bin"
        comm  = "python3 "
        comm += path + os.sep + "fistr2rad.py"
        comm += " " + option1 + " " + option2
        print(comm)
        stat, resCont, errCont = pyFistr.run(currDir).commandReturnCont(comm, isOut=False)
        if resCont.upper().find("ERROR") > 0:
            stat = "NG"
        if stat == "OK":
            title = _("fistr2rad.py 変換")
            mess = _("FrontISTR形式をOpenRadioss形式に変換しました。") + ls
            mess += "  " + radName + "_0000.inc" + ls
            mess += "  " + radName + "_0000.rad" + ls
            mess += "  " + radName + "_0001.rad ファイルを作成しました。"
            self.okDialog(title, mess, parent=mainWindow)
        else:
            title = _("エラー")
            mess = _("errorが発生しました。") + ls
            mess += _("logを確認してください。")
            self.errDialog(title, mess, parent=mainWindow)


    #
    #  applySolverCont
    #  ---------------
    #    solver内容を決定
    def applySolverCont(self, event):
        nIter = self.comboBox_slinMethod.get_active_iter()
        method = self.comboBox_slinMethod.get_model()[nIter][0]
        precond = self.textCtrl_slinPrecond.get_text()
        nIter = self.textCtrl_slinNiter.get_text()
        resid = self.textCtrl_slinResid.get_text()
        lines = readFistrModelCnt()
        i = pyFistr.getNextHeaderName(lines, 0, "!SOLVER", "")
        lines[i] = abaqus2fistr.setValName(lines[i], "METHOD="+method)
        lines[i] = abaqus2fistr.setValName(lines[i], "PRECOND="+precond)
        i += 1
        words = deleteSp(lines[i]).split(",")
        words[0] = nIter
        lines[i] = ", ".join(words) + ls
        i += 1
        words = deleteSp(lines[i]).split(",")
        words[0] = resid
        lines[i] = ", ".join(words) + ls
        writeFistrModelCnt(lines)
        print (_(u"線形solverの設定を変更しました"))
        # #設定dialog閉じる
        # closeSettingDialog()
        #flagをクリア
        self.clearSetFlagInTree()
        self.clearButtonLabel()

    #
    #  resultMerge
    #  -----------
    #    分散している結果を結合する
    def resultMerge(self, event):
        global currDir
        #解析typeを確認
        nameDict = pyFistr.getCntMshFileNameDict(os.getcwd())
        resFileHeader = nameDict["res"].split(".")[0]
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #結果をmerge
        if len(glob.glob(os.path.normpath(currDir + os.sep + resFileHeader + ".res.1*"))) == 0:
            title = _(u"エラー")
            mess = _(u"並列処理した計算結果ではありません")
            self.errDialog(title, mess, parent=mainWindow)
            return
        nCpu = self.textCtrl_postNProcs.get_text()
        if self.checkBtn_postPara.get_active() == True:
            addPara = " -para yes -np " + nCpu
        else:
            addPara = " -para no"
        title = "mergeResult"
        comm  = "python3 " + binAppPath + "mergeResFiles.py -res " + resFileHeader
        comm += addPara
        commVar = '"' + comm + '"'
        commSet = "python3 " + pythonAppPath + "runCommandWithDialog2.py " + title + ' "' + comm + '"'
        pyFistr.run(currDir).commandBG(commSet)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  setUseVtkOrVtu
    def setUseVtkOrVtu(self):
        """ radioBtnの状況によって、設定ボタンの表示を設定する"""
        if self.radioBtn_useVtk.get_active() == True:
            self.selectUseVtk()
        else:
            self.selectUseVtu()

    #
    #  selectUseVtk
    #---------------
    def selectUseVtk(self):
        """ resファイルをvtk変換を設定する"""
        self.button_convResult.set_sensitive(False)
        self.button_runParaView.set_sensitive(False)
        self.button_resultMerge46.set_sensitive(True)
        self.button_convResult46.set_sensitive(True)
        self.button_runParaView46.set_sensitive(True)
        #builder.get_object("label_under46Para_p37").set_sensitive(True)
        builder.get_object("label_mergeMethod_p37").set_sensitive(True)        
        builder.get_object("label_under46Conts_p37").set_sensitive(True)        
        builder.get_object("label_legParaview_p37").set_sensitive(True)        
        #builder.get_object("label_paraview_p37").set_sensitive(False)
        builder.get_object("label_fistr5_p37").set_sensitive(False)
        builder.get_object("label_convVtu_p37").set_sensitive(False)
        builder.get_object("label_xmlParaview_p37").set_sensitive(False)

    #
    #  selectUseVtu
    #---------------
    def selectUseVtu(self):
        """ vtuをそのまま使うに設定する"""
        self.button_convResult.set_sensitive(True)
        self.button_runParaView.set_sensitive(True)
        self.button_resultMerge46.set_sensitive(False)
        self.button_convResult46.set_sensitive(False)
        self.button_runParaView46.set_sensitive(False)
        #builder.get_object("label_under46Para_p37").set_sensitive(False)
        builder.get_object("label_mergeMethod_p37").set_sensitive(False)        
        builder.get_object("label_under46Conts_p37").set_sensitive(False)        
        builder.get_object("label_legParaview_p37").set_sensitive(False)        
        #builder.get_object("label_paraview_p37").set_sensitive(True)
        builder.get_object("label_fistr5_p37").set_sensitive(True)
        builder.get_object("label_convVtu_p37").set_sensitive(True)
        builder.get_object("label_xmlParaview_p37").set_sensitive(True)

    #
    #  convertResult46
    #-------------------
    def convertResult46(self, event):
        """ Fistr4.6用の出力形式をlegacy format のVTKに変換する。
        Fistr5.0以降でも使用可。"""
        global currDir
        #並列処理を取得
        if self.checkBtn_postPara.get_active() == True:
            para = True
            nCpu = self.textCtrl_postNProcs.get_text()
        else:
            para = False
            nCpu = "1"
        values = [para, nCpu]
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        error = convertDataForParaview46(values)
        if error != "":
            print(error)
            title = _("エラー")
            self.errDialog(title, error, parent=mainWindow)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  convertResultData
    #  -----------------
    #    結果fileをparaView用にデータ変換
    def convertResultData(self, event):
        """ fistr-5.0用の変換(vtu変換)"""

        def setCurrDirToTemp():
            global currDir
            currDir = currDirTemp
            os.chdir(currDirTemp)

        global currDir
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #logファイルからFistrのversionを取得
        fistrVer = self.getFistrVersionFromLogFile()
        if fistrVer != "5.0":
            mess = _("ver5の計算結果をvtk変換") + ls
            mess += _("出力形式のversionが不明です。") + ls
            mess += _("  このままver5として変換しますか？")
            title = _("vtk変換")
            funcOk = [self.convertResultDataProcess]
            funcCancel = [setCurrDirToTemp]
            self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=mainWindow)
            return
            # stat = self.okCancelDialog(title, mess)
            # if stat != "OK":
            #     currDir = currDirTemp
            #     os.chdir(currDirTemp)
            #     return
        #変換開始
        self.convertResultDataProcess()
    
    #
    #  convertResultDataProcess
    def convertResultDataProcess(self):
        global currDir
        #並列処理確認
        parallel = self.checkBtn_postPara.get_active()
        nCpu = "1"
        if parallel == True:
            nCpu = self.textCtrl_postNProcs.get_text()
        values = [parallel, nCpu]
        #データ変換
        error = convertDataForParaview(values)
        if error != "":
            print (error)
            title = _(u"エラー")
            self.errDialog(title, error, parent=mainWindow)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  getFistrVersionFromLogFile
    def getFistrVersionFromLogFile(self):
        """ FistrModel.logファイルから、fistrVersionを取得。
        logFileが存在しない場合は、vtuファイル有無で判断する。"""
        headerName = pyFistr.getHeaderName(FistrModelDict["res"])
        #logFile = "FistrModel.log"
        logFile = headerName + ".log"
        if os.path.exists(logFile) == False:
            fistrVer = "5.0"
            visHeader = FistrModelDict["vis"]
            #if len(glob.glob("FistrModel.vis_psf.000.*")) == 0:
            if len(glob.glob(visHeader + "_psf.*")) == 0:
                #if len(glob.glob("FistrModel.res.*")) > 0:
                resHeader = FistrModelDict["res"]
                if len(glob.glob(resHeader + ".*")) > 0:
                    #vtuが無くresファイルが存在する場合
                    fistrVer = "4.6"
            return fistrVer
        #logFileの内容を確認 
        f = open(logFile, encoding="utf-8"); cont = f.read(2000); f.close()
        lines = cont.split("\n")
        fistrVer = "4.6"
        for line in lines:
            words = line.split()
            if len(words) > 1:
                if words[0].upper() == "VERSION:":
                    fistrVer = "5.0"
                    break
        return fistrVer

    #
    #  runParaView46
    #----------------
    def runParaView46(self, event):
        """ Fistr-4.6用のparaView起動"""
        global currDir
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #計算結果の内容を取得
        values = getHecmwContFromDat()
        parallel = values[0]
        fileHeader = "convFistrModel"
        if anaType == "EIGEN":
            fileHeader += "_eigen"
        elif anaType == "HEAT" or anaType== "HEAT_D":
            fileHeader += "_temp"
        fileHeader += ".res"
        if parallel == True:
            fileHeader += ".merge"
            para = u"有り"
        else:
            fileHeader += ".0"
            para = u"なし"
        fileNames = glob.glob(fileHeader + "*.vtk")
        if len(fileNames) == 0:
            fileName = ""
        elif len(fileNames) == 1:
            fileName = fileNames[0]
        else:
            fileName = fileHeader + "...vtk"
        print("解析:" +  anaType + " 並列:" + para + "  の結果「" + fileName + "」を開きます。")
        comm = runParaViewComm + " " + fileName
        #pyFistr.runAppBG(comm)
        pyFistr.run(currDir).commandBG(comm)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  runParaView
    #  -----------
    #    paraViewの起動
    def runParaView(self, event):
        global currDir
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        #計算結果の内容を取得
        nameDict = pyFistr.getCntMshFileNameDict(currDir)
        visFileHeader = nameDict["vis"]
        fileNames = glob.glob(visFileHeader + "_psf.*.pvtu")
        if len(fileNames) == 0:
            fileName = ""
        elif len(fileNames) == 1:
            fileName = fileNames[0]
        else:
            fileName = visFileHeader + "_psf...pvtu"
        print (_(u"解析:") +  anaType + _(u"  の結果「") + fileName + _(u"」を開きます。"))
        comm = runParaViewComm + " " + fileName
        #pyFistr.runAppBG(comm)
        pyFistr.run(currDir).commandBG(comm)
        #環境を戻す
        currDir = currDirTemp
        os.chdir(currDirTemp)

    #
    #  showHideInpVtuButton
    #-----------------------
    def showHideInpVtuButton(self):
        """ calculixの計算結果をvtuに変換するbuttonの表示非表示"""
        if self.checkBtn_otherApp_pPost.get_active() == True:
            #button表示
            self.button_convInpToVtu.show()
        else:
            #button非表示
            self.button_convInpToVtu.hide()

    #
    #  convertInpResToVtu
    #------------------
    def convertInpResToVtu(self):
        """ calculixの計算結果をvtu変換する
        dialogを表示して、file名を取得。"""
        #元のcurrDirを取得
        currDir = getCurrDirFromTempFolder()
        funcOk = [self.convertInpResToVtu_run, currDir]
        dialog = convertInpResToVtuDDialog.getInpResName(currDir, funcOk=funcOk, parent=mainWindow)
        dialog.show()

    #
    #  convertInpResToVtu_run
    def convertInpResToVtu_run(self, fileName_ext, currDir):
        """ calculixの計算結果をvtu変換する
        fullPathのinpFile名を取得して、vtu変換する。"""
        fileName, extName = fileName_ext
        absName = currDir + os.sep + fileName
        if os.path.exists(absName) == False:
            title = _("エラー")
            name = absName.split(".")[-1]
            mess = name + _("Fileが取得できませんでした。")
            self.errDialog(title, mess, parent=mainWindow)
            return
        inpName = fileName
        #inp?
        if extName == "inp":
            #inp,datからvtu変換
            inpHeader = ".".join(inpName.split(".")[:-1])
            datFile = currDir + os.sep + inpHeader + ".dat"
            if os.path.exists(datFile) == False:
                title = _("エラー")
                mess = _("計算結果が取得できませんでした。")
                self.errDialog(title, mess, parent=mainWindow)
                return
            path = os.getenv("easyIstrPath") + os.sep + "bin"
            comm  = "python3 "
            comm += path + os.sep + "createAbaVtu.py -i "
            comm += inpHeader
            print(comm)
            run = pyFistr.run(currDir)
            stat, resCont, errCont = run.commandReturnCont(comm, isOut=False)
        #frd?
        elif extName == "frd":
            #frdから変換
            inpHeader = ".".join(inpName.split(".")[:-1])
            path = os.getenv("easyIstrPath") + os.sep + "bin"
            comm  = "python3 "
            comm += path + os.sep + "frd2vtu.py -i "
            comm += inpHeader
            print(comm)
            run = pyFistr.run(currDir)
            stat, resCont, errCont = run.commandReturnCont(comm, isOut=False)
        else:
            stat = "NG"
        #結果確認
        if stat == "OK":
            #paraview起動
            comm = runParaViewComm + " " + inpHeader + "_*"
            pyFistr.run(currDir).commandBG(comm)
        else:
            title = _("エラー")
            mess = _("errorが発生しました。") + ls
            mess += _("logを確認してください。")
            self.errDialog(title, mess, parent=mainWindow)

    # ---------- handler end -----------------


    #
    #  getNameInTreeData
    #    path(タプル)からtreeDataのnameを取得
    def getNameInTreeData(self, path):
        tree = [treeData]
        name = ""
        for n in path:
            nTree = tree[n]
            if type(nTree) == str:
                name = nTree
            else:
                name = nTree[0]
                tree = nTree[1]
        ans = name
        return ans

    #
    #  getParentNameInTreeData
    #    path(タプル)からtreeDataのparentを取得
    def getParentNameInTreeData(self, path):
        dPath = []
        dPath = path
        parent = self.getNameInTreeData(dPath[:-1])
        return parent

    #
    #  reloadDir
    #------------
    def reloadDir(self, event):
        """ directoryを再読込して、treeを再作成する"""
        self.maskEvent = True
        #selDirを取得
        selDir = self.treeWidget.getSelectedDirs()[0]
        #currDirの取得
        currDir = getCurrDirFromTempFolder()
        #rootからcurrDir, selDirまでのdirを取得
        folders = self.getAllFolders(currDir)
        folders += self.getAllFolders(selDir)
        folders = self.getNeedFolders(folders)
        folders = list(set(folders))
        folders.sort()
        dataDict = self.createDataDict(folders)
        self.treeWidget.dataDict = dataDict
        #itemの辞書（itemDict）を作成
        itemDict = self.createItemDict(folders)
        self.treeWidget.itemDict = itemDict
        #treeDataを作成
        treeData = self.treeWidget.createTreeData(itemDict)
        self.treeWidget.treeData = treeData
        #treeNodesを作成
        self.treeWidget.createTreeNodes()
        #currDir, selDirまで展開する
        self.treeWidget.expandToCurrDir(currDir)
        self.treeWidget.expandToCurrDir(selDir)
        #currDirのiconと書体を設定する
        self.setSelectedDir(currDir)
        #selDirを選択する(scrollして選択表示させる)
        self.treeWidget.selectDir(selDir)
        #statusBarに書き込み
        self.setStatusBar()
        #eventMaskを解除
        self.maskEvent = False

    #
    #  changeCurrDir
    #----------------
    def changeCurrDir(self, event):
        """ treeDir内の選択dirを作業folderに設定する"""
        global dimTrueFalseFlag
        selDirs = self.treeWidget.getSelectedDirs()
        if len(selDirs) > 1:
            self.warningMultiSelectionDir()
            return
        #cnt, mshファイルのtimeStampをチェックし、修正ならば保存後、currDirを移動する
        #  yesNoDialogを表示して処理
        newDir = selDirs[0]
        self.checkTempCaseDate(newDir)

    #
    #  setNewCurrDir
    def setNewCurrDir(self, newDir):
        """ newDirをcurrDirに設定する"""
        #beforePathを初期化
        self.beforePath = None
        #条件Tree内の展開しているnodeと選択しているnodeを取得
        (expPathes, selPath) = self.getExpandedSelectedNodesInTree()
        #unsetTreeItemsの保存
        self.writeUnsetTreeItems()
        #現在のworkDirのアイコンを元に戻す
        currDir = getCurrDirFromTempFolder()
        self.remakeNormalIconInTreeDir(currDir)
        #workDirをnewDirに変更
        self.changeWorkFolder(newDir)
        #newDirのアイコンをcheck付iconに変更する
        self.remakeCheckIconInTreeDir(newDir)
        #nodeを展開する
        self.setTreeSetPage(expPathes, selPath)
        #parallelのチェックを外す（defaultの設定）
        #self.checkBtn_solvePara.set_active(False)
        #createGrpのpageを初期化
        self.initCreateNgrpSgrpPage()
        #newDirの内容を取得し、dataDictに書き込み
        folderCont = self.getFolderCont(newDir)
        self.treeWidget.dataDict[newDir] = folderCont
        #itemDictのiconをcaseに設定
        self.treeWidget.itemDict[newDir][self.COL_ICON] = self.iconCase
        #vtkModel表示
        self.recreateVtk = "yes"
        self.setUndefineToHideElms()
        self.setVtkModel()
        #titleをセット
        self.setTitle()

    #
    #  getSelectedPathAndItemName
    def getSelectedPathAndItemName(self):
        """ 選択している項目のTreePathとItemName（項目名）を取得する"""
        #選択項目のtreePathを取得
        treeSelection = self.tree_main.get_selection()
        treestore, pathes = treeSelection.get_selected_rows()
        if len(pathes) == 0:
            pathInt = [0]
            path = Gtk.TreePath.new_from_indices(pathInt)
        else:
            path = pathes[0]
        #選択項目名を取得
        iter = treestore.get_iter(path)
        item = treestore.get_value(iter, 0)
        return path, item

    #
    #  showThisPageIfNotShow
    def showThisPageIfNotShow(self, path, item):
        """ path,itemのpageを表示する。"""
        currPath, currItem = self.getSelectedPathAndItemName()
        if currPath == path and currItem == item:
            #pageが変わっていない場合、直ぐに戻る
            return
        #元のpageに戻る。
        self.selectTreeItems(path)
        #page名を取得
        name = self.getNameInTreeData(path)
        parentName = self.getParentNameInTreeData(path)
        showPage = self.getShowPageName(parentName, name)
        #pageを表示
        self.showNoteBook(showPage)

    #
    #  selectTreeItems
    def selectTreeItems(self, path):
        """ TreeItem上のpathを選択する"""
        treeSelection = self.tree_main.get_selection()
        treeSelection.select_path(path)
        self.maskShowPage = False
        return

    #
    #  selectItem
    #    Treeの項目選択
    def selectItem(self, event):
        """ Treeの項目を選択したときのevent"""
        if self.maskShowPage == True:
            return
        #内容変更checkのeventをmaskする
        self.maskChangeCont = True
        #page（path）を取得
        treeCtrl = self.tree_main
        path, dummy_column = treeCtrl.get_cursor()
        if path == None:
            path = Gtk.TreePath.new_from_indices([0])
        #beforePathがNone？
        if self.beforePath == None:
            #無条件で移動する
            self.changeItem(path)
            return
        #statusBarに空き容量を表示
        self.setStatusBar()
        #pathは前回のpathと同じ？
        if path == self.beforePath:
            return
        #treeItemは、前回、今回とも「ステップ解析」?
        itemList = self.getItemListFromPath(path)
        itemName = itemList[-1]
        if itemName == _("ステップ解析") and self.beforeTreeItem == _("ステップ解析"):
            return
        #itemを移動するかどうかdialogで確認
        self.checkChangeItem(path)

    #
    #  checkChangeItem
    def checkChangeItem(self, path):
        if len(path) == 0:
            return
        #現在pageの「*設定」buttonを確認
        if self.isMarkButton() == True:
            #yesNoDialogで確認する。
            title = _("TreeItem移動")
            mess =_("内容が修正されています。") + ls
            mess += _("このままTreeを移動しますか？")
            funcYes = [self.changeItem, path]       #item移動
            funcNo = [self.returnBeforePath]        #itemを戻す
            self.yesNoDialog(title, mess, funcYes, funcNo, parent=mainWindow)
        else:
            self.changeItem(path)

    #
    #  returnBeforePath
    def returnBeforePath(self):
        """ 選択itemをbeforePathに戻す"""
        self.maskShowPage = True
        treeSelection = self.tree_main.get_selection()
        treeSelection.select_path(self.beforePath)
        self.maskShowPage = False

    #
    #  changeItem
    #--------------
    def changeItem(self, path):
        """ itemをpathのitemに移動する"""
        #pathをbeforePathに保存
        self.beforePath = path
        #treeItemNameをbeforeTreeItemに保存
        itemList = self.getItemListFromPath(path)
        self.beforeTreeItem = itemList[-1]
        #page名を取得
        name = self.getNameInTreeData(path)
        parentName = self.getParentNameInTreeData(path)
        showPage = self.getShowPageName(parentName, name)
        #現在（beforePage）page名取得
        i = self.notebook_main.get_current_page()
        page = self.notebook_main.get_nth_page(i)
        beforePage = self.notebook_main.get_tab_label_text(page)
        #beforePageがsolverPageの場合は、nThreadを保存
        if beforePage == "solver":
            nThread = self.textCtrl_solveNthread.get_text()
            saveIstrData(["thread " + nThread])
        #vtkの再描画flagをセット
        if showPage != "createNgrpSgrp" and beforePage == "createNgrpSgrp":
            self.recreateVtk = "yes"
        else:
            self.recreateVtk = "no"
        #vtk表示をnormalに戻す(非選択表示)
        if vtkImportFlag == "yes" and self.showModel == True:
            if showPage != _(u"createNgrpSgrp") and self.showMeshMode != "normal":
                self.showNoneSelectedModel()
                self.showMeshMode = "normal"
        #page毎の処理とpage表示
        #  辞書を作成
        showPageDict = {
            # showPage          page作成関数            引数
            "":                 [self.setFrontISTRPage, ()],
            _("FrontISTR"):     [self.setFrontISTRPage, ()],
            _("FistrModel"):    [self.setFistrModelPage, ()],
            _("createNgrpSgrp"):[self.createNgrpSgrpPage, ()],
            _("editGroup"):     [self.editGroup, ()],
            _("材料物性値"):    [self.setElGroupToListBoxInMaterial, ()],
            _("材料物性値_sub"):[self.setMaterialToElGroup, (name,)],
            _("境界条件"):      [self.showAllBoundaryPage, ()],
            _("BOUNDARY"):      [self.setBCGroupToListBox, (showPage,)],
            _("BOUNDARY_sub"):  [self.setBoundary_sub, (name,)],
            _("CLOAD"):         [self.setBCGroupToListBox, (showPage,)],
            _("CLOAD_sub"):     [self.setCload_sub, (name,)],
            _("DLOAD"):         [self.setBCGroupToListBox, (showPage,)],
            _("DLOAD_sub"):     [self.setDload_sub, (name,)],
            _("VLOAD"):         [self.setBCGroupToListBox, (showPage,)],
            _("VLOAD_sub"):     [self.setVload_sub, (name,)],
            _("GRAV"):          [self.setBCGroupToListBox, (showPage,)],
            _("GRAV_sub"):      [self.setGravToListBox, (name,)],
            _("CENT"):          [self.setBCGroupToListBox, (showPage,)],
            _("CENT_sub"):      [self.setCent_sub, (name,)],
            _("TEMPERATURE"):   [self.setBCGroupToListBox, (showPage,)],
            _("TEMPERATURE_sub"):[self.setTemperatureToListBox, (name,)],
            _("REFTEMP"):       [self.setBCGroupToListBox, (showPage,)],
            _("REFTEMP_sub"):   [self.setReftemp, ()],
            _("SPRING"):        [self.setBCGroupToListBox, (showPage,)],
            _("SPRING_sub"):    [self.setSpring_sub, (name,)],
            _("contact"):       [self.setContactGroupToListBox, ()],
            _("contact_sub"):   [self.setContact_sub, (name,)],
            _("FLOAD"):         [self.setBCGroupToListBox, (showPage,)],
            _("FLOAD_sub"):     [self.setFload_sub, (name,)],
            _("VELOCITY"):      [self.setBCGroupToListBox, (showPage,)],
            _("VELOCITY_sub"):  [self.setVelocity_sub, (name,)],
            _("ACCELERATION"):  [self.setBCGroupToListBox, (showPage,)],
            _("ACCELERATION_sub"):[self.setAcceleration_sub, (name,)],
            _("INITIAL"):       ["", (showPage,)],
            _("INITEMP"):       [self.setBCGroupToListBox, (showPage,)],
            _("INITEMP_sub"):   [self.setInitial_sub, (name,)],
            #_("INIVEL"):        [self.setBCGroupToListBox, (showPage,)],
            #_("INIVEL_sub"):    [self.setInivel_sub, (name,)],
            #_("INIACC"):        [self.setBCGroupToListBox, (showPage,)],
            #_("INIACC_sub"):    [self.setIniacc_sub, (name,)],
            _("FIXTEMP"):       [self.setBCGroupToListBox, (showPage,)],
            _("FIXTEMP_sub"):   [self.setFixtemp_sub, (name,)],
            _("CFLUX"):         [self.setBCGroupToListBox, (showPage,)],
            _("CFLUX_sub"):     [self.setCflux_sub, (name,)],
            _("SFLUX"):         [self.setBCGroupToListBox, (showPage,)],
            _("SFLUX_sub"):     [self.setSflux_sub, (name,)],
            _("DFLUX"):         [self.setBCGroupToListBox, (showPage,)],
            _("DFLUX_sub"):     [self.setDflux_sub, (name,)],
            _("BF"):            [self.setBCGroupToListBox, (showPage,)],
            _("BF_sub"):        [self.setBf_sub, (name,)],
            _("SFILM"):         [self.setBCGroupToListBox, (showPage,)],
            _("SFILM_sub"):     [self.setSfilm_sub, (name,)],
            _("SRADIATE"):      [self.setBCGroupToListBox, (showPage,)],
            _("SRADIATE_sub"):  [self.setSradiate_sub, (name,)],
            _("AMPLITUDE"):     [self.setAmpGroupToListBox, ()],
            _("AMPLITUDE_sub"): [self.setAmplitude_sub, (name,)],
            _("step"):          [self.setStepGroupToListBox, ()],
            _("step_sub"):      [self.setStep_sub, (name,)],
            _("solver"):        [self.setSolverPage, (name,)],
            _("solver_lin"):    [self.setSolverLinPage, ()],
            _("output"):        [self.setBCGroupToListBox, (showPage,)],
            _("solutionType"):  [self.setSolutionTypePage, (name,)],
            _("solution_eigen"):[self.setSolutionEigenPage, ()],
            _("solution_dyna"): [self.setSolutionDynaPage, ()],
            _("solution_heatDyna"):[self.setSolutionHeatDynaPage, ()],
            _("post"):          [self.setPostPage, ()]
            }
        #page作成関数を取得
        func = showPageDict[showPage][0]
        args = showPageDict[showPage][1]
        #関数を実行
        if func != "":
            if args == ():
                func()      #引数なしで実行
            else:
                func(*args)
        #pageを表示
        self.showNoteBook(showPage)
        #「設定」ボタンのlabelを設定
        self.setSettingButtonLabel()
        #内容変更checkのmaskを解除
        self.maskChangeCont = False

    #
    #  getShowPageName
    def getShowPageName(self, parentName, name):
        #parentNameからpageを取得
        pageFromParentDict = {
            #parentName             pageName
            _("材料物性値"):        _("材料物性値_sub"),
            _("初期値（初期温度）"):_("INITEMP_sub"),
            #_("INITEMP（初期温度）"):_("INITEMP_sub"),
            #_("INIVEL（初期速度）"):_("INIVEL_sub"),
            #_("INIACC（初期加速度）"):_("INIACC_sub"),
            _("参照温度"):          _("REFTEMP_sub"),
            _("BOUNDARY（変位）"):  _("BOUNDARY_sub"),
            _("CLOAD（荷重）"):     _("CLOAD_sub"),
            _("DLOAD（圧力）"):     _("DLOAD_sub"),
            _("VLOAD（体積力）"):   _("VLOAD_sub"),
            _("GRAV（重力）"):      _("GRAV_sub"),
            _("CENT（遠心力）"):    _("CENT_sub"),
            _("TEMPERATURE（温度）"):_("TEMPERATURE_sub"),
            #_("SPRING（バネ要素）"):_("SPRING_sub"),
            _("SPRING（バネ境界）"):_("SPRING_sub"),
            _("CONTACT（接触）"):   _("contact_sub"),
            _("FLOAD（周期荷重）"): _("FLOAD_sub"),
            _("VELOCITY（速度）"):  _("VELOCITY_sub"),
            _("ACCELERATION（加速度）"):_("ACCELERATION_sub"),
            _("INITIAL（初期温度）"):_("INITIAL_sub"),
            _("FIXTEMP（温度固定）"):_("FIXTEMP_sub"),
            _("CFLUX（集中熱量）"): _("CFLUX_sub"),
            _("SFLUX（面熱流束）"): _("SFLUX_sub"),
            _("DFLUX（個別の面熱流束）"): _("DFLUX_sub"),
            _("BF（内部発熱）"):    _("BF_sub"),
            _("SFILM（熱伝達率）"): _("SFILM_sub"),
            _("SRADIATE（輻射）"):  _("SRADIATE_sub"),
            _("時間変化"):          _("AMPLITUDE_sub"),
            _("ステップ解析"):      _("step_sub")
            }
        #nameからpageを取得
        pageFromNameDict = {
            #tree name                page
            _("solver"):            _("solver"),
            _("FrontISTR analysis"):_("FrontISTR"),
            _("FistrModel.msh"):    _("FistrModel"),
            _("GROUP作成"):         _("createNgrpSgrp"),
            _("GROUP編集"):         _("editGroup"),
            _("解析の種類"):        _("solutionType"),
            _("動解析_設定"):       _("solution_dyna"),
            _("周波数応答_設定"):   _("solution_dyna"),
            _("固有値解析_設定"):   _("solution_eigen"),
            _("熱伝導(動解析)_設定"):_("solution_heatDyna"),
            _("初期値（初期温度）"):_("INITEMP"),
            #_("初期値"):            _("INITIAL"),
            #_("INITEMP（初期温度）"):_("INITEMP"),
            #_("INIVEL（初期速度）"):_("INIVEL"),
            #_("INIACC（初期加速度）"):_("INIACC"),
            _("参照温度"):          _("REFTEMP"),
            _("境界条件"):          _("境界条件"),
            _("材料物性値"):        _("材料物性値"),
            _("BOUNDARY（変位）"):  _("BOUNDARY"),
            _("CLOAD（荷重）"):     _("CLOAD"),
            _("DLOAD（圧力）"):     _("DLOAD"),
            _("VLOAD（体積力）"):   _("VLOAD"),
            _("GRAV（重力）"):      _("GRAV"),
            _("CENT（遠心力）"):    _("CENT"),
            _("post"):              _("post"),
            _("TEMPERATURE（温度）"):_("TEMPERATURE"),
            #_("SPRING（バネ要素）"):_("SPRING"),
            _("SPRING（バネ境界）"):_("SPRING"),
            _("CONTACT（接触）"):   _("contact"),
            _("FLOAD（周期荷重）"): _("FLOAD"),
            _("VELOCITY（速度）"):  _("VELOCITY"),
            _("ACCELERATION（加速度）"):_("ACCELERATION"),
            _("INITIAL（初期温度）"):_("INITIAL"),
            _("FIXTEMP（温度固定）"):_("FIXTEMP"),
            _("CFLUX（集中熱量）"): _("CFLUX"),
            _("SFLUX（面熱流束）"): _("SFLUX"),
            _("DFLUX（個別の面熱流束）"): _("DFLUX"),
            _("BF（内部発熱）"):    _("BF"),
            _("SFILM（熱伝達率）"): _("SFILM"),
            _("SRADIATE（輻射）"):  _("SRADIATE"),
            _("時間変化"):          _("AMPLITUDE"),
            _("ステップ解析"):      _("step"),
            _("出力"):              _("output"),
            _("線形solver"):        _("solver_lin")
            }
        pageName = ""
        bndName = _("境界条件")
        if name[:len(bndName)] == bndName:
            name = bndName
        #parentNameからpageを取得
        if parentName in pageFromParentDict.keys():
            #辞書からpageを取得
            pageName = pageFromParentDict[parentName]
        elif name in pageFromNameDict.keys():
            #nameからpageを取得
            pageName = pageFromNameDict[name]
        return pageName

    #
    #  showNoteBook
    #    pageを表示
    def showNoteBook(self, name):
        """ pageNameを表示する"""
        #renameするnameの辞書
        renamePageDict = {
            #name           newName(pageName)
            "TEMPERATURE":  "setGroup",
            "GRAV":         "setGroup",
            "BOUNDARY":     "setGroup",
            "CLOAD":        "setGroup",
            "DLOAD":        "setGroup",
            "VLOAD":        "setGroup",
            "CENT":         "setGroup",
            "step":         "AMPLITUDE",
            "SPRING":       "setGroup",
            "FLOAD":        "setGroup",
            "VELOCITY":     "setGroup",
            "ACCELERATION": "setGroup",
            "INITEMP":      "setGroup",
            #"INIVEL":       "setGroup",
            #"INIACC":       "setGroup",
            "REFTEMP":      "setGroup",
            "FIXTEMP":      "setGroup",
            "CFLUX":        "setGroup",
            "SFLUX":        "setGroup",
            "DFLUX":        "setGroup",
            "BF":           "setGroup",
            "SFILM":        "setGroup",
            "SRADIATE":     "setGroup",
            "output":       "setGroup"
            #"INIVEL_sub":   "VELOCITY_sub",
            #"INIACC_sub":   "ACCELERATION_sub"
            }
        #nameをチェック
        if name in renamePageDict.keys():
            #nameを変更
            name = renamePageDict[name]
        #全page数を取得
        nPage = self.notebook_main.get_n_pages()
        #表示するpageを取得し、表示する
        i = 0
        while i < nPage:
            page = self.notebook_main.get_nth_page(i)
            pageName = self.notebook_main.get_tab_label_text(page)
            if pageName == name:
                self.notebook_main.set_current_page(i)
                break
            i += 1

    #
    #  setFrontISTRPage
    #-------------------
    def setFrontISTRPage(self):
        """ FrontISTRPage（TopPage）のset
        vtkの表示を非選択状態に設定する"""
        #cnt,mshファイル名をlabelに設定
        cont  = "cnt: " + FistrModel_cnt + ls
        cont += "msh: " + FistrModel_msh
        self.label_datCont.set_text(cont)
        if FistrModel_cnt == "FistrModel.cnt" and FistrModel_msh == "FistrModel.msh":
            self.button_datCont.set_sensitive(False)
        else:
            self.button_datCont.set_sensitive(True)
        #vtk表示設定
        if vtkImportFlag == "yes" and self.showModel == True:
            self.showNoneSelectedModel()

    #
    #  setFistrModelPage
    def setFistrModelPage(self):
        #sourceMesh名をセット
        self.setSourceMeshFileToLabel()
        #scaleをセット
        scale = self.textCtrl_meshScale.get_text()
        if scale == "":
            scale = "1.0"
        self.textCtrl_meshScale.set_text(scale)
        #dimensionの設定
        self.setComboDimension()
        #set341elm_selectiveの設定
        self.set341elm_setCheckBox()
        #vtk表示を非選択に設定
        self.showNoneSelectedModel()

    #  setSourceMeshFile
    def setSourceMeshFileToLabel(self):
        """ 現在meshのsourceFileをistrDataから取得する"""
        istrData = getSavedData()
        sourceMesh = ""
        for line in istrData:
            words = line.split()
            if len(words) > 1:
                if words[0] == "sourceMesh":
                    sourceMesh = words[1]
                    break
        sourceMesh = os.path.basename(sourceMesh)
        self.label_sourceFileName.set_text(sourceMesh)

    #
    #  initCreateNgrpSgrpPage
    #--------------------------
    def initCreateNgrpSgrpPage(self):
        """ createNgrpSgrpPageの初期化"""
        #textCtrlを非表示設定
        self.textCtrl_startFace.set_sensitive(False)
        #flagをクリア
        self.pickedGrp = ""
        #新規Grp作成にセット
        self.radioBtn_addGrp.set_active(True)
        self.radioBtn_newGrp.set_active(True)
        self.changeCreateGrpMethod()

    #
    #  setCreateNewGrp
    def setCreateNewGrp(self):
        """ grp新規作成にセットする"""
        self.radioBtn_newGrp.set_active(True)
        self.changeCreateGrpMethod()

    #
    #  changeCreateGrpMethod
    #-------------------------
    def changeCreateGrpMethod(self):
        """ grp作成方法（新規作成 or 既存Grp修正）を変えた時"""
        if self.radioBtn_newGrp.get_active() == True:
            #新規作成の場合
            self.textCtrl_grpName.set_sensitive(True)
            self.combo_existGrpName.comboBox.set_sensitive(False)
            self.radioBtn_addGrp.set_sensitive(False)
            self.radioBtn_subGrp.set_sensitive(False)
            self.combo_existGrpName.setItems([])
            self.combo_existGrpName.selectItem(0)
        elif self.radioBtn_existGrp.get_active() == True:
            #既存Grpの修正の場合
            self.textCtrl_grpName.set_sensitive(False)
            self.combo_existGrpName.comboBox.set_sensitive(True)
            self.radioBtn_addGrp.set_sensitive(True)
            self.radioBtn_subGrp.set_sensitive(True)
            #comboにgrp名をセット
            egrp, sgrp, ngrp = getGrpNameInTempFolder()
            if self.pickedGrp == "ngrp":
                items = ngrp
            elif self.pickedGrp == "sgrp":
                items = sgrp
            elif self.pickedGrp == "egrp":
                items = egrp
            else:
                items = []
            items.sort()
            self.combo_existGrpName.setItems(items)
            self.combo_existGrpName.selectItem(0)

    #
    #  createNgrpSgrpPage
    #---------------------
    def createNgrpSgrpPage(self):
        """ NGRP, SGRP作成pageを表示する"""
        #textCtrlを非表示設定
        self.initCreateNgrpSgrpPage()
        #showMeshModeを設定
        self.showMeshMode = "createGroup"
        #textBoxをクリア
        self.textCtrl_startFace.set_text("")
        #変数をクリア
        self.createdGrp = []
        self.pickedPoints = []
        self.dummyPickedPoints = []
        #取得buttonを非表示設定
        self.activeButtonOfCreateGrp([])
        #vtkを表示
        self.pickedData = []
        self.pickedActors = []
        self.showCreateGrpModel()

    #
    #  getSolidElmGrps
    def getSolidElmGrps(self):
        """ solid要素Grp名を取得し返す"""
        meshCont = getMeshContsFromTempFolder()["meshCont"]
        lines = meshCont.split("\n")
        egrps = []
        for line in lines:
            words = line.split()
            if len(words) > 1:
                if words[0] == "EGRP":
                    elType = words[3]
                    if abaqus2fistr.elementContsDict[elType][0] == "solid":
                        egrps.append(words[1])

        currDir = getCurrDirFromTempFolder()
        vtkFiles = glob.glob(currDir + os.sep + self.vtkFolder + os.sep + "*.vtu")
        vtkNames = list(map(lambda x: os.path.basename(x), vtkFiles))
        if len(list(filter(lambda x: x.find("--undefine--")>=0, vtkNames))) > 0:
            egrps += ["--undefine--"]
        egrps.sort()
        return egrps

    #
    #  editGroup
    #------------
    def editGroup(self):
        """ group編集pageを表示する。"""
        #showMeshModeを設定
        self.showMeshMode = "normal"
        #各groupを取得する
        egrp, sgrp, ngrp = getGrpNameInTempFolder()
        egrp.sort()
        sgrp.sort()
        ngrp.sort()
        self.treeList_eNgrp.setItems(ngrp)
        self.treeList_eSgrp.setItems(sgrp)
        self.treeList_eEgrp.setItems(egrp)
        #delMeshボタンを非表示
        self.button_editGroupDelMesh.set_sensitive(False)
        #vtkを再表示
        self.showNoneSelectedModel()

    #
    #  getSolutionPage
    #    solutionのpage名を取得
    def getSolutionPage(self):
        anaType = getSolutitionTypeFromCnt()
        if anaType == "EIGEN":
            page = "solution_eigen"     #固有値
        elif anaType == "DYNAMIC":
            page = "solution_dyna"      #動解析
        elif anaType == "DYNAMIC_F":
            page = "solution_dyna"      #周波数応答
        elif anaType == "HEAT_D":
            page = "solution_heatDyna"  #熱伝導（動解析）
        return page

    #
    #  setAmpGroupToListBox
    #
    def setAmpGroupToListBox(self):
        self.label_ampName.set_text("AMPLITUDE")
        self.label_ampTitle.set_text(_(u"時間変化（AMPLITUDE）の定義"))
        self.label_ampGrpName.set_text(_(u"設定するamp名"))
        msg  = _(u"amplitude定義を") + ls
        msg += _(u"「追加>>」ボタンで追加。") + ls
        msg += _(u"「<<削除」ボタンで削除。")
        self.label_ampMsg.set_text(msg)
        self.setListDataInListBox(self.listmodelSetAmp, self.listBox_setAmp,
                ampDefine)
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  setStepGroupToListBox
    #
    def setStepGroupToListBox(self):
        self.label_ampName.set_text("STEP")
        self.label_ampTitle.set_text(_(u"ステップ解析（step）の定義"))
        self.label_ampGrpName.set_text(_(u"設定するstep名"))
        msg  = _(u"step定義を") + ls
        msg += _(u"「追加>>」ボタンで追加。") + ls
        msg += _(u"「<<削除」ボタンで削除。")
        self.label_ampMsg.set_text(msg)
        self.setListDataInListBox(self.listmodelSetAmp, self.listBox_setAmp,
                stepDefine)
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  setContactGroupToListBox
    #
    def setContactGroupToListBox(self):
        #childrenItemを取得
        #childNames = self.getChildNamesFromSelectedItem()
        #parameterの設定
        contactAlgos = [_(u"SLAGRANGE（Lagrange乗数法）"), _(u"ALAGRANGE（拡張Lagrange法）")]
        self.setComboDataInComboBox(self.listmodelCntPair, self.comboBox_cntAlgo,
            contactAlgos)
        selAlgo = getContactAlgoInCnt()
        selNo = 1
        if selAlgo == "SLAGRANGE":
            selNo = 0
        elif selAlgo == "ALAGRANGE":
            selNo = 1
        #stepIdを取得
        nStep = self.getStepIdFromItem()
        #contactDefineを取得
        global contactDefine
        lines = readFistrModelCnt()
        contactDefine = getBoundaryNodeGroupInCnt(lines, "!CONTACT")
        #textBoxに表示
        self.comboBox_cntAlgo.set_active(selNo)
        self.setListDataInListBox(self.listmodelSetContact, self.listBox_setContact,
                contactDefine[nStep])
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = []
        self.showSelectedModel()

    #
    #  setTemperatureToListBox
    #
    def setTemperatureToListBox(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        values = self.readTemperatureValueFromCntMesh(name, nStep)
        header = pyFistr.getHeaderName(FistrModelDict["res"])
        headerName = header.split("_")[0]
        #heatResFiles = glob.glob("FistrModel_temp.res.0.*")
        heatResFiles = glob.glob(headerName + "_temp.res.0.*")
        line = _(u"（現在の熱伝導解析結果: ") + str(len(heatResFiles)) + " steps）"
        self.label_tempHres.set_label(line)
        self.setElGroupToLabel(self.temperatureGrpLabel, name)
        #初期温度のtextCtrlを非表示設定
        # self.textCtrl_tempIni.set_sensitive(False)
        # if nStep == 0:
        #     self.textCtrl_tempIni.set_sensitive(True)
        # else:
        #     self.textCtrl_tempIni.set_sensitive(False)
        if len(values) == 0:
            temp = "0.0"
            iniTemp = "0.0"
            readResult = "1"
            sStep = "1"
            interval = "1"
            self.checkBtn_tempUseH.set_active(False)
            self.textCtrl_tempSet.set_sensitive(True)
            self.textCtrl_tempReadR.set_sensitive(False)
            self.textCtrl_tempSstep.set_sensitive(False)
            self.textCtrl_tempInterval.set_sensitive(False)
        else:
            temp = values[0]
            iniTemp = values[1]
            readResult = values[2]
            sStep = values[3]
            interval = values[4]
            if readResult == "":
                #直接温度設定
                self.checkBtn_tempUseH.set_active(False)
                self.textCtrl_tempSet.set_sensitive(True)
                self.textCtrl_tempReadR.set_sensitive(False)
                self.textCtrl_tempSstep.set_sensitive(False)
                self.textCtrl_tempInterval.set_sensitive(False)
            else:
                #熱解析結果を使用する
                self.checkBtn_tempUseH.set_active(True)
                self.textCtrl_tempSet.set_sensitive(False)
                self.textCtrl_tempReadR.set_sensitive(True)
                self.textCtrl_tempSstep.set_sensitive(True)
                self.textCtrl_tempInterval.set_sensitive(True)
        #値をセット
        self.textCtrl_tempSet.set_text(temp)
        self.textCtrl_tempReadR.set_text(readResult)
        self.textCtrl_tempSstep.set_text(sStep)
        self.textCtrl_tempInterval.set_text(interval)
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    #
    #  setGravToListBox
    #
    def setGravToListBox(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.gravGrpLabel, name)
        values = self.readGravValueFromCnt(name, nStep)
        if len(values) == 0:
            #val = "0.0"
            ax = "0.0"
            ay = "0.0"
            az = "0.0"
        else:
            g = float(values[0])
            x = float(values[1])
            y = float(values[2])
            z = float(values[3])
            if g != 0:
                l = pow((x*x + y*y + z*z), 0.5)
                ax = str(x/l*g)
                ay = str(y/l*g)
                az = str(z/l*g)
            else:
                ax="0.0"; ay="0.0"; az="0.0"
        self.textCtrl_gravX.set_text(ax)
        self.textCtrl_gravY.set_text(ay)
        self.textCtrl_gravZ.set_text(az)
        #単位を設定
        self.setUnitToGravSubPage()
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["elementGrp_" + name]
        self.showSelectedModel()

    def setUnitToGravSubPage(self):
        """ 単位を設定"""
        units = [["accel", ["unit_accelx_grav", "unit_accely_grav", "unit_accelz_grav"]]]
        self.setUnitToPage(units)

    #
    #  setSolutionTypePage
    #    solutionTypePageをセット
    def setSolutionTypePage(self, name):
        global anaType
        anaType = getSolutitionTypeFromCnt()
        self.setAnalysisTypeToComboBox()
        self.setAnaTypeContInLabel(anaType)
        #vtkを非選択表示に設定
        if len(self.selectedActors) > 0 or len(self.preSelectedActors) > 0:
            self.showNoneSelectedModel()
        return

    #
    #  setSolutionHeatDynaPage
    #    熱伝導動解析のpageをセット
    def setSolutionHeatDynaPage(self):
        #単位を設定
        self.setUnitToHeatSolutionPage()
        #dataを取得
        values = getHeatDinaContFromCnt()
        self.textCtrl_hdynaDt.set_text(values[0])
        self.textCtrl_hdynaEtime.set_text(values[1])
        self.textCtrl_hdynaDtmin.set_text(values[2])
        self.textCtrl_hdynaDmax.set_text(values[3])
        self.textCtrl_hdynaItmax.set_text(values[4])
        self.textCtrl_hdynaEps.set_text(values[5])
        if float(values[2]) <= 0.0:
            self.checkBtn_soluDt.set_active(True)
        else:
            self.checkBtn_soluDt.set_active(False)

    def setUnitToHeatSolutionPage(self):
        """ 熱伝導の動解析pageに単位を設定する"""
        #         時間
        units = [["time", ["unit_DT_heatDyna", "unit_ETIME_heatDyna",
                           "unit_DTMIN_heatDyna"]]]
        self.setUnitToPage(units)

    #
    #  setSolutionDynaPage
    #    動解析のpageをセット
    def setSolutionDynaPage(self):
        anaType = getSolutitionTypeFromCnt()
        if anaType == "DYNAMIC":
            self.setUnitToSolutionDynaPage()
            self.setDynamicContToListBox()
        elif anaType == "DYNAMIC_F":
            self.setUnitToSolutionDyna_FPage()
            self.setFreqResponseContToListBox()

    def setUnitToSolutionDynaPage(self):
        """ 動解析pageの単位を設定する"""
        #        時間    labelのId名
        units = [["time", ["unit_startEndTime", "unit_incTime"]]]
        self.setUnitToPage(units)

    def setUnitToSolutionDyna_FPage(self):
        """ 周波数応答解析pageの単位を設定する"""
        #        周波数    labelのId名
        units = [["Hz", ["unit_startEndTime", "unit_incTime"]]]
        self.setUnitToPage(units)

    #
    #  setSolutionEigenPage
    #    固有値のpageをセット
    def setSolutionEigenPage(self):
        self.setEigenContToListBox()

    #
    #  setEigenContToListBox
    #    固有値解析の内容をセット
    def setEigenContToListBox(self):
        #dataを取得
        values = getEigenContFromCnt()
        if len(values) == 0:
            #defaultの値を設定
            values = defaultEigenSolutionCont()
        self.textCtrl_eigenNum.set_text(values[0])
        self.textCtrl_eigenPerm.set_text(values[1])
        self.textCtrl_eigenMaxiter.set_text(values[2])

    #
    #  setFreqResponseContToListBox
    #    周波数応答解析の内容をセット
    def setFreqResponseContToListBox(self):
        self.label_soldyTitle.set_text(_(u"周波数応答解析の設定"))
        defaultData = defaultFreqResponseSolutionCont()
        values = self.setDynamicContToListBox_sub(defaultData)
        visType = [_(u"1:モード空間"), _(u"2:物理空間")]
        self.setComboDataInComboBox(self.listmodelSoldyGroup, self.comboBox_soldyGroup, visType)
        if values[1][13] == "1":
            self.comboBox_soldyGroup.get_child().set_text(visType[0])
        else:
            self.comboBox_soldyGroup.get_child().set_text(visType[1])
        #file出力間隔を隠す
        self.textCtrl_soldyOutfile.set_sensitive(False)
        #開始・終了時間を表示する
        self.textCtrl_soldyStime.set_sensitive(True)
        self.textCtrl_soldyEtime.set_sensitive(True)
        self.textCtrl_soldySample.set_sensitive(True)
        #labelを修正
        self.label_soldySEtime.set_text(_(u"開始・終了 Hz"))
        self.label_soldyDtime.set_text(_(u"変位計算 Hz"))
        self.label_soldyGbeta.set_text(_(u"開始・終了時間"))
        self.label_soldyNewmark.set_text(_(u"実時間における"))
        self.label_soldyGroup.set_text(_(u"出力指定"))
        self.label_soldyOutdis.set_text(_(u" nodeID"))

    #
    #  setDynamicCont
    #    動解析の内容をセット
    def setDynamicContToListBox(self):
        self.label_soldyTitle.set_text(_(u"動解析の設定"))
        defaultData = defaultDynamicSolutionCont()
        values = self.setDynamicContToListBox_sub(defaultData)
        nodeGrp = meshGroup[2]
        self.setComboDataInComboBox(self.listmodelSoldyGroup, self.comboBox_soldyGroup, nodeGrp)
        entry = self.comboBox_soldyGroup.get_child()
        entry.set_text(values[1][13])
        #file出力間隔を隠す
        self.textCtrl_soldyOutfile.set_sensitive(False)
        #開始・終了時間を隠す
        self.textCtrl_soldyStime.set_sensitive(False)
        self.textCtrl_soldyEtime.set_sensitive(False)
        self.textCtrl_soldySample.set_sensitive(False)
        #labelを修正
        self.label_soldySEtime.set_text(_(u"開始・終了時間"))
        self.label_soldyDtime.set_text(_(u"時間増分"))
        self.label_soldyGbeta.set_text(_(u"ganma, beta"))
        self.label_soldyNewmark.set_text(_(u"Newmark-β法"))
        self.label_soldyGroup.set_text(_(u"group名"))
        self.label_soldyOutdis.set_text(_(u"出力間隔"))

    #  setDynamicContToListBox_sub
    #    textBoxにデータをセット
    def setDynamicContToListBox_sub(self, defaultData):
        #comboBoxをセット
        self.setComboDataInComboBox(self.listmodelSoldyType, self.comboBox_soldyType, [_(u"線形解析"), _(u"非線形解析")])
        self.setComboDataInComboBox(self.listmodelSoldyEqn, self.comboBox_soldyEqn, [_(u"陽解法（中央差分法）"), _(u"陰解法（Newmark-β法）")])
        #dataを取得
        values = getDynamicContFromCnt()
        if values[0] == "LINEAR" or values[0] == "NONLINEAR":
            pass
        else:
            values[0] == "LINEAR"
        if len(values[1]) == 21:
            pass
        else:
            values[1] = defaultData
        #線形・非線形
        self.comboBox_soldyType.set_active(0)
        if values[0] == "NONLINEAR":
            self.comboBox_soldyType.set_active(1)
        data = values[1]
        #運動方程式
        self.comboBox_soldyEqn.set_active(0)
        if data[0] != "11":
            self.comboBox_soldyEqn.set_active(1)
        #開始時間等
        self.textCtrl_soldyStime.set_text(data[2])
        self.textCtrl_soldyEtime.set_text(data[3])
        self.textCtrl_soldyAllstep.set_text(data[4])
        self.textCtrl_soldyDtime.set_text(data[5])
        self.textCtrl_soldyOutfile.set_text(values[2])
        #パラメータ
        self.textCtrl_soldyGanma.set_text(data[6])
        self.textCtrl_soldyBeta.set_text(data[7])
        self.textCtrl_soldyRm.set_text(data[10])
        self.textCtrl_soldyRk.set_text(data[11])
        #モニタ
        self.textCtrl_soldySample.set_text(data[12])
        self.textCtrl_soldyOutterm.set_text(data[14])
        self.checkBtn_soldyDis.set_active(False)
        self.checkBtn_soldyVelo.set_active(False)
        self.checkBtn_soldyAcc.set_active(False)
        self.checkBtn_soldyForce.set_active(False)
        self.checkBtn_soldyStrain.set_active(False)
        self.checkBtn_soldyStress.set_active(False)
        if data[15] == "1":
            self.checkBtn_soldyDis.set_active(True)
        if data[16] == "1":
            self.checkBtn_soldyVelo.set_active(True)
        if data[17] == "1":
            self.checkBtn_soldyAcc.set_active(True)
        if data[18] == "1":
            self.checkBtn_soldyForce.set_active(True)
        if data[19] == "1":
            self.checkBtn_soldyStrain.set_active(True)
        if data[20] == "1":
            self.checkBtn_soldyStress.set_active(True)
        return values

    #
    #  setSolverPage
    #
    def setSolverPage(self, name):
        values = getSolverContFromCnt()
        iterLog = values[4]
        timeLog = values[5]
        freq = values[6]
        restartFreq = values[7]
        if iterLog == "YES":
            self.checkBtn_solveIlog.set_active(True)
        else:
            self.checkBtn_solveIlog.set_active(False)
        if timeLog == "YES":
            self.checkBtn_solveTlog.set_active(True)
        else:
            self.checkBtn_solveTlog.set_active(False)
        #parallel, fistrVersionの設定の読み込み
        #[para, nCpu, thread, nThread, fistrVersion] = getParallelInSavedData()
        [para, nCpu, nThread, fistrVersion] = getParallelInSavedData()
        if para == "True":
            parallel = True
        else:
            parallel = False
        self.checkBtn_solvePara.set_active(parallel)
        self.textCtrl_solveNcpu.set_text(nCpu)
        self.textCtrl_solveNthread.set_text(nThread)
        self.textCtrl_solveFreq.set_text(freq)
        #並列処理用GUI部品の非表示設定
        if parallel == True:
            #self.button_solveFistr.set_label((_(u"FrontISTR実行") + ls + _(u"(process並列)")))
            self.label_nCpu.set_sensitive(True)
            self.textCtrl_solveNcpu.set_sensitive(True)
            self.button_separateMesh.set_sensitive(True)
        else:
            #self.button_solveFistr.set_label(_(u"FrontISTR実行"))
            self.label_nCpu.set_sensitive(False)
            self.textCtrl_solveNcpu.set_sensitive(False)
            self.button_separateMesh.set_sensitive(False)
        #実行ボタンのlabelを設定
        self.setRunButtonLabel()
        #fistrVersionの設定
        if fistrVersion == "4.6":
            self.checkBtn_fistrVersion.set_active(True)
        else:
            self.checkBtn_fistrVersion.set_active(False)
        #RESTARTの設定
        if int(restartFreq) < 0:
            #Restartの設定
            self.checkBtn_solverRestart.set_active(True)
        else:
            #Restartせず
            self.checkBtn_solverRestart.set_active(False)
        #fistrDirを設定
        nMax = 50
        if len(frontIstrFolder) > nMax:
            cont = "..." + frontIstrFolder[nMax-3:]
        else:
            cont = frontIstrFolder
        self.label_fistrDir.set_label(cont)
        #変換buttonの表示非表示設定
        self.showHideInpRadButton()
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  setSolverLinPage
    #    線形solverのpage作成
    def setSolverLinPage(self):
        values = getSolverContFromCnt()
        method = values[0]
        precond = values[1]
        nIter = values[2]
        resid = values[3]
        solvers = solveMethod
        self.setComboDataInComboBox(self.listmodelSlinMethod, self.comboBox_slinMethod, solvers)
        self.setComboActiveText(self.comboBox_slinMethod, method, solvers)
        self.textCtrl_slinPrecond.set_text(precond)
        self.textCtrl_slinNiter.set_text(nIter)
        self.textCtrl_slinResid.set_text(resid)
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  setPostPage
    #--------------
    def setPostPage(self):
        #fistrVersionに応じてbtnを表示・非表示設定する
        fistrVer = self.getFistrVersionFromIstrData()
        if fistrVer == "5.0":
            #ver 5.0用のbtnを表示
            self.radioBtn_useVtk.set_sensitive(True)
            self.radioBtn_useVtu.set_sensitive(True)
            self.setUseVtkOrVtu()
        else:
            #ver 4.6用のbtnを表示
            self.radioBtn_useVtk.set_sensitive(False)
            self.radioBtn_useVtu.set_sensitive(False)
            self.radioBtn_useVtk.set_active(True)
            self.setUseVtkOrVtu()
        #並列処理の設定
        currDir = currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        parallel = False
        nCpu = "1"
        #並列処理？
        values = getHecmwContFromDat()
        if values[0] == True:
            parallel = True
            nCpu = values[1]
        else:
            #thread?
            (para, nCpu, nThread, fistrVersion) = getParallelInSavedData()
            try:
                nn = int(nThread)
            except:
                nn = 0
            if nn > 1:
                #resFile数を確認
                nameDict = pyFistr.getCntMshFileNameDict(currDir)
                resName = nameDict["res"]
                #res0File = currDir + os.sep + "FistrModel.res.0.*"
                res0File = currDir + os.sep + resName + ".0.*"
                res0Files = glob.glob(res0File)
                #res1File = currDir + os.sep + "FistrModel.res.1.*"
                res1File = currDir + os.sep + resName + ".1.*"
                res1Files = glob.glob(res1File)
                if (len(res0Files) >= 2 and len(res1Files) == 0):
                    #並列設定
                    parallel = True
                    nCpu = nThread
        #label, entryの設定
        if parallel == True:
            self.checkBtn_postPara.set_active(True)
            self.textCtrl_postNProcs.set_text(nCpu)
        else:
            self.checkBtn_postPara.set_active(False)
        os.chdir(currDirTemp)
        #inpFrdToVtu変換buttonの表示非表示設定
        self.showHideInpVtuButton()
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  hideAutoincParts
    def hideAutoincParts(self):
        """ autoincのpartsを隠す"""
        self.autoincParts(False)

    #
    #  showAutoincParts
    def showAutoincParts(self):
        """ autoincのpartsを表示"""
        self.autoincParts(True)

    def autoincParts(self, stat):
        self.textCtrl_minDt.set_sensitive(stat)
        self.textCtrl_maxDt.set_sensitive(stat)
        self.textCtrl_nRes.set_sensitive(stat)
        self.textCtrl_stepDtime.set_sensitive(stat)
        self.textCtrl_stepEtime.set_sensitive(stat)
        self.label_DTIME.set_sensitive(stat)
        self.label_ETIME.set_sensitive(stat)
        self.label_minDt.set_sensitive(stat)
        self.label_maxDt.set_sensitive(stat)
        self.label_incCond.set_sensitive(stat)
        self.label_decCond.set_sensitive(stat)
        self.label_cutBackCond.set_sensitive(stat)
        self.label_incVal.set_sensitive(stat)
        self.label_decVal.set_sensitive(stat)
        self.label_cutbackVal.set_sensitive(stat)
        self.label_nRes.set_sensitive(stat)
        self.button_editAutoinc.set_sensitive(stat)

    #
    #  showFixincParts
    def showFixincParts(self):
        """ fixincのpartsを表示"""
        self.fixincParts(True)
        stepName = self.label_stepName.get_text()
        values = self.readStepNameValueFromCnt(stepName)
        solutionType = values[7]
        if solutionType != "DYNAMIC":
            #staticの場合は、隠す
            self.textCtrl_stepDtime.set_sensitive(False)
            self.textCtrl_stepEtime.set_sensitive(False)
            self.label_DTIME.set_sensitive(False)
            self.label_ETIME.set_sensitive(False)

    #
    #  hideFixincParts
    def hideFixincParts(self):
        """ fixincのpartsを隠す"""
        self.fixincParts(False)

    def fixincParts(self, stat):
        self.textCtrl_stepSubStep.set_sensitive(stat)
        self.textCtrl_stepDtime.set_sensitive(stat)
        self.textCtrl_stepEtime.set_sensitive(stat)
        self.label_DTIME.set_sensitive(stat)
        self.label_ETIME.set_sensitive(stat)

    #
    #  setStep_sub
    #
    def setStep_sub(self, stepName):
        global autoincParamData

        def getNoBnds(allBnds, cLines):
            noLines = []
            for allBnd in allBnds:
                newList = allBnd[:2] + [allBnd[-1]]
                allLine = ",".join(newList)
                flag = 0
                for cLine in cLines:
                    if allLine == cLine:
                        flag = 1
                        break
                if flag == 0:
                    noLines.append(allLine)
            return noLines

        self.label_stepName.set_text(stepName)
        self.setControlCont()       #追加24/08/16
        bndList = getStepBndListFromDefineData(stepName)
        stepTypes = [u"STATIC", u"VISCO"]
        self.setComboDataInComboBox(self.listmodelStepType, self.comboBox_stepType, stepTypes)
        values = self.readStepNameValueFromCnt(stepName)
        stepType = values[0]
        converg = values[1]
        subSteps = values[2]
        maxIter, maxContIter = values[3]
        dTime = values[4]
        eTime = values[5]
        bnds = values[6]
        _solutionType = values[7]
        cBnds = reformStepBCCont(bnds, bndList)
        cBnds = pyFistr.deleteSameData(cBnds)
        noBnds = getNoBnds(bndList, cBnds)
        noBnds = pyFistr.deleteSameData(noBnds)
        incType = values[8]
        minDt = values[9]
        maxDt = values[10]
        timePoints = values[11]
        autoParam = values[12]
        self.setComboActiveText(self.comboBox_stepType, stepType, stepTypes)
        self.textCtrl_stepConv.set_text(converg)
        self.textCtrl_stepSubStep.set_text(subSteps)
        self.textCtrl_stepMaxIter.set_text(maxIter)
        self.textCtrl_maxContIter.set_text(maxContIter)
        self.setListDataInListBoxStep(self.listmodelStepNoCnd, self.listBox_stepNoCnd, noBnds)
        self.setListDataInListBoxStep(self.listmodelStepSetCnd, self.listBox_stepSetCnd, cBnds)
        #autoincの設定
        self.textCtrl_stepDtime.set_text(dTime)
        self.textCtrl_stepEtime.set_text(eTime)
        self.textCtrl_minDt.set_text(minDt)
        self.textCtrl_maxDt.set_text(maxDt)
        if len(timePoints[1]) > 0:
            interval = deleteSp(timePoints[1][0]).split(",")[0]
            try:
                nRes = str(int(float(eTime) / float(interval)))
            except:
                nRes = "1"
        else:
            nRes = "1"
        self.textCtrl_nRes.set_text(nRes)
        if len(autoParam[1]) > 0:
            decLine = deleteSp(autoParam[1][0]).split()[0]
            incLine = deleteSp(autoParam[1][1]).split()[0]
            cutBackLine = deleteSp(autoParam[1][2]).split()[0]
            autoincParamData = autoParam[1]
        else:
            data = defaultAutoincParamLines()
            decLine = deleteSp(data[0]).split()[0]
            incLine = deleteSp(data[1]).split()[0]
            cutBackLine = deleteSp(data[2]).split()[0]
            autoincParamData = data
        self.label_decVal.set_text(("%-20s" % decLine)[:20])
        self.label_incVal.set_text(("%-20s" % incLine)[:20])
        self.label_cutbackVal.set_text(("%-20s" % cutBackLine)[:20])
        #GUIの表示を設定
        if self.checkBtn_autoinc.get_active() == False:
            #初期設定がFixの場合
            if incType == "FIX":
                self.hideAutoincParts()
                self.showFixincParts()
            else:
                #heckBtnを変更することで、表示が変わる
                self.checkBtn_autoinc.set_active(True)
        else:
            #初期設定がAutoの場合
            if incType == "AUTO":
                self.hideFixincParts()
                self.showAutoincParts()
            else:
                #heckBtnを変更することで、表示が変わる
                self.checkBtn_autoinc.set_active(False)
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  setContact_sub
    #
    def setContact_sub(self, name):
        global selPairName
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        #pairNameを取得
        self.setElGroupToLabel(self.contactGrpLabel, name)
        selPairName = name
        #conts（接触の設定を取得）
        conts = getContactContInCntMsh(name, nStep)
        pairType = conts[0]
        slave = conts[1]
        master = conts[2]
        interaction = conts[3]
        nTol = conts[4]
        tTol = conts[5]
        coeff = conts[6]
        factor = conts[7]
        #contactTypeを設定
        if pairType == "NODE-SURF":
            self.radioBtn_pointToPoint.set_active(True)
        else:
            self.radioBtn_faceToFace.set_active(True)
        #interactionComboを設定
        #interactions = [_(u"SSLID （微小すべり）"), _(u"FSLID （有限すべり）")]
        interactions = [_(u"SSLID （微小すべり）"),
                        _(u"FSLID （有限すべり）"),
                        _(u"TIED （結合）ver5.5以降")]
        self.setComboDataInComboBox(self.listmodelCntIntr, self.comboBox_cntIntr, interactions)
        n = 0
        for name in interactions:
            if name.split()[0] == interaction:
                break
            n += 1
        self.comboBox_cntIntr.set_active(n)
        self.textCtrl_cntNtol.set_text(nTol)
        self.textCtrl_cntTtol.set_text(tTol)
        self.textCtrl_cntCoeff.set_text(coeff)
        self.textCtrl_cntFact.set_text(factor) 
        #slave側のgrp名を設定
        if pairType == "NODE-SURF":
            slaveNames = meshGroup[2]   #NGRP
        else:
            slaveNames = meshGroup[1]   #SGRP
        slaveNames.sort()
        self.setComboDataInComboBox(self.listmodelCntSlave, self.comboBox_cntSlave, slaveNames)
        n = 0
        for name in slaveNames:
            if name == slave:
                break
            n += 1
        self.comboBox_cntSlave.set_active(n)
        #master側のgrp名を設定
        masterNames = meshGroup[1]
        masterNames.sort()
        self.setComboDataInComboBox(self.listmodelCntMaster, self.comboBox_cntMaster, masterNames)
        n = 0
        for name in masterNames:
            if name == master:
                break
            n += 1
        self.comboBox_cntMaster.set_active(n)
        #vtk再表示
        #self.preSelectedActors = []
        if pairType == "NODE-SURF":
            self.preSelectedActors = ["nodeGrp_" + slave]
        else:
            self.preSelectedActors = ["surfaceGrp_" + slave]
        self.selectedActors = ["surfaceGrp_" + master]
        self.showSelectedModel()

    #
    #  setCent_sub
    #
    def setCent_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.centGrpLabel, name)
        values = self.readCentEgrpName(name, nStep)
        self.textCtrl_centOm.set_text(values[0])
        self.textCtrl_centPx.set_text(values[1])
        self.textCtrl_centPy.set_text(values[2])
        self.textCtrl_centPz.set_text(values[3])
        self.textCtrl_centDx.set_text(values[4])
        self.textCtrl_centDy.set_text(values[5])
        self.textCtrl_centDz.set_text(values[6])
        #単位をセット
        self.setUnitToCentSubPage()
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["elementGrp_" + name]
        self.showSelectedModel()

    def setUnitToCentSubPage(self):
        """ 単位をセット"""
        units = [["omega",["unit_omega_cent"]],
                 ["len", ["unit_centx_cent", "unit_centy_cent", "unit_centz_cent"]]]
        self.setUnitToPage(units)

    #
    #  setSpring_sub
    #
    def setSpring_sub(self, name):

        def showRotationValue():
            self.checkBtn_springRX.set_sensitive(True)
            self.checkBtn_springRY.set_sensitive(True)
            self.checkBtn_springRZ.set_sensitive(True)
            self.textCtrl_springRX.set_sensitive(True)
            self.textCtrl_springRY.set_sensitive(True)
            self.textCtrl_springRZ.set_sensitive(True)

        def hideRotationValue():
            self.checkBtn_springRX.set_sensitive(False)
            self.checkBtn_springRY.set_sensitive(False)
            self.checkBtn_springRZ.set_sensitive(False)
            self.textCtrl_springRX.set_sensitive(False)
            self.textCtrl_springRY.set_sensitive(False)
            self.textCtrl_springRZ.set_sensitive(False)

        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        self.setElGroupToLabel(self.label_springGrp, name)
        [x, y, z, rx, ry, rz] = self.readSpringValueFromCont(name, nStep)
        meshCont = self.label_meshCnt.get_label()
        rotation = getRotationNodeGroup(name, meshCont)
        if rotation == True:
            showRotationValue()
        else:
            hideRotationValue()
        #単位を設定
        self.setUnitToSpringSubPage()
        #変位
        if x == "":
            self.checkBtn_springX.set_active(False)
            self.textCtrl_springX.set_text("0.0")
        else:
            self.checkBtn_springX.set_active(True)
            self.textCtrl_springX.set_text(x)
        if y == "":
            self.checkBtn_springY.set_active(False)
            self.textCtrl_springY.set_text("0.0")
        else:
            self.checkBtn_springY.set_active(True)
            self.textCtrl_springY.set_text(y)
        if z == "":
            self.checkBtn_springZ.set_active(False)
            self.textCtrl_springZ.set_text("0.0")
        else:
            self.checkBtn_springZ.set_active(True)
            self.textCtrl_springZ.set_text(z)
        #回転
        if rotation == True:
            if rx == "":
                self.checkBtn_springRX.set_active(False)
                self.textCtrl_springRX.set_text("0.0")
            else:
                self.checkBtn_springRX.set_active(True)
                self.textCtrl_springRX.set_text(rx)
            if ry == "":
                self.checkBtn_springRY.set_active(False)
                self.textCtrl_springRY.set_text("0.0")
            else:
                self.checkBtn_springRY.set_active(True)
                self.textCtrl_springRY.set_text(ry)
            if rz == "":
                self.checkBtn_springRZ.set_active(False)
                self.textCtrl_springRZ.set_text("0.0")
            else:
                self.checkBtn_springRZ.set_active(True)
                self.textCtrl_springRZ.set_text(rz)
        else:
            self.checkBtn_springRX.set_active(False)
            self.textCtrl_springRX.set_text("")
            self.checkBtn_springRY.set_active(False)
            self.textCtrl_springRY.set_text("")
            self.checkBtn_springRZ.set_active(False)
            self.textCtrl_springRZ.set_text("")
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToSpringSubPage(self):
        """ 単位を設定"""
        units = [["spring", ["unit_kx_spring", "unit_ky_spring", "unit_kz_spring"]],
                 ["springR", ["unit_Rx_spring", "unit_Ry_spring", "unit_Rz_spring"]]]
        self.setUnitToPage(units)

    #
    #  setVload_sub
    #
    def setVload_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.vloadGrpLabel, name)
        values = self.readVloadEgrpName(name, nStep)
        self.textCtrl_vloadBx.set_text(values[0])
        self.textCtrl_vloadBy.set_text(values[1])
        self.textCtrl_vloadBz.set_text(values[2])
        #単位を設定
        self.setUnitToVloadSubPage()
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["elementGrp_" + name]
        self.showSelectedModel()

    def setUnitToVloadSubPage(self):
        """ VLOADに単位を設定"""
        units = [["forceB", ["unit_Bx_vload", "unit_By_vload", "unit_Bz_vload"]]]
        self.setUnitToPage(units)

    #
    #  setDload_sub
    #    pageの初期化
    def setDload_sub(self, name):
        nStep = self.getStepIdFromSubItem()
        self.setElGroupToLabel(self.dloadGrpLabel, name)
        values, forceTypes = self.readDloadSgrpName(name, nStep)
        self.textCtrl_dload.set_text(values[0])
        #単位の設定
        self.setUnitToDloadSubPage()
        #mappingの設定
        forceType = forceTypes[0]
        if forceType == "mapping":
            #mappingの場合
            mapFile = forceTypes[1]; mapCoeff = forceTypes[2]
            mapShift = forceTypes[3]
            if mapShift == "":
                mapShift = "0.0"
            self.radioBtn_pressDist.set_active(True)
            ptcFile = self.setOpenFoamContsToTextCtrl(mapFile)
        else:
            #均一圧力の場合
            ptcFile = self.setOpenFoamContsToTextCtrl("")
            ptcFile = ""; mapCoeff = "1.0"; mapShift = "0.0"
            self.radioBtn_pressUniform.set_active(True)
        self.textCtrl_ptcFile.set_text(ptcFile)
        self.textCtrl_ptcCoeff.set_text(mapCoeff)
        self.textCtrl_ptcShift.set_text(mapShift)
        self.selectPressureType()
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["surfaceGrp_" + name]
        self.showSelectedModel()

    def setUnitToDloadSubPage(self):
        """ dloadSubに単位を設定"""
        units = [["press", ["unit_press_dload"]]]
        self.setUnitToPage(units)

    #
    #  setOpenFoamContsToTextCtrl
    def setOpenFoamContsToTextCtrl(self, mapFile):
        """ ptcFileからOpenFOAMの設定内容を取得する。
        fileが存在しない場合は、""を戻す。 """
        #ptcFile名を取得
        ptcFile = ""
        currDir = getCurrDirFromTempFolder()
        fileName = currDir + os.sep + mapFile
        if os.path.exists(fileName) == True and mapFile != "":
            ptcFile = self.readPtcFileNameFromMapFile(fileName)
        #ptcFileからOpenFoamの内容を取得
        caseDir = ""; time = ""; region = ""; field = ""; patch = ""
        fileName = currDir + os.sep + ptcFile
        if os.path.exists(fileName) == True and ptcFile != "":
            #ptcFileを読み込み
            (caseDir, time, region, field, patches) = self.readOpenFoamContsFromPtcFile(fileName)
            if caseDir != "":
                #openFOAM結果設定
                self.setCaseDirTimeRegionFieldPatch(caseDir, time, region, field, patches)
            else:
                #その他点群を設定
                source, cont = self.readOthherContsFromPtcFile(fileName)
                conts = source + "\n" + cont
                builder.get_object("label_timeField_p15").set_label(conts)
        else:
            #均一圧力設定
            conts = ""
            builder.get_object("label_timeField_p15").set_label(conts)
        return ptcFile

    #
    def setCaseDirTimeRegionFieldPatch(self, caseDir, time, region, field, patches):
        """ caseDir, time, region, field, patchをtextCtrlに表示"""
        #OFcontsを作成する。
        line  = "caseDir: " + self.shrinkLineTop(caseDir, 53) + ls
        #conts = self.shrinkLineEnd(line, 62)
        conts = line
        if region == ".":
            region = "(region0)"
        line = "time: " + time + ", region: " + region + ", field: " + field + "\n"
        conts += self.shrinkLineEnd(line, 62)
        line = "boundary: " + ",".join(patches)
        conts += self.shrinkLineEnd(line, 62)
        builder.get_object("label_timeField_p15").set_label(conts)

    #
    def shrinkLineTop(self, line, length):
        """ lineの先頭をlengthの長さに縮める"""
        if len(line) > length:
            line = "..." + line[-length-4:]
        return line

    #
    def shrinkLineEnd(self, line, length):
        """ lineの行末をlengthの長さに縮める"""
        if len(line) > length:
            line = line[:(length-4)] + "..." + ls
        return line

    #
    def readPtcFileNameFromMapFile(self, mapFile):
        """ mapFileからptcFileNameを取得し、返す"""
        ptcFile = ""
        f = open(mapFile, encoding="utf-8"); cont = f.read(1000); f.close()
        lines = cont.split("\n")
        for line in lines:
            if line[0] == "#":
                words = line.split()
                if len(words) >= 3:
                    if words[1] == "ptcFile":
                        ptcFile = words[2]
                        break
        return ptcFile

    #
    def readOpenFoamContsFromPtcFile(self, ptcFile):
        """ ptcFileからOpenFOAMの内容を読み込み戻す。"""
        caseDir = ""; time = ""; region = ""; field = ""; patches = []
        #ptcFileを読み込み
        f = open(ptcFile, encoding="utf-8"); cont = f.read(1000); f.close()
        lines = cont.split("\n")
        for line in lines:
            if line[0] == "#":
                words = line.split()
                if len(words) >= 3:
                    if words[1] == "caseDir":
                        caseDir = words[2]
                    elif words[1] == "time":
                        time = words[2]
                    elif words[1] == "region":
                        region = words[2]
                    elif words[1] == "field":
                        field = words[2]
                    elif words[1] == "patch" or words[1] == "boundary":
                        patches = words[2:]
            else:
                break
        return caseDir, time, region, field, patches

    #
    #  readOthherContsFromPtcFile
    def readOthherContsFromPtcFile(self, ptcFile):
        """ ptcFileからその他の内容を読み込む"""
        #初期値設定
        source = "original data"
        ptcCont = "   ---- "
        f = open(ptcFile, encoding="utf-8"); cont = f.read(1000); f.close()
        lines = cont.split("\n")
        for line in lines:
            if line[0] == "#":
                words = line.split()
                if len(words) >= 3:
                    if words[1] == "source" or words[1] == "title":
                        source = " ".join(words[2:])
                    elif words[1] == "cont" or words[1] == "contents":
                        ptcCont = " ".join(words[2:])
            else:
                break
        return source, ptcCont

    #
    #  setAcceleration_sub
    #    pageの初期化
    def setAcceleration_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.label_accelGrp, name)
        [x, y, z] = self.readAccelNgrpName(name, nStep)
        self.textCtrl_accelX.set_text(x)
        self.textCtrl_accelY.set_text(y)
        self.textCtrl_accelZ.set_text(z)
        self.checkBtn_Ax.set_active(False)
        self.checkBtn_Ay.set_active(False)
        self.checkBtn_Az.set_active(False)
        if x != "":
            self.checkBtn_Ax.set_active(True)
        if y != "":
            self.checkBtn_Ay.set_active(True)
        if z != "":
            self.checkBtn_Az.set_active(True)
        #単位を設定
        self.setUnitToAccelerationPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToAccelerationPage(self):
        """ 単位を設定"""
        units = [["accel", ["unit_Ax_accel", "unit_Ay_accel", "unit_Az_accel"]]]
        self.setUnitToPage(units)


    #
    #  setVelocity_sub
    #    pageの初期化
    def setVelocity_sub(self, name):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        self.setElGroupToLabel(self.label_veloGrp, name)
        [x, y, z, typeName] = self.readVeloNgrpName(name, nStep)
        self.textCtrl_veloX.set_text(x)
        self.textCtrl_veloY.set_text(y)
        self.textCtrl_veloZ.set_text(z)
        self.setComboVelType(typeName)
        self.checkBtn_Vx.set_active(False)
        self.checkBtn_Vy.set_active(False)
        self.checkBtn_Vz.set_active(False)
        if x != "":
            self.checkBtn_Vx.set_active(True)
        if y != "":
            self.checkBtn_Vy.set_active(True)
        if z != "":
            self.checkBtn_Vz.set_active(True)
        #単位を表示
        self.setUnitToVelocitySubPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToVelocitySubPage(self):
        """ 単位を設定"""
        units = [["velo", ["unit_Vx_velocity", "unit_Vy_velocity", "unit_Vz_velocity"]]]
        self.setUnitToPage(units)

    #
    #  setComboVelType
    def setComboVelType(self, typeName):
        """ velocityのtypeをcomboBoxに設定する"""
        items = ["INITIAL", "TRANSIT"]
        if not (typeName in items):
            typeName = "TRANSIT"
        self.comboBox_velType.setItems(items)
        self.comboBox_velType.selectItem(typeName)

    #
    #  setFload_sub
    #    pageの初期化
    def setFload_sub(self, name):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        self.setElGroupToLabel(self.floadGrpLabel, name)
        values = self.readFloadNgrpName(name, nStep)
        loadCase = values[0]
        [x, y, z] = values[1]
        self.textCtrl_floadCase.set_text(loadCase)
        self.textCtrl_floadX.set_text(x)
        self.textCtrl_floadY.set_text(y)
        self.textCtrl_floadZ.set_text(z)
        #単位を設定
        self.setUnitToFloadSubPage()
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToFloadSubPage(self):
        """ 単位を設定"""
        units = [["force", ["unit_fx_fload", "unit_fy_fload", "unit_fz_fload"]]]
        self.setUnitToPage(units)

    #
    #  setAmplitude_sub
    #    pageの初期化
    def setAmplitude_sub(self, name):

        def getNoBnds(allBnds, setBnds):
            noBnds = []
            for allBnd in allBnds:
                newList = allBnd[:2] + [allBnd[-1]]
                allLine = ",".join(newList)
                flag = 0
                for sLine in setBnds:
                    if allLine == sLine:
                        flag = 1
                        break
                if flag == 0:
                    noBnds.append(allLine)
            return noBnds

        self.setElGroupToLabel(self.label_ampGrp, name)
        setValues = ampValTypes()
        self.setComboDataInComboBox(self.listmodelAmpValue, self.comboBox_ampValue, setValues)
        value = self.readAmpGrpNameInMsh(name)
        setBndList = self.readAmpGrpNameInCnt(name)
        setBndList.sort()
        i = 0
        if value == "ABSOLUTE":
            i = 1
        self.comboBox_ampValue.set_active(i)
        allBndList = getAllStepBndListFromDefineData()
        #STEPがあれば追加
        allBndList += getStepListFromCnt()
        noBndList = getNoBnds(allBndList, setBndList)
        noBndList.sort()
        self.setListDataInListBox(self.listmodelAmpNoGrp, self.listBox_ampNoGrp, noBndList)
        self.setListDataInListBox(self.listmodelAmpSetGrp, self.listBox_ampSetGrp, setBndList)
        #vtk再表示
        self.showNoneSelectedModel()

    #
    #  setSradiate_sub
    #    pageの初期化
    def setSradiate_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.label_sradiateGrp, name)
        values = self.readSradiateEgrpName(name, nStep)
        self.textCtrl_sradiateVal.set_text(values[0])
        self.textCtrl_sradiateAmb.set_text(values[1])
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["surfaceGrp_" + name]
        self.showSelectedModel()

    #
    #  setSfilm_sub
    #    pageの初期化
    def setSfilm_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.label_sfilmGrp, name)
        values = self.readSfilmEgrpName(name, nStep)
        self.textCtrl_sfilmVal.set_text(values[0])
        self.textCtrl_sfilmAmb.set_text(values[1])
        #単位の設定
        self.setUnitToSfilmSubPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["surfaceGrp_" + name]
        self.showSelectedModel()

    def setUnitToSfilmSubPage(self):
        """ 単位の設定"""
        units = [["heatTr", ["unit_heatTr_sfilm"]]]
        self.setUnitToPage(units)

    #
    #  setDflux_sub
    #    pageの初期化
    def setDflux_sub(self, name):
        nStep = self.getStepIdFromSubItem()        #stepIdを取得
        self.setElGroupToLabel(self.label_dfluxGrp, name)
        values = self.readDfluxSgrpName(name, nStep)
        faceNo, value = values
        items = ["S1", "S2", "S3", "S4", "S5", "S6"]
        self.comboBox_dflux.setItems(items)
        self.comboBox_dflux.selectItem(faceNo)
        self.textCtrl_dflux.set_text(value)
        #単位を表示
        self.setUnitToDfluxSubPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["surfaceGrp_" + name]
        self.showSelectedModel()

    def setUnitToDfluxSubPage(self):
        """ 単位を設定"""
        units = [["wattF", ["unit_wf_dflux"]]]
        self.setUnitToPage(units)

    #
    #  setBf_sub
    #    pageの初期化
    def setBf_sub(self, name):
        nStep = self.getStepIdFromSubItem()        #stepIdを取得
        self.setElGroupToLabel(self.label_bfGrp, name)
        value = self.readBfEgrpName(name, nStep)
        self.textCtrl_bf.set_text(value)
        #単位を設定
        self.setUnitToBfSubPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["elementGrp_" + name]
        self.showSelectedModel()

    def setUnitToBfSubPage(self):
        """ 単位を設定"""
        units = [["wattV", ["unit_wattV_bf"]]]
        self.setUnitToPage(units)

    #
    #  setSflux_sub
    #    pageの初期化
    def setSflux_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepId取得
        self.setElGroupToLabel(self.label_sfluxGrp, name)
        value = self.readSfluxNgrpName(name, nStep)
        self.textCtrl_sflux.set_text(value)
        #単位の設定
        self.setUnitToSfluxSubPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["surfaceGrp_" + name]
        self.showSelectedModel()

    def setUnitToSfluxSubPage(self):
        """ 単位の設定"""
        units = [["wattF", ["unit_wf_sflux"]]]
        self.setUnitToPage(units)

    #
    #  setCflux_sub
    #    pageの初期化
    def setCflux_sub(self, name):
        nStep = self.getStepIdFromSubItem()     #stepIdを取得
        self.setElGroupToLabel(self.label_cfluxGrp, name)
        [value, qwType] = self.readCfluxNgrpName(name, nStep)
        if qwType == "aveQw":
            self.radioBtn_aveQw.set_active(True)
        elif qwType == "trueQw":
            self.radioBtn_trueQw.set_active(True)
        else:
            self.radioBtn_nodeQw.set_active(True)
        self.textCtrl_cflux.set_text(value)
        #単位の設定
        self.setUnitToCfluxSubPage()
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToCfluxSubPage(self):
        """ 単位の設定"""
        units = [["watt", ["unit_w_cflux"]]]
        self.setUnitToPage(units)

    #
    #  setInitial_sub
    #    pageの初期化
    def setInitial_sub(self, name):
        self.setElGroupToLabel(self.label_initialGrp, name)
        value = self.readInitialNgrpName(name)
        self.textCtrl_initempTemp.set_text(value)
        #vtk再表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    #
    #  setReftemp
    #-------------
    def setReftemp(self):
        """ REFTEMPを表示する"""
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        value = self.readReftempValue(nStep)
        if value == "":
            value = "0.0"
        try:
            a = float(value)
        except:
            value = "0.0"
        self.textCtrl_reftemp.set_text(value)
        self.showNoneSelectedModel()

    #
    #  setFixtemp_sub
    #    pageの初期化
    def setFixtemp_sub(self, name):
        nStep = self.getStepIdFromSubItem()         #stepIdを取得
        self.setElGroupToLabel(self.label_fixtempGrp, name)
        value = self.readFixtempNgrpName(name, nStep)
        self.textCtrl_fixtemp.set_text(value)
        #vtk表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    #
    #  setCload_sub
    #    pageの初期化
    def setCload_sub(self, name):
        #stepIdを取得
        nStep = self.getStepIdFromSubItem()
        #labelをセット
        self.setElGroupToLabel(self.cloadGrpLabel, name)
        #単位を設定
        self.setUnitToCloadSubPage()
        #値を取得
        [[x, y, z, Mx, My, Mz], forceType] = self.readCloadNgrpName(name, nStep)
        meshCont = self.label_meshCnt.get_label()
        rotation = getRotationNodeGroup(name, meshCont)
        if rotation == True:
            self.showRotationCloadValue()
        else:
            self.hideRotationCloadValue()
            Mx = []; My = []; Mz = []
        self.setCloadContToTextBox([x, y, z, Mx, My, Mz], forceType, name)
        #vtkを再表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToCloadSubPage(self):
        """ 単位を設定"""
        units = [["force", ["unit_Fx_cload", "unit_Fy_cload", "unit_Fz_cload"]],
                 ["moment", ["unit_Mx_cload", "unit_My_cload", "unit_Mz_cload"]]]
        self.setUnitToPage(units)

    #  showRotationCloadValue
    #    Cloadの回転のtextBoxを表示する
    def showRotationCloadValue(self):
        self.textCtrl_Mx.set_sensitive(True)
        self.textCtrl_My.set_sensitive(True)
        self.textCtrl_Mz.set_sensitive(True)
        self.label_Mx.set_sensitive(True)
        self.label_My.set_sensitive(True)
        self.label_Mz.set_sensitive(True)

    #  hideRotationCloadValue
    #    Cloadの回転のtextBoxを隠す
    def hideRotationCloadValue(self):
        self.textCtrl_Mx.set_sensitive(False)
        self.textCtrl_My.set_sensitive(False)
        self.textCtrl_Mz.set_sensitive(False)
        self.label_Mx.set_sensitive(False)
        self.label_My.set_sensitive(False)
        self.label_Mz.set_sensitive(False)

    #
    #  setBoundary_sub
    #    pageの初期化
    def setBoundary_sub(self, name):
        #stepIdを取得
        nStep = self.getStepIdFromSubItem()
        #labelをセット
        self.setElGroupToLabel(self.boundaryGrpLabel, name)
        #単位をセット
        self.setUnitToBoundarySubPage()
        #値を取得
        [x, y, z, Rx, Ry, Rz] = self.readBoundaryNgrpName(name, nStep)
        meshCont = self.label_meshCnt.get_label()
        rotation = getRotationNodeGroup(name, meshCont)
        if rotation == True:
            self.showRotationValue()
        else:
            self.hideRotationValue()
            Rx = []; Ry = []; Rz = []
        self.setBoundaryContToTextBox([x, y, z, Rx, Ry, Rz])
        #vtkを再表示
        self.preSelectedActors = []
        self.selectedActors = ["nodeGrp_" + name]
        self.showSelectedModel()

    def setUnitToBoundarySubPage(self):
        """ 単位を設定する"""
        units = [["len", ["unit_dispx_boundary", "unit_dispy_boundary", "unit_dispz_boundary"]]]
        self.setUnitToPage(units)

    #  showRotationValue
    #    回転のcheckBtnを表示する
    def showRotationValue(self):
        self.checkBtn_Rx.set_sensitive(True)
        self.checkBtn_Ry.set_sensitive(True)
        self.checkBtn_Rz.set_sensitive(True)
        self.textCtrl_Rx.set_sensitive(True)
        self.textCtrl_Ry.set_sensitive(True)
        self.textCtrl_Rz.set_sensitive(True)

    #  hideRotationValue
    #    回転のcheckBtnを隠す
    def hideRotationValue(self):
        self.checkBtn_Rx.set_sensitive(False)
        self.checkBtn_Ry.set_sensitive(False)
        self.checkBtn_Rz.set_sensitive(False)
        self.textCtrl_Rx.set_sensitive(False)
        self.textCtrl_Ry.set_sensitive(False)
        self.textCtrl_Rz.set_sensitive(False)

    #  setCloadContToTextBox
    def setCloadContToTextBox(self, bndCont, forceType, name):
        if forceType == "nodeForce":
            self.radioBtn_nodeForce.set_active(True)
        elif forceType == "aveForce":
            self.radioBtn_aveForce.set_active(True)
        elif forceType == "trueForce":
            self.radioBtn_trueForce.set_active(True)

        x = bndCont[0]
        y = bndCont[1]
        z = bndCont[2]
        Mx = bndCont[3]
        My = bndCont[4]
        Mz = bndCont[5]
        if len(x) > 0:
            v = bndCont[0][1]
            self.textCtrl_cloadX.set_text(v)
        else:
            self.textCtrl_cloadY.set_text("0.0")
        if len(y) > 0:
            v = bndCont[1][1]
            self.textCtrl_cloadY.set_text(v)
        else:
            self.textCtrl_cloadY.set_text("0.0")
        if len(z) > 0:
            v = bndCont[2][1]
            self.textCtrl_cloadZ.set_text(v)
        else:
            self.textCtrl_cloadZ.set_text("0.0")

        if len(Mx) > 0:
            v = Mx[1]
        else:
            v = ""
        self.textCtrl_Mx.set_text(v)
        if len(My) > 0:
            v = My[1]
        else:
            v = ""
        self.textCtrl_My.set_text(v)
        if len(Mz) > 0:
            v = Mz[1]
        else:
            v = ""
        self.textCtrl_Mz.set_text(v)

    #  setBoundaryContToTextBox
    def setBoundaryContToTextBox(self, bndCont):
        x = bndCont[0]
        y = bndCont[1]
        z = bndCont[2]
        Rx = bndCont[3]
        Ry = bndCont[4]
        Rz = bndCont[5]
        if len(x) > 0:
            v = bndCont[0][1]
            self.checkBtn_bndX.set_active(True)
            self.textCtrl_bndX.set_text(v)
        else:
            self.checkBtn_bndX.set_active(False)
            self.textCtrl_bndX.set_text("")
        if len(y) > 0:
            v = bndCont[1][1]
            self.checkBtn_bndY.set_active(True)
            self.textCtrl_bndY.set_text(v)
        else:
            self.checkBtn_bndY.set_active(False)
            self.textCtrl_bndY.set_text("")
        if len(z) > 0:
            v = bndCont[2][1]
            self.checkBtn_bndZ.set_active(True)
            self.textCtrl_bndZ.set_text(v)
        else:
            self.checkBtn_bndZ.set_active(False)
            self.textCtrl_bndZ.set_text("")

        if len(Rx) > 0:
            v = bndCont[3][1]
            self.checkBtn_Rx.set_active(True)
            self.textCtrl_Rx.set_text(v)
        else:
            self.checkBtn_Rx.set_active(False)
            self.textCtrl_Rx.set_text("")
        if len(Ry) > 0:
            v = bndCont[4][1]
            self.checkBtn_Ry.set_active(True)
            self.textCtrl_Ry.set_text(v)
        else:
            self.checkBtn_Ry.set_active(False)
            self.textCtrl_Ry.set_text("")
        if len(Rz) > 0:
            v = bndCont[5][1]
            self.checkBtn_Rz.set_active(True)
            self.textCtrl_Rz.set_text(v)
        else:
            self.checkBtn_Rz.set_active(False)
            self.textCtrl_Rz.set_text("")

    #
    #  readStepValueFromCnt
    #    STEPの値を取得
    def readStepValueFromCnt(self):
        values = []
        lines = readFistrModelCnt()
        i = 0
        while i < len(lines):
            line = lines[i]
            if line[:len("!STEP")] == "!STEP":
                stepType = abaqus2fistr.getValName(line, "TYPE")
                if stepType == "":
                    stepType = "STATIC"
                converg = abaqus2fistr.getValName(line, "CONVERG")
                if converg == "":
                    converg = "1.0e-6"
                subSteps = abaqus2fistr.getValName(line, "SUBSTEPS")
                if subSteps == "":
                    subSteps = "1"
                maxIter = abaqus2fistr.getValName(line, "MAXITER")
                if maxIter == "":
                    maxIter = "50"
                i += 1
                words = deleteSp(lines[i]).split(",")
                flag = 0
                try:
                    dTime = str(float(words[0]))
                    eTime = str(float(words[1]))
                    flag = 1
                except:
                    dTime = "1.0"
                    eTime = "1.0"
                if flag == 1:
                    i += 1
                bnds = []
                while i < len(lines):
                    line = lines[i]
                    if line[0] != "!":
                        if line[0] != "#":
                            bnds.append(line)
                    else:
                        break
                    i += 1
                values = [stepType, converg, subSteps, maxIter, dTime, eTime, bnds]
                break
            i += 1
        if len(values) > 0:
            #SOLUTIONのTYPEを追加
            solutionType = "STATIC"
            for line in lines:
                if line[:len("!SOLUTION")] == "!SOLUTION":
                    solutionType = abaqus2fistr.getValName(line, "TYPE")
                    break
            values += [solutionType]
        return values

    #  getStepParameter
    #    stepの内容を取得
    def getStepParameter(self, line):
        stepName = abaqus2fistr.getValName(line, "stepName")
        stepType = abaqus2fistr.getValName(line, "TYPE")
        if stepType == "":
            stepType = "STATIC"
        converg = abaqus2fistr.getValName(line, "CONVERG")
        if converg == "":
            converg = "1.0e-6"
        subSteps = abaqus2fistr.getValName(line, "SUBSTEPS")
        if subSteps == "":
            subSteps = "1"
        maxIter = abaqus2fistr.getValName(line, "MAXITER")
        if maxIter == "":
            maxIter = "50"
        maxContIter = abaqus2fistr.getValName(line, "MAXCONTITER")
        if maxContIter == "":
            maxContIter = "10"
        return [stepName, stepType, converg, subSteps, [maxIter, maxContIter]]

    #
    #  getAutoincValueFromCntLines
    def getAutoincValueFromCntLines(self, lines, iStep):
        """ autoincの値を取得する"""

        def getHeaderValue(lines, headerName, name):
            headerLine = ""
            headerLines = []
            flag = 0
            i = 0
            while i < iStep:
                line = lines[i]
                if line[0] == "!":
                    if line[:len(headerName)] == headerName:
                        if abaqus2fistr.getValName(line, "NAME") == name:
                            headerLine = line
                            headerLines = []
                            flag = 1
                    else:
                        flag = 0
                else:
                    if flag == 1:
                        headerLines.append(line)
                i += 1
            return [headerLine, headerLines]

        #         incType timePoints   autoParam
        values = ["FIX", ["TP0", []], ["AP0", []]]
        line = lines[iStep]
        incType = abaqus2fistr.getValName(line, "INC_TYPE")
        if incType == "":
            incType = "FIX"
        if incType == "Fix":
            return values
        #autoincValueを取得
        values[0] = incType
        tpName = abaqus2fistr.getValName(line, "TIMEPOINTS")
        if tpName != "":
            #timePointsを取得            
            (_tpLine, tpLines) = getHeaderValue(lines, "!TIME_POINTS", tpName)
            values[1] = [tpName, tpLines]
        apName = abaqus2fistr.getValName(line, "AUTOINCPARAM")
        if apName != "":
            #autoParamを取得
            (_apLine, apLines) = getHeaderValue(lines, "!AUTOINC_PARAM", apName)
            values[2] = [apName, apLines]
        return values

    #
    #  readStepNameValueFromCnt
    #    stepNameの内容を取得
    def readStepNameValueFromCnt(self, stepName):
        """ stepNameの内容を取得する。

        Args:
            stepName (str)  :step名
        Returns:
            values[0] (str) :stepType
            values[1] (str) :converg
            values[2] (str) :subSteps
            values[3] list((str)) :[maxIter, maxContIter]
            values[4] (str) :dTime
            values[5] (str) :eTime
            values[6] (str) :bnds(境界条件)
            values[7] (str) :solutionType
            values[8] (str) :incType
            values[9] (str) :minDT
            values[10] (str):maxDT
            values[11] (list(str, lines)) :[timePoints名, lines]
            values[12] (list(str, lines)) :[autoincParam名, lines]"""
        values = []
        lines = readFistrModelCnt()
        i = 0
        iStep = 0
        while i < len(lines):
            line = lines[i]
            if line[:len("!STEP")] == "!STEP":
                data = self.getStepParameter(line)
                if data[0] == stepName:
                    #該当する行Noを取得
                    iStep = i
                    #step内のparameterを取得
                    i += 1
                    words = deleteSp(lines[i]).split(",")
                    flag = 0
                    #times = ["1.0", "1.0", "0.01", "1.0"]
                    times = defaultAutoIncStepData()
                    try:
                        for ii in range(len(times)):
                            times[ii] = str(float(words[ii]))
                        flag = 1
                    except:
                        pass
                    (dTime, eTime, minTime, maxTime) = times
                    
                    #境界条件を取得
                    if flag == 1:
                        i += 1
                    bnds = []
                    while i < len(lines):
                        line = lines[i]
                        if line[0] != "!":
                            if line[0] != "#":
                                bnds.append(line)
                        else:
                            break
                        i += 1
                    values = data[1:] + [dTime, eTime, bnds]
                    break
            i += 1
        if len(values) > 0:
            solutionType = "STATIC"
            for line in lines:
                if line[:len("!SOLUTION")] == "!SOLUTION":
                    solutionType = abaqus2fistr.getValName(line, "TYPE")
                    break
            values += [solutionType]

        #autoIncを確認
        (incType, timePoints, autoParam) = self.getAutoincValueFromCntLines(lines, iStep)
        values += [incType, minTime, maxTime, timePoints, autoParam]
        return values    

    #
    #  readStepDataLinesFromCnt
    #    全てのstepの内容を取得
    def readStepDataLinesFromCnt(self):

        def get1stepLinesFromCurrLine(lines, i):
            stepLines = []
            flag = 0
            stepName = ""
            while i < len(lines):
                line = lines[i]
                if flag == 1:
                    if line[0] != "!" and line[:2] != "!!" and line[0] != "#":
                        stepLines.append(line)
                    else:
                        break
                else:
                    if line[:len("!STEP")] == "!STEP":
                        stepLines.append(line)
                        stepName = abaqus2fistr.getValName(line, "stepName")
                        flag = 1
                    elif line[:2] != "!!" and line[0] != "#":
                        stepLines.append(line)
                    else:
                        break
                i += 1
            return [stepName, stepLines, i]

        def getAutoincLine(lines, i):
            """ iを遡って、!AUTOINC_PARAMを探す"""
            ist = i
            while i >= 0:
                if lines[i][:len("!AUTOINC_PARAM")] == "!AUTOINC_PARAM":
                    ist = i
                    break
                i -= 1
            return ist

        data = []
        lines = readFistrModelCnt()
        #最初のstepを探す
        flag = 0
        i = 0
        while i < len(lines):
            line = lines[i]
            if line[:len("!STEP")] == "!STEP":
                flag = 1
                break
            i += 1
        if flag == 1:
            #iを遡って、!AUTOINC_PARAMを探す
            i = getAutoincLine(lines, i)
            #最初のstepからstep内容を取得
            while i < len(lines):
                [stepName, stepLines, i] = get1stepLinesFromCurrLine(lines, i)
                if len(stepLines) != 0:
                    data.append([stepName, stepLines])
                else:
                    break
        return data

    #
    #  readSpringValueFromCont
    #    SPRINGの値を取得
    def readSpringValueFromCont(self, name, nStep):
        values = ["", "", "", "", "", ""]
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)
        getFlag = 0
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!SPRING", "")
            if i < len(lines):
                sName = deleteSp(lines[i+1]).split(",")[0]
                if sName == name or sName == "dummy_"+name:
                    i += 1
                    while i < len(lines):
                        words = deleteSp(lines[i]).split(",")
                        if words[0] == name:
                            n = int(words[1]) - 1
                            values[n] = words[2]
                            getFlag = 1
                        elif words[0] == "dummy_" + name:
                            n = int(words[1]) - 1 + 3
                            values[n] = words[2]
                            getFlag = 1
                        else:
                            break
                        i += 1
                    if getFlag == 1:
                        break
            i += 1        
        return values

    #
    #  readTemperatureValueFromCntMesh
    #    TEMPERATUREの値を取得
    def readTemperatureValueFromCntMesh(self, name, nStep):
        values = []
        temp = ""
        iniTemp = ""
        lines = readFistrModelCnt()
        #temperatureを検索
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            line = lines[i]
            if line[:len("!TEMPERATURE")] == "!TEMPERATURE":
                if deleteSp(lines[i+1]).split(",")[0] == name:
                    readResult = abaqus2fistr.getValName(line, "READRESULT")
                    sStep = abaqus2fistr.getValName(line, "SSTEP")
                    interval = abaqus2fistr.getValName(line, "INTERVAL")
                    temp = deleteSp(lines[i+1]).split(",")[1]
                    break
            i += 1
        #iniTempを検索
        iniTemp = self.readInitialNgrpName(name)
        #検索結果を設定
        if temp != "":
            values = [temp, iniTemp, readResult, sStep, interval]
        return values

    #
    #  readGravValueFromCnt
    #    GRAVの値を取得
    def readGravValueFromCnt(self, name, nStep):
        lines = readFistrModelCnt()
        ansLine = ""
        values = []
        i = skipStepId(lines, nStep)
        while i < len(lines):
            grpTypes = pyFistr.getNextDloadGrpType(lines, i)
            if len(grpTypes) > 0:
                #for [grp, bndType, line, i] in grpTypes:
                for grpType in grpTypes:
                    (grp, bndType, line, i) = grpType[:4]
                    if grp == name and bndType == "GRAV":
                        ansLine = line
                i += 1
            else:
                break
            if ansLine != "":
                break
        if ansLine != "":
            values = deleteSp(ansLine).split(",")[2:]
        return values

    #
    #  readCentEgrpName
    #    EGRP名のCENT値を取得
    def readCentEgrpName(self, name, nStep):
        lines = readFistrModelCnt()
        getLine = ""
        values = []
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            grpTypes = pyFistr.getNextDloadGrpType(lines, i)
            if len(grpTypes) > 0:
                if len(grpTypes) == 1:
                    (grp, bndType, line, i) = grpTypes[0][:4]
                    if grp == name and bndType == "CENT":
                        getLine = line
                        break
            else:
                break
            i += 1        
        if getLine != "":
            words = getLine.split(",")
            values = words[2:]
        return values

    #
    #  readVloadEgrpName
    #    EGRP名のVLOAD値を取得
    def readVloadEgrpName(self, name, nStep):
        lines = readFistrModelCnt()
        bxLine = ""
        byLine = ""
        bzLine = ""
        values = []
        i = skipStepId(lines, nStep)    #stepId分をskip
        while i < len(lines):
            grpTypes = pyFistr.getNextDloadGrpType(lines, i)
            if len(grpTypes) > 0:
                #for [grp, bndType, line, i] in grpTypes:
                for grpType in grpTypes:
                    (grp, bndType, line, i) = grpType[:4]
                    if grp == name and bndType == "BX":
                        bxLine = line
                    elif grp == name and bndType == "BY":
                        byLine = line
                    elif grp == name and bndType == "BZ":
                        bzLine = line
                i += 1
            else:
                break
            if bxLine != "" or byLine != "" or bzLine != "":
                break
        bx = "0.0"; by = "0.0"; bz = "0.0"
        if bxLine != "":
            bx = deleteSp(bxLine).split(",")[2]
        if byLine != "":
            by = deleteSp(byLine).split(",")[2]
        if bzLine != "":
            bz = deleteSp(bzLine).split(",")[2]
        values = [bx, by, bz]
        return values

    #
    #  readDloadSgrpName
    #    SGRP名のDLOADを取得
    def readDloadSgrpName(self, name, nStep):
        lines = readFistrModelCnt()
        ansLine = ""
        values = []
        #stepId分skipする
        i = skipStepId(lines, nStep)
        while i < len(lines):
            grpTypes = pyFistr.getNextDloadGrpType(lines, i)
            if len(grpTypes) > 0:
                for vals in grpTypes:
                    (grp, bndType, line, i) = vals[:4]
                    if grp == name and bndType == "S":
                        ansLine = line
                i += 1
            else:
                break
            if ansLine != "":
                break
        if ansLine != "":
            values = deleteSp(ansLine).split(",")[2:]
            forceTypes = vals[4:]   # = [forceType, mapFile, mapCoeff, mapShift]
        return values, forceTypes

    #
    #  readAmpGrpNameInCnt
    #    ampが設定されている境界条件を取得
    def readAmpGrpNameInCnt(self, ampName):

        def setStepNameToBnds(bndsSet, stepName):
            for n in range(len(bndsSet)):
                if bndsSet[n][2] == "":
                    bndsSet[n][2] = stepName
            return bndsSet

        bndsSet = []
        lines = readFistrModelCnt()
        i = 0
        while i < len(lines):
            if lines[i][0] == "!":
                n = lines[i].find("AMP=")
                if n >= 0:
                    name = abaqus2fistr.getValName(lines[i], "AMP")
                    if name == ampName:
                        words = deleteSp(lines[i]).split(",")
                        words2 = deleteSp(lines[i+1]).split(",")
                        if words[0] == "!DLOAD":
                            if words2[1] == "S":
                                bnds = ["DLOAD", words2[0], ""]
                            elif words2[1] == "BX" or words2[1] == "BY" or words2[1] == "BZ":
                                bnds = ["VLOAD", words2[0], ""]
                            else:
                                bnds = [words2[1], words2[0], ""]
                        elif words[0] == "!STEP":
                            stepName = abaqus2fistr.getValName(lines[i], "stepName")
                            bndsSet = setStepNameToBnds(bndsSet, stepName)
                            bnds = [words[0][1:], "SUBSTEPS", stepName]
                        else:
                            bnds = [words[0][1:], words2[0], ""]
                        bndsSet.append(bnds)
                else:
                    words = deleteSp(lines[i]).split(",")
                    if words[0] == "!STEP":
                        stepName = abaqus2fistr.getValName(lines[i], "stepName")
                        bndsSet = setStepNameToBnds(bndsSet, stepName)
            i += 1
        bndsSet = setStepNameToBnds(bndsSet, "STEP0")
        bndLines = []
        for i in range(len(bndsSet)):
            bndLines.append(",".join(bndsSet[i]))
        return bndLines

    #
    #  readAmpGrpNameInMsh
    #    amp名のvalue（rel or abs）を取得
    def readAmpGrpNameInMsh(self, ampName):
        value = "RELATIVE"
        for headerData in meshHeaderData:
            line = headerData[0]
            if line[:len("!AMPLITUDE")] == "!AMPLITUDE":
                name = pyFistr.getValName(line, "NAME")
                if name == ampName:
                    value = pyFistr.getValName(line, "VALUE")
                    break
        return value

    #
    #  readSradiateEgrpName
    #    SGRP名のSRADITEを取得
    def readSradiateEgrpName(self, name, nStep):
        ans = ""
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)            #stepId分をskip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!SRADIATE", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                if words[0] == name:
                    ans = [words[1], words[2]]
                    break
        return ans

    #
    #  readSfilmEgrpName
    #    SGRP名のSFILMを取得
    def readSfilmEgrpName(self, name, nStep):
        ans = ""
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!SFILM", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                if words[0] == name:
                    ans = [words[1], words[2]]
                    break
        return ans

    #
    #  readDfluxSgrpName
    #    SGRP名のDFLUXを取得
    def readDfluxSgrpName(self, name, nStep):
        ans = ["", ""]
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!DFLUX", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                if words[0] == name and words[1][0] == "S":
                    ans = [words[1], words[2]]
                    break
        return ans

    #
    #  readBfEgrpName
    #    EGRP名のDFLUXを取得
    def readBfEgrpName(self, name, nStep):
        ans = ""
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!DFLUX", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                if words[0] == name and words[1] == "BF":
                    ans = words[2]
                    break
        return ans

    #
    #  readSfluxNgrpName
    #    SGRP名のSFLUXを取得
    def readSfluxNgrpName(self, name, nStep):
        ans = ""
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)            #stepId分skip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!SFLUX", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                if words[0] == name:
                    ans = words[1]
                    break
        return ans

    #
    #  readCfluxNgrpName
    #    NGRP名のCFLUXを取得
    def readCfluxNgrpName(self, name, nStep):
        ans = ["", ""]
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)            #stepId分skip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!CFLUX", "")
            if i < len(lines):
                words = deleteSp(lines[i+1]).split(",")
                if words[0] == name:
                    qwType = pyFistr.getValName(lines[i], "qwType")
                    qwValue = pyFistr.getValName(lines[i], "value")
                    if qwValue == "":
                        words = deleteSp(lines[i+1]).split(",")
                        qwValue = words[1]
                    ans = [qwValue, qwType]
                    break
            i += 1                
        return ans

    #
    #  readInitialNgrpName
    #    NGRP名のINITIALを取得
    def readInitialNgrpName(self, name):
        ans = ""
        for headerData in meshHeaderData:
            line = headerData[0]
            if line[:len("!INITIAL CONDITION")] == "!INITIAL CONDITION":
                dataLines = headerData[1]
                for dataLine in dataLines:
                    words = deleteSp(dataLine).split(",")
                    if words[0] == name:
                        ans = words[1]
                        break
                if ans != "":
                    break
        return ans

    #
    #  readReftempValue
    #-------------------
    def readReftempValue(self, nStep):
        """ REFTEMPの値を取得して返す"""
        ans = ""
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!REFTEMP", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                ans = words[0]
                break
        return ans

    #
    #  readFixtempNgrpName
    #    NGRP名のFIXTEMPを取得
    def readFixtempNgrpName(self, name, nStep):
        ans = ""
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!FIXTEMP", "")
            if i < len(lines):
                i += 1
                words = deleteSp(lines[i]).split(",")
                if words[0] == name:
                    ans = words[1]
                    break
        return ans

    #
    #  readAccelNgrpName
    #    NGRP名のACCELERATIONを取得
    def readAccelNgrpName(self, name, nStep):
        ans = ["", "", ""]
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        getFlag = 0
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!ACCELERATION", "")
            if i < len(lines):
                #typeName = pyFistr.getValName(lines[i], "TYPE")
                #ans[3] = typeName
                i += 1
                while i < len(lines):
                    words = deleteSp(lines[i]).split(",")
                    if words[0] != name:
                        break
                    else:
                        loc = int(words[1]) - 1
                        ans[loc] = words[3] 
                        getFlag = 1
                    i += 1
                if getFlag == 1:
                    break
            i += 1
        return ans

    #
    #  readVeloNgrpName
    #    NGRP名のVELOCITYを取得
    def readVeloNgrpName(self, name, nStep):
        ans = ["", "", "", ""]      #[x,y,z,type]
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分skip
        getFlag = 0
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!VELOCITY", "")
            if i < len(lines):
                typeName = pyFistr.getValName(lines[i], "TYPE")
                ans[3] = typeName
                i += 1
                while i < len(lines):
                    words = deleteSp(lines[i]).split(",")
                    if words[0] != name:
                        break
                    else:
                        getFlag = 1
                        loc = int(words[1]) - 1
                        ans[loc] = words[3]
                    i += 1
                if getFlag == 1:
                    break
            i += 1
        return ans

    #
    #  readFloadNgrpName
    #    NGRP名のFLOADを取得
    def readFloadNgrpName(self, name, nStep):
        ans = ["", ["", "", ""]]
        lines = readFistrModelCnt()
        i = skipStepId(lines, nStep)        #stepId分をskip
        getFlag = 0
        while i < len(lines):
            i = pyFistr.getNextHeaderName(lines, i, "!FLOAD", "")
            if i < len(lines):
                loadCase = abaqus2fistr.getValName(lines[i], "CASE")
                i += 1
                while i < len(lines):
                    line = deleteSp(lines[i])
                    words = line.split(",")
                    if words[0] == name:
                        ans[0] = loadCase
                        if words[1] == "1":
                            ans[1][0] = words[2]
                        elif words[1] == "2":
                            ans[1][1] = words[2]
                        elif words[1] == "3":
                            ans[1][2] = words[2]
                        getFlag = 1
                    else:
                        break
                    i += 1
                if getFlag == 1:
                    break
        return ans

    #
    #  readCloadNgrpName
    #    NGRP名のCLOADを取得
    def readCloadNgrpName(self, name, nStep):

        def getForceType(line):
            n = line.find("forceType=")
            if n >= 0:
                line = pyFistr.deleteSp(line)
                words = line.split(",")
                for word in words:
                    if word[:len("forceType=")] == "forceType=":
                        forceType = word.split("=")[1]
                        break
            else:
                forceType = "nodeForce"
            return forceType

        def getOrgxyz(line):
            n = line.find("value=")
            if n>=0:
                line = pyFistr.deleteSp(line)
                words = line.split(",")
                for i in range(len(words)):
                    word = words[i]
                    if word[:len("value=")] == "value=":
                        x = ["1", word.split("=")[1]]
                        y = ["2", words[i+1]]
                        z = ["3", words[i+2]]
                        Mx = ""; My = ""; Mz = ""
                        if i+3 < len(words):
                            Mx = ["4", words[i+3]]
                        else:
                            Mx = ["4", "0.0"]
                        if i+4 < len(words):
                            My = ["5", words[i+4]]
                        else:
                            My = ["5", "0.0"]
                        if i+5 < len(words):
                            Mz = ["6", words[i+5]]
                        else:
                            Mz = ["6", "0.0"]
                        break
            else:
                x = ""
                y = ""
                z = ""
                Mx = ""
                My = ""
                Mz = ""
            return [x, y, z, Mx, My, Mz]

        def getBndLines(lines, i, name):
            newLine = []
            while i < len(lines):
                line = deleteSp(lines[i])
                ngrp = line.split(",")[0]
                if ngrp == name:
                    newLine.append(line)
                else:
                    break
                i += 1 
            return newLine

        def remakeBndCont(lines):
            x = ["1", "0.0"]
            y = ["2", "0.0"]
            z = ["3", "0.0"]
            Mx = ["4", "0.0"]
            My = ["5", "0.0"]
            Mz = ["6", "0.0"]
            for line in lines:
                words = line.split(",")
                if words[1] == "1":
                    x[1] = words[2]
                elif words[1] == "2":
                    y[1] = words[2]
                elif words[1] == "3":
                    z[1] = words[2]
                elif words[1] == "4":
                    Mx[1] = words[2]
                elif words[1] == "5":
                    My[1] = words[2]
                elif words[1] == "6":
                    Mz[1] = words[2]
            return [x, y, z, Mx, My, Mz]

        lines = readFistrModelCnt()
        #stepId分をskip
        i = skipStepId(lines, nStep)
        #値を取得
        #bndLines = [[], [], []]
        bndLines = ["", "", ""]
        while i < len(lines):
            line = lines[i]
            if line[:len("!CLOAD")] == "!CLOAD":
                forceType = getForceType(line)
                orgxyz = getOrgxyz(line)
                i += 1
                line = deleteSp(lines[i])
                ngrp = line.split(",")[0]
                if ngrp == name or ngrp == "dummy_"+name:
                    bndLines = getBndLines(lines, i, name)
                    break
            i += 1
        xyz = remakeBndCont(bndLines)
        if len(orgxyz[0]) != 0:
            xyz = orgxyz
        ans = [xyz, forceType]
        return ans

    #
    #  readBoundaryNgrpName
    #    NGRP名のBOUNDARYを取得
    def readBoundaryNgrpName(self, name, nStep):

        def getBndLines(lines, i, name):
            newLine = []
            while i < len(lines):
                line = deleteSp(lines[i])
                ngrp = line.split(",")[0]
                if ngrp == name or ngrp == "dummy_"+name:
                    newLine.append(line)
                else:
                    break
                i += 1 
            return newLine

        def remakeBndCont(lines, name):
            x = []; y = []; z = []
            Rx = []; Ry = []; Rz = []
            for line in lines:
                words = line.split(",")
                if words[0] == name:
                    #記述が省略されているか確認
                    if len(words) == 2:
                        #拘束方向のみ記述の場合
                        words += [words[1]] + ["0.0"]
                    elif len(words) == 3:
                        #値を省略している場合
                        words += ["0.0"]
                    #複数の拘束を記述しているか
                    if words[1] != words[2]:
                        #複数の拘束記述
                        if words[1] == "1" and words[2] == "2":
                            x += ["1"] + [words[3]]
                            y += ["2"] + [words[3]]
                        if words[1] == "1" and words[2] == "3":
                            x += ["1"] + [words[3]]
                            y += ["2"] + [words[3]]
                            z += ["3"] + [words[3]]
                        if words[1] == "2" and words[2] == "3":
                            y += ["2"] + [words[3]]
                            z += ["3"] + [words[3]]
                    else:
                        #通常の記述
                        if words[1] == "1":
                            if len(x) == 0:
                                x += [words[1]] + [words[3]]
                            else:
                                x[0] = "1"
                                x[1] = words[3]
                        elif words[1] == "2":
                            if len(y) == 0:
                                y += [words[1]] + [words[3]]
                            else:
                                y[0] = "2"
                                y[1] = words[3]
                        elif words[1] == "3":
                            if len(z) == 0:
                                z += [words[1]] + [words[3]]
                            else:
                                y[0] = "3"
                                y[1] = words[3]
                        elif words[1] == "4":
                            if len(Rx) == 0:
                                Rx += [words[1]] + [words[3]]
                            else:
                                Rx[0] = "4"
                                Rx[1] = words[3]
                        elif words[1] == "5":
                            if len(Ry) == 0:
                                Ry += [words[1]] + [words[3]]
                            else:
                                Ry[0] = "5"
                                Ry[1] = words[3]
                        elif words[1] == "6":
                            if len(Rz) == 0:
                                Rz += [words[1]] + [words[3]]
                            else:
                                Rz[0] = "6"
                                Rz[1] = words[3]
                else:
                    #dummyを取得
                    if words[1] == "1":
                        Rx = [words[1], words[3]]
                    elif words[1] == "2":
                        Ry = [words[1], words[3]]
                    elif words[1] == "3":
                        Rz = [words[1], words[3]]    
            return [x, y, z, Rx, Ry, Rz]

        lines = readFistrModelCnt()
        #stepId分をskipする
        i = skipStepId(lines, nStep)
        #boundaryNameを検索
        #bndLines = [[], [], []]
        bndLines = ["", "", ""]
        while i < len(lines):
            line = lines[i]
            if line[:len("!BOUNDARY")] == "!BOUNDARY":
                i += 1
                line = deleteSp(lines[i])
                ngrp = line.split(",")[0]
                if ngrp == name or ngrp == "dummy_"+name:
                    bndLines = getBndLines(lines, i, name)
                    break
            i += 1
        ans = remakeBndCont(bndLines, name)
        return ans

    #
    #  showAllBoundaryPage
    #----------------------
    def showAllBoundaryPage(self):
        """ 境界条件pageを表示"""
        #vtkを再表示
        if (len(self.selectedActors) > 0
                or len(self.preSelectedActors) > 0):
            self.showNoneSelectedModel()

    #
    #  setBCGroupToListBox
    #    BCGroup選択時のpageの初期化
    def setBCGroupToListBox(self, showPage):
        #stepIdを取得
        nStep = self.getStepIdFromItem()
        #自身の処理        
        self.boundaryFrameLabel.set_label(showPage)
        self.boundaryFrameTitle.set_label(_(u"境界条件の設定"))
        self.boundaryFrameSet.set_text(_("設定するgroup"))
        self.boundaryFrameNoset.set_label(_(u"group名:"))
        #TEMPERATURE
        if showPage == _(u"TEMPERATURE"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global tempDefine
            #lines = readFistrModelCnt()
            #tempDefine = getBoundaryNodeGroupInCnt(lines, "!TEMPERATURE")
            #ngrps = meshGroup[2] + ["ALL"]        #nodeGroup
            ngrps = meshGroup[2]        #nodeGroup
            noBnd = self.getNoGroups(ngrps, tempDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup,
                        self.listBox_noGroup, noBnd)
            self.setListDataInListBox(self.listmodelSetGroup,
                        self.listBox_setGroup, tempDefine[nStep])
        #REFTEMP
        elif showPage == _(u"REFTEMP"):
            self.boundaryFrameTitle.set_label(_("参照温度の設定"))
            self.boundaryFrameSet.set_text(_("設定する"))
            self.boundaryFrameNoset.set_label(_("reftemp設定"))
            global reftempDefine
            #lines = readFistrModelCnt()
            #reftempDefine = getReftempInCnt(lines) 
            if len(reftempDefine) == 0:
                noBnd = ["reftemp"]
            else:
                noBnd = []
            self.setListDataInListBox(self.listmodelNoGroup,
                        self.listBox_noGroup, noBnd)
            self.setListDataInListBox(self.listmodelSetGroup,
                        self.listBox_setGroup, reftempDefine)
        #GRAV
        elif showPage == _(u"GRAV"):
            self.boundaryFrameNoset.set_label(_(u"elGroup名:"))
            global gravDefine
            #lines = readFistrModelCnt()
            #gravDefine = getGravGroupInCnt(lines)
            #ngrps = meshGroup[0] + ["ALL"]        #elementGroup
            ngrps = meshGroup[0]        #elementGroup
            noBnd = self.getNoGroups(ngrps, gravDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup,
                        self.listBox_noGroup, noBnd)
            self.setListDataInListBox(self.listmodelSetGroup,
                        self.listBox_setGroup, gravDefine[nStep])
        #BOUNDARY
        elif showPage == _(u"BOUNDARY"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global bndDefine
            #lines = readFistrModelCnt()
            #bndDefine = getBoundaryNodeGroupInCnt(lines, "!BOUNDARY")
            ngrps = meshGroup[2]            #nodeGroup
            noBnd = self.getNoGroups(ngrps, bndDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noBnd)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    bndDefine[nStep])
        #CLOAD
        elif showPage == _(u"CLOAD"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global cloadDefine
            #lines = readFistrModelCnt()
            #cloadDefine = getBoundaryNodeGroupInCnt(lines, "!CLOAD")
            ngrps = meshGroup[2]
            noCload = self.getNoGroups(ngrps, cloadDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noCload)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    cloadDefine[nStep])
        #DLOAD
        elif showPage == _(u"DLOAD"):
            self.boundaryFrameNoset.set_label(_(u"surfaceGroup名:"))
            global dloadDefine
            #lines = readFistrModelCnt()
            #dloadDefine = getDloadGroupInCnt(lines)
            sgrps = meshGroup[1]
            noGrps = self.getNoGroups(sgrps, dloadDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noGrps)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    dloadDefine[nStep])
        #VLOAD
        elif showPage == _(u"VLOAD"):
            self.boundaryFrameNoset.set_label(_(u"elGroup名:"))
            global vloadDefine
            #lines = readFistrModelCnt()
            #vloadDefine = getVloadGroupInCnt(lines)
            egrps = meshGroup[0]
            noGrps = self.getNoGroups(egrps, vloadDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noGrps)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    vloadDefine[nStep])
        #CENT
        elif showPage == _(u"CENT"):
            self.boundaryFrameNoset.set_label(_(u"elGroup名:"))
            global centDefine
            #lines = readFistrModelCnt()
            #centDefine = getCentGroupInCnt(lines)
            egrps = meshGroup[0]
            noGrps = self.getNoGroups(egrps, centDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noGrps)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    centDefine[nStep])
        #SPRING
        elif showPage == _(u"SPRING"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global springDefine
            #lines = readFistrModelCnt()
            #springDefine = getBoundaryNodeGroupInCnt(lines, "!SPRING")
            ngrps = meshGroup[2]
            noGrps = self.getNoGroups(ngrps, springDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noGrps)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    springDefine[nStep])
        #FLOAD
        elif showPage == _(u"FLOAD"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global floadDefine
            #lines = readFistrModelCnt()
            #floadDefine = getBoundaryNodeGroupInCnt(lines, "!FLOAD")
            ngrps = meshGroup[2]
            noFload = self.getNoGroups(ngrps, floadDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noFload)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    floadDefine[nStep])
        #VELOCITY
        elif showPage == _(u"VELOCITY"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global veloDefine
            #lines = readFistrModelCnt()
            #veloDefine = getBoundaryNodeGroupInCnt(lines, "!VELOCITY")
            #ngrps = meshGroup[2] + ["ALL"]
            ngrps = meshGroup[2]
            noVelo = self.getNoGroups(ngrps, veloDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noVelo)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    veloDefine[nStep])
        #ACCELERATION
        elif showPage == _(u"ACCELERATION"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global accelDefine
            #lines = readFistrModelCnt()
            #accelDefine = getBoundaryNodeGroupInCnt(lines, "!ACCELERATION")
            #ngrps = meshGroup[2] + ["ALL"]
            ngrps = meshGroup[2]
            noAccel = self.getNoGroups(ngrps, accelDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noAccel)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    accelDefine[nStep])
        #INITEMP
        elif showPage == _(u"INITEMP"):
            self.boundaryFrameTitle.set_label(_(u"初期温度の設定"))
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global initempDefine
            #initempDefine = getInitempGroupInMsh()
            #ngrps = meshGroup[2] + ["ALL"]
            ngrps = meshGroup[2]
            noInitial = self.getNoGroups(ngrps, initempDefine)
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noInitial)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    initempDefine)
        #FIXTEMP
        elif showPage == _(u"FIXTEMP"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global fixtempDefine
            #lines = readFistrModelCnt()
            #fixtempDefine = getBoundaryNodeGroupInCnt(lines, "!FIXTEMP")
            ngrps = meshGroup[2]
            noFixtemp = self.getNoGroups(ngrps, fixtempDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noFixtemp)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    fixtempDefine[nStep])
        #CFLUX
        elif showPage == _(u"CFLUX"):
            self.boundaryFrameNoset.set_label(_(u"nodeGroup名:"))
            global cfluxDefine
            #lines = readFistrModelCnt()
            #cfluxDefine = getBoundaryNodeGroupInCnt(lines, "!CFLUX")
            ngrps = meshGroup[2]
            noCflux = self.getNoGroups(ngrps, cfluxDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noCflux)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    cfluxDefine[nStep])
        #SFLUX
        elif showPage == _(u"SFLUX"):
            self.boundaryFrameNoset.set_label(_(u"surfaceGroup名:"))
            global sfluxDefine
            #lines = readFistrModelCnt()
            #sfluxDefine = getBoundaryNodeGroupInCnt(lines, "!SFLUX")
            sgrps = meshGroup[1]
            noSflux = self.getNoGroups(sgrps, sfluxDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noSflux)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    sfluxDefine[nStep])
        #DFLUX
        elif showPage == _(u"DFLUX"):
            self.boundaryFrameNoset.set_label(_(u"surfaceGroup名:"))
            global dfluxDefine
            #lines = readFistrModelCnt()
            #dfluxDefine = getBoundaryNodeGroupInCnt(lines, "!DFLUX")
            #dfluxDefine = getDfluxGroupInCnt(lines)
            sgrps = meshGroup[1]
            noDflux = self.getNoGroups(sgrps, dfluxDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noDflux)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    dfluxDefine[nStep])
        #BF
        elif showPage == _(u"BF"):
            self.boundaryFrameNoset.set_label(_(u"elGroup名:"))
            global bfDefine
            #lines = readFistrModelCnt()
            #bfDefine = getBoundaryNodeGroupInCnt(lines, "!DFLUX")
            #bfDefine = getBfGroupInCnt(lines)
            egrps = meshGroup[0]
            noBf = self.getNoGroups(egrps, bfDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noBf)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    bfDefine[nStep])
        #SFILM
        elif showPage == _(u"SFILM"):
            self.boundaryFrameNoset.set_label(_(u"surfaceGroup名:"))
            global sfilmDefine
            #lines = readFistrModelCnt()
            #sfilmDefine = getBoundaryNodeGroupInCnt(lines, "!SFILM")
            sgrps = meshGroup[1]
            noSfilm = self.getNoGroups(sgrps, sfilmDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noSfilm)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    sfilmDefine[nStep])
        #SRADIATE
        elif showPage == _(u"SRADIATE"):
            self.boundaryFrameNoset.set_label(_(u"surfaceGroup名:"))
            global sradiateDefine
            #lines = readFistrModelCnt()
            #sradiateDefine = getBoundaryNodeGroupInCnt(lines, "!SRADIATE")
            sgrps = meshGroup[1]
            noSradiate = self.getNoGroups(sgrps, sradiateDefine[nStep])
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noSradiate)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    sradiateDefine[nStep])
        #step
        elif showPage == _(u"step"):
            values = self.readStepValueFromCnt()
            if len(values) == 0:
                self.setListDataInListBox(self.listmodelNoGroup,
                        self.listBox_noGroup, ["STEP"])
                self.setListDataInListBox(self.listmodelSetGroup,
                        self.listBox_setGroup, [])
            else:
                self.setListDataInListBox(self.listmodelNoGroup,
                        self.listBox_noGroup, [])
                self.setListDataInListBox(self.listmodelSetGroup,
                        self.listBox_setGroup, ["STEP"])
        #output
        elif showPage == _(u"output"):
            values = getOutputContFromCnt()
            noSelItems = values[0]
            selItems = values[1]
            self.setListDataInListBox(self.listmodelNoGroup, self.listBox_noGroup,
                    noSelItems)
            self.setListDataInListBox(self.listmodelSetGroup, self.listBox_setGroup,
                    selItems)
            self.boundaryFrameTitle.set_label(_(u"出力項目の設定"))
            self.boundaryFrameNoset.set_label(_(u"出力項目:"))
            self.boundaryFrameSet.set_label(_(u"設定する出力項目"))
        #vtkを再表示
        if len(self.selectedActors) > 0 or len(self.preSelectedActors) > 0:
            self.showNoneSelectedModel()

    #
    #  getChildNamesFromSelectedItem
    def getChildNamesFromSelectedItem(self):
        """ 選択itemのchildNamesを取得して返す"""
        path, _col = self.tree_main.get_cursor()
        parentIter = self.treestore.get_iter(path)
        nChildren = self.treestore.iter_n_children(parentIter)
        pathStrs = path.to_string().split(":")
        pathInts = list(map(int, pathStrs))
        #子を取得
        itemNames = []
        for n in range(nChildren):
            childInts = pathInts[:]
            childInts.append(n)
            childPath = Gtk.TreePath.new_from_indices(childInts)
            childIter = self.treestore.get_iter(childPath)
            itemName = self.treestore.get_value(childIter, 0)
            itemNames.append(itemName)
            childPath = childPath.next()
        itemNames.sort()
        return itemNames

    #
    #  setElGroupToListBoxInMaterial
    #    elGrpと材料定義をlistboxに追加
    def setElGroupToListBoxInMaterial(self):
        egrps = meshGroup[0]    #EGRP名
        mats = []               #材料定義済のEGRP名
        for names in matDefine:
            mats.append(names[0])
        noMat = list(set(egrps) - set(mats))    #未定義のEGRP名
        #textBoxにセット
        self.listmodelNoMat.clear()
        if len(noMat) > 0:
            self.setListDataInListBox(self.listmodelNoMat, self.listBox_noMat, noMat)
        self.listmodelDefMat.clear()
        if len(matDefine) > 0:
            self.setListDataInListBox(self.listmodelDefMat, self.listBox_defMat, mats)
        #vtkを再表示
        self.showNoneSelectedModel()

    #
    #  setElGroupToLabel
    #    group名をlabelにセット
    def setElGroupToLabel(self, label, name):
        string = label.get_text()
        newString = string.split(":")[0] + ":" + name
        label.set_text(newString)

    #
    #  getElGroupFromLabel
    #    group名をlabelから取得
    def getElGroupFromLabel(self, label):
        line = label.get_text()
        name = line.split(":")[1]
        return name

    #
    #  setMaterialToElGroup
    #------------------------
    def setMaterialToElGroup(self, name):
        """ EGRPに材料名を設定する"""
        self.setElGroupToLabel(self.label_setMatGrp, name)  #group名をlabelにセット
        self.setUnitToMaterialSubPage()
        matName = self.readSetEachMaterialName(name)
        self.readSetMaterialType(matName, name)
        #cnt内のデータで計算できる状態か？
        if self.canCalculateInCntData(matName) == True:
            #計算できる状態
            #  cntの物性値とDBの物性値を比較
            newMatName = self.checkElasticMaterialDataInDB(matName)
            if newMatName != "":
                #cnt or DBを使うか選択し、設定
                self.selectMaterialDataCntOrDB(name, matName)
        else:
            #計算できない状態
            #  「設定」ボタンをセットする（*を付加）
            treeTuple = (_(u"材料物性値"), name)
            self.addTreeItemsSet.add(treeTuple)

    def setUnitToMaterialSubPage(self):
        """ 単位を設定"""
        #          単位　　label名
        units = [["len", ["unit_thickness_matSub"]],
                 ["area", ["unit_area_matSub"]],
                 ["intMoment", ["unit_intMoment_matSub", "unit_twist_matSub"]]]
        self.setUnitToPage(units)

    #
    #  readSetEachMaterialName
    #    各groupの材料名をセット
    def readSetEachMaterialName(self, elGroupName):
        matName = ""
        elGrpMatDict = readMeshGetEachMaterialName()
        if elGroupName in elGrpMatDict.keys():
            matName = elGrpMatDict[elGroupName]
        if matName != "":
            allMatNames = self.combo_matName.getAllItems()
            if matName in allMatNames:
                self.combo_matName.selectItem(matName)
            elif not matName in allMatNames and matName != "noData":            
                #matNameが材料DBに登録されていない場合、登録する
                self.setNewElasticMaterialInDB(matName)
                title = _("新材料名のDB登録")
                mess  = _("cntファイルで使用されている材料「") + matName + _("」が未登録材料の為、材料DBに登録しました。") + "\n"
                mess += _("登録内容を確認してください。")
                self.okDialog(title, mess, parent=mainWindow)
        else:
            self.combo_matName.unselectItem()
        #vtkを再表示
        self.preSelectedActors = []
        self.selectedActors = ["elementGrp_" + elGroupName]
        self.showSelectedModel()
        return matName

    #
    #  canCalculateInCntData
    #------------------------
    def canCalculateInCntData(self, matName):
        """ cnt内の物性値が計算できる状態まで揃っているか確認する
        ヤング率と比熱を確認する"""
        if matName == "noData":
            return False
        (E, myu, rho, alpha, kappa, cp) = self.getMaterialCoeffInMshCnt(matName)
        #全て「""」の場合は、mshFileから読み込み
        #vals = [E, myu, rho, alpha, kappa, cp]
        #if len(list(filter(lambda x: x=="", vals))) == len(vals):
        #    (E, myu, rho, alpha, kappa, cp) = self.getMaterialCoeffInMsh(matName)
        calcFlag = True
        if anaType in ["HEAT", "HEAT_D"]:
            #熱解析
            try:
                a = float(cp)
                a = float(kappa)
                a = float(rho)
            except:
                calcFlag = False
        elif anaType in ["DYNAMIC", "EIGEN", "DYNAMIC_F"]:
            #構造動解析
            try:
                a = float(E)
                a = float(myu)
                a = float(rho)
            except:
                calcFlag = False
        else:
            #構造静解析
            try:
                a = float(E)
                a = float(myu)
            except:
                calcFlag = False
        return calcFlag
    
    #
    #  selectMaterialDataCntOrDB
    #----------------------------
    def selectMaterialDataCntOrDB(self, egrp, matName):
        """ cntとDBの値が異なっている時、その値を表示し、どちらを使うか選択する。"""

        def getUnit(unitName):
            """ 単位を取得"""
            unit = unitDict[unitName]
            cont = " [" + unit + "]"
            return cont

        def fitNlNames(nlNames):
            newNames = []
            for name in nlNames:
                name += ":"
                newNames.append(name)
            return newNames

        def fitNlUnits(nlUnits):
            newUnits = []
            for unit in nlUnits:
                if unit != "":
                    unit = " [" + unit + "]"
                newUnits.append(unit)
            return newUnits

        def fitVals(vals):
            newVals = []
            for val in vals:
                if val == "":
                    val = "- "
                newVals.append(val)
            return newVals

        #単位の辞書を取得
        dim, matFile = getDimensionMatFileFromIstrData()
        unitDict = convDimensionMatCsv.createUnitDict(dim)
        #DBの値を取得
        (elastic, heatVals) = getMaterialElasticValue(matName)
        #  値のcheck
        vals = self.checkPhysicalValueENull(elastic + heatVals)
        elastic = vals[:4]; heatVals = vals[4:]
        #cntの値を取得
        conts = self.getMaterialCoeffInMshCnt(matName)
        (E, myu, rho, alpha, kappa, cp) = self.checkPhysicalValueENull(conts)
        #非線形データを取得
        #mthDict, mats = getMthDict()
        mthDict, mats = self.getMaterialTypeHardenDict()
        nlTitle = ""
        cnt3Vals = ["", "", ""]
        db3Vals = ["", "", ""]
        nlNames = ["", "", ""]
        nlUnits = ["", "", ""]
        if mthDict["dialog"] != "office" and mthDict["dialog"] != None:
            #cntの内容を取得
            cnt3Vals = getNonlinearMaterialDataInCnt(matName, mats)
            #matDBの内容を取得
            db3Vals, nlUnits = self.getMaterialParamsFromMatFile(matName, mthDict)
            nlTitle = mats[0]
            nlNames = mthDict["names"]
            nlNames = fitNlNames(nlNames)   #nlNamesを整形
            nlUnits = fitNlUnits(nlUnits)   #nlUnitsを整形
            cnt3Vals = fitVals(cnt3Vals)    #cnt3Valsを整形
            db3Vals = fitVals(db3Vals)      #db3Valsを整形
        #dialog内容設定
        if anaType[:len("HEAT")] != "HEAT":
            #構造解析
            itemNames = [matName + " "] + ["youngs:", "poisson:", "density:", "linearexp:"]
            cntVals   = ["<cnt>"] + [E, myu, rho, alpha]
            dbVals    = ["<DB>"] + elastic
            units     = [""] + [getUnit("press"), " [-]", getUnit("rho"), " [1/K]"]
        else:
            #熱解析
            itemNames = [matName + " "] + ["density:", "thermal_cond.:", "specific_heat:"]
            cntVals   = ["<cnt>"] + [rho, kappa, cp]
            dbVals    = ["<DB>"] + [elastic[2], heatVals[0], heatVals[1]]
            units     = [""] + [getUnit("rho"), getUnit("thermCond"), getUnit("specHeat")]
        #非線形データをdialog内容に追加
        itemNames += [nlTitle] + nlNames
        cntVals   += [""] + cnt3Vals
        dbVals    += [""] + db3Vals
        units     += [""] + nlUnits
        #dialogを表示して処理
        funcName = self.selectMaterialDataCntOrDB_onDlg
        path, item = self.getSelectedPathAndItemName()
        funcArgs = [matName, path, item]       
        dialog = selectMaterialDataCntDbDDialog.selectMaterialDataCntDb(egrp, matName, itemNames, cntVals, dbVals, units, funcName, funcArgs, parent=mainWindow)
        dialog.show()

    #  selectMaterialDataCntOrDB_onDlg
    def selectMaterialDataCntOrDB_onDlg(self, selData, matName, path, item):
        self.showThisPageIfNotShow(path, item)
        if selData == "db":
            #cntの値をDBに修正(DBの値を使う)
            self.setMaterialDataFromDbToCnt(matName)
        elif selData == "cnt":
            #DBの値をcntに修正（cntの値を使う）
            self.replaceElasticMaterialInDB(matName)
        return

    #
    # setMaterialDataFromDbToCnt
    #----------------------------
    def setMaterialDataFromDbToCnt(self, matName):
        """ cnt,msh内の材料定数をDB内の値に置き換える"""
        #線形材料の物性を置き換え
        self.setMaterialDataElasticFromDbToCnt(matName)
        #非線形材料の物性値を置き換え
        self.setMaterialDataNonlinearFromDbToCnt(matName)

    #
    #  setMaterialDataElasticFromDbToCnt
    def setMaterialDataElasticFromDbToCnt(self, matName):
        """ cnt内の線形材料の物性値をDB内の値を置き換える"""
        global meshHeaderData
        #DBの値を取得
        [elastic, heatVals] = getMaterialElasticValue(matName)
        if anaType[:len("HEAT")] != "HEAT":
            #構造解析
            #  mshファイル内を修正
            flag = 0
            elasFlag = [elastic[2], elastic[3]]
            addHeaderData = []
            ip = -1
            im = -1
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = deleteSp(header).split(",")
                if words[0] == "!MATERIAL":
                    name = pyFistr.getValName(header, "NAME")
                    if name == matName:
                        im = i
                        flag = 1
                    else:
                        flag = 0
                elif flag == 1:
                    if words[0] == "!ITEM=1":       #E,myu
                        data = [", ".join([elastic[0], elastic[1]]) + ls]
                        meshHeaderData[i] = [header, data]
                        ip = i + 1
                    elif words[0] == "!ITEM=2":     #rho
                        if elastic[2] != "":
                            data = [elastic[2] + ls]
                            meshHeaderData[i] = [header, data]
                            elasFlag[0] = ""
                            ip = i + 1
                    elif words[0] == "!ITEM=3":     #alpha
                        if elastic[3] != "":
                            data = [elastic[3] + ls]
                            meshHeaderData[i] = [header, data]
                            elasFlag[1] = ""
                            ip = i + 1
                else:
                    flag = 0
            #  未保存dataを確認
            nItem = 1
            if elasFlag[0] != "" :
                line = "!ITEM=2, SUBITEM=1" + ls
                data = [elasFlag[0] + ls]
                addHeaderData.append([line, data])
                nItem += 1
            elif elasFlag[1] != "":
                line = "!ITEM=3, SUBITEM=1" + ls
                data = [elasFlag[1] + ls]
                addHeaderData.append([line, data])
                nItem += 1
            #  addHeaderDataを追加
            meshHeaderData = meshHeaderData[:ip] + addHeaderData + meshHeaderData[ip:]
            if nItem != 1:
                header = meshHeaderData[im][0]
                header = pyFistr.setValName(header, "ITEM=" + str(nItem))
                meshHeaderData[im][0] = header
            #  meshFileに保存
            lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
            meshFile = currDir + os.sep + FistrModel_msh
            f = open(meshFile, "w", encoding="utf-8"); f.writelines(lines); f.close()
            
            #  cntを修正
            lines = readFistrModelCnt()
            cntHeaderData = pyFistr.getHeaderData(lines)
            flag = 0
            elsFlag = [elastic[2], elastic[3]]
            addHeaderData = []
            ip = -1
            for i in range(len(cntHeaderData)):
                header, data = cntHeaderData[i]
                words = deleteSp(header).split(",")
                if words[0] == "!MATERIAL":
                    name = pyFistr.getValName(header, "NAME")
                    if name == matName:
                        flag = 1
                    else:
                        flag = 0
                elif flag == 1:
                    if words[0] == "!ELASTIC":
                        data = [", ".join([elastic[0], elastic[1]]) + ls]
                        cntHeaderData[i] = [header, data]
                        ip = i + 1
                    elif words[0] == "!DENSITY":
                        if elastic[2] != "":
                            data = [elastic[2] + ls]
                            cntHeaderData[i] = [header, data]
                            elasFlag[0] = ""
                            ip = i + 1
                    elif words[0] == "!EXPANSION_COEFF":
                        if elastic[3] != "":
                            data = [elastic[3] + ls]
                            cntHeaderData[i] = [header, data]
                            elasFlag[1] = ""
                            ip = i + 1
                else:
                    flag = 0
            #  未保存dataを確認
            if elasFlag[0] != "":
                line = "!DENSITY" + ls
                data = [elastic[2] + ls]
                addHeaderData.append([line, data])
            elif elasFlag[1] != "":
                line = "!EXPANSION_COEFF, DEPENDENCIES=0" + ls
                data = [elastic[3] + ls]
                addHeaderData.append([line, data])
            #  addHeaderDataを追加
            cntHeaderData = cntHeaderData[:ip] + addHeaderData + cntHeaderData[ip:]
            #  cntFileに保存
            lines = []
            for header, data in cntHeaderData:
                lines += [header]
                lines += data
            cntFile = currDir + os.sep + FistrModel_cnt
            f = open(cntFile, "w", encoding="utf-8"); f.writelines(lines); f.close()
        else:
            #熱解析
            #  mshファイル内を修正
            flag = 0
            for i in range(len(meshHeaderData)):
                header, data = meshHeaderData[i]
                words = deleteSp(header).split(",")
                if words[0] == "!MATERIAL":
                    name = pyFistr.getValName(header, "NAME")
                    if name == matName:
                        flag = 1
                    else:
                        flag = 0
                elif flag == 1:
                    if words[0] == "!ITEM=1":       #E,myu
                        data = [elastic[2] + ls]
                        meshHeaderData[i] = [header, data]
                    elif words[0] == "!ITEM=2":
                        if heatVals[1] != "":
                            data = [heatVals[1] + ls]   
                            meshHeaderData[i] = [header, data]
                    elif words[0] == "!ITEM=3":
                        if heatVals[0] != "":
                            data =  [heatVals[0] + ls]
                            meshHeaderData[i] = [header, data]
                else:
                    flag = 0
            #  mshFileに保存
            lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
            meshFile = currDir + os.sep + FistrModel_msh
            f = open(meshFile, "w", encoding="utf-8"); f.writelines(lines); f.close()
            #  cntを修正
            lines = readFistrModelCnt()
            cntHeaderData = pyFistr.getHeaderData(lines)
            flag = 0
            for i in range(len(cntHeaderData)):
                header, data = cntHeaderData[i]
                words = deleteSp(header).split(",")
                if words[0] == "!MATERIAL":
                    name = pyFistr.getValName(header, "NAME")
                    if name == matName:
                        flag = 1
                    else:
                        flag = 0
                elif flag == 1:
                    if words[0] == "!DENSITY":
                        data = [elastic[2] + ls]
                        cntHeaderData[i] = [header, data]
                    elif words[0] == "!SPECIFIC_HEAT":
                        if heatVals[1] != "":
                            data = [heatVals[1] + ls]
                            cntHeaderData[i] = [header, data]
                    elif words[0] == "!THERMAL_CONDUCTIVITY":
                        if heatVals[0] != "":
                            data = [heatVals[0] + ls]
                            cntHeaderData[i] = [header, data]
                else:
                    flag = 0
            #  cntFileに保存
            lines = []
            for header, data in cntHeaderData:
                lines += [header]
                lines += data
            cntFile = currDir + os.sep + FistrModel_cnt
            f = open(cntFile, "w", encoding="utf-8"); f.writelines(lines); f.close()

    #
    #  setMaterialDataNonlinearFromDbToCnt
    def setMaterialDataNonlinearFromDbToCnt(self, matName):
        """ cnt内の非線形材料の物性値をDB内の値を置き換える"""

        def getValsLine(vals):
            line = ", ".join(vals)
            if line[-2:] == ", ":
                line = line[:-2]
            line += ls
            return line

        #非線形dataをDBから取得
        mthDict, mats = self.getMaterialTypeHardenDict()
        matModel, matType, matHard = mats
        db3Vals, nlUnits = self.getMaterialParamsFromMatFile(matName, mthDict)
        valsLine = getValsLine(db3Vals)
        valsData = [valsLine]
        #cntFileを修正
        lines = readFistrModelCnt()
        headerData = pyFistr.getHeaderData(lines)
        #  matNameを検索
        si = len(headerData)
        for i in range(len(headerData)):
            header, data = headerData[i]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] == "!MATERIAL":
                name = pyFistr.getValName(header, "NAME")
                if name == matName:
                    si = i + 1
                    break
        #  非線形部を検索
        for i in range(si, len(headerData)):
            header, data = headerData[i]
            words = pyFistr.deleteSp(header).split(",")
            if words[0] in matGrpHeader:
                if words[0] == "!" + matModel:
                    headerData[i][1] = valsData
                    break
            else:
                break
        #  書き込み
        lines = []
        for header, data in headerData:
            lines += [header]
            lines += data
        writeFistrModelCnt(lines)

    #
    #  checkPhysicalValueENull
    def checkPhysicalValueENull(self, values):
        """ young率(values[0])の指数checkとnull文字のcheck"""
        values = list(values)
        #値を整形
        for i in range(len(values)):
            values[i] = pyFistr.float2strAuto(values[i])
            if values[i] == "":
                values[i] = " - "
        return values

    #
    #  replaceElasticMaterialInDB
    #-----------------------------
    def replaceElasticMaterialInDB(self, matName):
        """ DB内の値をcntで定義されている材料定数に書き換える"""

        #cntの材料定数を取得
        E, myu, rho, alpha, kappa, cp = self.getMaterialCoeffInMshCnt(matName)
        conts = [E, myu, rho, alpha, kappa, cp]
        #値を書き換え
        f = open(materialDBName, encoding="utf-8"); lines = f.readlines(); f.close()
        for i in range(len(lines)):
            words = deleteSp(lines[i]).split(",")
            if words[0] == matName:
                for ii in range(len(conts)):
                    if conts[ii] != "":
                        words[ii+1] = conts[ii]
                lines[i] = ",".join(words) + ls
                break
        f = open(materialDBName, "w", encoding="utf-8"); f.writelines(lines); f.close()
        #非線形dataをcntから取得
        mthDict, mats = self.getMaterialTypeHardenDict()
        vals = getNonlinearMaterialDataInCnt(matName, mats)
        #DBに保存
        if vals != ["", "", ""]:
            self.saveMaterialParamsToMatFile(matName, mthDict, vals)

    #
    #  setNewElasticMaterialInDB
    #----------------------------
    def setNewElasticMaterialInDB(self, matName):
        """ 未登録材料をDBに登録する"""
        #材料定数を取得
        E, myu, rho, alpha, kappa, cp = self.getMaterialCoeffInMshCnt(matName)
        self.addNewElasticMaterialInDB(matName, E, myu, rho, alpha, kappa, cp)
        self.readMaterialDB()
        self.setMaterialNameToListBox()
        #newMaterialを選択
        self.combo_matName.selectItem(matName)

    #
    #  getMaterialCoeffInMshCnt
    def getMaterialCoeffInMshCnt(self, matName):
        """ mshFileから物性値を読み込み、cntFileの物性値で置き換える
        cntFileの値が優先する。"""
        valsMsh = self.getMaterialCoeffInMsh(matName)
        valsCnt = self.getMaterialCoeffInCnt(matName)
        for i in range(len(valsMsh)):
            if valsCnt[i] != "":
                valsMsh[i] = valsCnt[i]
        return valsMsh

    #
    #  getMaterialCoeffInMsh
    def getMaterialCoeffInMsh(self, matName):
        """ mshFileから物性値を取得する"""
        
        def _isHeatMaterial(st):
            """ 熱解析用の材料物性値か確認する"""
            i = st + 1
            ans = False
            while i < len(meshHeaderData):
                header, data = meshHeaderData[i]
                words = deleteSp(header).split(",")
                if words[0] == "!ITEM=1":
                    if words[1] == "SUBITEM=1":
                        ans = True
                    else:
                        ans = False
                    break
                elif words[0][:len("!ITEM")] != "!ITEM":
                    break
                i += 1
            return ans

        global meshHeaderData, anaType
        E, myu, rho, alpha, kappa, cp = ("", "", "", "", "", "")
        st = -1
        for i in range(len(meshHeaderData)):
            header, data = meshHeaderData[i]
            words = deleteSp(header).split(",")
            if words[0] == "!MATERIAL":
                name = pyFistr.getValName(header, "NAME")
                if name == matName:
                    st = i
                    break
        if st > 0:
            #!Materialの物性値は、Heat用か？
            if _isHeatMaterial(st) == True:
                #熱解析
                i = st + 1
                while i < len(meshHeaderData):
                    header, data = meshHeaderData[i]
                    words = deleteSp(header).split(",")
                    if words[0] == "!ITEM=1":       #密度
                        line = data[0]
                        words = deleteSp(line).split(",")
                        rho = words[0]
                    elif words[0] == "!ITEM=2":     #比熱
                        line = data[0]
                        words = deleteSp(line).split(",")
                        #kappa = words[0]
                        cp = words[0]
                    elif words[0] == "!ITEM=3":     #熱伝導率
                        line = data[0]
                        words = deleteSp(line).split(",")
                        #cp = words[0]
                        kappa = words[0]
                    else:
                        break
                    i += 1
            else:
                #構造
                i = st + 1
                while i < len(meshHeaderData):
                    header, data = meshHeaderData[i]
                    words = deleteSp(header).split(",")
                    if words[0] == "!ITEM=1":
                        line = data[0]
                        words = deleteSp(line).split(",")
                        E = words[0]
                        myu = words[1]
                    elif words[0] == "!ITEM=2":
                        line = data[0]
                        words = deleteSp(line).split(",")
                        rho = words[0]
                    elif words[0] == "!ITEM=3":
                        line = data[0]
                        words = deleteSp(line).split(",")
                        alpha = words[0]
                    else:
                        break
                    i += 1
        return [E, myu, rho, alpha, kappa, cp]

    #
    #  getMaterialCoeffInCnt
    def getMaterialCoeffInCnt(self, matName):
        """ 材料定数をcntファイルから取得して返す"""
        E, myu, rho, alpha, kappa, cp = ("", "", "", "", "", "")
        #lines = pyFistr.readFistrModelCnt()
        lines = readFistrModelCnt()
        si = pyFistr.getNextHeaderName(lines, 0, "!MATERIAL", "NAME="+matName)
        if si >= len(lines):
            return "", "", "", "", "", ""
        i = si + 1
        while i < len(lines):
            line = lines[i]
            words = pyFistr.deleteSp(line).split(",")
            if len(words) >= 1:
                if words[0] != "":
                    if words[0][0] == "!":
                        if words[0] == "!ELASTIC":
                            E, myu = pyFistr.deleteSp(lines[i+1]).split(",")[:2]
                        elif words[0] == "!DENSITY":
                            rho = pyFistr.deleteSp(lines[i+1]).split(",")[0]
                        elif words[0] == "!EXPANSION_COEFF":
                            alpha = pyFistr.deleteSp(lines[i+1]).split(",")[0]                        
                        elif words[0] == "!THERMAL_CONDUCTIVITY":
                            kappa = pyFistr.deleteSp(lines[i+1]).split(",")[0]
                        elif words[0] == "!SPECIFIC_HEAT":
                            cp = pyFistr.deleteSp(lines[i+1]).split(",")[0]
                        else:
                            break
            i += 1
        return [E, myu, rho, alpha, kappa, cp]

    #
    #  addNewElasticMaterialInDB
    def addNewElasticMaterialInDB(self, matName, E, myu, rho, alpha, kappa, cp):
        """ 材料DBに新たな材料名を登録する"""
        f = open(materialDBName, encoding="utf-8"); lines = f.readlines(); f.close()
        words = lines[0].split(",")
        vals = ["" for i in range(len(words))]
        vals = [matName, E, myu, rho, alpha, kappa, cp] + vals[7:]
        newLine = ",".join(vals) + "\n"
        lines += [newLine]
        f = open(materialDBName, "w", encoding="utf-8"); f.writelines(lines); f.close()


    #
    #  getMaterialTypeHardenDict
    def getMaterialTypeHardenDict(self):
        """ 材料の選択内容と辞書を取得"""

        def getSelectedName(combo):
            name = combo.getSelectedItem()
            if name == None:
                name = ""
            return name

        matModel = getSelectedName(self.combo_matModel)
        matType = getSelectedName(self.combo_matType)
        matHard = getSelectedName(self.combo_matHard)
        mats = (matModel, matType, matHard)
        mthDict = materialMthDict()[mats]
        return mthDict, mats

    #
    #  checkElasticMaterialDataInDB
    #--------------------------------
    def checkElasticMaterialDataInDB(self, matName):
        """ cntFileの内容とDBの内容をチェックする。
        異なる値の場合、newMatNameを返す"""

        def convFloat(numStr):
            try:
                num = float(numStr)
            except:
                num = numStr
            return num

        if matName == "noData":
            return matName
        #cntFileの内容
        E, myu, rho, alpha, kappa, cp = self.getMaterialCoeffInMshCnt(matName)
        conts = [E, myu, rho, alpha, kappa, cp]
        conts = self.checkPhysicalValueENull(conts)
        #DBの内容
        vals, heatVals = getMaterialElasticValue(matName)
        dbConts = vals + heatVals
        dbConts = self.checkPhysicalValueENull(dbConts)
        #必要な値のみ抽出
        anaType = getSolutitionTypeFromCnt()
        if anaType == "HEAT" or anaType == "HEAT_D":
            nums = (2, 4, 5)
        else:
            nums = (0, 1, 2, 3)
        cntVals = list(map(lambda x: conts[x], nums))
        dbVals = list(map(lambda x: dbConts[x], nums))
        #数値に変換
        cntVals = list(map(convFloat, cntVals))
        dbVals = list(map(convFloat, dbVals))
        #非線形データを取得
        cnt3Vals = ["", "", ""]
        db3Vals = ["", "", ""]
        mthDict, mats = self.getMaterialTypeHardenDict()
        if mthDict["dialog"] != "office" and mthDict["dialog"] != None:
            #cntFileの内容を取得
            cnt3Vals = getNonlinearMaterialDataInCnt(matName, mats)
            cnt3Vals = self.checkPhysicalValueENull(cnt3Vals)
            #matDBの内容を取得
            db3Vals, units = self.getMaterialParamsFromMatFile(matName, mthDict)
            db3Vals = self.checkPhysicalValueENull(db3Vals)
            #数値に変換
            cnt3Vals = list(map(convFloat, cnt3Vals))
            db3Vals = list(map(convFloat, db3Vals))
        #内容をチェック
        if cntVals == dbVals and cnt3Vals == db3Vals:
            return ""
        #newNameを取得
        newMatName = self.getNewMaterialName(matName)
        return newMatName

    #
    #  getNewMaterialName
    def getNewMaterialName(self, matName):
        """ 新しいmatNameを取得する。"""
        matNames = materialDBCont
        matNo = matName.split("_")[-1]
        orgMatName = "_".join(matName.split("_")[:-1])
        try:
            a = int(matNo)
            flag = 0
        except:
            flag = 1
        if flag == 1:
            newMatName = matName + "_1"
            return newMatName
        i = 0
        while i < 20:
            i += 1
            newMatName = orgMatName + "_" + str(a+i)
            if not (newMatName in matNames):
                break
        return newMatName

    #
    #  readSetMaterialType
    #    材料名、タイプを設定
    def readSetMaterialType(self, matName, egrpName):
        #板厚を取得
        elType = ""
        for mat in matDefine:
            if mat[0] == egrpName:
                elType = mat[2]
                break
        #solid,shell,beamに関する項目の表示非表示設定
        if isThicknessElementType(elType) == True:
            #shell
            params = getShellThickness(egrpName)
            self.setMaterialThicknessToTextBox(params)
            self.hideMaterialBeamParamsTextBox()
        elif isBeamElementType(elType) == True:
            #beam
            params = getShellThickness(egrpName)
            self.setMaterialBeamParamsToTextBox(params)            
            self.hideMaterialThicknessTextBox()
        else:
            #solid
            self.setMaterialThicknessToTextBox(["", ""])
            self.hideMaterialThicknessTextBox()
            self.hideMaterialBeamParamsTextBox()
        #材料名、タイプを取得し、buttonに表示
        if anaType[:len("HEAT")] != "HEAT":
            [matModel, matType, matHard, mat3Vals] = readGetMaterialModel(matName)
            self.setMaterialTypeToListBox([matModel, matType, matHard])
            self.setSsDataButtonLabel()
        else:
            self.setHeatMaterialTypeToListBox()

    #
    #  isMatNameHeat
    def isMatNameHeat(self, matName):
        """ materialNameが熱解析用のデータがどうか確認する
        matNamen内で「!SPECIFIC_HEAT」が定義されているか？
        
        Args:
            matName (str)   :材料名
        Returns:
            True      :熱解析用データ
            False     :構造解析用データ"""
        lines = readFistrModelCnt()
        headerData = pyFistr.getHeaderData(lines)
        flag = 0
        inFlag = 0
        for header, data in headerData:
            keyword = deleteSp(header).split(",")[0]
            if inFlag == 1:
                if keyword == "!SPECIFIC_HEAT":
                    flag = 1
                    break
            if keyword == "!MATERIAL":
                if pyFistr.getValName(header, "NAME") == matName:
                    inFlag = 1
                else:
                    inFlag = 0
            elif keyword[0] == "#":
                inFlag = 0
        if flag == 1:
            return True
        else:
            return False

    #
    #  setMaterialThicknessToTextBox
    #    材料の板厚をtextBoxにセット
    def setMaterialThicknessToTextBox(self, params):
        self.textCtrl_tShell.set_sensitive(True)
        self.textCtrl_nShell.set_sensitive(True)
        if len(params) != 2:
            #params取得できていない場合、default値を設定
            params = ["1.0", "5"]
        self.textCtrl_tShell.set_text(params[0])
        self.textCtrl_nShell.set_text(params[1])

    #
    #  setMaterialBeamParamsToTextBox
    #    beamのデータをtextBoxにセット
    def setMaterialBeamParamsToTextBox(self, params):
        self.button_getZaxis.set_sensitive(True)
        self.button_calcSect.set_sensitive(True)
        self.textCtrl_beamVx.set_sensitive(True)
        self.textCtrl_beamVy.set_sensitive(True)
        self.textCtrl_beamVz.set_sensitive(True)
        self.textCtrl_beamArea.set_sensitive(True)
        self.textCtrl_beamIyy.set_sensitive(True)
        self.textCtrl_beamIzz.set_sensitive(True)
        self.textCtrl_beamJx.set_sensitive(True)
        if len(params) != 7:
            #paramsが取得できていない場合、空白を設定する
            i = len(params)
            while i < 7:
                params.append("")
                i += 1
        self.textCtrl_beamVx.set_text(params[0])
        self.textCtrl_beamVy.set_text(params[1])
        self.textCtrl_beamVz.set_text(params[2])
        self.textCtrl_beamArea.set_text(params[3])
        self.textCtrl_beamIyy.set_text(params[4])
        self.textCtrl_beamIzz.set_text(params[5])
        self.textCtrl_beamJx.set_text(params[6])

    #
    #  hideMaterialThicknessTextBox
    #    textBoxを隠す
    def hideMaterialThicknessTextBox(self):
        self.textCtrl_tShell.set_sensitive(False)
        self.textCtrl_nShell.set_sensitive(False)
        self.textCtrl_tShell.set_text("")
        self.textCtrl_nShell.set_text("")

    #
    #  hideMaterialBeamParamsTextBox
    #
    def hideMaterialBeamParamsTextBox(self):
        self.button_getZaxis.set_sensitive(False)
        self.button_calcSect.set_sensitive(False)
        self.textCtrl_beamVx.set_sensitive(False)
        self.textCtrl_beamVy.set_sensitive(False)
        self.textCtrl_beamVz.set_sensitive(False)
        self.textCtrl_beamArea.set_sensitive(False)
        self.textCtrl_beamIyy.set_sensitive(False)
        self.textCtrl_beamIzz.set_sensitive(False)
        self.textCtrl_beamJx.set_sensitive(False)
        self.textCtrl_beamVx.set_text("")
        self.textCtrl_beamVy.set_text("")
        self.textCtrl_beamVz.set_text("")
        self.textCtrl_beamArea.set_text("")
        self.textCtrl_beamIyy.set_text("")
        self.textCtrl_beamIzz.set_text("")
        self.textCtrl_beamJx.set_text("")

    #
    #  setMaterialTypeToListBox
    #    材料モデルなどをlistboxにセット
    def setMaterialTypeToListBox(self, modelType):
        self.maskEvent = True
        [matModel, matType, matHard] = modelType
        #matModelをセット
        matModels = []
        for mat in materialType:
            matModels.append(mat[0])
        self.combo_matModel.setItems(matModels)
        self.combo_matModel.selectItem(matModel)
        #matTypeをセット
        matTypes = []
        matHards = []
        for nameGroup in materialType:
            if matModel == nameGroup[0]:
                matTypes = nameGroup[1]
                matHards = nameGroup[2]
                break
        self.combo_matType.comboBox.set_sensitive(True)
        self.combo_matHard.comboBox.set_sensitive(True)
        if len(matTypes) == 0:
            self.combo_matType.comboBox.set_sensitive(False)
        else:
            self.combo_matType.setItems(matTypes)
            self.combo_matType.selectItem(matType)
        #matHardをセット
        self.combo_matHard.setItems(matHards)
        self.combo_matHard.selectItem(matHard)
        #ssDataボタン表示設定
        #if matModel == "PLASTIC":
        if matModel == "ELASTIC" or matModel == "HEAT":
            self.button_ssData.set_sensitive(False)
        else:
            self.button_ssData.set_sensitive(True)
        self.maskEvent = False

    #
    #  setHeatMaterialTypeToListBox
    #    HEATの設定
    def setHeatMaterialTypeToListBox(self):
        matModels = ["HEAT"]
        self.listmodelMatModel = Gtk.ListStore(str)
        self.combo_matModel.setItems(matModels)
        self.combo_matModel.selectItem(matModels[0])
        self.combo_matType.comboBox.set_sensitive(False)
        self.combo_matHard.comboBox.set_sensitive(False)

    #
    #  checkCntMshFile
    #    cnt, mshファイルをチェックし、存在しない場合defaultのファイルをcopyする
    def checkCntMshFile(self):
        global FistrModel_cnt, FistrModel_msh, FistrModelDict
        flag = "OK"
        hecmwFile = currDir + os.sep + "hecmw_ctrl.dat"
        #if len(glob.glob(hecmwFile)) == 0:
        if os.path.exists(hecmwFile) == False:
            copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + "hecmw_ctrl.dat"
            pasteFile = hecmwFile
            osCopyFile(copyFile, pasteFile)
            FistrModel_cnt = "FistrModel.cnt"
            FistrModel_msh = "FistrModel.msh"
            flag = "copied"
        #cntFile = currDir + os.sep + "FistrModel.cnt"
        cntFile = currDir + os.sep + FistrModel_cnt
        #if len(glob.glob(cntFile)) == 0:
        if os.path.exists(cntFile) == False:
            name = self.textCtrl_useCntFile.get_text()
            copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + name
            pasteFile = cntFile
            osCopyFile(copyFile, pasteFile)
            flag = "copied"
        #mshFile = currDir + os.sep + "FistrModel.msh"
        mshFile = currDir + os.sep + FistrModel_msh
        #if len(glob.glob(mshFile)) == 0:
        if os.path.exists(mshFile) == False:
            copyFile = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + "FistrModel_noMesh.msh"
            pasteFile = mshFile
            osCopyFile(copyFile, pasteFile)
            flag = "copied"
        if flag == "copied":
            FistrModelDict = pyFistr.getCntMshFileNameDict(currDir)
        return flag

    #
    #  setCntFilesToListBox
    #    cntファイルをlistboxに表示
    def setCntFilesToListBox(self):
        cntDir = os.getenv("easyIstrUserPath") + os.sep + "data"
        files = glob.glob(cntDir + os.sep + "*.cnt")
        names = []
        for fileName in files:
            name = fileName.split(os.sep)[-1]
            names.append(name)
        self.setListDataInListBox(self.listmodelCntFile, self.listBox_cntFile, names)

    #
    #  setControlCont
    #    境界条件を取得
    def setControlCont(self):
        global bndDefine, cloadDefine, dloadDefine, vloadDefine, centDefine
        global tempDefine, reftempDefine
        global gravDefine, anaType, contactDefine, stepDefine, floadDefine
        global fixtempDefine, cfluxDefine, dfluxDefine, bfDefine, sfluxDefine, sfilmDefine
        global sradiateDefine, veloDefine, accelDefine, springDefine
        anaType = getSolutitionTypeFromCnt()
        lines = readFistrModelCnt()
        bndDefine = getBoundaryNodeGroupInCnt(lines, "!BOUNDARY")
        cloadDefine = getBoundaryNodeGroupInCnt(lines, "!CLOAD")
        dloadDefine = getDloadGroupInCnt(lines)
        vloadDefine = getVloadGroupInCnt(lines)
        centDefine = getCentGroupInCnt(lines)
        gravDefine = getGravGroupInCnt(lines)
        springDefine = getBoundaryNodeGroupInCnt(lines, "!SPRING")
        contactDefine = getBoundaryNodeGroupInCnt(lines, "!CONTACT")
        floadDefine = getBoundaryNodeGroupInCnt(lines, "!FLOAD")
        veloDefine = getBoundaryNodeGroupInCnt(lines, "!VELOCITY")
        accelDefine = getBoundaryNodeGroupInCnt(lines, "!ACCELERATION")
        fixtempDefine = getBoundaryNodeGroupInCnt(lines, "!FIXTEMP")
        cfluxDefine = getBoundaryNodeGroupInCnt(lines, "!CFLUX")
        #dfluxDefine = getBoundaryNodeGroupInCnt(lines, "!DFLUX")
        dfluxDefine = getDfluxGroupInCnt(lines)
        bfDefine = getBfGroupInCnt(lines)
        sfluxDefine = getBoundaryNodeGroupInCnt(lines, "!SFLUX")
        sfilmDefine = getBoundaryNodeGroupInCnt(lines, "!SFILM")
        sradiateDefine = getBoundaryNodeGroupInCnt(lines, "!SRADIATE")
        tempDefine = getBoundaryNodeGroupInCnt(lines, "!TEMPERATURE")
        reftempDefine = getReftempInCnt(lines)
        stepDefine = getStepGroupInCnt(lines)

    #  setAnalysisTypeToComboBox
    #
    def setAnalysisTypeToComboBox(self):
        anaTypes = analysisTypes()
        self.listmodelAnaType.clear()
        self.comboBox_anaType.clear()
        #modelにデータセット
        for data in anaTypes:
            self.listmodelAnaType.append([data])
        #modelをセット
        cell = Gtk.CellRendererText()
        self.comboBox_anaType.pack_start(cell, True)
        self.comboBox_anaType.add_attribute(cell, 'text', 0)
        self.comboBox_anaType.set_model(self.listmodelAnaType)
        #active名をセット   
        if anaType == "STATIC":
            self.comboBox_anaType.set_active(0)
        elif anaType == "NLSTATIC":
            self.comboBox_anaType.set_active(1)
        elif anaType == "DYNAMIC":
            self.comboBox_anaType.set_active(2)
        elif anaType == "EIGEN":
            self.comboBox_anaType.set_active(3)
        elif anaType == "DYNAMIC_F":
            self.comboBox_anaType.set_active(4)
        elif anaType == "HEAT":
            self.comboBox_anaType.set_active(5)
        elif anaType == "HEAT_D":
            self.comboBox_anaType.set_active(6)
        else:
            self.comboBox_anaType.set_active(0)

    #  getNoGroups
    #    allとselectのgroupからunselectのgroupを返す
    def getNoGroups(self, allGroups, selGroups):
        noSels = []
        for allGroup in allGroups:
            flag = 0
            for selGroup in selGroups:
                if allGroup == selGroup:
                    flag = 1
                    break
            if flag == 0:
                #「dummy***」のgroup名は除く
                if allGroup[:len("dummy")] != "dummy":
                    noSels.append(allGroup)
        noSels.sort()
        return noSels

    #
    #  setMaterialModelToComboBox
    #    材料モデルをcomboBoxにセットする（デフォルト値）
    def setMaterialModelToComboBox(self):
        #材料モデルをセット
        matModels = []
        for nameType in materialType:
            matModels.append(nameType[0])
        self.combo_matModel.setItems(matModels)
        #降伏条件/タイプをセット
        self.combo_matType.setItems([])
        #硬化則
        self.combo_matHard.setItems([])

    #
    #  setMaterialNameToListBox
    #    材料名をlistBoxにセット
    def setMaterialNameToListBox(self):
        global materialDBCont
        self.combo_matName.setItems(materialDBCont)

    #
    #  readMaterialDB
    #    材料DBを読み込み表示
    def readMaterialDB(self):
        global materialDBCont
        #matFile読み込み
        fileName = materialDBName
        data = pyFistr.readMaterialData(fileName)
        if len(data) == 0:
            return
        #材料名のみ取得
        materialDBCont = []
        i = 2
        while i < len(data):
            mat = data[i]
            materialDBCont.append(mat[0])
            i += 1
        materialDBCont.sort()

    #
    #  setIstrData
    #    istr_dataの内容をGUIに設定する
    def setIstrData(self):
        global currDir, sourceMeshFile, istrData, materialDBName
        for line in istrData:
            items = line.split()
            if items[0] == "convertOpt":
                if items[1] == "unv2fistr":
                    #self.radioBtn_unv2fistr.set_active(True)
                    pass
                else:
                    #self.radioBtn_abaqus2fistr.set_active(True)
                    pass
            elif items[0] == "currDir":
                currDir = items[1]
            elif items[0] == "sourceMesh":
                if len(items) > 1:
                    sourceMeshFile = items[1]
                    #self.textCtrl_sourceMesh.set_text(sourceMeshFile)
                #else:
                #    self.textCtrl_sourceMesh.set_text("")
            elif items[0] == "materialDB":
                materialDBName = items[1]
                self.textCtrl_matDB.set_text(materialDBName)
            elif items[0] == "useCntFile":
                self.textCtrl_useCntFile.set_text(items[1])
            elif items[0] == "execFile":
                pass
        #if len(glob.glob(currDir)) == 0:
        if os.path.exists(currDir) == False:
            currDir = os.getenv("HOME")
        os.chdir(currDir)

    #
    #  showTreeData
    #    treeList構造を開いて表示
    def showTreeData(self, treeList):
        self.setNewTreeData()
        self.showTreeParentExpand(treeList)

    #
    #  showTreeParentExpand
    #    親itemを表示し、親をexpandする
    def showTreeParentExpand(self, treeList):
        #rootName = treeData[0]
        #表示させるpathを取得
        tree = treeData[1]
        path = (0,)
        for name in treeList:
            n = 0
            while n < len(tree):
                nTree = tree[n]
                if type(nTree) == str:
                    treeName = nTree
                    aTree = []
                else:
                    treeName = nTree[0]
                    aTree = nTree[1]
                if treeName == name:
                    path += (n,)
                    tree = aTree
                    break
                n += 1
        #pathまでをexpandする。
        Gpath = Gtk.TreePath(path)
        self.tree_main.expand_to_path(Gpath)
        self.tree_main.set_cursor(Gpath)

    #
    #  setIniTreeData
    #    初期のTreeを作成
    def setIniTreeData(self):
        rootName = treeData[0]
        items = treeData[1]
        #treeMainをクリアする
        self.treeMainClear()
        #rootを追加
        root = self.treestore.append(None, [rootName])
        #root以下をmodelに追加
        self.addTreeNodes(self.treestore, root, items)
        #treeViewにmodelを追加
        self.tree_main.set_model(model=self.treestore)
        #treeのlabelを1行目に追加
        self.tvcolumn = Gtk.TreeViewColumn("Tree")
        self.tree_main.append_column(self.tvcolumn)
        #treeを作成
        self.cell = Gtk.CellRendererText()
        self.tvcolumn.pack_start(self.cell, True)
        self.tvcolumn.add_attribute(self.cell, "text", 0)
        #treeの文字色,styleを設定
        self.setTreeFontColour(anaType)
        #rootを展開
        path = Gtk.TreePath(0)
        self.tree_main.expand_row(path, False)

    #
    #  setTreeFontColour
    #    treeの文字色を設定
    def setTreeFontColour(self, anaType_1):
        """ tree_mainのfont色、style(normal,bold)を設定する"""

        def _setTVAttr(col, cell, model, itr, dummy):
            #fontColor設定
            cell.props.foreground = "black"
            path = model.get_path(itr)
            if len(path) == 3:
                for upath in unneedPath:
                    if path[1] == upath[1] and path[2] == upath[2]:
                        cell.props.foreground = "gray"
                        break
            #fontStyle設定(NORMAL or BOLD)
            cell.props.weight = self.NORMAL
            if len(gothPathes) > 0:
                for goPath in gothPathes:
                    if path == goPath:
                        cell.props.weight = self.BOLD
                        break

        #font色を変えるpathを取得
        [dummy_needBnds, unneedBnds] = getNeedUnneedBoundaryNo(anaType)
        unneedPath = []
        for n in unneedBnds:
            unneedPath.append((0,5,n))
        if len(stepDefine) >= 2:
            for m in range(len(stepDefine)-1):
                for n in unneedBnds:
                    unneedPath.append((0,5+m+1, n))
        #fontをゴシックにするpathを取得
        gothPathes = self.getAddTreeItemsPath()
        #font色変更
        self.tvcolumn.set_cell_data_func(self.cell, _setTVAttr) 
        #font色表示
        #  選択pathを取得
        treeSelection = self.tree_main.get_selection()
        _treestore, pathes = treeSelection.get_selected_rows()
        if len(pathes) > 0:
            selPath = pathes[0]
            #  selectItemをマスク
            self.maskSelectItem = True
            for path in gothPathes:
                #pathにcursorを設定してfontを表示
                self.tree_main.set_cursor(path, None, False)
            #  選択pathを選択状態に設定
            self.tree_main.set_cursor(selPath, None, False)
            #  selectItemのマスク解除
            self.maskSelectItem = False

    #
    #  getAddTreeItemsPath
    def getAddTreeItemsPath(self):
        """ self.addTreeItemsSetのpathを取得する"""
        goPathes = []
        for addItemsSet in self.addTreeItemsSet:
            goPath = [0]
            treeItems = treeData[1]
            for addItem in addItemsSet:
                for i in range(len(treeItems)):
                    if type(treeItems[i]) == list:
                        item = treeItems[i][0]
                    else:
                        item = treeItems[i]
                    if item == addItem:
                        goPath.append(i)
                        treeItems = treeItems[i][1]
                        break
            path = Gtk.TreePath.new_from_indices(goPath)
            goPathes.append(path)
            if len(path) > 2:
                #root以外の親pathを追加
                path0 = Gtk.TreePath.new_from_indices(goPath[:-1])
                goPathes.append(path0)
        return goPathes

    #
    #  treeMainClear
    #    treeMain(設定項目Tree）をクリア
    def treeMainClear(self):
        self.maskShowPage = True
        self.treestore.clear()
        self.maskShowPage = False
        col = self.tree_main.get_column(0)
        if col != None:
            self.tree_main.remove_column(col)

    #
    #  setNewTreeData
    #    treeData(設定項目Tree）を入れ替え
    def setNewTreeData(self):
        rootName = treeData[0]
        items = treeData[1]
        #treeMainをクリアする
        self.maskShowPage = True
        self.treestore.clear()
        self.maskShowPage = False
        col = self.tree_main.get_column(0)
        if col != None:
            self.tree_main.remove_column(col)
        #treeのlabelを1行目に追加
        self.tvcolumn = Gtk.TreeViewColumn("Tree")
        self.tree_main.append_column(self.tvcolumn)
        #treeを作成
        self.cell = Gtk.CellRendererText()
        self.tvcolumn.pack_start(self.cell, True)
        self.tvcolumn.add_attribute(self.cell, "text", 0)

        #rootを追加
        root = self.treestore.append(None, [rootName])
        #root以下をmodelに追加
        self.addTreeNodes(self.treestore, root, items)
        #treeの文字色を設定
        self.setTreeFontColour(anaType)

    #  addTreeNodes
    def addTreeNodes(self, treeStore, parentItem, items):
        for item in items:
            if type(item) == str:
                newItem = treeStore.append(parentItem, [item])
            else:
                newItem = treeStore.append(parentItem, [item[0]])
                self.addTreeNodes(treeStore, newItem, item[1])

    #
    #  setMeshCont
    #    mesh内容を読み込み、表示
    def setMeshCont(self):
        global ampDefine, initempDefine
        #meshデータ読み込み
        [meshCont, ampNames, initempNames] = getFistrModelMeshData(currDir)
        meshConts = getMeshContsFromTempFolder()
        meshCont = meshConts["meshCont"]
        #labelに表示
        self.label_meshCnt.set_label(meshCont)
        #amplitudeを取得
        ampDefine = ampNames
        #initialを取得
        initempDefine = initempNames

    #
    #  getStepIdFromItem
    #    親itemからstepIdを取得
    def getStepIdFromItem(self):
        #親itemを取得
        treeCtrl = self.tree_main
        path, dummy_column = treeCtrl.get_cursor()
        parentName = self.getParentNameInTreeData(path)
        #stepIdを取得
        nStep = 0
        words = parentName.split()
        if len(words) >= 2:
            i = 0
            for step in stepDefine:
                if step == words[1]:
                    nStep = i
                    break
                i += 1
        return nStep

    #
    #  getStepIdFromSubItem
    #    親の親itemからstepIdを取得
    def getStepIdFromSubItem(self):
        #親親itemを取得
        treeCtrl = self.tree_main
        path, dummy_column = treeCtrl.get_cursor()
        gndParentName = self.getNameInTreeData(path[:-2])
        #stepIdを取得
        nStep = 0
        words = gndParentName.split()
        if len(words) >= 2:
            i = 0
            for step in stepDefine:
                if step == words[1]:
                    nStep = i
                    break
                i += 1
        return nStep


    #----------comboBox, listBoxの設定----------------------
    #
    #  getNamesInListmodel
    #    listmodelから全namesを取得
    def getNamesInListmodel(self, listmodel):
        names = []
        iter = listmodel.get_iter_first()
        while iter != None:
            name = listmodel.get_value(iter, 0)
            names.append(name)
            iter = listmodel.iter_next(iter)
        return names

    #
    #  setListDataInListBox
    #    listBox(TreeView)をクリアしてデータをセットする
    def setListDataInListBox(self, listModel, listBox, setNames):
        listModel.clear()
        setNames.sort()
        for name in setNames:
            listModel.append([name])
        listBox.set_model(model=listModel)
        cols = [""]
        for i in range(len(cols)):
            coll = listBox.get_column(i)
            if coll != None:
                listBox.remove_column(coll)
            cell = Gtk.CellRendererText()
            col = Gtk.TreeViewColumn(cols[i], cell, text=i)
            listBox.append_column(col)
        listBox.set_headers_visible(False)

    #
    #  sortBndList
    #    stepのlistをsortする
    def sortBndList(self, setNames):
        bnds = []
        for bnd in setNames:
            words = bnd.split(",")
            bnds.append([words[-1], bnd])
        bnds.sort()
        ans = []
        for bnd in bnds:
            ans.append(bnd[1])
        setNames = ",".join(ans)
        return ans

    #
    #  setListDataInListBoxStep
    #    stepのlistBox(TreeView)をクリアしてデータをセットする
    def setListDataInListBoxStep(self, listModel, listBox, setNames):
        listModel.clear()
        setNames = self.sortBndList(setNames)
        for name in setNames:
            listModel.append([name])
        listBox.set_model(model=listModel)
        cols = [""]
        for i in range(len(cols)):
            coll = listBox.get_column(i)
            if coll != None:
                listBox.remove_column(coll)
            cell = Gtk.CellRendererText()
            col = Gtk.TreeViewColumn(cols[i], cell, text=i)
            listBox.append_column(col)
        listBox.set_headers_visible(False)

    #
    #  setComboDataInComboBox
    #    comboBoxをクリアしてデータをセットする
    def setComboDataInComboBox(self, listModel, comboBox, setNames):
        comboBox.clear()
        listModel.clear()
        for name in setNames:
            listModel.append([name])
        cell = Gtk.CellRendererText()
        comboBox.pack_start(cell, True)
        comboBox.add_attribute(cell, "text", 0)
        comboBox.set_model(listModel)

    #
    #  setComboActiveText
    #    comboBoxの指定したtextをactiveに設定
    def setComboActiveText(self, comboBox, selName, names):
        n = 0
        for name in names:
            if name == selName:
                break
            n += 1
        comboBox.set_active(n)

    #
    #  setStatusBar
    #--------------
    def setStatusBar(self):
        """ statusBarに内容を表示する"""
        workDir = getCurrDirFromTempFolder()
        self.setHddUsageToStatusBar(workDir)

    #
    #  setHddUsageToStatusBar
    def setHddUsageToStatusBar(self, path):
        """ pathを基準にHddの空きを調べstatusBarに書き込む"""
        if os.path.exists(path) == False:
            path = os.getenv("HOME")
        (total, free) = folderContHddVals.getDiskSpace(path)
        self.writeHddUsageToStatusBar(total, free)

    def writeHddUsageToStatusBar(self, total, free):
        total = int(total / 1000**3 * 100) / 100.0
        free = int(free / 1000**3 * 100) / 100.0
        cont = _(" 合計 ") + str(total) + " GB, " + _("空き ") + str(free) + " GB"
        self.label_statusBar.set_text(cont)

    #
    #  writeUnsetTreeItems
    #----------------------
    def writeUnsetTreeItems(self):
        """ addTreeItemsSetの内容を保存する。
        Tree内の未確定項目を保存する。"""
        #保存data取得
        if len(self.addTreeItemsSet) == 0:
            lines = []
        else:
            lines = list(map(lambda x: ",".join(x) + ls, self.addTreeItemsSet))
        #tempFolderに保存
        fileName = currDirTemp + os.sep + "unsetTreeItems"
        f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()
        #実folderに保存
        currDir = getCurrDirFromTempFolder()
        if os.path.exists(currDir) == True:
            fileName = currDir + os.sep + "unsetTreeItems"
            f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()

    #
    #  readUnsetTreeItems
    #---------------------
    def readUnsetTreeItems(self):
        """ 保存したaddTreeItemsSetの内容を読み取る"""
        fileName = currDirTemp + os.sep + "unsetTreeItems"
        self.addTreeItemsSet = set([])
        if os.path.exists(fileName) == True:
            f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
            for line in lines:
                line = line.rstrip()
                words = line.split(",")
                wordsTuple = tuple(words)
                self.addTreeItemsSet.add(wordsTuple)

    #
    #  writeEasyIstrVersion
    #-----------------------
    def writeEasyIstrVersion(self):
        """ easyIstrのversionを書き込む"""
        path = os.getenv("easyIstrUserPath")
        fileName = os.sep.join([path, "data", "EasyISTR_version"])
        f = open(fileName, "w", encoding="utf-8"); f.write(version); f.close()

    #--- copy paste at clipboard -------------
    def setDirsToClipboard(self, selDirs):
        """ selDirsをclipboardにセットする。"""
        self.clipboard = selDirs

    def getDirsFromClipboard(self):
        """ clipboardのdirsを取得する"""
        dirs = self.clipboard
        return dirs

    #---universal dialog--------------
    def openFileDialog(self, title, fileDir, funcOk, funcCancel, parent=None, selName="", filterSets=[]):
        dialog = universalDialogs.openFileDialog(title, fileDir, funcOk, funcCancel, parent, selName, filterSets)
        dialog.show()

    def saveFileDialog(self, title, fileDir, funcOk, funcCancel, parent=None, selName="", filterSets=[]):
        dialog = universalDialogs.saveFileDialog(title, fileDir, funcOk, funcCancel, parent, selName, filterSets)
        dialog.show()

    def okDialog(self, title, message, parent=None):
        dialog = universalDialogs.okDialog(title, message, parent)
        dialog.show()

    def okCancelDialog2(self, title, message, funcOk, funcCancel, parent=None):
        dialog = universalDialogs.okCancelDialog(title, message, funcOk, funcCancel, parent)
        dialog.show()

    def yesNoDialog(self, title, message, funcYes, funcNo, parent=None):
        dialog = universalDialogs.yesNoDialog(title, message, funcYes, funcNo, parent)
        dialog.show()

    def errDialog(self, title, message, parent=None):
        dialog = universalDialogs.errDialog(title, message, parent)
        dialog.show()

    def warningDialog(self, title, message, parent=None):
        dialog = universalDialogs.warningDialog(title, message, parent)
        dialog.show()
        
#
#  getGrpNameInTempFolder
def getGrpNameInTempFolder():
    """ tempFolder内のmeshContens内からgrpNameを取得して返す"""
    meshCont = getMeshContsFromTempFolder()["meshCont"]
    lines = meshCont.split("\n")
    egrp = []
    sgrp = []
    ngrp = []
    for line in lines:
        words = line.split()
        if len(words) > 1:
            if words[0] == "EGRP":
                egrp.append(words[1])
            elif words[0] == "SGRP":
                sgrp.append(words[1])
            elif words[0] == "NGRP":
                ngrp.append(words[1])
    return egrp, sgrp, ngrp

#
#  checkNumStr
#    指数表記の文字列に小数点が無い場合は追加する
def checkNumStr(word):
    if word.find(".") >= 0:
        return word
    n = word.lower().find("e")
    if n >= 0:
        word = word[:n] + ".0" + word[n:]
    return word

#
#  checkNumStrs
#    list内の指数表記の文字列で小数点をチェック
def checkNumStrs(numStrs):
    nums = []
    for numStr in numStrs:
        num = checkNumStr(numStr)
        nums.append(num)
    return nums            

#
#  getUsedContactNamesInCnt
#    cnt内から使用済みのcontactNameを取得する。
def getUsedContactNamesInCnt():
    lines = readFistrModelCnt()
    usedNames = []
    flag = 0
    for line in lines:
        if line[0] == "!":
            words = pyFistr.deleteSp(line).split(",")
            if words[0] == "!CONTACT":
                flag = 1
            else:
                flag = 0
        else:
            if flag == 1:
                name = pyFistr.deleteSp(line).split(",")[0]
                usedNames.append(name)
    return usedNames    

#
#  skipStepId
#    nStep分skipする
def skipStepId(lines, nStep):
    i = 0
    if nStep <= 0:
        return i
 
    while i < len(lines):
        line = lines[i]
        if line[:len("!STEP")] == "!STEP":
            nStep -= 1
            if nStep <= 0:
                i += 1
                break
        i += 1
    return i

#
#  getMeshHeaderData
#    meshDataを取得
def getMeshHeaderData():
    global meshHeaderData
    meshHeaderData = pyFistr.getHeaderNumDataMsh(currDir)

#
#  getReturnMeshHeaderData
def getReturnMeshHeaderData():
    """ meshHeaderDataを取得し戻す"""
    meshHeaderData = pyFistr.getHeaderNumDataMsh(currDir)
    return meshHeaderData

#
#  getReturnMeshHeaderData_file
def getReturnMeshHeaderData_file(fileName):
    """ fileNameを指定してmeshHeaderDataを取得して返す"""
    lines = pyFistr.readFistrFileUntilEnd(fileName)
    meshHeaderData = pyFistr.getHeaderNumData(lines) 
    return meshHeaderData

#
#  showSettingDialog
#    設定中dialogを表示
def showSettingDialog(title):
    global settingDialog
    comm = 'python3 ' + pythonAppPath + 'settingDialog2.py "' + title + '"'
    settingDialog = subprocess.Popen(
        comm,
        shell=True,
        stdin=subprocess.PIPE,
        stdout=subprocess.PIPE)
    numSettingDialog(0, "preparing... ")

#
#  numSettingDialog
#    設定中dialogに進行状況を表示
#    （num>100.0の場合は、閉じる）
def numSettingDialog(num, cont):
    settingDialog.stdin.write((str(num) + "," + cont + "\n").encode())
    if settingDialog.poll() == None:
        #BrokenPipeでは無い時にflushする
        settingDialog.stdin.flush()

#
#  closeSettingDialog
#    設定中dialogを閉じる
def closeSettingDialog():
    numSettingDialog(100, "close")
    settingDialog.stdin.write(("close\n").encode())
    if settingDialog.poll() == None:
        #BrokenPipeでは無い時にflushする
        settingDialog.stdin.flush()

#
#  getRotationNodeGroup
#    回転の自由度を持っている要素のNGRPかどうかチェック
def getRotationNodeGroup(ngrpName, meshCont):
    #dummyのnodeGroupをチェック
    rotation = ""
    lines = meshCont.split("\n")
    for line in lines:
        words = line.split()
        if len(words) > 2:
            if words[0] == "NGRP" and words[1] == "dummy_" + ngrpName:
                rotation = True
                break
    if rotation != "":
        #dummyがあれば、Trueを返す
        return rotation

    #solid要素をチェック
    rotation = True
    for line in lines:
        words = line.split()
        if len(words) > 2:
            if words[0] == "elements":
                elType = words[1].split(":")[-1]
                if elType[0] == "3":
                    #dummyが無くて、solid要素があればFalseをチェック
                    rotation = False
                    break
    return rotation

#
#  osCopyFile
#    osに基づいたfileCopy
#    pythonで各行を読み込み、そのまま各行を書き込む事で、変換できる
def osCopyFile(copyFile, pasteFile):
    f=open(copyFile, encoding="utf-8"); lines=f.readlines(); f.close()
    w=open(pasteFile, "w", encoding="utf-8")
    for line in lines:
        w.write(line)
    w.close()

#  needBndItemNoDict
#    解析内容に必要な境界条件
needBndItemNoDict = {
        #解析名        境界条件No
        "STATIC":       needBndStatic,      #線形弾性静解析 
        "NLSTATIC":     needBndNlstatic,    #非線形解析
        "DYNAMIC":      needBndDynamic,     #動解析
        "EIGEN":        needBndEigen,       #固有値解析
        "DYNAMIC_F":    needBndDynamic_F,   #周波数応答解析
        "HEAT":         needBndHeat,        #定常伝熱解析
        "HEAT_D":       needBndHeat_D       #非定常伝熱解析
        }

#
#  getNeedUnneedBoundaryNo
#    現在の解析で必要な境界条件の要不要な境界条件Noを返す
def getNeedUnneedBoundaryNo(anaType):
    #解析内容に応じた境界条件Noを取得
    needBndNo = needBndItemNoDict[anaType]
    #treeを作成
    tree = initialTreeParts()
    #boundary = tree[4]
    #boundary = tree[5]
    boundary = tree[6]
    allBnds = boundary[0][1]
    unneedBndNo = []
    for an in range(len(allBnds)):
        flag = 0
        for n in needBndNo:
            if an == n:
                flag = 1
                break
        if flag == 0:
            unneedBndNo.append(an)
    return [needBndNo, unneedBndNo]

#
#  remakeNormalHecmwCtrl
#    hecmw_ctrl.datファイルを通常の状態に戻す
def remakeNormalHecmwCtrl():
    lines = readHecmwCtrlDat()
    i = pyFistr.getNextHeaderName(lines, 0, "!RESULT", "NAME=fstrRES")
    i += 1
    lines[i] = "FistrModel.res" + ls
    lines = deleteFstrDynaResultIn(lines)
    writeHecmwCtrlDat(lines)

#
#  remakeHeatResultIn
#    hecmw_ctrl.datファイルに熱解析結果入力を追加する
def remakeHeatResultIn():
    header = pyFistr.getHeaderName(FistrModelDict["res"])
    headerName = header.split("_")[0]
    lines = readHecmwCtrlDat()
    lines = deleteFstrDynaResultIn(lines)
    addLines =  ["!RESULT, NAME=fstrTEMP, IO=IN" + ls]
    #addLines += ["FistrModel_temp.res" + ls]
    addLines += [headerName + "_temp.res" + ls]
    i = pyFistr.getInsertPointInCnt(lines, "!RESULT", ["NAME=fstrRES"])
    lines = lines[:i] + addLines + lines[i:]
    writeHecmwCtrlDat(lines)

#
#  addFstrDynaResultIn
#    hecmw_ctrl.datの!RESULT NAMEにfistrDynaとresult-inを追加
def addFstrDynaResultIn(lines):
    header = pyFistr.getHeaderName(FistrModelDict["res"])
    headerName = header.split("_")[0]
    #fstrDYNAを追加
    i = pyFistr.getNextHeaderName(lines, 0, "!RESULT", "NAME=fstrDYNA")
    if i < len(lines):
        i += 1
        #lines[i] = "FistrModel_dyna.res" + ls
        lines[i] = headerName + "_dyna.res" + ls
    else:
        addLines = ["!RESULT, NAME=fstrDYNA, IO=OUT" + ls]
        #addLines += ["FistrModel_dyna.res" + ls]
        addLines += [headerName + "_dyna.res" + ls]
        i = pyFistr.getInsertPointInCnt(lines, "!RESULT", ["NAME=fstrRES"])
        lines = lines[:i] + addLines + lines[i:]
    #result-inを追加
    i = pyFistr.getNextHeaderName(lines, 0, "!RESULT", "NAME=result-in")
    if i < len(lines):
        i += 1
        #lines[i] = "FistrModel_eigen.res" + ls
        lines[i] = headerName + "_eigen.res" + ls
    else:
        addLines = ["!RESULT, NAME=result-in, IO=IN" + ls]
        #addLines += ["FistrModel_eigen.res" + ls]
        addLines += [headerName + "_eigen.res" + ls]
        i = pyFistr.getInsertPointInCnt(lines, "!RESULT", ["NAME=fstrRES"])
        lines = lines[:i] + addLines + lines[i:]
    return lines

#
#  deleteFstrDynaResultIn
#    hecmw_ctrl.datの!RESULT NAMEからfistrDynaとresult-inを削除
def deleteFstrDynaResultIn(lines):
    lines = pyFistr.deleteHeaderName(lines, 0, "!RESULT", "NAME=fstrDYNA")
    lines = pyFistr.deleteHeaderName(lines, 0, "!RESULT", "NAME=result-in")
    lines = pyFistr.deleteHeaderName(lines, 0, "!RESULT", "NAME=fstrTEMP")
    return lines

#
#  setSingleHcmwCtrlDat
#    hecmw_ctrl.datをsingle設定にする
def setSingleHcmwCtrlDat():
    lines = readHecmwCtrlDat()
    #for partitionを削除
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=part_in")
    if i < len(lines):
        lines = pyFistr.delete1header(lines, i)
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=part_out")
    if i < len(lines):
        lines = pyFistr.delete1header(lines, i)
    #for solver
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=fstrMSH")
    lines[i] = abaqus2fistr.setValName(lines[i], "TYPE=HECMW-ENTIRE")
    lines[i+1] = FistrModel_msh + ls
    #for visualizer
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=mesh")
    if i < len(lines):
        lines[i] = abaqus2fistr.setValName(lines[i], "TYPE=HECMW-ENTIRE")
        lines[i+1] = FistrModel_msh + ls
    writeHecmwCtrlDat(lines)

#
#  setParallelHcmwCtrlDat
#    hcmw_ctrl.datをparallel設定にする
def setParallelHcmwCtrlDat(nCpu):
    lines = readHecmwCtrlDat()
    #for partitionerを削除（無ければ何もしない）
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=part_in")
    if i < len(lines):
        lines = pyFistr.delete1header(lines, i)
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=part_out")
    if i < len(lines):
        lines = pyFistr.delete1header(lines, i)
    #for partitionerを追加
    headerName = pyFistr.getHeaderName(FistrModel_msh)
    addLines =  ["!MESH, NAME=part_in, TYPE=HECMW-ENTIRE" + ls]
    #addLines += ["FistrModel.msh" + ls]
    addLines += [FistrModel_msh + ls]
    addLines += ["!MESH, NAME=part_out, TYPE=HECMW-DIST" + ls]
    #addLines += ["FistrModel_p" + nCpu + ls]
    addLines += [headerName + "_p" + nCpu + ls]
    i = pyFistr.getInsertPointInCnt(lines, "!MESH", ["partition"])
    lines = lines[:i] + addLines + lines[i:]
    #for solver
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=fstrMSH")
    lines[i] = abaqus2fistr.setValName(lines[i], "TYPE=HECMW-DIST")
    #lines[i+1] = "FistrModel_p" + nCpu + ls
    lines[i+1] = headerName + "_p" + nCpu + ls
    #for visualizer
    i = pyFistr.getNextHeaderName(lines, 0, "!MESH", "NAME=mesh")
    #必ずしも必要でないため、未定義時はskipする
    if i < len(lines):
        lines[i] = abaqus2fistr.setValName(lines[i], "TYPE=HECMW-DIST")
        #lines[i+1] = "FistrModel_p" + nCpu + ls
        lines[i+1] = headerName + "_p" + nCpu + ls
    writeHecmwCtrlDat(lines)

#
#  hideHcmwPartCtrlDat
#    hcmw_part_ctrl.datを隠す
def hideHcmwPartCtrlDat():
    fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
    #if len(glob.glob(fileName)) != 0:
    if os.path.exists(fileName) == True:
        shutil.copy(fileName, fileName+".bak")
        os.remove(fileName)

#
#  loadHcmwPartCtrlDat
#    hcmw_part_ctrl.datをloadする
def loadHcmwPartCtrlDat():
    fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
    #if len(glob.glob(fileName+".bak")) != 0:
    if os.path.exists(fileName+".bak") == True:
        #bakファイルをrenameする
        shutil.copy(fileName+".bak", fileName)
        os.remove(fileName+".bak")
    else:
        #defaultのhcmw_part_ctrl.datをコピーする
        copyFile = os.getenv("easyIstrUserPath") + os.path.normpath(os.sep + "data" + os.sep + "hecmw_part_ctrl.dat")
        f=open(copyFile, encoding="utf-8"); lines= f.readlines(); f.close()
        w=open(fileName, "w", encoding="utf-8")
        for line in lines:
            w.write(line)
        w.close()

#
#  setHecmwContFromDat
#    hecmw_part_ctrl.datファイルの内容をセット
def setHecmwContFromDat(para, nCpu):
    fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
    #if len(glob.glob(fileName)) == 0:
    if os.path.exists(fileName) == False:
        #shutil.copy(currDir + os.sep + "hecmw_part_ctrl.dat", currDir)
        source = os.getenv("easyIstrUserPath") + os.sep + "data" + os.sep + "hecmw_part_ctrl.dat"
        shutil.copy(source, currDir)
    #hecmw_part_ctrl.datを書き換え
    f=open(fileName, encoding="utf-8"); lines=f.readlines(); f.close()
    i = pyFistr.getNextHeaderName(lines, 0, "!PARTITION", "")
    #nCpu書き換え
    lines[i] = abaqus2fistr.setValName(lines[i], "DOMAIN="+nCpu)
    #set341elmの設定（書き換え）
    lines[i] = set341elm_hecmwPartCtrl(lines[i])
    #書き込み
    f=open(fileName, "w", encoding="utf-8")
    for line in lines:
        f.write(line)
    f.close()

#
#  set341elm_hecmwPartCtrl
def set341elm_hecmwPartCtrl(chLine):
    """ hecmw_part_ctrl.datファイルを修正する"""
    cntLines = pyFistr.readFistrModelCnt()
    flag = False
    for line in cntLines:
        if line[:len("!SECTION")] == "!SECTION":
            words = pyFistr.deleteSp(line).split(",")
            if words[0] == "!SECTION":
                name = pyFistr.getValName(line, "FORM341")
                if name == "SELECTIVE_ESNS":
                    flag = True
                    break
    if flag == True:
        #DEPTH=2を追加
        chLine = abaqus2fistr.setValName(chLine, "DEPTH=2")
    else:
        #DEPTH=1（defaultの設定）
        chLine = abaqus2fistr.setValName(chLine, "DEPTH=1")
    return chLine

#
#  getHecmwContFromDat
#    hecmwの内容を取得
def getHecmwContFromDat():
    fileName = currDir + os.sep + "hecmw_part_ctrl.dat"
    #if len(glob.glob(fileName)) == 0:
    if os.path.exists(fileName) == False:
        #シングルコア
        parallel = False
        nCpu = "1"
    else:
        parallel = True
        f=open(fileName, encoding="utf-8"); lines=f.readlines(); f.close()
        i = pyFistr.getNextHeaderName(lines, 0, "!PARTITION", "")
        nCpu = abaqus2fistr.getValName(lines[i], "DOMAIN")
    return [parallel, nCpu]

#
#  setDynamicContInCnt
#    dynamicSolutionの内容を設定
def setDynamicContInCnt(values):

    #eigenLogの個数を読み込み
    def getEigenNumber(fileName):
        f=open(fileName, encoding="utf-8"); lines=f.readlines(); f.close()
        st = "1"
        ed = "4"
        flag = 0
        i = 0
        while i < len(lines):
            words = lines[i].split()
            if len(words) > 2:
                if words[0] == "---":
                    i += 1
                    st = lines[i].split()[0]
                    flag = 1
                if flag == 1:
                    ed = lines[i].split()[0]
            i += 1
        return [st, ed]                    

    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!DYNAMIC", "")
    lines[i] = abaqus2fistr.setValName(lines[i], "TYPE="+values[0])
    #data部を削除
    i += 1
    ip = i
    while i < len(lines):
        if lines[i][0] == "!" or lines[i][0] == "#":
            break
        i += 1
    lines = lines[:ip] + lines[i:]
    #data部を追加
    data = values[1]
    addLines =  [", ".join(data[:2]) + ls]
    addLines += [", ".join(data[2:6]) + ls]
    addLines += [", ".join(data[6:8]) + ls]
    addLines += [", ".join(data[8:12]) + ls]
    addLines += [", ".join(data[12:15]) + ls]
    addLines += [", ".join(data[15:21]) + ls]
    lines = lines[:ip] + addLines + lines[ip:]
    #restartを修正
    i = pyFistr.getNextHeaderName(lines, 0, "!RESTART", "")
    if i >= len(lines):
        i = pyFistr.getInsertPointInCnt(lines, "!RESTART", ["SOLVER", "Solver"])
        lines = lines[:i] + ["!RESTART" + ls] + lines[i:]
    lines[i] = abaqus2fistr.setValName(lines[i], "FREQUENCY="+values[2])
    #!EIGENREADのチェック修正
    if anaType == "DYNAMIC_F":
        currDir = getCurrDirFromTempFolder()
        fileName = currDir + os.sep + "eigen_log"
        i = pyFistr.getInsertPointInCnt(lines, "!EIGENREAD", [])
        #[st, ed] = getEigenNumber("eigen_log")
        [st, ed] = getEigenNumber(fileName)
        lines[i+2] = st + ", " + ed + ls
    writeFistrModelCnt(lines)

#
#  setRestartInCnt
#    restartの設定
def setRestartInCnt(restart):
    headerName = pyFistr.getHeaderName(FistrModel_msh)
    #hecmw_cnt.datファイルをチェック
    addLines = []
    lines = readHecmwCtrlDat()
    i = pyFistr.getNextHeaderName(lines, 0, "!RESTART", "IO=OUT")
    if i >= len(lines):
        i = pyFistr.getInsertPointInCnt(lines, "!RESTART", ["NAME=fstrRES", "CONTROL"])
        addLines =  ["!RESTART, NAME=restart-out, IO=OUT" + ls]
        #addLines += ["FistrModel.restart" + ls]
        addLines += [headerName + ".restart" + ls]
        lines = lines[:i] + addLines + lines[i:]
    i = pyFistr.getNextHeaderName(lines, 0, "!RESTART", "IO=IN")
    if i >= len(lines):
        i = pyFistr.getInsertPointInCnt(lines, "!RESTART", ["NAME=fstrRES", "CONTROL"])
        addLines =  ["!RESTART, NAME=restart-in, IO=IN" + ls]
        #addLines += ["FistrModel.restart" + ls]
        addLines += [headerName + ".restart" + ls]
        lines = lines[:i] + addLines + lines[i:]
    if len(addLines) > 0:
        writeHecmwCtrlDat(lines)
    #cntファイルを修正
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!RESTART", "")
    freq = "1"
    if i < len(lines):
        freq = abaqus2fistr.getValName(lines[i], "FREQUENCY")
        if freq == "":
            freq = "1"
        if restart == True:
            newFreq = deleteSp(str(abs(int(freq)) * (-1)))
        else:
            newFreq = deleteSp(str(abs(int(freq))))
        lines[i] = abaqus2fistr.setValName(lines[i], "FREQUENCY="+newFreq)
    else:
        if restart == True:
            i = pyFistr.getInsertPointInCnt(lines, "!RESTART", ["!SOLVER", "SOLVER"])
            addLines = ["!RESTART, FREQUENCY=-1" + ls]
            lines = lines[:i] + addLines + lines[i:]
        else:
            i = pyFistr.getInsertPointInCnt(lines, "!RESTART", ["!SOLVER", "SOLVER"])
            addLines = ["!RESTART, FREQUENCY=1" + ls]
            lines = lines[:i] + addLines + lines[i:]
    writeFistrModelCnt(lines)

#
#  setOutputLogInCnt
#    logの出力設定
def setOutputLogInCnt(iterLog, timeLog, freq):
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!SOLVER", "")
    if iterLog == "YES":
        lines[i] = abaqus2fistr.setValName(lines[i], "ITERLOG=YES")
    else:
        lines[i] = abaqus2fistr.setValName(lines[i], "ITERLOG=NO")
    if timeLog == "YES":
        lines[i] = abaqus2fistr.setValName(lines[i], "TIMELOG=YES")
    else:
        lines[i] = abaqus2fistr.setValName(lines[i], "TIMELOG=NO")
    i = pyFistr.getNextHeaderName(lines, 0, "!WRITE", "")
    lines[i] = abaqus2fistr.setValName(lines[i], "FREQUENCY="+freq)
    i = pyFistr.getNextHeaderName(lines, i+1, "!WRITE", "")
    lines[i] = abaqus2fistr.setValName(lines[i], "FREQUENCY="+freq)
    writeFistrModelCnt(lines)

#
#  setAmpDataInMsh
#    ampDataを追加
def setAmpDataInMsh(meshHeaderData, ampName, valType, ampData):
    flag = 0
    for i in range(len(meshHeaderData)):
        line = meshHeaderData[i][0]
        if line[:len("!AMPLITUDE")] == "!AMPLITUDE":
            name = pyFistr.getValName(line, "NAME")
            if name == ampName:
                header = abaqus2fistr.setValName(line, "VALUE="+valType)
                headerData = [header, ampData]
                meshHeaderData[i] = headerData
                flag = 1
                break
    if flag == 0:
        header = "!AMPLITUDE, VALUE="+valType + ", NAME=" + ampName + ls
        headerData = [header, ampData]
        meshHeaderData = meshHeaderData[:-1] + [headerData] + meshHeaderData[-1:]
    return meshHeaderData

#
#  getAmpDataInFile
#    ampDataをcsvファイルから取得
def getAmpDataInFile(fileName):
    ampData = []
    contList = pyFistr.readCsvData(fileName)
    if contList[0][0] == "ampData":
        #旧形式でA列削除の場合（Excelで読み込み）
        si = 0
    else:
        #設定したcsv形式そのまま
        si = 1
    for row in contList[2:]:
        time = row[si]
        value = row[si+1]
        data = time + value
        if data != "":
            #timeとvalueを入れ替える
            ampData += [", ".join([value, time]) + ls]
    return ampData

#
#  getPlasticSsData
#    csvデータを取得する
def getPlasticSsData(fileName):
    ssData = ""
    #if len(glob.glob(fileName)) == 0:
    if os.path.exists(fileName) == False:
        return ssData
    contList = pyFistr.readCsvData(fileName)
    st = 1
    for row in contList[2:]:
        data = row[st] + row[st+1]
        if data != "":
            #strain, stressを入れ替える
            ssData += ", ".join([row[st+1], row[st]]) + ls
    return ssData

#
#  getPlasticSsFaiData
#
def getPlasticSsFaiData(fileName):
    """ FAI形式のcsvデータを取得する"""
    ssData = ""
    #if len(glob.glob(fileName)) == 0:
    if os.path.exists(fileName) == False:
        return ssData
    contList = pyFistr.readCsvData(fileName)
    st = 1
    ssData = contList[2][1] + ls    #第1行（FAI)
    for row in contList[3:]:        #第2行以降（value, stress)
        data = row[st] + row[st+1]
        if data != "":
            #value, stressを入れ替えない
            ssData += ", ".join([row[st], row[st+1]]) + ls
    return ssData

#
#  createAmpDataFile
#    ampDataのcsvファイルを作成
def createAmpDataFile(ampName, fileName):
    #mshファイルからampDataを取得
    dataLines = []
    flag = 0
    for headerData in meshHeaderData:
        line = headerData[0]
        if line[:len("!AMPLITUDE")] == "!AMPLITUDE":
            name = pyFistr.getValName(line, "NAME")
            if name == ampName:
                #dataLines = headerData[1]
                flag = 1
                break
    if flag == 1:
        #実フォルダ内のampDataを読み込む
        currDir = getCurrDirFromTempFolder()
        os.chdir(currDir)
        lines = pyFistr.readFistrModelMsh()
        os.chdir(currDirTemp)
        #meshのheaderData（テキスト）を作成
        mshData = pyFistr.getHeaderData(lines)
        for header, data in mshData:
            if header[:len("!AMPLITUDE")] == "!AMPLITUDE":
                name = pyFistr.getValName(header, "NAME")
                if name == ampName:
                    #ampDataを取得
                    dataLines = data
                    break
    #ampDataからcsvファイル作成
    dim, _matFile = getDimensionMatFileFromIstrData()
    rows = []
    #rows += [["fistr", "ampData", ""]]
    rows += [[dim, "ampData", ""]]
    rows += [["", "time", "value"]]
    f = open(fileName, "w", encoding="utf-8")
    for row in rows:
        line = ",".join(row) + ls
        f.write(line)
    for dataLine in dataLines:
        words = deleteSp(dataLine).split(",")
        line = "," + words[1] + "," + words[0] + ls
        f.write(line)
    f.close()

#
#  createPlasticSsDataFile
#    csvファイルを作成
def createPlasticSsDataFile(fileName, matName, mats):
    """ 非線形材料のdataを作成する
    cntFileのにdataがあれば、無条件にcsvを作り直す。
    cntFileにdata無し、csvファイル有りは、csvを開く。
    cntFileにdata無し、csvファイル無しは、空のcsvを作成し、開く"""

    def createFile(dim, Pa, data, fileName):
        rows = []
        rows += [[dim, "SS_curve", Pa]]
        rows += [["", "value", "stress"]]
        rows += data
        #data保存（file作成）
        f=open(fileName, "w", encoding="utf-8")
        for row in rows:
            line = ",".join(row) + ls
            f.write(line)
        f.close()

    dim, matFile = getDimensionMatFileFromIstrData()
    unitDict = convDimensionMatCsv.createUnitDict(dim)
    Pa = unitDict["press"]
    #cnt内のdataを読み取る（dataない場合空白[]が戻る）
    data = getNonlinearMaterialDataInCnt(matName, mats)
    if len(data) == 0:
        #cnt内にdata無し
        if os.path.exists(fileName) == False:
            #csvファイル無し
            #data作成
            createFile(dim, Pa, data, fileName)
    else:
        #cnt内にdataあり
        #csvファイル作成
        createFile(dim, Pa, data, fileName)

#
#  createPlasticSsDataFaiFile
def createPlasticSsDataFaiFile(fileName, matName, mats):
    """ FAI用のcsvファイルを作成
    cntFileのにdataがあれば、無条件にcsvを作り直す。
    cntFileにdata無し、csvファイル有りは、csvを開く。
    cntFileにdata無し、csvファイル無しは、空のcsvを作成し、開く"""

    def createFile(dim, Pa, faiVals, data1, fileName):
        fai, val00, val01 = faiVals
        #data作成
        rows = []
        rows += [[dim, "SV_curveFAI", Pa]]
        rows += [["", "value", "viscosity"]]
        rows += [["onlyFAI", fai, ""]]
        rows += [["valueAndViscosity", val00, val01]]
        rows += data1
        #data保存（file作成）
        f=open(fileName, "w", encoding="utf-8")
        for row in rows:
            line = ",".join(row) + ls
            f.write(line)
        f.close()

    dim, matFile = getDimensionMatFileFromIstrData()
    unitDict = convDimensionMatCsv.createUnitDict(dim)
    Pa = unitDict["press"]
    #cnt内のdataを読み取る（dataない場合空白[]が戻る）
    data = getNonlinearMaterialDataInCnt(matName, mats)
    if len(data) == 0:
        fai, val00, val01 = "", "", ""
        data1 = []
    else:
        fai = data[0][1]
        val00, val01 = data[1][1], data[1][2]
        data1 = data[2:]
    faiVals = [fai, val00, val01]
    if len(data1) == 0:
        #cnt内にdata無し
        if os.path.exists(fileName) == False:
            #csvファイル無し
            #data作成
            createFile(dim, Pa, faiVals, data1, fileName)
    else:
        #cnt内にdataあり
        #csvファイル作成
        createFile(dim, Pa, faiVals, data1, fileName)

#
#  getSolutionTypeFromCnt
#    solutionTypeを取得
def getSolutitionTypeFromCnt():
    #values = []
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!SOLUTION", "")
    if i >= len(lines):
        #デフォルト値を設定
        solType = "STATIC"
    else:
        solType = abaqus2fistr.getValName(lines[i], "TYPE")
        solType = solType.upper()       #大文字に変換
    if solType == "DYNAMIC":
        i = pyFistr.getNextHeaderName(lines, 0, "!DYNAMIC", "")
        i += 1
        if i < len(lines):
            words = deleteSp(lines[i]).split(",")
            if len(words) >= 2:
                if words[1] == "2":
                    solType = "DYNAMIC_F"
    elif solType == "HEAT":
        i = pyFistr.getNextHeaderName(lines, 0, "!HEAT", "")
        i += 1
        if i < len(lines):
            words = deleteSp(lines[i]).split(",")
            try:
                dt = float(words[0])
            except:
                dt = 0.0
            if dt > 0.0:
                solType = "HEAT_D"
    return solType

#
#  getFrequencyReactFromCnt
#    周波数応答解析かどうかをチェック
def getFrequencyReactFromCnt():
    ans = False
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!SOLUTION", "TYPE=DYNAMIC")
    if i < len(lines):
        i = pyFistr.getNextHeaderName(lines, 0, "!DYNAMIC", "")
        i += 1
        if i < len(lines):
            words = deleteSp(lines[i]).split(",")
            if len(words) >= 2:
                if words[1] == "2":
                    ans = True
    return ans

#
#  getHeatDinaContFromCnt
#    熱伝導動解析に関するdataをcntファイルから取得
def getHeatDinaContFromCnt():
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!HEAT", "")
    i += 1
    values = deleteSp(lines[i]).split(",")
    n = len(values)
    while n < 6:
        values.append("")
        n += 1
    return values

#
#  getEigenContFromCnt
#    固有値解析に関するdataをcntファイルから取得
def getEigenContFromCnt():
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!EIGEN", "")
    i += 1
    [values, i] = pyFistr.getOnlyDataInLines(lines, i)
    return values

#
#  getDynamicContFromCnt
#    動解析に関するdataをcntファイルから取得
def getDynamicContFromCnt():
    
    def checkDataOfNumber(vals, n):
        words = vals[:n]
        if len(words) != n:
            words += [""] * (n - len(words))
        return words

    values = []
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!DYNAMIC", "")
    dynType = abaqus2fistr.getValName(lines[i], "TYPE")
    values.append(dynType)
    i += 1
    data = []
    while i < len(lines):
        if lines[i][0] == "!":
            break
        else:
            if lines[i][0] != "#":
                line = deleteSp(lines[i])
                words = line.split(",")
                #data += words
                data.append(words)
        i += 1
    #dataのチェック
    data[0] = checkDataOfNumber(data[0], 2)
    data[1] = checkDataOfNumber(data[1], 4)
    data[2] = checkDataOfNumber(data[2], 2)
    data[3] = checkDataOfNumber(data[3], 4)
    data[4] = checkDataOfNumber(data[4], 3)
    data[5] = checkDataOfNumber(data[5], 6)
    #data作成
    newData = []
    for words in data:
        newData += words
    #values += [data]
    values += [newData]
    i = pyFistr.getNextHeaderName(lines, 0, "!RESTART", "")
    if i >= len(lines):
        resFreq = "1"
    else:
        resFreq = abaqus2fistr.getValName(lines[i], "FREQUENCY")
        if resFreq == "":
            resFreq = "1"
    values += [resFreq]
    return values

#
#  getSolverContFromCnt
#    solverに関するdataをcntファイルから取得
def getSolverContFromCnt():
    #values = []
    lines = readFistrModelCnt()
    i = pyFistr.getNextHeaderName(lines, 0, "!SOLVER", "")
    method = abaqus2fistr.getValName(lines[i], "METHOD")
    precond = abaqus2fistr.getValName(lines[i], "PRECOND")
    iterLog = abaqus2fistr.getValName(lines[i], "ITERLOG")
    timeLog = abaqus2fistr.getValName(lines[i], "TIMELOG")
    i += 1
    if lines[i][0] == "!":
        nIter = ""
        resid = ""
    else:
        nIter = deleteSp(lines[i]).split(",")[0]
        i += 1
        if lines[i] == "!":
            resid = ""
        else:
            resid = deleteSp(lines[i]).split(",")[0]
    #出力間隔を取得
    freq = "1"
    i = pyFistr.getNextHeaderName(lines, 0, "!WRITE", "")
    val = abaqus2fistr.getValName(lines[i], "FREQUENCY")
    if val != "":
        freq = val
    #restartを取得
    i = pyFistr.getNextHeaderName(lines, 0, "!RESTART", "")
    if i < len(lines):
        restartFreq = abaqus2fistr.getValName(lines[i], "FREQUENCY")
    else:
        restartFreq = "1"
    if restartFreq == "":
        restartFreq = "1"
    return [method, precond, nIter, resid, iterLog, timeLog, freq, restartFreq]

#
#  getOutputContFromCnt
#    outputに関するdataをcntファイルから取得
def getOutputContFromCnt():
    lines = readFistrModelCnt()
    #outputItemsを取得
    allItems = outputItems()
    selItems = []
    
    i = pyFistr.getNextHeaderName(lines, 0, "!OUTPUT_RES", "")
    i += 1
    while i < len(lines):
        line = lines[i]
        if line[0] == "!" or line[0] == "#":
            break
        words = deleteSp(line).split(",")
        if len(words) == 2:
            if words[1] == "ON":
                selItems.append(words[0])
        i += 1
    if len(selItems) == 0:
        selItems = iniOutputItems()
        selItems.sort()
    else:
        selItems = makeLongOutputName(selItems)
    noItems = pyFistr.getNoGroups(allItems, selItems)
    noItems.sort()
    return [noItems, selItems]

#
#  makeLongOutputName
#    outputNameに説明追加
def makeLongOutputName(names):
    newNames = []
    allNames = outputItems()
    for name in names:
        for longName in allNames:
            if name == longName.split(":")[1]:
                newNames.append(longName)
                break
    return newNames

#
#  searchSetBndInLines
#    bndSetをcntファイルから探す
def searchSetBndInLines(lines, setBnd):
    [bnd, setName, stepName] = setBnd.split(",")
    #nStepを求める
    nStep = 0
    for n in range(len(stepDefine)):
        if stepDefine[n] == stepName:
            nStep = n
            break

    #検索してセットする
    ip = -1
    if bnd == "GRAV" or bnd == "CENT":
        i = skipStepId(lines, nStep)
        while i < len(lines):
            if lines[i][:len("!DLOAD")] == "!DLOAD":
                words = deleteSp(lines[i+1]).split(",")
                if words[1] == bnd and words[0] == setName:
                    ip = i
                    break
            i += 1
    elif bnd == "VLOAD":
        i = skipStepId(lines, nStep)
        while i < len(lines):
            if lines[i][:len("!DLOAD")] == "!DLOAD":
                words = deleteSp(lines[i+1]).split(",")
                if words[1][0] == "B" and words[0] == setName:
                    ip = i
                    break
            i += 1
    elif bnd == "DLOAD":
        i = skipStepId(lines, nStep)
        while i < len(lines):
            if lines[i][:len("!DLOAD")] == "!DLOAD":
                words = deleteSp(lines[i+1]).split(",")
                if words[1] == "S" and words[0] == setName:
                    ip = i
                    break
            i += 1
    elif bnd == "STEP":
        i = skipStepId(lines, nStep)
        ip = pyFistr.getNextHeaderName(lines, i, "!STEP", "")
    else:
        i = skipStepId(lines, nStep)
        while i < len(lines):
            if lines[i][:len("!"+bnd)] == "!"+bnd:
                words = deleteSp(lines[i+1]).split(",")
                if words[0] == setName:
                    ip = i
                    break
            i += 1
    return ip

#
#  getStepListFromCnt
#    AMPLITUDEのために、!STEPがあれば、そのlistを返す
def getStepListFromCnt():
    lines = readFistrModelCnt()
    bndLines = []
    i = pyFistr.getNextHeaderName(lines, 0, "!STEP", "")
    while i < len(lines):
        if i < len(lines):
            stepName = abaqus2fistr.getValName(lines[i], "stepName")
            if stepName == "":
                stepName = "STEP0"
            ans = ["STEP", "SUBSTEPS", "STEP", stepName]
            bndLines.append(ans)
        i += 1
        i = pyFistr.getNextHeaderName(lines, i, "!STEP", "")
    return bndLines

#
#  getStepBndListFromDefineData
#    stepName部分のbndListを作成する
def getStepBndListFromDefineData(stepName):
    #step名からstepNoを取得
    n = 0; nStep = 0
    for name in stepDefine:
        if name == stepName:
            nStep = n
            break
        n += 1
    #境界条件を取得
    bndList = []
    lines = readFistrModelCnt()
    #stepNameまでの境界条件Listを取得
    n = 0
    while n <= nStep:
        bList = getBndListFromDefine(lines, n)
        bndList += bList
        n += 1
    #同じ内容を削除
    bndList.sort()
    newList = [bndList[0]]
    for i in range(1, len(bndList)):
        if newList[-1] != bndList[i]:
            newList.append(bndList[i])
    return bndList

#
#  getAllStepBndListFromDefineData
#    全てのBndListを作成する
def getAllStepBndListFromDefineData():
    if len(stepDefine) > 0:
        stepName = stepDefine[-1]
        bndList = getStepBndListFromDefineData(stepName)
    else:
        lines = readFistrModelCnt()
        bndList = getBndListFromDefine(lines, 0)
    return bndList        

#
#  getBndListFromDefine
#    nStep目までの境界条件Listを取得
def getBndListFromDefine(lines, nStep):
    bndList = []
    if len(stepDefine) == 0:
        stepName = ""
    else:
        stepName = stepDefine[nStep]
    #BOUNDARY
    for name in bndDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!BOUNDARY", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["BOUNDARY", name, "BOUNDARY", grpId, stp])
    #CLOAD
    for name in cloadDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!CLOAD", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["CLOAD", name, "LOAD", grpId, stp])
    #DLOAD(S)
    for name in dloadDefine[nStep]:
        bList = getDloadBoundaryIdStpName("DLOAD", lines, "S", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["DLOAD", name, "LOAD", grpId, stp])
    #DLOAD(BX)
    for name in vloadDefine[nStep]:
        bList = getDloadBoundaryIdStpName("DLOAD", lines, "BX", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["VLOAD", name, "LOAD", grpId, stp])
    #DLOAD(GRAV)
    for name in gravDefine[nStep]:
        bList = getDloadBoundaryIdStpName("DLOAD", lines, "GRAV", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["GRAV", name, "LOAD", grpId, stp])
    #DLOAD(CENT)
    for name in centDefine[nStep]:
        bList = getDloadBoundaryIdStpName("DLOAD", lines, "CENT", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["CENT", name, "LOAD", grpId, stp])
    #TEMPERATURE
    for name in tempDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!TEMPERATURE", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["TEMPERATURE", name, "LOAD", grpId, stp])
    # #REFTEMP
    # for name in reftempDefine[nStep]:
    #     bList = getReftempIdStpName(lines, "!REFTEMP", name, stepName)
    #     for [grpId, stp] in bList:
    #         bndList.append(["REFTEMP", name, "REFTEMP", grpId, stp])
    #SPRING
    for name in springDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!SPRING", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["SPRING", name, "SPRING", grpId, stp])
    #CONTACT
    for name in contactDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!CONTACT", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["CONTACT", name, "CONTACT", grpId, stp])
    #FLOAD
    for name in floadDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!FLOAD", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["FLOAD", name, "FLOAD", grpId, stp])
    #VELOCITY
    for name in veloDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!VELOCITY", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["VELOCITY", name, "VELOCITY", grpId, stp])
    #ACCELERATION
    for name in accelDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!ACCELERATION", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["ACCELERATION", name, "ACCELERATION", grpId, stp])
    #FIXTEMP
    for name in fixtempDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!FIXTEMP", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["FIXTEMP", name, "FIXTEMP", grpId, stp])
    #CFLUX
    for name in cfluxDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!CFLUX", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["CFLUX", name, "CFLUX", grpId, stp])
    #SFLUX
    for name in sfluxDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!SFLUX", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["SFLUX", name, "SFLUX", grpId, stp])
    #DFLUX(DFLUX)
    for name in dfluxDefine[nStep]:
        bList = getDfluxBoundaryIdStpName("!DFLUX", lines, "S", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["DFLUX", name, "DFLUX", grpId, stp])
    #DFLUX(BF)
    for name in bfDefine[nStep]:
        bList = getDfluxBoundaryIdStpName("!DFLUX", lines, "BF", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["BF",name, "DFLUX", grpId, stp])
    #SFILM
    for name in sfilmDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!SFILM", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["SFILM", name, "SFILM", grpId, stp])
    #SRADIATE
    for name in sradiateDefine[nStep]:
        bList = getBoundaryIdStpName(lines, "!SRADIATE", name, stepName)
        for [grpId, stp] in bList:
            bndList.append(["SRADIATE", name, "SRADIATE", grpId, stp])
    return bndList

#  getBoundaryIdStpName
def getBoundaryIdStpName(lines, bndName, name, stepName):
    grpId = ""
    i = 0
    nStep = 0
    bList = []
    while i < len(lines):
        line = lines[i]
        if line[:len(bndName)] == bndName:
            if deleteSp(lines[i+1]).split(",")[0] == name:
                grpId = abaqus2fistr.getValName(line, "GRPID")
                if len(stepDefine) == 0:
                    step = "STEP0"
                else:
                    step = stepDefine[nStep]
                bList.append([grpId, step])
        elif line[:len("!STEP")] == "!STEP":
            nStep += 1
            if abaqus2fistr.getValName(line, "stepName") == stepName:
                break
        i += 1
    return bList

#
#  getReftempIdStpName
#----------------------
def getReftempIdStpName(lines, bndName, name, stepName):
    """ REFTEMPを取得"""
    grpId = ""
    i = 0
    nStep = 0
    bList = []
    while i < len(lines):
        line = lines[i]
        if line[:len(bndName)] == bndName:
            grpId = abaqus2fistr.getValName(line, "GRPID")
            if len(stepDefine) == 0:
                step = "STEP0"
            else:
                step = stepDefine[nStep]
            bList.append([grpId, step])
        elif line[:len("!STEP")] == "!STEP":
            nStep += 1
            if abaqus2fistr.getValName(line, "stepName") == stepName:
                break
        i += 1
    return bList

#  getDloadBoundaryIdStpName
def getDloadBoundaryIdStpName(bnd, lines, bndName, name, stepName):
    grpId = ""
    i = 0
    nStep = 0
    bList = []
    while i < len(lines):
        line = lines[i]
        if line[:len(bnd)+1] == "!"+bnd:
            words = deleteSp(lines[i+1]).split(",")
            if words[0] == name:            #追加23/03/30
                if words[1] == bndName:
                    grpId = abaqus2fistr.getValName(line, "GRPID")
                    if len(stepDefine) == 0:
                        step = "STEP0"
                    else:
                        step = stepDefine[nStep]
                    bList.append([grpId, step])
        elif line[:len("!STEP")] == "!STEP":
            nStep += 1
            if abaqus2fistr.getValName(line, "stepName") == stepName:
                break
        i += 1
    return bList

#
#  getDfluxBoundaryIdStpName
def getDfluxBoundaryIdStpName(bnd, lines, bndName, name, stepName):
    """ bndListを取得する"""
    grpId = ""
    i = 0
    nStep = 0
    bList = []
    while i < len(lines):
        line = lines[i]
        if line[:len(bnd)] == bnd:
            words = deleteSp(lines[i+1]).split(",")
            if words[0] == name:
                if words[1][:len(bndName)] == bndName:
                    grpId = pyFistr.getValName(line, "GRPID")
                    if len(stepDefine) == 0:
                        step = "STEP0"
                    else:
                        step = setepDefine[nStep]
                    bList.append([grpId, step])
        elif line[:len("!STEP")] == "!STEP":
            nStep += 1
            if pyFistr.getValName(line, "stepName") == stepName:
                break
        i += 1
    return bList

#
#  reformStepBCCont
#    STEP解析に使用する境界条件を成形する
def reformStepBCCont(bnds, bndList):
    ans = []
    for bnd in bnds:
        bnd = deleteSp(bnd)
        for blist in bndList:
            if bnd == ",".join(blist[2:4]):
                newList = blist[:2] + [blist[-1]]
                ans.append(",".join(newList))
                #break
    return ans

#
#  reconstructStepBCCont
#    STEP解析に使用する境界条件を元に戻す
def reconstructStepBCCont(bnds, bndList):
    ans = []
    for bnd in bnds:
        bnd = deleteSp(bnd)
        for blist in bndList:
            newList = blist[:2] + [blist[-1]]
            bLine = ",".join(newList)
            if bnd == bLine:
                rLine = ", ".join(blist[2:4]) + ls
                ans.append(rLine)
                break
    return ans

#
#  convertDataForParaview46
#---------------------------
def convertDataForParaview46(values):
    """ Fistr-4.6用の出力形式をlegacy formatのvtkに変換する。"""
    #fileHeaderの確認
    #meshFileHeader = FistrModel_msh.split(".")[0]
    meshFileHeader = pyFistr.getHeaderName(FistrModel_msh)
    nameDict = pyFistr.getCntMshFileNameDict(os.getcwd())
    resFileHeader = nameDict["res"].split(".")[0]
    #結果データの有無確認
    if len(glob.glob(currDir + os.sep + resFileHeader + ".res.1.*")) == 0:
        #シングル計算の場合 
        files = glob.glob(currDir + os.sep + resFileHeader + ".res.0*")
        if len(files) == 0:
            mess = _(u"計算結果が存在しません。")
            return mess
    else:
        #並列計算の場合
        files = glob.glob(currDir + os.sep + resFileHeader + ".res.merge*")
        if len(files) == 0:
            mess = _(u"計算結果が分散したままです。") + ls
            mess += _(u"rmergeで計算結果を結合して、FistrModel.res.merge.*ファイルを作成してください。")
            return mess
    #メッシュ変換
    os.chdir(currDir)
    #  並列を確認
    para, nCpu = values
    if para == True:
        addPara = " -para yes -np " + nCpu
    else:
        addPara = " -para no"
    pyFistr.removes("conv"+resFileHeader+".res.*.vtk")
    comm = "python3 -u " + binAppPath + "fistr2vtk.py -mesh " + meshFileHeader + " -res " + resFileHeader + addPara + ls
    resp = getFrequencyReactFromCnt()
    if resp == True:
        #周波数応答の場合、追加変換
        #resFileHeader = "FistrModel_dyna"
        resFileHeader += "_dyna"
        pyFistr.removes("conv"+resFileHeader+".res.*.vtk")
        comm += "python3 -u " + binAppPath + "fistr2vtk.py -mesh " + meshFileHeader + " -res " + resFileHeader + addPara + ls
    title = "convData"
    if os.name=="nt":
        f=open("run.bat", "w"); f.write(comm); f.close()
        commSet = "python3 " + pythonAppPath + "runCommandWithDialog2.py " + title + " run"
    else:
        comm = "#!/bin/bash" + ls + comm
        runComm = "echo '" + comm + "' > run; chmod a+x run"
        pyFistr.run(currDir).command(runComm)
        commSet = "python3 " + pythonAppPath + "runCommandWithDialog2.py " + title + " ./run"
    pyFistr.run(currDir).commandBG(commSet)
    return ""

#
#  convertDataForParaview
#    データ変換
def convertDataForParaview(values):
    #fileHeaderの確認
    meshFileHeader = FistrModel_msh.split(".")[0]
    nameDict = pyFistr.getCntMshFileNameDict(currDir)
    resFileHeader = nameDict["res"].split(".")[0]
    #visFileHeader = nameDict["vis"].split(".")[0]
    visFileHeader = nameDict["vis"]
    #結果データの有無確認
    files = glob.glob(currDir + os.sep + resFileHeader + ".res.0*")
    if len(files) == 0:
        mess = _(u"計算結果が存在しません。")
        return mess
    parallel = values[0]
    #メッシュ変換
    addPara = " -para no"
    if parallel == True:
        nCpu = values[1]
        addPara = " -para yes -np " + nCpu
    os.chdir(currDir)
    comm = "python3 -u " + binAppPath + "fistr2vtu.py -mesh " + meshFileHeader + " -res " + resFileHeader
    comm += " -vis " + visFileHeader + addPara + ls
    resp = getFrequencyReactFromCnt()
    title = "convData"
    if os.name=="nt":
        f=open("run.bat", "w"); f.write(comm); f.close()
        commSet = "python3 " + pythonAppPath + "runCommandWithDialog2.py " + title + " run.bat"
    else:
        comm = "#!/bin/bash" + ls + comm
        runComm = "echo '" + comm + "' > run; chmod a+x run"
        pyFistr.run(currDir).command(runComm)
        commSet = "python3 " + pythonAppPath + "runCommandWithDialog2.py " + title + " ./run"
    pyFistr.run(currDir).commandBG(commSet)
    return u""

#
#  deleteStepContInCnt
#    STEPを削除
def deleteStepContInCnt():
    lines = readFistrModelCnt()
    lines = deleteStepCont(lines)
    writeFistrModelCnt(lines)

#
#  deleteGravContInCnt
#    GRAVを削除
def deleteGravContInCnt():
    lines = readFistrModelCnt()
    lines = deleteGravCont(lines)
    writeFistrModelCnt(lines)

#
#  deleteGravCont
#
def deleteGravCont(lines):
    newLines = []
    i = 0
    while i < len(lines):
        grpTypes = pyFistr.getNextDloadGrpType(lines, i)
        if len(grpTypes) > 0:
            if len(grpTypes) == 1:
                (grp, bndType, dummy_line, i) = grpTypes[0][:4]
                if grp == "ALL" and bndType == "GRAV":
                    newLines = lines[:i-1] + lines[i+1:]
                    break
                else:
                    i += 1
            else:
                i += 1
        else:
            break
    if len(newLines) > 0:
        #GRPIDを修正
        newLines = pyFistr.remakeGRPID(newLines, "!DLOAD")
    else:
        newLines = lines
    return newLines

#
#  matchControlCont
#    cntFileの内容をmeshに合わせる
def matchControlCont():
    lines = readFistrModelCnt()
    lines = deleteDloadWithoutNames(lines, meshGroup[1], -1)
    lines = deleteCloadWithoutNames(lines, meshGroup[2], -1)
    lines = deleteBoundaryWithoutNames(lines, meshGroup[2], -1)
    lines = deleteVloadWithoutNames(lines, meshGroup[0], -1)
    #lines = deleteGravWithoutNames(lines, meshGroup[0]+["ALL"], -1)
    lines = deleteGravWithoutNames(lines, meshGroup[0], -1)
    lines = deleteCentWithoutNames(lines, meshGroup[0], -1)
    #lines = deleteTemperatureWithoutNames(lines, meshGroup[2]+["ALL"], -1)
    lines = deleteTemperatureWithoutNames(lines, meshGroup[2], -1)
    lines = deleteSpringWithoutNames(lines, meshGroup[2], -1)
    lines = deleteFloadWithoutNames(lines, meshGroup[2], -1)
    #lines = deleteVeloWithoutNames(lines, meshGroup[2]+["ALL"], -1)
    lines = deleteVeloWithoutNames(lines, meshGroup[2], -1)
    #lines = deleteAccelWithoutNames(lines, meshGroup[2]+["ALL"], -1)
    lines = deleteAccelWithoutNames(lines, meshGroup[2], -1)
    lines = deleteFixtempWithoutNames(lines, meshGroup[2], -1)
    lines = deleteCfluxWithoutNames(lines, meshGroup[2], -1)
    lines = deleteSfluxWithoutNames(lines, meshGroup[1], -1)
    lines = deleteDfluxWithoutNames(lines, meshGroup[1], -1)
    lines = deleteBfWithoutNames(lines, meshGroup[0], -1)
    lines = deleteSfilmWithoutNames(lines, meshGroup[1], -1)
    lines = deleteSradiateWithoutNames(lines, meshGroup[1], -1)
    writeFistrModelCnt(lines)
    matNames = getMatNamesInCnt(lines)
    matNames += getMatNamesInMsh()
    matNames = list(set(matNames))
    flag = deleteMaterialInSectionWithoutNames(matNames)
    if flag == 1 and os.getcwd() == currDirTemp:
        writeFistrModelMshHeader()

#
#  deleteMaterialInSectionWithoutNames
#    m