#!/usr/bin/python3
#
#       vtk2vtu.py
#
#       vtkをvtuフォーマットに変換する
#
#   20/08/26    新規作成
#


import sys
import vtk

def help():
    cont  = "------------------- vtk2vtu.py --------------------------\n"
    cont += "vtkファイルをvtu形式に変換する。\n"
    cont += "\n"
    cont += "<使い方>\n"
    cont += "vtk2vtu.py <fileName>\n"
    cont += "  fileName:    変換するvtkファイル\n"
    cont += "\n"
    cont += "<使用例>\n"
    cont += "  vtk2vtu.py convFistrModel.vtk\n"
    cont += "    変換後fileName: convFistrModel_vtk.vtu\n"
    cont += "\n"
    print(cont)

if len(sys.argv) == 1:
    help()
    exit()
#入力file名を取得
fileName = sys.argv[1]
if fileName[0] == "-":
    help()
    exit()
#vtkを読み込む
print("reading " + fileName + "...")
reader = vtk.vtkUnstructuredGridReader()
reader.SetFileName(fileName)
reader.Update()
data = reader.GetOutput() 
#vtuのファイル名を設定
outName = ".".join(fileName.split(".")[:-1]) + "_vtk.vtu"
#vtuを書き込む
print("writing " + outName + "...")
writer = vtk.vtkXMLUnstructuredGridWriter()
writer.SetFileName(outName)
writer.SetInputData(data)
writer.Write()
print("has been converted to vtu.")
print("  convering file: " + outName)


