#!/usr/bin/python3  
# -*- coding: utf-8 -*-    
#
#       addTrueForceInCntFile.py
#
#           等分布荷重,mapping,otherDataをcntファイルに追加する。
#           対象は、currDir内の「FistrModel.cnt」ファイル
#
#   18/12/06    新規作成（easyIstr本体から外に出す）
#   19/01/07    python3用に書き換え
#      01/22    cfluxの等分布に対応。
#      04/20    vsCodeで修正。
#      05/04    addTrueForceInCntFile:モーメントが取得できていなかったので修正
#   22/03/15    国際化
#      04/12    log表示修正（import logFileCreaterを追加）
#      11/18    addTrueForceInCntFile:!DLOADにmappingを追加
#   23/04/17    readFistrModelMsh:mshFile名をhecmw_ctrl.datから取得する様に修正
#      04/19    addTrueForceInCntFile:!CLOAD, CFLUX, !TEMPERATUREでotherData=yes
#               の場合は、生dataを復活させる事を追加。
#      05/02    addTrueForceInCntFile:加算するmapShiftを追加。
#      11/18    addTrueForceInCntFile:!DLOADと!DFLUXについて、面番号に付加される
#               文字を各々"P", "S"に設定（バグ修正）
#   24/07/07    openにencoding="utf-8"を追加
#

import sys, os
import pyFistr
import getNodeForceAtArea

ls = "\n"

#
#  addTrueForceInCntFile
#    等分布荷重を設定
def addTrueForceInCntFile(lines):
    mappingCards = ("!DLOAD", "!DFLUX")
    mappingFaceChara = ("P", "S")
    otherDataCards = ("!CLOAD", "!CFLUX", "!TEMPERATURE")
    meshHeaderData = []
    headerConts = pyFistr.getHeaderData(lines)
    flag = 0
    for i in range(len(headerConts)):
        header = headerConts[i][0]
        words = pyFistr.deleteSp(header).split(",")
        
        #等分布荷重？
        if words[0].upper() == "!CLOAD":
            forceType = pyFistr.getValName(header, "forceType")
            if forceType == "trueForce":
                print ()
                print (_(u"等分布荷重をセットします"))
                #ngrpNameを取得
                line = headerConts[i][1][0]
                ngrpName = pyFistr.deleteSp(line).split(",")[0]
                if len(meshHeaderData) == 0:
                    #meshHeaderDataを取得
                    #mshLines = readFistrModelMsh()
                    #meshHeaderData = pyFistr.getHeaderNumData(mshLines)
                    meshHeaderData = pyFistr.getHeaderNumDataMsh(os.getcwd())
                #xyzForceを取得
                xyzForce = []
                for ii in range(len(words)):
                    word = words[ii]
                    if word[:len("value=")] == "value=":
                        #荷重を取得
                        xyzForce.append(word[len("value="):])
                        xyzForce.append(words[ii+1])
                        xyzForce.append(words[ii+2])
                        try:
                            float(words[ii+3])
                            #モーメントを取得
                            xyzForce.append(words[ii+3])
                            xyzForce.append(words[ii+4])
                            xyzForce.append(words[ii+5])
                        except:
                            pass
                        break
                #flagを設定
                flag = 1
                #node当たりの荷重を設定
                cloadCont = []
                [nodes, nodeForce] = getNodeForceAtArea.getNodeForceWOM(meshHeaderData, ngrpName)
                if len(nodes) != 0:
                    for ii in range(len(nodes)):
                        nodeNo = str(nodes[ii])
                        xForce = str(float(xyzForce[0]) * nodeForce[ii])
                        yForce = str(float(xyzForce[1]) * nodeForce[ii])
                        zForce = str(float(xyzForce[2]) * nodeForce[ii])
                        cloadCont.append(nodeNo + ", 1, " + xForce + ls)
                        cloadCont.append(nodeNo + ", 2, " + yForce + ls)
                        cloadCont.append(nodeNo + ", 3, " + zForce + ls)
                        if len(xyzForce) > 3:
                            MxForce = str(float(xyzForce[3]) * nodeForce[ii])
                            MyForce = str(float(xyzForce[4]) * nodeForce[ii])
                            MzForce = str(float(xyzForce[5]) * nodeForce[ii])
                            cloadCont.append(nodeNo + ", 4, " + MxForce + ls)
                            cloadCont.append(nodeNo + ", 5, " + MyForce + ls)
                            cloadCont.append(nodeNo + ", 6, " + MzForce + ls)
                    mess = _(u"節点数:") + str(len(nodes)) + _(u"  各節点に等分布荷重")
                    mess += _(u"をセットします")
                    print (mess)
                else:
                    mess = _(u"group内のnode数が取得できません") + ls
                    mess += _(u"meshFile内に指定したNGROUP名が存在しないか、")
                    mess += _(u"node数がセットされていません。") + ls
                    mess += _(u"入力値は、「節点当たりの荷重」としてセットします")
                    print (mess)
                #cloadContを加える
                headerConts[i][1] += cloadCont

        #等分布熱流束？
        elif words[0].upper() == "!CFLUX":
            qwType = pyFistr.getValName(header, "qwType")
            if qwType == "trueQw":
                print ()
                print (_(u"等分布熱量をセットします"))
                #ngrpNameを取得
                line = headerConts[i][1][0]
                ngrpName = pyFistr.deleteSp(line).split(",")[0]
                if len(meshHeaderData) == 0:
                    #meshHeaderDataを取得
                    #mshLines = readFistrModelMsh()
                    #meshHeaderData = pyFistr.getHeaderNumData(mshLines)
                    meshHeaderData = pyFistr.getHeaderNumDataMsh(os.getcwd())
                #qwValueを取得
                qwValue = ""
                for ii in range(len(words)):
                    word = words[ii]
                    if word[:len("value=")] == "value=":
                        qwValue = word[len("value="):]
                        break
                #flagを設定
                flag = 1
                #node当たりの熱量を設定
                cfluxCont = []
                [nodes, nodeForce] = getNodeForceAtArea.getNodeForceWOM(meshHeaderData, ngrpName)
                if len(nodes) != 0:
                    for ii in range(len(nodes)):
                        nodeNo = str(nodes[ii])
                        qw = str(float(qwValue) * nodeForce[ii])
                        cfluxCont.append(nodeNo + ", " + qw + ls)
                    mess = _(u"節点数:") + str(len(nodes)) + _(u"  各節点に等分布荷重")
                    mess += _(u"をセットします")
                    print (mess)
                else:
                    mess = _(u"group内のnode数が取得できません") + ls
                    mess += _(u"meshFile内に指定したNGROUP名が存在しないか、")
                    mess += _(u"node数がセットされていません。") + ls
                    mess += _(u"入力値は、「節点当たりの熱量」としてセットします")
                    print (mess)
                #cfluxContを加える
                headerConts[i][1] += cfluxCont

        #mapping?
        elif (words[0].upper() in mappingCards):
            idx = mappingCards.index(words[0].upper())
            faceChara =mappingFaceChara[idx]
            forceType = pyFistr.getValName(header, "forceType")
            if forceType == "mapping":
                print()
                print(_("mapping fileのデータを設定します。"))
                mapFile = pyFistr.getValName(header, "mapFile")
                if os.path.exists(mapFile) == False:
                    print(_("mapping File '" + mapFile + "'が存在しません。"))
                else:
                    #flagを設定
                    flag = 1
                    #係数を取得
                    mapCoeff = pyFistr.getValName(header, "mapCoeff")
                    try:
                        coeff = float(mapCoeff)
                    except:
                        coeff = 1.0
                    #shift量を取得
                    mapShift = pyFistr.getValName(header, "mapShift")
                    try:
                        shift = float(mapShift)
                    except:
                        shift = 0.0
                    #mappingDataを取得
                    dloadCont = []
                    f = open(mapFile, encoding="utf-8"); mapLines = f.readlines(); f.close()
                    for line in mapLines:
                        ne = line.find("#") 
                        if ne >= 0:
                            line = line[:ne] + "\n"
                        words = line.split()
                        if len(words) >= 3:
                            elmNo = words[0]; faceNo = words[1]; val = words[2]
                            val = "%13.5e" % (float(val) * coeff + shift)
                            #line = ", ".join([elmNo, "P"+faceNo, val]) + "\n"
                            line = ", ".join([elmNo, faceChara+faceNo, val]) + "\n"
                            dloadCont.append(line)
                    #dloadContを加える
                    headerConts[i][1] += dloadCont

        #otherData有り？
        elif (words[0].upper() in otherDataCards):
            otherData = pyFistr.getValName(header, "otherData")
            if otherData == "yes":
                #flagを設定
                flag = 1
                #grpNameを取得
                firstLine = headerConts[i][1][0]
                grpName = pyFistr.deleteSp(firstLine).split(",")[0]
                #元のcntfileを読込、同じgrp名の元のdataを取得する
                f = open(writeFile, encoding="utf-8"); cntLines = f.readlines(); f.close()
                cntHeaderConts = pyFistr.getHeaderData(cntLines)
                for ii in range(len(cntHeaderConts)):
                    hder = cntHeaderConts[ii][0]
                    wds = pyFistr.deleteSp(hder).split(",")
                    if wds[0] == words[0]:
                        if pyFistr.getValName(hder, "otherData") == "yes":
                            fline = cntHeaderConts[ii][1][0]
                            grp = pyFistr.deleteSp(fline).split(",")[0]
                            if grp == grpName:
                                #同じcardでgrp名でotherData=yesの場合
                                addData = []
                                for line in cntHeaderConts[ii][1]:
                                    if "0" <= line[0] and line[0] <= "9":
                                        addData.append(line)
                                #otherDataを追加
                                headerConts[i][1] += addData
    if flag == 1:
        lines = []
        for i in range(len(headerConts)):
            headerCont = headerConts[i]
            lines += [headerCont[0]]
            lines += headerCont[1]
    return lines


#
#  readFileLines
#    fileの読み込み
def readFileLines(fileName):
    f = open(fileName, encoding="utf-8")
    lines = f.readlines()
    f.close()
    return lines

#
#  writeFileLines
#    fileの書き込み
def writeFileLines(fileName, lines):
    f = open(fileName, "w", encoding="utf-8")
    for line in lines:
        f.write(line)
    f.close()

#
#  readFistrModelMsh
#
def readFistrModelMsh():
    workDir = os.getcwd()
    FistrModel_cnt, FistrModel_msh = pyFistr.cntMshFileName(workDir)
    fileName = FistrModel_msh
    lines = readFileLines(fileName)
    return lines

#
#  addTrueForceInCnt
#    等分布荷重をcntFileに追加する
def addTrueForceInCnt(readFile, writeFile):
    #cntファイルの読み込み
    lines = readFileLines(readFile)
    #等分布荷重を追加
    lines = addTrueForceInCntFile(lines)
    #cntファイルの書き込み
    writeFileLines(writeFile, lines)

if __name__ == "__main__":
    import gettext
    #gettext.install("app")
    #_ = gettext.gettext
    gettext.install("easyistr", os.getenv("LOCALE_DIR"))

    #log表示
    import logFileCreater
    logFileCreater.log()

    readFile = sys.argv[1]
    writeFile = sys.argv[2]
    addTrueForceInCnt(readFile, writeFile)

