#!/usr/bin/python3
#  coding:  utf-8
#
#   startingDialog.py
#
#       easyIstr起動画面
#
#   21/05/02    新規作成
#      05/07    closeまでの時間を60→120sに変更
#   23/03/18    getEasyIstrVersion:$easiIstrUserPathフォルダ有無を確認し
#               存在しない場合は、作成する様に修正。
#               起動時にuserFolderが存在しない場合、エラー発生し起動しない為。
#   24/07/07    openにencoding="utf-8"を追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import sys, os
import time


#-------------------
#  windowApp
#-------------------
#    GUIの起動と終了
class windowApp:  

    #  GUIの初期化
    def __init__(self):
        gladefile = "startingDialog.glade"  
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep  
        self.builder.add_from_file(path + gladefile)  
        self.setGtkObject()
        #windowの設定
        self.builder.connect_signals(self)
        self.mainWindow = self.builder.get_object ("window1")
        self.mainWindow.connect("delete-event", self.close)
        #titleBarを非表示
        self.mainWindow.set_decorated(False)
        #windowを最上位に表示させる
        self.mainWindow.set_keep_above(True)
        #easyIstrのversionを取得
        userPath = os.getenv("easyIstrUserPath")
        versionFile = os.sep.join([userPath, "data", "EasyISTR_version"])
        version = self.getEasyIstrVersion(versionFile)
        self.label_version.set_text("version " + version)
        #timerEventをの設定
        self.inputFile = os.sep.join([userPath, "data", "startingFile"])
        self.inputFileObj = ""
        self.existsFlag = "no"
        self.openFlag = "no"
        self.count = 0
        GLib.timeout_add(200, self.timerEvent)

    #
    #  main
    #------------
    def main(self):
        """ GUIを表示する"""
        self.mainWindow.show_all()
        Gtk.main()

    #
    #  close
    #---------
    def close(self, *args):
        """ windowを閉じる"""
        #inputFileを削除して終了
        Gtk.main_quit(*args)

    #
    #  setGtkObject
    #---------------
    """ GtkObjectの定義"""
    def setGtkObject(self):
        self.label_version = self.builder.get_object("label_version")
        self.label_status = self.builder.get_object("label_status")

    #
    #  close
    #---------
    def onClose(self, event):
        """ closeボタンをクリックした時のevent"""
        self.close()

    #
    #  getEasyIstrVersion
    #---------------------
    def getEasyIstrVersion(self, versionFile):
        """ versionFileからversionを読み取る"""
        easyIstrUserPath = os.sep.join(versionFile.split(os.sep)[:-2])
        if os.path.exists(easyIstrUserPath) == False:
            os.mkdir(easyIstrUserPath)
        if os.path.exists(versionFile) == True:
            f = open(versionFile, encoding="utf-8"); cont = f.read(); f.close()
            version = cont.split("\n")[0]
        else:
            version = "unknown"
        return version

    #
    #  timerEvent
    #--------------
    def timerEvent(self):
        """ timerEvent処理
        fileが存在しない場合は、1s間待つ。
        「close」が来るまでtimerEventを200ms間隔でevent発生を続ける。
        endCountまで待っても「close」が来ない場合は、閉じて終了する。"""
        checkCount = 5      #1s (interval * checkCount / 1000)
        endCount = 600      #120s (interval * endCount / 1000)
        interval = 200      #200ms間隔
        #inputFile有無確認
        if self.existsFlag == "no":
            if os.path.exists(self.inputFile) == True:
                self.existsFlag = "yes"
            else:
                self.count += 1
                if self.count > checkCount:
                    self.close()
                    return
                #timerEvent再設定
                GLib.timeout_add(interval, self.timerEvent)
                return
        #fileが存在する？
        if self.existsFlag == "yes":
            #timeOut?
            if self.count > endCount:
                #timeOutの為終了
                self.close()
                return
            #fileOpen？
            if self.openFlag == "no":
                #openされていない場合はopenする
                self.inputFileObj = open(self.inputFile, encoding="utf-8")
                self.openFlag = "yes"
            #fileから1行読込
            line = self.inputFileObj.readline()
            #close？
            if line[:len("close")] == "close":
                #閉じる
                self.close()
                return
            #空文字？
            elif line != "":
                text = line.split("\n")[0]
                self.label_status.set_text(text)
            #timerEvent再設定
            self.count += 1
            GLib.timeout_add(interval, self.timerEvent)
            return


if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext

    #os.environ["easyIstrUserPath"] = "/home/caeuser/easyIstrUser"
    app = windowApp()
    app.main()
