#!/usr/bin/python3
# -*- coding: utf-8 -*-    
#
#       settingDialog2.py
#
#           設定中dialog表示
#
#   17/08/29    新規作成
#      09/28    windowの表示位置をマウス位置に変更
#   19/01/26    python3、glade3用に書き換え
#      04/22    timerEvent:dialogを閉じる条件を修正（>100.0 → >100.1）
#               timerEvent時間を 10 → 50ms に修正。
#      12/01    最新のmessageのみ出力するように修正
#   20/04/22    多言語化対応
#   22/10/10    TreeFoam用をeasyIstr用に書き換え
#
#

""" 
progressBarを表示する。

表示:
    「python3 setDialog2.py <title> <setting>」で実行すると表示する。
    setting: 処理内容（例:"reading...")
進捗表示:
    標準入力に、"10, reading...\n" 形式で入力すると、進捗10%で表示する。
閉じる:
    標準入力に、"close\n" 又は 進捗100.0以上を入力すると、閉じる。
"""

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
from gi.repository import GLib

import sys   
import os   
import time
import threading

import locale
#localeDir = os.getenv("TreeFoamPath") + "/data/locale"
localeDir = os.getenv("LOCALE_DIR")
locale.bindtextdomain("easyistr", localeDir)

ls = "\n"
title = ""
setCont = ""
setting = ""


#-------------------
#  windowApp
#-------------------
#    GUIの起動と終了
class windowApp:  

    #  GUIの初期化
    def __init__(self):
        #Set the Glade file
        #gladefile = "settingDialog2.glade"  
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("easyistr")
        gladeFile = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep + "settingDialog22.glade"  
        self.builder.add_from_file(gladeFile)  
        self.setGtkObject()
        self.subInitialize()

        #windowを表示
        self.builder.connect_signals(self)
        self.mainWindow = self.builder.get_object ("window1")
        self.mainWindow.connect("delete-event", self.close)
        #title = _(u"設定中...")
        self.mainWindow.set_title(title)
        #threadを起動
        th = threading.Thread(target=self.readInputLine)
        th.start()


    #  GUIの表示
    def main(self):
        #GUI表示前に完了しているかどうかをチェック
        words = self.line.split(",")
        if words[0] == "close":
            return
        try:
            value = float(words[0])
        except:
            value = 0.0
        if value >= 100.0:
            return
        #完了していない場合、処理を継続する
        #timerEventを作成（0.2s）
        GLib.timeout_add(200, self.timerEvent)
        self.mainWindow.show_all()
        Gtk.main()

    #  GUIの終了
    def close(self, *args):
        self.value = 101.0
        Gtk.main_quit(*args)

    def onCancel(self, event):
        self.close()

    #
    #  setGtkObject
    #    objectの定義
    def setGtkObject(self):
        self.label_setCont = self.builder.get_object("label1")
        self.label_setting = self.builder.get_object("label2")
        self.prgBar = self.builder.get_object("progressBar1")
        #文字の設定
        self.builder.get_object("button_stop").set_label(_("中断"))

    #
    #  subInitialize
    #    初期化
    def subInitialize(self):
        self.label_setCont.set_text(setCont)
        self.label_setting.set_text(setting)

    #
    #  readInputLine
    #
    def readInputLine(self):
        """ input()から連続して読み込み。
        input()の内容が"close"の場合は、読み込み停止する。
        また、self.valueの値が「100」を超えた場合も読み込み停止。
        入力行の形式は、「10, U field...\n」で入力する"""
        self.value = 0.0
        self.line = ""
        while self.value < 100.0:
            try:
                self.line = input()
            except:
                self.line = "close"
                break
            if self.line[:len("close")] == "close":
                break

    def getValueMessage(self, line):
        """ 行をvalueとmessageに分ける。
        行は、"10, reading U file..."形式。
        この内容をvalue=10, message="reading U file..."に分けて返す。
       ただし、 行の内容が"close"の場合は、value:101.0を戻す。"""
        if line == "":
            value = 0.0
            message = ""
        elif line[:len("close")] == "close":
            value = 101.0
            message = line
        else:
            words = line.split(",")
            word = words[0]
            if len(words) >= 2:
                message = words[1]
            else:
                message = words[0]
            try:
                value = float(word)
            except:
                value = -1.0
        return (value, message) 

    #
    #  timeerEvent
    #    timerEventの処理
    def timerEvent(self):
        """ timerEvent発生時に、最新のself.lineを確認し、dialogに表示させる。
        行内容が"close"又は、aelf.valueが100を超えている場合は、dialogを閉じる。"""
        if self.line[:len("close")] == "close" or self.value > 100.0:
            #windowを閉じて終了
            Gtk.main_quit()
        else:
            (self.value, message) = self.getValueMessage(self.line)
            if self.value >= 0.0:
                #messageを出力
                self.label_setCont.set_text(message)
                #値を出力
                #setLine = setting + str(self.value) + " %"
                setLine = setting + ("%1.0f" % self.value) + " %"
                self.label_setting.set_text(setLine)
                self.prgBar.set_fraction(self.value/100.0)
                if self.value >= 100.1:
                    #windowを閉じて終了
                    Gtk.main_quit()
        #timerEventを設定して戻る(50ms)
        GLib.timeout_add(50, self.timerEvent)


if __name__ == "__main__":  
    import gettext
    gettext.install("easyistr", localeDir) # replace with the appropriate catalog name
    #_ = gettext.gettext

    setCont = ""
    title = _(u"設定中... ")
    setting = _(u"設定中... ")
    if len((sys.argv)) == 2:
        title = sys.argv[1]
        setting = sys.argv[1]
    if len((sys.argv)) == 3:
        title = sys.argv[1]
        setting = sys.argv[2]
    app = windowApp()  
    app.main()

