#!/usr/bin/python3
# -*- coding: utf-8 -*-    
#
#       settingDialog2.py
#
#           設定中dialog表示
#
#   17/08/29    新規作成
#      09/28    windowの表示位置をマウス位置に変更
#   19/01/26    python3、glade3用に書き換え
#      04/22    timerEvent:dialogを閉じる条件を修正（>100.0 → >100.1）
#               timerEvent時間を 10 → 50ms に修正。
#   20/06/29    最新のmessageのみ出力するように修正
#               dialogは入力がcloseでも出力させる。
#   22/04/04    __init__:windowを最上位で表示させる。
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
from gi.repository import GLib

import sys   
import os   
import time
import threading

ls = "\n"
title = ""
setCont = ""
setting = ""


#-------------------
#  windowApp
#-------------------
#    GUIの起動と終了
class windowApp:  

    #  GUIの初期化
    def __init__(self):
        #Set the Glade file
        gladefile = "settingDialog2.glade"  
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + gladefile)  
        self.setGtkObject()
        self.subInitialize()

        #windowを表示
        self.builder.connect_signals(self)
        self.mainWindow = self.builder.get_object ("window1")
        self.mainWindow.connect("delete-event", self.close)
        self.mainWindow.set_title(title)
        #windowを最上位に表示させる
        self.mainWindow.set_keep_above(True)

        self.line = ""
        self.value = 0.0
        th = threading.Thread(target=self.readInputLine)
        th.start()


    #  GUIの表示
    def main(self):
        #timerEventを作成（0.2s）
        GLib.timeout_add(200, self.timerEvent)
        #GUI表示
        self.mainWindow.show_all()
        Gtk.main()

    #  GUIの終了
    def close(self, *args):
        self.value = 101.0
        Gtk.main_quit(*args)

    #
    #  setGtkObject
    #    objectの定義
    def setGtkObject(self):
        self.label_setCont = self.builder.get_object("label1")
        self.label_setting = self.builder.get_object("label2")
        self.prgBar = self.builder.get_object("progressBar1")

    #
    #  subInitialize
    #    初期化
    def subInitialize(self):
        self.label_setCont.set_text(setCont)
        self.label_setting.set_text(setting)

    #
    #  readInputLine
    #----------------
    def readInputLine(self):
        """ input()から連続して読み込み。
        input()の内容が"close"の場合は、読み込み停止する。
        また、self.valueの値が「100」を超えた場合も読み込み停止。
        入力行の形式は、「10, U field...\n」で入力する"""
        self.value = 0.0
        self.line = ""
        while self.value < 100.0:
            try:
                self.line = input()
            except:
                self.line = "close"
                break
            if self.line[:len("close")] == "close":
                break

    #
    #  getValueMessage
    #------------------
    def getValueMessage(self, line):
        """ 行をvalueとmessageに分ける。
        行は、"10, reading U file..."形式。
        この内容をvalue=10, message="reading U file..."に分けて返す。
       ただし、 行の内容が"close"の場合は、value:101.0を戻す。"""
        if line == "":
            value = 0.0
            message = ""
        elif line[:len("close")] == "close":
            value = 101.0
            message = line
        else:
            words = line.split(",")
            word = words[0]
            if len(words) >= 2:
                message = words[1]
            else:
                message = words[0]
            try:
                value = float(word)
            except:
                value = -1.0
        return (value, message) 

    #
    #  timerEvent
    #--------------
    def timerEvent(self):
        """ timerEvent発生時に、最新のself.lineを確認し、dialogに表示させる。
        行内容が"close"又は、aelf.valueが100を超えている場合は、dialogを閉じる。"""
        if self.line[:len("close")] == "close" or self.value > 100.0:
            #windowを閉じて終了
            Gtk.main_quit()
        else:
            (self.value, message) = self.getValueMessage(self.line)
            if self.value >= 0.0:
                #messageを出力
                self.label_setCont.set_text(message)
                #値を出力
                #setLine = setting + str(self.value) + " %"
                setLine = setting + ("%1.0f" % self.value) + " %"
                self.label_setting.set_text(setLine)
                self.prgBar.set_fraction(self.value/100.0)
                if self.value >= 100.1:
                    #windowを閉じて終了
                    Gtk.main_quit()
        #timerEventを設定して戻る(50ms)
        GLib.timeout_add(50, self.timerEvent)


if __name__ == "__main__":  
    import gettext
    #gettext.install("app") # replace with the appropriate catalog name
    #_ = gettext.gettext
    gettext.install("easyistr", os.getenv("LOCALE_DIR"))

    setCont = ""
    title = _(u"設定中... ")
    setting = _(u"設定中... ")
    if len((sys.argv)) == 2:
        title = sys.argv[1]
        setCont = sys.argv[1]
    app = windowApp()  
    app.main()

