#!/usr/bin/python3
#  coding: utf-8
#
#           setDimensionAtChangeFolderDDialog.py
#
#       workFolder変更時、単位系が設定されていない場合、
#       単位系を選択させるDialog
#
#   24/03/20    新規作成
#      03/24    項目と値の表示方法を修正
#      05/26    setDimensionAtChangeFolder:クラスを追加
#      06/09    dialogApp:parentを追加
#      09/27    initialize:cancelBtnの動作をdialogに追記
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import sys
import os
import GtkParts
import createNewDimensionDDialog

ls = "\n"

#-------------------
#  dialogApp class
#-------------------
class dialogApp:

    def __init__(self, modelSize, anaType, matName, value, dimItems, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "setDimensionAtChangeFolderDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("単位系の設定"))
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.modelSize = modelSize
        self.anaType = anaType
        self.matName = matName
        self.value = value
        self.dimItems = dimItems
        self.iniUnit = "kg_m_s"
        self.unit = self.iniUnit
        self.stat = "cancel"
        self.initialize()
        
    #  show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #  close
    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        self.label_cont = self.builder.get_object("label_cont")
        self.combo_unit_org = self.builder.get_object("combo_unit")
        self.combo_unit = GtkParts.comboBox(self.combo_unit_org)
        self.builder.get_object("label_frame").set_text(_("単位系の設定"))
        self.builder.get_object("label_setDim").set_text(_("単位系を選択する"))
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))
        self.builder.get_object("button_ok").get_child().set_text(_("OK"))
        self.label_item0 = self.builder.get_object("label_item0")
        self.label_item1 = self.builder.get_object("label_item1")
        self.label_item2 = self.builder.get_object("label_item2")
        self.label_val0 = self.builder.get_object("label_val0")
        self.label_val1 = self.builder.get_object("label_val1")
        self.label_val2 = self.builder.get_object("label_val2")
        self.label_cancel = self.builder.get_object("label_cancel")

    #
    #  initialize
    #--------------
    def initialize(self):
        """ dialogの初期化"""
        #label_contの設定
        cont  = _("このfolder内のdataには、単位系が含まれていません。") + ls
        cont += _("folder内のモデルサイズ、材料物性値から、単位系を決定してください。") + ls
        self.label_cont.set_label(cont)
        if self.anaType[:len("HEAT")] != "HEAT":
            #構造解析（ヤング率）
            item = "youngs:"
        else:
            #熱解析（密度）
            item = "density:"
        items = ["modelSize(xyz):", "material:", item]
        self.modelSize = " ".join(self.modelSize.split("_"))
        vals = [self.modelSize, self.matName, self.value]
        labelItems = [self.label_item0, self.label_item1, self.label_item2]
        labelVals = [self.label_val0, self.label_val1, self.label_val2]
        for i in range(len(items)):
            labelItems[i].set_text(items[i])
            labelVals[i].set_text(" " + vals[i])
        self.label_cancel.set_label(_("「キャンセル」は、何もせずに戻る。"))
        #comboBoxの設定
        self.combo_unit.setItems(self.dimItems)
        self.combo_unit.selectItem(self.iniUnit)

    #
    #  changeItem
    #--------------
    def changeItem(self):
        """ combのitemが変更された時のevent"""
        self.unit = self.combo_unit.getSelectedItem()
        if self.unit == _(u"(任意)"):
            dialog = createNewDimensionDDialog.dialogApp(self.iniUnit)
            selDim = dialog.show()
            if selDim == "":
                return
            self.unit = selDim

#-------------------------------------------------
#  setDimensionAtChangeFolder class
#-------------------------------------------------
class setDimensionAtChangeFolder:

    def __init__(self, modelSize, anaType, matName, value, dimItems, funcName, funcArgs, parent=None):
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(modelSize, anaType, matName, value, dimItems, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)
        self.dialog.combo_unit_org.connect("changed", self.onChangeItem)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        unit = self.dialog.unit
        self.close()
        path, item = self.funcArgs
        self.funcName(unit, path, item)

    def onChangeItem(self, event):
        self.dialog.changeItem()


if __name__ == "__main__":
    import gettext
    gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext
