#!/usr/bin/python3
#  coding: utf-8
#
#           selectImportItemDDialog.py
#
#       import項目を選択する。
#
#   25/04/19    新規作成
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import os
import GtkParts

importItemDict = {
    #key            表示内容                                pattern
    "cad":          ["Cad: CAD_file  (*.step, *.stp, *.brep)", ["*.step", "*.stp", "*.brep"]],
    "unv2fistr":    ["Msh: I-deas_Universal  (*.unv)",    ["*.unv"]],
    "abaqus2fistr": ["MshCnt: Calculix  (*.inp)",         ["*.inp"]],
    "resFrd2vtk":   ["Res: Calculix  (*.frd, *.inp)",     ["*.frd", "*.inp"]],
    "readAbaqus":   ["meshio: Abaqus  (*.inp)",           ["*.inp"]],
    "readAnsys":    ["meshio: ANSYS  (*.msh)",            ["*.msh"]],
    "readAvsucd":   ["meshio: AVS-UCD  (*.avs)",          ["*.avs"]],
    "readExodus":   ["meshio: Exodus  (*.e, *.exo)",      ["*.e", "*.exo"]],
    "readGmsh":     ["meshio: Gmsh  (*.msh)",             ["*.msh"]],
    "readMdpa":     ["meshio: Kratos/MDPA  (*.mdpa)",     ["*.mdpa"]],
    "readMed":      ["meshio: Salome/med  (*.med)",       ["*.med"]],
    "readMedit":    ["meshio: Medit  (*.mesh)",           ["*.mesh"]],
    "readNastran":  ["meshio: Nastran  (*.bdf, *.fem, *.nas)", ["*.bdf", "*.fem", "*.nas"]],
    "readNetgen":   ["meshio: Netgen  (*.vol)",           ["*.vol"]],
    "readPermas":   ["meshio: PERMAS  (*.post, *.dato)",  ["*.post", "*.dato"]],
    "readVtk":      ["meshio: VTK  (*.vtk)",              ["*.vtk"]],
    "readVtu":      ["meshio: VTU  (*.vtu)",              ["*.vtu"]],
    "readXdmf":     ["meshio: XDMF  (*.xdmf, *.xmf)",     ["*.xdmf", "*.xmf"]]
    }

#--------------------
#  getImportItem class
#--------------------
class getImportItem:

    def __init__(self, istrData, funcOk=[], parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "selectImportItemDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("import形式の選択"))
        self.builder.connect_signals(self)
        #変数を設定
        self.funcOk = funcOk
        self.istrData = istrData
        self.setGtkObject()
        self.initialize()


    #show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #close
    def close(self, *args):
        """ dialog閉じる"""
        self.dialog.destroy()

    #  setGtkObject
    def setGtkObject(self):
        """ gtkObjectの定義"""
        combo_import = self.builder.get_object("combo_import")
        self.combo_import = GtkParts.comboBox(combo_import)
        self.builder.get_object("label_import").set_text(_("importする形式を選択する"))
        self.builder.get_object("label_importItem").set_text(_("import形式"))
        self.builder.get_object("label_itemName").set_text(_("形式名:"))
        msg  = _("Cad:    CAD fileをimport、mesh作成") + "\n"
        msg += _("Msh:    メッシュをimport") + "\n"
        msg += _("MshCnt: メッシュと制御内容をimport") + "\n"
        msg += _("Res:    計算結果をimport") + "\n"
        msg += _("meshio: meshioからメッシュをimport")
        self.builder.get_object("label_importConts").set_text(msg)
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))
        self.builder.get_object("button_ok").get_child().set_text(_("選択..."))

    #  initialize
    def initialize(self):
        """ 初期化"""
        items = list(map(lambda x: importItemDict[x][0], importItemDict.keys()))
        self.combo_import.setItems(items)
        #istrDataを設定
        importItem = "unv2fistr"
        for line in self.istrData:
            words = line.split()
            if len(words) > 1:
                if words[0] == "importItem":
                    importItem = words[1]
                    break
        if importItem in importItemDict.keys():
            selItem = importItemDict[importItem][0]
            self.combo_import.selectItem(selItem)
        else:
            selItem = importItemDict["unv2fistr"][0]
            self.combo_import.selectItem(selItem)

    #---- event handler -----------------
    def onOk(self, event):
        self.importSelectItem()

    def onCancel(self, event):
        self.close()

    #
    #  importSelectItem
    #-------------------
    def importSelectItem(self):
        """ 選択項目をimportする"""
        importKey = ""
        selItem = self.combo_import.getSelectedItem()
        for item in importItemDict.keys():
            if importItemDict[item][0] == selItem:
                importKey = item
                break
        funcName = self.funcOk[0]
        funcArgs = [importKey] + self.funcOk[1:]
        funcName(*funcArgs)
        self.close()
