#!/usr/bin/python3
#  coding:  utf-8
#
#           selectExportItemDDialog.py
#
#       exportの形式を選択する。
#
#   25/04/19    新規作成
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import os
import GtkParts

exportItemDict = {
    #key            表示内容                                pattern
    "fistr2abaqus": ["MshCnt: Calculix  (*.inp)",         ["*.inp"]],
    "fistr2rad":    ["MshCnt: OpenRadioss  (*.rad)",      ["*.rad"]],
    "writeAbaqus":  ["meshio: Abaqus  (*.inp)",           ["*.inp"]],
    "writeAnsys":   ["meshio: ANSYS  (*.msh)",            ["*.msh"]],
    "writeAvsucd":  ["meshio: AVS-UCD  (*.avs)",          ["*.avs"]],
    "writeExodus":  ["meshio: Exodus  (*.e, *.exo)",      ["*.e", "*.exo"]],
    "writeGmsh":    ["meshio: Gmsh  (*.msh)",             ["*.msh"]],
    "writeGmsh22":  ["meshio: Gmsh_2.2  (*.msh)",         ["*.msh"]],
    "writeMdpa":    ["meshio: Kratos/MDPA  (*.mdpa)",     ["*.mdpa"]],
    "writeMed":     ["meshio: Salome/med  (*.med)",       ["*.med"]],
    "writeMedit":   ["meshio: Medit  (*.mesh)",           ["*.mesh"]],
    "writeNastran": ["meshio: Nastran  (*.bdf, *.fem, *.nas)", ["*.bdf", "*.fem", "*.nas"]],
    "writeNetgen":  ["meshio: Netgen  (*.vol)",           ["*.vol"]],
    "writePermas":  ["meshio: PERMAS  (*.post, *.dato)",  ["*.post", "*.dato"]],
    "writeVtk":     ["meshio: VTK  (*.vtk)",              ["*.vtk"]],
    "writeVtu":     ["meshio: VTU  (*.vtu)",              ["*.vtu"]],
    "writeXdmf":    ["meshio: XDMF  (*.xdmf, *.xmf)",     ["*.xdmf", "*.xmf"]]
    }

#--------------------
#  getExportItem class
#--------------------
class getExportItem:

    def __init__(self, istrData, funcOk=[], parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "selectExportItemDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("export形式の選択"))
        self.builder.connect_signals(self)
        #変数を設定
        self.funcOk = funcOk
        self.istrData = istrData
        self.setGtkObject()
        self.initialize()

    #show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #close
    def close(self, *args):
        """ dialog閉じる"""
        self.dialog.destroy()

    #  setGtkObject
    def setGtkObject(self):
        """ gtkObjectの定義"""
        combo_export = self.builder.get_object("combo_export")
        self.combo_export = GtkParts.comboBox(combo_export)
        self.builder.get_object("label_export").set_text(_("exportする形式を選択する"))
        self.builder.get_object("label_exportItem").set_text(_("export形式"))
        self.builder.get_object("label_itemName").set_text(_("形式名:"))
        msg  = _("MshCnt: メッシュと制御内容をexport") + "\n"
        msg += _("meshio: meshioからメッシュをexport")
        self.builder.get_object("label_exportConts").set_text(msg)
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))
        self.builder.get_object("button_ok").get_child().set_text(_("選択..."))

    #  initialize
    def initialize(self):
        """ 初期化"""
        #comboの設定
        items = list(map(lambda x: exportItemDict[x][0], exportItemDict.keys()))
        self.combo_export.setItems(items)
        #istrDataの設定
        exportItem = "fistr2abaqus"
        for line in self.istrData:
            words = line.split()
            if len(words) > 1:
                if words[0] == "exportItem":
                    exportItem = words[1]
                    break
        if exportItem in exportItemDict.keys():
            selItem = exportItemDict[exportItem][0]
            self.combo_export.selectItem(selItem)
        else:
            selItem = exportItemDict["fistr2abaqus"][0]
            self.combo_export.selectItem(selItem)

    #---- event handler -----------------
    def onOk(self, event):
        self.exportSelectItem()
    def onCancel(self, event):
        self.close()

    #
    #  exportSelectItem
    #-------------------
    def exportSelectItem(self):
        """ 選択項目をexportする"""
        exportKey = ""
        selItem = self.combo_export.getSelectedItem()
        for item in exportItemDict.keys():
            if exportItemDict[item][0] == selItem:
                exportKey = item
                break
        funcName = self.funcOk[0]
        funcArgs = [exportKey] + self.funcOk[1:]
        funcName(*funcArgs)
        self.close()




