#!/usr/bin/python3  
# -*- coding: utf-8 -*-    
#
#       runCommandWithDialog.py
#
#   使い方
#   runCommandWithDialog.py <job> <command>
#       job     :job名
#       command :実行するコマンド
#
#   job名からtitle, messageを取得し、commandを実行する
#       
#
#   15/06/19    新規作成
#      09/02    "\n"→os.linesepに修正
#      10/18    messageをjobに応じて作成する様に修正
#      12/18    windows版のpangoWarning対策で、初期化を修正
#      12/25    行末コードを修正
#   19/01/07    python3、Gtk+3用に書き換え
#      01/21    dialogを修正。
#      01/26    runCommand:windows用に修正
#               汎用dialog:type→message_typeに修正
#               subprocess起動と中断方法をwindowsとlinuxで分ける
#   20/04/24    runCommand:dialogに出力する文字数を150文字以内に制限
#               1行の文字数が多すぎると、hangupする為。
#   22/03/14    国際化
#      03/22    国際化（文字をpython側でセット）
#      04/12    log表示修正（import logFileCreaterを追加）
#      04/18    log表示を廃止。標準出力は、実行している側が出力
#               しているので、ここではlog表示を廃止。
#               （2重で表示される為）
#      04/26    log表示復活
#      04/28    runCommand:windows側の出力行取得方法修正（バグ）
#      07/31    runCommand:windows側の出力行取得方法再修正（バグ）
#               windowsの場合、出力が取得できず、log表示されなかった
#   24/06/06    universalDialogsに変更。
#      06/07    timerEvent:okDialog表示タイミングを修正。
#      06/07    okDialog,okCancelDialog:parentを追加
#      06/12    windowApp:window位置をmouseに合わせる様修正
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
#from gi.repository import GObject
from gi.repository import GLib

import sys   
import os
import threading
import subprocess
import signal
import universalDialogs

#import locale
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

import gettext
gettext.install("easyistr", localeDir)



title = ""
message = ""
command = ""
ls = "\n"
outLines = []
closeFlag = 0       #command終了有無    1:終了
stopFlag = 0        #中断有無           1:中断


#  job名とその内容
jobDict = {
    #job名               title               message
    "convData":     [_(u"データ変換"),   _(u"データ変換が完了しました")],
    "mergeResult":  [_(u"結果の再構築"), _(u"分散結果をマージしました。")],
    "separateMesh": [_(u"メッシュ分割"), _(u"メッシュ分割\nメッシュを分割しました。")],
    "":             ["", ""]
    }


#----------------
#  windowApp
#----------------
#    GUIの起動と終了
class windowApp:  

    #  GUIの初期化
    def __init__(self):
        global command
        self.builder = Gtk.Builder()
        #self.builder.set_translation_domain("easyistr")
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "runCommandWithDialog2.glade")  
        self.setGtkObject()
        self.subInitialize()

        self.builder.connect_signals(self)
        self.mainWindow = self.builder.get_object("window1")
        #window位置をmouseの位置に合わせる        
        self.mainWindow.set_position(2)
        self.mainWindow.connect("delete-event", self.close)
        self.mainWindow.set_title(title)
        #GObject.timeout_add(200, self.timerEvent)
        GLib.timeout_add(200, self.timerEvent)

    #  GUIの表示
    def main(self):
        self.mainWindow.show_all()
        self.runThread()
        Gtk.main()


    #  GUIの終了
    def close(self, *args):
        Gtk.main_quit(*args)

    #  comm停止
    def onCancel(self, event):
        mess = title + _(u"の中断") + "\n"
        mess += _(u"本当に中断しますか?")
        funcOk = [self.cancelProcess]
        funcCancel = []
        self.okCancelDialog2(title, mess, funcOk, funcCancel, parent=self.mainWindow)
        return
        # stat = self.okCancelDialog(title, mess)
        # if stat == "OK":
        #     self.onCancelProcess()
    
    #
    #  cancelProcess
    def cancelProcess(self):
        global closeFlag, stopFlag
        if os.name == "nt":
            #windowsの場合
            #errorコードを送出
            try:
                dummy_outs, dummy_errs = self.proc.communicate(timeout=0.1)
            except:
                self.proc.kill()
                dummy_outs, dummy_errs = self.proc.communicate()
        else:
            #linuxの場合
            #全てのpidを停止
            os.killpg(os.getpgid(self.proc.pid), signal.SIGTERM)
        #中断flagを設定
        stopFlag = 1

    #  object名を取得
    def setGtkObject(self):
        self.label_mess = self.builder.get_object("label1")
        self.label_out = self.builder.get_object("label2")
        self.builder.get_object("button1").get_child().set_text(_("中止"))

    #  初期化
    def subInitialize(self):
        self.label_mess.set_text(title + u"中...")

    #  timerEvent
    def timerEvent(self):
        global outLines
        lines = outLines[-4:]
        cont = "".join(lines)
        self.label_out.set_text(cont)
        if closeFlag == 0 and stopFlag == 0:
            #終了していない場合は、timerEvent再設定
            #GObject.timeout_add(50, self.timerEvent)
            GLib.timeout_add(50, self.timerEvent)
        elif closeFlag == 1 and stopFlag == 0:
            #終了している場合、終了メッセージを出力
            funcOk = [self.close]
            self.okDialog(title, message, self.mainWindow, funcOk )
            #Gtk.main_quit()
        else:
            #中断の場合
            mess = title + _(u" を中断しました")
            print (mess)
            funcOk = [self.close]
            self.okDialog(title, message, self.mainWindow, funcOk )
            #Gtk.main_quit()

    #
    #  runThread
    #    thread実行
    def runThread(self):
        thread = threading.Thread(target=self.runCommand)
        thread.start()

    #  runCommand
    #    command実行
    #    正常終了した場合は、closeFlag=1 に設定する
    def runCommand(self):
        global outLines, command, closeFlag
        print ()
        print (command)
        outLines = [title+ls, ls, command + ls]
        command = command + " 2>&1"
        #subProcessを起動
        if os.name == "nt":
            #windows
            self.proc = subprocess.Popen(
                        command,                    #コマンド
                        shell=True,
                        stdout=subprocess.PIPE,
                        stderr=subprocess.PIPE)
            try:
                for line in iter(self.proc.stdout.readline, b""):
                    line = line.decode("shift-jis")
                    if line[-2:] == "\r\n":
                        line = line[:-2] + ls
                    #dialogに出力する内容は、100文字に抑える
                    outLine = line[:150]
                    if outLine[-1] != ls:
                        outLine += "..." + ls
                    outLines.append(line)
                    print (line, end="")
                closeFlag = 1
            except:
                pass
        else:
            #linux
            #「preexec_fn=os.setsid」でpidのgroupを作成（後で全て停止できるように）
            self.proc = subprocess.Popen(
                        command,                    #コマンド
                        shell=True,
                        stdout=subprocess.PIPE,
                        stderr=subprocess.PIPE,
                        preexec_fn=os.setsid)
            #subProcessの出力をrealTimeで取得する
            for line in iter(self.proc.stdout.readline, b""):
                line = line.decode("utf-8")
                #dialogに出力する内容は、100文字に抑える
                outLine = line[:150]
                if outLine[-1] != ls:
                    outLine += "..." + ls
                outLines.append(outLine)
                print (line, end="")
            """
            self.proc.stdout.flush()
            for line in self.proc.stdout:
                self.proc.stdout.flush()
                line = line.decode("utf-8")
                outLines.append(line)
                print (line, end=" ")
            """
            closeFlag = 1

    def okDialog(self, title, message, parent=None, funcOk=[]):
        dialog = universalDialogs.okDialog(title, message, parent, funcOk)
        dialog.show()

    def okCancelDialog2(self, title, message, funcOk, funcCancel, parent=None):
        dialog = universalDialogs.okCancelDialog(title, message, funcOk, funcCancel, parent)
        dialog.show()


#
#  getTitleMessage
#    jobからtitleとmessageを決定
def getTitleMessage(job):
    global title, message
    if job in jobDict.keys():
        title, message = jobDict[job]
    else:
        title, message  = "", ""

#--------
#  run
#--------
def run(job0, command0, parent=None):
    """ command実行"""
    global job, command
    job = job0
    command = command0
    getTitleMessage(job)
    app = windowApp(parent)
    app.main()


if __name__ == "__main__":
    #log表示
    import logFileCreater
    logFileCreater.log()

    job = sys.argv[1]
    command = sys.argv[2]

    getTitleMessage(job)

    app = windowApp()
    app.main()  

