#!/usr/bin/python3
#  coding: utf-8
#
#   procGetFolderContHdd.py
#
#       folderContとHDD容量を取得する。
#       subprocessをして実行する。
#
#   21/05/10    新規作成
#

import sys, os
import subprocess
import folderContHddVals

#
#  getFolderContHdd
#-------------------
def getFolderContHdd(folderDir):
    """ folderContとHDD容量を取得する"""
    folderCont = folderContHddVals.getFolderCont(folderDir)
    (total, free) = folderContHddVals.getDiskSpace(folderDir)
    folderCont = list(map(lambda x: "_None" if x=="" else x, folderCont))
    hdd = list(map(str, [total, free]))
    folderContHdd = folderCont + hdd
    cont = ",".join(folderContHdd)
    print(cont)

if __name__ == "__main__":
    folderDir = sys.argv[1]
    getFolderContHdd(folderDir)
