#!/usr/bin/python3
# coding: utf-8
#
#       inputTextDialog.py
#
#       テキストデータの入力dialog
#
#   13/10/15    国際化のため、修正
#   15/07/17    dialogの起動方法を修正
#   16/05/28    wx.EVT_KEY_DOWNを追加
#   19/10/15    GTK+3, python3用に大幅修正
#   22/03/15    国際化
#      03/22    国際化（文字をpython側でセット）
#   24/05/21    gladeファイル中のsignalを削除。
#               signalは、呼び出し側で設定する。
#               show:GUI表示後、直ぐに戻る。
#      06/01    set_modal(True)を追加。（親をfreezeさせる）
#      06/09    parentを追加
#      12/13    getInputText.__init__:freezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
import os, sys

#import locale
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

#-------------------
#  dialogApp class
#-------------------
class dialogApp:
    """ テキスト入力データを取得するGUI。
    
    Attribute:
        title (str)     :dialogのtitle
        message (str)   :出力するmessage
        entryText (str) :entryにdefaultで出力させる内容
    """

    def __init__(self, title, message, entryText, parent=None):
        self.builder = Gtk.Builder()
        #path = os.getenv("easyIstrPath") + os.sep + "python" + os.sep
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "inputTextDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.title = title
        self.message = message
        self.entryText = entryText
        self.stat = "CANCEL"
        #初期化
        self.initialize()

    def show(self):
        """ dialogを表示、entryのtextを戻す"""
        self.dialog.show()

    def close(self, *args):
        """ dialogを直接閉じた時のevent"""
        self.dialog.destroy()

    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.label_mess = self.builder.get_object("label_message")
        self.entry = self.builder.get_object("entry_text")
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")

    def initialize(self):
        self.dialog.set_title(self.title)
        self.label_mess.set_label(self.message)
        self.entry.set_text(self.entryText)
        #文字をセット
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))


#----------------------
#  getInputText class
#----------------------
class getInputText:
    """ テキストを取得するdialog。dialogはmodalの設定。
    
    Args:
        title (str):    dialogのtitle
        mess (str):     dialogに表示するmessage
        iniText (str):  起動時にentryに表示させる文字列
        funcName (object):  テキスト取得後の処理関数
        funcArgs (list):    処理関数の引数
        """

    def __init__(self, title, mess, iniText, funcName, funcArgs, parent=None):
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(title, mess, iniText, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)
        self.dialog.entry.connect("activate", self.onEntryActivate)
        #modal（freeze）設定
        #self.dialog.dialog.set_modal(True)

    def show(self):
        self.dialog.dialog.show()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        getText = self.dialog.entry.get_text()
        self.close()
        #取得したtextをfuncで処理する
        [grpNames] = self.funcArgs
        self.funcName(getText, grpNames)

    def onEntryActivate(self, event):
        self.onOk(event)

    def close(self, *argv):
        self.dialog.close()
