#
#  coding: utf-8
#
#   focus_addJobList.py
#
#       jobの内容をjobListに追加する
#
#   19/11/09    新規作成
#   24/07/07    openにencoding="utf-8"を追加
#

import os, sys
import datetime
import glob
import subprocess

jobListFile = os.getenv("HOME") + "/.jobList"

#
#  readJobList
def readJobList():
    """ ファイルからjobListを読み込む"""
    fileName = jobListFile
    #if len(glob.glob(fileName)) == 0:
    if os.path.exists(fileName) == False:
        return []
    else:
        f = open(fileName, encoding="utf-8"); jobLines = f.readlines(); f.close()
    return jobLines

#
#  deleteOverDyasJob
def deleteOverDaysJob(jobLines):
    """ 30日以前のjobは、削除する"""
    newLines = []
    for line in jobLines:
        words = line.split()
        if len(words) >= 1:
            job = list(map(int, words[1].split("-")))
            jobTime = datetime.datetime(job[0], job[1], job[2], job[3], job[4], job[5])
            days = (datetime.datetime.now() - jobTime).days
            if days < 30:
                newLines.append(line)
    return newLines              

#
#  addThisJobCont
def addThisJobCont(jobLines, jobNo, jobDir):
    """ 今回のjobを新規に追加する。"""
    n = datetime.datetime.now()
    timeList = [n.year, n.month, n.day, n.hour, n.minute, n.second]
    currTime = "-".join(list(map(str, timeList)))
    newLine = jobNo + " " + currTime + " " + jobDir + "\n"
    jobLines.append(newLine)
    return jobLines

#
#  writeJobCont
def writeJobCont(jobLines):
    """ job内容をファイルに書き込み"""
    fileName = jobListFile
    f = open(fileName, "w", encoding="utf-8")
    for line in jobLines:
        f.write(line)
    f.close()

#
#  addJobList
#  ----------
def addJobList(jobNo, jobDir):
    jobLines = readJobList()
    jobLines = deleteOverDaysJob(jobLines)
    jobLines = addThisJobCont(jobLines, jobNo, jobDir)
    writeJobCont(jobLines)

#
#  runJob
#---------
def runJob(jobDir, jobFile):
    """ jonを投入"""
    comm = "cd " + jobDir + "; "
    comm += "sbatch " + jobFile
    proc = subprocess.Popen(
        comm,
        shell=True,
        stdout=subprocess.PIPE,
        stderr=subprocess.PIPE)
    #結果をrealTimeに取得し、出力
    results = []
    for line in iter(proc.stdout.readline, b""):
        resLine = line.rstrip().decode("utf-8")
        results.append(resLine)
        print(resLine)
    #jobidを取得
    jobId = results[0].split()[-1]
    return jobId

if __name__ == "__main__":
    jobDir = sys.argv[1]
    jobFile = sys.argv[2]
    jobNo = runJob(jobDir, jobFile)
    addJobList(jobNo, jobDir)
