#!/usr/bin/python3  
# -*- coding: utf-8 -*-
#
#       deleteOverlapNodesDDialog2.py
#
#           節点Group間や節点Groupと面Group間で重複している節点を削除する。
#
#   18/01/28    新規作成
#      02/02    Show関数追加
#      06/17    checkNodeNumOfNgrp:group内の全nodeが削除された場合、エラー発生するので修正
#      11/25    overlapNamesを受けてGUI表示、「OK」ボタンでメッシュ情報を再取得する様に修正
#   19/01/09    python3用に書き換え
#      01/13    glade3のdialog表示に対応
#      01/26    okDialog:type→message_typeに修正
#      03/09    okDeleteNodes:バグ修正（nodeGrpの順番が正しく取得されていなかった。）
#   22/03/14    国際化
#      03/22    国際化（文字をpython側でセット）
#   23/04/17    mshファイル名をhecmw_ctrl.datから取得する様に修正
#   24/05/22    deleteOverlapNodes:新規追加。
#      06/08    okDialog,errdialog:parentを追加
#      06/09    dialogApp:parentを追加
#      07/07    openにencoding="utf-8"を追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import sys
import os
import glob
import pyFistr
import deleteOverlapNodeInNgrp as delnd
import universalDialogs

#import locale
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

meshHeaderData = []
ngrpNames = []
ngrps = []
allNgrpNames = []
ls = "\n"

stat = ""

#-----------
#  dialogApp
#-----------
#    GUIの起動と終了
class dialogApp:
    """ GUIの起動と終了"""

    #  dialogの初期化
    def __init__(self, names, parent=None):
        global ngrpNames
        ngrpNames = names
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "deleteOverlapNodesDDialog2.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        #objectの定義
        self.setGtkObject()
        self.subInitialize()

    #  dialogの表示
    def show(self):
        self.dialog.show()

    #  GUIの終了
    def close(self, *args):
        self.dialog.destroy()

    #
    #  setGtkObject
    #    objectの定義
    def setGtkObject(self):
        self.checkBtn_toSur = self.builder.get_object("checkbutton1")
        self.checkBtn_toNode = self.builder.get_object("checkbutton2")
        self.button_moveUp = self.builder.get_object("button1")
        self.button_moveDown = self.builder.get_object("button2")
        self.button_OK = self.builder.get_object("button3")
        self.button_cancel = self.builder.get_object("button4")
        self.listBox_ngrp = self.builder.get_object("treeview2")
        self.listBox_ngrp.get_selection().set_mode(Gtk.SelectionMode.MULTIPLE)
        self.label_delExp = self.builder.get_object("label3")
        self.label_boxTitle = self.builder.get_object("label6")
        self.label_boxUp = self.builder.get_object("label4")
        self.label_boxDwn = self.builder.get_object("label5")
        self.listmodel_ngrp = Gtk.ListStore(str)
        #文字をセット
        mess = _("節点Groupの修正\nGroup間の境界などで、重複定義された節点を修正する。")
        self.builder.get_object("label_delMethod").set_text(mess)
        self.builder.get_object("label_reformMethod").set_text(_("節点Group同士の重複節点を修正"))
        self.checkBtn_toNode.get_child().set_text(_("重複箇所の節点を全NGRPから削除する（Edgeの節点を削除）"))
        self.label_delExp.set_text(_("節点Groupの優先順を設定し、\n優先度の低い側の重複節点を削除する。"))
        self.label_boxTitle.set_text(_("節点が重複している節点Grpup"))
        self.label_boxUp.set_text(_("節点確保"))
        self.label_boxDwn.set_text(_("節点削除"))
        self.button_moveUp.get_child().set_text(_("上に移動"))
        self.button_moveDown.get_child().set_text(_("下に移動"))
        self.builder.get_object("label_reformNodeFace").set_text(_("節点Groupと面Group間の重複節点を修正"))
        self.checkBtn_toSur.get_child().set_text(_("重複している節点を節点Groupから削除する"))
        self.button_cancel.get_child().set_text(_("キャンセル"))

    #
    #  subInitialize
    #
    def subInitialize(self):
        #listBoxにitemをセット
        self.setListDataInListBox(self.listmodel_ngrp, self.listBox_ngrp, ngrpNames)
        path = (0)
        self.listBox_ngrp.get_selection().select_path(path)
        #checkBoxを設定
        self.checkBtn_toNode.set_active(True)
        self.checkBtn_toSur.set_active(True)
        self.changeDelMode()
        #titleをセット
        self.dialog.set_title(_("重複節点の削除"))

    #
    #  setListDataInListBox
    #    listBoxをクリアしてデータをセットする
    def setListDataInListBox(self, listModel, listBox, setNames):
        listModel.clear()
        if len(setNames) == 0:
            listModel.append(["(None)"])
        else:
            for name in setNames:
                listModel.append([name])
        listBox.set_model(model=listModel)
        cols = [""]
        for i in range(len(cols)):
            coll = listBox.get_column(i)
            if coll != None:
                listBox.remove_column(coll)
            cell = Gtk.CellRendererText()
            col = Gtk.TreeViewColumn(cols[i], cell, text=i)
            listBox.append_column(col)
        listBox.set_headers_visible(False)

    #
    #  changeDelMode
    #    節点削除modeを変更する
    def changeDelMode(self):
        if self.checkBtn_toNode.get_active() == True:
            #labelを隠す
            self.label_delExp.set_sensitive(False)
            self.label_boxTitle.set_sensitive(False)
            self.label_boxUp.set_sensitive(False)
            self.label_boxDwn.set_sensitive(False)
            self.listBox_ngrp.set_sensitive(False)
            self.button_moveUp.set_sensitive(False)
            self.button_moveDown.set_sensitive(False)
        else:
            #labelを表示
            self.label_delExp.set_sensitive(True)
            self.label_boxTitle.set_sensitive(True)
            self.label_boxUp.set_sensitive(True)
            self.label_boxDwn.set_sensitive(True)
            self.listBox_ngrp.set_sensitive(True)
            self.button_moveUp.set_sensitive(True)
            self.button_moveDown.set_sensitive(True)

    #
    #  ngrpMoveUp
    #    選択したnamesを一段上昇する
    def ngrpMoveUp(self):
        global ngrpNames
        (listmodel, pathList) = self.listBox_ngrp.get_selection().get_selected_rows()
        if len(pathList) == 0:
            title = _(u"NGRPの選択")
            mess = _(u"NGRP名を選択してください")
            self.errDialog(title, mess, parent=self.dialog)
            return
        #全namesを取得
        allNames = self.getNamesInListmodel(self.listmodel_ngrp)
        #選択しているnamesを取得
        selNames = []
        for path in pathList:
            selName = allNames[path[0]]
            selNames.append(selName)
        #順番を1ヶ上昇
        if selNames[0] != allNames[0]:
            for selName in selNames:
                seli = 0
                for i in range(len(allNames)):
                    if selName == allNames[i]:
                        seli = i
                        break
                if seli > 0:
                    allNames = allNames[:seli-1] + [selName] + [allNames[seli-1]] + allNames[seli+1:]
        #listBoxに表示
        self.setListDataInListBox(self.listmodel_ngrp, self.listBox_ngrp, allNames)
        #選択Namesｗっを選択表示させる
        self.showSelectItemsInListBox(self.listBox_ngrp, allNames, selNames)
        #global変数にlistをセット
        ngrpNames = allNames

    #
    #  ngrpMoveDown
    #    選択したnamesを一段下げる
    def ngrpMoveDown(self):
        global ngrpNames
        (listmodel, pathList) = self.listBox_ngrp.get_selection().get_selected_rows()
        if len(pathList) == 0:
            title = _(u"NGRPの選択")
            mess = _(u"NGRP名を選択してください")
            self.errDialog(title, mess, parent=self.dialog)
            return
        #全namesを取得
        allNames = self.getNamesInListmodel(self.listmodel_ngrp)
        #選択しているnamesを取得
        selNames = []
        for path in pathList:
            selName = allNames[path[0]]
            selNames.append(selName)
        #順番を1ヶ下げる
        if selNames[-1] != allNames[-1]:
            n = len(selNames) - 1
            while n >= 0:
                selName = selNames[n]
                seli = len(allNames) - 1
                i = len(allNames) - 1
                while i >= 0:
                    if selName == allNames[i]:
                        seli = i
                        break
                    i -= 1
                if seli < len(allNames)-1:
                    allNames = allNames[:seli] + [allNames[seli+1]] + [selName] + allNames[seli+2:]
                n -= 1

        #listBoxに表示
        self.setListDataInListBox(self.listmodel_ngrp, self.listBox_ngrp, allNames)
        #選択Namesｗっを選択表示させる
        self.showSelectItemsInListBox(self.listBox_ngrp, allNames, selNames)
        #global変数にlistをセット
        ngrpNames = allNames

    #  getNamesInListmodel
    def getNamesInListmodel(self, listmodel):
        names = []
        iter = listmodel.get_iter_first()
        while iter != None:
            name = listmodel.get_value(iter, 0)
            names.append(name)
            iter = listmodel.iter_next(iter)
        return names

    #
    #  showSelectItemsInListBox
    #    listBox内のselNamesを選択表示する
    def showSelectItemsInListBox(self, listBox, allNames, selNames):
        n = 0
        for name in allNames:
            for selName in selNames:
                if name == selName:
                    path = (n)
                    listBox.get_selection().select_path(path)
            n += 1

    #
    #  okDeleteNodes
    #
    def okDeleteNodes(self):
        global stat
        global ngrpNames, meshHeaderData, ngrps, allNgrpNames, otherNames
        stat = "OK"
        #必要なメッシュ情報を取得
        #lines = pyFistr.readFistrModelMsh()
        #meshHeaderData = pyFistr.getHeaderNumData(lines)
        meshHeaderData = pyFistr.getHeaderNumDataMsh(os.getcwd())
        [ngrps, allNgrpNames] = delnd.getNgrpData(meshHeaderData)
        [overlapNames, otherNames] = delnd.getOverlapNgrpNames(ngrps, allNgrpNames)
        overlapNames.sort()
        ngrpNames.sort()
        #当初のoverlapNamesと現在のoverlapNamesが合致しているかどうかチェック
        if overlapNames != ngrpNames:
            #合致していない場合
            title = _(u"エラー")
            mess = _(u"エラーが発生しました。") + "\n" + _(u"節点は削除していません。")
            func = [self.close]
            self.errDialog(title, mess, parent=self.dialog, funcOk=func)
            stat = "cancel"
        else:
            #合致している場合
            #  node削除する順番でngrpNamesを取得
            ngrpNames = self.getNamesInListmodel(self.listmodel_ngrp)
            #  node削除
            self.deleteOverlapNodes()

    #
    #  deleteOverlapNodes
    #    重複節点を削除する
    def deleteOverlapNodes(self):
        global meshHeaderData
        orderNames = ngrpNames + otherNames
        if self.checkBtn_toNode.get_active() == True:
            nodeDataList = delnd.createNodeDataListDeleteEdge(ngrps, orderNames)
        else:
            nodeDataList = delnd.createNodeDataListFromNgrps(ngrps, orderNames)
        if len(ngrpNames) > 0:
            print (_(u"nodeGroup間の重複節点を削除しました。"))
        if self.checkBtn_toSur.get_active() == True:
            surNodes = delnd.getSurfaceNodes(meshHeaderData)
            nodeDataList = delnd.addNodeDataListFromSgrps(surNodes, nodeDataList)
            print (_(u"surfaceGroupとの重複節点を削除しました。"))
        #meshHeaderDataを再作成
        meshHeaderData = delnd.createMeshHeaderData(meshHeaderData, nodeDataList,
                                                    orderNames)
        #書き込み
        lines = pyFistr.createLinesFistrModelMshHeader(meshHeaderData)
        workDir = os.getcwd()
        FistrModel_cnt, FistrModel_msh = pyFistr.cntMshFileName(workDir)
        #writeFileLines("FistrModel.msh", lines)
        writeFileLines(FistrModel_msh, lines)
        #削除したgrpNamesを確認、表示
        delMess = checkNodeNumOfNgrp(ngrps, meshHeaderData)
        title = _(u"重複節点の削除")
        func = [self.close]
        self.okDialog(title, delMess, parent=self.dialog, funcOk=func)

    def okDialog(self, title, message, parent=None, funcOk=[]):
        dialog = universalDialogs.okDialog(title, message, parent, funcOk)
        dialog.show()

    def errDialog(self, title, message, parent=None, funcOk=[]):
        dialog = universalDialogs.errDialog(title, message, parent, funcOk)
        dialog.show()

#
#  checkNodeNumOfNgrp
#    削除したnode数を確認
def checkNodeNumOfNgrp(ngrps, meshHeaderData):
    newNgrps = []
    for meshHeader in meshHeaderData:
        header = meshHeader[0]
        words = pyFistr.deleteSp(header).split(",")
        if words[0] == "!NGROUP":
            newNgrps.append(meshHeader)
    ngrpNums = []
    for ngrp in ngrps:
        name = pyFistr.getValName(ngrp[0], "NGRP")
        ngrpNums.append([name, len(ngrp[1])])
    ngrpNums.sort()
    newNgrpNums = []
    for newNgrp in newNgrps:
        name = pyFistr.getValName(newNgrp[0], "NGRP")
        newNgrpNums.append([name, len(newNgrp[1])])
    newNgrpNums.sort()
    mess = _(u"nodeGroup内の重複節点を削除しました。" + ls)
    #削除前後のnodeGroup数をチェック
    addMess = u""
    if len(ngrpNums) == len(newNgrpNums):
        #各nodeGroupの節点の一部が削除された場合
        for i in range(len(ngrpNums)):
            name = ngrpNums[i][0]
            num = ngrpNums[i][1]
            newNum = newNgrpNums[i][1]
            delNum = num - newNum
            if delNum > 0:
                addMess += "  " + name + ":  " + str(delNum) + " /" + str(num) + _(u" 削除") + ls
    else:
        #ngrpの数が合わない場合（ngrp内の全ての節点が削除された場合）
        for ngrpNum in ngrpNums:
            flag = 0
            for newNgrpNum in newNgrpNums:
                if ngrpNum[0] == newNgrpNum[0]:
                    flag = 1
                    break
            if flag == 1:
                #節点の一部が削除された場合
                name = ngrpNum[0]
                num = ngrpNum[1]
                newNum = newNgrpNum[1]
                delNum = num - newNum
                if delNum > 0:
                    addMess += "  " + name + ":  " + str(delNum) + " /" + str(num) + _(u" 削除") + ls
            else:
                #節点全て削除されngrpが削除されている場合
                name = ngrpNum[0]
                addMess += "  " + name + ":  " + str(num) +" /" + str(num) + _(u" 全て削除!!") + ls
    if addMess == "":
        mess = _(u"削除する重複節点は、ありません。")
    else:
        mess += addMess
    return mess

#
#  initialize
#
def initialize():
    global ngrpNames, meshHeaderData, ngrps, allNgrpNames, otherNames
    #ngrpNames = ["fix", "load", "press", "xxx", "yyyy", "zzzz"]
    #メッシュファイル読み込み
    #lines = delnd.readFistrModelMsh()
    #meshHeaderDataを取得
    #meshHeaderData = pyFistr.getHeaderNumData(lines)
    meshHeaderData = pyFistr.getHeaderNumDataMsh(os.getcwd())
    #ngrp部を取得
    [ngrps, allNgrpNames] = delnd.getNgrpData(meshHeaderData)
    #overlapしているNGRP名を取得
    [overlapNames, otherNames] = delnd.getOverlapNgrpNames(ngrps, allNgrpNames)
    overlapNames.sort()
    #textBoxに表示するNGRP名を取得
    ngrpNames = overlapNames

#
#  writeFileLines
#    fileに書き込み
def writeFileLines(fileName, lines):
    f = open(fileName, "w", encoding="utf-8")
    for line in lines:
        f.write(line)
    f.close()

#---------------------------
#  deleteOverlapNodes class
#---------------------------
class deleteOverlapNodes:
    """ 重複節点を削除するdialog。
    
    Args:
        names (list):   重複しているnodeGrp名のlist
        funcName (object):  重複節点削除方法指定後の処理関数名
        funcArgs (ste):     処理関数の引数名（currDir）"""

    def __init__(self, names, funcName, funcArgs, parent=None):
        global ngrpNames
        ngrpNames = names
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.stat = "cancel"
        self.data = []
        self.dialog = dialogApp(names, parent)
        self.dialog.dialog.connect("response", self.onResponse)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_OK.connect("clicked", self.onOk)
        self.dialog.button_moveUp.connect("clicked", self.onMoveUp)
        self.dialog.button_moveDown.connect("clicked", self.onMoveDown)
        self.dialog.checkBtn_toNode.connect("toggled", self.onChangeDelMode)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onResponse(self, event, resId):
        self.onCancel(event)

    def onCancel(self, event):
        self.stat = "cancel"
        self.data = meshHeaderData
        self.close()
        currDir, path, item = self.funcArgs
        self.funcName(self.stat, self.data, currDir, path, item)

    def onOk(self, event):
        self.stat = "OK"
        self.dialog.okDeleteNodes()     #ここでGUIをcloseする
        self.data = meshHeaderData
        currDir, path, item = self.funcArgs
        self.funcName(self.stat, self.data, currDir, path, item)

    def onMoveUp(self, event):
        self.dialog.ngrpMoveUp()

    def onMoveDown(self, event):
        self.dialog.ngrpMoveDown()

    def onChangeDelMode(self, event):
        self.dialog.changeDelMode()


if __name__ == "__main__":
    import gettext
    gettext.install("app")
    _ = gettext.gettext

    initialize()
    app = dialogApp()
    Gtk.main()

