#!/usr/bin/python3
# -*- coding: UTF-8 -*-
#
#
#       deleteOverlapNodeInNgrp.py
#
#           各NGRPでダブった節点を削除
#           SGROUPとダブった節点も削除する。
#
#   18/01/02    新規作成
#      01/31    getOverlapNgrpNames:追加
#               overlapしているnodeGroup名を取得する
#      02/03    createNodeDataListDeleteEdge:追加
#               overlap部のnodeを削除（Edgeをなくす）
#      03/31    createMeshHeaderData:バグ修正
#      11/21    getOverlapNgrpNames:ngrpNamesが空の場合、空のリストを返す様に修正（バグ）
#   19/01/09    python3用に書き換え
#   20/03/22    createMeshHeaderData:バグ修正
#      03/31    getOverlapNgrpNames:ndGrpの要素が空だった場合、
#               error発生するので、修正。
#   23/04/17    readFistrModelMsh:"FistrModel.msh"を使わずにhcemw_ctrl.datから取得に変更
#   24/07/07    openにencoding="utf-8"を追加
#

import os
import pyFistr


#
#  要素typeとfaceNo（node）
#
elmFaceNo = [
    #四面体1次
    ["341", 
        #face1    face2    face3    face4
        [1,2,3], [1,2,4], [2,3,4], [3,1,4]],
    #四面体2次
    ["342", 
        [1,7,2,5,3,6], [1,7,2,9,4,8], [2,5,3,10,4,9], [3,6,1,10,4,8]],
    #六面体1次
    ["361", 
        [1,2,3,4], [5,6,7,8], [1,2,6,5], [2,3,7,6], [3,4,8,7], [4,1,5,8]],
    #六面体2次
    ["362", 
        [1,9,2,10,3,11,4,12], [5,13,6,14,7,15,8,16], [1,9,2,18,6,13,5,17], 
        [2,10,3,19,7,14,6,18], [3,11,4,20,8,15,7,19], [4,12,1,17,5,16,8,20]],
    #五面体1次
    ["351", 
        [1,2,3], [4,5,6], [1,2,5,4], [2,3,6,5], [3,1,4,6]],
    #五面体2次
    ["352", 
        [1,9,2,7,3,8], [4,12,5,10,6,11], [1,9,2,14,5,12,4,13], [2,7,3,15,6,10,5,14], 
        [3,8,1,13,4,11,6,15]]
                ]


def readFistrModelMsh():
    workDir = os.getcwd()
    FistrModel_cnt, FistrModel_msh = pyFistr.cntMshFileName(workDir)
    #fileName = "FistrModel.msh"
    fileName = FistrModel_msh
    f = open(fileName, encoding="utf-8")
    lines = f.readlines()
    f.close()
    return lines

#
#  getNgrpData
#    meshHdaerDataから!NGROUPとgrpNameを取得
def getNgrpData(meshHeaderData):
    ngrps = []
    ngrpNames = []
    for headerData in meshHeaderData:
        words = pyFistr.deleteSp(headerData[0]).split(",")
        if words[0] == "!NGROUP":
            ngrps.append(headerData)
            ngrpName = pyFistr.getValName(headerData[0], "NGRP")
            ngrpNames.append(ngrpName)
    return [ngrps, ngrpNames]

#
#  getOverlapNgrpNames
#    overlapしているngrpNamesを取得する
def getOverlapNgrpNames(ngrps, ngrpNames):
    if len(ngrpNames) == 0:
        return [[], []]
    #maxNodeNoを取得
    try:
        maxmax = []
        for ngrp in ngrps:
            maxNode = max(ngrp[1])
            maxmax.append(maxNode)
        maxNodeNo = max(maxmax)
    except:
        return [[], []]
    #配列を準備
    #nodeDataList = [[]] * (maxNodeNo+1)
    nodeDataList = [ [] for i in range(maxNodeNo+1) ]
    #ngrpNoを保存
    for ngrp in ngrps:
        #ngrpのorderNoを取得
        ngrpName = pyFistr.getValName(ngrp[0], "NGRP")
        i = 0
        for name in ngrpNames:
            if name == ngrpName:
                break
            i += 1 
        #orderNoを保存       
        nodes = ngrp[1]
        for node in nodes:
            nodeDataList[node] = nodeDataList[node] + [i]
    #overlapしているNGRPを取得
    #tempNames = [0] * len(ngrpNames)
    tempNames = [ 0 for i in range(len(ngrpNames)) ]
    for i in range(len(nodeDataList)):
        if len(nodeDataList[i]) > 1:
            for n in nodeDataList[i]:
                tempNames[n] = 1
    overlapNames = []
    otherNames = []
    i = 0
    for n in tempNames:
        if n == 1:
            overlapNames.append(ngrpNames[i])
        else:
            otherNames.append(ngrpNames[i])
        i += 1
    print 
    return [overlapNames, otherNames]

#
#  createNodeDataListFromNgrps
#    nodeDataListを作成
#    nodeNoをindexとしてngrpNoを保存
#    ngrpNoは、ngrpNamesの順。この並びを変更すると優先順位が変わる
def createNodeDataListFromNgrps(ngrps, ngrpNames):
    #maxNodeNoを取得
    maxmax = []
    for ngrp in ngrps:
        maxNode = max(ngrp[1])
        maxmax.append(maxNode)
    maxNodeNo = max(maxmax)
    #配列を準備
    #nodeDataList = [[]] * (maxNodeNo+1)
    nodeDataList = [ [] for i in range(maxNodeNo+1) ]
    #ngrpNoを保存
    for ngrp in ngrps:
        #ngrpのorderNoを取得
        ngrpName = pyFistr.getValName(ngrp[0], "NGRP")
        i = 0
        for name in ngrpNames:
            if name == ngrpName:
                break
            i += 1 
        #orderNoを保存       
        nodes = ngrp[1]
        for node in nodes:
            nodeDataList[node] = nodeDataList[node] + [i]
    #overlapしているnodeNoを削除
    for i in range(len(nodeDataList)):
        if len(nodeDataList[i]) > 1:
            nodeDataList[i].sort()
            nodeDataList[i] = [nodeDataList[i][0]]
    return nodeDataList

#
#  createNodeDataListDeleteEdge
#    nodeDataListを作成
#    nodeNoをindexとしてngrpNoを保存
#    重複部（edge）のnodeを削除（edgeをなくす）
def createNodeDataListDeleteEdge(ngrps, ngrpNames):
    #maxNodeNoを取得
    maxmax = []
    for ngrp in ngrps:
        maxNode = max(ngrp[1])
        maxmax.append(maxNode)
    maxNodeNo = max(maxmax)
    #配列を準備
    #nodeDataList = [[]] * (maxNodeNo+1)
    nodeDataList = [ [] for i in range(maxNodeNo+1) ]
    #ngrpNoを保存
    for ngrp in ngrps:
        #ngrpのorderNoを取得
        ngrpName = pyFistr.getValName(ngrp[0], "NGRP")
        i = 0
        for name in ngrpNames:
            if name == ngrpName:
                break
            i += 1 
        #orderNoを保存       
        nodes = ngrp[1]
        for node in nodes:
            nodeDataList[node] = nodeDataList[node] + [i]
    #overlapしているnodeNoを削除
    for i in range(len(nodeDataList)):
        if len(nodeDataList[i]) > 1:
            nodeDataList[i] = []
    return nodeDataList

#
#  getNodeNosFromFaceNo
#    要素で使っているnodeNoと要素type、faceNoからfaceNoに相当するnodeNoを取得
def getNodeNosFromFaceNo(elType, elNodes, faceNo):
    for elmFace in elmFaceNo:
        if elmFace[0] == elType:
            faceOrder = elmFace[faceNo]
            break
    faceNodes = []
    for orderNo in faceOrder:
        nodeNo = elNodes[orderNo-1]
        faceNodes.append(nodeNo)
    return faceNodes

#
#  getSurfaceNodes
#    surGrpで使用しているnodeNoを取得
def getSurfaceNodes(meshHeaderData):
    #otherS以外のsurGrpsを取得
    surGrps = []
    for headerData in meshHeaderData:
        words = pyFistr.deleteSp(headerData[0]).split(",")
        if words[0] == "!SGROUP":
            surName = pyFistr.getValName(headerData[0], "SGRP")
            if surName != "otherS":
                surGrps += headerData[1]
    #要素typeを取得
    #  配列を準備
    maxElNo = max(surGrps)
    #elmDataList = [[]] * (maxElNo+1)
    elmDataList = [ [] for i in range(maxElNo+1) ]
    #  要素typeを取得
    for headerData in meshHeaderData:
        words = pyFistr.deleteSp(headerData[0]).split(",")
        if words[0] == "!ELEMENT":
            elType = pyFistr.getValName(headerData[0], "TYPE")
            elData = headerData[1]
            for el in elData:
                elNo = el[0]
                if elNo <= maxElNo:
                    elmDataList[elNo] = [elType, el[1:]]
    #surGrpsのnodeNoを取得
    surNodes = []
    i = 0
    while i < len(surGrps):
        elNo = surGrps[i]
        faceNo = surGrps[i+1]
        if elNo <= maxElNo:
            elType = elmDataList[elNo][0]
            elNodes = elmDataList[elNo][1]
            nodeNos = getNodeNosFromFaceNo(elType, elNodes, faceNo)
            surNodes += nodeNos
        i += 2
    return surNodes

#
#  addNodeDataListFromSgrps
#    surGrpで使用しているnodeNoからnodeDataListを修正
def addNodeDataListFromSgrps(surNodes, nodeDataList):
    maxNodeNo = len(nodeDataList) - 1
    for surNodeNo in surNodes:
        if surNodeNo <= maxNodeNo:
            if len(nodeDataList[surNodeNo]) != 0:
                #surNodeは、nodeGrpNoを空にする
                nodeDataList[surNodeNo] = []
    return nodeDataList

#
#  createMeshHeaderData
#    nodeDataListからmesshHeaderDataを再作成する
def createMeshHeaderData(meshHeaderData, nodeDataList, ngrpNames):
    #newNgrpを作成
    #newNgrps = [[]] * len(ngrpNames)
    newNgrps = [ [] for i in range(len(ngrpNames)) ]
    #  nodeNoを取得
    for i in range(len(nodeDataList)):
        if len(nodeDataList[i]) == 1:
            #nodeNoを取得（空、複数:overlapは取得しない）
            ngrpNo = nodeDataList[i][0]
            newNgrps[ngrpNo] = newNgrps[ngrpNo] + [i]
    #  headerを設定
    for i in range(len(ngrpNames)):
        ngrpName = ngrpNames[i]
        for headerData in meshHeaderData:
            header = headerData[0]
            name = pyFistr.getValName(header, "NGRP")
            if name == ngrpName:
                #node数をチェック
                if len(newNgrps[i]) != 0:
                    newNgrps[i] = [header, newNgrps[i]]
                else:
                    #node数が空の場合は、削除
                    newNgrps[i] = ["", newNgrps[i]]
                break
    #meshHeaderDataを作成
    newMeshHeaderData = []
    for i in range(len(meshHeaderData)):
        header = meshHeaderData[i][0]
        words = pyFistr.deleteSp(header).split(",")
        if words[0] != "!NGROUP":
            newMeshHeaderData.append(meshHeaderData[i])
    if newMeshHeaderData[-1][0][:len("!END")] == "!END":
        newMeshHeaderData = newMeshHeaderData[:-1] + newNgrps + [newMeshHeaderData[-1]]
    else:
        newMeshHeaderData = newMeshHeaderData + newNgrps + [["!END", []]]
    return newMeshHeaderData


if __name__ == "__main__":
    import gettext
    gettext.install("app")

    #meshHeaderDataを取得
    #lines = readFistrModelMsh()
    #meshHeaderData = pyFistr.getHeaderNumData(lines)
    meshHeaderData = pyFistr.getHeaderNumDataMsh(os.getcwd())
    #meshHeaderData内のngrp部とngrpNameを取得
    [ngrps, ngrpNames] = getNgrpData(meshHeaderData)
    #ngrpNamesの順にnodeDataListを作成
    nodeDataList = createNodeDataListFromNgrps(ngrps, ngrpNames)
    #suGrpのnodeNoを取得
    surNodes = getSurfaceNodes(meshHeaderData)
    #nodeDataListを修正
    nodeDataList = addNodeDataListFromSgrps(surNodes, nodeDataList)
    #meshHeaderDataを再作成
    newMeshHeaderData = createMeshHeaderData(meshHeaderData, nodeDataList, ngrpNames)
    #meshDataをファイルに保存
    #pyFistr.writeFistrModelMshHeader(newMeshHeaderData)

