#!/usr/bin/python3
# -*- coding: UTF-8 -*-
#
#   commTee.py
#
#       command実行とfile出力を行う
#       linuxの場合はteeコマンドがあるが、windowsの場合は無い為作成。
#
#       commTee.py <command> <arg1> <arg2> ... <fileName>
#
#   19/01/29    新規作成
#   22/03/14    国際化
#      04/25    connTeeAdd:追加
#      09/29    bytes2unicode:追加
#               bytes(utf-8,shift-jis)をunicodeに変換する。
#               commTee:byte2unicodeに変更。
#      10/07    commTeeAdd:commTeeと同様な修正。修正漏れ。
#   24/07/07    openにencoding="utf-8"を追加
#

import sys, os
import subprocess

import gettext
localeDir = os.getenv("LOCALE_DIR")
gettext.install("easyistr", localeDir)

def printHelp():
    cont = """
----- <commTee.py> ---------------------------------------------------------
command実行とその出力をfileに出力する。
windowsでは、teeコマンドが無いため、その代用。

<使い方>
commTee.py [option] <command> [<args1> <args2> ...] <fileName>
  option
    -a          :fileに追加して出力する
  command       :実行するコマンド
  args1 ...     :コマンドの引数（省略可）
  fileName      :コマンドが出力する内容を保存するfileName

<例>
commTee.py dir test.txt
commTee.py -a dir test.txt      #test.txtに追加して出力する
"""
    print (cont)

def bytes2unicode(line):
    try:
        #utf-8に変換
        line = line.decode("utf-8")
    except:
        #shift-jisで読み込む。errorがあれば置き換える
        line = line.decode("shift-jis", errors="replace")
        #utf-8のbytes型に変換
        b = line.encode(encoding="utf-8", errors="replace")
        #utf-8に変換
        line = b.decode("utf-8")
    return line

def commTee(comms):
    comm = " ".join(comms)
    proc = subprocess.Popen(
            comm,
            shell=True,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE)
    for line in iter(proc.stdout.readline, b""):
        line = bytes2unicode(line)
        print (line, end="")
        if line[-2:] == "\r\n":
            line = line[:-2] + "\n"
        f.write(line)
        f.flush()
    #実行結果を確認
    errCont = bytes2unicode(proc.stderr.read())
    if errCont != "":
        print(errCont)
        f.write(errCont)
        f.flush()

def commTeeAdd(comms):
    """ logをfileに追加してcommを実行する。"""
    comm = " ".join(comms)
    proc = subprocess.Popen(
            comm,
            shell=True,
            stdout=subprocess.PIPE,
            stderr=subprocess.PIPE)
    #実行結果を行単位で取得
    for line in iter(proc.stdout.readline, b""):
        #line = line.decode("utf-8")
        line = bytes2unicode(line)
        print (line, end="")
        if line[-2:] == "\r\n":
            line = line[:-2] + "\n"
        f.write(line)
        f.flush()
    #実行結果を確認
    #errCont = proc.stderr.read().decode("utf-8")
    errCont = bytes2unicode(proc.stderr.read())
    if errCont != "":
        print(errCont)
        f.write(errCont)
        f.flush()

if __name__ == "__main__":
    if len(sys.argv) <= 2:
        print (_(u"引数が不足しています"))
        printHelp()
        exit()
    comms = sys.argv[1:-1]
    outFile = sys.argv[-1]
    #fileに追加して出力？
    if comms[0] == "-a" or comms[0] == "--add":
        comms = comms[1:]
        f = open(outFile, "a", encoding="utf-8")
        try:
            commTeeAdd(comms)
        except KeyboardInterrupt:
            pass
        finally:
            f.close()
    else:
        #引数エラー
        if comms[0][0] == "-":
            printHelp()
            exit()
        #結果をfileに出力する
        f = open(outFile, "w", encoding="utf-8")
        try:
            commTee(comms)
        except KeyboardInterrupt:
            pass
        finally:
            f.close()

