#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#       plotStepMonitor46.py
#
#           各stepの進捗状況をプロットする（モニタ用）
#
#       17/07/29    新規作成
#          08/23    gnuplotコマンドをusingApp内から読み込む様に修正
#          08/24    dataのprintOutを追加。
#          09/12    plotStepMonitor:「os.Popen」を「subprocess.Popen」に変更
#          11/30    plotStepMonitor:端末への出力量を減らす。
#          12/01    plotStepMonitor:端末への出力量をさらに減らす。
#       19/01/08    python3用に書き換え
#          01/14    stdin.flush()を追加
#          02/05    windows用にctrl-cで停止させる事を想定して対応
#       20/07/01    fistr-4.6用として名称変更
#          07/08    readGnuplotCommand:読み込みを辞書に変更
#   24/07/07    openにencoding="utf-8"を追加
#


import os
import time
import pyFistr
import subprocess

logFile = "0.log"
convFile = "FSTR.sta"
waitTime = 5.0

#
#  readGnuplotCommand
#    gnuplotのコマンドを取得
def readGnuplotCommand():
    appDict = pyFistr.readUsingApplications()
    runGnuplotComm = appDict["gnuplot"]
    if runGnuplotComm == "":
        runGnuplotComm = "gnuplot"
    comm = runGnuplotComm + " -p\n"
    return comm

#
#  isHeader
#    header行かどうかをcheck
def isHeader(line):
    ans = False
    words = line.split()
    if len(words) >= 3:
        if words[0] == "####" and words[1] == "Result" and words[2] == "step=":
            ans = True
    return ans

#
#  isFcHeader
#    convFileのheaderかどうかをチェック
def isFcHeader(line):
    ans = False
    words = line.split()
    if len(words) >= 3:
        if words[0] == "###" and words[1] == "Converged":
            ans = True
    return ans

#
#  getPlotData
#    plotするデータをlinesから取得
def getPlotData(lines):

    #  checkError
    #    errorCheckし、dataを修正
    def checkError(data):
        for i in range(len(data)):
            try:
                a = float(data[i])
            except:
                #errorの場合
                if data[i].find("E") < 0 and data[i].find("e") < 0:
                    #数列に「E」が抜けている場合
                    words = data[i].split("-")
                    if len(words) > 1:
                        #指数が「-」の場合
                        data[i] = "-".join(words[:-1]) + "E-" + words[-1]
                    else:
                        words = data[i].split("+")
                        if len(words) > 1:
                            #指数が「+」の場合
                            data[i] = "+".join(words[:-1]) + "E+" + words[-1]
        return data

    #変数の初期化
    dataList = []
    u1 = ""; u2 = ""; u3 = ""; data = []
    uFlag = 0
    #1行ごとに処理
    for line in lines:
        words = line.split()
        if len(words) >= 3:
            if words[0] == "####" and words[1] == "Result" and words[2] == "step=":
                u1 = ""; u2 = ""; u3 = ""; u1min = ""; u2min = ""; u3min = ""; data = []
                step = words[3]
            elif words[0] == "#####" and words[1] == "Global" and words[2] == "Summary":
               uFlag = 1
            else:
                if uFlag == 1:
                    if words[0] == "//U1":
                        u1 = words[1]; u1min = words[2]
                    elif words[0] == "//U2":
                        u2 = words[1]; u2min = words[2]
                    elif words[0] == "//U3":
                        u3 = words[1]; u3min = words[2]
                    elif words[0] == "//SMS":
                        sms = words[1]
                        uFlag = 0
                        data = [step, u1, u2, u3, u1min, u2min, u3min, sms]
                        data = checkError(data)
                        dataList.append(data)
                else:
                    pass
    return dataList

#
#  getNIteration(fcLine)
#    イタレーション回数を取得する
def getNIteration(fcLine):
    nIter = ""
    words = fcLine.split()
    for i in range(len(words)):
        if words[i] == "iter=":
            nIter = words[i+1]
            break
    return nIter

#
#  checkFullData
#    全てのdataが取得できるまで行が取り込めたかcheck
#    logFile側
def checkFullData(line, fullFlag):
    words = line.split()
    if fullFlag == 0:
        if words[0] == "#####" and words[1] == "Global":
            fullFlag += 1
    elif fullFlag == 1:
        if words[0] == "//SMS":
            fullFlag += 1
    return fullFlag

#
#  checkFullFlag_fc
#    全てのdataが取得できるまで行が取り込めたかcheck
#    staFile側
def checkFullFlag_fc(line):
    flag = 0
    words = line.split()
    if words[0] == "###" and words[1] == "Converged":
        flag = 1
    return flag

#
#  plotStepMonitor
#    logファイルを読み込みながらデータをplot
def plotStepMonitor(runGnuplotComm):

    #  skipStepHeader
    #    headerまでskipする
    def skipStepHeader():
        flag = 0
        while flag == 0:
            line = f.readline()
            if isHeader(line) == True:
                flag = 1
                break
        return line

    #  dataPlot
    #    dataを描画する
    def dataPlot(alldata, fcData):
        if len(allData) >= 2:
            g.stdin.write(b'$stepData << EOD\n')
            for data in allData:
                line = data[0] + " " + data[1] + " " + data[2] + " " + data[3] + " " + data[4] + " " + data[5] + " " + data[6] + " " + data[7] + "\n"
                g.stdin.write(line.encode())
            g.stdin.write(b"EOD\n")
            gLine = b"plot "
            gLine += b"$stepData using 1:2 with line title 'Ux max' linewidth 2, "
            gLine += b"$stepData using 1:3 with line title 'Uy max' linewidth 2, "
            gLine += b"$stepData using 1:4 with line title 'Uz max' linewidth 2, "
            gLine += b"$stepData using 1:5 with line title 'Ux min', "
            gLine += b"$stepData using 1:6 with line title 'Uy min', "
            gLine += b"$stepData using 1:7 with line title 'Uz min', "
            gLine += b"$stepData using 1:8 with line title 'mises stress max' axes x1y2\n"
            g.stdin.write(gLine)
            g.stdin.flush()         #入力データの吐き出し

        if len(fcData) >= 2:
            gs.stdin.write(b"$stepData << EOD\n")
            nData = len(fcData)
            for i in range(nData):
                line = str(i+1) + " " + fcData[i][0] + " " + fcData[i][1] + " " + fcData[i][2] + "\n"
                gs.stdin.write(line.encode())
            gs.stdin.write(b"EOD\n")
            gLine = b"plot "
            gLine += b"$stepData using 1:2 with line title 'residual(1)' linewidth 2, "
            gLine += b"$stepData using 1:3 with line title 'residual(2)' linewidth 2, "
            gLine += b"$stepData using 1:4 with line title 'number of iteration'\n"
            gs.stdin.write(gLine)
            gs.stdin.flush()        #入力データの吐き出し

    #
    #  データプロット
    #        
    #gnuplotを起動
    g = subprocess.Popen(runGnuplotComm, shell=True, stdin=subprocess.PIPE)
    g.stdin.write(b"set ytics nomirror\n")
    g.stdin.write(b"set y2tics\n")
    g.stdin.write(b"set grid\n")
    g.stdin.write(b"set xlabel 'step'\n")
    g.stdin.write(b"set ylabel 'DISPLACEMENT'\n")
    g.stdin.write(b"set y2label 'mises stress'\n")
    gs = subprocess.Popen(runGnuplotComm, shell=True, stdin=subprocess.PIPE)
    gs.stdin.write(b"set logscale y\n")
    gs.stdin.write(b"set grid\n")
    gs.stdin.write(b"set format y '%.1E'\n")
    gs.stdin.write(b"set xlabel 'step'\n")
    gs.stdin.write(b"set ylabel 'residual, number of iteration'\n")
    #logファイルをopen
    f = open(logFile, encoding="utf-8")
    fc = open(convFile, encoding="utf-8")
    #変数の初期化
    allData = []; fcData = []
    lines = []; fcLines = []
    fullFlag = 0; plotFlag = 0
    n = 0
    pLine = ""
    #logファイルを読み込みながらdataをplot
    while n == 0:
        #1行読み込み
        line = f.readline()
        fcLine = fc.readline()
        #logFileの処理
        if line != "":
            #読み込めた場合処理
            lines.append(line)
            #全てのdataが取得できる行が取得できたかcheck
            fullFlag = checkFullData(line, fullFlag)
            if fullFlag == 2:
                #dataを取得
                data = getPlotData(lines)
                #print "f:" + " ".join(data[0])
                pLine += "f" + data[0][0] + " "
                allData += data
                #flagをクリア
                lines = []
                fullFlag = 0
                plotFlag = 1
        #convFileの処理
        if fcLine != "":
            fullFlag_fc = checkFullFlag_fc(fcLine)
            if fullFlag_fc == 1:
                #残渣データを取得
                words = fcLines[-1].split()
                res1 = words[-2]
                res2 = words[-1]
                #fcLineからイタレーション回数を取得
                nIter = getNIteration(fcLine)
                data = [res1, res2, nIter]
                #print "fc:" + str(len(fcData)+1) + " " + " ".join(data)
                pLine += "fc" + str(len(fcData)+1) + " "
                fcData.append(data)
                fcLines = []
            else:
                fcLines.append(fcLine)
        #dataPlot
        if line == "" and fcLine == "":
            #行が読み込めなかった場合
            if plotFlag == 1:
                #グラフを描画し、描画flagをクリア
                dataPlot(allData, fcData)
                if len(pLine) > 5000:
                    print ("..." + pLine[-5000:])
                else:
                    print (pLine)
                plotFlag = 0
                pLine = ""
            #waitする
            time.sleep(waitTime)
    f.close()
    fc.close()

if __name__ == '__main__':
    runGnuplotComm = readGnuplotCommand()
    try:
        plotStepMonitor(runGnuplotComm)
    except:
        exit()
    

