#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#       plotStepMonitor.py
#
#           各stepの進捗状況をプロットする（モニタ用）
#
#       17/07/29    新規作成
#          08/23    gnuplotコマンドをusingApp内から読み込む様に修正
#          08/24    dataのprintOutを追加。
#          09/12    plotStepMonitor:「os.Popen」を「subprocess.Popen」に変更
#          11/30    plotStepMonitor:端末への出力量を減らす。
#          12/01    plotStepMonitor:端末への出力量をさらに減らす。
#       19/01/08    python3用に書き換え
#          01/14    stdin.flush()を追加
#          02/05    windows用にctrl-cで停止させる事を想定して対応
#       20/04/15    FrontISTR-5用に書き換え
#          04/19    readGnuplotCommand:起動optionを修正。
#                   閉じても「gnuplot_qt」が残ってしまう為。
#          07/08    readGnuplotCommand:読み込みを辞書に変更
#       24/07/07    openにencoding="utf-8"を追加
#


import os
import time
import pyFistr
import subprocess

logFile = "0.log"
convFile = "FSTR.sta"
waitTime = 5.0

#
#  readGnuplotCommand
#    gnuplotのコマンドを取得
def readGnuplotCommand():
    appDict = pyFistr.readUsingApplications()
    runGnuplotComm = appDict["gnuplot"]
    if runGnuplotComm == "":
        runGnuplotComm = "gnuplot"
    #comm = runGnuplotComm + " -p\n"
    comm = runGnuplotComm + "\n"
    return comm

#
#  isHeader
#    header行かどうかをcheck
def isHeader(line):
    ans = False
    words = line.split()
    if len(words) >= 3:
        if words[0] == "####" and words[1] == "Result" and words[2] == "step=":
            ans = True
    return ans

#
#  isFcHeader
#    convFileのheaderかどうかをチェック
def isFcHeader(line):
    ans = False
    words = line.split()
    if len(words) >= 3:
        if words[0] == "###" and words[1] == "Converged":
            ans = True
    return ans

#
#  getPlotData
#    plotするデータをlinesから取得
def getPlotData(lines):

    #  checkError
    #    errorCheckし、dataを修正
    def checkError(data):
        for i in range(len(data)):
            try:
                float(data[i])
            except:
                #errorの場合
                if data[i].find("E") < 0 and data[i].find("e") < 0:
                    #数列に「E」が抜けている場合
                    words = data[i].split("-")
                    if len(words) > 1:
                        #指数が「-」の場合
                        data[i] = "-".join(words[:-1]) + "E-" + words[-1]
                    else:
                        words = data[i].split("+")
                        if len(words) > 1:
                            #指数が「+」の場合
                            data[i] = "+".join(words[:-1]) + "E+" + words[-1]
        return data

    #変数の初期化
    dataList = []
    u1 = ""; u2 = ""; u3 = ""; data = []
    uFlag = 0
    #1行ごとに処理
    for line in lines:
        words = line.split()
        if len(words) >= 4:
            if words[0] == "####" and words[1] == "Result" and words[2] == "step=":
                u1 = ""; u2 = ""; u3 = ""; u1min = ""; u2min = ""; u3min = ""; data = []
                step = words[3]
            elif words[0] == "#####" and words[1] == "Global" and words[2] == "Summary" and words[3] == "@Node":
               uFlag = 1
            else:
                if uFlag == 1:
                    if words[0] == "//U1":
                        #u1 = words[1]; u1min = words[2]
                        u1 = words[1]; u1min = words[3]
                    elif words[0] == "//U2":
                        #u2 = words[1]; u2min = words[2]
                        u2 = words[1]; u2min = words[3]
                    elif words[0] == "//U3":
                        #u3 = words[1]; u3min = words[2]
                        u3 = words[1]; u3min = words[3]
                    elif words[0] == "//SMS":
                        sms = words[1]
                        uFlag = 0
                        data = [step, u1, u2, u3, u1min, u2min, u3min, sms]
                        data = checkError(data)
                        dataList.append(data)
                else:
                    pass
    return dataList

#
#  getNIteration(fcLine)
#    イタレーション回数を取得する
def getNIteration(fcLine):
    nIter = ""
    words = fcLine.split()
    for i in range(len(words)):
        if words[i] == "iter=":
            nIter = words[i+1]
            break
    return nIter

#
#  checkFullData
#    全てのdataが取得できるまで行が取り込めたかcheck
#    logFile側
def checkFullData(line, fullFlag):
    words = line.split()
    if fullFlag == 0:
        if words[0] == "#####" and words[1] == "Global" and words[2] == "Summary" and words[3] == "@Node":
            fullFlag += 1
    elif fullFlag == 1:
        if words[0] == "//SMS":
            fullFlag += 1
    return fullFlag

#
#  checkFullFlag_fc
#    全てのdataが取得できるまで行が取り込めたかcheck
#    staFile側
def checkFullFlag_fc(line):
    flag = 0
    words = line.split()
    if len(words) >= 10 and words[3] == "S":
        flag = 1
    return flag

#
#  plotStepMonitor
#    logファイルを読み込みながらデータをplot
def plotStepMonitor(runGnuplotComm):

    #  dataPlot
    #    dataを描画する
    def dataPlot(alldata, fcData):
        if len(allData) >= 2:
            g.stdin.write(b'$stepData << EOD\n')
            for data in allData:
                line = data[0] + " " + data[1] + " " + data[2] + " " + data[3] + " " + data[4] + " " + data[5] + " " + data[6] + " " + data[7] + "\n"
                g.stdin.write(line.encode())
            g.stdin.write(b"EOD\n")
            gLine = b"plot "
            gLine += b"$stepData using 1:2 with line title 'Ux max' linewidth 2, "
            gLine += b"$stepData using 1:3 with line title 'Uy max' linewidth 2, "
            gLine += b"$stepData using 1:4 with line title 'Uz max' linewidth 2, "
            gLine += b"$stepData using 1:5 with line title 'Ux min', "
            gLine += b"$stepData using 1:6 with line title 'Uy min', "
            gLine += b"$stepData using 1:7 with line title 'Uz min', "
            gLine += b"$stepData using 1:8 with line title 'mises stress max' axes x1y2\n"
            g.stdin.write(gLine)
            g.stdin.flush()         #入力データの吐き出し

        if len(fcData) >= 2:
            gc.stdin.write(b"$stepData << EOD\n")
            nData = len(fcData)
            for i in range(nData):
                line = " ".join([str(i+1)] + fcData[i]) + "\n"
                gc.stdin.write(line.encode())
            gc.stdin.write(b"EOD\n")
            gLine = b"plot "
            gLine += b"$stepData using 1:2 with line title 'maxIter' linewidth 2, "
            gLine += b"$stepData using 1:3 with line title 'sumIter' linewidth 2, "
            gLine += b"$stepData using 1:4 with line title 'contIter' linewidth 2, "
            gLine += b"$stepData using 1:5 with line title 'incTime' axes x1y2\n"
            gc.stdin.write(gLine)
            gc.stdin.flush()


    # #  dataRelot
    # #    dataを描画する
    # def dataReplot(alldata):
    #     if len(allData) >= 2:
    #         g.stdin.write(b'$stepData << EOD\n')
    #         for data in allData:
    #             line = data[0] + " " + data[1] + " " + data[2] + " " + data[3] + " " + data[4] + " " + data[5] + " " + data[6] + " " + data[7] + "\n"
    #             g.stdin.write(line.encode())
    #         g.stdin.write(b"EOD\n")
    #         gLine = b"replot "
    #         gLine += b"$stepData using 1:2 with line title 'Ux max' linewidth 2, "
    #         gLine += b"$stepData using 1:3 with line title 'Uy max' linewidth 2, "
    #         gLine += b"$stepData using 1:4 with line title 'Uz max' linewidth 2, "
    #         gLine += b"$stepData using 1:5 with line title 'Ux min', "
    #         gLine += b"$stepData using 1:6 with line title 'Uy min', "
    #         gLine += b"$stepData using 1:7 with line title 'Uz min', "
    #         gLine += b"$stepData using 1:8 with line title 'mises stress max' axes x1y2\n"
    #         g.stdin.write(gLine)
    #         g.stdin.flush()         #入力データの吐き出し


    #
    #  データプロット
    #        
    #gnuplotを起動
    g = subprocess.Popen(runGnuplotComm, shell=True, stdin=subprocess.PIPE)
    g.stdin.write(b"set ytics nomirror\n")
    g.stdin.write(b"set y2tics\n")
    g.stdin.write(b"set grid\n")
    g.stdin.write(b"set xlabel 'step'\n")
    g.stdin.write(b"set ylabel 'DISPLACEMENT'\n")
    g.stdin.write(b"set y2label 'mises stress'\n")
    gc = subprocess.Popen(runGnuplotComm, shell=True, stdin=subprocess.PIPE)
    gc.stdin.write(b"set ytics nomirror\n")
    gc.stdin.write(b"set y2tics\n")
    gc.stdin.write(b"set logscale y\n")
    gc.stdin.write(b"set logscale y2\n")
    gc.stdin.write(b"set grid\n")
    #gc.stdin.write(b"set format y2 '%.1E'\n")
    gc.stdin.write(b"set xlabel 'step'\n")
    gc.stdin.write(b"set ylabel 'number of iteration'\n")
    gc.stdin.write(b"set y2label 'inc time'\n")
    #logファイルをopen
    f = open(logFile, encoding="utf-8")
    fc = open(convFile, encoding="utf-8")
    #変数の初期化
    allData = []; fcData = []
    lines = []
    fullFlag = 0; plotFlag = 0
    n = 0
    pLine = ""
    #logファイルを読み込みながらdataをplot
    while n == 0:
        #1行読み込み
        line = f.readline()
        fcLine = fc.readline()
        #logFileの処理
        if line != "":
            #読み込めた場合処理
            lines.append(line)
            #全てのdataが取得できる行が取得できたかcheck
            fullFlag = checkFullData(line, fullFlag)
            if fullFlag == 2:
                #dataを取得
                data = getPlotData(lines)
                pLine += "f" + data[0][0] + " "
                allData += data
                #flagをクリア
                lines = []
                fullFlag = 0
                plotFlag = 1
        #convFileの処理
        if fcLine != "":
            fullFlag_fc = checkFullFlag_fc(fcLine)
            if fullFlag_fc == 1:
                #iterを読込
                words = fcLine.split()
                contIter = words[4]
                maxIter = words[5]
                totalIter = words[6]
                incTime = words[8]
                data = [maxIter, totalIter, contIter, incTime]
                pLine += "fc" + str(len(fcData)+1) + " "
                fcData.append(data)
        #dataPlot
        if line == "" and fcLine == "":
            #行が読み込めなかった場合
            if plotFlag == 1:
                #グラフを描画し、描画flagをクリア
                dataPlot(allData, fcData)
                if len(pLine) > 5000:
                    print ("..." + pLine[-5000:])
                else:
                    print (pLine)
                plotFlag = 0
                pLine = ""
            #waitする
            time.sleep(waitTime)
    f.close()
    fc.close()


if __name__ == '__main__':
    runGnuplotComm = readGnuplotCommand()
    #plotStepMonitor(runGnuplotComm)

    try:
        plotStepMonitor(runGnuplotComm)
    except:
        exit()
    

