#!/usr/bin/python3
#  coding: utf-8
#
#       mergeResFiles.py
#
#           rmergeを使ってresFileをmergeする
#
#   23/01/12    新規作成
#

import os, sys
import glob
import multiprocessing
import subprocess
import pyFistr

#
#  mergeFiles
#-------------
def mergeFiles(resFileHeader, para, nCpu):
    """ resFile全てをmergeする"""
    #結果fileがあるか確認
    names = glob.glob(resFileHeader + ".res.1*") 
    if len(names) == 0:
        mess = _("並列処理した計算結果ではありません")
        return
    #step数を取得
    steps = []
    for name in names:
        step = name.split(".")[-1]
        stepNum = int(step)
        steps.append([stepNum, step])
    steps.sort()
    #merge開始
    #singleコア?
    if para == "no":
        for step in steps:
            stepName = step[1]
            values = [resFileHeader, stepName]
            res = merge1File(values)
    #並列処理？
    else:
        valueList = []
        for step in steps:
            stepName = step[1]
            value = [resFileHeader, stepName]
            valueList.append(value)
        p = multiprocessing.Pool(int(nCpu))
        res = p.map(merge1File, valueList)

#
#  merge1File
#-------------
def merge1File(values):
    """ 指定したstepのrefFileをmergeする"""
    (resFileHeader, stepName) = values
    comm = "rmerge -s " + stepName + " -e " + stepName + " -i 1 " + resFileHeader + ".res.merge"
    print("merge step " + stepName + " ...", flush=True)
    subprocess.run(
        comm,
        shell=True,
        stdout=subprocess.DEVNULL,
        stderr=subprocess.PIPE)
    return stepName

#
#  getOption
#-------------
def getOption():
    """ 引数を取得"""
    resFileHeader = ""
    para = "no"
    nCpu = "1"
    i = 1
    while i < len(sys.argv):
        if sys.argv[i] == "-res":
            i += 1
            resFileHeader = sys.argv[i]
        elif sys.argv[i] == "-para":
            i += 1
            para = sys.argv[i]
        elif sys.argv[i] == "-np":
            i += 1
            nCpu = sys.argv[i]
        i += 1
    return (resFileHeader, para, nCpu)

if __name__ == "__main__":
    resFileHeader, para, nCpu = getOption()
    mergeFiles(resFileHeader, para, nCpu)
