#!/usr/bin/python3
# _*_ doding: utf-8 _*_
#
#   getDisplacement.py
#
#       nodeGroupの変位を出力する
#
#   19/09/23    新規作成
#   22/03/15    国際化
#   24/07/07    openにencoding="utf-8"を追加
#

import sys, os
import glob
import convertMesh as cm
import fistr2vtk

def helpMsg():
    """ helpMessageを出力"""
    cont = """
"""
    print(cont)

def deleteSp(line):
    line = line.replace(" ", "").replace("\n", "")
    return line

def readFileLines(fileName):
    f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
    return lines

def getMeshConts(meshFile):
    lines = readFileLines(meshFile)
    meshConts = cm.getFistrHeaderNumData(lines)
    return meshConts

def addNewNodeNo(nodeList):
    newNo = 0
    for i in range(len(nodeList)):
        if len(nodeList[i]) != 0:
            nodeList[i].append(newNo)
            newNo += 1
    return nodeList

def getNewNodeNoOfNodeGrp(nodeGrp, nodeList):
    newGrp = []
    for node in nodeGrp[1]:
        newNo = nodeList[node][-1]
        newGrp.append(newNo)
    nodeGrp[1] = newGrp
    return nodeGrp

def getNumberOfNodes(meshHeaderConts):
    nNode = 0
    for meshCont in meshHeaderConts:
        header = meshCont[0]
        words = deleteSp(header).split(",")
        if words[0].upper() == "!NODE":
            nNode += len(meshCont[1])
    return nNode

def getNodeGrp(meshHeaderNumConts, nodeGrpName):
    nodeGrp = []
    for meshCont in meshHeaderNumConts:
        header = meshCont[0]
        words = deleteSp(header).split(",")
        if words[0].upper() == "!NGROUP":
            grpName = cm.getValName(header, "NGRP")
            if grpName == nodeGrpName:
                nodeGrp = [grpName, meshCont[1]]
                break
    return nodeGrp

def getResNodeValues(resFile, nNodes):
    """ 結果ファイル内の全nodalValueを取得する"""
    lines = readFileLines(resFile)
    (nodeFields, _i) = fistr2vtk.getNodalResults(lines, 3, nNodes)
    nodeVals = []
    for nodeField in nodeFields:
        nodeVals.append([nodeField[0], nodeField[1:]])
    return nodeVals

def getDisplacementValue(dispVals, nodeGrp):
    """ nodeGrpのdisplacementを取得"""
    disps = []
    for node in nodeGrp[1]:
        disp = dispVals[1][node].split()
        disps.append(disp)
    return disps

#
#  getDisplacement
#
def getDisplacement(nodeGrpName, fileHeader, num):
    """ 変位を取得する"""
    #エラーチェック
    if fileHeader == "":
        meshFile = "FistrModel.msh"
    else:
        meshFile = ".".join(fileHeader.split(".")[:-2]) + ".msh"
    #if len(glob.glob(meshFile)) == 0:
    if os.path.exists(meshFile) == False:
        print (_("メッシュファイルが存在しません"))
        return
    if fileHeader == "":
        resFiles = glob.glob("FistrModel.res.merge.*")
        if len(resFiles) == 0:
            resFiles = glob.glob("FistrModel.res.0.*")
            if len(resFiles) == 0:
                print (_("結果ファイルが存在しません"))
                return
    else:
        resFiles = glob.glob(fileHeader + ".*")
        if len(resFiles) == 0:
            print (_("結果ファイルが存在しません"))
            return
    numResFiles = []
    flag = 0
    for resFile in resFiles:
        try:
            num = float(resFile.split(".")[-1])
            numResFiles.append([num, resFile])
        except:
            print (_("結果ファイル名が間違っています。"))
            flag = 1
    if flag == 1:
        return
    numResFiles.sort()
    if num == "":
        resFile = numResFiles[-1][1]
    else:
        resFile = ""
        for numResFile in numResFiles:
            if float(num) == numResFile[0]:
                resFile = numResFile[1]
                break
        if resFile == "":
            print(_("num に対応する結果ファイルが存在しません"))
            return

    print()
    print("getting displacement of '" + nodeGrpName + "'...")
    meshHeaderNumConts = getMeshConts(meshFile)
    (nodeList, _elmList) = cm.getFistrMeshConts(meshHeaderNumConts)
    nodeList = addNewNodeNo(nodeList)
    nodeGrp = getNodeGrp(meshHeaderNumConts, nodeGrpName)
    if len(nodeGrp) == 0:
        print("nodeGroup '" + nodeGrpName + _("' は存在しません"))
        return
    nodeNos = nodeGrp[1]
    nodeGrp = getNewNodeNoOfNodeGrp(nodeGrp, nodeList)
    nNodes = getNumberOfNodes(meshHeaderNumConts)
    nodalVals = getResNodeValues(resFile, nNodes)
    dispVals = []
    for vals in nodalVals:
        header = vals[0]
        words = header.split()
        if words[0] == "DISPLACEMENT":
            dispVals = vals
            break
    if len(dispVals) == 0:
        print(resFile + _(" 内に「DISPLACEMENT」のデータがありません"))
    else:
        nodeDispVals = getDisplacementValue(dispVals, nodeGrp)
        nodeLocs = []
        for nodeNo in nodeNos:
            nodeLocs.append(nodeList[int(nodeNo)][0])
        print("nodeNo locx locy, locz dispx dispy dispz")
        for i in range(len(nodeNos)):
            words = [str(nodeNos[i])]
            words += list(map(str, nodeLocs[i]))
            words += nodeDispVals[i]
            line = " ".join(words)
            print(line)

#
#  getArgument
#
def getArgument():
    """ argumentを取得"""
    nodeGrpName = ""
    fileHeader = ""
    num = ""
    flagHeader = 0
    flagNum = 0
    for i in range(1, len(sys.argv)):
        if sys.argv[i][0] == "-":
            if sys.argv[i] == "-h" or sys.argv[i] == "--help":
                nodeGrpName = ""
                break
            elif sys.argv[i] == "-header":
                flagHeader = 1
            elif sys.argv[i] == "-n" or sys.argv[i] == "--num":
                flagNum = 1
            else:
                print (_(u"「") + sys.argv[i] + _(u"」は、不明なoptionです。"))
                nodeGrpName = ""
                break
        else:
            if flagHeader == 1:
                fileHeader = sys.argv[i]
            elif flagNum == 1:
                num = sys.argv[i]
            else:
                nodeGrpName = sys.argv[i]
    return (nodeGrpName, fileHeader, num)


if __name__ == "__main__":
    import gettext
    gettext.install("easyistr", os.getenv("LOCALE_DIR"))
    if len(sys.argv) == 1:
        helpMsg()
        exit()
    (nodeGrpName, fileHeader, num) = getArgument()
    if nodeGrpName == "":
        helpMsg()
        exit()
    #if num == "":
    #    helpMsg()
    #    exit()
    getDisplacement(nodeGrpName, fileHeader, num)
