#!/usr/bin/python3
# -*- coding: utf-8 -*-    
#
#   createFreqResponseFile.py
#
#       「0.log」の内容からsamplingPointの応答結果を取得してcsvに変換する。
#
#
#   15/10/27    新規作成
#      12/25    行末コードlsを修正
#   19/01/22    python3用に書き換え
#   22/03/15    国際化
#

import os

fileName = "0.log"      #読み込むfileName
ls = os.linesep

def readLogFile(fileName):
    f=open(fileName)
    lines = f.readlines()
    f.close()
    return lines

#
#  getResponseCont
#    responseのみ抽出
def getResponseCont(lines):
    i = 0
    sp = 0
    while i < len(lines):
        line = lines[i]
        if line.find("monitor nodeid=") >= 0:
            sp = i + 1
            break
        i += 1
    if sp == 0:
        return []

    flag = 0
    newLines = []
    i = sp
    while i < len(lines):
        words = lines[i].split()
        try:
            a = float(words[0])
        except:
            #終了
            flag = 1
            break
        if flag == 0:
            newLines.append(lines[i])
        i += 2
    return newLines

#
#  writeCsvFile
#    csvFile作成
def writeCsvFile(lines):
    f=open("resFrequencyResponse.csv", "w")
    f.write('"freq","response"' + ls)
    for line in lines:
        words = line.split()
        newLine = words[0] + "," + words[-1] + ls 
        f.write(newLine)
    f.close()


if __name__ == "__main__":
    import gettext
    gettext.install("easyistr", os.getenv("LOCALE_DIR"))

    lines = readLogFile(fileName)
    lines = getResponseCont(lines)
    writeCsvFile(lines)
    print ()
    print (_(u"「0.log」ファイルから、周波数応答結果ファイル「resFrequencyResponse.csv」を作成しました。"))


