#!/usr/bin/python3
#  coding: utf-8
#
#           switchGtk.py
#
#       Gtkの初期化、起動、閉じるをGtkのversionに応じて処理する。
#       （Gtk3 or Gtk4のいずれかで処理）
#
#   24/05/13    新規作成
#

import getGtkVersion                #Gtk4, Gtk3をimportする
gtkVer = getGtkVersion.gtkVer       #importできたGtkのversionを取得
from gi.repository import Gtk

#global変数を定義
GtkApp = ""
builder = ""
mainWindow = ""

#
#  init
#--------
def init(parent, ui_name, id_name):
    """ 初期化（__init__）部分
    GtkApp, builder, mainWindowの変数を定義。"""
    global gtkVer
    if gtkVer == "4.0":
        initGtk4(parent, ui_name, id_name)
    elif gtkVer == "3.0":
        initGtk3(parent, ui_name, id_name)
    else:
        print("Error: Gtk is not imported !!")

#
#  show
#-------
def show():
    """ GUIを表示する"""
    global gtkVer
    if gtkVer == "4.0":
        showGtk4()
    elif gtkVer == "3.0":
        showGtk3()
    else:
        print("Error: Gtk is not imported !!")

#
#  run
#-------
def run():
    """ Gtkアプリを起動する。"""
    global gtkVer
    if gtkVer == "4.0":
        runGtk4()
    elif gtkVer == "3.0":
        runGtk3()
    else:
        print("Error: Gtk is not imported !!")
    
#
#  close
#--------
def close():
    """ Gtkアプリを閉じる"""
    global gtkVer
    if gtkVer == "4.0":
        closeGtk4()
    elif gtkVer == "3.0":
        closeGtk3()
    else:
        print("Error: Gtk is not imported !!")


#------------ Gtk4 ---------------------
#  initGtk4
def initGtk4(parent, ui_name, id_name):
    """ Gtk4用の初期化（GtkApp、builder、mainWindowの定義、GUI表示）"""
    global GtkApp, builder, mainWindow
    GtkApp = Gtk.Application()
    builder = Gtk.Builder(parent)
    builder.add_from_file(ui_name)
    mainWindow = builder.get_object(id_name)
    #GtkApp.connect("activate", on_activateGtk4)
    
#
#  showGtk4
def showGtk4():
    """ Gtk4用のGUI表示"""
    
    def on_activateGtk4(*args):
        """ GUI表示部分"""
        global mainWindow
        mainWindow.set_application(GtkApp)
        mainWindow.present()
    
    global GtkApp
    GtkApp.connect("activate", on_activateGtk4)
    
#
#  runGtk
def runGtk4():
    """ Gtk4用の起動処理"""
    global GtkApp
    GtkApp.run()
    
#
#  closeGtk4
def closeGtk4(*args):
    """ Gtk4用のclose"""
    global GtkApp
    GtkApp.quit()
    

#----------- Gtk3 --------------------------
#  initGtk3
def initGtk3(parent, ui_name, id_name):
    """ Gtk3用の初期化"""
    global GtkApp, builder, mainWindow
    GtkApp = Gtk
    builder = Gtk.Builder()
    builder.add_from_file(ui_name)
    mainWindow = builder.get_object(id_name)
    mainWindow.connect("delete-event", closeGtk3)
    builder.connect_signals(parent)
    #mainWindow.show_all()

#
#  showGtk3
def showGtk3():
    global mainWindow
    mainWindow.show_all()

#
#  runGtk3
def runGtk3():
    """ Gtk3用の起動処理"""
    global GtkApp
    GtkApp.main()
    
#
#  closeGtk3
def closeGtk3(*args):
    """ Gtk3用のclose処理"""
    global GtkApp
    GtkApp.main_quit()
    

