#!/usr/bin/python3
#  coding: utf-8
#
#           showContentsDDialog.py
#
#       スクロールバー付きのmessageDialog。
#
#   25/01/05    新規作成
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys

localeDir = os.getenv("LOCALE_DIR")

#----------------------
#  showMessage class
#----------------------
class showMessage:
    """ スクロールバー付きのmessageDialog"""

    def __init__(self, contents, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "showContentsDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.dialog.set_title(_("message"))
        self.contents = contents
        self.setGtkObject()

    def setGtkObject(self):
        self.label_conts = self.builder.get_object("label_conts")
        self.label_conts.set_text(self.contents)

    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.close()

    def onClose(self, event):
        self.close()


    