#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   logFileCreater.py
#
#       log作成用
#       環境変数$LogFileからfile名を取得し、そのfileをstdout、stderrに設定する
#
#   13/12/15    新規作成
#   14/06/24    標準出力をfileとterminal両方に設定
#   15/02/08    標準出力を元に戻す「term()」を追加。
#               標準出力をfileとterminal両方に設定し直す。
#   19/08/16    python3用に書き換え。newFileLogクラスにflushを追加
#               new, log:logFile有無チェック方法を修正
#   21/08/21    fileOpen時にencoding="utf-8"を追加
#               書き込みエラーが発生する事があった為。
#   22/04/11    easyIstr様に整理
#


import os
import glob
import sys

terminal = sys.__stdout__


#---------------------
#  mewFileLog class
#---------------------
class newFileLog():

    def __init__(self, fileName):
        self.logFile = fileName
        f=open(self.logFile, "w", encoding="utf-8")
        f.close()
    
    def write(self, string):
        #if type(string) == unicode:
        #    string = string.encode("utf-8")
        f=open(self.logFile, "a", encoding="utf-8")
        f.write(string)
        f.close()
        #comm = "echo -n '" + string + "' >> " + self.logFile
        #os.system(comm)
        terminal.write(string)

    def flush(self):
        terminal.flush()


#---------------------
#  addFileLog class
#---------------------
class addFileLog():

    def __init__(self, fileName):
        self.logFile = fileName
        #if len(glob.glob(self.logFile)) == 0:
        if os.path.exists(self.logFile) == False:
            f=open(self.logFile, "w", encoding="utf-8")
            f.close()

    def write(self, string):
        #if type(string) == unicode:
        #    string = string.encode("utf-8")
        f=open(self.logFile, "a", encoding="utf-8")
        f.write(string)
        f.close()
        #comm = "echo -n '" + string + "' >> " + self.logFile
        #os.system(comm)
        terminal.write(string)

    def flush(self):
        pass



#-------- 外から使用する関数 --------------------

#
#  new
#------------
def new():
    """
    新規にlogFile作成し、logを記録
    logFileは、環境変数で受け継ぐ
    """
    logFile = os.getenv("LogFile")
    #if logFile != os.environ["HOME"]:
    if not (logFile == None or logFile == ""):
        redirect = newFileLog(logFile)
        sys.stdout = redirect
        sys.stderr = redirect

#
#  log
#-----------
def log():
    """
    logFileにlogを追加
    """
    logFile = os.getenv("LogFile")
    #importするタイミングによって、logFileが$HOME or fileの場合がある
    #if logFile != os.environ["HOME"] and os.path.isfile(logFile) == True:
    if not (logFile == None or logFile == ""):
        redirect = addFileLog(logFile)
        sys.stdout = redirect
        sys.stderr = redirect

#
#  term
#------------
def term():
    """
    標準出力を元に戻す
    """
    sys.stdout = sys.__stdout__
    sys.stderr = sys.__stderr__

