#!/usr/bin/python3
#  coding: utf-8
#
#       inputMaterialContSigmaDDialog.py
#
#           非線形材料データの入力dialog
#
#   22/04/13    新規作成
#   24/05/25    inputMaterialCont:クラスを追加
#      06/09    dialogApp:parentを追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
import os, sys

ls = "\n"

#--------------------
#  dialogApp class
#--------------------
class dialogApp:
    """ 非線形材料データの入力dialog"""

    def __init__(self, matModelTypeHard, labelNames, mat3Vals, conts=[], parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "inputMaterialContSigmaDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.matModel = matModelTypeHard[0]
        self.matType = matModelTypeHard[1]
        self.matHard = matModelTypeHard[2]
        self.labelNames = labelNames
        self.mat3Vals = mat3Vals
        self.conts = conts
        self.stat = "CANCEL"
        #初期化
        self.initilize()

    #  show
    def show(self):
        self.dialog.show()

    #  close
    def close(self, *args):
        self.dialog.destroy()

    #
    #  setGtkObject
    #----------------
    def setGtkObject(self):
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        self.label_subTitle = self.builder.get_object("label_subTitle")
        self.label_name0 = self.builder.get_object("label_name0")
        self.label_name1 = self.builder.get_object("label_name1")
        self.label_name2 = self.builder.get_object("label_name2")
        self.entry_val0 = self.builder.get_object("entry_val0") 
        self.entry_val1 = self.builder.get_object("entry_val1") 
        self.entry_val2 = self.builder.get_object("entry_val2")
        self.label_cont0 = self.builder.get_object("label_cont0")
        self.label_cont1 = self.builder.get_object("label_cont1")
        self.label_cont2 = self.builder.get_object("label_cont2")
        #文字を追加
        self.builder.get_object("button_ok").get_child().set_text("OK")
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))

    #
    #  initilize
    #------------
    def initilize(self):
        """ 初期化"""
        #title設定
        self.dialog.set_title(_("材料定数の設定"))
        mess = self.matModel + ls + self.matType + ls + self.matHard
        self.label_subTitle.set_text(mess)
        #各項目名を設定
        if self.labelNames[0] != "":
            self.label_name0.set_sensitive(True)
            self.entry_val0.set_sensitive(True)
            self.label_name0.set_text(self.labelNames[0])
            self.entry_val0.set_text(self.mat3Vals[0])
        else:
            self.label_name0.set_text("")
            self.entry_val0.set_text("")
            self.label_name0.set_sensitive(False)
            self.entry_val0.set_sensitive(False)
        
        if self.labelNames[1] != "":
            self.label_name1.set_sensitive(True)
            self.entry_val1.set_sensitive(True)
            self.label_name1.set_text(self.labelNames[1])
            self.entry_val1.set_text(self.mat3Vals[1])
        else:
            self.label_name1.set_text("")
            self.entry_val1.set_text("")
            self.label_name1.set_sensitive(False)
            self.entry_val1.set_sensitive(False)
            
        if self.labelNames[2] != "":
            self.label_name2.set_sensitive(True)
            self.entry_val2.set_sensitive(True)
            self.label_name2.set_text(self.labelNames[2])
            self.entry_val2.set_text(self.mat3Vals[2])
        else:
            self.label_name2.set_text("")
            self.entry_val2.set_text("")
            self.label_name2.set_sensitive(False)
            self.entry_val2.set_sensitive(False)

        #各項目の内容を設定
        self.label_cont0.set_text(self.conts[0])
        self.label_cont1.set_text(self.conts[1])
        self.label_cont2.set_text(self.conts[2])

    #
    #  getVals
    #----------
    def getVals(self):
        """ entry内のtextを取得"""
        val0 = self.entry_val0.get_text()
        val1 = self.entry_val1.get_text()
        val2 = self.entry_val2.get_text()
        return [val0, val1, val2]

#--------------------------------------
#  inputMaterialCont class
#--------------------------------------
class inputMaterialCont:
    """ 非線形dataを取得するdialogの表示、所得処理する。"""

    def __init__(self, matModelTypeHard, labelNames, mat3Vals, labelConts, funcName, funcArgs, parent=None):
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(matModelTypeHard, labelNames, mat3Vals, labelConts, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.dialog.show()

    def close(self):
        self.dialog.dialog.close()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        mat3Vals = self.dialog.getVals()
        self.close()
        matName, mthDict, path, item = self.funcArgs
        self.funcName(mat3Vals, matName, mthDict, path, item)



if __name__ == "__main__":
    import gettext
    gettext.install("easyistr", os.getenv("LOCALE_DIR"))

    mats = ["PLASTIC", "MISES", "BILINEAR"]
    names = ["YIELD0", "H", ""]
    conts = ["初期降伏応力", "硬化係数", ""]
    vals = ["0", "0", ""]
    dialog = dialogApp(mats, names, vals, conts)
    dialog.show()
