#!/usr/bin/python3
#  coding:  utf-8
#
#           exportMeshToOtherFormatDDialog.py
#
#       他形式メッシュにexportする
#
#   25/04/19    新規作成
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import os

exportItemDict = {
    "writeAbaqus":  ["meshio: Abaqus  (*.inp)",           ["*.inp", ["*.inp"]]],
    "writeANSYS":   ["meshio: ANSYS  (*.msh)",            ["*.msh", ["*.msh"]]],
    "writeAvsucd":  ["meshio: AVS-UCD  (*.avs)",          ["*.avs", ["*.avs"]]],
    "writeExodus":  ["meshio: Exodus  (*.e, *.exo)",      ["*.e, *.exo", ["*.e", "*.exo"]]],
    "writeGmsh":    ["meshio: Gmsh  (*.msh)",             ["*.msh", ["*.msh"]]],
    "writeMdpa":    ["meshio: Kratos/MDPA  (*.mdpa)",     ["*.mdpa", ["*.mdpa"]]],
    "writeMed":     ["meshio: Salome/med  (*.med)",       ["*.med", ["*.med"]]],
    "writeMedit":   ["meshio: Medit  (*.mesh)",           ["*.mesh", ["*.mesh"]]],
    "writeNastran": ["meshio: Nastran  (*.bdf, *.fem, *.nas)", ["*.bdf, *.fem, *.nas", ["*.bdf", "*.fem", "*.nas"]]],
    "writeNetgen":  ["meshio: Netgen  (*.vol)",           ["*.vol", ["*.vol"]]],
    "writePermas":  ["meshio: PERMAS  (*.post, *.dato)",  ["*.post, *.dato", ["*.post", "*.dato"]]],
    "writeVtk":     ["meshio: VTK  (*.vtk)",              ["*.vtk", ["*.vtk"]]],
    "writeVtu":     ["meshio: VTU  (*.vtu)",              ["*.vtu", ["*.vtu"]]],
    "writeXdmf":    ["meshio: XDMF  (*.xdmf, *.xmf)",     ["*.xdmf, *.xmf", ["*.xdmf", "*.xmf"]]]
    }

#--------------------
#  exportMesh class
#--------------------
class exportMesh:

    def __init__(self, formatKey, istrData, funcOk=[], parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "exportMeshToOtherFormatDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.dialog.set_title(_("exportMesh"))
        self.builder.connect_signals(self)
        #変数を設定
        self.istrData = istrData
        self.funcOk = funcOk
        self.formatKey = formatKey
        self.setGtkObject()
        self.initialize()

    #show
    def show(self):
        """ dialog表示"""
        self.dialog.show()

    #close
    def close(self, *args):
        """ dialog閉じる"""
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        """ gtkObjectの定義"""
        self.label_exportFormat = self.builder.get_object("label_exportFormat")
        self.entry_fileName = self.builder.get_object("entry_fileName")
        self.builder.get_object("label_title").set_text(_("meshをexportする。"))
        self.builder.get_object("label_exportCont").set_text(_("meshioを使って、他形式のメッシュにexportする。"))
        self.builder.get_object("label_exportMesh").set_text(_("メッシュのexport")) 
        self.builder.get_object("label_otherFormat").set_text(_("exportする形式:"))
        self.builder.get_object("label_fileName").set_text(_("出力file名:"))
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化"""
        #label_formatを設定
        selItem = exportItemDict[self.formatKey][0]
        self.label_exportFormat.set_text(selItem)


    #-------- event handler ---------------
    def onCancel(self, event):
        self.close()
    def onOk(self, event):
        self.exportOtherMesh()

    #
    #  exportOtherMesh
    #------------------
    def exportOtherMesh(self):
        """ exportする"""
        formatKey = self.formatKey
        fileName = self.entry_fileName.get_text()
        funcName = self.funcOk[0]
        funcArgs = [formatKey, fileName] + self.funcOk[1:]
        funcName(*funcArgs)
        self.close()
