#!/usr/bin/python3
#  coding :  utf-8
#
#       editUsingAppDDialog.py
#
#       usingAppファイルを編集する。
#
#   20/07/07    新規作成
#      07/08    CAD, mesherを追加
#      07/10    writeUsingApp:usingAppの書き込みをutf-8に指定した。
#               windowsでは、shift-jisになってしまう為。
#   22/03/13    languageの設定を追加
#      03/22    国際化（文字をpython側でセット）
#      03/24    setTextToUsingApp:dialog表示を追加。
#      10/13    項目terminalRunを追加
#   23/01/10    REVOCAPを削除
#   24/05/22    editUsingApp:新規追加
#      06/06    universalDialogsに修正
#      06/08    okDialog:parentを追加
#      06/09    dialogApp:parent追加
#   25/03/24    mpiを追加
#      06/17    設定項目にvtkFormat（ascii or binary）を追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import sys   
import os   

import pyFistr
import GtkParts
import universalDialogs

#import locale
#gladeファイル内を翻訳
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

ls = "\n"


#----------------------
#  dialogApp class
#----------------------
class dialogApp:

    def __init__(self, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "editUsingAppDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.dialog.set_title(_("設定内容の変更"))
        self.stat = "CANCEL"
        self.usingAppDict = {}

    #  show
    def show(self):
        self.initialize()
        self.dialog.show()

    #  close
    def close(self, *args):
        self.dialog.destroy()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_apply = self.builder.get_object("button_apply")
        self.entry_terminal = self.builder.get_object("entry_terminal")
        self.entry_terminalRun = self.builder.get_object("entry_terminalRun")
        self.entry_fileManager = self.builder.get_object("entry_fileManager")
        self.entry_editor = self.builder.get_object("entry_editor")
        self.entry_fistrFolder = self.builder.get_object("entry_fistrFolder")
        self.entry_paraView = self.builder.get_object("entry_paraView")
        self.entry_office = self.builder.get_object("entry_office")
        #self.entry_REVOCAP = self.builder.get_object("entry_REVOCAP")
        self.entry_gnuplot = self.builder.get_object("entry_gnuplot")
        self.entry_cad = self.builder.get_object("entry_cad")
        self.entry_mesher = self.builder.get_object("entry_mesher")
        self.entry_mpi = self.builder.get_object("entry_mpi")
        self.combo_language = self.builder.get_object("combo_language")
        self.combo_vtkFormat = self.builder.get_object("combo_vtkFormat")
        #文字をセット
        self.builder.get_object("label_subTitle").set_text(_("usingAppファイル内容の編集"))
        self.builder.get_object("label_setConts").set_text(_("設定内容"))
        self.builder.get_object("label_language").set_text(_("言語の設定"))
        self.builder.get_object("label_term").set_text(_("端末"))
        self.builder.get_object("label_termRun").set_text(_("端末内でアプリ起動"))
        self.builder.get_object("label_fistr").set_text(_("FrontISTR実行ファイル保存場所"))
        self.builder.get_object("label_forCheckRes").set_text(_("結果確認用"))
        self.builder.get_object("label_forEditCsv").set_text(_("csvファイル編集用"))
        self.builder.get_object("label_forResidual").set_text(_("残渣確認用"))
        self.builder.get_object("label_forModelCad").set_text(_("CAD model作成用"))
        self.builder.get_object("label_forMesh").set_text(_("mesh作成用"))
        self.builder.get_object("label_mpi").set_text(_("並列計算library"))
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))
        self.builder.get_object("button_apply").get_child().set_text(_("適用"))
        self.builder.get_object("label_vtkFormat").set_text(_("vtkファイルのフォーマット"))

    #
    #  setTextToUsingApp
    #--------------------
    def setTextToUsingApp(self):
        """ GUIのentryから内容を取得し、usingAppに書き込み"""
        lang = self.comboLang.getSelectedItem()
        office = self.entry_office.get_text()
        terminal = self.entry_terminal.get_text()
        terminalRun = self.entry_terminalRun.get_text()
        fileManager = self.entry_fileManager.get_text()
        editor = self.entry_editor.get_text()
        frontIstrFolder = self.entry_fistrFolder.get_text()
        paraView = self.entry_paraView.get_text()
        #revocap = self.entry_REVOCAP.get_text()
        gnuplot = self.entry_gnuplot.get_text()
        cad = self.entry_cad.get_text()
        mesher = self.entry_mesher.get_text()
        mpi =self.entry_mpi.get_text()
        vtkFormat = self.comboVtkFormat.getSelectedItem()
        appDict = {}
        appDict["language"] = lang
        appDict["office"] = office
        appDict["terminal"] = terminal
        appDict["terminalRun"] = terminalRun
        appDict["fileManager"] = fileManager
        appDict["editor"] = editor
        appDict["frontIstrFolder"] = frontIstrFolder
        appDict["paraView"] = paraView
        #appDict["REVOCAP"] = revocap
        appDict["gnuplot"] = gnuplot
        appDict["CAD"] = cad
        appDict["mesher"] = mesher
        appDict["mpi"] = mpi
        appDict["vtkFormat"] = vtkFormat
        #usingAppに書き込み
        writeUsingApp(appDict)
        #dialogを表示
        title = _("usingAppの設定")
        mess = _("usingAppファイル内容を書き換えました。")
        if self.usingAppDict["language"] != appDict["language"]:
            mess += ls + ls + _("使用言語が変更されています。") + ls
            mess += "    " + _("言語の変更は、次回起動時に適用されます。")
        func = [self.close]
        self.okDialog(title, mess, parent=self.dialog, funcOk=func)

    #
    #  initialize
    #---------------
    def initialize(self):
        #usingAppの読み込み
        appDict = pyFistr.readUsingApplications()
        self.usingAppDict = appDict
        #comboLangにセット
        self.comboLang = GtkParts.comboBox(self.combo_language)
        items = ["Japanese", "English"]
        self.comboLang.setItems(items)
        lang = appDict["language"]
        self.comboLang.selectItem(lang)
        #comboVtkにセット
        self.comboVtkFormat = GtkParts.comboBox(self.combo_vtkFormat)
        items = ["ascii", "binary"]
        self.comboVtkFormat.setItems(items)
        vtk = appDict["vtkFormat"]
        self.comboVtkFormat.selectItem(vtk)
        #entryにセット
        self.entry_office.set_text(appDict["office"])
        self.entry_terminal.set_text(appDict["terminal"])
        self.entry_terminalRun.set_text(appDict["terminalRun"])
        self.entry_fileManager.set_text(appDict["fileManager"])
        self.entry_editor.set_text(appDict["editor"])
        self.entry_fistrFolder.set_text(appDict["frontIstrFolder"])
        self.entry_paraView.set_text(appDict["paraView"])
        #self.entry_REVOCAP.set_text(appDict["REVOCAP"])
        self.entry_gnuplot.set_text(appDict["gnuplot"])
        self.entry_cad.set_text(appDict["CAD"])
        self.entry_mesher.set_text(appDict["mesher"])
        self.entry_mpi.set_text(appDict["mpi"])
        
    def okDialog(self, title, message, parent=None, funcOk=[]):
        dialog = universalDialogs.okDialog(title, message, parent, funcOk)
        dialog.show()

#
#  writeUsingApp
#-----------------
def writeUsingApp(appDict):
    """ usingAppにappDictを書き込み"""
    pyFistr.writeUsingApplications(appDict)


#-----------------------------------
#  editUsingApp class
#-----------------------------------
class editUsingApp:
    """ usingAppを設定するdialog。"""

    def __init__(self, funcName, funcArgs, parent=None):
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.stat = "cancel"
        self.dialog = dialogApp(parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_apply.connect("clicked", self.onApply)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onCancel(self, event):
        self.close()

    def onApply(self, event):
        #GUIのcloseは、setTextToUsingApp内のokDialogでcloseする
        self.dialog.setTextToUsingApp()
        self.stat = "OK"
        path, item = self.funcArgs
        self.funcName(self.stat, path, item)



if __name__ == "__main__":
    import gettext
    #gettext.install("app")
    #_ = gettext.gettext
    gettext.install("easyistr", localeDir)

    app = windowApp()
    app.main()


