#!/usr/bin/python3  
# -*- coding: utf-8 -*-    
#
#       deleteFilesDialog2.py
#
#           fileを削除する
#
#   15/06/16    新規作成
#      09/01    windows対応のため、os.sepに修正
#      12/18    windows版のpangoWarning対策で、初期化を修正
#      12/25    行末コードlsを修正
#   19/01/09    python3用に書き換え
#      01/26    okCancelDialog:type→message_typeに修正
#   20/02/28    FrontISTR-5対応で修正
#      04/02    削除せず残すfileを追加。
#   22/02/15    subInitialize:labelの表示、非表示の設定を修正。
#      03/14    国際化
#      03/22    国際化（文字をpython側でセット）
#      04/12    log表示修正（import logFileCreaterを追加）
#      12/17    「全て削除」ボタンを追加
#      12/22    currResultFiles:削除ファイルに「*.plt」を追加
#   23/02/18    currResultFiles:削除fileのpattern「"FistrModel.restart.*"」
#               を「"FistrModel.restart*"」に変更。
#      11/02    headerNameを「FistrModel」→「<headerName>」に変更
#      11/18    currResultFiles:resファイルを検出する関数deleteResultPattern
#               で取得。
#   24/06/06    universalDialogsに修正。
#      06/08    okCancelDialog:parentを追加
#      06/12    windowApp:whidowの位置をmouseに合わせる様修正。
#      06/30    subInitialize:remainFilesの結果が反映されていない為、修正
#      07/05    currResultFiles:OpenRadiossのanimeファイルの削除を追加
#      08/22    deleteFiles,deleteAllFiles:削除後dialogを閉じる様に修正
#   25/06/25    currResultFiles:削除pattern「*_gmsh.msh」を追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk

import sys   
import os   
import os.path   
import glob
import shutil
import pyFistr
import universalDialogs

#import locale
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)

builder = ""
mainWindow = ""

ls = "\n"
headerName = ""             #FistrModel_mshのheader名
FistrModelDict = {}         #hcemw_ctrl.dat内容の辞書
FistrModel_msh = ""         #mshファイル名

#  remainFiles
#    削除せずに残すfile名
def remainFiles():
    global FistrModel_msh
    h = pyFistr.getHeaderName(FistrModel_msh)
    #files = ["convFistrModel.msh.vtu"]
    files = ["conv" + h + ".msh.vtu"]
    return files

#  partMeshFiles
#    並列処理用に分割したメッシュファイル
def partMeshFiles():
    global FistrModel_msh
    h = pyFistr.getHeaderName(FistrModel_msh)
    files = [h + "_p*"]
    return files

#  currResultFolders
#    現在の結果フォルダ
def currResultFolders():
    #global headerName, FistrModelDict
    #folders = ["FistrModel.*", "*_psf.*"]
    folders = ["*_psf.*"]
    return folders

#  currResultFiles
#    現在の結果ファイル
def currResultFiles():
    global FsitrModel_msh, FistrModelDict
    mh = pyFistr.getHeaderName(FistrModel_msh)
    #resHeader = pyFistr.getHeaderName(FistrModelDict["res"])
    #rh = resHeader.split("_")[0]
    files = [mh+"*.inp", "*.restart*", "*.vtk",
             "conv*", "*.log", "FSTR.dbg.*", "FSTR.msg", "FSTR.sta",
             "*.pvtu", "*.vtu", "*.plt", "*_gmsh.msh"]
    files += [mh+"A*"]
    files += deletResultPattern()
    return files

#  eigenResultFiles
#    固有値解析結果ファイル
def eigenResultFiles():
    #global headereName
    #h = headerName
    files = ["*_eigen.res.*", "eigen_log"]
    return files

#  responseResultFiles
#    周波数応答解析結果ファイル
def responseResultFiles():
    #global headerName
    #h = headerName
    files = ["*_dyna.res.*", "dyna_*.txt"]
    return files

#  heatResultFiles
#    熱伝導解析結果ファイル
def heatResultFiles():
    #global headerName
    #h = headerName
    files = ["*_temp.res.*"]
    return files


#  ---------
#  windowApp
#  ---------
#    GUIの起動と終了
class windowApp:

    #  GUIの初期化
    def __init__(self):
        global builder, mainWindow
        builder = Gtk.Builder()
        #builder.set_translation_domain("easyistr")
        #builder.add_from_file(os.getenv("easyIstrPath") + os.sep + "easyIstr_2.glade")
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        builder.add_from_file(path + "deleteFilesDialog2.glade")
        mainWindow = builder.get_object("window1")
        #window位置をmouseに合わせる
        mainWindow.set_position(2)
        mainWindow.connect("delete-event", self.close)
        builder.connect_signals(self)

        self.setGtkObject()
        self.subInitialize()
        self.setTitle()


    #  GUIの表示
    def main(self):
        mainWindow.show_all()
        Gtk.main()

    #
    #  GUIの終了
    #
    def close(self, *args):
        Gtk.main_quit(*args)

    #
    #  handler
    #  ------------------------------
    #削除
    def onDeleteFiles(self, event):
        self.deleteFiles(event)
        #Gtk.main_quit()
    #全て削除(
    def onDeleteAllFiles(self, event):
        self.deleteAllFiles(event)
        #Gtk.main_quit()
    #キャンセル
    def onCancel(self, event):
        Gtk.main_quit()
    #--------------------------------

    #
    #  setGtkObject
    #    objectの定義
    def setGtkObject(self):
        self.checkBtn_partMesh = builder.get_object("checkbutton1")
        self.checkBtn_currRes = builder.get_object("checkbutton2")
        self.checkBtn_eigenRes = builder.get_object("checkbutton3")
        self.checkBtn_respRes = builder.get_object("checkbutton4")
        self.checkBtn_heatRes = builder.get_object("checkbutton5")
        self.label_message = builder.get_object("label1")
        self.label_partMesh = builder.get_object("label2")
        self.label_currRes = builder.get_object("label3")
        self.label_eigenRes = builder.get_object("label4")
        self.label_respRes = builder.get_object("label5")
        self.label_heatRes = builder.get_object("label6")
        #文字をセット
        builder.get_object("label_getDeleteFiles").set_text(_("削除ファイルの指定"))
        self.checkBtn_partMesh.set_label(_("並列処理用に分割したメッシュファイル"))
        self.checkBtn_currRes.set_label(_("現在の結果ファイル、logファイル"))
        self.checkBtn_eigenRes.set_label(_("固有値解析の結果ファイル"))
        self.checkBtn_respRes.set_label(_("周波数応答解析の結果ファイル"))
        self.checkBtn_heatRes.set_label(_("熱伝導解析の結果ファイル"))
        builder.get_object("button_cancel").set_label(_("キャンセル"))
        builder.get_object("button_delete").set_label(_("選択項目を削除"))
        builder.get_object("button_allDelete").set_label(_("全て削除"))

    #
    #  subInitialize
    #    初期化
    def subInitialize(self):
        global headerName, FistrModelDict, FistrModel_msh

        def checkFiles(pattern):
            files = glob.glob(pattern)
            files = set(files) - set(remainFiles())
            return files

        #labelを設定
        #headerNameを取得
        currDir = os.getcwd()
        FistrModel_cnt, FistrModel_msh = pyFistr.cntMshFileName(currDir)
        #headerName = pyFistr.getHeaderName(FistrModel_msh)
        FistrModelDict = pyFistr.getCntMshFileNameDict(currDir)
        label = _(u"ファイルを削除します")
        label += ls + _(u"削除するファイルを選択してください")
        self.label_message.set_text(label)
        label = makeLabel(partMeshFiles())
        self.label_partMesh.set_text(label)
        label = makeLabel(currResultFiles())
        self.label_currRes.set_text(label)
        label = makeLabel(eigenResultFiles())
        self.label_eigenRes.set_text(label)
        label = makeLabel(responseResultFiles())
        self.label_respRes.set_text(label)
        label = makeLabel(heatResultFiles())
        self.label_heatRes.set_text(label)
        #checkBtnの設定
        self.checkBtn_partMesh.set_sensitive(False)
        self.checkBtn_partMesh.set_active(False)
        self.label_partMesh.set_sensitive(False)
        files = partMeshFiles()
        for name in files:
            #if len(glob.glob(name)) != 0:
            if len(checkFiles(name)) != 0:
                self.checkBtn_partMesh.set_sensitive(True)
                self.checkBtn_partMesh.set_active(True)
                self.label_partMesh.set_sensitive(True)
                break
        self.checkBtn_currRes.set_sensitive(False)
        self.checkBtn_currRes.set_active(False)
        self.label_currRes.set_sensitive(False)
        files = currResultFiles()
        for name in files:
            if len(checkFiles(name)) != 0:
                self.checkBtn_currRes.set_sensitive(True)
                self.checkBtn_currRes.set_active(True)
                self.label_currRes.set_sensitive(True)
                break
        self.checkBtn_eigenRes.set_sensitive(False)
        self.checkBtn_eigenRes.set_active(False)
        self.label_eigenRes.set_sensitive(False)
        files = eigenResultFiles()
        for name in files:
            #if len(glob.glob(name)) != 0:
            if len(checkFiles(name)) != 0:
                self.checkBtn_eigenRes.set_sensitive(True)
                self.checkBtn_eigenRes.set_active(True)
                self.label_eigenRes.set_sensitive(True)
                break
        self.checkBtn_respRes.set_sensitive(False)
        self.checkBtn_respRes.set_active(False)
        self.label_respRes.set_sensitive(False)
        files = responseResultFiles()
        for name in files:
            #if len(glob.glob(name)) != 0:
            if len(checkFiles(name)) != 0:
                self.checkBtn_respRes.set_sensitive(True)
                self.checkBtn_respRes.set_active(True)
                self.label_respRes.set_sensitive(True)
                break
        self.checkBtn_heatRes.set_sensitive(False)
        self.checkBtn_heatRes.set_active(False)
        self.label_heatRes.set_sensitive(False)
        files = heatResultFiles()
        for name in files:
            #if len(glob.glob(name)) != 0:
            if len(checkFiles(name)) != 0:
                self.checkBtn_heatRes.set_sensitive(True)
                self.checkBtn_heatRes.set_active(True)
                self.label_heatRes.set_sensitive(True)
                break

    #
    #  setTitle
    #    GUIのタイトルを設定
    def setTitle(self):
        title = _(u"不要なファイルを削除")
        mainWindow.set_title(title)

    #
    #  deleteFiles
    #    指定されたfileを削除
    def deleteFiles(self, event):
        #確認メッセージ
        title = _(u"ファイルの削除")
        mess = _(u"本当に削除しますか？") + ls
        mess += _(u"削除すると元に戻りません")
        funcOk = [self.deleteFilesProcess_close]
        funcCancel = []
        self.okCancelDialog(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # self.deleteFilesProcess()

    #deleteFilesProcess_close
    def deleteFilesProcess_close(self):
        self.deleteFilesProcess()   #file削除
        self.close()                #dialogを閉じる

    #  deleteFilesProcess
    def deleteFilesProcess(self):
        #ファイルの削除
        if self.checkBtn_partMesh.get_active() == True:
            deleteSetNames(partMeshFiles())
        if self.checkBtn_currRes.get_active() == True:
            deleteSetFolders(currResultFolders())
            deleteSetNames(currResultFiles())
        if self.checkBtn_eigenRes.get_active() == True:
            deleteSetNames(eigenResultFiles())
        if self.checkBtn_respRes.get_active() == True:
            deleteSetNames(responseResultFiles())
        if self.checkBtn_heatRes.get_active() == True:
            deleteSetNames(heatResultFiles())
        print (_(u"ファイルを削除しました"))
        self.subInitialize()

    def deleteAllFiles(self, event):
        #確認メッセージ
        title = _(u"ファイルの削除")
        mess = _(u"本当に削除しますか？") + ls
        mess += _(u"削除すると元に戻りません")
        funcOk = [self.deleteAllFilesProcess_close]
        funcCancel = []
        self.okCancelDialog(title, mess, funcOk, funcCancel, parent=mainWindow)
        # stat = self.okCancelDialog(title, mess)
        # if stat != "OK":
        #     return
        # self.deleteAllFilesProcess()

    #  deleteAllFilesProcess_close
    def deleteAllFilesProcess_close(self):
        self.deleteAllFilesProcess()
        self.close()

    #  deleteAllFilesProcess
    def deleteAllFilesProcess(self):
        #全て削除
        deleteSetNames(partMeshFiles())
        deleteSetFolders(currResultFolders())
        deleteSetNames(currResultFiles())
        deleteSetNames(eigenResultFiles())
        deleteSetNames(responseResultFiles())
        deleteSetNames(heatResultFiles())
        print (_(u"ファイルを削除しました"))
        self.subInitialize()

    def okCancelDialog(self, title, message, funcOk, funcCancel, parent=None):
        dialog = universalDialogs.okCancelDialog(title, message, funcOk, funcCancel, parent)
        dialog.show()

#
#  deleteSetFolders
#    指定されたfolderを削除
def deleteSetFolders(folders):
    for folder in folders:
        delNames = glob.glob(folder)
        for delName in delNames:
            if os.path.isdir(delName) == True:
                shutil.rmtree(delName)

#
#  deleteSetNames
#    指定されたfileを削除
def deleteSetNames(names):
    for name in names:
        comm = "rm -rf " + name
        print (comm)
        delNames = glob.glob(name)
        if len(delNames) > 0:
            for delName in delNames:
                if not delName in remainFiles():
                    os.remove(delName)

#
#  deleteResultPattern
#    _temp, _eigen以外のresを削除
def deletResultPattern():
    names = glob.glob("*.res.*")
    delNamesSet = set([])
    for name in names:
        if name.find("_temp.res.") < 0:
            if name.find("_eigen.res.") < 0:
                n = name.find(".res.")
                delName = name[:n + len(".res.")] + "*"
                delNamesSet.add(delName)
    delNames = list(delNamesSet)
    return delNames

#
#  makeLabel
#    単語を接続してlabelを作成
def makeLabel(words):
    label = ""
    maxl = 60
    l = 0
    i = 0
    ip = 0
    while i < len(words):
        l += len(words[i])
        if l > maxl:
            label += ", ".join(words[ip:i])
            if ip < len(words):
                label += ls
            ip = i
            l = 0
        i += 1
    if ip == 0:
        label = ", ".join(words)
    elif ip != i-1:
        label += ", ".join(words[ip:])
    return label




if __name__ == "__main__":
    import gettext
    #gettext.install("app")
    #_ = gettext.gettext
    gettext.install("easyistr", localeDir)

    #log表示
    import logFileCreater
    logFileCreater.log()

    app = windowApp()
    app.main()

