#!/usr/bin/python3
# coding: utf-8
#
#       convertToRadiossDDialog.py
#
#       fistr2rad.py変換用のOpenRadiossのHeaderファイル名を取得する
#
#   25/01/10    新規作成
#      01/10    refine
#      04/20    onReference:新規追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys
import showContentsDDialog
import fistr2rad
import universalDialogs

localeDir = os.getenv("LOCALE_DIR")

ls = "\n"

#----------------------
#  getRadName class
#----------------------
class getRadName:
    """ fistr2rad.py変換の為のOpeanRadiossのHeaderファイル名を取得する"""

    def __init__(self, headerName, currDir, funcOk=[], parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "convertToRadiossDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.dialog.set_title("fistr2rad.py")
        self.funcOk = funcOk
        self.inpName = ""
        self.currDir = currDir
        self.entry_radName.set_text(headerName)

    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        self.label_topMess = self.builder.get_object("label_topMess")
        self.label_conts = self.builder.get_object("label_conts")
        self.label_setInpFile = self.builder.get_object("label_setInpFile")
        self.label_radName = self.builder.get_object("label_radName")
        self.label_option = self.builder.get_object("label_option")
        self.label_addOption = self.builder.get_object("label_addOption")
        self.entry_radName = self.builder.get_object("entry_radName")
        self.entry_option = self.builder.get_object("entry_option")
        self.button_showDetail = self.builder.get_object("button_showDetail")
        self.button_convert = self.builder.get_object("button_convert")
        self.button_cancel = self.builder.get_object("button_cancel")
        #文字を設定
        mess = _("<変換対象>") + ls
        mess += _("  !ELASTIC, !PLASTIC-MISES-MULTILINEAR,") + ls
        mess += _("  !BOUNRARY, !CLOAD, !DLOAD-S,GRAV, !VELOCITY,") + ls
        mess += _("  !ACCELERATION, !CONTACT, !DYNAMIC") + ls
        mess += _("<mesheType>") + ls
        mess += _("  341, 342, 361, 362, 731, 741, 761, 781") + ls
        mess += _("  NGRP, SGRP, EGRP")
        self.label_conts.set_text(mess)
        self.label_topMess.set_text(_("cnt,mshファイルをOpenRadioss形式の starter, engineファイルに変換する。"))
        self.label_setInpFile.set_text(_("Headerファイル名と追加optionを入力"))
        self.label_radName.set_text(_("Header名:"))
        self.label_option.set_text(_("追加option:"))
        self.label_addOption.set_text(_("「-inc」「-rad」optionは、設定されています。"))
        self.builder.get_object("button_refer").get_child().set_text(_("参照..."))
        self.button_showDetail.get_child().set_text(_("変換内容の詳細表示..."))
        self.button_convert.get_child().set_text(_("変換開始"))
        self.button_cancel.get_child().set_text(_("キャンセル"))

    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.close()

    def onCancel(self, event):
        self.close()

    def onShowDetail(self, event):
        self.showDetail()

    def onActivate(self, event):
        self.onOk(event)

    def onOk(self, event):
        radName = self.entry_radName.get_text()
        option = self.entry_option.get_text()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            funcArgs = [radName, option] + self.funcOk[1:]
            GLib.timeout_add(100, funcName, *funcArgs)

    def onReference(self, event):
        title = ""
        currDir = self.currDir
        funcOk = [self.getFileName, currDir]
        funcCancel = []
        selName = self.entry_radName.get_text()
        filterSet = ["OpenRadioss  (*.rad, *.inc)", ["*.rad", "*.inc"]]
        filterSets = [filterSet, [_("全ファイル"), ["*"]]]
        self.saveFileDialog(title, currDir, funcOk, funcCancel, self.dialog, selName, filterSets)

    def getFileName(self, fileName, currDir):
        relativePath = os.path.relpath(fileName, currDir)
        self.entry_radName.set_text(relativePath)

    #
    #  showDetail
    #-------------
    def showDetail(self):
        """ 変換内容の詳細を表示する"""
        #実行file名を取得
        fileName = os.getenv("easyIstrPath") + os.sep + "bin" + os.sep + "fistr2rad.py"
        #変換内容を実行fileから取得
        f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
        contLines = []
        for i in range(2, len(lines), 1):
            line = lines[i]
            if line[:len("#--------")] == "#--------":
                break
            contLines += [line]
        conts = "".join(contLines)
        conts += fistr2rad.HelpCont
        dialog = showContentsDDialog.showMessage(conts, parent=self.dialog)
        dialog.show()

    #---- universalDialogs ------------------
    def saveFileDialog(self, title, fileDir, funcOk, funcCancel, parent=None, selName="", filterSets=[]):
        dialog = universalDialogs.saveFileDialog(title, fileDir, funcOk, funcCancel, parent, selName, filterSets)
        dialog.show()


if __name__ == "__main__":
    import gettext
    #gettext.install("app") # replace with the appropriate catalog name
    _ = gettext.gettext
    dialog = getRadName()
    dialog.show()
    Gtk.main()
