#!/usr/bin/python3
# -*- coding: UTF-8 -*-
#
#       主応力の計算
#
#   15/12/17    主応力のベクトル追加
#      12/24    精度向上（有効桁数10桁）、内容を整理
#   16/01/31    reorderSS:初期値を設定
#               Vectorの算出方法を以下のwebを参考に修正
#               http://www.fem.gr.jp/fem/3dim/3dsolidexample/3dsolidexampleb.html
#      04/07    calcVectorSS:特別解を別な方法でvector算出し、主値も再計算
#   18/01/04    python3用に書き換え
#      04/22    vsCodeにより修正
#   25/01/13    numpyで計算する様に書き換え。戻り値の書式変更。
#

import numpy as np

#
#  calcSSigma
#    主応力の計算（numpyで計算）
def calcSSigma(sigmaList):
    """ 主応力を計算"""

    #xx,   yy,   zz,   xy,   yz,   zx
    [SG11, SG22, SG33, SG12, SG23, SG13] = sigmaList
    SG21 = SG12
    SG31 = SG13
    SG32 = SG23

    array = [[SG11, SG12, SG13],                    #テンソル作成
             [SG21, SG22, SG23],
             [SG31, SG32, SG33]]
    #numpyで計算
    ss, sv = np.linalg.eig(array)                   #scalar値、単位ベクトルを取得
    #     0     idx   1     idx   2     idx
    a = [[ss[0], 0], [ss[1], 1], [ss[2], 2]]
    a.sort(reverse=True)                            #降順に並べ替え
    #      max      mid      min
    ss  = [a[0][0], a[1][0], a[2][0]]               #scalarを再取得
    #      max軸        mid軸        min軸
    ssv = [sv[a[0][1]], sv[a[1][1]], sv[a[2][1]]]   #各軸再取得

    #主応力のベクトル算出
    a = np.array(ss)
    v = a.reshape(3,1)
    ssv = v * ssv           #主応力のベクトル
    ans = [ss, ssv]         #戻り値                        
    return ans

#
#  pricpalStress
#  -------------
def principalStress(sigmaList):
    """ 主応力の計算
    
    Args:   [xx, yy, zz, xy, yz, zx]
    Return: [sig1, sig2, sig3], [vSig1, vSig2, vSig3]
            scalar値            vector
    """
    [SS, SSV] = calcSSigma(sigmaList)
    return [SS, SSV]


if __name__ == "__main__":
    xx=4.61E+02; yy=1.50E+02; zz=2.07E+02
    xy=-3.13E+01; yz=-1.15E+01; zx=-6.62E+01

    #sigmaList = [xx, yy, zz, xy, yz, zx]
    #sigmaList = [10000000.000471603, 0.00047178906250000004, 1.353400902866366e-24, 0.0004718398437500004, -4.204932183080673e-09, -4.204932183074549e-09]
    #sigmaList = [10000000.000471603, 0.00047178906250000004, 1e-11, 0.0004718398437500004, -4.204932183080673e-09, -4.204932183074549e-09]
    sigmaList = [3,2,3,0,0,0]

    [sig1, sig2, sig3, v1, v2, v3] = principalStress(sigmaList)
    #[sig, v] = principalStress(sigmaList)
    sig1, sig2, sig3 = sig
    v1, v2, v3 = v
    mises2 = (pow((sig1-sig2),2) + pow((sig2-sig3),2) + pow((sig3-sig1),2))/2.0
    mises = pow(mises2, 0.5)
    print (sig1, sig2, sig3, [v1, v2, v3])

