#!/usr/bin/python3
#  coding: utf-8
#
#       autoincParamDDialog.py
#
#       「!AUTOINC_PARAM」の値を編集する
#
#   20/03/12    新規作成
#   22/03/14    国際化
#      03/22    国際化（文字をpython側でセット）
#   24/05/22    autoincParam:新規追加。
#      06/09    parentを追加
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk
import os

#import locale
localeDir = os.getenv("LOCALE_DIR")
#locale.bindtextdomain("easyistr", localeDir)


#-------------------
#  dialogApp class
#-------------------
class dialogApp:
    """ AUTOINC_PARAMのdata入力用Dialog。
    
    Attribute:
        paraLines (list(str))   :データ行をlist形式で与える
        """

    def __init__(self, paraLines, parent=None):
        self.builder = Gtk.Builder()
        path = os.getenv("easyIstrPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "autoincParamDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        self.dialog.set_transient_for(parent)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        self.dialog.set_title(_("時間幅自動増減の設定"))
        self.paraLines = paraLines
        self.entryDec = [
                self.entry_decRatio, self.entry_decMax,
                self.entry_decSum, self.entry_decCont,
                self.entry_decSubstep]
        self.entryInc = [
                self.entry_incRatio, self.entry_incMax,
                self.entry_incSum, self.entry_incCont,
                self.entry_incSubstep]
        self.entryCutBack = [
                self.entry_cutRatio, self.entry_cutNum]

    def show(self):
        self.initialize()
        self.dialog.show()

    def close(self, *args):
        self.dialog.destroy()
        
    #
    #  setGtkObject
    #----------------
    def setGtkObject(self):
        """ GtkObjectを定義"""
        self.button_cancel = self.builder.get_object("button_cancel")
        self.button_ok = self.builder.get_object("button_ok")
        self.entry_decRatio = self.builder.get_object("entry_decRatio")
        self.entry_decMax = self.builder.get_object("entry_decMax")
        self.entry_decSum = self.builder.get_object("entry_decSum")
        self.entry_decCont = self.builder.get_object("entry_decCont")
        self.entry_decSubstep = self.builder.get_object("entry_decSubstep")
        self.entry_incRatio = self.builder.get_object("entry_incRatio")
        self.entry_incMax = self.builder.get_object("entry_incMax")
        self.entry_incSum = self.builder.get_object("entry_incSum")
        self.entry_incCont = self.builder.get_object("entry_incCont")
        self.entry_incSubstep = self.builder.get_object("entry_incSubstep")
        self.entry_cutRatio = self.builder.get_object("entry_cutRatio")
        self.entry_cutNum = self.builder.get_object("entry_cutNum")
        #labelに文字をセット
        self.builder.get_object("label_title").set_text(_("時間幅増減、カットバック条件の詳細設定"))
        mess = _("max, sum, 接触の反復数が設定値を超えた（超えない）状態が、\n連続subStep数まで継続した時、変化率に応じて時間幅を減少（増加）する。\n  sum反復数 = max反復数 + 接触反復数")
        self.builder.get_object("label_setMethod").set_text(mess)
        self.builder.get_object("label_autoInc").set_text(_("自動時間増減の内容"))
        self.builder.get_object("label_changeRatio").set_text(_("変化率"))
        self.builder.get_object("label_maxIter").set_text(_("max反復数"))
        self.builder.get_object("label_sumIter").set_text(_("sum反復数"))
        self.builder.get_object("label_contactIter").set_text(_("接触反復数"))
        self.builder.get_object("label_continueStep").set_text(_("連続subStep数"))
        self.builder.get_object("label_decInterval").set_text(_("時間幅減少"))
        self.builder.get_object("label_incInterval").set_text(_("時間幅増加"))
        self.builder.get_object("label_changeRatioCutBack").set_text(_("変化率"))
        self.builder.get_object("label_nCutBack").set_text(_("cutBack回数"))
        mess = _("収束しなかった場合は、時間幅を変化率に応じて減少し、再計算する。\n再計算回数がcutBack回数を超えた場合、中断する。")
        self.builder.get_object("label_autoIncConts").set_text(mess)
        self.builder.get_object("button_cancel").get_child().set_text(_("キャンセル"))

    #
    #  initialize
    #-------------
    def initialize(self):
        """ 初期化。paramDataをentryにセットする。"""

        def deleteSp(line):
            line = line.replace(" ", "")
            line = line.replace("\n", "")
            return line

        #decEntryに値をセット
        line = self.paraLines[0]
        vals = deleteSp(line).split(",")
        for i in range(len(self.entryDec)):
            self.entryDec[i].set_text(vals[i])
        #incEntryに値をセット
        line = self.paraLines[1]
        vals = deleteSp(line).split(",")
        for i in range(len(self.entryInc)):
            self.entryInc[i].set_text(vals[i])
        #cutbackに値をセット
        vals = deleteSp(self.paraLines[2]).split(",")
        for i in range(len(self.entryCutBack)):
            self.entryCutBack[i].set_text(vals[i])
        
    #
    #  getValueFromAllEntrys
    #------------------------
    def getValueFromAllEntrys(self):
        """ entryの内容を取得して返す"""
        lines = []
        #decEntryを取得
        vals = []
        for i in range(len(self.entryDec)):
            val = self.entryDec[i].get_text()
            vals.append(val)
        line = ", ".join(vals) + "\n"
        lines.append(line)
        #incEntryを取得
        vals = []
        for i in range(len(self.entryInc)):
            val = self.entryInc[i].get_text()
            vals.append(val)
        line = ", ".join(vals) + "\n"
        lines.append(line)
        #cutBackEntryを取得
        vals = []
        for i in range(len(self.entryCutBack)):
            val = self.entryCutBack[i].get_text()
            vals.append(val)
        line = ", ".join(vals) + "\n"
        lines.append(line)
        return lines
    
#----------------------
#  autoincParam class
#----------------------
class autoincParam:
    """ autoincParameterを取得、設定するdialog。
    
    Args:
        paraLines (list):   現在のparameter
        funcName (object):  取得したparameterを設定する関数"""

    def __init__(self, paraLines, funcName, funcArgs, parent=None):
        self.paraLines = paraLines
        self.funcName = funcName
        self.funcArgs = funcArgs
        self.dialog = dialogApp(paraLines, parent)
        self.dialog.button_cancel.connect("clicked", self.onCancel)
        self.dialog.button_ok.connect("clicked", self.onOk)

    def show(self):
        self.dialog.show()

    def close(self):
        self.dialog.close()

    def onCancel(self, event):
        self.close()

    def onOk(self, event):
        self.paraLines = self.dialog.getValueFromAllEntrys()
        self.close()
        path, item = self.funcArgs
        self.funcName(self.paraLines, path, item)
