#!/usr/bin/env python3
# -*- coding: utf-8 -*-
#
#   vol2fistr.py
#
#       vol形式のメッシュファイルをFistr形式に変換
#       変換対象: beam1次、三角形shell1次、四面体1次2次
#
#
#   18/07/27    新規作成
#      09/12    辞書見直し（バグ）
#   20/09/22    python3用に書き換え
#   25/02/27    変換対象にshell, beamを追加
#               createMesh_netgen.pyの関数を使用するように修正
#

import sys
import os
import netgen.meshing as ngmesh
import createMesh_netgen


#
#  helpMsg
#    helpを出力
def helpMsg():
    msg = """
<vol2fistr.py>
vol形式のmeshファイルをfistr形式に変換する。

<使い方>
vol2fistr.py <volName.vol> [<FistrFile.msh>]
    volName.vol :   vol形式のファイル
    FistrFile.msh:  FrontISTR形式のファイル
                省略可。省略時は、「volName.msh」に設定される

使用例:
vol2fistr.py name.vol               #結果は、「name.msh」に変換される
vol2fistr.py name                   #  ↑
vol2fistr.py name.vol Fistr.msh     #結果は、「Fistr.msh」に変換される
"""
    print (msg)



#
#  vol2fistr
#------------
def vol2fistr(volFileName, fistrFileName):
    """ vol形式をfistr形式に変換する"""
    mesh = ngmesh.Mesh()
    mesh.Load(volFileName)
    #createMeshの関数で変換する
    createMesh_netgen.convertVolToFistr(mesh, volFileName, fistrFileName)


if __name__=='__main__':
    if len(sys.argv) == 1:
        helpMsg()
        exit()
    
    volFileName = sys.argv[1]
    if volFileName == "-h" or volFileName == "--help":
        helpMsg()
        exit()

    words = volFileName.split(".")
    if words[-1] != "vol":
        volFileName += ".vol"

    if len(sys.argv) > 2:
        fistrFileName = sys.argv[2]
        if fistrFileName.split(".")[-1] != "msh":
            fistrFileName += ".msh"
    else:
        fistrFileName = volFileName[:-4] + ".msh" 
    #file変換開始
    vol2fistr(volFileName, fistrFileName)

