#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   unv2fistr.py
#
#       unv →　abaqus　→　fistr　の順にメッシュ変換
#
#       unv2fistr.py <unvファイル名>
#
#
#   15/03/19    新規作成
#      09/01    windows対応のため、os.sepに修正
#      10/27    unvファイルの行末修正（file内容チェック）を追加
#   16/06/15    ヘルプ表示を修正
#   17/09/26    高速化の為、fileCheck時の書き出し方法を修正
#   18/03/24    高速化の為、fileCheck方法を修正。
#      07/06    file名中に「.」があると、エラー停止する為、修正。（バグ修正）
#   19/01/08    python3用に書き換え
#      04/06    pythonスクリプト起動時にフルパスで指定する様に修正
#      05/17    unv2fistrEx.pyを実行するように修正
#   21/05/17    os.systemをsubprocessに変更
#   22/04/12    log表示修正（import logFileCreaterを追加）
#   24/07/07    openにencoding="utf-8"を追加
#   25/04/22    入力の引数（newName）を追加
#

import sys
import os
import glob
import subprocess
import pyFistr

binAppPath = pyFistr.binAppPath
pythonAppPath = pyFistr.pythonAppPath

#
#  printMsg
#
def printMsg():
    msg = """
<unv2fistr.py>
unvフォーマットのmeshをFrontISTR用mesh(HECMWフォーマット）に変換する。

<使い方>
unv2fistr.py <unvファイル> <fistrファイル>

例：
unv2fistr.py name.unv  test
unv2fistr.py name  test.msh
"""
    print (msg)

#
#  abaqus2fistr
#    abaqusをfistrに変換
def abaqus2fistr(fileName, newName):
    print
    print ("convert abaqus to fistr...")
    comm = "python3 " + binAppPath + "abaqus2fistr.py " + fileName
    print (comm)
    #os.system(comm)
    proc = subprocess.run(comm, shell=True)

#
#  unv2abaqus
#    unvをabaqusに変換
def unv2abaqus(fileName, newName):
    print
    print ("convert unv to abaqus...")
    comm = "python3 " + binAppPath + "unv2abaqusEx.py " + fileName + " " + newName + " N"
    print (comm)
    #os.system(comm)
    proc = subprocess.run(comm, shell=True)

#
#  unv2fistr
#    unvFileを直接fistr形式に変換する
def unv2fistr(fileName, newName):
    print
    print ("convert unv to fistr...")
    comm = "python3 " + binAppPath + "unv2fistrEx.py " + fileName + " " + newName
    print (comm)
    #os.system(comm)
    proc = subprocess.run(comm, shell=True)

#
#  checkUnvFile
#    unvFileの行末コードをチェック修正
def checkUnvFile(fileName):
    #500byte分読み込み
    f=open(fileName)
    cont = f.read(500)
    f.close()
    #osチェック
    if os.name == "nt":
        #windowsの場合
        lines = cont.split("\r\n")
        if len(lines) > 1:
            return
    else:
        #linuxの場合
        lines = cont.split("\r\n")
        if len(lines) == 1:
            lines = cont.split("\n")
            if len(lines) > 1:
                return
    #読み込み、書き込み（osと行末コードが合わない場合）
    f = open(fileName, encoding="utf-8"); lines = f.readlines(); f.close()
    w = open(fileName, "w", encoding="utf-8")
    for line in lines:
        w.write(line)
    w.close()
    return


if __name__=='__main__':

    #log表示
    import logFileCreater
    logFileCreater.log()

    if len(sys.argv) < 2:
        printMsg()
        exit()

    name = sys.argv[1]
    newName = sys.argv[2]
    if name[:len("-h")] == "-h" or name[:len("--help")] == "--help":
        printMsg()
    else:
        #file名を取得
        fileDir = os.sep.join(sys.argv[1].split(os.sep)[:-1])
        if fileDir == "":
            fileDir = os.getcwd()
        fileName = sys.argv[1].split(os.sep)[-1]
        if fileName[-4:] != ".unv":
            fileName += ".unv"
        #file有無チェック
        #if len(glob.glob(fileDir+os.sep+fileName)) == 0:
        if os.path.exists(fileDir+os.sep+fileName) == False:
            print()
            print ("error: '" + fileDir + os.sep + fileName + "' does not exist.")
            exit()
        #file内容をチェック
        print ()
        print ("checking file contents...")
        checkUnvFile(fileDir+os.sep+fileName)
        if newName.split(".")[-1] != "msh":
            newName = newName + ".msh"
        unv2fistr(fileDir+os.sep+fileName, newName)


