#!/usr/bin/python3
#  coding: utf-8
#
#   shell731To761.py
#
#       shell要素731を761に変換する。
#
#   21/03/08    新規作成
#   22/03/15    国際化
#

import os, sys
import pyFistr

#
#  createNodeElementDict
#------------------------
def createNodeElementDict(meshHeaderData):
    """ nodeDict, elementDictを作成"""
    nodeDict = {}
    elementDict = {}
    for header, data in meshHeaderData:
        words = pyFistr.deleteSp(header).split(",")
        if words[0] == "!NODE":
            for nodeData in data:
                nodeNo = nodeData[0]
                loc = nodeData[1:]
                nodeDict[nodeNo] = {"loc":loc}
        elif words[0] == "!ELEMENT":
            elmType = pyFistr.getValName(header, "TYPE")
            for elmData in data:
                elmNo = elmData[0]
                nodes = elmData[1:]
                elementDict[elmNo] = {"node":nodes, "type":elmType}
                for nodeNo in nodes:
                    if "elm" in nodeDict[nodeNo].keys():
                        nodeDict[nodeNo]["elm"].add(elmNo)
                    else:
                        nodeDict[nodeNo]["elm"] = set([elmNo])
    return nodeDict, elementDict

#
#  addDummyNodes
#-----------------
def addDummyNodes(meshHeaderData, dicts):
    """ dummyNodeを追加する"""
    nodeDict, elementDict = dicts
    maxNo = max(list(nodeDict.keys()))
    #dummyDict作成
    dummyNodeDict = {}
    dummyNodeNo = maxNo + 1
    for nodeNo in nodeDict.keys():
        dummyNodeDict[nodeNo] = dummyNodeNo
        dummyNodeNo += 1
    #dummyNodeをElementに追加
    addHeaderData = []
    nodesSet = set([])
    for i in range(len(meshHeaderData)):
        header = meshHeaderData[i][0]
        data = meshHeaderData[i][1]
        words = pyFistr.deleteSp(header).split(",")
        if words[0] == "!ELEMENT":
            header = pyFistr.setValName(header, "TYPE=761")
            meshHeaderData[i][0] = header
            egrpName = pyFistr.getValName(header, "EGRP")
            for ii in range(len(data)):
                elm = data[ii]
                elmNo = elm[0]
                nodes = elm[1:]
                for nodeNo in nodes:
                    nodesSet.add(nodeNo)
                    loc = nodeDict[nodeNo]["loc"]
                    dummyNodeNo = dummyNodeDict[nodeNo]
                    nodeDict[dummyNodeNo] = {"loc":loc, "elm":elmNo}
                    elm += [dummyNodeNo]
                data[ii] = elm
                elementDict[elmNo]["node"] = elm[1:]
    #!dummyの!NODEを作成
    nodes = list(nodesSet)
    nodes.sort()
    dummyHeader = "!NODE, NGRP=dummyNodes\n"
    dummyData = []
    for nodeNo in nodes:
        dummyNo = dummyNodeDict[nodeNo]
        loc = nodeDict[nodeNo]["loc"]
        dummyData.append([dummyNo] + loc)
    addHeaderData.append([dummyHeader, dummyData])

    #挿入
    for i in range(len(meshHeaderData)):
        header = meshHeaderData[i][0]
        data = meshHeaderData[i][1]
        words = pyFistr.deleteSp(header).split(",")
        if words[0] == "!ELEMENT":
            si = i
            break
    meshHeaderData = meshHeaderData[:si] + addHeaderData + meshHeaderData[si:]
    return meshHeaderData

#
#  addDummyNgrp
#---------------
def addDummyNgrp(meshHeaderData, dicts):
    """ dummyのNGRPを追加する"""
    nodeDict, elementDict = dicts
    addHeaderData = []
    for header, data in meshHeaderData:
        words = pyFistr.deleteSp(header).split(",")
        if words[0] == "!NGROUP":
            ngrpName = pyFistr.getValName(header, "NGRP")
            addHeader = "!NGROUP, NGRP=dummy_" + ngrpName + "\n"
            addData = []
            for nodeNo in data:
                if len(nodeDict[nodeNo]["elm"]) > 0:
                    elmNos = list(nodeDict[nodeNo]["elm"])
                    elmNo = elmNos[0]
                    nodes = elementDict[elmNo]["node"]
                    idx = nodes.index(nodeNo)
                    dummyNodeNo = nodes[idx + 3]
                    addData.append(dummyNodeNo)
            addHeaderData.append([addHeader, addData])
    #挿入
    flag = 0
    ip = len(meshHeaderData)
    for i in range(len(meshHeaderData)):
        header = meshHeaderData[i][0]
        words = pyFistr.deleteSp(header).split(",")
        if flag == 0:
            if words[0] == "!NGROUP":
                flag = 1
        else:
            if words[0] != "!NGROUP":
                ip = i
                break
    meshHeaderData = meshHeaderData[:ip] + addHeaderData + meshHeaderData[ip:]
    return meshHeaderData

#
#  convShellType
#----------------
def convShellType():
    """ shell741を781に変換する"""
    #lines = pyFistr.readFistrModelMsh()
    #meshHeaderData = pyFistr.getHeaderNumData(lines)
    meshHeaderData = pyFistr.getHeaderNumDataMsh(os.getcwd())
    nodeDict, elementDict = createNodeElementDict(meshHeaderData)
    dicts = [nodeDict, elementDict]
    if isOnlyShell741(meshHeaderData) == False:
        print(_("731以外の要素が存在する為、761に変換できません"))
        print(_("変換できるのは、731のみで構成されたモデルです。"))
        return
    meshHeaderData = addDummyNodes(meshHeaderData, dicts)
    meshHeaderData = addDummyNgrp(meshHeaderData, dicts)

#
#  convert
#----------
def convert(meshHeaderData):
    """ meshHeaderDataを781に変換して返す。
    モジュール専用"""
    nodeDict, elementDict = createNodeElementDict(meshHeaderData)
    dicts = [nodeDict, elementDict]
    meshHeaderData = addDummyNodes(meshHeaderData, dicts)
    meshHeaderData = addDummyNgrp(meshHeaderData, dicts)
    return meshHeaderData

if __name__ == "__main__":
    import gettext
    gettext.install("easyistr", os.getenv("LOCALE_DIR"))
    #_ = gettext.gettext

    convShellType()
