#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#       plotStepMonitorHeatDy.py
#
#           各stepの進捗状況をプロットする（モニタ用）
#           非定常熱伝導解析用
#
#   18/12/30    新規作成
#   19/01/08    python3用に書き換え
#      01/14    stdin.flush()を追加
#      02/05    windows用にcrtl-cで停止させる事を想定し対応
#   20/07/08    readGnuplotCommand:辞書形式に変更
#   24/07/07    openにencoding="utf-8"を追加
#

import os
import time
import pyFistr
import subprocess

logFile = "0.log"
waitTime = 5.0

#
#  readGnuplotCommand
#    gnuplotのコマンドを取得
def readGnuplotCommand():
    appDict = pyFistr.readUsingApplications()
    runGnuplotComm = appDict["gnuplot"]
    if runGnuplotComm == "":
        runGnuplotComm = "gnuplot"
    comm = runGnuplotComm + " -p\n"
    return comm

#
#  getPlotData
#    plotするデータをlinesから取得
def getPlotData(data):

    #  checkError
    #    errorCheckし、dataを修正
    def checkError(data):
        for i in range(len(data)):
            try:
                a = float(data[i])
            except:
                #errorの場合
                if data[i].find("E") < 0 and data[i].find("e") < 0:
                    #数列に「E」が抜けている場合
                    words = data[i].split("-")
                    if len(words) > 1:
                        #指数が「-」の場合
                        data[i] = "-".join(words[:-1]) + "E-" + words[-1]
                    else:
                        words = data[i].split("+")
                        if len(words) > 1:
                            #指数が「+」の場合
                            data[i] = "+".join(words[:-1]) + "E+" + words[-1]
        return data

    #変数の初期化
    data = checkError(data)
    return data

#
#  plotStepMonitor
#    logファイルを読み込みながらデータをplot
def plotStepMonitor(runGnuplotComm):

    #
    #  getStepNo
    def getStepNo(line):
        """ stepNoを取得"""
        step = ""
        words = line.split()
        if words[:2] == ["ISTEP", "="]:
            step = words[2]
        return step

    #
    #  getStepTimeInLine
    def getStepTimeInLine(line):
        """ stepの時間を取得する"""
        timeVal = ""
        words = line.split()
        if words[:2] == ["Time", "="]:
            timeVal = words[2]
        return timeVal

    #  getStepDataInLine
    #    dataがある行かcheck
    def getStepDataInLine(line):
        stepVal = ""
        words = line.split()
        if words[:3] == ["Maximum", "Temperature(global)", ":"]:
            stepVal = words[3]
        return stepVal
        # if len(words) > 5:
        #     if words[0].upper() == "STEP":
        #         nStep = words[2]
        #         timeValue = words[5]
        #         stepData = [nStep, timeValue]
        # return stepData

    #  dataPlot
    #    dataを描画する
    def dataPlot(allData):
        if len(allData) >= 2:
            g.stdin.write(b"$stepData << EOD\n")
            for data in allData:
                line = " ".join(data) + "\n"
                g.stdin.write(line.encode())
            g.stdin.write(b"EOD\n")
            gLine = b"plot "
            gLine += b"$stepData using 1:2 with line title 'time', "
            gLine += b"$stepData using 1:3 with line title 'max temperature' axes x1y2\n"
            g.stdin.write(gLine)
            g.stdin.flush()
        return

    #
    #  データプロット
    #
    g = subprocess.Popen(runGnuplotComm, shell=True, stdin=subprocess.PIPE)
    g.stdin.write(b"set ytics nomirror\n")
    g.stdin.write(b"set y2tics\n")
    g.stdin.write(b"set grid\n")
    g.stdin.write(b"set xlabel 'step'\n")
    g.stdin.write(b"set ylabel 'time'\n")
    g.stdin.write(b"set y2label 'temperature'\n")
    #logファイルをopen
    f = open(logFile, encoding="utf-8")
    #変数の初期化
    allData = []
    lines = []
    plotFlag = 0
    #logファイルを読み込みながらdataをplot
    pLine = ""
    n = 0
    while n == 0:
        #1行読込
        line = f.readline()
        #logFileの処理
        if line != "":
            #読み込めた場合に処理
            plotFlag = 1
            lines.append(line)
            #step数を取得
            _step = getStepNo(line)
            if _step != "":
                step = _step
            else:
                _timeVal = getStepTimeInLine(line)
                if _timeVal != "":
                    timeVal = _timeVal
                else:
                    #値を取得
                    stepVal = getStepDataInLine(line)
            #stepData = getStepDataInLine(line)
            #if len(stepData) == 2:
            if stepVal != "":
                stepData = [step, timeVal, stepVal]
                #dataを取得
                stepData = getPlotData(stepData)
                pLine += "f" + stepData[0] + " "
                allData += [stepData]
                #flagをクリア
                lines = []
        #dataPlot
        #if line == "" and plotFlag == 1:
        if line == "":
            if plotFlag == 1:
                #行が読み込めなかった場合、plot
                dataPlot(allData)
                if len(pLine) > 5000:
                    print ("..." + pLine[-5000:])
                else:
                    print (pLine)
                pLine = ""
                plotFlag = 0
            #waitする
            time.sleep(waitTime)
    f.close()
                

if __name__ == '__main__':
    runGnuplotComm = readGnuplotCommand()
    try:
        plotStepMonitor(runGnuplotComm)
    except:
        exit()


