#!/usr/bin/python3
#  coding :  utf-8
#
#   createAbaInitialConditions.py
#
#       calculixのdatファイルからinitialConditions,type=displacement
#       を作成する。
#
#   21/06/25    新規作成
#   22/13/15    国際化
#   24/07/07    openにencoding="utf-8"を追加
#


import sys, os


#
#  createIniCondDisp
#--------------------
def createIniCondDisp(fileHeader):
    """ datファイルからinitialConditions,Type=displacementを作成する"""
    datFile = fileHeader + ".dat"
    f = open(datFile, encoding="utf-8"); lines = f.readlines(); f.close()
    #最終のDispを取得
    ist = -1
    i = len(lines) - 1
    while i > 0:
        line = lines[i]
        n = line.find("displacements")
        if n >= 0:
            ist = i
            break
        i -= 1
    if ist < 0:
        print(_("error: displacementのdataが存在しません。"))
        return
    #dispDataを取得
    i = ist + 1
    disps = []
    while i < len(lines):
        line = lines[i]
        words = line.split()
        if len(words) == 4:
            disps.append(words)
        elif len(words) == 0:
            pass
        else:
            break
        i += 1
    #initialConditionsのdataを作成
    lines = []
    lines += ["*INITIAL CONDITIONS, TYPE=DISPLACEMENT\n"]
    for (nodeNo, x, y, z) in disps:
        line = ", ".join([nodeNo, "1", x]) + "\n"
        lines += [line]
        line = ", ".join([nodeNo, "2", y]) + "\n"
        lines += [line]
        line = ", ".join([nodeNo, "3", z]) + "\n"
        lines += [line]
    #file作成
    fileName = fileHeader + "_iniCond"
    f = open(fileName, "w", encoding="utf-8"); f.writelines(lines); f.close()



#
#  getArguments
#---------------
def getArguments():
    """ 引数を取得する"""
    fileHeader = ""
    i = 1
    while i < len(sys.argv):
        val = sys.argv[i]
        if val == "-i":
            i += 1
            fileHeader = sys.argv[i]
        i += 1
    return fileHeader

#
#  printHelp
#------------
def printHelp():
    cont  = "------------ createAbaInitialConditions.py ----------------------------\n"
    cont += "calculixの最後の結果データからinitialConditionsを作成する。\n"
    cont += "datファイルからvtu形式に変換する。\n"
    cont += "<使い方>\n"
    cont += "  createAbaInitialConditions.py [option]\n"
    cont += "  [option]\n"
    cont += "    -i <headerFile>    inpファイルのheader名\n"
    cont += "    -h, --help:        helpを出力\n"
    cont += "<使用例>\n"
    cont += "  createAbaInitialConditions.py model\n"
    cont += "           :model.datからmodel_iniCondを作り出す\n"
    print(cont)

if __name__ == "__main__":
    import gettext
    gettext.install("easyistr", os.getenv("easyistr", os.getenv("LOCALE_DIR")))
    #_ = gettext.gettext

    fileHeader = getArguments()
    if os.path.exists(fileHeader + ".inp") == False:
        printHelp()
        exit()
    else:
        createIniCondDisp(fileHeader)
