#!/usr/bin/python3
#  coding: utf-8
#
#           universalDialogsGtk3.py
#
#       よく使用するGtk3用のdialogをまとめたmodule
#
#       okDialog(title, message)
#       errDialog(title, message)
#       warningDialog(title, message)
#       yesNoDialog(title, message, funcYes, funcNo)
#       okCancelDialog(title, message, funcOk, funcCancel)
#       openFileDialog(title, fileDir, funcOk, funcCancel, selName="", filterSets=[])
#       saveFileDialog(title, fileDir, funcOk, funcCancel, selName="", filterSets=[])
#       openFolderDialog(title, showDir, funcOk, funcCancel, selName="", filterSets=[])
#
#
#   24/05/31    新規作成
#      06/30    openFileDialog:fileDidefaultのfolder設定を「set_current_folder」で追加。
#      08/01    okCancelDialog,yesNoDialog,openFileDialog,openFolderDirlog
#               :close関数内のdialog.destroy()を最後から最初に移動。funcOk等の処理内容
#               によっては、dialogが消えない場合があるため。
#      08/14    openFileDialog,openFolderDialog:08/01の修正分が完全ではなく、再修正。
#      10/18    全class:funcNameの起動をGLib.timeout_add(100,funcName,*args)で実行する様修正。
#               dialogを先に消して、funcNameを実行させる為。
#      12/13    全class:親のfreezeを削除
#   25/02/20    openFileDialog,openFolderDialog:複数のpatternが設定できるように修正
#      04/16    openFileDialog:指定したpatternのfileリストのみ表示されない事があり修正。
#      04/21    saveFileDialog:新規追加。
#      04/22    fileChooserDialogの表示方法をfolderが最初になる様に統一。
#               windowsの場合、folder,fileの区別なく名前順でsortして表示されていた為修正。
#      04/24    saveFileDialog:selNameの表示方法を修正。
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib, Gio

import os
import glob

ls = "/n"

#fileChooserDialogの表示がfolderを最初にする様に設定する
#  windowsの表示がfolder、file含めて混在する状態だった為修正。
setting = Gio.Settings.new("org.gtk.Settings.FileChooser")
setting.set_boolean("sort-directories-first", True)


#-----------------
#  okDialog class
#-----------------
class okDialog:

    def __init__(self, title, message, parentWin=None, funcOk=[]):
        self.funcOk = funcOk
        self.dialog = Gtk.MessageDialog(
                parent = parentWin,
                #flags = Gtk.DialogFlags.MODAL,
                message_type =  Gtk.MessageType.INFO,
                #   INFO, WARNING, QUESTION, ERROR, OTHER
                buttons = Gtk.ButtonsType.OK,
                #   NONE, OK, CLOSE, CANCEL, YES_NO, OK_CANCEL
                )
        self.dialog.set_title(title)
        mess1 = message.split(ls)[0]
        mess2 = ls.join(message.split(ls)[1:])
        self.dialog.set_markup(mess1)
        self.dialog.format_secondary_text(mess2)
        #OKボタンにfocusを当てる
        self.dialog.set_default_response(Gtk.ResponseType.OK)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #signalを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.destroy()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            funcArgs = self.funcOk[1:]
            #funcName(*funcArgs)
            GLib.timeout_add(100, funcName, *funcArgs)

#------------------
#  errDialog class
#------------------
class errDialog:

    def __init__(self, title, message, parentWin=None, funcOk=[]):
        self.funcOk = funcOk
        self.dialog = Gtk.MessageDialog(
                parent=parentWin,
                message_type=Gtk.MessageType.ERROR,
                buttons=Gtk.ButtonsType.OK)
        self.dialog.set_title(title)
        mess1 = message.split(ls)[0]
        mess2 = ls.join(message.split(ls)[1:])
        self.dialog.set_markup(mess1)
        self.dialog.format_secondary_text(mess2)
        #self.dialog.message_format = message
        #OKボタンにfocusを当てる
        self.dialog.set_default_response(Gtk.ResponseType.OK)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #signalを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.destroy()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            funcArgs = self.funcOk[1:]
            #funcName(*funcArgs)
            GLib.timeout_add(100, funcName, *funcArgs)

#-----------------------
#  warningDialog class
#-----------------------
class warningDialog:

    def __init__(self, title, message, parentWin=None, funcOk=[]):
        self.funcOk = funcOk
        self.dialog = Gtk.MessageDialog(
                parent=parentWin,
                message_type=Gtk.MessageType.WARNING,
                buttons=Gtk.ButtonsType.OK)
        self.dialog.set_title(title)
        mess1 = message.split(ls)[0]
        mess2 = ls.join(message.split(ls)[1:])
        self.dialog.set_markup(mess1)
        self.dialog.format_secondary_text(mess2)
        #OKボタンにfocusを当てる
        self.dialog.set_default_response(Gtk.ResponseType.OK)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #signalを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, *args):
        self.dialog.destroy()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            funcArgs = self.funcOk[1:]
            #funcName(*funcArgs)
            GLib.timeout_add(100, funcName, *funcArgs)

#--------------------
#  yesNoDialog class
#--------------------
class yesNoDialog:

    def __init__(self, title, message, funcYes=[], funcNo=[], parentWin=None):
        self.dialog = Gtk.MessageDialog(
                parent=parentWin,
                message_type=Gtk.MessageType.INFO,
                buttons=Gtk.ButtonsType.YES_NO)
        self.funcYes = funcYes
        self.funcNo = funcNo
        self.dialog.set_title(title)
        mess1 = message.split(ls)[0]
        mess2 = ls.join(message.split(ls)[1:])
        self.dialog.set_markup(mess1)
        self.dialog.format_secondary_text(mess2)
        #YESボタンにfocusを当てる
        self.dialog.set_default_response(Gtk.ResponseType.YES)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #signalを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, dialog, response):
        self.dialog.destroy()
        if response == Gtk.ResponseType.YES:
            if len(self.funcYes) > 0:
                funcName = self.funcYes[0]
                funcArgs = self.funcYes[1:]
                #funcName(*funcArgs)
                GLib.timeout_add(100, funcName, *funcArgs)
        elif response == Gtk.ResponseType.NO:
            if len(self.funcNo) > 0:
                funcName = self.funcNo[0]
                funcArgs = self.funcNo[1:]
                #funcName(*funcArgs)
                GLib.timeout_add(100, funcName, *funcArgs)
        
#-----------------------
#  okCancelDialog class
#-----------------------
class okCancelDialog:

    def __init__(self, title, message, funcOk=[], funcCancel=[], parentWin=None):
        self.dialog = Gtk.MessageDialog(
            parent = parentWin,
            message_type =  Gtk.MessageType.WARNING,
            buttons = Gtk.ButtonsType.OK_CANCEL)
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        self.dialog.set_title(title)
        mess1 = message.split(ls)[0]
        mess2 = ls.join(message.split(ls)[1:])
        self.dialog.set_markup(mess1)
        self.dialog.format_secondary_text(mess2)
        #OKボタンにfocusを当てる
        self.dialog.set_default_response(Gtk.ResponseType.OK)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #signalを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()
        
    def close(self, dialog, response):
        self.dialog.destroy()
        if response == Gtk.ResponseType.OK:
            if len(self.funcOk) > 0:
                funcName = self.funcOk[0]
                funcArgs = self.funcOk[1:]
                GLib.timeout_add(100, funcName, *funcArgs)
        elif response == Gtk.ResponseType.CANCEL:
            if len(self.funcCancel) > 0:
                funcName = self.funcCancel[0]
                funcArgs = self.funcCancel[1:]
                GLib.timeout_add(100, funcName, *funcArgs)
        
#------------------------
#  openFileDialog class
#------------------------
class openFileDialog:

    def __init__(self, title, fileDir, funcOk=[], funcCancel=[], parentWin=None, selName="", filterSets=[]):
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #dialogを設定
        self.dialog = Gtk.FileChooserDialog(
            parent = parentWin,
            title = title,
            action = Gtk.FileChooserAction.OPEN)
        self.dialog.add_buttons(
            Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL,
            Gtk.STOCK_OPEN, Gtk.ResponseType.OK)
        #patternをlistで取得
        for i in range(len(filterSets)):
            name, pattern = filterSets[i]
            if type(pattern) == str:
                filterSets[i][1] = [pattern]
        #filterを設定
        for [name, pattern] in filterSets:
            filter = Gtk.FileFilter()
            filter.set_name(name)
            for pat in pattern:
                filter.add_pattern(pat)
            self.dialog.add_filter(filter)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #selNameをセット
        fullPath = fileDir + os.sep + selName
        selectDir = os.path.dirname(fullPath)
        selectName = os.path.basename(fullPath)
        saveDir = os.getcwd()
        os.chdir(selectDir)
        files = []
        for name, pattern in filterSets:
            for pat in pattern:
                files += glob.glob(pat)
        #selNameがpatternに該当？
        if selectName in files:
            #該当する場合にselNameを選択表示
            self.dialog.set_filename(selectName)
            self.dialog.set_current_folder(selectDir)
        else:
            #該当しない場合
            self.dialog.set_current_folder(fileDir)
        os.chdir(saveDir)
        #eventを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, dialog, response):
        #fullPathを取得
        fileName = self.dialog.get_filename()
        self.dialog.destroy()
        if response == Gtk.ResponseType.OK:
            if len(self.funcOk) > 0:
                funcName = self.funcOk[0]
                funcArgs = [fileName] + self.funcOk[1:]
                GLib.timeout_add(100, funcName, *funcArgs)
        elif response == Gtk.ResponseType.CANCEL:
            if len(self.funcCancel) > 0:
                funcName = self.funcCancel[0]
                funcArgs = self.funcCancel[1:]
                GLib.timeout_add(100, funcName, *funcArgs)

#------------------------
#  saveFileDialog class
#------------------------
class saveFileDialog:

    def __init__(self, title, fileDir, funcOk=[], funcCancel=[], parentWin=None, selName="", filterSets=[]):
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #dialogを設定
        self.dialog = Gtk.FileChooserDialog(
            parent = parentWin,
            title = title,
            #action = Gtk.FileChooserAction.OPEN)
            action = Gtk.FileChooserAction.SAVE)
        self.dialog.add_buttons(
            Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL,
            Gtk.STOCK_OPEN, Gtk.ResponseType.OK)
        #patternをlistで取得
        for i in range(len(filterSets)):
            name, pattern = filterSets[i]
            if type(pattern) == str:
                filterSets[i][1] = [pattern]
        #filterを設定
        for [name, pattern] in filterSets:
            filter = Gtk.FileFilter()
            filter.set_name(name)
            for pat in pattern:
                filter.add_pattern(pat)
            self.dialog.add_filter(filter)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #selNameをセット
        fullPath = fileDir + os.sep + selName
        selectDir = os.path.dirname(fullPath)
        selectName = os.path.basename(fullPath)
        #selectNameをdialogに表示
        saveDir = os.getcwd()
        os.chdir(selectDir)
        self.dialog.set_current_folder(selectDir)
        self.dialog.set_current_name(selectName)
        os.chdir(saveDir)
        #eventを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, dialog, response):
        fileName = self.dialog.get_filename()
        self.dialog.destroy()
        if response == Gtk.ResponseType.OK:
            if len(self.funcOk) > 0:
                funcName = self.funcOk[0]
                funcArgs = [fileName] + self.funcOk[1:]
                GLib.timeout_add(100, funcName, *funcArgs)
        elif response == Gtk.ResponseType.CANCEL:
            if len(self.funcCancel) > 0:
                funcName = self.funcCancel[0]
                funcArgs = self.funcCancel[1:]
                GLib.timeout_add(100, funcName, *funcArgs)

#-------------------------
#  openFolderDialog class
#-------------------------
class openFolderDialog:

    def __init__(self, title, showDir, funcOk=[], funcCancel=[], parentWin=None, selName="", filterSets=[]):
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #dialogを設定
        self.dialog = Gtk.FileChooserDialog(
            parent = parentWin,
            title = title,
            action = Gtk.FileChooserAction.SELECT_FOLDER,
            create_folders = True)
        self.dialog.add_buttons(
            Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL,
            Gtk.STOCK_OPEN, Gtk.ResponseType.OK)
        #patternをlistで取得
        for i in range(len(filterSets)):
            name, pattern = filterSets[i]
            if type(pattern) == str:
                filterSets[i][1] = [pattern]
        #filterを設定
        for [name, pattern] in filterSets:
            filter = Gtk.FileFilter()
            filter.set_name(name)
            for pat in pattern:
                filter.add_pattern(pat)
            self.dialog.add_filter(filter)
        #modal（freeze）設定する
        #self.dialog.set_modal(True)
        #selNameをセット
        self.dialog.set_current_folder(showDir)
        self.dialog.set_filename(showDir + os.sep + selName)
        #eventを設定
        self.dialog.connect("response", self.close)
        self.dialog.connect("close", self.close)

    def show(self):
        self.dialog.show()

    def close(self, dialog, response):
        folderName = self.dialog.get_filename()
        self.dialog.destroy()
        if response == Gtk.ResponseType.OK:
            if len(self.funcOk) > 0:
                funcName = self.funcOk[0]
                funcArgs = [folderName] + self.funcOk[1:]
                #funcName(*funcArgs)
                GLib.timeout_add(100, funcName, *funcArgs)
        elif response == Gtk.ResponseType.CANCEL:
            if len(self.funcCancel) > 0:
                funcName = self.funcCancel[0]
                funcArgs = self.funcCancel[1:]
                #funcName(*funcArgs)
                GLib.timeout_add(100, funcName, *funcArgs)

