#!/usr/bin/python3
# coding: utf-8
#
#   topoSetEditorCommand
#
#       topoSetDictを作成する
#
#   12/09/25    新規作成
#      12/16    makeCombiContentsを追加
#   13/01/22    setSourceName, setSourceNameWqを修正（「;」が取得できない）
#      01/27    regionToCellを修正
#      02/03    cellToFace:cellSet(Zone)からcell表面のfaceSet(Zone)を抽出を追加
#      08/11    setSourceName:nameがstrかどうかをチェック。strでない場合(list)は、
#               空文を返す。
#   14/12/06    makeCombiContents:newAddsSetを修正
#      12/07    getSourceInfo:sourceNameがlistの場合、「""」を戻す
#   15/07/01    topoSetDictの内容をOF-2.4.0に合わせる
#      07/02    actionの検索方法を変更、resultTypeに「sets」と「zones」を追加
#      07/03    resultType「sets」「zones」にadd, delete, clear, invert, remove actionを追加
#      10/10    faceSetSourceList:「regionToFace」を追加（OF-2.4.0対応）
#   19/12/29    makeRunTopoSetを書き換え、
#               GTK+3, python3用に修正
#   21/06/04    makeSetsZonesContents:sets zonesの処理でadd removeのgroupが未完成
#               だったのを作成した。
#   22/07/18    makeTopoSet_10 classを追加。OF-10からDictの書式が変わっている為追加
#


import os
import glob

import pyTreeFoam


#---------------------
#  makeTopoSet class
#---------------------
class makeTopoSet:
    """ OF-5系のtopoSet"""

    def __init__(self, topoSetDict):
        #topoSetDictからcommandDB作成
        f = open(topoSetDict); lines = f.readlines(); f.close()
        topoSetCont = []
        for line in lines:
            if len(line) > 2:
                if line[:2] == "//":
                    topoSetCont.append(line[2:])
        #コマンド取得
        cellSet = self.getSubCommand("cellSet", topoSetCont)
        faceSet = self.getSubCommand("faceSet", topoSetCont)
        pointSet = self.getSubCommand("pointSet", topoSetCont)
        cellZoneSet = self.getSubCommand("cellZoneSet", topoSetCont)
        faceZoneSet = self.getSubCommand("faceZoneSet", topoSetCont)
        pointZoneSet = self.getSubCommand("pointZoneSet", topoSetCont)
        self.topoSetDB = cellSet + faceSet+ pointSet+ cellZoneSet+ faceZoneSet+ pointZoneSet
        #----- set -------------
        self.cellSetSourceList = [
            #<sourceType>    <検索word>     <sourcename置き換えword>
            # source         sourceInfo            修正名
            ["cellSet",      "cellToCell",         "set"],
            ["faceSet",      "faceToCell",         "set"],
            ["pointSet",     "pointToCell",        "set"],
            ["cellZone",     "zoneToCell",         "name"],
            ["faceZone",     "faceZoneToCell",     "name"],
            ["surface",      "surfaceToCell",      "file"],
            ["label",        "labelToCell",        ""],
            ["shape",        "shapeToCel",         ""],
            ["box",          "boxToCell",          ""],
            ["cylinder",     "cylinderToCell",     ""],
            ["sphere",       "sphereToCell",       ""],
            ["rotatedBox",   "rotatedBoxToCell",   ""],
            ["targetVolume", "targetVolumeToCell", ""],
            ["nearest",      "nearestToCell",      ""],
            ["field",        "fieldToCell",        ""],
            ["region",       "regionToCell",       "set"]
            ]
        self.faceSetSourceList = [
            ["cellSet", "cellToFace",      "set"],
            ["faceSet", "faceToFace",      "set"],
            ["pointSet", "pointToFace",    "set"],
            ["faceZone", "zoneToFace",     "name"],
            ["label",    "labelToFace",    ""],
            ["box",      "boxToFace",      ""],
            ["patch",    "patchToFace",    "name"],
            ["normal",   "normalToFace",   ""],
            ["boundary", "boundaryToFace", ""],
            ["region",   "regionToFace",   "set"]
            ]
        self.pointSetSourceList = [
            ["cellSet",   "cellToPoint",    "set"],
            ["faceSet",   "faceToPoint",    "set"],
            ["pointSet",  "pointToPoint",   "set"],
            ["pointZone", "zoneToPoint",    "name"],
            ["surface",   "surfaceToPoint", "file"],
            ["label",     "labelToPoint",   ""],
            ["box",       "boxToPoint",     ""],
            ["nearest",   "nearestToPoint", ""]
            ]
        self.setsSourceList = [
            ["cellSet",   "setToCellZone",  "set"],
            ["faceSet",   "setToFaceZone",  "faceSet"],
            ["pointSet",  "setToPointZone", "set"],
            ["cellZone",  "zoneToCell",     "name"],
            ["faceZone",  "zoneToFace",     "name"],
            ["pointZone", "zoneToPoint",    "name"]
            ]
        #----- zone -------------
        self.cellZoneSetSourceList = [
            ["cellSet", "setToCellZone", "set"]
            ]
        self.faceZoneSetSourceList = [
            ["faceSet", "setToFaceZone", "faceSet"],
            ["searchableSurface", "searchableSurfaceToFaceZone", ""],
            ["sets", "setsToFaceZone", "cellSet", "faceSet"]
            ]
        self.pointZoneSetSourceList = [
            ["pointSet", "setToPointZone", "set"]
            ]
        self.zonesSourceList = [
            ["cellSet",  "setToCellZone",  "set"],
            ["faceSet",  "setToFaceZone",  "faceSet"],
            ["pointSet", "setToPointZone", "set"]
            ]

    def getSubCommand(self, comm, cont):
        """ subCommandをcontから取得する"""
        i = 0
        while i < len(cont):
            line = cont[i]
            if len(line) > len(" " + comm):
                if line[:len(" " + comm)] == " " + comm:
                    i += 1
                    break
            i += 1
        #commを取得
        comms = []
        while i < len(cont):
            line = cont[i]
            if len(line) > 2:
                if line[1] == " ":
                    comms.append(line)
                else:
                    if ((line.find("cell") >= 0 and line.find("cell") < 3)
                        or (line.find("face") >= 0 and line.find("face") < 3)
                        or (line.find("point") >= 0 and line.find("point") < 3)):
                        break
            i += 1
        return "".join(comms)

    def getCommFromDB(self, comm):
        comms = self.topoSetDB
        p = self.findCommand(comm)
        if p < 0:
            return ""

        p = self.getBeforeLineHead(comms, p)
        while comms[p:p+6] == "    //":
            p = self.getBeforeLineHead(comms, p)
        ps = self.getNextLineHead(comms, p)
        commsOp = pyTreeFoam.strOp(comms)
        (_lineCont, p, _kind) = commsOp.get1line(ps)
        (_lineCont, p, _kind) = commsOp.get1line(p)
        commCont = comms[ps:p]
        return commCont

    def findCommand(self, comm):
        """ " source " と <comm>の文字列を検索"""

        def skipSp(p):
            while comms[p] == " ":
                p += 1
            return p

        comms = self.topoSetDB
        p = 0
        #flag = 0
        while 0 <= p and p < len(comms):
            p = comms.find(" source ", p)
            if p >= 0:
                p += len(" source ")
                p = skipSp(p)
                if comms[p:p + len(comm)] == comm:
                    #flag = 1
                    break
        if p >= len(comms):
            p = -1
        return p

    def getBeforeLineHead(self, cont, p):
        p -= 1
        while cont[p] != "\n" and p >= 0:
            p -= 1
        p -= 1
        while cont[p] != "\n" and p >= 0:
            p -= 1
        p += 1
        return p

    def getNextLineHead(self, cont, p):
        p += 1
        while cont[p] != "\n" and p <= len(cont):
            p += 1
        p += 1
        return p

    def setSourceName(self, cont, comm, name):
        """ sourceInfoにnameをセットする。"""
        if type(name) == list:
            return ""
        lines = cont.split("\n")
        i = 0
        for line in lines:
            lineOp = pyTreeFoam.strOp(line)
            (keyword, p) = lineOp.getKeyword(0)
            if keyword == comm:
                sp = p
                (keyword, ep) = lineOp.getKeyword(sp)
                #keywordの内容により処理変更
                if keyword[0] == '"':
                    newline = line[:p] + ' "' + name + '"; ' + line[ep:]
                else:
                    newline = line[:p] + " " + name + line[ep:]
                lines[i] = newline
                break
            i += 1
        newCont = "\n".join(lines)
        return newCont

    def add4Spaces(self, cont):
        """ 各行に空白4ヶを追加する"""
        lines = cont.split("\n")
        for i in range(len(lines)):
            lines[i] = "    " + lines[i]
        cont = "\n".join(lines)
        return cont

    #
    #  makeCombiContents
    #--------------------
    def makeCombiContents(self, sourceType, sourceName, action, resultType, resultName):
        """ 組み合わせactionの内容を作成"""
        #rename　SetとZoneの名称変更
        if action == "renameSetZone":
            if sourceType.find("Zone") >= 0:
                if sourceType == "cellZone":
                    cont  = self.makeContents(sourceType, sourceName, "new",
                            "cellSet", "temp")
                    cont += self.makeContents("cellSet", "temp", "new",
                            "cellZoneSet", resultName)
                    cont += self.makeContents("cellSet", sourceName, "remove",
                            "cellZoneSet", sourceName)
                    cont += self.makeContents("cellSet", "temp", "remove",
                            "cellZoneSet", "temp")
                else:
                    cont  = self.makeContents(sourceType, sourceName, "new",
                            "faceSet", resultName)
                    cont += self.makeContents("faceSet", sourceName, "new",
                            "faceZoneSet", resultName)
                    cont += self.makeContents("faceSet", sourceName, "remove",
                            "faceZoneSet", sourceName)
            elif sourceType.find("Set") >= 0:
                cont  = self.makeContents(sourceType, sourceName, "new",
                            sourceType, resultName)
                cont += self.makeContents(sourceType, sourceName, "remove",
                            sourceType, sourceName)
            else:
                cont = u""
            return cont

        #newAdds　cellSet(faceSet)を複数加え、新しい名称をつける
        elif action == "newAddsSet":
            if sourceType == "faceSet":
                #newAddFace
                if type(sourceName) == str:
                    #one sourceName
                    cont  = self.makeContents(sourceType, sourceName, "new",
                                "faceSet", resultName)
                    return cont
                else:
                    #multi sourceName
                    cont  = self.makeContents(sourceType, sourceName[0], "new",
                                "faceSet", resultName)
                    i = 1
                    while i < len(sourceName):
                        cont += self.makeContents(sourceType, sourceName[i], "add",
                                "faceSet", resultName)
                        i += 1
                return cont

            elif sourceType == "cellSet":
                #newAddCell
                if type(sourceName) == str:
                    #one sourceName
                    cont  = self.makeContents(sourceType, sourceName, "new",
                                "cellSet", resultName)
                    return cont
                else:
                    #multi sourceName
                    cont  = self.makeContents(sourceType, sourceName[0], "new",
                                "cellSet", resultName)
                    i=1
                    while i < len(sourceName):
                        cont += self.makeContents(sourceType, sourceName[i], "add",
                                "cellSet", resultName)
                        i += 1
                return cont
            else:
                return ""

        #newInvert　cellSetの反転をnewNameでつくる
        elif action == "newInvertSet":
            if sourceType == "cellSet":
                cont  = self.makeContents(sourceType, sourceName, "new",
                            "cellSet", resultName)
                cont += self.makeContents(sourceType, resultName, "invert",
                            "cellSet", resultName)
            else:
                cont = ""
            return cont

        #newCellToFace  cellSet（Zone）からcell表面のfaceSet（Zone）を作る
        elif action == "newCellToFace":
            if sourceType == "cellSet":
                cont = self.makeContentsCellToFace(sourceType, sourceName, action,
                        resultType, resultName)
            elif sourceType == "cellZone":
                cont = self.makeContents(sourceType, sourceName, "new", "cellSet",
                        sourceName)
                cont += self.makeContentsCellToFace("cellSet", sourceName, action,
                        resultType, resultName)
                cont += self.makeContents("faceSet", resultName, "new", "faceZoneSet",
                        resultName)
            return cont

        #newZonesToSets:cellZone(faceZone)からcellSet(faceSet)を作る
        elif action == "newZonesToSets":
            if sourceType == "cellZone":
                if type(sourceName) != list:
                    #one sourceName(string)
                    cont = self.makeContents(sourceType, sourceName, "new", "cellSet",
                            sourceName)
                else:
                    #multi sourceName(list)
                    cont = ""
                    i = 0
                    while i<len(sourceName):
                        cont += self.makeContents(sourceType, sourceName[i], "new", "cellSet",
                                sourceName[i])
                        i += 1
                return cont
            elif sourceType == "faceZone":
                if type(sourceName) != list:
                    #one sourceName(string)
                    cont = self.makeContents(sourceType, sourceName, "new", "faceSet",
                            sourceName)
                else:
                    #multi sourceName(list)
                    cont = ""
                    i = 0
                    while i<len(sourceName):
                        cont += self.makeContents(sourceType, sourceName[i], "new", "faceSet",
                                sourceName[i])
                        i += 1
                return cont
        else:
            return ""

    def makeContentsCellToFace(self, sourceType, sourceName, action, resultType, resultName):
        Tcont  = self.makeContents(sourceType, sourceName, "new", "faceSet", "temp")
        cont = self.setOption(Tcont, "both")
        Tcont = self.makeContents(sourceType, sourceName, "new", "faceSet", resultName)
        cont += self.setOption(Tcont, "all")
        cont += self.makeContents("faceSet", "temp", "delete", "faceSet", resultName)
        cont += self.makeContents(sourceType, sourceName, "remove", "faceSet", "temp")
        return cont

    def setOption(self, cont, optionCont):
        newCont = self.setSourceName(cont, "option", optionCont)
        return newCont


    #
    #  makeSetsZonesContents
    #------------------------
    def makeSetsZonesContents(self, sourceType, sourceName, action, resultType, resultName):
        """ sets or zones の繰り返しのcontentsを作成"""
        contents = ""
        if action == "new":
            #action new
            contents = self.makeNewSetsZonesContents(sourceType, sourceName, action,
                                resultType, resultName)
        elif action == "add" or action == "delete":
            #action add, delete
            contents = self.makeAddDeleteSetsZonesContents(sourceType, sourceName, action,
                                resultType, resultName)
        elif action == "remove" or action == "clear" or action == "invert":
            #action remove, clear, invert
            contents = self.makeRemoveSetsZonesContents(sourceType, sourceName, action,
                                resultType, resultName)
        return contents

    #
    #  makeNewSetsZonesContents
    def makeNewSetsZonesContents(self, sourceType, sourceName, action, resultType, resultName):
        """ action newの場合の sets or zones の繰り返し"""
        #resultNameを取得（sourceNameと同じ）
        if type(sourceName) == list:
            names = sourceName
        else:
            names = [sourceName]
        #resultTypeを取得
        resultType = self.changeResultTypeFromSourceType(sourceType)
        #内容を取得
        footer = self.makeContentsFooter()
        contents = ""
        for name in names:
            contU = self.makeContentsHeader(action, sourceType, resultType, name)
            cont = self.getSourceInfo(sourceType, name, action, resultType)
            if cont != "":
                cont = self.add4Spaces(cont)
            contents += contU + cont + footer
        return contents

    #
    #  makeAddDeleteSetsZonesContents
    def makeAddDeleteSetsZonesContents(self, sourceType, sourceName, action, resultType, resultName):
        """ action add, deleteの場合の sets or zones の繰り返し"""
        if type(sourceName) == str or type(sourceName) == bytes:
            names = [sourceName]
        else:
            names = sourceName
        #resultTypeを取得
        resultType = self.getResultTypeFromSourceType(sourceType, resultType)
        #内容を取得
        footer = self.makeContentsFooter()
        contents = ""
        for name in names:
            contU = self.makeContentsHeader(action, sourceType, resultType, resultName)
            cont = self.getSourceInfo(sourceType, name, action, resultType)
            if cont != "":
                cont = self.add4Spaces(cont)
            contents += contU + cont + footer
        return contents

    #
    #  getResultTypeFromSourceType
    def getResultTypeFromSourceType(self, sourceType, resultType):
        """ sourceTypeからresultTypeを特定する（同じtypeを取得）"""
        name = ""
        if resultType == "sets":
            if sourceType[-3:] == "Set":
                name = sourceType
            elif sourceType[-4:] == "Zone":
                name = sourceType[:-4] + "Set"
        elif resultType == "zones":
            if sourceType[-3:] == "Set":
                name = sourceType[:-3] + "ZoneSet"
            elif sourceType[:-4] == "Zone":
                name = sourceType + "Set"
        return name

    #
    #  changeResultTypeFromSourceType
    def changeResultTypeFromSourceType(self, sourceType):
        """ sourceTypeからresultTypeを特定する（反対のtypeを取得）"""
        name = ""
        if sourceType[-3:] == "Set":
            name = sourceType[:-3] + "ZoneSet"
        elif sourceType[-4:] == "Zone":
            name = sourceType[:-4] + "Set"
        return name

    #
    #  makeRemoveSetsZonesContents(sourceType, sourceName, action,
    def makeRemoveSetsZonesContents(self, sourceType, sourceName, action, resultType, resultName):
        """ action removeの場合の sets or zones の繰り返し"""
        #nameを取得
        cellNames = []
        faceNames = []
        pointNames = []
        for name in resultName:
            words = name.split(":")
            if words[0] == "c":
                cellNames.append(words[1])
            elif words[0] == "f":
                faceNames.append(words[1])
            elif words[0] == "p":
                pointNames.append(words[1])
        #内容を取得
        contents = ""
        footer = self.makeContentsFooter()
        if resultType == "sets":
            nType = "Set"
        elif resultType == "zones":
            nType = "ZoneSet"
        #cellNameを作成
        if len(cellNames) > 0:
            for name in cellNames:
                contU = self.makeContentsHeader(action, sourceType, "cell"+nType, name)
                contents += contU + footer
        #faceNameを作成
        if len(faceNames) > 0:
            for name in faceNames:
                contU = self.makeContentsHeader(action, sourceType, "face"+nType, name)
                contents += contU + footer
        #pointNameを作成
        if len(pointNames) > 0:
            for name in pointNames:
                contU = self.makeContentsHeader(action, sourceType, "point"+nType, name)
                contents += contU + footer
        return contents

    #
    #  makeContents
    #---------------
    def makeContents(self, sourceType, sourceName, action, resultType, resultName):
        """ 処理内容を作成"""
        contU = self.makeContentsHeader(action, sourceType, resultType, resultName)
        cont = self.getSourceInfo(sourceType, sourceName, action, resultType)
        if cont != "":
            cont = self.add4Spaces(cont)
        footer = self.makeContentsFooter()
        contents = contU + cont + footer
        return contents

    #
    #  makeContentsHeader
    def makeContentsHeader(self, action, sourceType, resultType, resultName):
        """ 処理内容のheader部を作成"""
        contU  = "\n    // " + action + " To " + resultType + "\n"
        contU += "    {\n"
        contU += "        name    " + resultName + ";\n"
        contU += "        type    " + resultType + ";\n"
        contU += "        action  " + action + ";\n"
        return contU    

    #
    #  makeContentsFooter
    def makeContentsFooter(self):
        """ 処理のfooter部を作成"""
        cont = "\n    }\n"
        return cont

    #
    #  getSourceInfo
    def getSourceInfo(self, sourceType, sourceName, action, resultType):
        """ sourceのoptionを取得"""
        #  source内容を取得
        #    <DB内容の例>
        #       // Copy elements from cellSet
        #       source cellToCell;
        #       sourceInfo
        #       {
        #           set c1;
        #       }
        def searchNameGetCont(resultSourceList):
            cont = ""
            for sourceList in resultSourceList:
                if sourceList[0] == sourceType:
                    searchName = sourceList[1]
                    keyName = sourceList[2]
                    cont = self.getCommFromDB(searchName)
                    if keyName != "":
                        cont = self.setSourceName(cont, keyName, sourceName)
                    break
            return cont

        #  sourceType:setsの内容を取得
        def searchSetsCFNameGetCont():
            cont = self.getCommFromDB("sets")
            if len(sourceName) == 2:
                for name in sourceName:
                    setName = name.split(":")
                    if len(setName) == 2:
                        if setName[0] == "c":
                            cont = self.setSourceName(cont, "cellSet", setName[1])
                        elif setName[0] == "f":
                            cont = self.setSourceName(cont, "faceSet", setName[1])
            return cont

        #no source action?
        if action == "clear" or action == "invert" or action == "remove":
            return ""

        #combind or sets action?
        cont = ""
        if type(sourceName) == list:
            if sourceType == "sets":
                cont = searchSetsCFNameGetCont()
            return cont

        #sourceの内容を取得
        cont = ""
        if resultType == "cellSet":
            cont = searchNameGetCont(self.cellSetSourceList)
        elif resultType == "faceSet":
            cont = searchNameGetCont(self.faceSetSourceList)
        elif resultType == "pointSet":
            cont = searchNameGetCont(self.pointSetSourceList)
        elif resultType == "cellZoneSet":
            cont = searchNameGetCont(self.cellZoneSetSourceList)
        elif resultType == "faceZoneSet":
            cont = searchNameGetCont(self.faceZoneSetSourceList)
        elif resultType == "pointZoneSet":
            cont = searchNameGetCont(self.pointZoneSetSourceList)
        elif resultType == "sets":
            cont = searchNameGetCont(self.setsSourceList)
        elif resultType == "zones":
            cont = searchNameGetCont(self.zonesSourceList)
        return cont


#------------------------
#  makeTopoSet1812 class
#------------------------
class makeTopoSet1812(makeTopoSet):
    """ OF-v1812系のtopoSet。makeTopoSet classを継承する。"""

    def __init__(self, topoSetDict):
        #topoSetDictからcommandDB作成
        f = open(topoSetDict); topoSetCont = f.read(); f.close()
        #コマンド取得
        cellSet = self.getSubCommand("cellSet_doc", topoSetCont)
        faceSet = self.getSubCommand("faceSet_doc", topoSetCont)
        pointSet = self.getSubCommand("pointSet_doc", topoSetCont)
        cellZoneSet = self.getSubCommand("cellZoneSet_doc", topoSetCont)
        faceZoneSet = self.getSubCommand("faceZoneSet_doc", topoSetCont)
        pointZoneSet = self.getSubCommand("pointZoneSet_doc", topoSetCont)
        self.topoSetDB = cellSet + faceSet+ pointSet+ cellZoneSet+ faceZoneSet+ pointZoneSet
        #----- set -------------
        self.cellSetSourceList = [
            #<sourceType>    <検索word>     <sourcename置き換えword>
            # source         sourceInfo            修正名
            ["cellSet",           "cellToCell",  "set"],
            ["faceSet",           "faceToCell",  "set"],
            ["pointSet",          "pointToCell", "set"],
            ["cellZone",          "zoneToCell",  "zone"],
            ["faceZone",          "faceZoneToCell", "zone"],
            ["surface",           "surfaceToCell", "file"],
            ["label",             "labelToCell", ""],
            ["shape",             "shapeToCel",  ""],
            ["box",               "boxToCell",   ""],
            ["cylinder",          "cylinderToCell", ""],
            ["sphere",            "sphereToCell", ""],
            ["rotatedBox",        "rotatedBoxToCell", ""],
            ["targetVolume",      "targetVolumeToCell", ""],
            ["nearest",           "nearestToCell", ""],
            ["field",             "fieldToCell", ""],
            ["region",            "regionToCell", "set"],
            ["patch",             "patchToCell", "patch"],
            ["searchableSurface", "searchableSurfaceToCell", "surface"]
            ]
        self.faceSetSourceList = [
            ["cellSet",  "cellToFace",  "set"],
            ["faceSet",  "faceToFace",  "set"],
            ["pointSet", "pointToFace", "set"],
            ["faceZone", "zoneToFace",  "zone"],
            ["label",    "labelToFace", ""],
            ["box",      "boxToFace",   ""],
            ["patch",    "patchToFace", "patch"],
            ["normal",   "normalToFace", ""],
            ["boundary", "boundaryToFace", ""],
            ["region",   "regionToFace", "set"],
            ["cylinder", "cylinderToFace", ""],
            ["sphere",   "sphereToFace", ""],
            ["patch",    "patchToFace", "patch"],
            ["searchableSurface", "searchableSurfaceToFace", ""]
            ]
        self.pointSetSourceList = [
            ["cellSet",   "cellToPoint",  "set"],
            ["faceSet",   "faceToPoint",  "set"],
            ["pointSet",  "pointToPoint", "set"],
            ["pointZone", "zoneToPoint",  "zone"],
            ["surface",   "surfaceToPoint", "file"],
            ["label",     "labelToPoint", ""],
            ["box",       "boxToPoint",   ""],
            ["nearest",   "nearestToPoint", ""],
            ["cylinder",  "cylinderToPoint", ""],
            ["sphere",    "sphereToPoint", ""]
            ]
        self.setsSourceList = [
            ["cellSet",   "setToCellZone", "set"],
            ["faceSet",   "setToFaceZone", "faceSet"],
            ["pointSet",  "setToPointZone", "set"],
            ["cellZone",  "zoneToCell", "zone"],
            ["faceZone",  "zoneToFace", "zone"],
            ["pointZone", "zoneToPoint", "zone"]
            ]
        #----- zone -------------
        self.cellZoneSetSourceList = [
            ["cellSet", "setToCellZone", "set"]
            ]
        self.faceZoneSetSourceList = [
            ["faceSet",  "setToFaceZone",  "faceSet"],
            ["searchableSurface", "searchableSurfaceToFaceZone", ""],
            ["sets",     "setsToFaceZone", "cellSet", "faceSet"],
            ["faceZone", "faceZoneToFaceZone", "zone"]
            ]
        self.pointZoneSetSourceList = [
            ["pointSet", "setToPointZone", "set"]
            ]
        self.zonesSourceList = [
            ["cellSet", "setToCellZone", "set"],
            ["faceSet", "setToFaceZone", "faceSet"],
            ["pointSet", "setToPointZone", "set"]
            ]

    def getSubCommand(self, comm, cont):
        contOp = pyTreeFoam.strOp(cont)
        p = contOp.skipFoamFile()
        (comms, p) = contOp.getKeywordContents(comm, p)
        return comms

    def getCommFromDB(self, comm):
        comms = self.topoSetDB
        loop = True
        p = 0
        commCont = ""
        commsOp = pyTreeFoam.strOp(comms)
        while loop == True:
            (lineCont, p) = commsOp.getMiddlePair(p)
            lineContOp = pyTreeFoam.strOp(lineCont)
            (subCont, _pp, _kind) = lineContOp.get1line(0)
            words = subCont.split()
            if len(words) >= 2:
                key = subCont.split()[1]
                if key[-1] == ";":
                    key = key[:-1]
                if key == comm:
                    commCont = lineCont
                    break
            else:
                break
        return commCont

    def add4Spaces(self, cont):
        """ 各行に空白4ヶを追加する"""
        lines = cont.split("\n")
        for i in range(len(lines)):
            lines[i] = "    " + lines[i]
        cont = "\n".join(lines)
        return cont

    def setSourceName(self, cont, comm, name):
        if type(name) == list:
            return ""
        lines = cont.split("\n")
        for i in range(len(lines)):
            line = lines[i]
            lineOp = pyTreeFoam.strOp(line)
            (keyword, p) = lineOp.getKeyword(0)
            if keyword == comm:
                sp = p
                (keyword, ep) = lineOp.getKeyword(sp)
                #keywordの内容により処理変更
                if keyword[0] == '"':
                    newline = line[:p] + ' "' + name + '"; ' + line[ep:]
                else:
                    newline = line[:p] + " " + name + line[ep:]
                lines[i] = newline
                break
            i += 1
        newCont = "\n".join(lines)
        return newCont

    #
    #  makeCombiContents
    #--------------------
    #def makeCombiContents(self, sourceType, sourceName, action, resultType, resultName):
    #  makeTopoSet classを継承している為、不要  

    #
    #  makeSetsZonesContents
    #------------------------
    #def makeSetsZonesContents(self, sourceType, sourceName, action, resultType, resultName):
    #　makeTopoSet classを継承している為、不要

    #
    #  makeContents
    #---------------
    def makeContents(self, sourceType, sourceName, action, resultType, resultName):
        """ 処理内容を作成"""
        contU = self.makeContentsHeader(action, sourceType, resultType, resultName)
        cont = self.getSourceInfo(sourceType, sourceName, action, resultType)
        if cont != "":
            cont = self.add4Spaces(cont)
        footer = self.makeContentsFooter()
        contents = contU + cont + footer
        return contents

    #
    #  makeContentsHeader
    def makeContentsHeader(self, action, sourceType, resultType, resultName):
        """ 処理内容のheader部を作成"""
        contU  = "\n    // " + action + " To " + resultType + "\n"
        contU += "    {\n"
        contU += "        name    " + resultName + ";\n"
        contU += "        type    " + resultType + ";\n"
        contU += "        action  " + action + ";\n"
        return contU    

    #
    #  makeContentsFooter
    def makeContentsFooter(self):
        """ 処理のfooter部を作成"""
        cont = "\n    }\n"
        return cont

    #
    #  getSourceInfo
    def getSourceInfo(self, sourceType, sourceName, action, resultType):
        """ sourceのoptionを取得"""
        #  source内容を取得
        #    <DB内容の例>
        #       // Copy elements from cellSet
        #       {
        #           source cellToCell;
        #           set     (c1 c2);
        #           // or
        #           set     c1;
        #       }
        def searchNameGetCont(resultSourceList):
            cont = ""
            for sourceList in resultSourceList:
                if sourceList[0] == sourceType:
                    searchName = sourceList[1]
                    keyName = sourceList[2]
                    cont = self.getCommFromDB(searchName)
                    if keyName != "":
                        cont = self.setSourceName(cont, keyName, sourceName)
                    break
            return cont

        #  sourceType:setsの内容を取得
        def searchSetsCFNameGetCont():
            #cont = getCommFromDB("sets")
            searchName = "setsToFaceZone"
            cont = self.getCommFromDB(searchName)
            if len(sourceName) == 2:
                for name in sourceName:
                    setName = name.split(":")
                    if len(setName) == 2:
                        if setName[0] == "c":
                            cont = self.setSourceName(cont, "cellSet", setName[1])
                        elif setName[0] == "f":
                            cont = self.setSourceName(cont, "faceSet", setName[1])
            return cont

        #no source action?
        if action == "clear" or action == "invert" or action == "remove":
            return ""

        #combind or sets action?
        cont = ""
        if type(sourceName) == list:
            if sourceType == "sets":
                cont = searchSetsCFNameGetCont()
            return cont

        #sourceの内容を取得
        cont = ""
        if resultType == "cellSet":
            cont = searchNameGetCont(self.cellSetSourceList)
        elif resultType == "faceSet":
            cont = searchNameGetCont(self.faceSetSourceList)
        elif resultType == "pointSet":
            cont = searchNameGetCont(self.pointSetSourceList)
        elif resultType == "cellZoneSet":
            cont = searchNameGetCont(self.cellZoneSetSourceList)
        elif resultType == "faceZoneSet":
            cont = searchNameGetCont(self.faceZoneSetSourceList)
        elif resultType == "pointZoneSet":
            cont = searchNameGetCont(self.pointZoneSetSourceList)
        elif resultType == "sets":
            cont = searchNameGetCont(self.setsSourceList)
        elif resultType == "zones":
            cont = searchNameGetCont(self.zonesSourceList)
        return cont


#------------------------
#  makeTopoSet_10 class
#------------------------
class makeTopoSet_10(makeTopoSet):
    """ OF-10のtopoSet。makeTopoSet classを継承する。
    OF-10からDictの記述の形式が変更されている"""

    def __init__(self, topoSetDict):
        #topoSetDictからcommandDB作成
        f = open(topoSetDict); lines = f.readlines(); f.close()
        topoSetCont = []
        for line in lines:
            if len(line) > 2:
                if line[:2] == "//":
                    topoSetCont.append(line[2:])
        #コマンド取得
        cellSet = self.getSubCommand("cellSet", topoSetCont)
        faceSet = self.getSubCommand("faceSet", topoSetCont)
        pointSet = self.getSubCommand("pointSet", topoSetCont)
        cellZoneSet = self.getSubCommand("cellZoneSet", topoSetCont)
        faceZoneSet = self.getSubCommand("faceZoneSet", topoSetCont)
        pointZoneSet = self.getSubCommand("pointZoneSet", topoSetCont)
        self.topoSetDB = cellSet + faceSet+ pointSet+ cellZoneSet+ faceZoneSet+ pointZoneSet
        #----- set -------------
        self.cellSetSourceList = [
            #<sourceType>    <検索word>     <sourcename置き換えword>
            # source         sourceInfo            修正名
            ["label",        "labelToCell",        ""],
            ["cellSet",      "cellToCell",         "set"],
            ["cellZone",     "zoneToCell",         "zone"],
            ["faceZone",     "faceZoneToCell",     "zone"],
            ["faceSet",      "faceToCell",         "set"],
            ["pointSet",     "pointToCell",        "set"],
            ["shape",        "shapeToCel",         ""],
            ["box",          "boxToCell",          ""],
            ["rotatedBox",   "rotatedBoxToCell",   ""],
            ["cylinder",     "cylinderToCell",     ""],
            ["sphere",       "sphereToCell",       ""],
            ["nearest",      "nearestToCell",      ""],
            ["surface",      "surfaceToCell",      "file"],
            ["field",        "fieldToCell",        "fieldName"],
            ["region",       "regionToCell",       "set"],
            ["targetVolume", "targetVolumeToCell", ""]
            ]
        self.faceSetSourceList = [
            ["faceSet", "faceToFace",      "set"],
            ["cellSet", "cellToFace",      "set"],
            ["pointSet", "pointToFace",    "set"],
            ["label",    "labelToFace",    ""],
            ["patch",    "patchToFace",    "patch"],
            ["boundary", "boundaryToFace", ""],
            ["faceZone", "zoneToFace",     "zone"],
            ["box",      "boxToFace",      ""],
            ["normal",   "normalToFace",   ""],
            ["region",   "regionToFace",   "set"]
            ]
        self.pointSetSourceList = [
            ["pointSet",  "pointToPoint",   "set"],
            ["cellSet",   "cellToPoint",    "set"],
            ["faceSet",   "faceToPoint",    "set"],
            ["label",     "labelToPoint",   ""],
            ["pointZone", "zoneToPoint",    "zone"],
            ["nearest",   "nearestToPoint", ""],
            ["box",       "boxToPoint",     ""],
            ["surface",   "surfaceToPoint", "file"],
            ["patch",     "patchDistanceToCell", "patch"]
            ]
        self.setsSourceList = [
            ["cellSet",   "setToCellZone",  "set"],
            ["faceSet",   "setToFaceZone",  "faceSet"],
            ["pointSet",  "setToPointZone", "set"],
            ["cellZone",  "zoneToCell",     "zone"],
            ["faceZone",  "zoneToFace",     "zone"],
            ["pointZone", "zoneToPoint",    "zone"]
            ]
        #----- zone -------------
        self.cellZoneSetSourceList = [
            ["cellSet", "setToCellZone", "set"]
            ]
        self.faceZoneSetSourceList = [
            ["faceSet", "setToFaceZone",  "faceSet"],
            ["sets",    "setsToFaceZone", "cellSet", "faceSet"],
            ["searchableSurface", "searchableSurfaceToFaceZone", ""]
            ]
        self.pointZoneSetSourceList = [
            ["pointSet", "setToPointZone", "set"]
            ]
        self.zonesSourceList = [
            ["cellSet",  "setToCellZone",  "set"],
            ["faceSet",  "setToFaceZone",  "faceSet"],
            ["pointSet", "setToPointZone", "set"]
            ]
