#!/usr/bin/python3
#  coding: utf-8
#
#   startingTreeFoam.py
#
#   20/04/22    多言語化対応
#      05/23    install後の初回起動時にエラーが発生するため
#               checkUserSettingFolderを追加。
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#------------------
#  windowApp class
#------------------
class windowApp:

    def __init__(self):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        gladeFile = os.getenv("TreeFoamPath") + "/glade/startingTreeFoam.glade"
        self.builder.add_from_file(gladeFile)
        self.builder.connect_signals(self)
        self.mainWindow = self.builder.get_object("window1")
        self.mainWindow.connect("delete-event", self.close)
        #titleBar非表示
        self.mainWindow.set_decorated(False)
        #windowを最上位に表示させる
        self.mainWindow.set_keep_above(True)
        #GUIのobjectを取得
        self.setGtkObject()
        #version読み込み表示
        self.setVersion()
        #folder有無チェック($TreeFoamUserPath/tempフォルダをチェック)
        self.checkUserSettingFolder()
        #入力ファイルクリア
        self.inputFileName = os.getenv("startingFile")
        self.openFlag = None
        # f = open(self.inputFileName, "w"); f.close()
        # #入力ファイルopen
        # self.inputFile = open(self.inputFileName)
        #timerEvent
        GLib.timeout_add(200, self.timerEvent)
        self.count = 0

    #
    #  main
    #--------
    def main(self):
        #GUI表示
        self.mainWindow.show_all()
        Gtk.main()

    #
    #  close
    #--------
    def close(self, *args):
        if os.path.exists(self.inputFileName) == True:
            os.remove(self.inputFileName)
        Gtk.main_quit()

    #
    #  setGtkObject
    #---------------
    def setGtkObject(self):
        self.label_version = self.builder.get_object("label_version")
        self.label_status = self.builder.get_object("label_status")

    #
    #  setVersion
    #-------------
    def setVersion(self):
        fileName = os.getenv("TreeFoamPath") + "/TreeFoamVersion"
        f = open(fileName); version = f.read(); f.close()
        cont = "version " + version
        self.label_version.set_text(cont)

    #
    #  onClose
    #----------
    def onClose(self, event):
        """ closeボタンをクリック"""
        self.close()

    #
    #  timerEvent
    #-------------
    def timerEvent(self):
        """ timerEvent"""
        self.count += 1

        if os.path.exists(self.inputFileName) == True:
            if self.openFlag == None:
                self.inputFile = open(self.inputFileName)
                self.openFlag = "yes"

            line = self.inputFile.readline()
            if line[:len("close")] == "close":
                self.close()
                return
            elif line != "":
                self.label_status.set_text(line[:-1])

        if self.count < 300:
            GLib.timeout_add(100, self.timerEvent)
        else:
            #カウンタが300を超えるとcloseする
            self.close()
            return

    #
    #  checkUserSettingFolder
    #-------------------------
    def checkUserSettingFolder(self):
        """ 最低限のfolder有無をチェックする"""
        treeFoamUserPath = os.getenv("TreeFoamUserPath")
        if os.path.exists(treeFoamUserPath) == False:
            os.mkdir(treeFoamUserPath)
        if os.path.exists(treeFoamUserPath + "/temp") == False:
            os.mkdir(treeFoamUserPath + "/temp")

if __name__ == "__main__":
    import gettext
    gettext.install("treefoam", localeDir)
    #_ = gettext.gettext

    #os.environ["TreeFoamPath"] = "/home/caeuser/TreeFoam-glade3"
    #os.environ["TreeFoamUserPath"] = "/home/caeuser/.TreeFoamUser"
    winApp = windowApp()
    winApp.main()
