#!/usr/bin/python3
# coding: utf-8
#
#   separateCellZoneGroupDialog.py
#
#       cellZoneを流体と固体に分ける
#
#   11/04/18    FrameからDialogに置き換え
#      04/21    変数(liquidCellZones, solidCellZones)の初期化追加
#   12/03/18    アイコンの読み込み場所変更
#   13/10/12    多言語化の為、修正
#   15/07/17    dialogの起動方法を修正
#   19/10/24    GTK+3, python3用に大幅修正
#   20/04/22    多言語化対応    
#   24/08/09    GtkPartsに置き換え、funcOk,funcCancel,parentを追加
#      12/13    __init__:親のfreezeを削除
#

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib

import os, sys
import GtkParts

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

#------------------------------
#  separateCellZoneGroup class
#------------------------------
class separateCellZoneGroup:
    """ cellZoneを流体と固体に分ける"""

    def __init__(self, zoneNames, funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "separateCellZoneGroupDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)を設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.zoneNames = zoneNames
        self.fluidSolid = None
        self.fluidNames = []
        self.solidNames = []
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #GUIの初期化
        self.iniGui()

    def setGtkObject(self):
        tree_all = self.builder.get_object("tree_all")
        tree_fluid = self.builder.get_object("tree_fluid")
        tree_solid = self.builder.get_object("tree_solid")
        self.treeAll = GtkParts.treeList(tree_all)
        self.treeFluid = GtkParts.treeList(tree_fluid)
        self.treeSolid = GtkParts.treeList(tree_solid)

    #
    #  show
    #  ----
    def show(self):
        """ dialogを表示する"""
        self.dialog.show()
        # self.dialog.run()
        # return self.fluidSolid

    def close(self, *args):
        """ dialogを閉じる"""
        self.dialog.destroy()

    #----event handler -----------
    #選択>> fluid
    def onSelectFluid(self, event):
        self.selectFluid()
    #<<戻す fluid
    def onReturnFluid(self, event):
        self.returnFluid()
    #選択>> solid
    def onSelectSolid(self, event):
        self.selectSolid()
    #<<戻す solid
    def onReturnSolid(self, event):
        self.returnSolid()
    #OK
    def onOk(self, event):
        self.getFluidSolidNames()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(self.fluidSolid, *args)
            GLib.timeout_add(100, funcName, self.fluidSolid, *args)
    #キャンセル
    def onCancel(self, event):
        #self.fluidSolid = None
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)

    #
    #  iniGui
    def iniGui(self):
        """ GUIの初期化
        treeViewの設定と表示"""
        self.treeAll.create()
        self.treeAll.setItems(self.zoneNames)
        self.treeFluid.create()
        self.treeFluid.setItems([])
        self.treeSolid.create()
        self.treeSolid.setItems([])

    #
    #  deleteNamesFromBox
    def deleteNamesFromBox(self, treeList, delNames):
        """ 指定されたtreeListから項目を削除する"""
        allItems = treeList.getAllItems()
        remNames = list(set(allItems) - set(delNames))
        treeList.setItems(remNames)
    
    #
    #  addNamesToBox
    def addNamesToBox(self, treeList, addNames):
        """ 指定されたtreeListに項目を追加する"""
        allItems = treeList.getAllItems()
        setItems = list(set(allItems + addNames))
        treeList.setItems(setItems)
        treeList.selectItems(addNames)

    #
    #  selectFluid
    #  -----------
    def selectFluid(self):
        """ 全zonesの選択zoneをflud側へ移動する"""
        selNames = self.treeAll.getSelectedItems()
        if len(selNames) > 0:
            self.deleteNamesFromBox(self.treeAll, selNames)
            self.addNamesToBox(self.treeFluid, selNames)

    #
    #  returnFluid
    #  -----------
    def returnFluid(self):
        """ fluid側のzone名を全zone側に戻す"""
        selNames = self.treeFluid.getSelectedItems()
        if len(selNames) > 0:
            self.deleteNamesFromBox(self.treeFluid, selNames)
            self.addNamesToBox(self.treeAll, selNames)

    #
    #  selectSolid
    #  -----------
    def selectSolid(self):
        """ 全zonesの選択zoneをsolid側へ移動する"""
        selNames = self.treeAll.getSelectedItems()
        if len(selNames) > 0:
            self.deleteNamesFromBox(self.treeAll, selNames)
            self.addNamesToBox(self.treeSolid, selNames)

    #
    #  returnSolid
    #  -----------
    def returnSolid(self):
        """ solid側のzone名を全zone側に戻す"""
        selNames = self.treeSolid.getSelectedItems()
        if len(selNames) > 0:
            self.deleteNamesFromBox(self.treeSolid, selNames)
            self.addNamesToBox(self.treeAll, selNames)

    #
    #  getFluidSolidNames
    #  ------------------
    def getFluidSolidNames(self):
        """ fluid, solidの内容を取得する"""
        #fluid側を取得
        fluidNames = self.treeFluid.getAllItems()
        #solid側を取得
        solidNames = self.treeSolid.getAllItems()
        self.fluidNames = fluidNames
        self.solidNames = solidNames
        self.fluidSolid = [fluidNames, solidNames]
