#!/usr/bin/python3
# -*- coding: utf-8 -*-
#
#   openFieldsForGridEditorDDialog.py
#
#     gridEditor用のfield非表示、表示（再読込）の為のdialog
#     fieldの表示順も設定できる
#
#   12/04/17    新規作成
#   13/10/12    多言語化のため、修正
#   15/07/17    dialog起動方法を修正
#   20/02/13    GTK+3, python3用に大幅修正
#      04/22    多言語化対応
#      05/02    PyQt4, PyQt5, PySide, PySide2に対応
#      05/24    PyQtの取得方法を修正（一元化）
#   24/08/23    setCenterParentPosition:新規追加
#               (dialogをparentの中心に配置)
#      08/28    Qt4系とQt6系に対応するように修正。
#


import os

import getPyQtModule
PyQtModule = getPyQtModule.PyQtModule

#  import されているPyQtに応じてimportする
if PyQtModule == "PyQt6":
    from PyQt6.QtCore import *
    from PyQt6.QtGui import *
    from PyQt6.QtWidgets import *
elif PyQtModule == "PySide6":
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
elif PyQtModule == "PyQt5":
    from PyQt5.QtCore import *
    from PyQt5.QtGui import *
    from PyQt5.QtWidgets import *
elif PyQtModule == "PySide2":
    from PySide2.QtCore import *
    from PySide2.QtGui import *
    from PySide2.QtWidgets import *
elif PyQtModule == "PyQt4":
    from PyQt4.QtCore import *
    from PyQt4.QtGui import *
elif PyQtModule == "PySide":
    from PySide.QtCore import *
    from PySide.QtGui import *
else:
    print("import error: could not import PyQt or PySide!")
    exit()


import QtVar

import QtParts

def _fromUtf8(s):
    return s

try:
    _encoding = QApplication.UnicodeUTF8
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig, _encoding)
except AttributeError:
    def _translate(context, text, disambig):
        return QApplication.translate(context, text, disambig)


#-------------------
#  Ui_Dialog class
#-------------------
class Ui_Dialog(object):

    def __init__(self, fieldDir, showNames, hideNames, parent):
        self.fieldDir = fieldDir
        self.showNames = showNames
        self.hideNames = hideNames
        self.parent = parent

        iconDir = os.getenv("TreeFoamPath") + "/icons"
        self.iconFile = QIcon()
        self.iconFile.addPixmap(QPixmap(iconDir + "/text8.png"), mode=QtVar.Normal, state=QtVar.Off)
        self.iconLink = QIcon()
        self.iconLink.addPixmap(QPixmap(iconDir + "/textLink8.png"), mode=QtVar.Normal, state=QtVar.Off)

        self.Dialog = QDialog()
        self.setupUi(self.Dialog)
        self.Dialog.setWindowTitle(_("fieldの表示順を設定"))
        self.setEvent()

    def Show(self):
        self.initialize()
        #dialogをparentの中心に表示
        self.setCenterParentPosition()
        self.Dialog.exec()
        return self.showNames

    def close(self):
        self.Dialog.close()

    def setCenterParentPosition(self):
        """ dialogの位置を親の中心に設定する。
        widgetのレイアウト設定後に実行する"""
        if self.parent == None:
            return
        #parentの中心位置
        geo = self.parent.geometry()
        xy = (geo.left() + geo.width()//2, geo.top() + geo.height()//2)
        pos = QPoint(xy[0], xy[1])
        #設定位置を取得
        geo = self.Dialog.geometry()
        geoP = QPoint(geo.width()//2, geo.height()//2)
        newPos = pos - geoP
        self.Dialog.move(newPos)

    def setupUi(self, Dialog):
        """ Qtのversionに応じたGUIを設定"""
        if getPyQtModule.UiCode == "Qt4":
            self.setupUi_Qt4(Dialog)
        elif getPyQtModule.UiCode == "Qt6":
            self.setupUi_Qt6(Dialog)

    def setupUi_Qt6(self, Dialog):
        """ Qt6系のGUIを設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(603, 371)
        self.verticalLayout_5 = QVBoxLayout(Dialog)
        self.verticalLayout_5.setObjectName(_fromUtf8("verticalLayout_5"))
        self.label = QLabel(Dialog)
        ## self.label.setAlignment(Qt.AlignCenter)
        self.label.setAlignment(Qt.AlignmentFlag.AlignCenter)
        self.label.setObjectName(_fromUtf8("label"))
        self.verticalLayout_5.addWidget(self.label)
        ## spacerItem = QSpacerItem(20, 10, QSizePolicy.Minimum, QSizePolicy.Fixed)
        spacerItem = QSpacerItem(20, 10, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Fixed)
        self.verticalLayout_5.addItem(spacerItem)
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        self.verticalLayout = QVBoxLayout()
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        self.label_2 = QLabel(Dialog)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.verticalLayout.addWidget(self.label_2)
        self.list_hide = QListView(Dialog)
        self.list_hide.setObjectName(_fromUtf8("list_hide"))
        self.verticalLayout.addWidget(self.list_hide)
        self.horizontalLayout.addLayout(self.verticalLayout)
        self.verticalLayout_2 = QVBoxLayout()
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        ## spacerItem1 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        spacerItem1 = QSpacerItem(20, 40, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Expanding)
        self.verticalLayout_2.addItem(spacerItem1)
        self.label_3 = QLabel(Dialog)
        ## sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Policy.Preferred, QSizePolicy.Policy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_3.sizePolicy().hasHeightForWidth())
        self.label_3.setSizePolicy(sizePolicy)
        ## self.label_3.setAlignment(Qt.AlignHCenter|Qt.AlignTop)
        self.label_3.setAlignment(Qt.AlignmentFlag.AlignHCenter|Qt.AlignmentFlag.AlignTop)
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.verticalLayout_2.addWidget(self.label_3)
        self.btn_show = QPushButton(Dialog)
        self.btn_show.setObjectName(_fromUtf8("btn_show"))
        self.verticalLayout_2.addWidget(self.btn_show)
        self.btn_hide = QPushButton(Dialog)
        self.btn_hide.setObjectName(_fromUtf8("btn_hide"))
        self.verticalLayout_2.addWidget(self.btn_hide)
        ## spacerItem2 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        spacerItem2 = QSpacerItem(20, 40, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Expanding)
        self.verticalLayout_2.addItem(spacerItem2)
        self.horizontalLayout.addLayout(self.verticalLayout_2)
        self.verticalLayout_3 = QVBoxLayout()
        self.verticalLayout_3.setObjectName(_fromUtf8("verticalLayout_3"))
        self.label_4 = QLabel(Dialog)
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.verticalLayout_3.addWidget(self.label_4)
        self.list_show = QListView(Dialog)
        self.list_show.setObjectName(_fromUtf8("list_show"))
        self.verticalLayout_3.addWidget(self.list_show)
        self.horizontalLayout.addLayout(self.verticalLayout_3)
        self.verticalLayout_4 = QVBoxLayout()
        self.verticalLayout_4.setObjectName(_fromUtf8("verticalLayout_4"))
        ## spacerItem3 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        spacerItem3 = QSpacerItem(20, 40, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Expanding)
        self.verticalLayout_4.addItem(spacerItem3)
        self.label_5 = QLabel(Dialog)
        ## self.label_5.setAlignment(Qt.AlignHCenter|Qt.AlignTop)
        self.label_5.setAlignment(Qt.AlignmentFlag.AlignHCenter|Qt.AlignmentFlag.AlignTop)
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.verticalLayout_4.addWidget(self.label_5)
        self.btn_fore = QPushButton(Dialog)
        self.btn_fore.setObjectName(_fromUtf8("btn_fore"))
        self.verticalLayout_4.addWidget(self.btn_fore)
        self.btn_back = QPushButton(Dialog)
        self.btn_back.setObjectName(_fromUtf8("btn_back"))
        self.verticalLayout_4.addWidget(self.btn_back)
        ## spacerItem4 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        spacerItem4 = QSpacerItem(20, 40, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Expanding)
        self.verticalLayout_4.addItem(spacerItem4)
        self.horizontalLayout.addLayout(self.verticalLayout_4)
        self.verticalLayout_5.addLayout(self.horizontalLayout)
        ## spacerItem5 = QSpacerItem(20, 20, QSizePolicy.Minimum, QSizePolicy.Fixed)
        spacerItem5 = QSpacerItem(20, 20, QSizePolicy.Policy.Minimum, QSizePolicy.Policy.Fixed)
        self.verticalLayout_5.addItem(spacerItem5)
        self.buttonBox = QDialogButtonBox(Dialog)
        ## self.buttonBox.setOrientation(Qt.Horizontal)
        self.buttonBox.setOrientation(Qt.Orientation.Horizontal)
        ## self.buttonBox.setStandardButtons(QDialogButtonBox.Cancel|QDialogButtonBox.Ok)
        self.buttonBox.setStandardButtons(QDialogButtonBox.StandardButton.Cancel|QDialogButtonBox.StandardButton.Ok)
        self.buttonBox.setObjectName(_fromUtf8("buttonBox"))
        self.verticalLayout_5.addWidget(self.buttonBox)

        self.retranslateUi(Dialog)
        self.buttonBox.accepted.connect(self.onOk)
        self.buttonBox.rejected.connect(self.onCancel)
        QMetaObject.connectSlotsByName(Dialog)

    def setupUi_Qt4(self, Dialog):
        """ Qt4系のGUI設定"""
        Dialog.setObjectName(_fromUtf8("Dialog"))
        Dialog.resize(603, 371)
        ## self.verticalLayout_5 = QtGui.QVBoxLayout(Dialog)
        self.verticalLayout_5 = QVBoxLayout(Dialog)
        self.verticalLayout_5.setObjectName(_fromUtf8("verticalLayout_5"))
        ## self.label = QtGui.QLabel(Dialog)
        self.label = QLabel(Dialog)
        self.label.setAlignment(Qt.AlignCenter)
        self.label.setObjectName(_fromUtf8("label"))
        self.verticalLayout_5.addWidget(self.label)
        ## spacerItem = QtGui.QSpacerItem(20, 10, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Fixed)
        spacerItem = QSpacerItem(20, 10, QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.verticalLayout_5.addItem(spacerItem)
        ## self.horizontalLayout = QtGui.QHBoxLayout()
        self.horizontalLayout = QHBoxLayout()
        self.horizontalLayout.setObjectName(_fromUtf8("horizontalLayout"))
        ## self.verticalLayout = QtGui.QVBoxLayout()
        self.verticalLayout = QVBoxLayout()
        self.verticalLayout.setObjectName(_fromUtf8("verticalLayout"))
        ## self.label_2 = QtGui.QLabel(Dialog)
        self.label_2 = QLabel(Dialog)
        self.label_2.setObjectName(_fromUtf8("label_2"))
        self.verticalLayout.addWidget(self.label_2)
        ## self.list_hide = QtGui.QListView(Dialog)
        self.list_hide = QListView(Dialog)
        self.list_hide.setObjectName(_fromUtf8("list_hide"))
        self.verticalLayout.addWidget(self.list_hide)
        self.horizontalLayout.addLayout(self.verticalLayout)
        ## self.verticalLayout_2 = QtGui.QVBoxLayout()
        self.verticalLayout_2 = QVBoxLayout()
        self.verticalLayout_2.setObjectName(_fromUtf8("verticalLayout_2"))
        ## spacerItem1 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        spacerItem1 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem1)
        ## self.label_3 = QtGui.QLabel(Dialog)
        self.label_3 = QLabel(Dialog)
        ## sizePolicy = QtGui.QSizePolicy(QtGui.QSizePolicy.Preferred, QtGui.QSizePolicy.Preferred)
        sizePolicy = QSizePolicy(QSizePolicy.Preferred, QSizePolicy.Preferred)
        sizePolicy.setHorizontalStretch(0)
        sizePolicy.setVerticalStretch(0)
        sizePolicy.setHeightForWidth(self.label_3.sizePolicy().hasHeightForWidth())
        self.label_3.setSizePolicy(sizePolicy)
        self.label_3.setAlignment(Qt.AlignHCenter|Qt.AlignTop)
        self.label_3.setObjectName(_fromUtf8("label_3"))
        self.verticalLayout_2.addWidget(self.label_3)
        ## self.btn_show = QtGui.QPushButton(Dialog)
        self.btn_show = QPushButton(Dialog)
        self.btn_show.setObjectName(_fromUtf8("btn_show"))
        self.verticalLayout_2.addWidget(self.btn_show)
        ## self.btn_hide = QtGui.QPushButton(Dialog)
        self.btn_hide = QPushButton(Dialog)
        self.btn_hide.setObjectName(_fromUtf8("btn_hide"))
        self.verticalLayout_2.addWidget(self.btn_hide)
        ## spacerItem2 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        spacerItem2 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        self.verticalLayout_2.addItem(spacerItem2)
        self.horizontalLayout.addLayout(self.verticalLayout_2)
        ## self.verticalLayout_3 = QtGui.QVBoxLayout()
        self.verticalLayout_3 = QVBoxLayout()
        self.verticalLayout_3.setObjectName(_fromUtf8("verticalLayout_3"))
        ## self.label_4 = QtGui.QLabel(Dialog)
        self.label_4 = QLabel(Dialog)
        self.label_4.setObjectName(_fromUtf8("label_4"))
        self.verticalLayout_3.addWidget(self.label_4)
        ## self.list_show = QtGui.QListView(Dialog)
        self.list_show = QListView(Dialog)
        self.list_show.setObjectName(_fromUtf8("list_show"))
        self.verticalLayout_3.addWidget(self.list_show)
        self.horizontalLayout.addLayout(self.verticalLayout_3)
        ## self.verticalLayout_4 = QtGui.QVBoxLayout()
        self.verticalLayout_4 = QVBoxLayout()
        self.verticalLayout_4.setObjectName(_fromUtf8("verticalLayout_4"))
        ## spacerItem3 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        spacerItem3 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        self.verticalLayout_4.addItem(spacerItem3)
        ## self.label_5 = QtGui.QLabel(Dialog)
        self.label_5 = QLabel(Dialog)
        self.label_5.setAlignment(Qt.AlignHCenter|Qt.AlignTop)
        self.label_5.setObjectName(_fromUtf8("label_5"))
        self.verticalLayout_4.addWidget(self.label_5)
        ## self.btn_fore = QtGui.QPushButton(Dialog)
        self.btn_fore = QPushButton(Dialog)
        self.btn_fore.setObjectName(_fromUtf8("btn_fore"))
        self.verticalLayout_4.addWidget(self.btn_fore)
        ## self.btn_back = QtGui.QPushButton(Dialog)
        self.btn_back = QPushButton(Dialog)
        self.btn_back.setObjectName(_fromUtf8("btn_back"))
        self.verticalLayout_4.addWidget(self.btn_back)
        ## spacerItem4 = QtGui.QSpacerItem(20, 40, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Expanding)
        spacerItem4 = QSpacerItem(20, 40, QSizePolicy.Minimum, QSizePolicy.Expanding)
        self.verticalLayout_4.addItem(spacerItem4)
        self.horizontalLayout.addLayout(self.verticalLayout_4)
        self.verticalLayout_5.addLayout(self.horizontalLayout)
        ## spacerItem5 = QtGui.QSpacerItem(20, 20, QtGui.QSizePolicy.Minimum, QtGui.QSizePolicy.Fixed)
        spacerItem5 = QSpacerItem(20, 20, QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.verticalLayout_5.addItem(spacerItem5)
        ## self.buttonBox = QtGui.QDialogButtonBox(Dialog)
        self.buttonBox = QDialogButtonBox(Dialog)
        self.buttonBox.setOrientation(Qt.Horizontal)
        ## self.buttonBox.setStandardButtons(QtGui.QDialogButtonBox.Cancel|QtGui.QDialogButtonBox.Ok)
        self.buttonBox.setStandardButtons(QDialogButtonBox.Cancel|QDialogButtonBox.Ok)
        self.buttonBox.setObjectName(_fromUtf8("buttonBox"))
        self.verticalLayout_5.addWidget(self.buttonBox)

        self.retranslateUi(Dialog)
        self.buttonBox.accepted.connect(self.onOk)
        self.buttonBox.rejected.connect(self.onCancel)
        QMetaObject.connectSlotsByName(Dialog)

    def retranslateUi(self, Dialog):
        Dialog.setWindowTitle(_translate("Dialog", "Dialog", None))
        self.label.setText(_translate("Dialog", "<html><head/><body><p>" + _("非表示、表示fieldの設定と、Fieldの表示順を設定します") + "</p><p>" + _("Fieldを選択してボタンをクリックして設定する") + "</p></body></html>", None))
        self.label_2.setText(_translate("Dialog", _("隠すField"), None))
        self.label_3.setText(_translate("Dialog", _("表示設定"), None))
        self.btn_show.setText(_translate("Dialog", _("表示>>"), None))
        self.btn_hide.setText(_translate("Dialog", _("<<隠す"), None))
        self.label_4.setText(_translate("Dialog", _("表示するField"), None))
        self.label_5.setText(_translate("Dialog", _("表示順"), None))
        self.btn_fore.setText(_translate("Dialog", _("↑先"), None))
        self.btn_back.setText(_translate("Dialog", _("↓後"), None))

    def setEvent(self):
        self.btn_show.clicked.connect(self.onMoveToShow)
        self.btn_hide.clicked.connect(self.onMoveToHide)
        self.btn_fore.clicked.connect(self.onMoveToUp)
        self.btn_back.clicked.connect(self.onMoveToDown)

    def onOk(self):
        self.close()
    def onCancel(self):
        self.showNames = []
        self.close() 
    def onMoveToShow(self):
        self.moveToShow()
    def onMoveToHide(self):
        self.moveToHide()
    def onMoveToUp(self):
        self.moveToUp()
    def onMoveToDown(self):
        self.moveToDown()

    #
    #  moveToHide
    #-------------
    def moveToHide(self):
        """ 選択項目をhide側に移動する"""
        selNames = self.getSelectedNames(self.list_show)
        self.hideNames += selNames
        self.hideNames.sort()
        newNames = []
        for name in self.showNames:
            if not name in selNames:
                newNames.append(name)
        self.showNames = newNames
        #show側
        items = list(map(lambda x: [self.iconDict[x], x], self.showNames))
        self.setNamesToListView(self.list_show, items)
        #hide側
        items = list(map(lambda x: [self.iconDict[x], x], self.hideNames))
        self.setNamesToListView(self.list_hide, items)
        #  selNamesを選択表示させる
        self.selectNames(self.list_hide, selNames)

    #
    #  moveToShow
    #-------------
    def moveToShow(self):
        """ 選択項目をshow側に移動する"""
        selNames = self.getSelectedNames(self.list_hide)
        self.showNames += selNames
        self.hideNames = list(set(self.hideNames).difference(selNames))
        self.hideNames.sort()
        #hide側
        items = list(map(lambda x: [self.iconDict[x], x], self.hideNames))
        self.setNamesToListView(self.list_hide, items)
        #show側
        items = list(map(lambda x: [self.iconDict[x], x], self.showNames))
        self.setNamesToListView(self.list_show, items)
        #  selNamesを選択表示させる
        self.selectNames(self.list_show, selNames)

    #
    #  moveToUp
    #-----------
    def moveToUp(self):
        """ 選択項目をup側に移動する。"""
        selNos = self.getSelectedIndexes(self.list_show)
        selNames = list(map(lambda x: self.showNames[x], selNos))
        for n in selNos:
            if n > 0:
                name = self.showNames[n-1]
                if name in selNames:
                    pass
                else:
                    self.showNames[n-1] = self.showNames[n]
                    self.showNames[n] = name
        items = list(map(lambda x: [self.iconDict[x], x], self.showNames))
        self.setNamesToListView(self.list_show, items)
        self.selectNames(self.list_show, selNames)

    #
    #  moveToDown
    #-------------
    def moveToDown(self):
        """ 選択項目をup側に移動する。"""
        selNos = self.getSelectedIndexes(self.list_show)
        selNames = list(map(lambda x: self.showNames[x], selNos))
        for n in selNos:
            if n < len(self.showNames)-1:
                name = self.showNames[n+1]
                if name in selNames:
                    pass
                else:
                    #入れ替え
                    self.showNames[n+1] = self.showNames[n]
                    self.showNames[n] = name
        items = list(map(lambda x: [self.iconDict[x], x], self.showNames))
        self.setNamesToListView(self.list_show, items)
        self.selectNames(self.list_show, selNames)

    #
    #  initialize
    #--------------
    def initialize(self):
        """ 初期化。"""
        self.iconDict = {}
        #show側のitemを取得、表示
        showItems = []
        for field in self.showNames:
            icon = self.iconFile
            if os.path.islink(self.fieldDir + "/" + field) == True:
                icon = self.iconLink
            showItems.append([icon, field])
            self.iconDict[field] = icon
        self.setNamesToListView(self.list_show, showItems)
        #hide側のitemを取得、表示
        hideItems = []
        for field in self.hideNames:
            icon = self.iconFile
            if os.path.islink(self.fieldDir + "/" + field) == True:
                icon = self.iconLink
            hideItems.append([icon, field])
            self.iconDict[field] = icon
        self.setNamesToListView(self.list_hide, hideItems)

    #------ listViewの操作関連
    def setNamesToListView(self, listView, items, multi=True):
        """ listViewにitemを設定する"""
        QtParts.listView(listView).setItems(items, multi)

    def getSelectedNames(self, listView):
        names = QtParts.listView(listView).getSelectedNames()
        return names

    def getSelectedIndexes(self, listView):
        rows = QtParts.listView(listView).getSelectedIndexes()
        return rows

    def selectNames(self, listView, selNames):
        QtParts.listView(listView).selectNames(selNames)



if __name__ == "__main__":
    import sys
    app = QApplication(sys.argv)
    Dialog = QDialog()
    #ui = Ui_Dialog()
    #ui.setupUi(Dialog)
    Dialog.show()
    sys.exit(app.exec_())

