#!/user/bin/python3
# coding: utf-8
#
#       mountServerDDialog.py
#
#       sshfsコマンドでマウントするサーバを選択する。
#
#   17/06/20    新規作成
#      06/30    textBoxを追加
#   19/10/31    GTK+3, python3用に大幅修正
#   20/04/22    多言語化対応
#   24/08/09    GtkPartsを使用、funcOk,funcCancel, parentを設定
#      12/13    __init__:親のfreezeを削除
# 

import gi
gi.require_version("Gtk", "3.0")
from gi.repository import Gtk, GLib
import os, sys

try:
    import pyTreeFoam
    import GtkParts
except:
    import python.pyTreeFoam as pyTreeFoam
    import python.GtkParts as GtkParts

import locale
localeDir = os.getenv("TreeFoamPath") + "/data/locale"
locale.bindtextdomain("treefoam", localeDir)

import logFileCreater
logFileCreater.log()
 

#-------------------
#  mountServer class
#-------------------
class mountServer:
    """ sshfsコマンドでマウントするサーバを選択する。
    
    Attribute:
        serverNames (list(str)) :マウントできるserver名
    Returns:
        serverName (str)        :選択したserver名 or 「""」"""
    def __init__(self, serverNames, funcOk=[], funcCancel=[], parent=None):
        self.builder = Gtk.Builder()
        self.builder.set_translation_domain("treefoam")
        path = os.getenv("TreeFoamPath") + os.sep + "glade" + os.sep
        self.builder.add_from_file(path + "mountServerDDialog.glade")
        self.dialog = self.builder.get_object("dialog1")
        #親windowを設定
        self.dialog.set_transient_for(parent)
        #modal(freeze)の設定
        #self.dialog.set_modal(True)
        self.dialog.connect("delete-event", self.close)
        self.builder.connect_signals(self)
        self.setGtkObject()
        #変数の設定
        self.serverNames = serverNames
        self.selServer = serverNames[0]
        self.funcOk = funcOk
        self.funcCancel = funcCancel
        #serverのデータを取得
        server = pyTreeFoam.server(self.selServer)
        self.sshfsDict = server.sshfsDict
        self.sshDict = server.sshDict
        #comboにデータセット
        self.setDataToCombo()
        #entryにデータセット
        self.setDataToEntry()
        #textViewにデータセット
        self.setDataToTextView()

    def setGtkObject(self):
        """ GUIのobject名を取得する"""
        combo_server = self.builder.get_object("combo_server")
        self.cmb_server = GtkParts.comboBoxText(combo_server)
        self.entry_hostName = self.builder.get_object("entry_hostName")
        self.entry_hostDir = self.builder.get_object("entry_hostDir")
        #self.textView_setEnv = self.builder.get_object("textView_setEnviron")
        textView_setEnv = self.builder.get_object("textView_setEnviron")
        self.txt_setEnv = GtkParts.textView(textView_setEnv)

    #
    #  show
    #  ----
    def show(self):
        """ dialogの表示"""
        self.dialog.show()
        # self.dialog.run()
        # if self.stat != "OK":
        #     return ""
        # else:
        #     return self.selServer

    #
    #  close
    def close(self, *args):
        self.dialog.destroy()

    
    #-------- event handler -----------
    def onChangeServer(self, event):
        self.changeServer()
    def onOk(self, event):
        self.setServerContData()
        self.close()
        if len(self.funcOk) > 0:
            funcName = self.funcOk[0]
            args = self.funcOk[1:]
            #funcName(self.selServer, *args)
            GLib.timeout_add(100, funcName, self.selServer, *args)
    def onCancel(self, event):
        self.close()
        if len(self.funcCancel) > 0:
            funcName = self.funcCancel[0]
            args = self.funcCancel[1:]
            #funcName(*args)
            GLib.timeout_add(100, funcName, *args)

    #-----------------------------------

    #
    #  setDataToCombo
    #  --------------
    def setDataToCombo(self):
        self.cmb_server.setItems(self.serverNames)
        self.cmb_server.selectItem(self.serverNames[0])

    #
    #  setDataToEntry
    #  --------------
    def setDataToEntry(self):
        hostName = self.sshfsDict["hostName"]
        self.entry_hostName.set_text(hostName)
        hostDir = self.sshfsDict["hostDir"]
        self.entry_hostDir.set_text(hostDir)

    #
    #  setDataToTextView
    #  -----------------
    def setDataToTextView(self):
        setEnv = self.sshfsDict["setEnviron"]
        self.txt_setEnv.setText(setEnv)

    #
    #  changeServer
    #  ------------
    def changeServer(self):
        self.selServer = self.cmb_server.getSelectedItem()
        server = pyTreeFoam.server(self.selServer)
        self.sshfsDict = server.sshfsDict
        self.sshdict = server.sshDict
        self.setDataToEntry()
        self.setDataToTextView()

    #
    #  setServerContData
    #  -----------------
    def setServerContData(self):
        self.selServer = self.cmb_server.getSelectedItem()
        hostName = self.entry_hostName.get_text()
        hostDir = self.entry_hostDir.get_text()
        setEnv = self.txt_setEnv.getText()
        self.sshfsDict["hostName"] = hostName
        self.sshfsDict["hostDir"] = hostDir
        self.sshfsDict["setEnviron"] = setEnv
        server = pyTreeFoam.server(self.selServer)
        server.sshfsDict = self.sshfsDict
        server.writeSshfsData()
